/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Component } from "@angular/core";
import { ListViewStore, } from "../../store/list-view/list-view.store";
import { AppStateStore } from "../../../../store/app-state/app-state.store";
import { QuickFiltersService } from "../../services/quick-filters.service";
import { ListViewSidebarWidgetService } from "../../services/list-view-sidebar-widget.service";
import { RecordPaginationService } from "../../../record/store/record-pagination/record-pagination.service";
import * as i0 from "@angular/core";
import * as i1 from "../../../../store/app-state/app-state.store";
import * as i2 from "../../store/list-view/list-view.store";
import * as i3 from "../../services/quick-filters.service";
import * as i4 from "../../services/list-view-sidebar-widget.service";
import * as i5 from "../../../record/store/record-pagination/record-pagination.service";
import * as i6 from "@angular/common";
import * as i7 from "../list-header/list-header.component";
import * as i8 from "../list-container/list-container.component";
function ListComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1);
    i0.ɵɵelement(1, "scrm-list-header")(2, "scrm-list-container");
    i0.ɵɵelementEnd();
} }
class ListComponent {
    constructor(appState, listStore, quickFilters, sidebarWidgetHandler, recordPaginationService) {
        this.appState = appState;
        this.listStore = listStore;
        this.quickFilters = quickFilters;
        this.sidebarWidgetHandler = sidebarWidgetHandler;
        this.recordPaginationService = recordPaginationService;
        this.vm$ = null;
        this.TAG_COLORS_LIST = {
            vip: "#2ecc71",
            "bonus hunter": "#e74c3c",
            "short listed": "#3498db",
            registered: "#27ae60",
            hot: "#c0392b",
            remove: "#e67e22",
            "30% retention bonus": "#f1c40f",
            "50% retention bonus": "#f39c12",
            "30% 50% retention bonus": "#f1948a",
            outsource: "#9b59b6",
            "50k batch 1": "#8e44ad",
        };
    }
    ngOnInit() {
        console.log("List component init");
        this.appState.removeAllPrevRoutes();
        this.module = this.appState.getModule();
        this.listSub = this.listStore.init(this.module).subscribe();
        this.vm$ = this.listStore.vm$;
    }
    ngAfterViewInit() {
        console.log("list.component.ts ngAfterViewInit");
        setTimeout(() => {
            this.injectListTagColors();
            this.injectCallStatusDotList();
        }, 500);
    }
    ngOnDestroy() {
        if (this.listSub) {
            this.listSub.unsubscribe();
        }
        this.updateListLocalStorage();
        this.quickFilters.destroy();
        this.sidebarWidgetHandler.destroy();
        this.listStore.destroy();
    }
    updateListLocalStorage() {
        this.recordPaginationService.updateRecordListLocalStorage(this.listStore.recordList.records, this.listStore.recordList.pagination);
    }
    injectCallStatusDotList() {
        const interval = setInterval(() => {
            const callStatusEls = document.querySelectorAll(".field-name-call_status_c scrm-dropdownenum-detail");
            if (callStatusEls.length > 0) {
                clearInterval(interval);
                const statusDot = {
                    willdeposit: "🟢",
                    interested: "🟢",
                    callterminated: "🔴",
                    depositdone: "🟢",
                    calllater: "🟡",
                    switchoff: "🔴",
                    notpicked1: "🟡",
                    notpicked2: "🟡",
                    notpicked3: "🟡",
                    invalidnumber: "🔴",
                    haventcall: "🟡",
                    notinterestbonus: "🔴",
                    notinterestweb: "🔴",
                    registered: "🟢",
                };
                callStatusEls.forEach((el) => {
                    const text = el.textContent?.trim() || "";
                    const cleanVal = text.toLowerCase().replace(/\s+/g, "");
                    const symbol = statusDot[cleanVal];
                    if (symbol && !text.startsWith(symbol)) {
                        el.textContent = `${symbol} ${text}`;
                    }
                });
            }
        }, 300);
    }
    injectListTagColors() {
        const interval = setInterval(() => {
            const tagLists = document.querySelectorAll(".field-name-tag_c scrm-multienum-detail li");
            if (tagLists.length > 0) {
                clearInterval(interval);
                tagLists.forEach((el) => {
                    const label = el.textContent?.trim().toLowerCase();
                    this.applyFlatTagStyleList(el, label);
                });
            }
        }, 300);
    }
    applyFlatTagStyleList(el, label) {
        const color = this.TAG_COLORS_LIST[label.toLowerCase()];
        if (!color)
            return;
        el.style.backgroundColor = color;
        el.style.color = "white";
        el.style.fontSize = "12px";
        el.style.fontWeight = "bold";
        el.style.padding = "2px 8px";
        el.style.borderRadius = "12px";
        el.style.display = "inline-block";
        el.style.margin = "2px";
    }
    static { this.ɵfac = function ListComponent_Factory(t) { return new (t || ListComponent)(i0.ɵɵdirectiveInject(i1.AppStateStore), i0.ɵɵdirectiveInject(i2.ListViewStore), i0.ɵɵdirectiveInject(i3.QuickFiltersService), i0.ɵɵdirectiveInject(i4.ListViewSidebarWidgetService), i0.ɵɵdirectiveInject(i5.RecordPaginationService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ListComponent, selectors: [["scrm-list"]], features: [i0.ɵɵProvidersFeature([ListViewStore, QuickFiltersService, ListViewSidebarWidgetService])], decls: 2, vars: 3, consts: [["class", "list-view", 4, "ngIf"], [1, "list-view"]], template: function ListComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, ListComponent_div_0_Template, 3, 0, "div", 0);
            i0.ɵɵpipe(1, "async");
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", i0.ɵɵpipeBind1(1, 1, ctx.vm$));
        } }, dependencies: [i6.NgIf, i7.ListHeaderComponent, i8.ListContainerComponent, i6.AsyncPipe], encapsulation: 2 }); }
}
export { ListComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ListComponent, [{
        type: Component,
        args: [{ selector: "scrm-list", providers: [ListViewStore, QuickFiltersService, ListViewSidebarWidgetService], template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<!-- Start List View Section -->\n<div class=\"list-view\" *ngIf=\"(vm$ | async) as vm\">\n    <scrm-list-header></scrm-list-header>\n    <scrm-list-container></scrm-list-container>\n</div>\n<!-- End List View Section -->\n" }]
    }], function () { return [{ type: i1.AppStateStore }, { type: i2.ListViewStore }, { type: i3.QuickFiltersService }, { type: i4.ListViewSidebarWidgetService }, { type: i5.RecordPaginationService }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGlzdC5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi9jb3JlL2FwcC9jb3JlL3NyYy9saWIvdmlld3MvbGlzdC9jb21wb25lbnRzL2xpc3Qtdmlldy9saXN0LmNvbXBvbmVudC50cyIsIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL2NvcmUvYXBwL2NvcmUvc3JjL2xpYi92aWV3cy9saXN0L2NvbXBvbmVudHMvbGlzdC12aWV3L2xpc3QuY29tcG9uZW50Lmh0bWwiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztHQXdCRztBQUVILE9BQU8sRUFBRSxTQUFTLEVBQXFDLE1BQU0sZUFBZSxDQUFDO0FBRTdFLE9BQU8sRUFFTCxhQUFhLEdBQ2QsTUFBTSx1Q0FBdUMsQ0FBQztBQUMvQyxPQUFPLEVBQUUsYUFBYSxFQUFFLE1BQU0sNkNBQTZDLENBQUM7QUFDNUUsT0FBTyxFQUFFLG1CQUFtQixFQUFFLE1BQU0sc0NBQXNDLENBQUM7QUFDM0UsT0FBTyxFQUFFLDRCQUE0QixFQUFFLE1BQU0saURBQWlELENBQUM7QUFDL0YsT0FBTyxFQUFFLHVCQUF1QixFQUFFLE1BQU0sbUVBQW1FLENBQUM7Ozs7Ozs7Ozs7O0lDUDVHLDhCQUFtRDtJQUMvQyxtQ0FBcUMsMEJBQUE7SUFFekMsaUJBQU07O0FETU4sTUFNYSxhQUFhO0lBTXhCLFlBQ1ksUUFBdUIsRUFDdkIsU0FBd0IsRUFDeEIsWUFBaUMsRUFDakMsb0JBQWtELEVBQ2xELHVCQUFnRDtRQUpoRCxhQUFRLEdBQVIsUUFBUSxDQUFlO1FBQ3ZCLGNBQVMsR0FBVCxTQUFTLENBQWU7UUFDeEIsaUJBQVksR0FBWixZQUFZLENBQXFCO1FBQ2pDLHlCQUFvQixHQUFwQixvQkFBb0IsQ0FBOEI7UUFDbEQsNEJBQXVCLEdBQXZCLHVCQUF1QixDQUF5QjtRQVA1RCxRQUFHLEdBQThCLElBQUksQ0FBQztRQW1HckIsb0JBQWUsR0FBOEI7WUFDNUQsR0FBRyxFQUFFLFNBQVM7WUFDZCxjQUFjLEVBQUUsU0FBUztZQUN6QixjQUFjLEVBQUUsU0FBUztZQUN6QixVQUFVLEVBQUUsU0FBUztZQUNyQixHQUFHLEVBQUUsU0FBUztZQUNkLE1BQU0sRUFBRSxTQUFTO1lBQ2pCLHFCQUFxQixFQUFFLFNBQVM7WUFDaEMscUJBQXFCLEVBQUUsU0FBUztZQUNoQyx5QkFBeUIsRUFBRSxTQUFTO1lBQ3BDLFNBQVMsRUFBRSxTQUFTO1lBQ3BCLGFBQWEsRUFBRSxTQUFTO1NBQ3pCLENBQUM7SUF2R0MsQ0FBQztJQUVKLFFBQVE7UUFDTixPQUFPLENBQUMsR0FBRyxDQUFDLHFCQUFxQixDQUFDLENBQUM7UUFFbkMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxtQkFBbUIsRUFBRSxDQUFDO1FBQ3BDLElBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxTQUFTLEVBQUUsQ0FBQztRQUN4QyxJQUFJLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxTQUFTLEVBQUUsQ0FBQztRQUM1RCxJQUFJLENBQUMsR0FBRyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDO0lBQ2hDLENBQUM7SUFDRCxlQUFlO1FBQ2IsT0FBTyxDQUFDLEdBQUcsQ0FBQyxtQ0FBbUMsQ0FBQyxDQUFDO1FBRWpELFVBQVUsQ0FBQyxHQUFHLEVBQUU7WUFDZCxJQUFJLENBQUMsbUJBQW1CLEVBQUUsQ0FBQztZQUMzQixJQUFJLENBQUMsdUJBQXVCLEVBQUUsQ0FBQztRQUNqQyxDQUFDLEVBQUUsR0FBRyxDQUFDLENBQUM7SUFDVixDQUFDO0lBRUQsV0FBVztRQUNULElBQUksSUFBSSxDQUFDLE9BQU8sRUFBRTtZQUNoQixJQUFJLENBQUMsT0FBTyxDQUFDLFdBQVcsRUFBRSxDQUFDO1NBQzVCO1FBRUQsSUFBSSxDQUFDLHNCQUFzQixFQUFFLENBQUM7UUFFOUIsSUFBSSxDQUFDLFlBQVksQ0FBQyxPQUFPLEVBQUUsQ0FBQztRQUM1QixJQUFJLENBQUMsb0JBQW9CLENBQUMsT0FBTyxFQUFFLENBQUM7UUFFcEMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxPQUFPLEVBQUUsQ0FBQztJQUMzQixDQUFDO0lBRU0sc0JBQXNCO1FBQzNCLElBQUksQ0FBQyx1QkFBdUIsQ0FBQyw0QkFBNEIsQ0FDdkQsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsT0FBTyxFQUNqQyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQ3JDLENBQUM7SUFDSixDQUFDO0lBQ08sdUJBQXVCO1FBQzdCLE1BQU0sUUFBUSxHQUFHLFdBQVcsQ0FBQyxHQUFHLEVBQUU7WUFDaEMsTUFBTSxhQUFhLEdBQUcsUUFBUSxDQUFDLGdCQUFnQixDQUM3QyxvREFBb0QsQ0FDckQsQ0FBQztZQUVGLElBQUksYUFBYSxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUU7Z0JBQzVCLGFBQWEsQ0FBQyxRQUFRLENBQUMsQ0FBQztnQkFFeEIsTUFBTSxTQUFTLEdBQThCO29CQUMzQyxXQUFXLEVBQUUsSUFBSTtvQkFDakIsVUFBVSxFQUFFLElBQUk7b0JBQ2hCLGNBQWMsRUFBRSxJQUFJO29CQUNwQixXQUFXLEVBQUUsSUFBSTtvQkFDakIsU0FBUyxFQUFFLElBQUk7b0JBQ2YsU0FBUyxFQUFFLElBQUk7b0JBQ2YsVUFBVSxFQUFFLElBQUk7b0JBQ2hCLFVBQVUsRUFBRSxJQUFJO29CQUNoQixVQUFVLEVBQUUsSUFBSTtvQkFDaEIsYUFBYSxFQUFFLElBQUk7b0JBQ25CLFVBQVUsRUFBRSxJQUFJO29CQUNoQixnQkFBZ0IsRUFBRSxJQUFJO29CQUN0QixjQUFjLEVBQUUsSUFBSTtvQkFDcEIsVUFBVSxFQUFFLElBQUk7aUJBQ2pCLENBQUM7Z0JBRUYsYUFBYSxDQUFDLE9BQU8sQ0FBQyxDQUFDLEVBQVcsRUFBRSxFQUFFO29CQUNwQyxNQUFNLElBQUksR0FBRyxFQUFFLENBQUMsV0FBVyxFQUFFLElBQUksRUFBRSxJQUFJLEVBQUUsQ0FBQztvQkFDMUMsTUFBTSxRQUFRLEdBQUcsSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDLE9BQU8sQ0FBQyxNQUFNLEVBQUUsRUFBRSxDQUFDLENBQUM7b0JBQ3hELE1BQU0sTUFBTSxHQUFHLFNBQVMsQ0FBQyxRQUFRLENBQUMsQ0FBQztvQkFFbkMsSUFBSSxNQUFNLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxFQUFFO3dCQUN0QyxFQUFFLENBQUMsV0FBVyxHQUFHLEdBQUcsTUFBTSxJQUFJLElBQUksRUFBRSxDQUFDO3FCQUN0QztnQkFDSCxDQUFDLENBQUMsQ0FBQzthQUNKO1FBQ0gsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxDQUFDO0lBQ1YsQ0FBQztJQUNPLG1CQUFtQjtRQUN6QixNQUFNLFFBQVEsR0FBRyxXQUFXLENBQUMsR0FBRyxFQUFFO1lBQ2hDLE1BQU0sUUFBUSxHQUFHLFFBQVEsQ0FBQyxnQkFBZ0IsQ0FDeEMsNENBQTRDLENBQzdDLENBQUM7WUFFRixJQUFJLFFBQVEsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFO2dCQUN2QixhQUFhLENBQUMsUUFBUSxDQUFDLENBQUM7Z0JBQ3hCLFFBQVEsQ0FBQyxPQUFPLENBQUMsQ0FBQyxFQUFFLEVBQUUsRUFBRTtvQkFDdEIsTUFBTSxLQUFLLEdBQUcsRUFBRSxDQUFDLFdBQVcsRUFBRSxJQUFJLEVBQUUsQ0FBQyxXQUFXLEVBQUUsQ0FBQztvQkFDbkQsSUFBSSxDQUFDLHFCQUFxQixDQUFDLEVBQWlCLEVBQUUsS0FBSyxDQUFDLENBQUM7Z0JBQ3ZELENBQUMsQ0FBQyxDQUFDO2FBQ0o7UUFDSCxDQUFDLEVBQUUsR0FBRyxDQUFDLENBQUM7SUFDVixDQUFDO0lBZU8scUJBQXFCLENBQUMsRUFBZSxFQUFFLEtBQWE7UUFDMUQsTUFBTSxLQUFLLEdBQUcsSUFBSSxDQUFDLGVBQWUsQ0FBQyxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUMsQ0FBQztRQUN4RCxJQUFJLENBQUMsS0FBSztZQUFFLE9BQU87UUFDbkIsRUFBRSxDQUFDLEtBQUssQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO1FBQ2pDLEVBQUUsQ0FBQyxLQUFLLENBQUMsS0FBSyxHQUFHLE9BQU8sQ0FBQztRQUN6QixFQUFFLENBQUMsS0FBSyxDQUFDLFFBQVEsR0FBRyxNQUFNLENBQUM7UUFDM0IsRUFBRSxDQUFDLEtBQUssQ0FBQyxVQUFVLEdBQUcsTUFBTSxDQUFDO1FBQzdCLEVBQUUsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztRQUM3QixFQUFFLENBQUMsS0FBSyxDQUFDLFlBQVksR0FBRyxNQUFNLENBQUM7UUFDL0IsRUFBRSxDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsY0FBYyxDQUFDO1FBQ2xDLEVBQUUsQ0FBQyxLQUFLLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQztJQUMxQixDQUFDOzhFQWhJVSxhQUFhO29FQUFiLGFBQWEsK0RBRmIsQ0FBQyxhQUFhLEVBQUUsbUJBQW1CLEVBQUUsNEJBQTRCLENBQUM7WUNiL0UsOERBR007OztZQUhrQixvREFBb0I7OztTRGUvQixhQUFhO3VGQUFiLGFBQWE7Y0FOekIsU0FBUzsyQkFDRSxXQUFXLGFBR1YsQ0FBQyxhQUFhLEVBQUUsbUJBQW1CLEVBQUUsNEJBQTRCLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIFN1aXRlQ1JNIGlzIGEgY3VzdG9tZXIgcmVsYXRpb25zaGlwIG1hbmFnZW1lbnQgcHJvZ3JhbSBkZXZlbG9wZWQgYnkgU2FsZXNBZ2lsaXR5IEx0ZC5cbiAqIENvcHlyaWdodCAoQykgMjAyMSBTYWxlc0FnaWxpdHkgTHRkLlxuICpcbiAqIFRoaXMgcHJvZ3JhbSBpcyBmcmVlIHNvZnR3YXJlOyB5b3UgY2FuIHJlZGlzdHJpYnV0ZSBpdCBhbmQvb3IgbW9kaWZ5IGl0IHVuZGVyXG4gKiB0aGUgdGVybXMgb2YgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZSB2ZXJzaW9uIDMgYXMgcHVibGlzaGVkIGJ5IHRoZVxuICogRnJlZSBTb2Z0d2FyZSBGb3VuZGF0aW9uIHdpdGggdGhlIGFkZGl0aW9uIG9mIHRoZSBmb2xsb3dpbmcgcGVybWlzc2lvbiBhZGRlZFxuICogdG8gU2VjdGlvbiAxNSBhcyBwZXJtaXR0ZWQgaW4gU2VjdGlvbiA3KGEpOiBGT1IgQU5ZIFBBUlQgT0YgVEhFIENPVkVSRUQgV09SS1xuICogSU4gV0hJQ0ggVEhFIENPUFlSSUdIVCBJUyBPV05FRCBCWSBTQUxFU0FHSUxJVFksIFNBTEVTQUdJTElUWSBESVNDTEFJTVMgVEhFXG4gKiBXQVJSQU5UWSBPRiBOT04gSU5GUklOR0VNRU5UIE9GIFRISVJEIFBBUlRZIFJJR0hUUy5cbiAqXG4gKiBUaGlzIHByb2dyYW0gaXMgZGlzdHJpYnV0ZWQgaW4gdGhlIGhvcGUgdGhhdCBpdCB3aWxsIGJlIHVzZWZ1bCwgYnV0IFdJVEhPVVRcbiAqIEFOWSBXQVJSQU5UWTsgd2l0aG91dCBldmVuIHRoZSBpbXBsaWVkIHdhcnJhbnR5IG9mIE1FUkNIQU5UQUJJTElUWSBvciBGSVRORVNTXG4gKiBGT1IgQSBQQVJUSUNVTEFSIFBVUlBPU0UuIFNlZSB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlIGZvciBtb3JlXG4gKiBkZXRhaWxzLlxuICpcbiAqIFlvdSBzaG91bGQgaGF2ZSByZWNlaXZlZCBhIGNvcHkgb2YgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZVxuICogYWxvbmcgd2l0aCB0aGlzIHByb2dyYW0uICBJZiBub3QsIHNlZSA8aHR0cDovL3d3dy5nbnUub3JnL2xpY2Vuc2VzLz4uXG4gKlxuICogSW4gYWNjb3JkYW5jZSB3aXRoIFNlY3Rpb24gNyhiKSBvZiB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlXG4gKiB2ZXJzaW9uIDMsIHRoZXNlIEFwcHJvcHJpYXRlIExlZ2FsIE5vdGljZXMgbXVzdCByZXRhaW4gdGhlIGRpc3BsYXkgb2YgdGhlXG4gKiBcIlN1cGVyY2hhcmdlZCBieSBTdWl0ZUNSTVwiIGxvZ28uIElmIHRoZSBkaXNwbGF5IG9mIHRoZSBsb2dvcyBpcyBub3QgcmVhc29uYWJseVxuICogZmVhc2libGUgZm9yIHRlY2huaWNhbCByZWFzb25zLCB0aGUgQXBwcm9wcmlhdGUgTGVnYWwgTm90aWNlcyBtdXN0IGRpc3BsYXlcbiAqIHRoZSB3b3JkcyBcIlN1cGVyY2hhcmdlZCBieSBTdWl0ZUNSTVwiLlxuICovXG5cbmltcG9ydCB7IENvbXBvbmVudCwgT25EZXN0cm95LCBPbkluaXQsIEFmdGVyVmlld0luaXQgIH0gZnJvbSBcIkBhbmd1bGFyL2NvcmVcIjtcbmltcG9ydCB7IE9ic2VydmFibGUsIFN1YnNjcmlwdGlvbiB9IGZyb20gXCJyeGpzXCI7XG5pbXBvcnQge1xuICBMaXN0Vmlld01vZGVsLFxuICBMaXN0Vmlld1N0b3JlLFxufSBmcm9tIFwiLi4vLi4vc3RvcmUvbGlzdC12aWV3L2xpc3Qtdmlldy5zdG9yZVwiO1xuaW1wb3J0IHsgQXBwU3RhdGVTdG9yZSB9IGZyb20gXCIuLi8uLi8uLi8uLi9zdG9yZS9hcHAtc3RhdGUvYXBwLXN0YXRlLnN0b3JlXCI7XG5pbXBvcnQgeyBRdWlja0ZpbHRlcnNTZXJ2aWNlIH0gZnJvbSBcIi4uLy4uL3NlcnZpY2VzL3F1aWNrLWZpbHRlcnMuc2VydmljZVwiO1xuaW1wb3J0IHsgTGlzdFZpZXdTaWRlYmFyV2lkZ2V0U2VydmljZSB9IGZyb20gXCIuLi8uLi9zZXJ2aWNlcy9saXN0LXZpZXctc2lkZWJhci13aWRnZXQuc2VydmljZVwiO1xuaW1wb3J0IHsgUmVjb3JkUGFnaW5hdGlvblNlcnZpY2UgfSBmcm9tIFwiLi4vLi4vLi4vcmVjb3JkL3N0b3JlL3JlY29yZC1wYWdpbmF0aW9uL3JlY29yZC1wYWdpbmF0aW9uLnNlcnZpY2VcIjtcblxuQENvbXBvbmVudCh7XG4gIHNlbGVjdG9yOiBcInNjcm0tbGlzdFwiLFxuICB0ZW1wbGF0ZVVybDogXCIuL2xpc3QuY29tcG9uZW50Lmh0bWxcIixcbiAgc3R5bGVVcmxzOiBbXSxcbiAgcHJvdmlkZXJzOiBbTGlzdFZpZXdTdG9yZSwgUXVpY2tGaWx0ZXJzU2VydmljZSwgTGlzdFZpZXdTaWRlYmFyV2lkZ2V0U2VydmljZV0sXG59KVxuZXhwb3J0IGNsYXNzIExpc3RDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQsIE9uRGVzdHJveSwgQWZ0ZXJWaWV3SW5pdCB7XG4gIGxpc3RTdWI6IFN1YnNjcmlwdGlvbjtcbiAgbW9kdWxlOiBzdHJpbmc7XG5cbiAgdm0kOiBPYnNlcnZhYmxlPExpc3RWaWV3TW9kZWw+ID0gbnVsbDtcblxuICBjb25zdHJ1Y3RvcihcbiAgICBwcm90ZWN0ZWQgYXBwU3RhdGU6IEFwcFN0YXRlU3RvcmUsXG4gICAgcHJvdGVjdGVkIGxpc3RTdG9yZTogTGlzdFZpZXdTdG9yZSxcbiAgICBwcm90ZWN0ZWQgcXVpY2tGaWx0ZXJzOiBRdWlja0ZpbHRlcnNTZXJ2aWNlLFxuICAgIHByb3RlY3RlZCBzaWRlYmFyV2lkZ2V0SGFuZGxlcjogTGlzdFZpZXdTaWRlYmFyV2lkZ2V0U2VydmljZSxcbiAgICBwcm90ZWN0ZWQgcmVjb3JkUGFnaW5hdGlvblNlcnZpY2U6IFJlY29yZFBhZ2luYXRpb25TZXJ2aWNlXG4gICkge31cblxuICBuZ09uSW5pdCgpOiB2b2lkIHtcbiAgICBjb25zb2xlLmxvZyhcIkxpc3QgY29tcG9uZW50IGluaXRcIik7XG5cbiAgICB0aGlzLmFwcFN0YXRlLnJlbW92ZUFsbFByZXZSb3V0ZXMoKTtcbiAgICB0aGlzLm1vZHVsZSA9IHRoaXMuYXBwU3RhdGUuZ2V0TW9kdWxlKCk7XG4gICAgdGhpcy5saXN0U3ViID0gdGhpcy5saXN0U3RvcmUuaW5pdCh0aGlzLm1vZHVsZSkuc3Vic2NyaWJlKCk7XG4gICAgdGhpcy52bSQgPSB0aGlzLmxpc3RTdG9yZS52bSQ7XG4gIH1cbiAgbmdBZnRlclZpZXdJbml0KCk6IHZvaWQge1xuICAgIGNvbnNvbGUubG9nKFwibGlzdC5jb21wb25lbnQudHMgbmdBZnRlclZpZXdJbml0XCIpO1xuICBcbiAgICBzZXRUaW1lb3V0KCgpID0+IHtcbiAgICAgIHRoaXMuaW5qZWN0TGlzdFRhZ0NvbG9ycygpO1xuICAgICAgdGhpcy5pbmplY3RDYWxsU3RhdHVzRG90TGlzdCgpO1xuICAgIH0sIDUwMCk7XG4gIH1cbiAgXG4gIG5nT25EZXN0cm95KCk6IHZvaWQge1xuICAgIGlmICh0aGlzLmxpc3RTdWIpIHtcbiAgICAgIHRoaXMubGlzdFN1Yi51bnN1YnNjcmliZSgpO1xuICAgIH1cblxuICAgIHRoaXMudXBkYXRlTGlzdExvY2FsU3RvcmFnZSgpO1xuXG4gICAgdGhpcy5xdWlja0ZpbHRlcnMuZGVzdHJveSgpO1xuICAgIHRoaXMuc2lkZWJhcldpZGdldEhhbmRsZXIuZGVzdHJveSgpO1xuXG4gICAgdGhpcy5saXN0U3RvcmUuZGVzdHJveSgpO1xuICB9XG5cbiAgcHVibGljIHVwZGF0ZUxpc3RMb2NhbFN0b3JhZ2UoKTogdm9pZCB7XG4gICAgdGhpcy5yZWNvcmRQYWdpbmF0aW9uU2VydmljZS51cGRhdGVSZWNvcmRMaXN0TG9jYWxTdG9yYWdlKFxuICAgICAgdGhpcy5saXN0U3RvcmUucmVjb3JkTGlzdC5yZWNvcmRzLFxuICAgICAgdGhpcy5saXN0U3RvcmUucmVjb3JkTGlzdC5wYWdpbmF0aW9uXG4gICAgKTtcbiAgfVxuICBwcml2YXRlIGluamVjdENhbGxTdGF0dXNEb3RMaXN0KCk6IHZvaWQge1xuICAgIGNvbnN0IGludGVydmFsID0gc2V0SW50ZXJ2YWwoKCkgPT4ge1xuICAgICAgY29uc3QgY2FsbFN0YXR1c0VscyA9IGRvY3VtZW50LnF1ZXJ5U2VsZWN0b3JBbGwoXG4gICAgICAgIFwiLmZpZWxkLW5hbWUtY2FsbF9zdGF0dXNfYyBzY3JtLWRyb3Bkb3duZW51bS1kZXRhaWxcIlxuICAgICAgKTtcblxuICAgICAgaWYgKGNhbGxTdGF0dXNFbHMubGVuZ3RoID4gMCkge1xuICAgICAgICBjbGVhckludGVydmFsKGludGVydmFsKTtcblxuICAgICAgICBjb25zdCBzdGF0dXNEb3Q6IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH0gPSB7XG4gICAgICAgICAgd2lsbGRlcG9zaXQ6IFwi8J+folwiLFxuICAgICAgICAgIGludGVyZXN0ZWQ6IFwi8J+folwiLFxuICAgICAgICAgIGNhbGx0ZXJtaW5hdGVkOiBcIvCflLRcIixcbiAgICAgICAgICBkZXBvc2l0ZG9uZTogXCLwn5+iXCIsXG4gICAgICAgICAgY2FsbGxhdGVyOiBcIvCfn6FcIixcbiAgICAgICAgICBzd2l0Y2hvZmY6IFwi8J+UtFwiLFxuICAgICAgICAgIG5vdHBpY2tlZDE6IFwi8J+foVwiLFxuICAgICAgICAgIG5vdHBpY2tlZDI6IFwi8J+foVwiLFxuICAgICAgICAgIG5vdHBpY2tlZDM6IFwi8J+foVwiLFxuICAgICAgICAgIGludmFsaWRudW1iZXI6IFwi8J+UtFwiLFxuICAgICAgICAgIGhhdmVudGNhbGw6IFwi8J+foVwiLFxuICAgICAgICAgIG5vdGludGVyZXN0Ym9udXM6IFwi8J+UtFwiLFxuICAgICAgICAgIG5vdGludGVyZXN0d2ViOiBcIvCflLRcIixcbiAgICAgICAgICByZWdpc3RlcmVkOiBcIvCfn6JcIixcbiAgICAgICAgfTtcblxuICAgICAgICBjYWxsU3RhdHVzRWxzLmZvckVhY2goKGVsOiBFbGVtZW50KSA9PiB7XG4gICAgICAgICAgY29uc3QgdGV4dCA9IGVsLnRleHRDb250ZW50Py50cmltKCkgfHwgXCJcIjtcbiAgICAgICAgICBjb25zdCBjbGVhblZhbCA9IHRleHQudG9Mb3dlckNhc2UoKS5yZXBsYWNlKC9cXHMrL2csIFwiXCIpO1xuICAgICAgICAgIGNvbnN0IHN5bWJvbCA9IHN0YXR1c0RvdFtjbGVhblZhbF07XG5cbiAgICAgICAgICBpZiAoc3ltYm9sICYmICF0ZXh0LnN0YXJ0c1dpdGgoc3ltYm9sKSkge1xuICAgICAgICAgICAgZWwudGV4dENvbnRlbnQgPSBgJHtzeW1ib2x9ICR7dGV4dH1gO1xuICAgICAgICAgIH1cbiAgICAgICAgfSk7XG4gICAgICB9XG4gICAgfSwgMzAwKTtcbiAgfVxuICBwcml2YXRlIGluamVjdExpc3RUYWdDb2xvcnMoKTogdm9pZCB7XG4gICAgY29uc3QgaW50ZXJ2YWwgPSBzZXRJbnRlcnZhbCgoKSA9PiB7XG4gICAgICBjb25zdCB0YWdMaXN0cyA9IGRvY3VtZW50LnF1ZXJ5U2VsZWN0b3JBbGwoXG4gICAgICAgIFwiLmZpZWxkLW5hbWUtdGFnX2Mgc2NybS1tdWx0aWVudW0tZGV0YWlsIGxpXCJcbiAgICAgICk7XG5cbiAgICAgIGlmICh0YWdMaXN0cy5sZW5ndGggPiAwKSB7XG4gICAgICAgIGNsZWFySW50ZXJ2YWwoaW50ZXJ2YWwpO1xuICAgICAgICB0YWdMaXN0cy5mb3JFYWNoKChlbCkgPT4ge1xuICAgICAgICAgIGNvbnN0IGxhYmVsID0gZWwudGV4dENvbnRlbnQ/LnRyaW0oKS50b0xvd2VyQ2FzZSgpO1xuICAgICAgICAgIHRoaXMuYXBwbHlGbGF0VGFnU3R5bGVMaXN0KGVsIGFzIEhUTUxFbGVtZW50LCBsYWJlbCk7XG4gICAgICAgIH0pO1xuICAgICAgfVxuICAgIH0sIDMwMCk7XG4gIH1cbiAgcHJpdmF0ZSByZWFkb25seSBUQUdfQ09MT1JTX0xJU1Q6IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH0gPSB7XG4gICAgdmlwOiBcIiMyZWNjNzFcIixcbiAgICBcImJvbnVzIGh1bnRlclwiOiBcIiNlNzRjM2NcIixcbiAgICBcInNob3J0IGxpc3RlZFwiOiBcIiMzNDk4ZGJcIixcbiAgICByZWdpc3RlcmVkOiBcIiMyN2FlNjBcIixcbiAgICBob3Q6IFwiI2MwMzkyYlwiLFxuICAgIHJlbW92ZTogXCIjZTY3ZTIyXCIsXG4gICAgXCIzMCUgcmV0ZW50aW9uIGJvbnVzXCI6IFwiI2YxYzQwZlwiLFxuICAgIFwiNTAlIHJldGVudGlvbiBib251c1wiOiBcIiNmMzljMTJcIixcbiAgICBcIjMwJSA1MCUgcmV0ZW50aW9uIGJvbnVzXCI6IFwiI2YxOTQ4YVwiLFxuICAgIG91dHNvdXJjZTogXCIjOWI1OWI2XCIsXG4gICAgXCI1MGsgYmF0Y2ggMVwiOiBcIiM4ZTQ0YWRcIixcbiAgfTtcblxuICBwcml2YXRlIGFwcGx5RmxhdFRhZ1N0eWxlTGlzdChlbDogSFRNTEVsZW1lbnQsIGxhYmVsOiBzdHJpbmcpOiB2b2lkIHtcbiAgICBjb25zdCBjb2xvciA9IHRoaXMuVEFHX0NPTE9SU19MSVNUW2xhYmVsLnRvTG93ZXJDYXNlKCldO1xuICAgIGlmICghY29sb3IpIHJldHVybjtcbiAgICBlbC5zdHlsZS5iYWNrZ3JvdW5kQ29sb3IgPSBjb2xvcjtcbiAgICBlbC5zdHlsZS5jb2xvciA9IFwid2hpdGVcIjtcbiAgICBlbC5zdHlsZS5mb250U2l6ZSA9IFwiMTJweFwiO1xuICAgIGVsLnN0eWxlLmZvbnRXZWlnaHQgPSBcImJvbGRcIjtcbiAgICBlbC5zdHlsZS5wYWRkaW5nID0gXCIycHggOHB4XCI7XG4gICAgZWwuc3R5bGUuYm9yZGVyUmFkaXVzID0gXCIxMnB4XCI7XG4gICAgZWwuc3R5bGUuZGlzcGxheSA9IFwiaW5saW5lLWJsb2NrXCI7XG4gICAgZWwuc3R5bGUubWFyZ2luID0gXCIycHhcIjtcbiAgfVxufVxuIiwiPCEgLS1cbi8qKlxuKiBTdWl0ZUNSTSBpcyBhIGN1c3RvbWVyIHJlbGF0aW9uc2hpcCBtYW5hZ2VtZW50IHByb2dyYW0gZGV2ZWxvcGVkIGJ5IFNhbGVzQWdpbGl0eSBMdGQuXG4qIENvcHlyaWdodCAoQykgMjAyMSBTYWxlc0FnaWxpdHkgTHRkLlxuKlxuKiBUaGlzIHByb2dyYW0gaXMgZnJlZSBzb2Z0d2FyZTsgeW91IGNhbiByZWRpc3RyaWJ1dGUgaXQgYW5kL29yIG1vZGlmeSBpdCB1bmRlclxuKiB0aGUgdGVybXMgb2YgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZSB2ZXJzaW9uIDMgYXMgcHVibGlzaGVkIGJ5IHRoZVxuKiBGcmVlIFNvZnR3YXJlIEZvdW5kYXRpb24gd2l0aCB0aGUgYWRkaXRpb24gb2YgdGhlIGZvbGxvd2luZyBwZXJtaXNzaW9uIGFkZGVkXG4qIHRvIFNlY3Rpb24gMTUgYXMgcGVybWl0dGVkIGluIFNlY3Rpb24gNyhhKTogRk9SIEFOWSBQQVJUIE9GIFRIRSBDT1ZFUkVEIFdPUktcbiogSU4gV0hJQ0ggVEhFIENPUFlSSUdIVCBJUyBPV05FRCBCWSBTQUxFU0FHSUxJVFksIFNBTEVTQUdJTElUWSBESVNDTEFJTVMgVEhFXG4qIFdBUlJBTlRZIE9GIE5PTiBJTkZSSU5HRU1FTlQgT0YgVEhJUkQgUEFSVFkgUklHSFRTLlxuKlxuKiBUaGlzIHByb2dyYW0gaXMgZGlzdHJpYnV0ZWQgaW4gdGhlIGhvcGUgdGhhdCBpdCB3aWxsIGJlIHVzZWZ1bCwgYnV0IFdJVEhPVVRcbiogQU5ZIFdBUlJBTlRZOyB3aXRob3V0IGV2ZW4gdGhlIGltcGxpZWQgd2FycmFudHkgb2YgTUVSQ0hBTlRBQklMSVRZIG9yIEZJVE5FU1NcbiogRk9SIEEgUEFSVElDVUxBUiBQVVJQT1NFLiBTZWUgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZSBmb3IgbW9yZVxuKiBkZXRhaWxzLlxuKlxuKiBZb3Ugc2hvdWxkIGhhdmUgcmVjZWl2ZWQgYSBjb3B5IG9mIHRoZSBHTlUgQWZmZXJvIEdlbmVyYWwgUHVibGljIExpY2Vuc2VcbiogYWxvbmcgd2l0aCB0aGlzIHByb2dyYW0uICBJZiBub3QsIHNlZSBodHRwOi8vd3d3LmdudS5vcmcvbGljZW5zZXMuXG4qXG4qIEluIGFjY29yZGFuY2Ugd2l0aCBTZWN0aW9uIDcoYikgb2YgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZVxuKiB2ZXJzaW9uIDMsIHRoZXNlIEFwcHJvcHJpYXRlIExlZ2FsIE5vdGljZXMgbXVzdCByZXRhaW4gdGhlIGRpc3BsYXkgb2YgdGhlXG4qIFwiU3VwZXJjaGFyZ2VkIGJ5IFN1aXRlQ1JNXCIgbG9nby4gSWYgdGhlIGRpc3BsYXkgb2YgdGhlIGxvZ29zIGlzIG5vdCByZWFzb25hYmx5XG4qIGZlYXNpYmxlIGZvciB0ZWNobmljYWwgcmVhc29ucywgdGhlIEFwcHJvcHJpYXRlIExlZ2FsIE5vdGljZXMgbXVzdCBkaXNwbGF5XG4qIHRoZSB3b3JkcyBcIlN1cGVyY2hhcmdlZCBieSBTdWl0ZUNSTVwiLlxuKi9cbi0tPlxuPCEtLSBTdGFydCBMaXN0IFZpZXcgU2VjdGlvbiAtLT5cbjxkaXYgY2xhc3M9XCJsaXN0LXZpZXdcIiAqbmdJZj1cIih2bSQgfCBhc3luYykgYXMgdm1cIj5cbiAgICA8c2NybS1saXN0LWhlYWRlcj48L3Njcm0tbGlzdC1oZWFkZXI+XG4gICAgPHNjcm0tbGlzdC1jb250YWluZXI+PC9zY3JtLWxpc3QtY29udGFpbmVyPlxuPC9kaXY+XG48IS0tIEVuZCBMaXN0IFZpZXcgU2VjdGlvbiAtLT5cbiJdfQ==