/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Component, HostListener } from '@angular/core';
import { RecordViewStore } from '../../store/record-view/record-view.store';
import { ModuleNavigation } from '../../../../services/navigation/module-navigation/module-navigation.service';
import { RecordActionsAdapter } from '../../adapters/actions.adapter';
import { AppStateStore } from "../../../../store/app-state/app-state.store";
import { Router } from "@angular/router";
import * as i0 from "@angular/core";
import * as i1 from "../../adapters/actions.adapter";
import * as i2 from "../../store/record-view/record-view.store";
import * as i3 from "../../../../services/navigation/module-navigation/module-navigation.service";
import * as i4 from "../../../../store/app-state/app-state.store";
import * as i5 from "@angular/router";
import * as i6 from "@angular/common";
import * as i7 from "../../../../components/module-title/module-title.component";
import * as i8 from "../../../../components/dynamic-label/dynamic-label.component";
import * as i9 from "../../../../components/action-group-menu/action-group-menu.component";
import * as i10 from "../../../../containers/favorite-toggle/components/favorite-toggle/favorite-toggle.component";
import * as i11 from "../../../../components/button/button.component";
function RecordHeaderComponent_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 3)(1, "div", 4);
    i0.ɵɵelement(2, "scrm-module-title", 5)(3, "div", 6);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("title", ctx_r0.moduleTitle);
} }
function RecordHeaderComponent_div_3_div_3_scrm_button_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-button", 20);
} if (rf & 2) {
    const ctx_r6 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("config", ctx_r6.backButtonConfig);
} }
function RecordHeaderComponent_div_3_div_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 18);
    i0.ɵɵtemplate(1, RecordHeaderComponent_div_3_div_3_scrm_button_1_Template, 1, 1, "scrm-button", 19);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r2.backButtonConfig);
} }
function RecordHeaderComponent_div_3_div_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 21);
    i0.ɵɵelement(1, "scrm-favorite-toggle", 22);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r3 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("record", ctx_r3.record);
} }
function RecordHeaderComponent_div_3_scrm_dynamic_label_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-dynamic-label", 23);
} if (rf & 2) {
    const ctx_r4 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("fields", ctx_r4.record.fields)("labelKey", ctx_r4.getSummaryTemplate());
} }
function RecordHeaderComponent_div_3_div_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 24);
    i0.ɵɵelement(1, "scrm-action-group-menu", 25);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r5 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("config", ctx_r5.actionsAdapter)("actionContext", ctx_r5.getActionContext(ctx_r5.record))("klass", ctx_r5.isScrolled ? "record-view-actions-scrolled float-right" : "record-view-actions float-right");
} }
function RecordHeaderComponent_div_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 7)(1, "div", 8)(2, "div", 9);
    i0.ɵɵtemplate(3, RecordHeaderComponent_div_3_div_3_Template, 2, 1, "div", 10);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "div", 11)(5, "div", 12);
    i0.ɵɵtemplate(6, RecordHeaderComponent_div_3_div_6_Template, 2, 1, "div", 13);
    i0.ɵɵtemplate(7, RecordHeaderComponent_div_3_scrm_dynamic_label_7_Template, 1, 2, "scrm-dynamic-label", 14);
    i0.ɵɵelementEnd()()();
    i0.ɵɵelementStart(8, "div", 15)(9, "div", 16);
    i0.ɵɵtemplate(10, RecordHeaderComponent_div_3_div_10_Template, 2, 3, "div", 17);
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngIf", ctx_r1.mode === "detail" || ctx_r1.mode === "edit");
    i0.ɵɵadvance(1);
    i0.ɵɵclassProp("justify-content-center", ctx_r1.mode === "detail" || ctx_r1.mode === "edit")("justify-content-start", !(ctx_r1.mode === "detail" || ctx_r1.mode === "edit"))("record-view-name-wrapper-margin-left", ctx_r1.mode === "detail" || ctx_r1.mode === "edit");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngClass", ctx_r1.isScrolled ? "record-view-name-scrolled" : "record-view-name");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r1.record && ctx_r1.record.fields && ctx_r1.mode !== "create");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r1.record && ctx_r1.record.fields);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngIf", ctx_r1.record);
} }
class RecordHeaderComponent {
    onScroll() {
        const scrollPosition = window.pageYOffset;
        //ScrollThreshold is set to 1em
        const scrollThreshold = parseFloat(getComputedStyle(document.documentElement).fontSize);
        if (scrollPosition > scrollThreshold) {
            //5 is just a random safezone number
            if (scrollPosition - scrollThreshold < 5)
                return;
            this.isScrolled = true;
        }
        else {
            if (scrollThreshold - scrollPosition < 5)
                return;
            this.isScrolled = false;
        }
    }
    constructor(actionsAdapter, recordViewStore, moduleNavigation, appState, router) {
        this.actionsAdapter = actionsAdapter;
        this.recordViewStore = recordViewStore;
        this.moduleNavigation = moduleNavigation;
        this.appState = appState;
        this.router = router;
        this.mode = 'detail';
        this.loading = true;
        this.isScrolled = false;
        this.subs = [];
    }
    ngOnInit() {
        this.mode = this.recordViewStore.getMode();
        this.setBackButtonConfig();
        this.subs.push(this.recordViewStore.mode$.subscribe(mode => {
            this.mode = mode;
        }));
        this.subs.push(this.recordViewStore.record$.subscribe(record => {
            this.record = record;
        }));
        this.subs.push(this.recordViewStore.loading$.subscribe(loading => {
            this.loading = loading;
        }));
    }
    ngOnDestroy() {
        this.subs.forEach(sub => sub.unsubscribe());
    }
    get moduleTitle() {
        const module = this.recordViewStore.vm.appData.module;
        const appListStrings = this.recordViewStore.vm.appData.language.appListStrings;
        return this.moduleNavigation.getModuleLabel(module, appListStrings);
    }
    /**
     * Get Summary template
     *
     * @returns {string} template label
     */
    getSummaryTemplate() {
        return this.recordViewStore.getSummaryTemplate();
    }
    /**
     * Build action context
     * @param record
     */
    getActionContext(record) {
        if (!record) {
            return {};
        }
        return {
            module: record.module || '',
            record
        };
    }
    setBackButtonConfig() {
        const moduleRoute = this.moduleNavigation.getModuleRoute(this.recordViewStore.vm.appData.module);
        this.backButtonConfig = {
            icon: 'paginate_previous',
            klass: 'back-button',
            onClick: () => {
                this.router.navigate([moduleRoute.route], { queryParams: { keepPagination: true } }).then();
            }
        };
    }
    static { this.ɵfac = function RecordHeaderComponent_Factory(t) { return new (t || RecordHeaderComponent)(i0.ɵɵdirectiveInject(i1.RecordActionsAdapter), i0.ɵɵdirectiveInject(i2.RecordViewStore), i0.ɵɵdirectiveInject(i3.ModuleNavigation), i0.ɵɵdirectiveInject(i4.AppStateStore), i0.ɵɵdirectiveInject(i5.Router)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: RecordHeaderComponent, selectors: [["scrm-record-header"]], hostBindings: function RecordHeaderComponent_HostBindings(rf, ctx) { if (rf & 1) {
            i0.ɵɵlistener("scroll", function RecordHeaderComponent_scroll_HostBindingHandler() { return ctx.onScroll(); }, false, i0.ɵɵresolveWindow);
        } }, decls: 4, vars: 3, consts: [[1, "record-view-header", 3, "ngClass"], ["class", "row mr-0", 4, "ngIf"], ["class", "row m-0 d-flex justify-content-between ml-1 mr-1", 4, "ngIf"], [1, "row", "mr-0"], [1, "col-md-4", "d-flex", "align-items-center"], [1, "record-view-title", "title-font", 3, "title"], [1, "record-view-name", "pt-3", "pb-3"], [1, "row", "m-0", "d-flex", "justify-content-between", "ml-1", "mr-1"], [1, "col-xs-12", "col-sm-12", "col-md-6", "col-lg-7", "col-xl-8", "record-name-container"], [1, "float-left", "p-0"], ["class", "d-flex record-view-back-button justify-content-start", 4, "ngIf"], [1, "record-view-name-wrapper", "d-flex", "justify-content-md-start", "align-items-center"], [1, "p-0", "d-inline-block", 3, "ngClass"], ["class", "float-right align-items-top d-flex", 4, "ngIf"], ["class", "record-view-name-label d-block p-0 lh-100", 3, "fields", "labelKey", 4, "ngIf"], [1, "col-xs-12", "col-sm-12", "col-md-6", "col-lg-5", "col-xl-4", "align-items-center", "record-view-action-header"], [1, "row", "mr-1", "ml-1", "justify-content-center", "justify-content-md-end"], ["class", "", 4, "ngIf"], [1, "d-flex", "record-view-back-button", "justify-content-start"], [3, "config", 4, "ngIf"], [3, "config"], [1, "float-right", "align-items-top", "d-flex"], [1, "h-100", "lh-100", 3, "record"], [1, "record-view-name-label", "d-block", "p-0", "lh-100", 3, "fields", "labelKey"], [1, ""], ["buttonClass", "settings-button", 3, "config", "actionContext", "klass"]], template: function RecordHeaderComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementContainerStart(0);
            i0.ɵɵelementStart(1, "div", 0);
            i0.ɵɵtemplate(2, RecordHeaderComponent_div_2_Template, 4, 1, "div", 1);
            i0.ɵɵtemplate(3, RecordHeaderComponent_div_3_Template, 11, 11, "div", 2);
            i0.ɵɵelementEnd();
            i0.ɵɵelementContainerEnd();
        } if (rf & 2) {
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngClass", ctx.isScrolled ? "record-view-header-scrolled shadow-md" : "");
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.loading);
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", !ctx.loading);
        } }, dependencies: [i6.NgClass, i6.NgIf, i7.ModuleTitleComponent, i8.DynamicLabelComponent, i9.ActionGroupMenuComponent, i10.FavoriteToggleComponent, i11.ButtonComponent], encapsulation: 2 }); }
}
export { RecordHeaderComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RecordHeaderComponent, [{
        type: Component,
        args: [{ selector: 'scrm-record-header', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<ng-container>\n    <div [ngClass]=\"isScrolled ? 'record-view-header-scrolled shadow-md': ''\" class=\"record-view-header\">\n        <div *ngIf=\"loading\" class=\"row mr-0\">\n            <div class=\"col-md-4 d-flex align-items-center\">\n                <scrm-module-title [title]=\"moduleTitle\" class=\"record-view-title title-font\"></scrm-module-title>\n                <div class=\"record-view-name pt-3 pb-3\"></div>\n            </div>\n        </div>\n        <div *ngIf=\"!loading\" class=\"row m-0 d-flex justify-content-between ml-1 mr-1\">\n            <div class=\"col-xs-12 col-sm-12 col-md-6 col-lg-7 col-xl-8 record-name-container\">\n                <div class=\"float-left p-0\">\n                    <div class=\"d-flex record-view-back-button justify-content-start\" *ngIf=\"mode === 'detail' || mode === 'edit'\">\n                        <scrm-button *ngIf=\"backButtonConfig\" [config]=\"backButtonConfig\"></scrm-button>\n                    </div>\n                </div>\n                <div class=\"record-view-name-wrapper d-flex justify-content-md-start align-items-center\"\n                     [class.justify-content-center]=\"mode === 'detail' || mode === 'edit'\"\n                     [class.justify-content-start]=\"!(mode === 'detail' || mode === 'edit')\"\n                     [class.record-view-name-wrapper-margin-left]=\"mode === 'detail' || mode === 'edit'\"\n                >\n                    <div class=\"p-0 d-inline-block\" [ngClass]=\"isScrolled ? 'record-view-name-scrolled' : 'record-view-name'\">\n                        <div *ngIf=\"record && record.fields && mode !== 'create'\" class=\"float-right align-items-top d-flex\">\n                            <scrm-favorite-toggle [record]=\"record\"\n                                                  class=\"h-100 lh-100\"></scrm-favorite-toggle>\n                        </div>\n                        <scrm-dynamic-label *ngIf=\"record && record.fields\"\n                                            class=\"record-view-name-label d-block p-0 lh-100\"\n                                            [fields]=\"record.fields\"\n                                            [labelKey]=\"getSummaryTemplate()\">\n                        </scrm-dynamic-label>\n\n                    </div>\n                </div>\n            </div>\n            <div class=\"col-xs-12 col-sm-12 col-md-6 col-lg-5 col-xl-4 align-items-center record-view-action-header\">\n                <div class=\"row mr-1 ml-1 justify-content-center justify-content-md-end\">\n                    <div *ngIf=\"record\" class=\"\">\n                        <scrm-action-group-menu\n                                [config]=\"actionsAdapter\"\n                                [actionContext]=\"getActionContext(record)\"\n                                [klass]=\"isScrolled ?  'record-view-actions-scrolled float-right' : 'record-view-actions float-right'\"\n                                buttonClass=\"settings-button\"\n                        >\n                        </scrm-action-group-menu>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</ng-container>\n" }]
    }], function () { return [{ type: i1.RecordActionsAdapter }, { type: i2.RecordViewStore }, { type: i3.ModuleNavigation }, { type: i4.AppStateStore }, { type: i5.Router }]; }, { onScroll: [{
            type: HostListener,
            args: ['window:scroll']
        }] }); })();
//# sourceMappingURL=data:application/json;base64,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