/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
export class ActionHandler {
    getStatus(data) {
        return '';
    }
    checkAccess(action, acls, defaultAcls) {
        let requiredAcls = defaultAcls || [];
        if (action && action.acl) {
            requiredAcls = action.acl;
        }
        if (!requiredAcls || !requiredAcls.length) {
            return true;
        }
        const aclsMap = {};
        acls.forEach(value => aclsMap[value] = value);
        return requiredAcls.every(value => aclsMap[value]);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWN0aW9uLm1vZGVsLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vY29yZS9hcHAvY29tbW9uL3NyYy9saWIvYWN0aW9ucy9hY3Rpb24ubW9kZWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztHQXdCRztBQW1CSCxNQUFNLE9BQWdCLGFBQWE7SUFLL0IsU0FBUyxDQUFDLElBQU87UUFDYixPQUFPLEVBQUUsQ0FBQztJQUNkLENBQUM7SUFFUyxXQUFXLENBQUMsTUFBYyxFQUFFLElBQWMsRUFBRSxXQUFzQjtRQUN4RSxJQUFJLFlBQVksR0FBRyxXQUFXLElBQUksRUFBRSxDQUFDO1FBRXJDLElBQUksTUFBTSxJQUFJLE1BQU0sQ0FBQyxHQUFHLEVBQUU7WUFDdEIsWUFBWSxHQUFHLE1BQU0sQ0FBQyxHQUFHLENBQUM7U0FDN0I7UUFFRCxJQUFJLENBQUMsWUFBWSxJQUFJLENBQUMsWUFBWSxDQUFDLE1BQU0sRUFBRTtZQUN2QyxPQUFPLElBQUksQ0FBQztTQUNmO1FBRUQsTUFBTSxPQUFPLEdBQUcsRUFBZSxDQUFDO1FBQ2hDLElBQUksQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLEdBQUcsS0FBSyxDQUFDLENBQUM7UUFFOUMsT0FBTyxZQUFZLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDdkQsQ0FBQztDQUtKIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBTdWl0ZUNSTSBpcyBhIGN1c3RvbWVyIHJlbGF0aW9uc2hpcCBtYW5hZ2VtZW50IHByb2dyYW0gZGV2ZWxvcGVkIGJ5IFNhbGVzQWdpbGl0eSBMdGQuXG4gKiBDb3B5cmlnaHQgKEMpIDIwMjEgU2FsZXNBZ2lsaXR5IEx0ZC5cbiAqXG4gKiBUaGlzIHByb2dyYW0gaXMgZnJlZSBzb2Z0d2FyZTsgeW91IGNhbiByZWRpc3RyaWJ1dGUgaXQgYW5kL29yIG1vZGlmeSBpdCB1bmRlclxuICogdGhlIHRlcm1zIG9mIHRoZSBHTlUgQWZmZXJvIEdlbmVyYWwgUHVibGljIExpY2Vuc2UgdmVyc2lvbiAzIGFzIHB1Ymxpc2hlZCBieSB0aGVcbiAqIEZyZWUgU29mdHdhcmUgRm91bmRhdGlvbiB3aXRoIHRoZSBhZGRpdGlvbiBvZiB0aGUgZm9sbG93aW5nIHBlcm1pc3Npb24gYWRkZWRcbiAqIHRvIFNlY3Rpb24gMTUgYXMgcGVybWl0dGVkIGluIFNlY3Rpb24gNyhhKTogRk9SIEFOWSBQQVJUIE9GIFRIRSBDT1ZFUkVEIFdPUktcbiAqIElOIFdISUNIIFRIRSBDT1BZUklHSFQgSVMgT1dORUQgQlkgU0FMRVNBR0lMSVRZLCBTQUxFU0FHSUxJVFkgRElTQ0xBSU1TIFRIRVxuICogV0FSUkFOVFkgT0YgTk9OIElORlJJTkdFTUVOVCBPRiBUSElSRCBQQVJUWSBSSUdIVFMuXG4gKlxuICogVGhpcyBwcm9ncmFtIGlzIGRpc3RyaWJ1dGVkIGluIHRoZSBob3BlIHRoYXQgaXQgd2lsbCBiZSB1c2VmdWwsIGJ1dCBXSVRIT1VUXG4gKiBBTlkgV0FSUkFOVFk7IHdpdGhvdXQgZXZlbiB0aGUgaW1wbGllZCB3YXJyYW50eSBvZiBNRVJDSEFOVEFCSUxJVFkgb3IgRklUTkVTU1xuICogRk9SIEEgUEFSVElDVUxBUiBQVVJQT1NFLiBTZWUgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZSBmb3IgbW9yZVxuICogZGV0YWlscy5cbiAqXG4gKiBZb3Ugc2hvdWxkIGhhdmUgcmVjZWl2ZWQgYSBjb3B5IG9mIHRoZSBHTlUgQWZmZXJvIEdlbmVyYWwgUHVibGljIExpY2Vuc2VcbiAqIGFsb25nIHdpdGggdGhpcyBwcm9ncmFtLiAgSWYgbm90LCBzZWUgPGh0dHA6Ly93d3cuZ251Lm9yZy9saWNlbnNlcy8+LlxuICpcbiAqIEluIGFjY29yZGFuY2Ugd2l0aCBTZWN0aW9uIDcoYikgb2YgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZVxuICogdmVyc2lvbiAzLCB0aGVzZSBBcHByb3ByaWF0ZSBMZWdhbCBOb3RpY2VzIG11c3QgcmV0YWluIHRoZSBkaXNwbGF5IG9mIHRoZVxuICogXCJTdXBlcmNoYXJnZWQgYnkgU3VpdGVDUk1cIiBsb2dvLiBJZiB0aGUgZGlzcGxheSBvZiB0aGUgbG9nb3MgaXMgbm90IHJlYXNvbmFibHlcbiAqIGZlYXNpYmxlIGZvciB0ZWNobmljYWwgcmVhc29ucywgdGhlIEFwcHJvcHJpYXRlIExlZ2FsIE5vdGljZXMgbXVzdCBkaXNwbGF5XG4gKiB0aGUgd29yZHMgXCJTdXBlcmNoYXJnZWQgYnkgU3VpdGVDUk1cIi5cbiAqL1xuXG5pbXBvcnQge09ic2VydmFibGV9IGZyb20gJ3J4anMnO1xuaW1wb3J0IHtWaWV3TW9kZX0gZnJvbSAnLi4vdmlld3Mvdmlldy5tb2RlbCc7XG5pbXBvcnQge1JlY29yZH0gZnJvbSAnLi4vcmVjb3JkL3JlY29yZC5tb2RlbCc7XG5pbXBvcnQge1NlYXJjaENyaXRlcmlhfSBmcm9tICcuLi92aWV3cy9saXN0L3NlYXJjaC1jcml0ZXJpYS5tb2RlbCc7XG5pbXBvcnQge1N0cmluZ01hcH0gZnJvbSAnLi4vdHlwZXMvc3RyaW5nLW1hcCc7XG5pbXBvcnQgeyBMb2dpY0RlZmluaXRpb25zIH0gZnJvbSAnLi4vbWV0YWRhdGEvbWV0YWRhdGEubW9kZWwnO1xuXG5leHBvcnQgaW50ZXJmYWNlIEFjdGlvbkRhdGEge1xuICAgIFtrZXk6IHN0cmluZ106IGFueTtcblxuICAgIGFjdGlvbj86IEFjdGlvbjtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBBY3Rpb25IYW5kbGVyTWFwPEQgZXh0ZW5kcyBBY3Rpb25EYXRhPiB7XG4gICAgW2tleTogc3RyaW5nXTogQWN0aW9uSGFuZGxlcjxEPjtcbn1cblxuZXhwb3J0IGFic3RyYWN0IGNsYXNzIEFjdGlvbkhhbmRsZXI8RCBleHRlbmRzIEFjdGlvbkRhdGE+IHtcbiAgICBhYnN0cmFjdCBrZXk6IHN0cmluZztcblxuICAgIGFic3RyYWN0IG1vZGVzOiBWaWV3TW9kZVtdO1xuXG4gICAgZ2V0U3RhdHVzKGRhdGE6IEQpOiBzdHJpbmcge1xuICAgICAgICByZXR1cm4gJyc7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGNoZWNrQWNjZXNzKGFjdGlvbjogQWN0aW9uLCBhY2xzOiBzdHJpbmdbXSwgZGVmYXVsdEFjbHM/OiBzdHJpbmdbXSk6IGJvb2xlYW4ge1xuICAgICAgICBsZXQgcmVxdWlyZWRBY2xzID0gZGVmYXVsdEFjbHMgfHwgW107XG5cbiAgICAgICAgaWYgKGFjdGlvbiAmJiBhY3Rpb24uYWNsKSB7XG4gICAgICAgICAgICByZXF1aXJlZEFjbHMgPSBhY3Rpb24uYWNsO1xuICAgICAgICB9XG5cbiAgICAgICAgaWYgKCFyZXF1aXJlZEFjbHMgfHwgIXJlcXVpcmVkQWNscy5sZW5ndGgpIHtcbiAgICAgICAgICAgIHJldHVybiB0cnVlO1xuICAgICAgICB9XG5cbiAgICAgICAgY29uc3QgYWNsc01hcCA9IHt9IGFzIFN0cmluZ01hcDtcbiAgICAgICAgYWNscy5mb3JFYWNoKHZhbHVlID0+IGFjbHNNYXBbdmFsdWVdID0gdmFsdWUpO1xuXG4gICAgICAgIHJldHVybiByZXF1aXJlZEFjbHMuZXZlcnkodmFsdWUgPT4gYWNsc01hcFt2YWx1ZV0pO1xuICAgIH1cblxuICAgIGFic3RyYWN0IHJ1bihkYXRhOiBELCBhY3Rpb24/OiBBY3Rpb24pOiB2b2lkO1xuXG4gICAgYWJzdHJhY3Qgc2hvdWxkRGlzcGxheShkYXRhOiBEKTogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBNb2RlQWN0aW9ucyB7XG4gICAgW2tleTogc3RyaW5nXTogQWN0aW9uW107XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgQWN0aW9uIHtcbiAgICBba2V5OiBzdHJpbmddOiBhbnk7XG5cbiAgICBrZXk6IHN0cmluZztcbiAgICBsYWJlbEtleT86IHN0cmluZztcbiAgICB0aXRsZUtleT86IHN0cmluZztcbiAgICBsYWJlbD86IHN0cmluZztcbiAgICBpY29uPzogc3RyaW5nO1xuICAgIGtsYXNzPzogc3RyaW5nW107XG4gICAgc3RhdHVzPzogc3RyaW5nO1xuICAgIG1vZGVzPzogc3RyaW5nW107XG4gICAgYXN5bmNQcm9jZXNzPzogYm9vbGVhbjtcbiAgICBwYXJhbXM/OiB7IFtrZXk6IHN0cmluZ106IGFueSB9O1xuICAgIGV4dHJhUGFyYW1zPzogeyBba2V5OiBzdHJpbmddOiBhbnkgfTtcbiAgICBhY2w/OiBzdHJpbmdbXTtcbiAgICBkaXNwbGF5TG9naWM/OiBMb2dpY0RlZmluaXRpb25zO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIEFjdGlvbkRhdGFTb3VyY2Uge1xuICAgIGNvbGxhcHNlQnV0dG9ucz86IGJvb2xlYW47XG5cbiAgICBnZXRBY3Rpb25zKGNvbnRleHQ/OiBBY3Rpb25Db250ZXh0KTogT2JzZXJ2YWJsZTxBY3Rpb25bXT47XG5cbiAgICBydW5BY3Rpb24oYWN0aW9uOiBBY3Rpb24sIGNvbnRleHQ/OiBBY3Rpb25Db250ZXh0KTogdm9pZDtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBBY3Rpb25NYW5hZ2VyPEQgZXh0ZW5kcyBBY3Rpb25EYXRhPiB7XG5cbiAgICBydW4oYWN0aW9uOiBBY3Rpb24sIG1vZGU6IFZpZXdNb2RlLCBkYXRhOiBEKTogdm9pZDtcblxuICAgIGdldEhhbmRsZXIoYWN0aW9uOiBBY3Rpb24sIG1vZGU6IFZpZXdNb2RlKTogQWN0aW9uSGFuZGxlcjxEPjtcblxuICAgIGFkZEhhbmRsZXIoYWN0aW9uOiBBY3Rpb24sIG1vZGU6IFZpZXdNb2RlLCBoYW5kbGVyOiBBY3Rpb25IYW5kbGVyPEQ+KTogdm9pZDtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBBY3Rpb25Db250ZXh0IHtcbiAgICBba2V5OiBzdHJpbmddOiBhbnk7XG5cbiAgICBtb2R1bGU/OiBzdHJpbmc7XG4gICAgcmVjb3JkPzogUmVjb3JkO1xuICAgIGlkcz86IHN0cmluZ1tdO1xuICAgIGNyaXRlcmlhPzogU2VhcmNoQ3JpdGVyaWE7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgQWN0aXZlTGluZUFjdGlvbiB7XG4gICAgYWN0aXZlQWN0aW9uJDogT2JzZXJ2YWJsZTxzdHJpbmc+O1xuICAgIGdldEFjdGl2ZUFjdGlvbigpOiBzdHJpbmc7XG4gICAgc2V0QWN0aXZlQWN0aW9uKGtleTogc3RyaW5nKTogdm9pZDtcbiAgICByZXNldEFjdGl2ZUFjdGlvbigpOiB2b2lkO1xufVxuIl19