import { isTrue } from 'common';
import { Injectable } from '@angular/core';
import { FormControlUtils } from "../../field/form-control.utils";
import * as i0 from "@angular/core";
import * as i1 from "../../field/form-control.utils";
export const lineItemsRequiredValidator = (viewField, record, utils) => ((control) => {
    const name = viewField.name || '';
    if (!name || !record || !record.fields) {
        return null;
    }
    const field = record?.fields[name] ?? {};
    const items = field?.items ?? [];
    if (!field || !items) {
        return null;
    }
    const activeItems = items.filter(item => !(item && item.attributes && item.attributes.deleted));
    if (activeItems && activeItems.length > 0) {
        return null;
    }
    return {
        required: {
            required: true,
            message: {
                labelKey: 'LBL_VALIDATION_ERROR_REQUIRED',
                context: {}
            }
        }
    };
});
class LineItemsRequiredValidator {
    constructor(utils) {
        this.utils = utils;
    }
    applies(record, viewField) {
        if (!viewField || !viewField.fieldDefinition) {
            return false;
        }
        const type = viewField?.type ?? viewField?.fieldDefinition?.type ?? '';
        let required = viewField?.required ?? viewField?.fieldDefinition?.required ?? false;
        return type === 'line-items' && isTrue(required);
    }
    getValidator(viewField, record) {
        return [lineItemsRequiredValidator(viewField, record, this.utils)];
    }
    static { this.ɵfac = function LineItemsRequiredValidator_Factory(t) { return new (t || LineItemsRequiredValidator)(i0.ɵɵinject(i1.FormControlUtils)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: LineItemsRequiredValidator, factory: LineItemsRequiredValidator.ɵfac, providedIn: 'root' }); }
}
export { LineItemsRequiredValidator };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LineItemsRequiredValidator, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i1.FormControlUtils }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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