/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Component } from "@angular/core";
import { Subject } from "rxjs";
import { takeUntil } from "rxjs/operators";
import { ListViewStore, } from "../../store/list-view/list-view.store";
import { AppStateStore } from "../../../../store/app-state/app-state.store";
import { QuickFiltersService } from "../../services/quick-filters.service";
import { ListViewSidebarWidgetService } from "../../services/list-view-sidebar-widget.service";
import { RecordPaginationService } from "../../../record/store/record-pagination/record-pagination.service";
import { Injectable } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../../store/app-state/app-state.store";
import * as i2 from "../../store/list-view/list-view.store";
import * as i3 from "../../services/quick-filters.service";
import * as i4 from "../../services/list-view-sidebar-widget.service";
import * as i5 from "../../../record/store/record-pagination/record-pagination.service";
import * as i6 from "@angular/common";
import * as i7 from "../list-header/list-header.component";
import * as i8 from "../list-container/list-container.component";
function ListComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1);
    i0.ɵɵelement(1, "scrm-list-header")(2, "scrm-list-container");
    i0.ɵɵelementEnd();
} }
class ColorService {
    constructor() {
        this.colors = null;
        this.loading = null;
    }
    getColors() {
        if (this.colors)
            return Promise.resolve(this.colors);
        if (this.loading)
            return this.loading;
        const basePath = window.location.pathname.split("/legacy")[0]; // gets "/johncrm"
        this.loading = fetch(`${basePath}/legacy/custom/field_colors.php`)
            .then(res => res.json())
            .then(data => {
            this.colors = data;
            return data;
        })
            .catch(error => {
            console.error("Failed to load color mappings:", error);
            return { tagColors: {}, callStatus: {} };
        });
        return this.loading;
    }
    static { this.ɵfac = function ColorService_Factory(t) { return new (t || ColorService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ColorService, factory: ColorService.ɵfac, providedIn: 'root' }); }
}
export { ColorService };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ColorService, [{
        type: Injectable,
        args: [{ providedIn: 'root' }]
    }], null, null); })();
class ListComponent {
    constructor(appState, listStore, quickFilters, sidebarWidgetHandler, recordPaginationService, colorService) {
        this.appState = appState;
        this.listStore = listStore;
        this.quickFilters = quickFilters;
        this.sidebarWidgetHandler = sidebarWidgetHandler;
        this.recordPaginationService = recordPaginationService;
        this.colorService = colorService;
        this.destroy$ = new Subject();
        this.TAG_COLORS_LIST = {};
        this.CALL_STATUS_STYLES = {};
        this.vm$ = null;
    }
    ngOnInit() {
        console.log("List component init");
        this.appState.removeAllPrevRoutes();
        this.module = this.appState.getModule();
        this.listSub = this.listStore.init(this.module).subscribe();
        this.vm$ = this.listStore.vm$;
        this.vm$.pipe(takeUntil(this.destroy$)).subscribe(() => {
            // Wait for DOM to render - using a one-time timeout instead of repeatedly polling
            setTimeout(() => {
                this.setupDomObserver();
            }, 300);
        });
    }
    ngAfterViewInit() {
        console.log("list.component.ts ngAfterViewInit");
        // Load colors once and cache them
        this.loadColors().then(() => {
            // Apply styles once after colors are loaded
            this.injectListTagColors();
            this.injectCallStatusDotList();
        });
    }
    ngOnDestroy() {
        if (this.listSub) {
            this.listSub.unsubscribe();
        }
        // Clean up the observer if it exists
        if (this.domObserver) {
            this.domObserver.disconnect();
        }
        // Signal all subscriptions to complete
        this.destroy$.next();
        this.destroy$.complete();
        this.updateListLocalStorage();
        this.quickFilters.destroy();
        this.sidebarWidgetHandler.destroy();
        this.listStore.destroy();
    }
    setupDomObserver() {
        // Clean up any existing observer
        if (this.domObserver) {
            this.domObserver.disconnect();
        }
        const listTable = document.querySelector(".list-view-table") || document.body;
        this.domObserver = new MutationObserver(() => {
            console.log("[MutationObserver] Detected DOM changes in ListView");
            this.injectListTagColors();
            this.injectCallStatusDotList();
        });
        this.domObserver.observe(listTable, { childList: true, subtree: true });
    }
    updateListLocalStorage() {
        this.recordPaginationService.updateRecordListLocalStorage(this.listStore.recordList.records, this.listStore.recordList.pagination);
    }
    injectCallStatusDotList() {
        console.log("[CallStatus][ListView] Injecting call status dots");
        const callStatusEls = document.querySelectorAll(".field-name-call_status_c scrm-dropdownenum-detail");
        if (callStatusEls.length === 0) {
            console.log("[CallStatus][ListView] No elements found yet");
            return;
        }
        console.log(`[CallStatus][ListView] Found ${callStatusEls.length} elements.`);
        callStatusEls.forEach((el, index) => {
            const rawText = el.textContent?.trim() || "";
            const cleanVal = rawText.toLowerCase().replace(/\s+/g, "");
            const styleInfo = this.CALL_STATUS_STYLES[cleanVal];
            if (styleInfo) {
                const spanExists = el.querySelector(".call-status-pill");
                if (!spanExists) {
                    console.log(`[CallStatus][ListView][${index}] Applying color: ${styleInfo.color}`);
                    el.innerHTML = `<span class="call-status-pill">${styleInfo.emoji} ${rawText}</span>`;
                    const span = el.querySelector(".call-status-pill");
                    if (span) {
                        span.style.backgroundColor = styleInfo.color;
                        span.style.color = "#fff";
                        span.style.padding = "2px 10px";
                        span.style.borderRadius = "20px";
                        span.style.fontWeight = "600";
                        span.style.display = "inline-block";
                        span.style.textTransform = "uppercase";
                        span.style.fontSize = "12px";
                        span.style.letterSpacing = "0.5px";
                    }
                }
            }
        });
    }
    injectListTagColors() {
        const tagLists = document.querySelectorAll(".field-name-tag_c scrm-multienum-detail li");
        if (tagLists.length === 0) {
            return;
        }
        tagLists.forEach((el) => {
            const label = el.textContent?.trim().toLowerCase();
            this.applyFlatTagStyleList(el, label);
        });
    }
    async loadColors() {
        try {
            const data = await this.colorService.getColors();
            this.TAG_COLORS_LIST = data.tagColors;
            this.CALL_STATUS_STYLES = data.callStatus;
        }
        catch (error) {
            console.error("Failed to load color mappings:", error);
        }
    }
    applyFlatTagStyleList(el, label) {
        const color = this.TAG_COLORS_LIST[label.toLowerCase()];
        if (!color)
            return;
        el.style.backgroundColor = color;
        el.style.color = "white";
        el.style.fontSize = "12px";
        el.style.fontWeight = "bold";
        el.style.padding = "2px 8px";
        el.style.borderRadius = "12px";
        el.style.display = "inline-block";
        el.style.margin = "2px";
    }
    static { this.ɵfac = function ListComponent_Factory(t) { return new (t || ListComponent)(i0.ɵɵdirectiveInject(i1.AppStateStore), i0.ɵɵdirectiveInject(i2.ListViewStore), i0.ɵɵdirectiveInject(i3.QuickFiltersService), i0.ɵɵdirectiveInject(i4.ListViewSidebarWidgetService), i0.ɵɵdirectiveInject(i5.RecordPaginationService), i0.ɵɵdirectiveInject(ColorService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ListComponent, selectors: [["scrm-list"]], features: [i0.ɵɵProvidersFeature([ListViewStore, QuickFiltersService, ListViewSidebarWidgetService])], decls: 2, vars: 3, consts: [["class", "list-view", 4, "ngIf"], [1, "list-view"]], template: function ListComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, ListComponent_div_0_Template, 3, 0, "div", 0);
            i0.ɵɵpipe(1, "async");
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", i0.ɵɵpipeBind1(1, 1, ctx.vm$));
        } }, dependencies: [i6.NgIf, i7.ListHeaderComponent, i8.ListContainerComponent, i6.AsyncPipe], encapsulation: 2 }); }
}
export { ListComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ListComponent, [{
        type: Component,
        args: [{ selector: "scrm-list", providers: [ListViewStore, QuickFiltersService, ListViewSidebarWidgetService], template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<!-- Start List View Section -->\n<div class=\"list-view\" *ngIf=\"(vm$ | async) as vm\">\n    <scrm-list-header></scrm-list-header>\n    <scrm-list-container></scrm-list-container>\n</div>\n<!-- End List View Section -->\n" }]
    }], function () { return [{ type: i1.AppStateStore }, { type: i2.ListViewStore }, { type: i3.QuickFiltersService }, { type: i4.ListViewSidebarWidgetService }, { type: i5.RecordPaginationService }, { type: ColorService }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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