/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Component, Input } from '@angular/core';
import { take } from 'rxjs/operators';
import { AsyncActionService } from '../../../services/process/processes/async-action/async-action';
import { AppStateStore } from '../../../store/app-state/app-state.store';
import { SystemConfigStore } from "../../../store/system-config/system-config.store";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/process/processes/async-action/async-action";
import * as i2 from "../../../store/system-config/system-config.store";
import * as i3 from "../../../store/app-state/app-state.store";
import * as i4 from "@angular/common";
import * as i5 from "@angular/router";
import * as i6 from "../../image/image.component";
import * as i7 from "../../../pipes/truncate/truncate.pipe";
function BaseMenuItemLinkComponent_ng_container_0_scrm_image_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 3);
} if (rf & 2) {
    const ctx_r3 = i0.ɵɵnextContext(2);
    i0.ɵɵpropertyInterpolate("image", ctx_r3.icon);
} }
function BaseMenuItemLinkComponent_ng_container_0_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span");
    i0.ɵɵtext(1);
    i0.ɵɵpipe(2, "truncate");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r4 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate(i0.ɵɵpipeBind2(2, 1, ctx_r4.link.label, ctx_r4.charSize.mediumLength));
} }
function BaseMenuItemLinkComponent_ng_container_0_span_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span");
    i0.ɵɵtext(1);
    i0.ɵɵpipe(2, "truncate");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r5 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate(i0.ɵɵpipeBind2(2, 1, ctx_r5.link.label, ctx_r5.charSize.maxLength));
} }
function BaseMenuItemLinkComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    const _r7 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "a", 1);
    i0.ɵɵlistener("click", function BaseMenuItemLinkComponent_ng_container_0_Template_a_click_1_listener($event) { i0.ɵɵrestoreView(_r7); const ctx_r6 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r6.config.onClick($event)); })("touchstart", function BaseMenuItemLinkComponent_ng_container_0_Template_a_touchstart_1_listener($event) { i0.ɵɵrestoreView(_r7); const ctx_r8 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r8.config.onTouchStart($event)); });
    i0.ɵɵtemplate(2, BaseMenuItemLinkComponent_ng_container_0_scrm_image_2_Template, 1, 1, "scrm-image", 2);
    i0.ɵɵtemplate(3, BaseMenuItemLinkComponent_ng_container_0_span_3_Template, 3, 4, "span", 0);
    i0.ɵɵtemplate(4, BaseMenuItemLinkComponent_ng_container_0_span_4_Template, 3, 4, "span", 0);
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngClass", ctx_r0.class);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r0.icon);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", !ctx_r0.link.params);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r0.link.params);
} }
function BaseMenuItemLinkComponent_ng_container_1_a_1_scrm_image_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 3);
} if (rf & 2) {
    const ctx_r12 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("image", ctx_r12.icon);
} }
function BaseMenuItemLinkComponent_ng_container_1_a_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span");
    i0.ɵɵtext(1);
    i0.ɵɵpipe(2, "truncate");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r13 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate(i0.ɵɵpipeBind2(2, 1, ctx_r13.link.label, ctx_r13.charSize.mediumLength));
} }
function BaseMenuItemLinkComponent_ng_container_1_a_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span");
    i0.ɵɵtext(1);
    i0.ɵɵpipe(2, "truncate");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r14 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate(i0.ɵɵpipeBind2(2, 1, ctx_r14.link.label, ctx_r14.charSize.maxLength));
} }
function BaseMenuItemLinkComponent_ng_container_1_a_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "a", 7);
    i0.ɵɵtemplate(1, BaseMenuItemLinkComponent_ng_container_1_a_1_scrm_image_1_Template, 1, 1, "scrm-image", 2);
    i0.ɵɵtemplate(2, BaseMenuItemLinkComponent_ng_container_1_a_1_span_2_Template, 3, 4, "span", 0);
    i0.ɵɵtemplate(3, BaseMenuItemLinkComponent_ng_container_1_a_1_span_3_Template, 3, 4, "span", 0);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r9 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("ngClass", ctx_r9.class)("queryParams", ctx_r9.link.params)("routerLink", ctx_r9.link.route);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r9.icon);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", !ctx_r9.link.params);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r9.link.params);
} }
function BaseMenuItemLinkComponent_ng_container_1_a_2_scrm_image_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 3);
} if (rf & 2) {
    const ctx_r15 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("image", ctx_r15.icon);
} }
function BaseMenuItemLinkComponent_ng_container_1_a_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "a", 8);
    i0.ɵɵtemplate(1, BaseMenuItemLinkComponent_ng_container_1_a_2_scrm_image_1_Template, 1, 1, "scrm-image", 2);
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r10 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("href", ctx_r10.link.url, i0.ɵɵsanitizeUrl)("ngClass", ctx_r10.class);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r10.icon);
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", ctx_r10.link.label, " ");
} }
function BaseMenuItemLinkComponent_ng_container_1_a_3_scrm_image_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 3);
} if (rf & 2) {
    const ctx_r16 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("image", ctx_r16.icon);
} }
function BaseMenuItemLinkComponent_ng_container_1_a_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "a", 9);
    i0.ɵɵtemplate(1, BaseMenuItemLinkComponent_ng_container_1_a_3_scrm_image_1_Template, 1, 1, "scrm-image", 2);
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r11 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("ngClass", ctx_r11.class);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r11.icon);
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", ctx_r11.link.label, " ");
} }
function BaseMenuItemLinkComponent_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, BaseMenuItemLinkComponent_ng_container_1_a_1_Template, 4, 6, "a", 4);
    i0.ɵɵtemplate(2, BaseMenuItemLinkComponent_ng_container_1_a_2_Template, 3, 4, "a", 5);
    i0.ɵɵtemplate(3, BaseMenuItemLinkComponent_ng_container_1_a_3_Template, 3, 3, "a", 6);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r1.link.route);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", !ctx_r1.link.route && ctx_r1.link.url);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", !ctx_r1.link.route && !ctx_r1.link.url);
} }
function BaseMenuItemLinkComponent_ng_container_2_scrm_image_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 3);
} if (rf & 2) {
    const ctx_r17 = i0.ɵɵnextContext(2);
    i0.ɵɵpropertyInterpolate("image", ctx_r17.icon);
} }
function BaseMenuItemLinkComponent_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    const _r19 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "a", 10);
    i0.ɵɵlistener("click", function BaseMenuItemLinkComponent_ng_container_2_Template_a_click_1_listener() { i0.ɵɵrestoreView(_r19); const ctx_r18 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r18.handleProcess(ctx_r18.link.process)); });
    i0.ɵɵtemplate(2, BaseMenuItemLinkComponent_ng_container_2_scrm_image_2_Template, 1, 1, "scrm-image", 2);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngClass", ctx_r2.class);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r2.icon);
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", ctx_r2.link.label, " ");
} }
class BaseMenuItemLinkComponent {
    constructor(asyncActionService, systemConfigStore, appState) {
        this.asyncActionService = asyncActionService;
        this.systemConfigStore = systemConfigStore;
        this.appState = appState;
        this.charSize = {
            minLength: 20,
            mediumLength: 20,
            maxLength: 20
        };
    }
    ngOnInit() {
        const characterSizes = this.systemConfigStore.getUi('navbar_truncate_character_sizes');
        this.charSize = { ...characterSizes };
    }
    handleProcess(process) {
        if (!process) {
            return;
        }
        const processType = process;
        const options = {
            action: processType,
            module: this.appState.getModule(),
        };
        this.asyncActionService.run(processType, options).pipe(take(1)).subscribe();
    }
    static { this.ɵfac = function BaseMenuItemLinkComponent_Factory(t) { return new (t || BaseMenuItemLinkComponent)(i0.ɵɵdirectiveInject(i1.AsyncActionService), i0.ɵɵdirectiveInject(i2.SystemConfigStore), i0.ɵɵdirectiveInject(i3.AppStateStore)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: BaseMenuItemLinkComponent, selectors: [["scrm-base-menu-item-link"]], inputs: { link: "link", icon: "icon", class: "class", config: "config" }, decls: 3, vars: 3, consts: [[4, "ngIf"], [3, "ngClass", "click", "touchstart"], [3, "image", 4, "ngIf"], [3, "image"], [3, "ngClass", "queryParams", "routerLink", 4, "ngIf"], [3, "href", "ngClass", 4, "ngIf"], [3, "ngClass", 4, "ngIf"], [3, "ngClass", "queryParams", "routerLink"], [3, "href", "ngClass"], [3, "ngClass"], [3, "ngClass", "click"]], template: function BaseMenuItemLinkComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, BaseMenuItemLinkComponent_ng_container_0_Template, 5, 4, "ng-container", 0);
            i0.ɵɵtemplate(1, BaseMenuItemLinkComponent_ng_container_1_Template, 4, 3, "ng-container", 0);
            i0.ɵɵtemplate(2, BaseMenuItemLinkComponent_ng_container_2_Template, 4, 3, "ng-container", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", !ctx.link.process && (ctx.config == null ? null : ctx.config.onClick));
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", !ctx.link.process && !(ctx.config == null ? null : ctx.config.onClick));
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.link.process);
        } }, dependencies: [i4.NgClass, i4.NgIf, i5.RouterLink, i6.ImageComponent, i7.TruncatePipe], encapsulation: 2 }); }
}
export { BaseMenuItemLinkComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseMenuItemLinkComponent, [{
        type: Component,
        args: [{ selector: 'scrm-base-menu-item-link', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<ng-container *ngIf=\"!link.process && config?.onClick\">\n    <a (click)=\"config.onClick($event)\"\n       (touchstart)=\"config.onTouchStart($event)\"\n       [ngClass]=\"class\"\n    >\n        <scrm-image *ngIf=\"icon\" image=\"{{ icon }}\"></scrm-image>\n        <span *ngIf=\"!link.params\">{{ link.label | truncate: charSize.mediumLength }}</span>\n        <span *ngIf=\"link.params\">{{ link.label | truncate: charSize.maxLength }}</span>\n    </a>\n</ng-container>\n<ng-container *ngIf=\"!link.process && !config?.onClick\">\n    <a *ngIf=\"link.route\"\n       [ngClass]=\"class\"\n       [queryParams]=\"link.params\"\n       [routerLink]=\"link.route\"\n    >\n        <scrm-image *ngIf=\"icon\" image=\"{{ icon }}\"></scrm-image>\n        <span *ngIf=\"!link.params\">{{ link.label | truncate: charSize.mediumLength  }}</span>\n        <span *ngIf=\"link.params\">{{ link.label | truncate: charSize.maxLength  }}</span>\n    </a>\n    <a *ngIf=\"!link.route && link.url\"\n       [href]=\"link.url\"\n       [ngClass]=\"class\"\n    >\n        <scrm-image *ngIf=\"icon\" image=\"{{ icon }}\"></scrm-image>\n        {{ link.label }}\n    </a>\n    <a *ngIf=\"!link.route && !link.url\"\n       [ngClass]=\"class\"\n    >\n        <scrm-image *ngIf=\"icon\" image=\"{{ icon }}\"></scrm-image>\n        {{ link.label }}\n    </a>\n</ng-container>\n<ng-container *ngIf=\"link.process\">\n    <a [ngClass]=\"class\" (click)=\"handleProcess(link.process)\">\n        <scrm-image *ngIf=\"icon\" image=\"{{ icon }}\"></scrm-image>\n        {{ link.label }}\n    </a>\n</ng-container>\n\n\n" }]
    }], function () { return [{ type: i1.AsyncActionService }, { type: i2.SystemConfigStore }, { type: i3.AppStateStore }]; }, { link: [{
            type: Input
        }], icon: [{
            type: Input
        }], class: [{
            type: Input
        }], config: [{
            type: Input
        }] }); })();
//# sourceMappingURL=data:application/json;base64,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