/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { BaseFieldComponent } from './base-field.component';
import { Component } from '@angular/core';
import { isEmptyString, isVoid } from 'common';
import { DataTypeFormatter } from '../../services/formatters/data-type.formatter.service';
import { LanguageStore } from '../../store/language/language.store';
import { FieldLogicManager } from '../field-logic/field-logic.manager';
import { FieldLogicDisplayManager } from '../field-logic-display/field-logic-display.manager';
import { isNull, isObject } from "lodash-es";
import * as i0 from "@angular/core";
import * as i1 from "../../store/language/language.store";
import * as i2 from "../../services/formatters/data-type.formatter.service";
import * as i3 from "../field-logic/field-logic.manager";
import * as i4 from "../field-logic-display/field-logic-display.manager";
class BaseEnumComponent extends BaseFieldComponent {
    constructor(languages, typeFormatter, logic, logicDisplay) {
        super(typeFormatter, logic, logicDisplay);
        this.languages = languages;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
        this.selectedValues = [];
        this.valueLabel = '';
        this.options = [];
        this.subs = [];
        this.isDynamicEnum = false;
    }
    ngOnInit() {
        super.ngOnInit();
        const options$ = this?.field?.metadata?.options$ ?? null;
        if (options$) {
            this.subs.push(this.field.metadata.options$.subscribe((options) => {
                this.buildProvidedOptions(options);
                this.initValue();
            }));
            return;
        }
        const options = this?.field?.definition?.options ?? null;
        if (options) {
            this.subs.push(this.languages.vm$.subscribe((strings) => {
                this.buildAppStringListOptions(strings.appListStrings);
                this.initValue();
            }));
        }
        if (!options && !options$) {
            this.initValue();
        }
    }
    ngOnDestroy() {
        this.isDynamicEnum = false;
        this.subs.forEach(sub => sub.unsubscribe());
        this.options = [];
        this.optionsMap = {};
        this.selectedValues = [];
    }
    getInvalidClass() {
        if (this.validateOnlyOnSubmit ? this.isInvalid() : (this.field.formControl.invalid && this.field.formControl.touched)) {
            return 'is-invalid';
        }
        return '';
    }
    buildProvidedOptions(options) {
        this.options = options;
        this.optionsMap = {};
        options.forEach(option => {
            this.optionsMap[option.value] = option.label;
        });
    }
    buildAppStringListOptions(appStrings) {
        this.optionsMap = {};
        this.addExtraOptions();
        if (appStrings && this.field.definition.options && appStrings[this.field.definition.options]) {
            const options = appStrings[this.field.definition.options];
            if (this.options && Object.keys(this.options)) {
                this.optionsMap = { ...this.optionsMap, ...options };
            }
        }
        this.buildOptionsArray(appStrings);
    }
    addExtraOptions() {
        const extraOptions = (this.field.metadata && this.field.metadata.extraOptions) || [];
        extraOptions.forEach((item) => {
            if (isVoid(item.value)) {
                return;
            }
            let label = item.label || '';
            if (item.labelKey) {
                label = this.languages.getFieldLabel(item.labelKey);
            }
            this.optionsMap[item.value] = label;
        });
    }
    buildOptionsArray(appStrings) {
        this.options = [];
        Object.keys(this.optionsMap).forEach(key => {
            const isOptionEmpty = isEmptyString(this.optionsMap[key]);
            if (isOptionEmpty && this.isSkipEmptyMode()) {
                return;
            }
            if (isOptionEmpty && !this.addEmptyStringOption()) {
                return;
            }
            this.options.push({
                value: key,
                label: this.optionsMap[key]
            });
        });
        if (this.isDynamicEnum) {
            this.buildDynamicEnumOptions(appStrings);
        }
    }
    addEmptyStringOption() {
        return this.field.type !== 'multienum';
    }
    isSkipEmptyMode() {
        return this.mode === 'massupdate' || this.mode === 'filter';
    }
    initValue() {
        this.selectedValues = [];
        if (this.field.criteria) {
            this.initValueLabel();
            return;
        }
        if (typeof this.field.value !== 'string') {
            return;
        }
        if (!this.optionsMap) {
            return;
        }
        if (typeof this.optionsMap[this.field.value] !== 'string') {
            return;
        }
        this.initValueLabel();
    }
    initValueLabel() {
        const fieldValue = this.field.value || this.field.criteria?.target || undefined;
        if (fieldValue !== undefined) {
            this.valueLabel = this.optionsMap[fieldValue];
            this.selectedValues.push({
                value: fieldValue,
                label: this.valueLabel
            });
        }
    }
    /**
     *  Initialize the default value for the enum
     *
     *  @returns {void}
     *  @description set default enum value, if defined in vardefs
     * */
    initEnumDefault() {
        if (!isEmptyString(this.record?.id)) {
            this.field?.formControl.setValue('');
            return;
        }
        let defaultVal = this?.field?.default ?? this?.field?.definition?.default ?? null;
        if (typeof defaultVal === 'string') {
            defaultVal = defaultVal.trim();
        }
        if (!defaultVal) {
            this.field.formControl.setValue('');
            return;
        }
        this.selectedValues.push({
            value: defaultVal,
            label: this.optionsMap[defaultVal]
        });
        this.initEnumDefaultFieldValues(defaultVal);
    }
    initEnumDefaultFieldValues(defaultVal) {
        if (this.field.type === 'multienum') {
            const defaultValues = this.selectedValues.map(option => option.value);
            this.field.valueList = defaultValues;
            this.field.formControl.setValue(defaultValues);
        }
        else {
            this.field.value = defaultVal;
            this.field.formControl.setValue(defaultVal);
        }
        this.field.formControl.markAsDirty();
    }
    checkAndInitAsDynamicEnum() {
        const definition = (this.field && this.field.definition) || {};
        const dynamic = (definition && definition.dynamic) || false;
        const parentEnumKey = (definition && definition.parentenum) || '';
        const fields = (this.record && this.record.fields) || null;
        if (dynamic && parentEnumKey && fields) {
            this.isDynamicEnum = true;
            const parentEnum = fields[parentEnumKey];
            if (parentEnum) {
                this.subscribeToParentValueChanges(parentEnum);
            }
        }
    }
    buildDynamicEnumOptions(appStrings) {
        const parentEnum = this.record.fields[this.field.definition.parentenum];
        if (parentEnum) {
            const parentOptionMap = appStrings[parentEnum.definition.options];
            if (parentOptionMap && Object.keys(parentOptionMap).length !== 0) {
                this.mappedOptions = this.createParentChildOptionsMap(parentOptionMap, this.options);
                let parentValues = [];
                if (parentEnum.definition.type === 'multienum') {
                    parentValues = parentEnum.valueList;
                }
                else {
                    parentValues.push(parentEnum.value);
                }
                this.options = this.filterMatchingOptions(parentValues);
                if (parentValues && parentValues.length) {
                    this.setValueToAvailableOption();
                }
            }
        }
    }
    filterMatchingOptions(values) {
        let filteredOptions = [];
        if (!values || !values.length) {
            return [];
        }
        values.forEach(value => {
            if (!this.mappedOptions[value]) {
                return;
            }
            filteredOptions = filteredOptions.concat([...this.mappedOptions[value]]);
        });
        return filteredOptions;
    }
    createParentChildOptionsMap(parentOptions, childOptions) {
        const mappedOptions = {};
        Object.keys(parentOptions).forEach(key => {
            mappedOptions[key] = childOptions.filter(option => String(option.value).startsWith(key));
        });
        return mappedOptions;
    }
    subscribeToParentValueChanges(parentEnum) {
        if (parentEnum.formControl) {
            this.subs.push(parentEnum.formControl.valueChanges.subscribe(values => {
                if (typeof values === 'string') {
                    values = [values];
                }
                // Rebuild available enum options
                this.options = this.filterMatchingOptions(values);
                this.setValueToAvailableOption();
                this.initValue();
            }));
        }
    }
    setValueToAvailableOption() {
        if (!this?.options?.length) {
            this.field.value = '';
            this.field.formControl.setValue('');
            return;
        }
        if (!this.options.some(option => option.value === this.field.value)) {
            this.field.value = this.options[0].value;
            this.field.formControl.setValue(this.options[0].value);
        }
    }
    buildOptionFromValue(value) {
        const option = { value: '', label: '' };
        if (isNull(value)) {
            return option;
        }
        option.value = (typeof value !== 'string' ? JSON.stringify(value) : value).trim();
        option.label = option.value;
        const valueLabel = this.optionsMap[option.value] ?? option.label;
        if (isObject(valueLabel)) {
            return option;
        }
        option.label = (typeof valueLabel !== 'string' ? JSON.stringify(valueLabel) : valueLabel).trim();
        return option;
    }
    static { this.ɵfac = function BaseEnumComponent_Factory(t) { return new (t || BaseEnumComponent)(i0.ɵɵdirectiveInject(i1.LanguageStore), i0.ɵɵdirectiveInject(i2.DataTypeFormatter), i0.ɵɵdirectiveInject(i3.FieldLogicManager), i0.ɵɵdirectiveInject(i4.FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: BaseEnumComponent, selectors: [["ng-component"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 0, vars: 0, template: function BaseEnumComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
export { BaseEnumComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseEnumComponent, [{
        type: Component,
        args: [{ template: '' }]
    }], function () { return [{ type: i1.LanguageStore }, { type: i2.DataTypeFormatter }, { type: i3.FieldLogicManager }, { type: i4.FieldLogicDisplayManager }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmFzZS1lbnVtLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL2NvcmUvYXBwL2NvcmUvc3JjL2xpYi9maWVsZHMvYmFzZS9iYXNlLWVudW0uY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7R0F3Qkc7QUFFSCxPQUFPLEVBQUMsa0JBQWtCLEVBQUMsTUFBTSx3QkFBd0IsQ0FBQztBQUMxRCxPQUFPLEVBQUMsU0FBUyxFQUFvQixNQUFNLGVBQWUsQ0FBQztBQUUzRCxPQUFPLEVBQXlCLGFBQWEsRUFBRSxNQUFNLEVBQVMsTUFBTSxRQUFRLENBQUM7QUFDN0UsT0FBTyxFQUFDLGlCQUFpQixFQUFDLE1BQU0sdURBQXVELENBQUM7QUFDeEYsT0FBTyxFQUVILGFBQWEsRUFHaEIsTUFBTSxxQ0FBcUMsQ0FBQztBQUM3QyxPQUFPLEVBQUMsaUJBQWlCLEVBQUMsTUFBTSxvQ0FBb0MsQ0FBQztBQUNyRSxPQUFPLEVBQUMsd0JBQXdCLEVBQUMsTUFBTSxvREFBb0QsQ0FBQztBQUM1RixPQUFPLEVBQUMsTUFBTSxFQUFFLFFBQVEsRUFBQyxNQUFNLFdBQVcsQ0FBQzs7Ozs7O0FBRTNDLE1BQ2EsaUJBQWtCLFNBQVEsa0JBQWtCO0lBVXJELFlBQ2MsU0FBd0IsRUFDeEIsYUFBZ0MsRUFDaEMsS0FBd0IsRUFDeEIsWUFBc0M7UUFFaEQsS0FBSyxDQUFDLGFBQWEsRUFBRSxLQUFLLEVBQUUsWUFBWSxDQUFDLENBQUM7UUFMaEMsY0FBUyxHQUFULFNBQVMsQ0FBZTtRQUN4QixrQkFBYSxHQUFiLGFBQWEsQ0FBbUI7UUFDaEMsVUFBSyxHQUFMLEtBQUssQ0FBbUI7UUFDeEIsaUJBQVksR0FBWixZQUFZLENBQTBCO1FBYnBELG1CQUFjLEdBQWEsRUFBRSxDQUFDO1FBQzlCLGVBQVUsR0FBRyxFQUFFLENBQUM7UUFFaEIsWUFBTyxHQUFhLEVBQUUsQ0FBQztRQUViLFNBQUksR0FBbUIsRUFBRSxDQUFDO1FBRTFCLGtCQUFhLEdBQUcsS0FBSyxDQUFDO0lBU2hDLENBQUM7SUFFRCxRQUFRO1FBRUosS0FBSyxDQUFDLFFBQVEsRUFBRSxDQUFDO1FBRWpCLE1BQU0sUUFBUSxHQUFHLElBQUksRUFBRSxLQUFLLEVBQUUsUUFBUSxFQUFFLFFBQVEsSUFBSSxJQUFJLENBQUM7UUFDekQsSUFBSSxRQUFRLEVBQUU7WUFDVixJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDLENBQUMsT0FBaUIsRUFBRSxFQUFFO2dCQUN4RSxJQUFJLENBQUMsb0JBQW9CLENBQUMsT0FBTyxDQUFDLENBQUM7Z0JBRW5DLElBQUksQ0FBQyxTQUFTLEVBQUUsQ0FBQztZQUVyQixDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ0osT0FBTztTQUVWO1FBRUQsTUFBTSxPQUFPLEdBQUcsSUFBSSxFQUFFLEtBQUssRUFBRSxVQUFVLEVBQUUsT0FBTyxJQUFJLElBQUksQ0FBQztRQUN6RCxJQUFJLE9BQU8sRUFBRTtZQUNULElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLFNBQVMsQ0FBQyxDQUFDLE9BQXdCLEVBQUUsRUFBRTtnQkFFckUsSUFBSSxDQUFDLHlCQUF5QixDQUFDLE9BQU8sQ0FBQyxjQUFjLENBQUMsQ0FBQztnQkFDdkQsSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDO1lBRXJCLENBQUMsQ0FBQyxDQUFDLENBQUM7U0FDUDtRQUVELElBQUksQ0FBQyxPQUFPLElBQUksQ0FBQyxRQUFRLEVBQUU7WUFDdkIsSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDO1NBQ3BCO0lBRUwsQ0FBQztJQUVELFdBQVc7UUFDUCxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztRQUMzQixJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxXQUFXLEVBQUUsQ0FBQyxDQUFDO1FBQzVDLElBQUksQ0FBQyxPQUFPLEdBQUcsRUFBRSxDQUFDO1FBQ2xCLElBQUksQ0FBQyxVQUFVLEdBQUcsRUFBRSxDQUFDO1FBQ3JCLElBQUksQ0FBQyxjQUFjLEdBQUcsRUFBRSxDQUFDO0lBQzdCLENBQUM7SUFFRCxlQUFlO1FBQ1gsSUFBSSxJQUFJLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQyxPQUFPLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDLEVBQUU7WUFDbkgsT0FBTyxZQUFZLENBQUM7U0FDdkI7UUFDRCxPQUFPLEVBQUUsQ0FBQztJQUNkLENBQUM7SUFFUyxvQkFBb0IsQ0FBQyxPQUFpQjtRQUM1QyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU8sQ0FBQztRQUN2QixJQUFJLENBQUMsVUFBVSxHQUFHLEVBQUUsQ0FBQztRQUVyQixPQUFPLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxFQUFFO1lBQ3JCLElBQUksQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxHQUFHLE1BQU0sQ0FBQyxLQUFLLENBQUM7UUFDakQsQ0FBQyxDQUFDLENBQUM7SUFFUCxDQUFDO0lBRVMseUJBQXlCLENBQUMsVUFBaUM7UUFFakUsSUFBSSxDQUFDLFVBQVUsR0FBRyxFQUF1QixDQUFDO1FBQzFDLElBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQztRQUV2QixJQUFJLFVBQVUsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxPQUFPLElBQUksVUFBVSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxFQUFFO1lBQzFGLE1BQU0sT0FBTyxHQUFHLFVBQVUsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQXNCLENBQUM7WUFFL0UsSUFBSSxJQUFJLENBQUMsT0FBTyxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxFQUFFO2dCQUMzQyxJQUFJLENBQUMsVUFBVSxHQUFHLEVBQUMsR0FBRyxJQUFJLENBQUMsVUFBVSxFQUFFLEdBQUcsT0FBTyxFQUFDLENBQUM7YUFDdEQ7U0FDSjtRQUVELElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBRVMsZUFBZTtRQUNyQixNQUFNLFlBQVksR0FBRyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLFlBQVksQ0FBQyxJQUFJLEVBQUUsQ0FBQztRQUVyRixZQUFZLENBQUMsT0FBTyxDQUFDLENBQUMsSUFBWSxFQUFFLEVBQUU7WUFDbEMsSUFBSSxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxFQUFFO2dCQUNwQixPQUFPO2FBQ1Y7WUFFRCxJQUFJLEtBQUssR0FBRyxJQUFJLENBQUMsS0FBSyxJQUFJLEVBQUUsQ0FBQztZQUM3QixJQUFJLElBQUksQ0FBQyxRQUFRLEVBQUU7Z0JBQ2YsS0FBSyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQzthQUN2RDtZQUVELElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLEtBQUssQ0FBQztRQUN4QyxDQUFDLENBQUMsQ0FBQztJQUNQLENBQUM7SUFFUyxpQkFBaUIsQ0FBQyxVQUFpQztRQUV6RCxJQUFJLENBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQztRQUNsQixNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLEVBQUU7WUFFdkMsTUFBTSxhQUFhLEdBQUcsYUFBYSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztZQUUxRCxJQUFJLGFBQWEsSUFBSSxJQUFJLENBQUMsZUFBZSxFQUFFLEVBQUU7Z0JBQ3pDLE9BQU87YUFDVjtZQUVELElBQUksYUFBYSxJQUFJLENBQUMsSUFBSSxDQUFDLG9CQUFvQixFQUFFLEVBQUM7Z0JBQzlDLE9BQU87YUFDVjtZQUVELElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDO2dCQUNkLEtBQUssRUFBRSxHQUFHO2dCQUNWLEtBQUssRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQzthQUNwQixDQUFDLENBQUM7UUFDakIsQ0FBQyxDQUFDLENBQUM7UUFFSCxJQUFJLElBQUksQ0FBQyxhQUFhLEVBQUU7WUFDcEIsSUFBSSxDQUFDLHVCQUF1QixDQUFDLFVBQVUsQ0FBQyxDQUFDO1NBQzVDO0lBQ0wsQ0FBQztJQUVTLG9CQUFvQjtRQUMxQixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxLQUFLLFdBQVcsQ0FBQztJQUMzQyxDQUFDO0lBRVMsZUFBZTtRQUNyQixPQUFPLElBQUksQ0FBQyxJQUFJLEtBQUssWUFBWSxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssUUFBUSxDQUFDO0lBQ2hFLENBQUM7SUFFUyxTQUFTO1FBRWYsSUFBSSxDQUFDLGNBQWMsR0FBRyxFQUFFLENBQUM7UUFFekIsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsRUFBRTtZQUNyQixJQUFJLENBQUMsY0FBYyxFQUFFLENBQUM7WUFDdEIsT0FBTztTQUNWO1FBRUQsSUFBSSxPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxLQUFLLFFBQVEsRUFBRTtZQUN0QyxPQUFPO1NBQ1Y7UUFFRCxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRTtZQUNsQixPQUFPO1NBQ1Y7UUFFRCxJQUFJLE9BQU8sSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxLQUFLLFFBQVEsRUFBRTtZQUN2RCxPQUFPO1NBQ1Y7UUFFRCxJQUFJLENBQUMsY0FBYyxFQUFFLENBQUM7SUFDMUIsQ0FBQztJQUVTLGNBQWM7UUFDcEIsTUFBTSxVQUFVLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRLEVBQUUsTUFBTSxJQUFJLFNBQVMsQ0FBQztRQUNoRixJQUFJLFVBQVUsS0FBSyxTQUFTLEVBQUU7WUFDMUIsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1lBQzlDLElBQUksQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDO2dCQUNyQixLQUFLLEVBQUUsVUFBVTtnQkFDakIsS0FBSyxFQUFFLElBQUksQ0FBQyxVQUFVO2FBQ2YsQ0FBQyxDQUFDO1NBQ2hCO0lBQ0wsQ0FBQztJQUVEOzs7OztTQUtLO0lBQ0ssZUFBZTtRQUVyQixJQUFJLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsRUFBRSxDQUFDLEVBQUU7WUFDakMsSUFBSSxDQUFDLEtBQUssRUFBRSxXQUFXLENBQUMsUUFBUSxDQUFDLEVBQUUsQ0FBQyxDQUFDO1lBRXJDLE9BQU87U0FDVjtRQUVELElBQUksVUFBVSxHQUFHLElBQUksRUFBRSxLQUFLLEVBQUUsT0FBTyxJQUFJLElBQUksRUFBRSxLQUFLLEVBQUUsVUFBVSxFQUFFLE9BQU8sSUFBSSxJQUFJLENBQUM7UUFDbEYsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7WUFDaEMsVUFBVSxHQUFHLFVBQVUsQ0FBQyxJQUFJLEVBQUUsQ0FBQztTQUNsQztRQUNELElBQUksQ0FBQyxVQUFVLEVBQUU7WUFDYixJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQyxRQUFRLENBQUMsRUFBRSxDQUFDLENBQUM7WUFDcEMsT0FBTztTQUNWO1FBQ0QsSUFBSSxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUM7WUFDckIsS0FBSyxFQUFFLFVBQVU7WUFDakIsS0FBSyxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO1NBQzNCLENBQUMsQ0FBQztRQUNiLElBQUksQ0FBQywwQkFBMEIsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBRVMsMEJBQTBCLENBQUMsVUFBa0I7UUFFbkQsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksS0FBSyxXQUFXLEVBQUU7WUFDakMsTUFBTSxhQUFhLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQyxHQUFHLENBQUMsTUFBTSxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDdEUsSUFBSSxDQUFDLEtBQUssQ0FBQyxTQUFTLEdBQUcsYUFBYSxDQUFDO1lBQ3JDLElBQUksQ0FBQyxLQUFLLENBQUMsV0FBVyxDQUFDLFFBQVEsQ0FBQyxhQUFhLENBQUMsQ0FBQztTQUVsRDthQUFNO1lBQ0gsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLEdBQUcsVUFBVSxDQUFDO1lBQzlCLElBQUksQ0FBQyxLQUFLLENBQUMsV0FBVyxDQUFDLFFBQVEsQ0FBQyxVQUFVLENBQUMsQ0FBQztTQUMvQztRQUNELElBQUksQ0FBQyxLQUFLLENBQUMsV0FBVyxDQUFDLFdBQVcsRUFBRSxDQUFDO0lBQ3pDLENBQUM7SUFFUyx5QkFBeUI7UUFFL0IsTUFBTSxVQUFVLEdBQUcsQ0FBQyxJQUFJLENBQUMsS0FBSyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLElBQUksRUFBcUIsQ0FBQztRQUNsRixNQUFNLE9BQU8sR0FBRyxDQUFDLFVBQVUsSUFBSSxVQUFVLENBQUMsT0FBTyxDQUFDLElBQUksS0FBSyxDQUFDO1FBQzVELE1BQU0sYUFBYSxHQUFHLENBQUMsVUFBVSxJQUFJLFVBQVUsQ0FBQyxVQUFVLENBQUMsSUFBSSxFQUFFLENBQUM7UUFDbEUsTUFBTSxNQUFNLEdBQUcsQ0FBQyxJQUFJLENBQUMsTUFBTSxJQUFJLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLElBQUksSUFBSSxDQUFDO1FBRTNELElBQUksT0FBTyxJQUFJLGFBQWEsSUFBSSxNQUFNLEVBQUU7WUFDcEMsSUFBSSxDQUFDLGFBQWEsR0FBRyxJQUFJLENBQUM7WUFDMUIsTUFBTSxVQUFVLEdBQVUsTUFBTSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1lBQ2hELElBQUksVUFBVSxFQUFFO2dCQUNaLElBQUksQ0FBQyw2QkFBNkIsQ0FBQyxVQUFVLENBQUMsQ0FBQzthQUNsRDtTQUNKO0lBQ0wsQ0FBQztJQUVTLHVCQUF1QixDQUFDLFVBQWlDO1FBRS9ELE1BQU0sVUFBVSxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBRXhFLElBQUksVUFBVSxFQUFFO1lBRVosTUFBTSxlQUFlLEdBQXNCLFVBQVUsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBc0IsQ0FBQztZQUUxRyxJQUFJLGVBQWUsSUFBSSxNQUFNLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUU7Z0JBRTlELElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSxDQUFDLDJCQUEyQixDQUFDLGVBQWUsRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUM7Z0JBRXJGLElBQUksWUFBWSxHQUFhLEVBQUUsQ0FBQztnQkFDaEMsSUFBSSxVQUFVLENBQUMsVUFBVSxDQUFDLElBQUksS0FBSyxXQUFXLEVBQUU7b0JBQzVDLFlBQVksR0FBRyxVQUFVLENBQUMsU0FBUyxDQUFDO2lCQUN2QztxQkFBTTtvQkFDSCxZQUFZLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQztpQkFDdkM7Z0JBQ0QsSUFBSSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsWUFBWSxDQUFDLENBQUM7Z0JBRXhELElBQUksWUFBWSxJQUFJLFlBQVksQ0FBQyxNQUFNLEVBQUU7b0JBQ3JDLElBQUksQ0FBQyx5QkFBeUIsRUFBRSxDQUFDO2lCQUNwQzthQUVKO1NBQ0o7SUFDTCxDQUFDO0lBRVMscUJBQXFCLENBQUMsTUFBZ0I7UUFFNUMsSUFBSSxlQUFlLEdBQWEsRUFBRSxDQUFDO1FBRW5DLElBQUksQ0FBQyxNQUFNLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxFQUFFO1lBQzNCLE9BQU8sRUFBRSxDQUFDO1NBQ2I7UUFFRCxNQUFNLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQ25CLElBQUksQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxFQUFFO2dCQUM1QixPQUFPO2FBQ1Y7WUFDRCxlQUFlLEdBQUcsZUFBZSxDQUFDLE1BQU0sQ0FBQyxDQUFDLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDN0UsQ0FBQyxDQUFDLENBQUM7UUFFSCxPQUFPLGVBQWUsQ0FBQztJQUMzQixDQUFDO0lBRVMsMkJBQTJCLENBQUMsYUFBZ0MsRUFBRSxZQUFzQjtRQUMxRixNQUFNLGFBQWEsR0FBZ0MsRUFBRSxDQUFDO1FBQ3RELE1BQU0sQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxFQUFFO1lBQ3JDLGFBQWEsQ0FBQyxHQUFHLENBQUMsR0FBRyxZQUFZLENBQUMsTUFBTSxDQUNwQyxNQUFNLENBQUMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUNqRCxDQUFDO1FBQ04sQ0FBQyxDQUFDLENBQUM7UUFDSCxPQUFPLGFBQWEsQ0FBQztJQUN6QixDQUFDO0lBRVMsNkJBQTZCLENBQUMsVUFBaUI7UUFDckQsSUFBSSxVQUFVLENBQUMsV0FBVyxFQUFFO1lBQ3hCLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMsRUFBRTtnQkFFbEUsSUFBSSxPQUFPLE1BQU0sS0FBSyxRQUFRLEVBQUU7b0JBQzVCLE1BQU0sR0FBRyxDQUFDLE1BQU0sQ0FBQyxDQUFDO2lCQUNyQjtnQkFFRCxpQ0FBaUM7Z0JBQ2pDLElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLHFCQUFxQixDQUFDLE1BQU0sQ0FBQyxDQUFDO2dCQUNsRCxJQUFJLENBQUMseUJBQXlCLEVBQUUsQ0FBQztnQkFFakMsSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDO1lBQ3JCLENBQUMsQ0FBQyxDQUFDLENBQUM7U0FDUDtJQUNMLENBQUM7SUFFUyx5QkFBeUI7UUFDL0IsSUFBSSxDQUFDLElBQUksRUFBRSxPQUFPLEVBQUUsTUFBTSxFQUFFO1lBQ3hCLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxHQUFHLEVBQUUsQ0FBQztZQUN0QixJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQyxRQUFRLENBQUMsRUFBRSxDQUFDLENBQUM7WUFDcEMsT0FBTztTQUNWO1FBRUQsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDLEtBQUssS0FBSyxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQ2pFLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDO1lBQ3pDLElBQUksQ0FBQyxLQUFLLENBQUMsV0FBVyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDO1NBQzFEO0lBQ0wsQ0FBQztJQUVTLG9CQUFvQixDQUFDLEtBQWE7UUFDeEMsTUFBTSxNQUFNLEdBQVcsRUFBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssRUFBRSxFQUFFLEVBQUMsQ0FBQztRQUU5QyxJQUFJLE1BQU0sQ0FBQyxLQUFLLENBQUMsRUFBRTtZQUNmLE9BQU8sTUFBTSxDQUFDO1NBQ2pCO1FBQ0QsTUFBTSxDQUFDLEtBQUssR0FBRyxDQUFDLE9BQU8sS0FBSyxLQUFLLFFBQVEsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsSUFBSSxFQUFFLENBQUM7UUFDbEYsTUFBTSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsS0FBSyxDQUFDO1FBRTVCLE1BQU0sVUFBVSxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxJQUFJLE1BQU0sQ0FBQyxLQUFLLENBQUM7UUFDakUsSUFBSSxRQUFRLENBQUMsVUFBVSxDQUFDLEVBQUU7WUFDdEIsT0FBTyxNQUFNLENBQUM7U0FDakI7UUFDRCxNQUFNLENBQUMsS0FBSyxHQUFHLENBQUMsT0FBTyxVQUFVLEtBQUssUUFBUSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxJQUFJLEVBQUUsQ0FBQztRQUVqRyxPQUFPLE1BQU0sQ0FBQztJQUNsQixDQUFDO2tGQW5WUSxpQkFBaUI7b0VBQWpCLGlCQUFpQjs7U0FBakIsaUJBQWlCO3VGQUFqQixpQkFBaUI7Y0FEN0IsU0FBUztlQUFDLEVBQUMsUUFBUSxFQUFFLEVBQUUsRUFBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogU3VpdGVDUk0gaXMgYSBjdXN0b21lciByZWxhdGlvbnNoaXAgbWFuYWdlbWVudCBwcm9ncmFtIGRldmVsb3BlZCBieSBTYWxlc0FnaWxpdHkgTHRkLlxuICogQ29weXJpZ2h0IChDKSAyMDIxIFNhbGVzQWdpbGl0eSBMdGQuXG4gKlxuICogVGhpcyBwcm9ncmFtIGlzIGZyZWUgc29mdHdhcmU7IHlvdSBjYW4gcmVkaXN0cmlidXRlIGl0IGFuZC9vciBtb2RpZnkgaXQgdW5kZXJcbiAqIHRoZSB0ZXJtcyBvZiB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlIHZlcnNpb24gMyBhcyBwdWJsaXNoZWQgYnkgdGhlXG4gKiBGcmVlIFNvZnR3YXJlIEZvdW5kYXRpb24gd2l0aCB0aGUgYWRkaXRpb24gb2YgdGhlIGZvbGxvd2luZyBwZXJtaXNzaW9uIGFkZGVkXG4gKiB0byBTZWN0aW9uIDE1IGFzIHBlcm1pdHRlZCBpbiBTZWN0aW9uIDcoYSk6IEZPUiBBTlkgUEFSVCBPRiBUSEUgQ09WRVJFRCBXT1JLXG4gKiBJTiBXSElDSCBUSEUgQ09QWVJJR0hUIElTIE9XTkVEIEJZIFNBTEVTQUdJTElUWSwgU0FMRVNBR0lMSVRZIERJU0NMQUlNUyBUSEVcbiAqIFdBUlJBTlRZIE9GIE5PTiBJTkZSSU5HRU1FTlQgT0YgVEhJUkQgUEFSVFkgUklHSFRTLlxuICpcbiAqIFRoaXMgcHJvZ3JhbSBpcyBkaXN0cmlidXRlZCBpbiB0aGUgaG9wZSB0aGF0IGl0IHdpbGwgYmUgdXNlZnVsLCBidXQgV0lUSE9VVFxuICogQU5ZIFdBUlJBTlRZOyB3aXRob3V0IGV2ZW4gdGhlIGltcGxpZWQgd2FycmFudHkgb2YgTUVSQ0hBTlRBQklMSVRZIG9yIEZJVE5FU1NcbiAqIEZPUiBBIFBBUlRJQ1VMQVIgUFVSUE9TRS4gU2VlIHRoZSBHTlUgQWZmZXJvIEdlbmVyYWwgUHVibGljIExpY2Vuc2UgZm9yIG1vcmVcbiAqIGRldGFpbHMuXG4gKlxuICogWW91IHNob3VsZCBoYXZlIHJlY2VpdmVkIGEgY29weSBvZiB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlXG4gKiBhbG9uZyB3aXRoIHRoaXMgcHJvZ3JhbS4gIElmIG5vdCwgc2VlIDxodHRwOi8vd3d3LmdudS5vcmcvbGljZW5zZXMvPi5cbiAqXG4gKiBJbiBhY2NvcmRhbmNlIHdpdGggU2VjdGlvbiA3KGIpIG9mIHRoZSBHTlUgQWZmZXJvIEdlbmVyYWwgUHVibGljIExpY2Vuc2VcbiAqIHZlcnNpb24gMywgdGhlc2UgQXBwcm9wcmlhdGUgTGVnYWwgTm90aWNlcyBtdXN0IHJldGFpbiB0aGUgZGlzcGxheSBvZiB0aGVcbiAqIFwiU3VwZXJjaGFyZ2VkIGJ5IFN1aXRlQ1JNXCIgbG9nby4gSWYgdGhlIGRpc3BsYXkgb2YgdGhlIGxvZ29zIGlzIG5vdCByZWFzb25hYmx5XG4gKiBmZWFzaWJsZSBmb3IgdGVjaG5pY2FsIHJlYXNvbnMsIHRoZSBBcHByb3ByaWF0ZSBMZWdhbCBOb3RpY2VzIG11c3QgZGlzcGxheVxuICogdGhlIHdvcmRzIFwiU3VwZXJjaGFyZ2VkIGJ5IFN1aXRlQ1JNXCIuXG4gKi9cblxuaW1wb3J0IHtCYXNlRmllbGRDb21wb25lbnR9IGZyb20gJy4vYmFzZS1maWVsZC5jb21wb25lbnQnO1xuaW1wb3J0IHtDb21wb25lbnQsIE9uRGVzdHJveSwgT25Jbml0fSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7U3Vic2NyaXB0aW9ufSBmcm9tICdyeGpzJztcbmltcG9ydCB7RmllbGQsIEZpZWxkRGVmaW5pdGlvbiwgaXNFbXB0eVN0cmluZywgaXNWb2lkLCBPcHRpb259IGZyb20gJ2NvbW1vbic7XG5pbXBvcnQge0RhdGFUeXBlRm9ybWF0dGVyfSBmcm9tICcuLi8uLi9zZXJ2aWNlcy9mb3JtYXR0ZXJzL2RhdGEtdHlwZS5mb3JtYXR0ZXIuc2VydmljZSc7XG5pbXBvcnQge1xuICAgIExhbmd1YWdlTGlzdFN0cmluZ01hcCxcbiAgICBMYW5ndWFnZVN0b3JlLFxuICAgIExhbmd1YWdlU3RyaW5nTWFwLFxuICAgIExhbmd1YWdlU3RyaW5nc1xufSBmcm9tICcuLi8uLi9zdG9yZS9sYW5ndWFnZS9sYW5ndWFnZS5zdG9yZSc7XG5pbXBvcnQge0ZpZWxkTG9naWNNYW5hZ2VyfSBmcm9tICcuLi9maWVsZC1sb2dpYy9maWVsZC1sb2dpYy5tYW5hZ2VyJztcbmltcG9ydCB7RmllbGRMb2dpY0Rpc3BsYXlNYW5hZ2VyfSBmcm9tICcuLi9maWVsZC1sb2dpYy1kaXNwbGF5L2ZpZWxkLWxvZ2ljLWRpc3BsYXkubWFuYWdlcic7XG5pbXBvcnQge2lzTnVsbCwgaXNPYmplY3R9IGZyb20gXCJsb2Rhc2gtZXNcIjtcblxuQENvbXBvbmVudCh7dGVtcGxhdGU6ICcnfSlcbmV4cG9ydCBjbGFzcyBCYXNlRW51bUNvbXBvbmVudCBleHRlbmRzIEJhc2VGaWVsZENvbXBvbmVudCBpbXBsZW1lbnRzIE9uSW5pdCwgT25EZXN0cm95IHtcbiAgICBzZWxlY3RlZFZhbHVlczogT3B0aW9uW10gPSBbXTtcbiAgICB2YWx1ZUxhYmVsID0gJyc7XG4gICAgb3B0aW9uc01hcDogTGFuZ3VhZ2VTdHJpbmdNYXA7XG4gICAgb3B0aW9uczogT3B0aW9uW10gPSBbXTtcbiAgICBsYWJlbHM6IExhbmd1YWdlU3RyaW5nTWFwO1xuICAgIHByb3RlY3RlZCBzdWJzOiBTdWJzY3JpcHRpb25bXSA9IFtdO1xuICAgIHByb3RlY3RlZCBtYXBwZWRPcHRpb25zOiB7IFtrZXk6IHN0cmluZ106IE9wdGlvbltdIH07XG4gICAgcHJvdGVjdGVkIGlzRHluYW1pY0VudW0gPSBmYWxzZTtcblxuICAgIGNvbnN0cnVjdG9yKFxuICAgICAgICBwcm90ZWN0ZWQgbGFuZ3VhZ2VzOiBMYW5ndWFnZVN0b3JlLFxuICAgICAgICBwcm90ZWN0ZWQgdHlwZUZvcm1hdHRlcjogRGF0YVR5cGVGb3JtYXR0ZXIsXG4gICAgICAgIHByb3RlY3RlZCBsb2dpYzogRmllbGRMb2dpY01hbmFnZXIsXG4gICAgICAgIHByb3RlY3RlZCBsb2dpY0Rpc3BsYXk6IEZpZWxkTG9naWNEaXNwbGF5TWFuYWdlclxuICAgICkge1xuICAgICAgICBzdXBlcih0eXBlRm9ybWF0dGVyLCBsb2dpYywgbG9naWNEaXNwbGF5KTtcbiAgICB9XG5cbiAgICBuZ09uSW5pdCgpOiB2b2lkIHtcblxuICAgICAgICBzdXBlci5uZ09uSW5pdCgpO1xuXG4gICAgICAgIGNvbnN0IG9wdGlvbnMkID0gdGhpcz8uZmllbGQ/Lm1ldGFkYXRhPy5vcHRpb25zJCA/PyBudWxsO1xuICAgICAgICBpZiAob3B0aW9ucyQpIHtcbiAgICAgICAgICAgIHRoaXMuc3Vicy5wdXNoKHRoaXMuZmllbGQubWV0YWRhdGEub3B0aW9ucyQuc3Vic2NyaWJlKChvcHRpb25zOiBPcHRpb25bXSkgPT4ge1xuICAgICAgICAgICAgICAgIHRoaXMuYnVpbGRQcm92aWRlZE9wdGlvbnMob3B0aW9ucyk7XG5cbiAgICAgICAgICAgICAgICB0aGlzLmluaXRWYWx1ZSgpO1xuXG4gICAgICAgICAgICB9KSk7XG4gICAgICAgICAgICByZXR1cm47XG5cbiAgICAgICAgfVxuXG4gICAgICAgIGNvbnN0IG9wdGlvbnMgPSB0aGlzPy5maWVsZD8uZGVmaW5pdGlvbj8ub3B0aW9ucyA/PyBudWxsO1xuICAgICAgICBpZiAob3B0aW9ucykge1xuICAgICAgICAgICAgdGhpcy5zdWJzLnB1c2godGhpcy5sYW5ndWFnZXMudm0kLnN1YnNjcmliZSgoc3RyaW5nczogTGFuZ3VhZ2VTdHJpbmdzKSA9PiB7XG5cbiAgICAgICAgICAgICAgICB0aGlzLmJ1aWxkQXBwU3RyaW5nTGlzdE9wdGlvbnMoc3RyaW5ncy5hcHBMaXN0U3RyaW5ncyk7XG4gICAgICAgICAgICAgICAgdGhpcy5pbml0VmFsdWUoKTtcblxuICAgICAgICAgICAgfSkpO1xuICAgICAgICB9XG5cbiAgICAgICAgaWYgKCFvcHRpb25zICYmICFvcHRpb25zJCkge1xuICAgICAgICAgICAgdGhpcy5pbml0VmFsdWUoKTtcbiAgICAgICAgfVxuXG4gICAgfVxuXG4gICAgbmdPbkRlc3Ryb3koKTogdm9pZCB7XG4gICAgICAgIHRoaXMuaXNEeW5hbWljRW51bSA9IGZhbHNlO1xuICAgICAgICB0aGlzLnN1YnMuZm9yRWFjaChzdWIgPT4gc3ViLnVuc3Vic2NyaWJlKCkpO1xuICAgICAgICB0aGlzLm9wdGlvbnMgPSBbXTtcbiAgICAgICAgdGhpcy5vcHRpb25zTWFwID0ge307XG4gICAgICAgIHRoaXMuc2VsZWN0ZWRWYWx1ZXMgPSBbXTtcbiAgICB9XG5cbiAgICBnZXRJbnZhbGlkQ2xhc3MoKTogc3RyaW5nIHtcbiAgICAgICAgaWYgKHRoaXMudmFsaWRhdGVPbmx5T25TdWJtaXQgPyB0aGlzLmlzSW52YWxpZCgpIDogKHRoaXMuZmllbGQuZm9ybUNvbnRyb2wuaW52YWxpZCAmJiB0aGlzLmZpZWxkLmZvcm1Db250cm9sLnRvdWNoZWQpKSB7XG4gICAgICAgICAgICByZXR1cm4gJ2lzLWludmFsaWQnO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiAnJztcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgYnVpbGRQcm92aWRlZE9wdGlvbnMob3B0aW9uczogT3B0aW9uW10pOiB2b2lkIHtcbiAgICAgICAgdGhpcy5vcHRpb25zID0gb3B0aW9ucztcbiAgICAgICAgdGhpcy5vcHRpb25zTWFwID0ge307XG5cbiAgICAgICAgb3B0aW9ucy5mb3JFYWNoKG9wdGlvbiA9PiB7XG4gICAgICAgICAgICB0aGlzLm9wdGlvbnNNYXBbb3B0aW9uLnZhbHVlXSA9IG9wdGlvbi5sYWJlbDtcbiAgICAgICAgfSk7XG5cbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgYnVpbGRBcHBTdHJpbmdMaXN0T3B0aW9ucyhhcHBTdHJpbmdzOiBMYW5ndWFnZUxpc3RTdHJpbmdNYXApOiB2b2lkIHtcblxuICAgICAgICB0aGlzLm9wdGlvbnNNYXAgPSB7fSBhcyBMYW5ndWFnZVN0cmluZ01hcDtcbiAgICAgICAgdGhpcy5hZGRFeHRyYU9wdGlvbnMoKTtcblxuICAgICAgICBpZiAoYXBwU3RyaW5ncyAmJiB0aGlzLmZpZWxkLmRlZmluaXRpb24ub3B0aW9ucyAmJiBhcHBTdHJpbmdzW3RoaXMuZmllbGQuZGVmaW5pdGlvbi5vcHRpb25zXSkge1xuICAgICAgICAgICAgY29uc3Qgb3B0aW9ucyA9IGFwcFN0cmluZ3NbdGhpcy5maWVsZC5kZWZpbml0aW9uLm9wdGlvbnNdIGFzIExhbmd1YWdlU3RyaW5nTWFwO1xuXG4gICAgICAgICAgICBpZiAodGhpcy5vcHRpb25zICYmIE9iamVjdC5rZXlzKHRoaXMub3B0aW9ucykpIHtcbiAgICAgICAgICAgICAgICB0aGlzLm9wdGlvbnNNYXAgPSB7Li4udGhpcy5vcHRpb25zTWFwLCAuLi5vcHRpb25zfTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuXG4gICAgICAgIHRoaXMuYnVpbGRPcHRpb25zQXJyYXkoYXBwU3RyaW5ncyk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGFkZEV4dHJhT3B0aW9ucygpOiB2b2lkIHtcbiAgICAgICAgY29uc3QgZXh0cmFPcHRpb25zID0gKHRoaXMuZmllbGQubWV0YWRhdGEgJiYgdGhpcy5maWVsZC5tZXRhZGF0YS5leHRyYU9wdGlvbnMpIHx8IFtdO1xuXG4gICAgICAgIGV4dHJhT3B0aW9ucy5mb3JFYWNoKChpdGVtOiBPcHRpb24pID0+IHtcbiAgICAgICAgICAgIGlmIChpc1ZvaWQoaXRlbS52YWx1ZSkpIHtcbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIGxldCBsYWJlbCA9IGl0ZW0ubGFiZWwgfHwgJyc7XG4gICAgICAgICAgICBpZiAoaXRlbS5sYWJlbEtleSkge1xuICAgICAgICAgICAgICAgIGxhYmVsID0gdGhpcy5sYW5ndWFnZXMuZ2V0RmllbGRMYWJlbChpdGVtLmxhYmVsS2V5KTtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgdGhpcy5vcHRpb25zTWFwW2l0ZW0udmFsdWVdID0gbGFiZWw7XG4gICAgICAgIH0pO1xuICAgIH1cblxuICAgIHByb3RlY3RlZCBidWlsZE9wdGlvbnNBcnJheShhcHBTdHJpbmdzOiBMYW5ndWFnZUxpc3RTdHJpbmdNYXApOiB2b2lkIHtcblxuICAgICAgICB0aGlzLm9wdGlvbnMgPSBbXTtcbiAgICAgICAgT2JqZWN0LmtleXModGhpcy5vcHRpb25zTWFwKS5mb3JFYWNoKGtleSA9PiB7XG5cbiAgICAgICAgICAgIGNvbnN0IGlzT3B0aW9uRW1wdHkgPSBpc0VtcHR5U3RyaW5nKHRoaXMub3B0aW9uc01hcFtrZXldKTtcblxuICAgICAgICAgICAgaWYgKGlzT3B0aW9uRW1wdHkgJiYgdGhpcy5pc1NraXBFbXB0eU1vZGUoKSkge1xuICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgaWYgKGlzT3B0aW9uRW1wdHkgJiYgIXRoaXMuYWRkRW1wdHlTdHJpbmdPcHRpb24oKSl7XG4gICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICB0aGlzLm9wdGlvbnMucHVzaCh7XG4gICAgICAgICAgICAgICAgdmFsdWU6IGtleSxcbiAgICAgICAgICAgICAgICBsYWJlbDogdGhpcy5vcHRpb25zTWFwW2tleV1cbiAgICAgICAgICAgIH0gYXMgT3B0aW9uKTtcbiAgICAgICAgfSk7XG5cbiAgICAgICAgaWYgKHRoaXMuaXNEeW5hbWljRW51bSkge1xuICAgICAgICAgICAgdGhpcy5idWlsZER5bmFtaWNFbnVtT3B0aW9ucyhhcHBTdHJpbmdzKTtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIHByb3RlY3RlZCBhZGRFbXB0eVN0cmluZ09wdGlvbigpOiBib29sZWFuIHtcbiAgICAgICAgcmV0dXJuIHRoaXMuZmllbGQudHlwZSAhPT0gJ211bHRpZW51bSc7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGlzU2tpcEVtcHR5TW9kZSgpOiBib29sZWFuIHtcbiAgICAgICAgcmV0dXJuIHRoaXMubW9kZSA9PT0gJ21hc3N1cGRhdGUnIHx8IHRoaXMubW9kZSA9PT0gJ2ZpbHRlcic7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGluaXRWYWx1ZSgpOiB2b2lkIHtcblxuICAgICAgICB0aGlzLnNlbGVjdGVkVmFsdWVzID0gW107XG5cbiAgICAgICAgaWYgKHRoaXMuZmllbGQuY3JpdGVyaWEpIHtcbiAgICAgICAgICAgIHRoaXMuaW5pdFZhbHVlTGFiZWwoKTtcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuXG4gICAgICAgIGlmICh0eXBlb2YgdGhpcy5maWVsZC52YWx1ZSAhPT0gJ3N0cmluZycpIHtcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuXG4gICAgICAgIGlmICghdGhpcy5vcHRpb25zTWFwKSB7XG4gICAgICAgICAgICByZXR1cm47XG4gICAgICAgIH1cblxuICAgICAgICBpZiAodHlwZW9mIHRoaXMub3B0aW9uc01hcFt0aGlzLmZpZWxkLnZhbHVlXSAhPT0gJ3N0cmluZycpIHtcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuXG4gICAgICAgIHRoaXMuaW5pdFZhbHVlTGFiZWwoKTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgaW5pdFZhbHVlTGFiZWwoKSB7XG4gICAgICAgIGNvbnN0IGZpZWxkVmFsdWUgPSB0aGlzLmZpZWxkLnZhbHVlIHx8IHRoaXMuZmllbGQuY3JpdGVyaWE/LnRhcmdldCB8fCB1bmRlZmluZWQ7XG4gICAgICAgIGlmIChmaWVsZFZhbHVlICE9PSB1bmRlZmluZWQpIHtcbiAgICAgICAgICAgIHRoaXMudmFsdWVMYWJlbCA9IHRoaXMub3B0aW9uc01hcFtmaWVsZFZhbHVlXTtcbiAgICAgICAgICAgIHRoaXMuc2VsZWN0ZWRWYWx1ZXMucHVzaCh7XG4gICAgICAgICAgICAgICAgdmFsdWU6IGZpZWxkVmFsdWUsXG4gICAgICAgICAgICAgICAgbGFiZWw6IHRoaXMudmFsdWVMYWJlbFxuICAgICAgICAgICAgfSBhcyBPcHRpb24pO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogIEluaXRpYWxpemUgdGhlIGRlZmF1bHQgdmFsdWUgZm9yIHRoZSBlbnVtXG4gICAgICpcbiAgICAgKiAgQHJldHVybnMge3ZvaWR9XG4gICAgICogIEBkZXNjcmlwdGlvbiBzZXQgZGVmYXVsdCBlbnVtIHZhbHVlLCBpZiBkZWZpbmVkIGluIHZhcmRlZnNcbiAgICAgKiAqL1xuICAgIHByb3RlY3RlZCBpbml0RW51bURlZmF1bHQoKTogdm9pZCB7XG5cbiAgICAgICAgaWYgKCFpc0VtcHR5U3RyaW5nKHRoaXMucmVjb3JkPy5pZCkpIHtcbiAgICAgICAgICAgIHRoaXMuZmllbGQ/LmZvcm1Db250cm9sLnNldFZhbHVlKCcnKTtcblxuICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICB9XG5cbiAgICAgICAgbGV0IGRlZmF1bHRWYWwgPSB0aGlzPy5maWVsZD8uZGVmYXVsdCA/PyB0aGlzPy5maWVsZD8uZGVmaW5pdGlvbj8uZGVmYXVsdCA/PyBudWxsO1xuICAgICAgICBpZiAodHlwZW9mIGRlZmF1bHRWYWwgPT09ICdzdHJpbmcnKSB7XG4gICAgICAgICAgICBkZWZhdWx0VmFsID0gZGVmYXVsdFZhbC50cmltKCk7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKCFkZWZhdWx0VmFsKSB7XG4gICAgICAgICAgICB0aGlzLmZpZWxkLmZvcm1Db250cm9sLnNldFZhbHVlKCcnKTtcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuICAgICAgICB0aGlzLnNlbGVjdGVkVmFsdWVzLnB1c2goe1xuICAgICAgICAgICAgdmFsdWU6IGRlZmF1bHRWYWwsXG4gICAgICAgICAgICBsYWJlbDogdGhpcy5vcHRpb25zTWFwW2RlZmF1bHRWYWxdXG4gICAgICAgIH0gYXMgT3B0aW9uKTtcbiAgICAgICAgdGhpcy5pbml0RW51bURlZmF1bHRGaWVsZFZhbHVlcyhkZWZhdWx0VmFsKTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgaW5pdEVudW1EZWZhdWx0RmllbGRWYWx1ZXMoZGVmYXVsdFZhbDogc3RyaW5nKTogdm9pZCB7XG5cbiAgICAgICAgaWYgKHRoaXMuZmllbGQudHlwZSA9PT0gJ211bHRpZW51bScpIHtcbiAgICAgICAgICAgIGNvbnN0IGRlZmF1bHRWYWx1ZXMgPSB0aGlzLnNlbGVjdGVkVmFsdWVzLm1hcChvcHRpb24gPT4gb3B0aW9uLnZhbHVlKTtcbiAgICAgICAgICAgIHRoaXMuZmllbGQudmFsdWVMaXN0ID0gZGVmYXVsdFZhbHVlcztcbiAgICAgICAgICAgIHRoaXMuZmllbGQuZm9ybUNvbnRyb2wuc2V0VmFsdWUoZGVmYXVsdFZhbHVlcyk7XG5cbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIHRoaXMuZmllbGQudmFsdWUgPSBkZWZhdWx0VmFsO1xuICAgICAgICAgICAgdGhpcy5maWVsZC5mb3JtQ29udHJvbC5zZXRWYWx1ZShkZWZhdWx0VmFsKTtcbiAgICAgICAgfVxuICAgICAgICB0aGlzLmZpZWxkLmZvcm1Db250cm9sLm1hcmtBc0RpcnR5KCk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGNoZWNrQW5kSW5pdEFzRHluYW1pY0VudW0oKTogdm9pZCB7XG5cbiAgICAgICAgY29uc3QgZGVmaW5pdGlvbiA9ICh0aGlzLmZpZWxkICYmIHRoaXMuZmllbGQuZGVmaW5pdGlvbikgfHwge30gYXMgRmllbGREZWZpbml0aW9uO1xuICAgICAgICBjb25zdCBkeW5hbWljID0gKGRlZmluaXRpb24gJiYgZGVmaW5pdGlvbi5keW5hbWljKSB8fCBmYWxzZTtcbiAgICAgICAgY29uc3QgcGFyZW50RW51bUtleSA9IChkZWZpbml0aW9uICYmIGRlZmluaXRpb24ucGFyZW50ZW51bSkgfHwgJyc7XG4gICAgICAgIGNvbnN0IGZpZWxkcyA9ICh0aGlzLnJlY29yZCAmJiB0aGlzLnJlY29yZC5maWVsZHMpIHx8IG51bGw7XG5cbiAgICAgICAgaWYgKGR5bmFtaWMgJiYgcGFyZW50RW51bUtleSAmJiBmaWVsZHMpIHtcbiAgICAgICAgICAgIHRoaXMuaXNEeW5hbWljRW51bSA9IHRydWU7XG4gICAgICAgICAgICBjb25zdCBwYXJlbnRFbnVtOiBGaWVsZCA9IGZpZWxkc1twYXJlbnRFbnVtS2V5XTtcbiAgICAgICAgICAgIGlmIChwYXJlbnRFbnVtKSB7XG4gICAgICAgICAgICAgICAgdGhpcy5zdWJzY3JpYmVUb1BhcmVudFZhbHVlQ2hhbmdlcyhwYXJlbnRFbnVtKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgIH1cblxuICAgIHByb3RlY3RlZCBidWlsZER5bmFtaWNFbnVtT3B0aW9ucyhhcHBTdHJpbmdzOiBMYW5ndWFnZUxpc3RTdHJpbmdNYXApOiB2b2lkIHtcblxuICAgICAgICBjb25zdCBwYXJlbnRFbnVtID0gdGhpcy5yZWNvcmQuZmllbGRzW3RoaXMuZmllbGQuZGVmaW5pdGlvbi5wYXJlbnRlbnVtXTtcblxuICAgICAgICBpZiAocGFyZW50RW51bSkge1xuXG4gICAgICAgICAgICBjb25zdCBwYXJlbnRPcHRpb25NYXA6IExhbmd1YWdlU3RyaW5nTWFwID0gYXBwU3RyaW5nc1twYXJlbnRFbnVtLmRlZmluaXRpb24ub3B0aW9uc10gYXMgTGFuZ3VhZ2VTdHJpbmdNYXA7XG5cbiAgICAgICAgICAgIGlmIChwYXJlbnRPcHRpb25NYXAgJiYgT2JqZWN0LmtleXMocGFyZW50T3B0aW9uTWFwKS5sZW5ndGggIT09IDApIHtcblxuICAgICAgICAgICAgICAgIHRoaXMubWFwcGVkT3B0aW9ucyA9IHRoaXMuY3JlYXRlUGFyZW50Q2hpbGRPcHRpb25zTWFwKHBhcmVudE9wdGlvbk1hcCwgdGhpcy5vcHRpb25zKTtcblxuICAgICAgICAgICAgICAgIGxldCBwYXJlbnRWYWx1ZXM6IHN0cmluZ1tdID0gW107XG4gICAgICAgICAgICAgICAgaWYgKHBhcmVudEVudW0uZGVmaW5pdGlvbi50eXBlID09PSAnbXVsdGllbnVtJykge1xuICAgICAgICAgICAgICAgICAgICBwYXJlbnRWYWx1ZXMgPSBwYXJlbnRFbnVtLnZhbHVlTGlzdDtcbiAgICAgICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgICAgICBwYXJlbnRWYWx1ZXMucHVzaChwYXJlbnRFbnVtLnZhbHVlKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgdGhpcy5vcHRpb25zID0gdGhpcy5maWx0ZXJNYXRjaGluZ09wdGlvbnMocGFyZW50VmFsdWVzKTtcblxuICAgICAgICAgICAgICAgIGlmIChwYXJlbnRWYWx1ZXMgJiYgcGFyZW50VmFsdWVzLmxlbmd0aCkge1xuICAgICAgICAgICAgICAgICAgICB0aGlzLnNldFZhbHVlVG9BdmFpbGFibGVPcHRpb24oKTtcbiAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgIH1cblxuICAgIHByb3RlY3RlZCBmaWx0ZXJNYXRjaGluZ09wdGlvbnModmFsdWVzOiBzdHJpbmdbXSk6IE9wdGlvbltdIHtcblxuICAgICAgICBsZXQgZmlsdGVyZWRPcHRpb25zOiBPcHRpb25bXSA9IFtdO1xuXG4gICAgICAgIGlmICghdmFsdWVzIHx8ICF2YWx1ZXMubGVuZ3RoKSB7XG4gICAgICAgICAgICByZXR1cm4gW107XG4gICAgICAgIH1cblxuICAgICAgICB2YWx1ZXMuZm9yRWFjaCh2YWx1ZSA9PiB7XG4gICAgICAgICAgICBpZiAoIXRoaXMubWFwcGVkT3B0aW9uc1t2YWx1ZV0pIHtcbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBmaWx0ZXJlZE9wdGlvbnMgPSBmaWx0ZXJlZE9wdGlvbnMuY29uY2F0KFsuLi50aGlzLm1hcHBlZE9wdGlvbnNbdmFsdWVdXSk7XG4gICAgICAgIH0pO1xuXG4gICAgICAgIHJldHVybiBmaWx0ZXJlZE9wdGlvbnM7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGNyZWF0ZVBhcmVudENoaWxkT3B0aW9uc01hcChwYXJlbnRPcHRpb25zOiBMYW5ndWFnZVN0cmluZ01hcCwgY2hpbGRPcHRpb25zOiBPcHRpb25bXSk6IHsgW2tleTogc3RyaW5nXTogT3B0aW9uW10gfSB7XG4gICAgICAgIGNvbnN0IG1hcHBlZE9wdGlvbnM6IHsgW2tleTogc3RyaW5nXTogT3B0aW9uW10gfSA9IHt9O1xuICAgICAgICBPYmplY3Qua2V5cyhwYXJlbnRPcHRpb25zKS5mb3JFYWNoKGtleSA9PiB7XG4gICAgICAgICAgICBtYXBwZWRPcHRpb25zW2tleV0gPSBjaGlsZE9wdGlvbnMuZmlsdGVyKFxuICAgICAgICAgICAgICAgIG9wdGlvbiA9PiBTdHJpbmcob3B0aW9uLnZhbHVlKS5zdGFydHNXaXRoKGtleSlcbiAgICAgICAgICAgICk7XG4gICAgICAgIH0pO1xuICAgICAgICByZXR1cm4gbWFwcGVkT3B0aW9ucztcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgc3Vic2NyaWJlVG9QYXJlbnRWYWx1ZUNoYW5nZXMocGFyZW50RW51bTogRmllbGQpOiB2b2lkIHtcbiAgICAgICAgaWYgKHBhcmVudEVudW0uZm9ybUNvbnRyb2wpIHtcbiAgICAgICAgICAgIHRoaXMuc3Vicy5wdXNoKHBhcmVudEVudW0uZm9ybUNvbnRyb2wudmFsdWVDaGFuZ2VzLnN1YnNjcmliZSh2YWx1ZXMgPT4ge1xuXG4gICAgICAgICAgICAgICAgaWYgKHR5cGVvZiB2YWx1ZXMgPT09ICdzdHJpbmcnKSB7XG4gICAgICAgICAgICAgICAgICAgIHZhbHVlcyA9IFt2YWx1ZXNdO1xuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgIC8vIFJlYnVpbGQgYXZhaWxhYmxlIGVudW0gb3B0aW9uc1xuICAgICAgICAgICAgICAgIHRoaXMub3B0aW9ucyA9IHRoaXMuZmlsdGVyTWF0Y2hpbmdPcHRpb25zKHZhbHVlcyk7XG4gICAgICAgICAgICAgICAgdGhpcy5zZXRWYWx1ZVRvQXZhaWxhYmxlT3B0aW9uKCk7XG5cbiAgICAgICAgICAgICAgICB0aGlzLmluaXRWYWx1ZSgpO1xuICAgICAgICAgICAgfSkpO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIHNldFZhbHVlVG9BdmFpbGFibGVPcHRpb24oKTogdm9pZCB7XG4gICAgICAgIGlmICghdGhpcz8ub3B0aW9ucz8ubGVuZ3RoKSB7XG4gICAgICAgICAgICB0aGlzLmZpZWxkLnZhbHVlID0gJyc7XG4gICAgICAgICAgICB0aGlzLmZpZWxkLmZvcm1Db250cm9sLnNldFZhbHVlKCcnKTtcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuXG4gICAgICAgIGlmICghdGhpcy5vcHRpb25zLnNvbWUob3B0aW9uID0+IG9wdGlvbi52YWx1ZSA9PT0gdGhpcy5maWVsZC52YWx1ZSkpIHtcbiAgICAgICAgICAgIHRoaXMuZmllbGQudmFsdWUgPSB0aGlzLm9wdGlvbnNbMF0udmFsdWU7XG4gICAgICAgICAgICB0aGlzLmZpZWxkLmZvcm1Db250cm9sLnNldFZhbHVlKHRoaXMub3B0aW9uc1swXS52YWx1ZSk7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgYnVpbGRPcHRpb25Gcm9tVmFsdWUodmFsdWU6IHN0cmluZyk6IE9wdGlvbiB7XG4gICAgICAgIGNvbnN0IG9wdGlvbjogT3B0aW9uID0ge3ZhbHVlOiAnJywgbGFiZWw6ICcnfTtcblxuICAgICAgICBpZiAoaXNOdWxsKHZhbHVlKSkge1xuICAgICAgICAgICAgcmV0dXJuIG9wdGlvbjtcbiAgICAgICAgfVxuICAgICAgICBvcHRpb24udmFsdWUgPSAodHlwZW9mIHZhbHVlICE9PSAnc3RyaW5nJyA/IEpTT04uc3RyaW5naWZ5KHZhbHVlKSA6IHZhbHVlKS50cmltKCk7XG4gICAgICAgIG9wdGlvbi5sYWJlbCA9IG9wdGlvbi52YWx1ZTtcblxuICAgICAgICBjb25zdCB2YWx1ZUxhYmVsID0gdGhpcy5vcHRpb25zTWFwW29wdGlvbi52YWx1ZV0gPz8gb3B0aW9uLmxhYmVsO1xuICAgICAgICBpZiAoaXNPYmplY3QodmFsdWVMYWJlbCkpIHtcbiAgICAgICAgICAgIHJldHVybiBvcHRpb247XG4gICAgICAgIH1cbiAgICAgICAgb3B0aW9uLmxhYmVsID0gKHR5cGVvZiB2YWx1ZUxhYmVsICE9PSAnc3RyaW5nJyA/IEpTT04uc3RyaW5naWZ5KHZhbHVlTGFiZWwpIDogdmFsdWVMYWJlbCkudHJpbSgpO1xuXG4gICAgICAgIHJldHVybiBvcHRpb247XG4gICAgfVxuXG59XG4iXX0=