/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Injectable } from '@angular/core';
import { DataTypeFormatter } from '../formatters/data-type.formatter.service';
import { isVoid } from 'common';
import { LanguageStore } from '../../store/language/language.store';
import get from 'lodash-es/get';
import { SystemConfigStore } from '../../store/system-config/system-config.store';
import { UserPreferenceStore } from '../../store/user-preference/user-preference.store';
import * as i0 from "@angular/core";
import * as i1 from "../formatters/data-type.formatter.service";
import * as i2 from "../../store/language/language.store";
import * as i3 from "../../store/system-config/system-config.store";
import * as i4 from "../../store/user-preference/user-preference.store";
class DynamicLabelService {
    constructor(typeFormatter, language, configs, preferences) {
        this.typeFormatter = typeFormatter;
        this.language = language;
        this.configs = configs;
        this.preferences = preferences;
        this.valuePipes = {};
        this.fieldPipes = {};
        this.valuePipes.int = (value) => this.valueTypeFormat('int', value);
        this.valuePipes.float = (value) => this.valueTypeFormat('float', value);
        this.valuePipes.date = (value) => this.valueTypeFormat('date', value);
        this.valuePipes.datetime = (value) => this.valueTypeFormat('datetime', value);
        this.valuePipes.currency = (value) => this.valueTypeFormat('currency', value);
        this.valuePipes.enum = (value, filterArguments = []) => this.enumFormat(value, filterArguments);
        this.fieldPipes.int = (value) => this.fieldTypeFormat('int', value);
        this.fieldPipes.float = (value) => this.fieldTypeFormat('float', value);
        this.fieldPipes.date = (value) => this.fieldTypeFormat('date', value);
        this.fieldPipes.datetime = (value) => this.fieldTypeFormat('datetime', value);
        this.fieldPipes.currency = (value) => this.fieldTypeFormat('currency', value);
        this.fieldPipes.phone = (value) => this.fieldTypeFormat('phone', value);
        this.fieldPipes.enum = (value) => this.enumFieldFormat(value);
        this.fieldPipes.dynamicenum = (value) => this.enumFieldFormat(value);
        this.fieldPipes.multienum = (value) => this.multiEnumFormat(value);
    }
    addValuePipe(name, processor) {
        this.valuePipes[name] = processor;
    }
    addFieldPipe(name, processor) {
        this.fieldPipes[name] = processor;
    }
    parse(template, context, fields) {
        if (!template) {
            return template;
        }
        const regex = /({{[\s\S]+?}})/g;
        const matches = template.match(regex);
        if (!matches || matches.length < 1) {
            return template;
        }
        let parsedTemplate = template;
        const module = (context && context.module) || '';
        matches.forEach((regexMatch) => {
            if (!parsedTemplate.includes(regexMatch)) {
                return;
            }
            let filter = '';
            let filterArguments = [];
            let value = '';
            let source = 'context';
            let parts = [];
            let variableName = '' + regexMatch;
            variableName = variableName.replace('{{', '');
            variableName = variableName.replace('}}', '');
            variableName = variableName.trim();
            let path = variableName;
            if (variableName.includes('|')) {
                const [name, pipe, ...others] = variableName.split('|');
                filter = pipe.trim();
                if (pipe.trim().includes(':')) {
                    let [filterType, ...filterArgs] = pipe.trim().split(':');
                    filter = filterType.trim();
                    filterArguments = filterArgs;
                }
                variableName = name.trim();
                path = name.trim();
            }
            if (variableName.includes('.')) {
                parts = variableName.split('.');
                source = parts[0];
                variableName = parts[1];
            }
            let sourceValues = context;
            if (source === 'fields') {
                sourceValues = fields;
            }
            if (source === 'fields') {
                if (!sourceValues || !(variableName in sourceValues)) {
                    parsedTemplate = parsedTemplate.replace(regexMatch, value);
                    return;
                }
                const field = fields[variableName];
                if (!field) {
                    parsedTemplate = parsedTemplate.replace(regexMatch, '');
                    return;
                }
                if (parts[2] && parts[2] === 'value' && field.type in this.fieldPipes) {
                    value = this.fieldPipes[field.type](field);
                    parsedTemplate = parsedTemplate.replace(regexMatch, value);
                    return;
                }
                if (parts[2] && parts[2] === 'label') {
                    value = this.getFieldLabel(field.labelKey, module);
                    parsedTemplate = parsedTemplate.replace(regexMatch, value);
                    return;
                }
                value = get({ fields }, path, '');
                parsedTemplate = parsedTemplate.replace(regexMatch, value);
                return;
            }
            if (source === 'config') {
                parsedTemplate = this.parseObjectContext(variableName, parsedTemplate, regexMatch, filter, filterArguments, (key) => {
                    return this.configs.getConfigValue(key);
                });
                return;
            }
            if (source === 'preferences') {
                parsedTemplate = this.parseObjectContext(variableName, parsedTemplate, regexMatch, filter, filterArguments, (key) => {
                    return this.preferences.getUserPreference(key);
                });
                return;
            }
            if (!sourceValues || !(variableName in sourceValues)) {
                parsedTemplate = parsedTemplate.replace(regexMatch, value);
                return;
            }
            value = get({ context }, path, '');
            if (filter in this.valuePipes) {
                value = this.valuePipes[filter](value);
            }
            parsedTemplate = parsedTemplate.replace(regexMatch, value);
        });
        return parsedTemplate;
    }
    valueTypeFormat(type, value) {
        return this.typeFormatter.toUserFormat(type, value);
    }
    enumFormat(value, filterArguments) {
        const options = filterArguments[0] ?? '';
        if (!options || !value) {
            return '';
        }
        return this.language.getListLabel(options, value);
    }
    fieldTypeFormat(type, field) {
        return this.typeFormatter.toUserFormat(type, field.value);
    }
    enumFieldFormat(field) {
        if (isVoid(field.definition.options) || isVoid(field.value)) {
            return '';
        }
        return this.language.getListLabel(field.definition.options, field.value);
    }
    multiEnumFormat(field) {
        if (isVoid(field.definition.options) || isVoid(field.valueList) || field.valueList.length < 1) {
            return '';
        }
        const result = [];
        field.valueList.forEach(value => {
            if (isVoid(value)) {
                return;
            }
            result.push(this.language.getListLabel(field.definition.options, value));
        });
        return result.join(', ');
    }
    getFieldLabel(labelKey, module = '') {
        if (isVoid(labelKey)) {
            return '';
        }
        return this.language.getFieldLabel(labelKey, module);
    }
    parseObjectContext(variableName, parsedTemplate, regexMatch, filter, filterArguments, getter) {
        let entryKey = variableName;
        if (variableName.includes('.')) {
            let [key, ...others] = variableName.split('.');
            entryKey = key;
        }
        let value = getter(entryKey);
        if (variableName.includes('.') && typeof value === 'object') {
            value = get({ value }, variableName, '');
        }
        if (!value || typeof value === 'object') {
            return parsedTemplate.replace(regexMatch, '');
        }
        if (filter in this.valuePipes) {
            value = this.valuePipes[filter](value, filterArguments);
        }
        return parsedTemplate.replace(regexMatch, value);
    }
    static { this.ɵfac = function DynamicLabelService_Factory(t) { return new (t || DynamicLabelService)(i0.ɵɵinject(i1.DataTypeFormatter), i0.ɵɵinject(i2.LanguageStore), i0.ɵɵinject(i3.SystemConfigStore), i0.ɵɵinject(i4.UserPreferenceStore)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: DynamicLabelService, factory: DynamicLabelService.ɵfac, providedIn: 'root' }); }
}
export { DynamicLabelService };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DynamicLabelService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i1.DataTypeFormatter }, { type: i2.LanguageStore }, { type: i3.SystemConfigStore }, { type: i4.UserPreferenceStore }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZHluYW1pYy1sYWJlbC5zZXJ2aWNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vY29yZS9hcHAvY29yZS9zcmMvbGliL3NlcnZpY2VzL2xhbmd1YWdlL2R5bmFtaWMtbGFiZWwuc2VydmljZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBd0JHO0FBRUgsT0FBTyxFQUFDLFVBQVUsRUFBQyxNQUFNLGVBQWUsQ0FBQztBQUN6QyxPQUFPLEVBQUMsaUJBQWlCLEVBQUMsTUFBTSwyQ0FBMkMsQ0FBQztBQUM1RSxPQUFPLEVBQWtCLE1BQU0sRUFBWSxNQUFNLFFBQVEsQ0FBQztBQUMxRCxPQUFPLEVBQUMsYUFBYSxFQUFDLE1BQU0scUNBQXFDLENBQUM7QUFDbEUsT0FBTyxHQUFHLE1BQU0sZUFBZSxDQUFDO0FBQ2hDLE9BQU8sRUFBQyxpQkFBaUIsRUFBQyxNQUFNLCtDQUErQyxDQUFDO0FBQ2hGLE9BQU8sRUFBQyxtQkFBbUIsRUFBQyxNQUFNLG1EQUFtRCxDQUFDOzs7Ozs7QUFzQnRGLE1BR2EsbUJBQW1CO0lBSTVCLFlBQ2MsYUFBZ0MsRUFDaEMsUUFBdUIsRUFDdkIsT0FBMEIsRUFDMUIsV0FBZ0M7UUFIaEMsa0JBQWEsR0FBYixhQUFhLENBQW1CO1FBQ2hDLGFBQVEsR0FBUixRQUFRLENBQWU7UUFDdkIsWUFBTyxHQUFQLE9BQU8sQ0FBbUI7UUFDMUIsZ0JBQVcsR0FBWCxXQUFXLENBQXFCO1FBUHBDLGVBQVUsR0FBMkIsRUFBRSxDQUFDO1FBQ3hDLGVBQVUsR0FBMkIsRUFBRSxDQUFDO1FBUzlDLElBQUksQ0FBQyxVQUFVLENBQUMsR0FBRyxHQUFHLENBQUMsS0FBYSxFQUFVLEVBQUUsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUssR0FBRyxDQUFDLEtBQWEsRUFBVSxFQUFFLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxPQUFPLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDeEYsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxLQUFhLEVBQVUsRUFBRSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsTUFBTSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBQ3RGLElBQUksQ0FBQyxVQUFVLENBQUMsUUFBUSxHQUFHLENBQUMsS0FBYSxFQUFVLEVBQUUsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLFVBQVUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUM5RixJQUFJLENBQUMsVUFBVSxDQUFDLFFBQVEsR0FBRyxDQUFDLEtBQWEsRUFBVSxFQUFFLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxVQUFVLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDOUYsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxLQUFhLEVBQUUsa0JBQTRCLEVBQUUsRUFBVSxFQUFFLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxLQUFLLEVBQUUsZUFBZSxDQUFDLENBQUM7UUFFMUgsSUFBSSxDQUFDLFVBQVUsQ0FBQyxHQUFHLEdBQUcsQ0FBQyxLQUFZLEVBQVUsRUFBRSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBQ25GLElBQUksQ0FBQyxVQUFVLENBQUMsS0FBSyxHQUFHLENBQUMsS0FBWSxFQUFVLEVBQUUsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLE9BQU8sRUFBRSxLQUFLLENBQUMsQ0FBQztRQUN2RixJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksR0FBRyxDQUFDLEtBQVksRUFBVSxFQUFFLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxNQUFNLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDckYsSUFBSSxDQUFDLFVBQVUsQ0FBQyxRQUFRLEdBQUcsQ0FBQyxLQUFZLEVBQVUsRUFBRSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsVUFBVSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBQzdGLElBQUksQ0FBQyxVQUFVLENBQUMsUUFBUSxHQUFHLENBQUMsS0FBWSxFQUFVLEVBQUUsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLFVBQVUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUM3RixJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUssR0FBRyxDQUFDLEtBQVksRUFBVSxFQUFFLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxPQUFPLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDdkYsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxLQUFZLEVBQVUsRUFBRSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDN0UsSUFBSSxDQUFDLFVBQVUsQ0FBQyxXQUFXLEdBQUcsQ0FBQyxLQUFZLEVBQVUsRUFBRSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDcEYsSUFBSSxDQUFDLFVBQVUsQ0FBQyxTQUFTLEdBQUcsQ0FBQyxLQUFZLEVBQVUsRUFBRSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDdEYsQ0FBQztJQUVELFlBQVksQ0FBQyxJQUFZLEVBQUUsU0FBOEI7UUFDckQsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsR0FBRyxTQUFTLENBQUM7SUFDdEMsQ0FBQztJQUVELFlBQVksQ0FBQyxJQUFZLEVBQUUsU0FBOEI7UUFDckQsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsR0FBRyxTQUFTLENBQUM7SUFDdEMsQ0FBQztJQUVELEtBQUssQ0FBQyxRQUFnQixFQUFFLE9BQWtCLEVBQUUsTUFBZ0I7UUFFeEQsSUFBSSxDQUFDLFFBQVEsRUFBRTtZQUNYLE9BQU8sUUFBUSxDQUFDO1NBQ25CO1FBRUQsTUFBTSxLQUFLLEdBQUcsaUJBQWlCLENBQUM7UUFFaEMsTUFBTSxPQUFPLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUV0QyxJQUFJLENBQUMsT0FBTyxJQUFJLE9BQU8sQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFO1lBQ2hDLE9BQU8sUUFBUSxDQUFDO1NBQ25CO1FBRUQsSUFBSSxjQUFjLEdBQUcsUUFBUSxDQUFDO1FBRTlCLE1BQU0sTUFBTSxHQUFHLENBQUMsT0FBTyxJQUFJLE9BQU8sQ0FBQyxNQUFNLENBQUMsSUFBSSxFQUFFLENBQUM7UUFFakQsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLFVBQVUsRUFBRSxFQUFFO1lBRTNCLElBQUksQ0FBQyxjQUFjLENBQUMsUUFBUSxDQUFDLFVBQVUsQ0FBQyxFQUFFO2dCQUN0QyxPQUFPO2FBQ1Y7WUFFRCxJQUFJLE1BQU0sR0FBRyxFQUFFLENBQUM7WUFDaEIsSUFBSSxlQUFlLEdBQUcsRUFBRSxDQUFDO1lBQ3pCLElBQUksS0FBSyxHQUFHLEVBQUUsQ0FBQztZQUNmLElBQUksTUFBTSxHQUFHLFNBQVMsQ0FBQztZQUN2QixJQUFJLEtBQUssR0FBRyxFQUFFLENBQUM7WUFFZixJQUFJLFlBQVksR0FBRyxFQUFFLEdBQUcsVUFBVSxDQUFDO1lBQ25DLFlBQVksR0FBRyxZQUFZLENBQUMsT0FBTyxDQUFDLElBQUksRUFBRSxFQUFFLENBQUMsQ0FBQztZQUM5QyxZQUFZLEdBQUcsWUFBWSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEVBQUUsRUFBRSxDQUFDLENBQUM7WUFDOUMsWUFBWSxHQUFHLFlBQVksQ0FBQyxJQUFJLEVBQUUsQ0FBQztZQUVuQyxJQUFJLElBQUksR0FBRyxZQUFZLENBQUM7WUFFeEIsSUFBSSxZQUFZLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxFQUFFO2dCQUM1QixNQUFNLENBQUMsSUFBSSxFQUFFLElBQUksRUFBRSxHQUFHLE1BQU0sQ0FBQyxHQUFHLFlBQVksQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7Z0JBQ3hELE1BQU0sR0FBRyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7Z0JBRXJCLElBQUksSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsRUFBRTtvQkFDM0IsSUFBRyxDQUFDLFVBQVUsRUFBRSxHQUFHLFVBQVUsQ0FBQyxHQUFHLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7b0JBQ3hELE1BQU0sR0FBRyxVQUFVLENBQUMsSUFBSSxFQUFFLENBQUM7b0JBQzNCLGVBQWUsR0FBRyxVQUFVLENBQUM7aUJBQ2hDO2dCQUVELFlBQVksR0FBRyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7Z0JBQzNCLElBQUksR0FBRyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7YUFDdEI7WUFFRCxJQUFJLFlBQVksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLEVBQUU7Z0JBQzVCLEtBQUssR0FBRyxZQUFZLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO2dCQUNoQyxNQUFNLEdBQUcsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDO2dCQUNsQixZQUFZLEdBQUcsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDO2FBQzNCO1lBR0QsSUFBSSxZQUFZLEdBQXNDLE9BQU8sQ0FBQztZQUM5RCxJQUFJLE1BQU0sS0FBSyxRQUFRLEVBQUU7Z0JBQ3JCLFlBQVksR0FBRyxNQUFNLENBQUM7YUFDekI7WUFFRCxJQUFJLE1BQU0sS0FBSyxRQUFRLEVBQUU7Z0JBRXJCLElBQUksQ0FBQyxZQUFZLElBQUksQ0FBQyxDQUFDLFlBQVksSUFBSSxZQUFZLENBQUMsRUFBRTtvQkFDbEQsY0FBYyxHQUFHLGNBQWMsQ0FBQyxPQUFPLENBQUMsVUFBVSxFQUFFLEtBQUssQ0FBQyxDQUFDO29CQUMzRCxPQUFPO2lCQUNWO2dCQUVELE1BQU0sS0FBSyxHQUFHLE1BQU0sQ0FBQyxZQUFZLENBQUMsQ0FBQztnQkFFbkMsSUFBSSxDQUFDLEtBQUssRUFBRTtvQkFDUixjQUFjLEdBQUcsY0FBYyxDQUFDLE9BQU8sQ0FBQyxVQUFVLEVBQUUsRUFBRSxDQUFDLENBQUM7b0JBQ3hELE9BQU87aUJBQ1Y7Z0JBRUQsSUFBSSxLQUFLLENBQUMsQ0FBQyxDQUFDLElBQUksS0FBSyxDQUFDLENBQUMsQ0FBQyxLQUFLLE9BQU8sSUFBSSxLQUFLLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxVQUFVLEVBQUU7b0JBQ25FLEtBQUssR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDM0MsY0FBYyxHQUFHLGNBQWMsQ0FBQyxPQUFPLENBQUMsVUFBVSxFQUFFLEtBQUssQ0FBQyxDQUFDO29CQUMzRCxPQUFPO2lCQUNWO2dCQUVELElBQUksS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLEtBQUssQ0FBQyxDQUFDLENBQUMsS0FBSyxPQUFPLEVBQUU7b0JBQ2xDLEtBQUssR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxRQUFRLEVBQUUsTUFBTSxDQUFDLENBQUM7b0JBQ25ELGNBQWMsR0FBRyxjQUFjLENBQUMsT0FBTyxDQUFDLFVBQVUsRUFBRSxLQUFLLENBQUMsQ0FBQztvQkFDM0QsT0FBTztpQkFDVjtnQkFFRCxLQUFLLEdBQUcsR0FBRyxDQUFDLEVBQUMsTUFBTSxFQUFDLEVBQUUsSUFBSSxFQUFFLEVBQUUsQ0FBQyxDQUFDO2dCQUVoQyxjQUFjLEdBQUcsY0FBYyxDQUFDLE9BQU8sQ0FBQyxVQUFVLEVBQUUsS0FBSyxDQUFDLENBQUM7Z0JBQzNELE9BQU87YUFDVjtZQUVELElBQUksTUFBTSxLQUFLLFFBQVEsRUFBRTtnQkFDckIsY0FBYyxHQUFHLElBQUksQ0FBQyxrQkFBa0IsQ0FDcEMsWUFBWSxFQUNaLGNBQWMsRUFDZCxVQUFVLEVBQ1YsTUFBTSxFQUNOLGVBQWUsRUFDZixDQUFDLEdBQVcsRUFBTyxFQUFFO29CQUNqQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsY0FBYyxDQUFDLEdBQUcsQ0FBQyxDQUFDO2dCQUM1QyxDQUFDLENBQ0osQ0FBQztnQkFDRixPQUFPO2FBQ1Y7WUFFRCxJQUFJLE1BQU0sS0FBSyxhQUFhLEVBQUU7Z0JBQzFCLGNBQWMsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQ3BDLFlBQVksRUFDWixjQUFjLEVBQ2QsVUFBVSxFQUNWLE1BQU0sRUFDTixlQUFlLEVBQ2YsQ0FBQyxHQUFXLEVBQU8sRUFBRTtvQkFDakIsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDLGlCQUFpQixDQUFDLEdBQUcsQ0FBQyxDQUFDO2dCQUNuRCxDQUFDLENBQ0osQ0FBQztnQkFDRixPQUFPO2FBQ1Y7WUFFRCxJQUFJLENBQUMsWUFBWSxJQUFJLENBQUMsQ0FBQyxZQUFZLElBQUksWUFBWSxDQUFDLEVBQUU7Z0JBQ2xELGNBQWMsR0FBRyxjQUFjLENBQUMsT0FBTyxDQUFDLFVBQVUsRUFBRSxLQUFLLENBQUMsQ0FBQztnQkFDM0QsT0FBTzthQUNWO1lBRUQsS0FBSyxHQUFHLEdBQUcsQ0FBQyxFQUFDLE9BQU8sRUFBQyxFQUFFLElBQUksRUFBRSxFQUFFLENBQUMsQ0FBQztZQUVqQyxJQUFJLE1BQU0sSUFBSSxJQUFJLENBQUMsVUFBVSxFQUFFO2dCQUMzQixLQUFLLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQzthQUMxQztZQUVELGNBQWMsR0FBRyxjQUFjLENBQUMsT0FBTyxDQUFDLFVBQVUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUMvRCxDQUFDLENBQUMsQ0FBQztRQUVILE9BQU8sY0FBYyxDQUFDO0lBQzFCLENBQUM7SUFFUyxlQUFlLENBQUMsSUFBWSxFQUFFLEtBQWE7UUFDakQsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLFlBQVksQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDeEQsQ0FBQztJQUVTLFVBQVUsQ0FBQyxLQUFhLEVBQUUsZUFBMEI7UUFDMUQsTUFBTSxPQUFPLEdBQUcsZUFBZSxDQUFDLENBQUMsQ0FBQyxJQUFJLEVBQUUsQ0FBQztRQUN6QyxJQUFJLENBQUMsT0FBTyxJQUFJLENBQUMsS0FBSyxFQUFFO1lBQ3BCLE9BQU8sRUFBRSxDQUFDO1NBQ2I7UUFFRCxPQUFPLElBQUksQ0FBQyxRQUFRLENBQUMsWUFBWSxDQUFDLE9BQU8sRUFBRSxLQUFLLENBQUMsQ0FBQztJQUN0RCxDQUFDO0lBRVMsZUFBZSxDQUFDLElBQVksRUFBRSxLQUFZO1FBQ2hELE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQyxZQUFZLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUM5RCxDQUFDO0lBRVMsZUFBZSxDQUFDLEtBQVk7UUFDbEMsSUFBSSxNQUFNLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsSUFBSSxNQUFNLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQ3pELE9BQU8sRUFBRSxDQUFDO1NBQ2I7UUFFRCxPQUFPLElBQUksQ0FBQyxRQUFRLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsT0FBTyxFQUFFLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUM3RSxDQUFDO0lBRVMsZUFBZSxDQUFDLEtBQVk7UUFDbEMsSUFBSSxNQUFNLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsSUFBSSxNQUFNLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxJQUFJLEtBQUssQ0FBQyxTQUFTLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTtZQUMzRixPQUFPLEVBQUUsQ0FBQztTQUNiO1FBRUQsTUFBTSxNQUFNLEdBQWEsRUFBRSxDQUFDO1FBRTVCLEtBQUssQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQzVCLElBQUksTUFBTSxDQUFDLEtBQUssQ0FBQyxFQUFFO2dCQUNmLE9BQU87YUFDVjtZQUVELE1BQU0sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxPQUFPLEVBQUUsS0FBSyxDQUFDLENBQUMsQ0FBQztRQUM3RSxDQUFDLENBQUMsQ0FBQztRQUVILE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUM3QixDQUFDO0lBRVMsYUFBYSxDQUFDLFFBQWdCLEVBQUUsTUFBTSxHQUFHLEVBQUU7UUFDakQsSUFBSSxNQUFNLENBQUMsUUFBUSxDQUFDLEVBQUU7WUFDbEIsT0FBTyxFQUFFLENBQUM7U0FDYjtRQUVELE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxhQUFhLENBQUMsUUFBUSxFQUFFLE1BQU0sQ0FBQyxDQUFDO0lBQ3pELENBQUM7SUFFUyxrQkFBa0IsQ0FBQyxZQUFvQixFQUFFLGNBQXNCLEVBQUUsVUFBa0IsRUFBRSxNQUFjLEVBQUUsZUFBeUIsRUFBRSxNQUE0QjtRQUNsSyxJQUFJLFFBQVEsR0FBRyxZQUFZLENBQUM7UUFDNUIsSUFBSSxZQUFZLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxFQUFFO1lBQzVCLElBQUksQ0FBQyxHQUFHLEVBQUUsR0FBRyxNQUFNLENBQUMsR0FBRyxZQUFZLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBQy9DLFFBQVEsR0FBRyxHQUFHLENBQUM7U0FDbEI7UUFFRCxJQUFJLEtBQUssR0FBRyxNQUFNLENBQUMsUUFBUSxDQUFDLENBQUM7UUFFN0IsSUFBSSxZQUFZLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxJQUFJLE9BQU8sS0FBSyxLQUFLLFFBQVEsRUFBRTtZQUN6RCxLQUFLLEdBQUcsR0FBRyxDQUFDLEVBQUMsS0FBSyxFQUFDLEVBQUUsWUFBWSxFQUFFLEVBQUUsQ0FBQyxDQUFDO1NBQzFDO1FBRUQsSUFBSSxDQUFDLEtBQUssSUFBSSxPQUFPLEtBQUssS0FBSyxRQUFRLEVBQUU7WUFDckMsT0FBTyxjQUFjLENBQUMsT0FBTyxDQUFDLFVBQVUsRUFBRSxFQUFFLENBQUMsQ0FBQztTQUNqRDtRQUVELElBQUksTUFBTSxJQUFJLElBQUksQ0FBQyxVQUFVLEVBQUU7WUFDM0IsS0FBSyxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLENBQUMsS0FBSyxFQUFFLGVBQWUsQ0FBQyxDQUFDO1NBQzNEO1FBRUQsT0FBTyxjQUFjLENBQUMsT0FBTyxDQUFDLFVBQVUsRUFBRSxLQUFLLENBQUMsQ0FBQztJQUNyRCxDQUFDO29GQTFQUSxtQkFBbUI7dUVBQW5CLG1CQUFtQixXQUFuQixtQkFBbUIsbUJBRmhCLE1BQU07O1NBRVQsbUJBQW1CO3VGQUFuQixtQkFBbUI7Y0FIL0IsVUFBVTtlQUFDO2dCQUNSLFVBQVUsRUFBRSxNQUFNO2FBQ3JCIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBTdWl0ZUNSTSBpcyBhIGN1c3RvbWVyIHJlbGF0aW9uc2hpcCBtYW5hZ2VtZW50IHByb2dyYW0gZGV2ZWxvcGVkIGJ5IFNhbGVzQWdpbGl0eSBMdGQuXG4gKiBDb3B5cmlnaHQgKEMpIDIwMjEgU2FsZXNBZ2lsaXR5IEx0ZC5cbiAqXG4gKiBUaGlzIHByb2dyYW0gaXMgZnJlZSBzb2Z0d2FyZTsgeW91IGNhbiByZWRpc3RyaWJ1dGUgaXQgYW5kL29yIG1vZGlmeSBpdCB1bmRlclxuICogdGhlIHRlcm1zIG9mIHRoZSBHTlUgQWZmZXJvIEdlbmVyYWwgUHVibGljIExpY2Vuc2UgdmVyc2lvbiAzIGFzIHB1Ymxpc2hlZCBieSB0aGVcbiAqIEZyZWUgU29mdHdhcmUgRm91bmRhdGlvbiB3aXRoIHRoZSBhZGRpdGlvbiBvZiB0aGUgZm9sbG93aW5nIHBlcm1pc3Npb24gYWRkZWRcbiAqIHRvIFNlY3Rpb24gMTUgYXMgcGVybWl0dGVkIGluIFNlY3Rpb24gNyhhKTogRk9SIEFOWSBQQVJUIE9GIFRIRSBDT1ZFUkVEIFdPUktcbiAqIElOIFdISUNIIFRIRSBDT1BZUklHSFQgSVMgT1dORUQgQlkgU0FMRVNBR0lMSVRZLCBTQUxFU0FHSUxJVFkgRElTQ0xBSU1TIFRIRVxuICogV0FSUkFOVFkgT0YgTk9OIElORlJJTkdFTUVOVCBPRiBUSElSRCBQQVJUWSBSSUdIVFMuXG4gKlxuICogVGhpcyBwcm9ncmFtIGlzIGRpc3RyaWJ1dGVkIGluIHRoZSBob3BlIHRoYXQgaXQgd2lsbCBiZSB1c2VmdWwsIGJ1dCBXSVRIT1VUXG4gKiBBTlkgV0FSUkFOVFk7IHdpdGhvdXQgZXZlbiB0aGUgaW1wbGllZCB3YXJyYW50eSBvZiBNRVJDSEFOVEFCSUxJVFkgb3IgRklUTkVTU1xuICogRk9SIEEgUEFSVElDVUxBUiBQVVJQT1NFLiBTZWUgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZSBmb3IgbW9yZVxuICogZGV0YWlscy5cbiAqXG4gKiBZb3Ugc2hvdWxkIGhhdmUgcmVjZWl2ZWQgYSBjb3B5IG9mIHRoZSBHTlUgQWZmZXJvIEdlbmVyYWwgUHVibGljIExpY2Vuc2VcbiAqIGFsb25nIHdpdGggdGhpcyBwcm9ncmFtLiAgSWYgbm90LCBzZWUgPGh0dHA6Ly93d3cuZ251Lm9yZy9saWNlbnNlcy8+LlxuICpcbiAqIEluIGFjY29yZGFuY2Ugd2l0aCBTZWN0aW9uIDcoYikgb2YgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZVxuICogdmVyc2lvbiAzLCB0aGVzZSBBcHByb3ByaWF0ZSBMZWdhbCBOb3RpY2VzIG11c3QgcmV0YWluIHRoZSBkaXNwbGF5IG9mIHRoZVxuICogXCJTdXBlcmNoYXJnZWQgYnkgU3VpdGVDUk1cIiBsb2dvLiBJZiB0aGUgZGlzcGxheSBvZiB0aGUgbG9nb3MgaXMgbm90IHJlYXNvbmFibHlcbiAqIGZlYXNpYmxlIGZvciB0ZWNobmljYWwgcmVhc29ucywgdGhlIEFwcHJvcHJpYXRlIExlZ2FsIE5vdGljZXMgbXVzdCBkaXNwbGF5XG4gKiB0aGUgd29yZHMgXCJTdXBlcmNoYXJnZWQgYnkgU3VpdGVDUk1cIi5cbiAqL1xuXG5pbXBvcnQge0luamVjdGFibGV9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHtEYXRhVHlwZUZvcm1hdHRlcn0gZnJvbSAnLi4vZm9ybWF0dGVycy9kYXRhLXR5cGUuZm9ybWF0dGVyLnNlcnZpY2UnO1xuaW1wb3J0IHtGaWVsZCwgRmllbGRNYXAsIGlzVm9pZCwgU3RyaW5nTWFwfSBmcm9tICdjb21tb24nO1xuaW1wb3J0IHtMYW5ndWFnZVN0b3JlfSBmcm9tICcuLi8uLi9zdG9yZS9sYW5ndWFnZS9sYW5ndWFnZS5zdG9yZSc7XG5pbXBvcnQgZ2V0IGZyb20gJ2xvZGFzaC1lcy9nZXQnO1xuaW1wb3J0IHtTeXN0ZW1Db25maWdTdG9yZX0gZnJvbSAnLi4vLi4vc3RvcmUvc3lzdGVtLWNvbmZpZy9zeXN0ZW0tY29uZmlnLnN0b3JlJztcbmltcG9ydCB7VXNlclByZWZlcmVuY2VTdG9yZX0gZnJvbSAnLi4vLi4vc3RvcmUvdXNlci1wcmVmZXJlbmNlL3VzZXItcHJlZmVyZW5jZS5zdG9yZSc7XG5cblxuZXhwb3J0IGRlY2xhcmUgdHlwZSBUZW1wbGF0ZVZhbHVlRmlsdGVyID0gKHZhbHVlOiBzdHJpbmcsIGZpbHRlckFyZ3VtZW50cz86IHN0cmluZ1tdKSA9PiBzdHJpbmc7XG5leHBvcnQgZGVjbGFyZSB0eXBlIFRlbXBsYXRlRmllbGRGaWx0ZXIgPSAodmFsdWU6IEZpZWxkKSA9PiBzdHJpbmc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgVGVtcGxhdGVWYWx1ZUZpbHRlck1hcCB7XG4gICAgW2tleTogc3RyaW5nXTogVGVtcGxhdGVWYWx1ZUZpbHRlcjtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBUZW1wbGF0ZUZpZWxkRmlsdGVyTWFwIHtcbiAgICBba2V5OiBzdHJpbmddOiBUZW1wbGF0ZUZpZWxkRmlsdGVyO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIER5bmFtaWNMYWJlbFNlcnZpY2VJbnRlcmZhY2Uge1xuICAgIGFkZFZhbHVlUGlwZShuYW1lOiBzdHJpbmcsIHByb2Nlc3NvcjogVGVtcGxhdGVWYWx1ZUZpbHRlcik6IHZvaWQ7XG5cbiAgICBhZGRGaWVsZFBpcGUobmFtZTogc3RyaW5nLCBwcm9jZXNzb3I6IFRlbXBsYXRlRmllbGRGaWx0ZXIpOiB2b2lkO1xuXG4gICAgcGFyc2UodGVtcGxhdGU6IHN0cmluZywgY29udGV4dDogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfSwgZmllbGRzOiBGaWVsZE1hcCk6IHN0cmluZztcbn1cblxuQEluamVjdGFibGUoe1xuICAgIHByb3ZpZGVkSW46ICdyb290J1xufSlcbmV4cG9ydCBjbGFzcyBEeW5hbWljTGFiZWxTZXJ2aWNlIGltcGxlbWVudHMgRHluYW1pY0xhYmVsU2VydmljZUludGVyZmFjZSB7XG4gICAgcHJvdGVjdGVkIHZhbHVlUGlwZXM6IFRlbXBsYXRlVmFsdWVGaWx0ZXJNYXAgPSB7fTtcbiAgICBwcm90ZWN0ZWQgZmllbGRQaXBlczogVGVtcGxhdGVGaWVsZEZpbHRlck1hcCA9IHt9O1xuXG4gICAgY29uc3RydWN0b3IoXG4gICAgICAgIHByb3RlY3RlZCB0eXBlRm9ybWF0dGVyOiBEYXRhVHlwZUZvcm1hdHRlcixcbiAgICAgICAgcHJvdGVjdGVkIGxhbmd1YWdlOiBMYW5ndWFnZVN0b3JlLFxuICAgICAgICBwcm90ZWN0ZWQgY29uZmlnczogU3lzdGVtQ29uZmlnU3RvcmUsXG4gICAgICAgIHByb3RlY3RlZCBwcmVmZXJlbmNlczogVXNlclByZWZlcmVuY2VTdG9yZSxcbiAgICApIHtcblxuICAgICAgICB0aGlzLnZhbHVlUGlwZXMuaW50ID0gKHZhbHVlOiBzdHJpbmcpOiBzdHJpbmcgPT4gdGhpcy52YWx1ZVR5cGVGb3JtYXQoJ2ludCcsIHZhbHVlKTtcbiAgICAgICAgdGhpcy52YWx1ZVBpcGVzLmZsb2F0ID0gKHZhbHVlOiBzdHJpbmcpOiBzdHJpbmcgPT4gdGhpcy52YWx1ZVR5cGVGb3JtYXQoJ2Zsb2F0JywgdmFsdWUpO1xuICAgICAgICB0aGlzLnZhbHVlUGlwZXMuZGF0ZSA9ICh2YWx1ZTogc3RyaW5nKTogc3RyaW5nID0+IHRoaXMudmFsdWVUeXBlRm9ybWF0KCdkYXRlJywgdmFsdWUpO1xuICAgICAgICB0aGlzLnZhbHVlUGlwZXMuZGF0ZXRpbWUgPSAodmFsdWU6IHN0cmluZyk6IHN0cmluZyA9PiB0aGlzLnZhbHVlVHlwZUZvcm1hdCgnZGF0ZXRpbWUnLCB2YWx1ZSk7XG4gICAgICAgIHRoaXMudmFsdWVQaXBlcy5jdXJyZW5jeSA9ICh2YWx1ZTogc3RyaW5nKTogc3RyaW5nID0+IHRoaXMudmFsdWVUeXBlRm9ybWF0KCdjdXJyZW5jeScsIHZhbHVlKTtcbiAgICAgICAgdGhpcy52YWx1ZVBpcGVzLmVudW0gPSAodmFsdWU6IHN0cmluZywgZmlsdGVyQXJndW1lbnRzOiBzdHJpbmdbXSA9IFtdKTogc3RyaW5nID0+IHRoaXMuZW51bUZvcm1hdCh2YWx1ZSwgZmlsdGVyQXJndW1lbnRzKTtcblxuICAgICAgICB0aGlzLmZpZWxkUGlwZXMuaW50ID0gKHZhbHVlOiBGaWVsZCk6IHN0cmluZyA9PiB0aGlzLmZpZWxkVHlwZUZvcm1hdCgnaW50JywgdmFsdWUpO1xuICAgICAgICB0aGlzLmZpZWxkUGlwZXMuZmxvYXQgPSAodmFsdWU6IEZpZWxkKTogc3RyaW5nID0+IHRoaXMuZmllbGRUeXBlRm9ybWF0KCdmbG9hdCcsIHZhbHVlKTtcbiAgICAgICAgdGhpcy5maWVsZFBpcGVzLmRhdGUgPSAodmFsdWU6IEZpZWxkKTogc3RyaW5nID0+IHRoaXMuZmllbGRUeXBlRm9ybWF0KCdkYXRlJywgdmFsdWUpO1xuICAgICAgICB0aGlzLmZpZWxkUGlwZXMuZGF0ZXRpbWUgPSAodmFsdWU6IEZpZWxkKTogc3RyaW5nID0+IHRoaXMuZmllbGRUeXBlRm9ybWF0KCdkYXRldGltZScsIHZhbHVlKTtcbiAgICAgICAgdGhpcy5maWVsZFBpcGVzLmN1cnJlbmN5ID0gKHZhbHVlOiBGaWVsZCk6IHN0cmluZyA9PiB0aGlzLmZpZWxkVHlwZUZvcm1hdCgnY3VycmVuY3knLCB2YWx1ZSk7XG4gICAgICAgIHRoaXMuZmllbGRQaXBlcy5waG9uZSA9ICh2YWx1ZTogRmllbGQpOiBzdHJpbmcgPT4gdGhpcy5maWVsZFR5cGVGb3JtYXQoJ3Bob25lJywgdmFsdWUpO1xuICAgICAgICB0aGlzLmZpZWxkUGlwZXMuZW51bSA9ICh2YWx1ZTogRmllbGQpOiBzdHJpbmcgPT4gdGhpcy5lbnVtRmllbGRGb3JtYXQodmFsdWUpO1xuICAgICAgICB0aGlzLmZpZWxkUGlwZXMuZHluYW1pY2VudW0gPSAodmFsdWU6IEZpZWxkKTogc3RyaW5nID0+IHRoaXMuZW51bUZpZWxkRm9ybWF0KHZhbHVlKTtcbiAgICAgICAgdGhpcy5maWVsZFBpcGVzLm11bHRpZW51bSA9ICh2YWx1ZTogRmllbGQpOiBzdHJpbmcgPT4gdGhpcy5tdWx0aUVudW1Gb3JtYXQodmFsdWUpO1xuICAgIH1cblxuICAgIGFkZFZhbHVlUGlwZShuYW1lOiBzdHJpbmcsIHByb2Nlc3NvcjogVGVtcGxhdGVWYWx1ZUZpbHRlcik6IHZvaWQge1xuICAgICAgICB0aGlzLnZhbHVlUGlwZXNbbmFtZV0gPSBwcm9jZXNzb3I7XG4gICAgfVxuXG4gICAgYWRkRmllbGRQaXBlKG5hbWU6IHN0cmluZywgcHJvY2Vzc29yOiBUZW1wbGF0ZUZpZWxkRmlsdGVyKTogdm9pZCB7XG4gICAgICAgIHRoaXMuZmllbGRQaXBlc1tuYW1lXSA9IHByb2Nlc3NvcjtcbiAgICB9XG5cbiAgICBwYXJzZSh0ZW1wbGF0ZTogc3RyaW5nLCBjb250ZXh0OiBTdHJpbmdNYXAsIGZpZWxkczogRmllbGRNYXApOiBzdHJpbmcge1xuXG4gICAgICAgIGlmICghdGVtcGxhdGUpIHtcbiAgICAgICAgICAgIHJldHVybiB0ZW1wbGF0ZTtcbiAgICAgICAgfVxuXG4gICAgICAgIGNvbnN0IHJlZ2V4ID0gLyh7e1tcXHNcXFNdKz99fSkvZztcblxuICAgICAgICBjb25zdCBtYXRjaGVzID0gdGVtcGxhdGUubWF0Y2gocmVnZXgpO1xuXG4gICAgICAgIGlmICghbWF0Y2hlcyB8fCBtYXRjaGVzLmxlbmd0aCA8IDEpIHtcbiAgICAgICAgICAgIHJldHVybiB0ZW1wbGF0ZTtcbiAgICAgICAgfVxuXG4gICAgICAgIGxldCBwYXJzZWRUZW1wbGF0ZSA9IHRlbXBsYXRlO1xuXG4gICAgICAgIGNvbnN0IG1vZHVsZSA9IChjb250ZXh0ICYmIGNvbnRleHQubW9kdWxlKSB8fCAnJztcblxuICAgICAgICBtYXRjaGVzLmZvckVhY2goKHJlZ2V4TWF0Y2gpID0+IHtcblxuICAgICAgICAgICAgaWYgKCFwYXJzZWRUZW1wbGF0ZS5pbmNsdWRlcyhyZWdleE1hdGNoKSkge1xuICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgbGV0IGZpbHRlciA9ICcnO1xuICAgICAgICAgICAgbGV0IGZpbHRlckFyZ3VtZW50cyA9IFtdO1xuICAgICAgICAgICAgbGV0IHZhbHVlID0gJyc7XG4gICAgICAgICAgICBsZXQgc291cmNlID0gJ2NvbnRleHQnO1xuICAgICAgICAgICAgbGV0IHBhcnRzID0gW107XG5cbiAgICAgICAgICAgIGxldCB2YXJpYWJsZU5hbWUgPSAnJyArIHJlZ2V4TWF0Y2g7XG4gICAgICAgICAgICB2YXJpYWJsZU5hbWUgPSB2YXJpYWJsZU5hbWUucmVwbGFjZSgne3snLCAnJyk7XG4gICAgICAgICAgICB2YXJpYWJsZU5hbWUgPSB2YXJpYWJsZU5hbWUucmVwbGFjZSgnfX0nLCAnJyk7XG4gICAgICAgICAgICB2YXJpYWJsZU5hbWUgPSB2YXJpYWJsZU5hbWUudHJpbSgpO1xuXG4gICAgICAgICAgICBsZXQgcGF0aCA9IHZhcmlhYmxlTmFtZTtcblxuICAgICAgICAgICAgaWYgKHZhcmlhYmxlTmFtZS5pbmNsdWRlcygnfCcpKSB7XG4gICAgICAgICAgICAgICAgY29uc3QgW25hbWUsIHBpcGUsIC4uLm90aGVyc10gPSB2YXJpYWJsZU5hbWUuc3BsaXQoJ3wnKTtcbiAgICAgICAgICAgICAgICBmaWx0ZXIgPSBwaXBlLnRyaW0oKTtcblxuICAgICAgICAgICAgICAgIGlmIChwaXBlLnRyaW0oKS5pbmNsdWRlcygnOicpKSB7XG4gICAgICAgICAgICAgICAgICAgIGxldFtmaWx0ZXJUeXBlLCAuLi5maWx0ZXJBcmdzXSA9IHBpcGUudHJpbSgpLnNwbGl0KCc6Jyk7XG4gICAgICAgICAgICAgICAgICAgIGZpbHRlciA9IGZpbHRlclR5cGUudHJpbSgpO1xuICAgICAgICAgICAgICAgICAgICBmaWx0ZXJBcmd1bWVudHMgPSBmaWx0ZXJBcmdzO1xuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgIHZhcmlhYmxlTmFtZSA9IG5hbWUudHJpbSgpO1xuICAgICAgICAgICAgICAgIHBhdGggPSBuYW1lLnRyaW0oKTtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgaWYgKHZhcmlhYmxlTmFtZS5pbmNsdWRlcygnLicpKSB7XG4gICAgICAgICAgICAgICAgcGFydHMgPSB2YXJpYWJsZU5hbWUuc3BsaXQoJy4nKTtcbiAgICAgICAgICAgICAgICBzb3VyY2UgPSBwYXJ0c1swXTtcbiAgICAgICAgICAgICAgICB2YXJpYWJsZU5hbWUgPSBwYXJ0c1sxXTtcbiAgICAgICAgICAgIH1cblxuXG4gICAgICAgICAgICBsZXQgc291cmNlVmFsdWVzOiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB8IEZpZWxkIH0gPSBjb250ZXh0O1xuICAgICAgICAgICAgaWYgKHNvdXJjZSA9PT0gJ2ZpZWxkcycpIHtcbiAgICAgICAgICAgICAgICBzb3VyY2VWYWx1ZXMgPSBmaWVsZHM7XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIGlmIChzb3VyY2UgPT09ICdmaWVsZHMnKSB7XG5cbiAgICAgICAgICAgICAgICBpZiAoIXNvdXJjZVZhbHVlcyB8fCAhKHZhcmlhYmxlTmFtZSBpbiBzb3VyY2VWYWx1ZXMpKSB7XG4gICAgICAgICAgICAgICAgICAgIHBhcnNlZFRlbXBsYXRlID0gcGFyc2VkVGVtcGxhdGUucmVwbGFjZShyZWdleE1hdGNoLCB2YWx1ZSk7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgICBjb25zdCBmaWVsZCA9IGZpZWxkc1t2YXJpYWJsZU5hbWVdO1xuXG4gICAgICAgICAgICAgICAgaWYgKCFmaWVsZCkge1xuICAgICAgICAgICAgICAgICAgICBwYXJzZWRUZW1wbGF0ZSA9IHBhcnNlZFRlbXBsYXRlLnJlcGxhY2UocmVnZXhNYXRjaCwgJycpO1xuICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgaWYgKHBhcnRzWzJdICYmIHBhcnRzWzJdID09PSAndmFsdWUnICYmIGZpZWxkLnR5cGUgaW4gdGhpcy5maWVsZFBpcGVzKSB7XG4gICAgICAgICAgICAgICAgICAgIHZhbHVlID0gdGhpcy5maWVsZFBpcGVzW2ZpZWxkLnR5cGVdKGZpZWxkKTtcbiAgICAgICAgICAgICAgICAgICAgcGFyc2VkVGVtcGxhdGUgPSBwYXJzZWRUZW1wbGF0ZS5yZXBsYWNlKHJlZ2V4TWF0Y2gsIHZhbHVlKTtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgIGlmIChwYXJ0c1syXSAmJiBwYXJ0c1syXSA9PT0gJ2xhYmVsJykge1xuICAgICAgICAgICAgICAgICAgICB2YWx1ZSA9IHRoaXMuZ2V0RmllbGRMYWJlbChmaWVsZC5sYWJlbEtleSwgbW9kdWxlKTtcbiAgICAgICAgICAgICAgICAgICAgcGFyc2VkVGVtcGxhdGUgPSBwYXJzZWRUZW1wbGF0ZS5yZXBsYWNlKHJlZ2V4TWF0Y2gsIHZhbHVlKTtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgIHZhbHVlID0gZ2V0KHtmaWVsZHN9LCBwYXRoLCAnJyk7XG5cbiAgICAgICAgICAgICAgICBwYXJzZWRUZW1wbGF0ZSA9IHBhcnNlZFRlbXBsYXRlLnJlcGxhY2UocmVnZXhNYXRjaCwgdmFsdWUpO1xuICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgaWYgKHNvdXJjZSA9PT0gJ2NvbmZpZycpIHtcbiAgICAgICAgICAgICAgICBwYXJzZWRUZW1wbGF0ZSA9IHRoaXMucGFyc2VPYmplY3RDb250ZXh0KFxuICAgICAgICAgICAgICAgICAgICB2YXJpYWJsZU5hbWUsXG4gICAgICAgICAgICAgICAgICAgIHBhcnNlZFRlbXBsYXRlLFxuICAgICAgICAgICAgICAgICAgICByZWdleE1hdGNoLFxuICAgICAgICAgICAgICAgICAgICBmaWx0ZXIsXG4gICAgICAgICAgICAgICAgICAgIGZpbHRlckFyZ3VtZW50cyxcbiAgICAgICAgICAgICAgICAgICAgKGtleTogc3RyaW5nKTogYW55ID0+IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiB0aGlzLmNvbmZpZ3MuZ2V0Q29uZmlnVmFsdWUoa2V5KTtcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICk7XG4gICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICBpZiAoc291cmNlID09PSAncHJlZmVyZW5jZXMnKSB7XG4gICAgICAgICAgICAgICAgcGFyc2VkVGVtcGxhdGUgPSB0aGlzLnBhcnNlT2JqZWN0Q29udGV4dChcbiAgICAgICAgICAgICAgICAgICAgdmFyaWFibGVOYW1lLFxuICAgICAgICAgICAgICAgICAgICBwYXJzZWRUZW1wbGF0ZSxcbiAgICAgICAgICAgICAgICAgICAgcmVnZXhNYXRjaCxcbiAgICAgICAgICAgICAgICAgICAgZmlsdGVyLFxuICAgICAgICAgICAgICAgICAgICBmaWx0ZXJBcmd1bWVudHMsXG4gICAgICAgICAgICAgICAgICAgIChrZXk6IHN0cmluZyk6IGFueSA9PiB7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gdGhpcy5wcmVmZXJlbmNlcy5nZXRVc2VyUHJlZmVyZW5jZShrZXkpO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgKTtcbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIGlmICghc291cmNlVmFsdWVzIHx8ICEodmFyaWFibGVOYW1lIGluIHNvdXJjZVZhbHVlcykpIHtcbiAgICAgICAgICAgICAgICBwYXJzZWRUZW1wbGF0ZSA9IHBhcnNlZFRlbXBsYXRlLnJlcGxhY2UocmVnZXhNYXRjaCwgdmFsdWUpO1xuICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgdmFsdWUgPSBnZXQoe2NvbnRleHR9LCBwYXRoLCAnJyk7XG5cbiAgICAgICAgICAgIGlmIChmaWx0ZXIgaW4gdGhpcy52YWx1ZVBpcGVzKSB7XG4gICAgICAgICAgICAgICAgdmFsdWUgPSB0aGlzLnZhbHVlUGlwZXNbZmlsdGVyXSh2YWx1ZSk7XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIHBhcnNlZFRlbXBsYXRlID0gcGFyc2VkVGVtcGxhdGUucmVwbGFjZShyZWdleE1hdGNoLCB2YWx1ZSk7XG4gICAgICAgIH0pO1xuXG4gICAgICAgIHJldHVybiBwYXJzZWRUZW1wbGF0ZTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgdmFsdWVUeXBlRm9ybWF0KHR5cGU6IHN0cmluZywgdmFsdWU6IHN0cmluZyk6IHN0cmluZyB7XG4gICAgICAgIHJldHVybiB0aGlzLnR5cGVGb3JtYXR0ZXIudG9Vc2VyRm9ybWF0KHR5cGUsIHZhbHVlKTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgZW51bUZvcm1hdCh2YWx1ZTogc3RyaW5nLCBmaWx0ZXJBcmd1bWVudHM/OiBzdHJpbmdbXSk6IHN0cmluZyB7XG4gICAgICAgIGNvbnN0IG9wdGlvbnMgPSBmaWx0ZXJBcmd1bWVudHNbMF0gPz8gJyc7XG4gICAgICAgIGlmICghb3B0aW9ucyB8fCAhdmFsdWUpIHtcbiAgICAgICAgICAgIHJldHVybiAnJztcbiAgICAgICAgfVxuXG4gICAgICAgIHJldHVybiB0aGlzLmxhbmd1YWdlLmdldExpc3RMYWJlbChvcHRpb25zLCB2YWx1ZSk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGZpZWxkVHlwZUZvcm1hdCh0eXBlOiBzdHJpbmcsIGZpZWxkOiBGaWVsZCk6IHN0cmluZyB7XG4gICAgICAgIHJldHVybiB0aGlzLnR5cGVGb3JtYXR0ZXIudG9Vc2VyRm9ybWF0KHR5cGUsIGZpZWxkLnZhbHVlKTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgZW51bUZpZWxkRm9ybWF0KGZpZWxkOiBGaWVsZCk6IHN0cmluZyB7XG4gICAgICAgIGlmIChpc1ZvaWQoZmllbGQuZGVmaW5pdGlvbi5vcHRpb25zKSB8fCBpc1ZvaWQoZmllbGQudmFsdWUpKSB7XG4gICAgICAgICAgICByZXR1cm4gJyc7XG4gICAgICAgIH1cblxuICAgICAgICByZXR1cm4gdGhpcy5sYW5ndWFnZS5nZXRMaXN0TGFiZWwoZmllbGQuZGVmaW5pdGlvbi5vcHRpb25zLCBmaWVsZC52YWx1ZSk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIG11bHRpRW51bUZvcm1hdChmaWVsZDogRmllbGQpOiBzdHJpbmcge1xuICAgICAgICBpZiAoaXNWb2lkKGZpZWxkLmRlZmluaXRpb24ub3B0aW9ucykgfHwgaXNWb2lkKGZpZWxkLnZhbHVlTGlzdCkgfHwgZmllbGQudmFsdWVMaXN0Lmxlbmd0aCA8IDEpIHtcbiAgICAgICAgICAgIHJldHVybiAnJztcbiAgICAgICAgfVxuXG4gICAgICAgIGNvbnN0IHJlc3VsdDogc3RyaW5nW10gPSBbXTtcblxuICAgICAgICBmaWVsZC52YWx1ZUxpc3QuZm9yRWFjaCh2YWx1ZSA9PiB7XG4gICAgICAgICAgICBpZiAoaXNWb2lkKHZhbHVlKSkge1xuICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgcmVzdWx0LnB1c2godGhpcy5sYW5ndWFnZS5nZXRMaXN0TGFiZWwoZmllbGQuZGVmaW5pdGlvbi5vcHRpb25zLCB2YWx1ZSkpO1xuICAgICAgICB9KTtcblxuICAgICAgICByZXR1cm4gcmVzdWx0LmpvaW4oJywgJyk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGdldEZpZWxkTGFiZWwobGFiZWxLZXk6IHN0cmluZywgbW9kdWxlID0gJycpOiBzdHJpbmcge1xuICAgICAgICBpZiAoaXNWb2lkKGxhYmVsS2V5KSkge1xuICAgICAgICAgICAgcmV0dXJuICcnO1xuICAgICAgICB9XG5cbiAgICAgICAgcmV0dXJuIHRoaXMubGFuZ3VhZ2UuZ2V0RmllbGRMYWJlbChsYWJlbEtleSwgbW9kdWxlKTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgcGFyc2VPYmplY3RDb250ZXh0KHZhcmlhYmxlTmFtZTogc3RyaW5nLCBwYXJzZWRUZW1wbGF0ZTogc3RyaW5nLCByZWdleE1hdGNoOiBzdHJpbmcsIGZpbHRlcjogc3RyaW5nLCBmaWx0ZXJBcmd1bWVudHM6IHN0cmluZ1tdLCBnZXR0ZXI6IChrZXk6IHN0cmluZykgPT4gYW55KTogc3RyaW5nIHtcbiAgICAgICAgbGV0IGVudHJ5S2V5ID0gdmFyaWFibGVOYW1lO1xuICAgICAgICBpZiAodmFyaWFibGVOYW1lLmluY2x1ZGVzKCcuJykpIHtcbiAgICAgICAgICAgIGxldCBba2V5LCAuLi5vdGhlcnNdID0gdmFyaWFibGVOYW1lLnNwbGl0KCcuJyk7XG4gICAgICAgICAgICBlbnRyeUtleSA9IGtleTtcbiAgICAgICAgfVxuXG4gICAgICAgIGxldCB2YWx1ZSA9IGdldHRlcihlbnRyeUtleSk7XG5cbiAgICAgICAgaWYgKHZhcmlhYmxlTmFtZS5pbmNsdWRlcygnLicpICYmIHR5cGVvZiB2YWx1ZSA9PT0gJ29iamVjdCcpIHtcbiAgICAgICAgICAgIHZhbHVlID0gZ2V0KHt2YWx1ZX0sIHZhcmlhYmxlTmFtZSwgJycpO1xuICAgICAgICB9XG5cbiAgICAgICAgaWYgKCF2YWx1ZSB8fCB0eXBlb2YgdmFsdWUgPT09ICdvYmplY3QnKSB7XG4gICAgICAgICAgICByZXR1cm4gcGFyc2VkVGVtcGxhdGUucmVwbGFjZShyZWdleE1hdGNoLCAnJyk7XG4gICAgICAgIH1cblxuICAgICAgICBpZiAoZmlsdGVyIGluIHRoaXMudmFsdWVQaXBlcykge1xuICAgICAgICAgICAgdmFsdWUgPSB0aGlzLnZhbHVlUGlwZXNbZmlsdGVyXSh2YWx1ZSwgZmlsdGVyQXJndW1lbnRzKTtcbiAgICAgICAgfVxuXG4gICAgICAgIHJldHVybiBwYXJzZWRUZW1wbGF0ZS5yZXBsYWNlKHJlZ2V4TWF0Y2gsIHZhbHVlKTtcbiAgICB9XG59XG4iXX0=