/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Component } from '@angular/core';
import { Router } from '@angular/router';
import { combineLatestWith, of } from 'rxjs';
import { catchError, map, tap } from 'rxjs/operators';
import { transition, trigger, useAnimation } from '@angular/animations';
import { fadeIn } from 'ng-animate';
import { RecoverPasswordService } from '../../../../services/process/processes/recover-password/recover-password';
import { SystemConfigStore } from '../../../../store/system-config/system-config.store';
import { AuthService } from '../../../../services/auth/auth.service';
import { LanguageStore } from '../../../../store/language/language.store';
import { MessageService } from '../../../../services/message/message.service';
import { AppStateStore } from "../../../../store/app-state/app-state.store";
import * as i0 from "@angular/core";
import * as i1 from "@angular/router";
import * as i2 from "../../../../services/auth/auth.service";
import * as i3 from "../../../../services/message/message.service";
import * as i4 from "../../../../store/system-config/system-config.store";
import * as i5 from "../../../../store/language/language.store";
import * as i6 from "../../../../services/process/processes/recover-password/recover-password";
import * as i7 from "../../../../store/app-state/app-state.store";
import * as i8 from "@angular/forms";
import * as i9 from "../../../../components/logo/logo.component";
import * as i10 from "@angular/common";
import * as i11 from "../../../../components/image/image.component";
import * as i12 from "../../../../directives/button-loading/button-loading.directive";
function LoginUiComponent_div_0_div_6_option_9_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 17);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const item_r8 = ctx.$implicit;
    const ctx_r7 = i0.ɵɵnextContext(3);
    let tmp_0_0;
    i0.ɵɵproperty("selected", ((tmp_0_0 = ctx_r7.language) !== null && tmp_0_0 !== undefined ? tmp_0_0 : "en_us") === item_r8)("value", item_r8);
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", ctx_r7.getEnabledLanguages()[item_r8], " ");
} }
function LoginUiComponent_div_0_div_6_Template(rf, ctx) { if (rf & 1) {
    const _r10 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 10)(1, "div", 5)(2, "label", 11);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd()();
    i0.ɵɵelement(4, "div", 12);
    i0.ɵɵelementStart(5, "div", 5)(6, "div", 13)(7, "select", 14, 15);
    i0.ɵɵlistener("change", function LoginUiComponent_div_0_div_6_Template_select_change_7_listener() { i0.ɵɵrestoreView(_r10); const _r6 = i0.ɵɵreference(8); const ctx_r9 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r9.onLanguageSelect(_r6.value)); });
    i0.ɵɵtemplate(9, LoginUiComponent_div_0_div_6_option_9_Template, 2, 3, "option", 16);
    i0.ɵɵelementEnd()()()();
} if (rf & 2) {
    const vm_r1 = i0.ɵɵnextContext().ngIf;
    const ctx_r3 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate(vm_r1.appStrings["LBL_LANGUAGE"]);
    i0.ɵɵadvance(6);
    i0.ɵɵproperty("ngForOf", ctx_r3.getEnabledLanguagesKeys());
} }
function LoginUiComponent_div_0_div_8_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 28);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const vm_r1 = i0.ɵɵnextContext(2).ngIf;
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", vm_r1.appStrings["ERR_MISSING_REQUIRED_FIELDS"], " ");
} }
function LoginUiComponent_div_0_div_8_div_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 28);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const vm_r1 = i0.ɵɵnextContext(2).ngIf;
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", vm_r1.appStrings["ERR_MISSING_REQUIRED_FIELDS"], " ");
} }
function LoginUiComponent_div_0_div_8_div_13_Template(rf, ctx) { if (rf & 1) {
    const _r20 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 29)(1, "a", 30);
    i0.ɵɵlistener("click", function LoginUiComponent_div_0_div_8_div_13_Template_a_click_1_listener() { i0.ɵɵrestoreView(_r20); const ctx_r19 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r19.flipCard()); });
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const vm_r1 = i0.ɵɵnextContext(2).ngIf;
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate1(" ", vm_r1.appStrings["LBL_LOGIN_FORGOT_PASSWORD"], " ");
} }
function LoginUiComponent_div_0_div_8_Template(rf, ctx) { if (rf & 1) {
    const _r23 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 18)(1, "div", 13);
    i0.ɵɵelement(2, "scrm-image", 19);
    i0.ɵɵelementStart(3, "input", 20, 21);
    i0.ɵɵlistener("ngModelChange", function LoginUiComponent_div_0_div_8_Template_input_ngModelChange_3_listener($event) { i0.ɵɵrestoreView(_r23); const ctx_r22 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r22.uname = $event); });
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(5, LoginUiComponent_div_0_div_8_div_5_Template, 2, 1, "div", 22);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(6, "div", 13);
    i0.ɵɵelement(7, "scrm-image", 23);
    i0.ɵɵelementStart(8, "input", 24, 25);
    i0.ɵɵlistener("ngModelChange", function LoginUiComponent_div_0_div_8_Template_input_ngModelChange_8_listener($event) { i0.ɵɵrestoreView(_r23); const ctx_r24 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r24.passw = $event); });
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(10, LoginUiComponent_div_0_div_8_div_10_Template, 2, 1, "div", 22);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(11, "button", 26);
    i0.ɵɵlistener("click", function LoginUiComponent_div_0_div_8_Template_button_click_11_listener() { i0.ɵɵrestoreView(_r23); i0.ɵɵnextContext(); const _r2 = i0.ɵɵreference(2); const ctx_r25 = i0.ɵɵnextContext(); _r2.control.markAllAsTouched(); return i0.ɵɵresetView(_r2.valid && ctx_r25.doLogin()); });
    i0.ɵɵtext(12);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(13, LoginUiComponent_div_0_div_8_div_13_Template, 3, 1, "div", 27);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const _r12 = i0.ɵɵreference(4);
    const _r14 = i0.ɵɵreference(9);
    const vm_r1 = i0.ɵɵnextContext().ngIf;
    const ctx_r4 = i0.ɵɵnextContext();
    i0.ɵɵproperty("@fade", undefined);
    i0.ɵɵadvance(3);
    i0.ɵɵclassProp("is-invalid", _r12.invalid && _r12.touched);
    i0.ɵɵpropertyInterpolate("placeholder", vm_r1.appStrings["LBL_USER_NAME"]);
    i0.ɵɵproperty("ngModel", ctx_r4.uname);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", _r12.invalid && _r12.touched);
    i0.ɵɵadvance(3);
    i0.ɵɵclassProp("is-invalid", _r14.invalid && _r14.touched);
    i0.ɵɵpropertyInterpolate("placeholder", vm_r1.appStrings["LBL_PASSWORD"]);
    i0.ɵɵproperty("ngModel", ctx_r4.passw);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", _r14.invalid && _r14.touched);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("scrm-button-loading", ctx_r4.loading);
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", vm_r1.appStrings["LBL_LOGIN_BUTTON_LABEL"], " ");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", vm_r1.showForgotPassword);
} }
function LoginUiComponent_div_0_div_9_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 28);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const vm_r1 = i0.ɵɵnextContext(2).ngIf;
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", vm_r1.appStrings["ERR_MISSING_REQUIRED_FIELDS"], " ");
} }
function LoginUiComponent_div_0_div_9_div_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 28);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const vm_r1 = i0.ɵɵnextContext(2).ngIf;
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", vm_r1.appStrings["ERR_MISSING_REQUIRED_FIELDS"], " ");
} }
function LoginUiComponent_div_0_div_9_Template(rf, ctx) { if (rf & 1) {
    const _r34 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 31)(1, "div", 13);
    i0.ɵɵelement(2, "scrm-image", 19);
    i0.ɵɵelementStart(3, "input", 20, 21);
    i0.ɵɵlistener("ngModelChange", function LoginUiComponent_div_0_div_9_Template_input_ngModelChange_3_listener($event) { i0.ɵɵrestoreView(_r34); const ctx_r33 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r33.uname = $event); });
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(5, LoginUiComponent_div_0_div_9_div_5_Template, 2, 1, "div", 22);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(6, "div", 13);
    i0.ɵɵelement(7, "scrm-image", 32);
    i0.ɵɵelementStart(8, "input", 33, 34);
    i0.ɵɵlistener("ngModelChange", function LoginUiComponent_div_0_div_9_Template_input_ngModelChange_8_listener($event) { i0.ɵɵrestoreView(_r34); const ctx_r35 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r35.email = $event); });
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(10, LoginUiComponent_div_0_div_9_div_10_Template, 2, 1, "div", 22);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(11, "button", 35);
    i0.ɵɵlistener("click", function LoginUiComponent_div_0_div_9_Template_button_click_11_listener() { i0.ɵɵrestoreView(_r34); i0.ɵɵnextContext(); const _r2 = i0.ɵɵreference(2); const ctx_r36 = i0.ɵɵnextContext(); _r2.control.markAllAsTouched(); return i0.ɵɵresetView(_r2.valid && ctx_r36.recoverPassword()); });
    i0.ɵɵtext(12);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(13, "div")(14, "a", 36);
    i0.ɵɵlistener("click", function LoginUiComponent_div_0_div_9_Template_a_click_14_listener() { i0.ɵɵrestoreView(_r34); const ctx_r37 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r37.flipCard()); });
    i0.ɵɵtext(15);
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const _r27 = i0.ɵɵreference(4);
    const _r29 = i0.ɵɵreference(9);
    const vm_r1 = i0.ɵɵnextContext().ngIf;
    const ctx_r5 = i0.ɵɵnextContext();
    i0.ɵɵproperty("@fade", undefined);
    i0.ɵɵadvance(3);
    i0.ɵɵclassProp("is-invalid", _r27.invalid && _r27.touched);
    i0.ɵɵpropertyInterpolate("placeholder", vm_r1.appStrings["LBL_USER_NAME"]);
    i0.ɵɵproperty("ngModel", ctx_r5.uname);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", _r27.invalid && _r27.touched);
    i0.ɵɵadvance(3);
    i0.ɵɵclassProp("is-invalid", _r29.invalid && _r29.touched);
    i0.ɵɵpropertyInterpolate("placeholder", vm_r1.appStrings["LBL_EMAIL"]);
    i0.ɵɵproperty("ngModel", ctx_r5.email);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", _r29.invalid && _r29.touched);
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate1(" ", vm_r1.appStrings["LBL_GENERATE_PASSWORD_BUTTON_TITLE"], " ");
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate1(" ", vm_r1.appStrings["LBL_BACK"], " ");
} }
function LoginUiComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1)(1, "form", 2, 3)(3, "div", 4)(4, "div", 5);
    i0.ɵɵelement(5, "scrm-logo-ui");
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(6, LoginUiComponent_div_0_div_6_Template, 10, 2, "div", 6);
    i0.ɵɵelementStart(7, "div", 7);
    i0.ɵɵtemplate(8, LoginUiComponent_div_0_div_8_Template, 14, 14, "div", 8);
    i0.ɵɵtemplate(9, LoginUiComponent_div_0_div_9_Template, 16, 13, "div", 9);
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const vm_r1 = ctx.ngIf;
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(6);
    i0.ɵɵproperty("ngIf", vm_r1.showLanguages);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r0.cardState === "front");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r0.cardState === "back");
} }
class LoginUiComponent {
    constructor(router, auth, message, configs, languageStore, recoverPasswordService, appState) {
        this.router = router;
        this.auth = auth;
        this.message = message;
        this.configs = configs;
        this.languageStore = languageStore;
        this.recoverPasswordService = recoverPasswordService;
        this.appState = appState;
        this.hidden = true;
        this.loading = false;
        this.error = '';
        this.uname = '';
        this.passw = '';
        this.email = '';
        this.cardState = 'front';
        this.systemConfigs$ = this.configs.configs$;
        this.appStrings$ = this.languageStore.appStrings$;
        this.language = null;
        this.vm$ = this.systemConfigs$.pipe(combineLatestWith(this.appStrings$), map(([systemConfigs, appStrings]) => {
            let showLanguages = false;
            let showForgotPassword = false;
            if (systemConfigs.languages && systemConfigs.languages.items && systemConfigs.login_language.value) {
                showLanguages = Object.keys(systemConfigs.languages.items).length > 1;
            }
            if (systemConfigs.passwordsetting && systemConfigs.passwordsetting.items) {
                const forgotPasswordProperty = systemConfigs.passwordsetting.items.forgotpasswordON;
                showForgotPassword = [true, '1', 'true'].includes(forgotPasswordProperty);
            }
            return {
                systemConfigs,
                appStrings,
                showLanguages,
                showForgotPassword
            };
        }));
        this.loading = false;
        this.hidden = false;
        this.language = null;
    }
    ngOnInit() {
        this.setCurrentLanguage();
        this.appState.removeAllPrevRoutes();
    }
    onLanguageSelect(language) {
        if (!language) {
            return;
        }
        if (language === this.language) {
            return;
        }
        this.changeLanguage(language);
    }
    changeLanguage(language) {
        this.language = language;
        let languagesLoading = false;
        if (this?.appState?.updateLoading) {
            this.appState.updateLoading('change-language', true);
            languagesLoading = true;
        }
        this.languageStore.changeLanguage(language, true).pipe(tap(() => {
            if (languagesLoading) {
                this.appState.updateLoading('change-language', false);
            }
        })).subscribe();
    }
    getEnabledLanguages() {
        return this.languageStore.getEnabledLanguages();
    }
    getEnabledLanguagesKeys() {
        return Object.keys(this.languageStore.getEnabledLanguages() ?? {}) ?? [];
    }
    flipCard() {
        if (this.cardState === 'front') {
            this.cardState = 'back';
        }
        else {
            this.cardState = 'front';
        }
    }
    doLogin() {
        this.loading = true;
        this.auth.doLogin(this.uname, this.passw, this.onLoginSuccess.bind(this), this.onLoginError.bind(this));
    }
    recoverPassword() {
        this.recoverPasswordService
            .run(this.uname, this.email)
            .subscribe((process) => {
            this.message.log('Recover Password Status: ' + process.status);
            let handler = 'addSuccessMessageByKey';
            if (process.status === 'error') {
                handler = 'addDangerMessageByKey';
            }
            if (process.messages) {
                process.messages.forEach(message => {
                    this.message[handler](message);
                });
            }
        }, () => {
            this.message.log('Recover Password failed');
            this.message.addDangerMessageByKey('ERR_AJAX_LOAD_FAILURE');
        });
    }
    onLoginSuccess(result) {
        this.loading = false;
        this.message.log('Login success');
        this.message.removeMessages();
        this.languageStore.setSessionLanguage()
            .pipe(catchError(() => of({})))
            .subscribe(() => {
            if (result && result.redirect && result.redirect.route) {
                this.router.navigate([result.redirect.route], {
                    queryParams: result.redirect.queryParams ?? {}
                }).then();
                return;
            }
            if (this.appState.getPreLoginUrl()) {
                this.router.navigateByUrl(this.appState.getPreLoginUrl()).then(() => {
                    this.appState.setPreLoginUrl('');
                });
                return;
            }
            const defaultModule = this.configs.getHomePage();
            this.router.navigate(['/' + defaultModule]).then();
        });
        if (this.configs.getConfigValue('login_language')) {
            this.languageStore.setUserLanguage().subscribe();
        }
        return;
    }
    onLoginError(httpError) {
        this.loading = false;
        this.message.log('Login failed');
        const defaultMessage = 'Login credentials incorrect, please try again.';
        const defaultTooManyFailedMessage = 'Too many failed login attempts, please try again later.';
        let message = this.languageStore.getFieldLabel('LOGIN_INCORRECT');
        const errorMessage = httpError?.error?.error ?? '';
        if (typeof errorMessage === 'string' && errorMessage.includes('Too many failed login attempts, please try again in')) {
            message = this.getTooManyFailedMessage(defaultTooManyFailedMessage);
        }
        if (!message) {
            message = defaultMessage;
        }
        this.message.addDangerMessage(message);
    }
    getTooManyFailedMessage(defaultTooManyFailedMessage) {
        let tooManyFailedMessage = this.languageStore.getFieldLabel('LOGIN_TOO_MANY_FAILED');
        if (!tooManyFailedMessage) {
            tooManyFailedMessage = defaultTooManyFailedMessage;
        }
        return tooManyFailedMessage;
    }
    setCurrentLanguage() {
        let currentLanguage = this.languageStore.getSelectedLanguage() ?? '';
        const activeLanguage = this.languageStore.getActiveLanguage();
        if (!currentLanguage) {
            currentLanguage = activeLanguage;
        }
        if (!this.languageStore.isLanguageEnabled(currentLanguage)) {
            currentLanguage = '';
        }
        if (this.language && currentLanguage === this.language) {
            return;
        }
        const defaultLanguage = this.configs.getConfigValue('default_language') ?? 'en_us';
        if (!currentLanguage) {
            currentLanguage = defaultLanguage;
        }
        if (!this.languageStore.isLanguageEnabled(currentLanguage)) {
            currentLanguage = this.languageStore.getFirstLanguage();
        }
        this.language = currentLanguage;
        this.changeLanguage(currentLanguage);
    }
    static { this.ɵfac = function LoginUiComponent_Factory(t) { return new (t || LoginUiComponent)(i0.ɵɵdirectiveInject(i1.Router), i0.ɵɵdirectiveInject(i2.AuthService), i0.ɵɵdirectiveInject(i3.MessageService), i0.ɵɵdirectiveInject(i4.SystemConfigStore), i0.ɵɵdirectiveInject(i5.LanguageStore), i0.ɵɵdirectiveInject(i6.RecoverPasswordService), i0.ɵɵdirectiveInject(i7.AppStateStore)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: LoginUiComponent, selectors: [["scrm-login-ui"]], decls: 2, vars: 3, consts: [["class", "login-view full-height-view d-flex align-items-center", 4, "ngIf"], [1, "login-view", "full-height-view", "d-flex", "align-items-center"], ["name", "login", 1, "login-form"], ["loginForm", "ngForm"], [1, "form-row", "form-group"], [1, "col"], ["class", "form-row", 4, "ngIf"], [1, "form-row", "fade-card"], ["class", "fade-card-front col", 4, "ngIf"], ["class", "fade-card-back col", 4, "ngIf"], [1, "form-row"], ["for", "languages", 1, ""], [1, "w-100"], [1, "inner-addon", "left-addon"], ["id", "languages", 3, "change"], ["languageSelect", ""], [3, "selected", "value", 4, "ngFor", "ngForOf"], [3, "selected", "value"], [1, "fade-card-front", "col"], ["image", "login_user"], ["type", "text", "name", "username", "aria-label", "Username", "required", "", 3, "ngModel", "placeholder", "ngModelChange"], ["username", "ngModel"], ["class", "invalid-feedback", 4, "ngIf"], ["image", "login_password"], ["type", "password", "name", "password", "aria-label", "Password", "required", "", 3, "ngModel", "placeholder", "ngModelChange"], ["password", "ngModel"], ["id", "login-button", 1, "login-button", 3, "scrm-button-loading", "click"], ["class", "forgotten-password", 4, "ngIf"], [1, "invalid-feedback"], [1, "forgotten-password"], [1, "forgotten-password-link", 3, "click"], [1, "fade-card-back", "col"], ["image", "email"], ["type", "email", "name", "email", "aria-label", "Email", "required", "", 3, "ngModel", "placeholder", "ngModelChange"], ["mail", "ngModel"], ["scrm-button-loading", "", 1, "submit-button", "login-button", 3, "click"], [1, "back-link", "forgotten-password-link", 3, "click"]], template: function LoginUiComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, LoginUiComponent_div_0_Template, 10, 3, "div", 0);
            i0.ɵɵpipe(1, "async");
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", i0.ɵɵpipeBind1(1, 1, ctx.vm$));
        } }, dependencies: [i8.ɵNgNoValidate, i8.NgSelectOption, i8.ɵNgSelectMultipleOption, i8.DefaultValueAccessor, i8.NgControlStatus, i8.NgControlStatusGroup, i8.RequiredValidator, i8.NgModel, i8.NgForm, i9.LogoUiComponent, i10.NgForOf, i10.NgIf, i11.ImageComponent, i12.ButtonLoadingDirective, i10.AsyncPipe], encapsulation: 2, data: { animation: [
                trigger('fade', [
                    transition(':enter', useAnimation(fadeIn, {
                        params: { timing: 0.5, delay: 0 }
                    })),
                ])
            ] } }); }
}
export { LoginUiComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LoginUiComponent, [{
        type: Component,
        args: [{ selector: 'scrm-login-ui', animations: [
                    trigger('fade', [
                        transition(':enter', useAnimation(fadeIn, {
                            params: { timing: 0.5, delay: 0 }
                        })),
                    ])
                ], template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<div *ngIf=\"(vm$ | async) as vm\" class=\"login-view full-height-view d-flex align-items-center\">\n\n    <!-- Start of login form section -->\n\n    <form name=\"login\" class=\"login-form\" #loginForm=\"ngForm\">\n        <div class=\"form-row form-group\">\n            <div class=\"col\">\n                <scrm-logo-ui></scrm-logo-ui>\n            </div>\n        </div>\n        <div class=\"form-row\" *ngIf=\"vm.showLanguages\">\n            <div class=\"col\">\n                <label class=\"\" for=\"languages\">{{vm.appStrings['LBL_LANGUAGE']}}</label>\n            </div>\n            <div class=\"w-100\"></div>\n            <div class=\"col\">\n                <div class=\"inner-addon left-addon\">\n                    <select #languageSelect id=\"languages\"\n                            (change)=\"onLanguageSelect(languageSelect.value)\">\n                        <option *ngFor=\"let item of getEnabledLanguagesKeys()\"\n                                [selected]=\"(language ?? 'en_us') === item\"\n                                [value]=\"item\">\n                            {{getEnabledLanguages()[item]}}\n                        </option>\n                    </select>\n                </div>\n            </div>\n        </div>\n\n\n        <div class=\"form-row fade-card\">\n\n            <!-- Card front -->\n            <div class=\"fade-card-front col\"\n                 *ngIf=\"cardState==='front'\"\n                 [@fade]>\n\n                <div class=\"inner-addon left-addon\">\n                    <scrm-image image=\"login_user\"></scrm-image>\n                    <input [(ngModel)]=\"uname\"\n                           type=\"text\"\n                           name=\"username\"\n                           [class.is-invalid]=\"username.invalid && username.touched\"\n                           #username=\"ngModel\"\n                           placeholder=\"{{vm.appStrings['LBL_USER_NAME']}}\"\n                           aria-label=\"Username\"\n                           required>\n                    <div *ngIf=\"username.invalid && username.touched\" class=\"invalid-feedback\">\n                        {{vm.appStrings['ERR_MISSING_REQUIRED_FIELDS']}}\n                    </div>\n                </div>\n\n                <div class=\"inner-addon left-addon\">\n                    <scrm-image image=\"login_password\"></scrm-image>\n                    <input [(ngModel)]=\"passw\"\n                           type=\"password\"\n                           name=\"password\"\n                           [class.is-invalid]=\"password.invalid && password.touched\"\n                           #password=\"ngModel\"\n                           placeholder=\"{{vm.appStrings['LBL_PASSWORD']}}\"\n                           aria-label=\"Password\"\n                           required>\n                    <div *ngIf=\"password.invalid && password.touched\" class=\"invalid-feedback\">\n                        {{vm.appStrings['ERR_MISSING_REQUIRED_FIELDS']}}\n                    </div>\n                </div>\n\n\n                <button id=\"login-button\" class=\"login-button\"\n                        [scrm-button-loading]=\"loading\"\n                        (click)=\"loginForm.control.markAllAsTouched(); loginForm.valid && doLogin()\">\n                    {{vm.appStrings['LBL_LOGIN_BUTTON_LABEL']}}\n                </button>\n                <div class=\"forgotten-password\" *ngIf=\"vm.showForgotPassword\">\n                    <a class=\"forgotten-password-link\" (click)=\"flipCard()\">\n                        {{vm.appStrings['LBL_LOGIN_FORGOT_PASSWORD']}}\n                    </a>\n                </div>\n\n            </div>\n\n            <!-- Card back-->\n            <div class=\"fade-card-back col\"\n                 *ngIf=\"cardState==='back'\"\n                 [@fade]>\n                <div class=\"inner-addon left-addon\">\n                    <scrm-image image=\"login_user\"></scrm-image>\n                    <input [(ngModel)]=\"uname\"\n                           type=\"text\"\n                           name=\"username\"\n                           [class.is-invalid]=\"username.invalid && username.touched\"\n                           #username=\"ngModel\"\n                           placeholder=\"{{vm.appStrings['LBL_USER_NAME']}}\"\n                           aria-label=\"Username\"\n                           required>\n                    <div *ngIf=\"username.invalid && username.touched\" class=\"invalid-feedback\">\n                        {{vm.appStrings['ERR_MISSING_REQUIRED_FIELDS']}}\n                    </div>\n                </div>\n\n                <div class=\"inner-addon left-addon\">\n                    <scrm-image image=\"email\"></scrm-image>\n                    <input [(ngModel)]=\"email\"\n                           type=\"email\"\n                           name=\"email\"\n                           [class.is-invalid]=\"mail.invalid && mail.touched\"\n                           #mail=\"ngModel\"\n                           placeholder=\"{{vm.appStrings['LBL_EMAIL']}}\"\n                           aria-label=\"Email\"\n                           required>\n                    <div *ngIf=\"mail.invalid && mail.touched\" class=\"invalid-feedback\">\n                        {{vm.appStrings['ERR_MISSING_REQUIRED_FIELDS']}}\n                    </div>\n                </div>\n\n                <button class=\"submit-button login-button\"\n                        scrm-button-loading\n                        (click)=\"loginForm.control.markAllAsTouched(); loginForm.valid && recoverPassword()\">\n                    {{vm.appStrings['LBL_GENERATE_PASSWORD_BUTTON_TITLE']}}\n                </button>\n                <div>\n                    <a class=\"back-link forgotten-password-link\" (click)=\"flipCard()\">\n                        {{vm.appStrings['LBL_BACK']}}\n                    </a>\n                </div>\n            </div>\n        </div>\n    </form>\n\n    <!-- End of login form section -->\n\n</div>\n\n<!-- End of login component section -->\n" }]
    }], function () { return [{ type: i1.Router }, { type: i2.AuthService }, { type: i3.MessageService }, { type: i4.SystemConfigStore }, { type: i5.LanguageStore }, { type: i6.RecoverPasswordService }, { type: i7.AppStateStore }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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