import { ActivatedRouteSnapshot, Router } from '@angular/router';
import { ModuleNameMapper } from '../navigation/module-name-mapper/module-name-mapper.service';
import { ActionNameMapper } from '../navigation/action-name-mapper/action-name-mapper.service';
import { SystemConfigStore } from '../../store/system-config/system-config.store';
import { LanguageStore } from '../../store/language/language.store';
import { NavigationStore } from '../../store/navigation/navigation.store';
import { UserPreferenceStore } from '../../store/user-preference/user-preference.store';
import { ThemeImagesStore } from '../../store/theme-images/theme-images.store';
import { AppStateStore } from '../../store/app-state/app-state.store';
import { MetadataStore } from '../../store/metadata/metadata.store.service';
import { BaseModuleResolver } from './base-module.resolver';
import { Observable } from 'rxjs';
import { MessageService } from '../message/message.service';
import { RouteConverter } from "../navigation/route-converter/route-converter.service";
import { AppMetadataStore } from '../../store/app-metadata/app-metadata.store.service';
import { AuthService } from '../auth/auth.service';
import { RecentlyViewedService } from '../navigation/recently-viewed/recently-viewed.service';
import * as i0 from "@angular/core";
export declare class BaseRecordResolver extends BaseModuleResolver {
    protected systemConfigStore: SystemConfigStore;
    protected languageStore: LanguageStore;
    protected navigationStore: NavigationStore;
    protected metadataStore: MetadataStore;
    protected userPreferenceStore: UserPreferenceStore;
    protected themeImagesStore: ThemeImagesStore;
    protected moduleNameMapper: ModuleNameMapper;
    protected actionNameMapper: ActionNameMapper;
    protected appStateStore: AppStateStore;
    protected messageService: MessageService;
    protected routeConverter: RouteConverter;
    protected router: Router;
    protected appMetadata: AppMetadataStore;
    protected auth: AuthService;
    protected recentlyViewed: RecentlyViewedService;
    constructor(systemConfigStore: SystemConfigStore, languageStore: LanguageStore, navigationStore: NavigationStore, metadataStore: MetadataStore, userPreferenceStore: UserPreferenceStore, themeImagesStore: ThemeImagesStore, moduleNameMapper: ModuleNameMapper, actionNameMapper: ActionNameMapper, appStateStore: AppStateStore, messageService: MessageService, routeConverter: RouteConverter, router: Router, appMetadata: AppMetadataStore, auth: AuthService, recentlyViewed: RecentlyViewedService);
    resolve(route: ActivatedRouteSnapshot): Observable<any>;
    static ɵfac: i0.ɵɵFactoryDeclaration<BaseRecordResolver, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<BaseRecordResolver>;
}
//# sourceMappingURL=base-record.resolver.d.ts.map