/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2023 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Action, LogicDefinitions, ViewMode } from 'common';
import { RecordActionData } from '../../actions/record.action';
import { ActionLogicHandler } from '../../../../services/actions/action-logic-handler';
import { ActiveFieldsChecker } from "../../../../services/condition-operators/active-fields-checker.service";
import * as i0 from "@angular/core";
export declare class RecordActionDisplayTypeLogic extends ActionLogicHandler<RecordActionData> {
    protected activeFieldsChecker: ActiveFieldsChecker;
    key: string;
    modes: ViewMode[];
    constructor(activeFieldsChecker: ActiveFieldsChecker);
    runAll(displayLogic: LogicDefinitions, data: RecordActionData): boolean;
    run(data: RecordActionData, logic: Action): boolean;
    static ɵfac: i0.ɵɵFactoryDeclaration<RecordActionDisplayTypeLogic, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<RecordActionDisplayTypeLogic>;
}
//# sourceMappingURL=display-type.logic.d.ts.map