/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { GroupFieldModule } from './group-field/group-field.module';
import { baseFieldComponents, baseFieldModules, baseViewFieldsMap } from './base-fields.manifest';
import { GroupFieldComponent } from './group-field/group-field.component';
import { CompositeComponent } from './composite/composite.component';
import { CompositeModule } from './composite/composite.module';
export const fieldModules = [
    ...baseFieldModules,
    GroupFieldModule,
    CompositeModule
];
export const fieldComponents = [
    ...baseFieldComponents,
    GroupFieldComponent,
    CompositeComponent
];
export const viewFieldsMap = {
    ...baseViewFieldsMap,
    'grouped-field.list': GroupFieldComponent,
    'grouped-field.detail': GroupFieldComponent,
    'grouped-field.edit': GroupFieldComponent,
    'grouped-field.filter': GroupFieldComponent,
    'composite.list': CompositeComponent,
    'composite.detail': CompositeComponent,
    'composite.edit': CompositeComponent,
    'composite.filter': CompositeComponent,
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmllbGQubWFuaWZlc3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9jb3JlL2FwcC9jb3JlL3NyYy9saWIvZmllbGRzL2ZpZWxkLm1hbmlmZXN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7R0F3Qkc7QUFFSCxPQUFPLEVBQUMsZ0JBQWdCLEVBQUMsTUFBTSxrQ0FBa0MsQ0FBQztBQUNsRSxPQUFPLEVBQUMsbUJBQW1CLEVBQUUsZ0JBQWdCLEVBQUUsaUJBQWlCLEVBQUMsTUFBTSx3QkFBd0IsQ0FBQztBQUNoRyxPQUFPLEVBQUMsbUJBQW1CLEVBQUMsTUFBTSxxQ0FBcUMsQ0FBQztBQUV4RSxPQUFPLEVBQUMsa0JBQWtCLEVBQUMsTUFBTSxpQ0FBaUMsQ0FBQztBQUNuRSxPQUFPLEVBQUMsZUFBZSxFQUFDLE1BQU0sOEJBQThCLENBQUM7QUFFN0QsTUFBTSxDQUFDLE1BQU0sWUFBWSxHQUFHO0lBQ3hCLEdBQUcsZ0JBQWdCO0lBQ25CLGdCQUFnQjtJQUNoQixlQUFlO0NBQ2xCLENBQUM7QUFDRixNQUFNLENBQUMsTUFBTSxlQUFlLEdBQUc7SUFDM0IsR0FBRyxtQkFBbUI7SUFDdEIsbUJBQW1CO0lBQ25CLGtCQUFrQjtDQUNyQixDQUFDO0FBRUYsTUFBTSxDQUFDLE1BQU0sYUFBYSxHQUFzQjtJQUM1QyxHQUFHLGlCQUFpQjtJQUNwQixvQkFBb0IsRUFBRSxtQkFBbUI7SUFDekMsc0JBQXNCLEVBQUUsbUJBQW1CO0lBQzNDLG9CQUFvQixFQUFFLG1CQUFtQjtJQUN6QyxzQkFBc0IsRUFBRSxtQkFBbUI7SUFDM0MsZ0JBQWdCLEVBQUUsa0JBQWtCO0lBQ3BDLGtCQUFrQixFQUFFLGtCQUFrQjtJQUN0QyxnQkFBZ0IsRUFBRSxrQkFBa0I7SUFDcEMsa0JBQWtCLEVBQUUsa0JBQWtCO0NBQ3pDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIFN1aXRlQ1JNIGlzIGEgY3VzdG9tZXIgcmVsYXRpb25zaGlwIG1hbmFnZW1lbnQgcHJvZ3JhbSBkZXZlbG9wZWQgYnkgU2FsZXNBZ2lsaXR5IEx0ZC5cbiAqIENvcHlyaWdodCAoQykgMjAyMSBTYWxlc0FnaWxpdHkgTHRkLlxuICpcbiAqIFRoaXMgcHJvZ3JhbSBpcyBmcmVlIHNvZnR3YXJlOyB5b3UgY2FuIHJlZGlzdHJpYnV0ZSBpdCBhbmQvb3IgbW9kaWZ5IGl0IHVuZGVyXG4gKiB0aGUgdGVybXMgb2YgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZSB2ZXJzaW9uIDMgYXMgcHVibGlzaGVkIGJ5IHRoZVxuICogRnJlZSBTb2Z0d2FyZSBGb3VuZGF0aW9uIHdpdGggdGhlIGFkZGl0aW9uIG9mIHRoZSBmb2xsb3dpbmcgcGVybWlzc2lvbiBhZGRlZFxuICogdG8gU2VjdGlvbiAxNSBhcyBwZXJtaXR0ZWQgaW4gU2VjdGlvbiA3KGEpOiBGT1IgQU5ZIFBBUlQgT0YgVEhFIENPVkVSRUQgV09SS1xuICogSU4gV0hJQ0ggVEhFIENPUFlSSUdIVCBJUyBPV05FRCBCWSBTQUxFU0FHSUxJVFksIFNBTEVTQUdJTElUWSBESVNDTEFJTVMgVEhFXG4gKiBXQVJSQU5UWSBPRiBOT04gSU5GUklOR0VNRU5UIE9GIFRISVJEIFBBUlRZIFJJR0hUUy5cbiAqXG4gKiBUaGlzIHByb2dyYW0gaXMgZGlzdHJpYnV0ZWQgaW4gdGhlIGhvcGUgdGhhdCBpdCB3aWxsIGJlIHVzZWZ1bCwgYnV0IFdJVEhPVVRcbiAqIEFOWSBXQVJSQU5UWTsgd2l0aG91dCBldmVuIHRoZSBpbXBsaWVkIHdhcnJhbnR5IG9mIE1FUkNIQU5UQUJJTElUWSBvciBGSVRORVNTXG4gKiBGT1IgQSBQQVJUSUNVTEFSIFBVUlBPU0UuIFNlZSB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlIGZvciBtb3JlXG4gKiBkZXRhaWxzLlxuICpcbiAqIFlvdSBzaG91bGQgaGF2ZSByZWNlaXZlZCBhIGNvcHkgb2YgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZVxuICogYWxvbmcgd2l0aCB0aGlzIHByb2dyYW0uICBJZiBub3QsIHNlZSA8aHR0cDovL3d3dy5nbnUub3JnL2xpY2Vuc2VzLz4uXG4gKlxuICogSW4gYWNjb3JkYW5jZSB3aXRoIFNlY3Rpb24gNyhiKSBvZiB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlXG4gKiB2ZXJzaW9uIDMsIHRoZXNlIEFwcHJvcHJpYXRlIExlZ2FsIE5vdGljZXMgbXVzdCByZXRhaW4gdGhlIGRpc3BsYXkgb2YgdGhlXG4gKiBcIlN1cGVyY2hhcmdlZCBieSBTdWl0ZUNSTVwiIGxvZ28uIElmIHRoZSBkaXNwbGF5IG9mIHRoZSBsb2dvcyBpcyBub3QgcmVhc29uYWJseVxuICogZmVhc2libGUgZm9yIHRlY2huaWNhbCByZWFzb25zLCB0aGUgQXBwcm9wcmlhdGUgTGVnYWwgTm90aWNlcyBtdXN0IGRpc3BsYXlcbiAqIHRoZSB3b3JkcyBcIlN1cGVyY2hhcmdlZCBieSBTdWl0ZUNSTVwiLlxuICovXG5cbmltcG9ydCB7R3JvdXBGaWVsZE1vZHVsZX0gZnJvbSAnLi9ncm91cC1maWVsZC9ncm91cC1maWVsZC5tb2R1bGUnO1xuaW1wb3J0IHtiYXNlRmllbGRDb21wb25lbnRzLCBiYXNlRmllbGRNb2R1bGVzLCBiYXNlVmlld0ZpZWxkc01hcH0gZnJvbSAnLi9iYXNlLWZpZWxkcy5tYW5pZmVzdCc7XG5pbXBvcnQge0dyb3VwRmllbGRDb21wb25lbnR9IGZyb20gJy4vZ3JvdXAtZmllbGQvZ3JvdXAtZmllbGQuY29tcG9uZW50JztcbmltcG9ydCB7RmllbGRDb21wb25lbnRNYXB9IGZyb20gJy4vZmllbGQubW9kZWwnO1xuaW1wb3J0IHtDb21wb3NpdGVDb21wb25lbnR9IGZyb20gJy4vY29tcG9zaXRlL2NvbXBvc2l0ZS5jb21wb25lbnQnO1xuaW1wb3J0IHtDb21wb3NpdGVNb2R1bGV9IGZyb20gJy4vY29tcG9zaXRlL2NvbXBvc2l0ZS5tb2R1bGUnO1xuXG5leHBvcnQgY29uc3QgZmllbGRNb2R1bGVzID0gW1xuICAgIC4uLmJhc2VGaWVsZE1vZHVsZXMsXG4gICAgR3JvdXBGaWVsZE1vZHVsZSxcbiAgICBDb21wb3NpdGVNb2R1bGVcbl07XG5leHBvcnQgY29uc3QgZmllbGRDb21wb25lbnRzID0gW1xuICAgIC4uLmJhc2VGaWVsZENvbXBvbmVudHMsXG4gICAgR3JvdXBGaWVsZENvbXBvbmVudCxcbiAgICBDb21wb3NpdGVDb21wb25lbnRcbl07XG5cbmV4cG9ydCBjb25zdCB2aWV3RmllbGRzTWFwOiBGaWVsZENvbXBvbmVudE1hcCA9IHtcbiAgICAuLi5iYXNlVmlld0ZpZWxkc01hcCxcbiAgICAnZ3JvdXBlZC1maWVsZC5saXN0JzogR3JvdXBGaWVsZENvbXBvbmVudCxcbiAgICAnZ3JvdXBlZC1maWVsZC5kZXRhaWwnOiBHcm91cEZpZWxkQ29tcG9uZW50LFxuICAgICdncm91cGVkLWZpZWxkLmVkaXQnOiBHcm91cEZpZWxkQ29tcG9uZW50LFxuICAgICdncm91cGVkLWZpZWxkLmZpbHRlcic6IEdyb3VwRmllbGRDb21wb25lbnQsXG4gICAgJ2NvbXBvc2l0ZS5saXN0JzogQ29tcG9zaXRlQ29tcG9uZW50LFxuICAgICdjb21wb3NpdGUuZGV0YWlsJzogQ29tcG9zaXRlQ29tcG9uZW50LFxuICAgICdjb21wb3NpdGUuZWRpdCc6IENvbXBvc2l0ZUNvbXBvbmVudCxcbiAgICAnY29tcG9zaXRlLmZpbHRlcic6IENvbXBvc2l0ZUNvbXBvbmVudCxcbn07XG4iXX0=