/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Injectable } from '@angular/core';
import { Router } from '@angular/router';
import { ModuleNameMapper } from '../module-name-mapper/module-name-mapper.service';
import { ActionNameMapper } from '../action-name-mapper/action-name-mapper.service';
import * as i0 from "@angular/core";
import * as i1 from "@angular/router";
import * as i2 from "../module-name-mapper/module-name-mapper.service";
import * as i3 from "../action-name-mapper/action-name-mapper.service";
const ROUTE_PREFIX = './#';
class ModuleNavigation {
    constructor(router, moduleNameMapper, actionNameMapper) {
        this.router = router;
        this.moduleNameMapper = moduleNameMapper;
        this.actionNameMapper = actionNameMapper;
    }
    /**
     * Public Api
     */
    /**
     * Get module info
     *
     * @param {string} module name
     * @param {object} navigation info
     * @returns {object} module info
     */
    getModuleInfo(module, navigation) {
        if (!navigation || !navigation.modules) {
            return null;
        }
        return navigation.modules[module];
    }
    /**
     * Get module label
     *
     * @param {object} module info
     * @param {object} appListStrings map
     * @returns {string} the module label
     */
    getModuleLabel(module, appListStrings) {
        if (!appListStrings || !appListStrings.moduleList || !module) {
            return '';
        }
        const labelKey = (module && module.labelKey) || '';
        return appListStrings.moduleList[labelKey] || labelKey;
    }
    /**
     * Get module route
     *
     * @param {object} module NavbarModule
     * @returns {object} NavigationRoute
     */
    getModuleRoute(module) {
        let url = (module && module.defaultRoute) || '';
        let route = null;
        const params = null;
        if (url.startsWith(ROUTE_PREFIX)) {
            route = url.replace(ROUTE_PREFIX, '');
            url = null;
        }
        return { route, url, params };
    }
    /**
     * Navigate using action information
     *
     * @param {object} item ModuleAction
     * @returns {object} Promise<boolean>
     */
    navigate(item) {
        const route = this.getActionRoute(item);
        return this.router.navigate([route.route], {
            queryParams: route.params
        });
    }
    /**
     * Navigate using menu item information
     *
     * @param {object} item MenuItem
     */
    navigateUsingMenuItem(item) {
        if (item.link.route) {
            this.router.navigate([item.link.route ?? ''], {
                queryParams: item.link.params ?? {}
            }).then();
            return;
        }
        if (item.link.url) {
            this.router.navigateByUrl(item.link.url ?? '').then();
            return;
        }
    }
    /**
     * Get action route info
     *
     * @param {object} action ModuleAction
     * @returns {object} NavigationRoute
     */
    getActionRoute(action) {
        let url = action.url;
        let route = null;
        let params = {};
        let process = action?.process;
        if (url.startsWith(ROUTE_PREFIX)) {
            route = url.replace(ROUTE_PREFIX, '');
            url = null;
            if (action.params) {
                params = action.params;
            }
            else {
                const routeParts = route.split('?');
                route = routeParts[0];
                const queryParamsStr = routeParts[1];
                const queryParamsObj = {};
                if (queryParamsStr) {
                    queryParamsStr.split('&').forEach(param => {
                        const keyValue = param.split('=');
                        queryParamsObj[keyValue[0]] = keyValue[1];
                    });
                }
                params = queryParamsObj;
            }
        }
        return { route, url, params, process };
    }
    /**
     * Get label for module action item
     *
     * @param {string} module name
     * @param {object} item action
     * @param {object} languages map
     * @param {string} labelKey to use
     * @returns {string} label
     */
    getActionLabel(module, item, languages, labelKey = '') {
        if (!languages || !languages.modStrings || !item || !module) {
            return '';
        }
        let key = labelKey;
        if (!key) {
            key = item.labelKey;
        }
        let label = languages.modStrings[module] && languages.modStrings[module][key];
        if (!label) {
            label = languages.appStrings && languages.appStrings[key];
        }
        if (!label && item.module) {
            label = languages.modStrings[item.module] && languages.modStrings[item.module][key];
        }
        if (!label) {
            label = languages.modStrings.administration && languages.modStrings.administration[key];
        }
        return label || '';
    }
    /**
     * Get record router link route info
     *
     * @param {string} module name
     * @param {string} id fo the record
     * @returns {string} router link
     */
    getRecordRouterLink(module, id, isEdit) {
        if (isEdit) {
            return `/${module}/edit/${id}`;
        }
        return `/${module}/record/${id}`;
    }
    /**
     * Navigate back using return params
     * @param record
     * @param moduleName
     * @param params
     */
    navigateBack(record, moduleName, params) {
        let returnModule = this.getReturnModule(params);
        let returnAction = this.getReturnAction(params);
        const returnId = this.getReturnId(params);
        let route = '';
        if (returnModule) {
            route += '/' + returnModule;
        }
        if (returnAction) {
            route += '/' + returnAction;
        }
        if (returnId) {
            route += '/' + returnId;
        }
        if (returnModule === moduleName && returnAction === 'record') {
            const rid = !returnId ? record.id : returnId;
            route = '/' + moduleName + '/record/' + rid;
        }
        if (!route && record && record.id) {
            route = '/' + moduleName + '/record/' + record.id;
        }
        if (!route && record && record.id) {
            route = '/' + moduleName;
        }
        this.router.navigate([route]).then();
    }
    /**
     * Extract return id
     * @param params
     */
    getReturnId(params) {
        return params.return_id || '';
    }
    /**
     * Extract and map return action
     * @param params
     */
    getReturnAction(params) {
        let returnAction = '';
        if (params.return_action) {
            returnAction = this.actionNameMapper.toFrontend(params.return_action);
        }
        return returnAction;
    }
    /**
     * Extract and map return action
     * @param params
     */
    getReturnModule(params) {
        let returnModule = '';
        if (params.return_module) {
            returnModule = this.moduleNameMapper.toFrontend(params.return_module);
        }
        return returnModule;
    }
    static { this.ɵfac = function ModuleNavigation_Factory(t) { return new (t || ModuleNavigation)(i0.ɵɵinject(i1.Router), i0.ɵɵinject(i2.ModuleNameMapper), i0.ɵɵinject(i3.ActionNameMapper)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ModuleNavigation, factory: ModuleNavigation.ɵfac, providedIn: 'root' }); }
}
export { ModuleNavigation };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ModuleNavigation, [{
        type: Injectable,
        args: [{ providedIn: 'root' }]
    }], function () { return [{ type: i1.Router }, { type: i2.ModuleNameMapper }, { type: i3.ActionNameMapper }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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