import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
export const duplicateEmailValidator = (viewField, record) => ((control) => {
    const name = viewField.name || '';
    if (!name || !record || !record.fields) {
        return null;
    }
    const field = record.fields[name] || {};
    const items = field.items;
    if (!field || !items || !items.length) {
        return null;
    }
    const addresses = {};
    let count = 0;
    const activeItems = items.filter(item => !(item && item.attributes && item.attributes.deleted));
    if (activeItems && activeItems.length < 1) {
        return null;
    }
    activeItems.some(item => {
        const emailField = (item.fields && item.fields['email-fields']) || {};
        const emailAddress = (emailField.attributes && emailField.attributes['email_address']) || null;
        if (!emailAddress.value) {
            return false;
        }
        const upperCaseValue = ("" + emailAddress.value).toUpperCase();
        if (addresses[upperCaseValue]) {
            count++;
            return true;
        }
        addresses[upperCaseValue] = true;
        return count > 1;
    });
    if (count == 0) {
        return null;
    }
    return {
        duplicateEmailValidation: {
            valid: false,
            message: {
                labelKey: 'LBL_DUPLICATE_EMAIL_VALIDATION_ERROR',
                context: {}
            }
        },
    };
});
class DuplicateEmailValidator {
    constructor() {
    }
    applies(record, viewField) {
        if (!viewField || !viewField.fieldDefinition) {
            return false;
        }
        const type = viewField.type || viewField.fieldDefinition.type || '';
        const name = viewField.name || viewField.fieldDefinition.name || '';
        return type === 'line-items' && name === 'email_addresses';
    }
    getValidator(viewField, record) {
        if (!viewField || !viewField.fieldDefinition || !record) {
            return [];
        }
        return [duplicateEmailValidator(viewField, record)];
    }
    static { this.ɵfac = function DuplicateEmailValidator_Factory(t) { return new (t || DuplicateEmailValidator)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: DuplicateEmailValidator, factory: DuplicateEmailValidator.ɵfac, providedIn: 'root' }); }
}
export { DuplicateEmailValidator };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DuplicateEmailValidator, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return []; }, null); })();
//# sourceMappingURL=data:application/json;base64,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