import { Injectable } from '@angular/core';
import { EmailFormatter } from '../../../formatters/email/email-formatter.service';
import * as i0 from "@angular/core";
import * as i1 from "../../../formatters/email/email-formatter.service";
export const emailValidator = (formatter, customValidationRegex) => ((control) => {
    const validationRegex = customValidationRegex || formatter.getUserFormatPattern();
    const invalid = formatter.validateUserFormat(control.value, validationRegex);
    return invalid ? {
        emailValidator: {
            valid: false,
            format: new RegExp(validationRegex),
            message: {
                labelKey: 'LBL_VALIDATION_ERROR_EMAIL_FORMAT',
                context: {
                    value: control.value,
                    expected: 'example@example.org'
                }
            }
        },
    } : null;
});
class EmailValidator {
    constructor(formatter) {
        this.formatter = formatter;
    }
    applies(record, viewField) {
        if (!viewField || !viewField.fieldDefinition) {
            return false;
        }
        return viewField.type === 'email';
    }
    getValidator(viewField) {
        if (!viewField || !viewField.fieldDefinition) {
            return [];
        }
        const customValidationRegex = viewField?.fieldDefinition?.validation?.regex.toString() ?? null;
        return [emailValidator(this.formatter, customValidationRegex)];
    }
    static { this.ɵfac = function EmailValidator_Factory(t) { return new (t || EmailValidator)(i0.ɵɵinject(i1.EmailFormatter)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: EmailValidator, factory: EmailValidator.ɵfac, providedIn: 'root' }); }
}
export { EmailValidator };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EmailValidator, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i1.EmailFormatter }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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