import { Validators } from '@angular/forms';
import { Injectable } from '@angular/core';
import { isNumber } from "lodash-es";
import * as i0 from "@angular/core";
export const minValidator = (min) => ((control) => {
    const result = Validators.min(min)(control);
    if (result === null) {
        return null;
    }
    return {
        emailValidator: {
            ...result,
            message: {
                labelKey: 'LBL_VALIDATION_ERROR_MIN',
                context: {
                    value: control.value,
                    min: '' + min
                }
            }
        }
    };
});
export const maxValidator = (max) => ((control) => {
    const result = Validators.max(max)(control);
    if (result === null) {
        return null;
    }
    return {
        emailValidator: {
            ...result,
            message: {
                labelKey: 'LBL_VALIDATION_ERROR_MAX',
                context: {
                    value: control.value,
                    max: '' + max
                }
            }
        }
    };
});
class RangeValidator {
    applies(record, viewField) {
        if (!viewField || !viewField.fieldDefinition) {
            return false;
        }
        const definition = viewField.fieldDefinition;
        return this.getRangeValidation(definition) !== null;
    }
    getValidator(viewField) {
        if (!viewField || !viewField.fieldDefinition) {
            return [];
        }
        const validation = this.getRangeValidation(viewField.fieldDefinition);
        if (!validation) {
            return [];
        }
        let max = null;
        if (isNumber(validation?.max)) {
            max = parseInt('' + validation.max, 10);
        }
        let min = null;
        if (isNumber(validation?.min)) {
            min = parseInt('' + validation.min, 10);
        }
        const validations = [];
        if (isNumber(min) && isFinite(min)) {
            validations.push(minValidator(min));
        }
        if (isNumber(max) && isFinite(max)) {
            validations.push(maxValidator(max));
        }
        return validations;
    }
    getRangeValidation(definition) {
        if (this.isRangeValidation(definition.validation)) {
            return definition.validation;
        }
        if (!definition.validations || !definition.validations.length) {
            return null;
        }
        let validation = null;
        definition.validations.some(entry => {
            validation = entry;
            return this.isRangeValidation(entry);
        });
        return validation;
    }
    isRangeValidation(validation) {
        return validation && validation.type === 'range';
    }
    static { this.ɵfac = function RangeValidator_Factory(t) { return new (t || RangeValidator)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: RangeValidator, factory: RangeValidator.ɵfac, providedIn: 'root' }); }
}
export { RangeValidator };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RangeValidator, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmFuZ2UudmFsaWRhdG9yLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vY29yZS9hcHAvY29yZS9zcmMvbGliL3NlcnZpY2VzL3JlY29yZC92YWxpZGF0aW9uL3ZhbGlkYXRvcnMvcmFuZ2UudmFsaWRhdG9yLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQTJCQSxPQUFPLEVBQWtCLFVBQVUsRUFBQyxNQUFNLGdCQUFnQixDQUFDO0FBUzNELE9BQU8sRUFBQyxVQUFVLEVBQUMsTUFBTSxlQUFlLENBQUM7QUFDekMsT0FBTyxFQUFDLFFBQVEsRUFBQyxNQUFNLFdBQVcsQ0FBQzs7QUFFbkMsTUFBTSxDQUFDLE1BQU0sWUFBWSxHQUFHLENBQUMsR0FBVyxFQUF1QixFQUFFLENBQUMsQ0FDOUQsQ0FBQyxPQUF3QixFQUFtQyxFQUFFO0lBRTFELE1BQU0sTUFBTSxHQUFHLFVBQVUsQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUM7SUFFNUMsSUFBSSxNQUFNLEtBQUssSUFBSSxFQUFFO1FBQ2pCLE9BQU8sSUFBSSxDQUFDO0tBQ2Y7SUFFRCxPQUFPO1FBQ0gsY0FBYyxFQUFFO1lBQ1osR0FBRyxNQUFNO1lBQ1QsT0FBTyxFQUFFO2dCQUNMLFFBQVEsRUFBRSwwQkFBMEI7Z0JBQ3BDLE9BQU8sRUFBRTtvQkFDTCxLQUFLLEVBQUUsT0FBTyxDQUFDLEtBQUs7b0JBQ3BCLEdBQUcsRUFBRSxFQUFFLEdBQUcsR0FBRztpQkFDaEI7YUFDSjtTQUNKO0tBQ0osQ0FBQztBQUNOLENBQUMsQ0FDSixDQUFDO0FBRUYsTUFBTSxDQUFDLE1BQU0sWUFBWSxHQUFHLENBQUMsR0FBVyxFQUF1QixFQUFFLENBQUMsQ0FDOUQsQ0FBQyxPQUF3QixFQUFtQyxFQUFFO0lBRTFELE1BQU0sTUFBTSxHQUFHLFVBQVUsQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUM7SUFFNUMsSUFBSSxNQUFNLEtBQUssSUFBSSxFQUFFO1FBQ2pCLE9BQU8sSUFBSSxDQUFDO0tBQ2Y7SUFFRCxPQUFPO1FBQ0gsY0FBYyxFQUFFO1lBQ1osR0FBRyxNQUFNO1lBQ1QsT0FBTyxFQUFFO2dCQUNMLFFBQVEsRUFBRSwwQkFBMEI7Z0JBQ3BDLE9BQU8sRUFBRTtvQkFDTCxLQUFLLEVBQUUsT0FBTyxDQUFDLEtBQUs7b0JBQ3BCLEdBQUcsRUFBRSxFQUFFLEdBQUcsR0FBRztpQkFDaEI7YUFDSjtTQUNKO0tBQ0osQ0FBQztBQUNOLENBQUMsQ0FDSixDQUFDO0FBRUYsTUFHYSxjQUFjO0lBRXZCLE9BQU8sQ0FBQyxNQUFjLEVBQUUsU0FBOEI7UUFDbEQsSUFBSSxDQUFDLFNBQVMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxlQUFlLEVBQUU7WUFDMUMsT0FBTyxLQUFLLENBQUM7U0FDaEI7UUFFRCxNQUFNLFVBQVUsR0FBRyxTQUFTLENBQUMsZUFBZSxDQUFDO1FBRTdDLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxLQUFLLElBQUksQ0FBQztJQUN4RCxDQUFDO0lBRUQsWUFBWSxDQUFDLFNBQThCO1FBRXZDLElBQUksQ0FBQyxTQUFTLElBQUksQ0FBQyxTQUFTLENBQUMsZUFBZSxFQUFFO1lBQzFDLE9BQU8sRUFBRSxDQUFDO1NBQ2I7UUFFRCxNQUFNLFVBQVUsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBRXRFLElBQUksQ0FBQyxVQUFVLEVBQUU7WUFDYixPQUFPLEVBQUUsQ0FBQztTQUNiO1FBRUQsSUFBSSxHQUFHLEdBQUcsSUFBSSxDQUFDO1FBQ2YsSUFBSSxRQUFRLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxFQUFFO1lBQzNCLEdBQUcsR0FBRyxRQUFRLENBQUMsRUFBRSxHQUFHLFVBQVUsQ0FBQyxHQUFHLEVBQUUsRUFBRSxDQUFDLENBQUM7U0FDM0M7UUFFRCxJQUFJLEdBQUcsR0FBRyxJQUFJLENBQUM7UUFDZixJQUFJLFFBQVEsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLEVBQUU7WUFDM0IsR0FBRyxHQUFHLFFBQVEsQ0FBQyxFQUFFLEdBQUcsVUFBVSxDQUFDLEdBQUcsRUFBRSxFQUFFLENBQUMsQ0FBQztTQUMzQztRQUVELE1BQU0sV0FBVyxHQUFHLEVBQUUsQ0FBQztRQUV2QixJQUFJLFFBQVEsQ0FBQyxHQUFHLENBQUMsSUFBSSxRQUFRLENBQUMsR0FBRyxDQUFDLEVBQUU7WUFDaEMsV0FBVyxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztTQUN2QztRQUVELElBQUksUUFBUSxDQUFDLEdBQUcsQ0FBQyxJQUFJLFFBQVEsQ0FBQyxHQUFHLENBQUMsRUFBRTtZQUNoQyxXQUFXLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO1NBQ3ZDO1FBRUQsT0FBTyxXQUFXLENBQUM7SUFDdkIsQ0FBQztJQUVTLGtCQUFrQixDQUFDLFVBQTJCO1FBRXBELElBQUksSUFBSSxDQUFDLGlCQUFpQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtZQUMvQyxPQUFPLFVBQVUsQ0FBQyxVQUFVLENBQUM7U0FDaEM7UUFFRCxJQUFJLENBQUMsVUFBVSxDQUFDLFdBQVcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsTUFBTSxFQUFFO1lBQzNELE9BQU8sSUFBSSxDQUFDO1NBQ2Y7UUFFRCxJQUFJLFVBQVUsR0FBeUIsSUFBSSxDQUFDO1FBRTVDLFVBQVUsQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQ2hDLFVBQVUsR0FBRyxLQUFLLENBQUM7WUFDbkIsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDekMsQ0FBQyxDQUFDLENBQUM7UUFFSCxPQUFPLFVBQVUsQ0FBQztJQUN0QixDQUFDO0lBRVMsaUJBQWlCLENBQUMsVUFBZ0M7UUFDeEQsT0FBTyxVQUFVLElBQUksVUFBVSxDQUFDLElBQUksS0FBSyxPQUFPLENBQUM7SUFDckQsQ0FBQzsrRUFyRVEsY0FBYzt1RUFBZCxjQUFjLFdBQWQsY0FBYyxtQkFGWCxNQUFNOztTQUVULGNBQWM7dUZBQWQsY0FBYztjQUgxQixVQUFVO2VBQUM7Z0JBQ1IsVUFBVSxFQUFFLE1BQU07YUFDckIiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIFN1aXRlQ1JNIGlzIGEgY3VzdG9tZXIgcmVsYXRpb25zaGlwIG1hbmFnZW1lbnQgcHJvZ3JhbSBkZXZlbG9wZWQgYnkgU2FsZXNBZ2lsaXR5IEx0ZC5cbiAqIENvcHlyaWdodCAoQykgMjAyMSBTYWxlc0FnaWxpdHkgTHRkLlxuICpcbiAqIFRoaXMgcHJvZ3JhbSBpcyBmcmVlIHNvZnR3YXJlOyB5b3UgY2FuIHJlZGlzdHJpYnV0ZSBpdCBhbmQvb3IgbW9kaWZ5IGl0IHVuZGVyXG4gKiB0aGUgdGVybXMgb2YgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZSB2ZXJzaW9uIDMgYXMgcHVibGlzaGVkIGJ5IHRoZVxuICogRnJlZSBTb2Z0d2FyZSBGb3VuZGF0aW9uIHdpdGggdGhlIGFkZGl0aW9uIG9mIHRoZSBmb2xsb3dpbmcgcGVybWlzc2lvbiBhZGRlZFxuICogdG8gU2VjdGlvbiAxNSBhcyBwZXJtaXR0ZWQgaW4gU2VjdGlvbiA3KGEpOiBGT1IgQU5ZIFBBUlQgT0YgVEhFIENPVkVSRUQgV09SS1xuICogSU4gV0hJQ0ggVEhFIENPUFlSSUdIVCBJUyBPV05FRCBCWSBTQUxFU0FHSUxJVFksIFNBTEVTQUdJTElUWSBESVNDTEFJTVMgVEhFXG4gKiBXQVJSQU5UWSBPRiBOT04gSU5GUklOR0VNRU5UIE9GIFRISVJEIFBBUlRZIFJJR0hUUy5cbiAqXG4gKiBUaGlzIHByb2dyYW0gaXMgZGlzdHJpYnV0ZWQgaW4gdGhlIGhvcGUgdGhhdCBpdCB3aWxsIGJlIHVzZWZ1bCwgYnV0IFdJVEhPVVRcbiAqIEFOWSBXQVJSQU5UWTsgd2l0aG91dCBldmVuIHRoZSBpbXBsaWVkIHdhcnJhbnR5IG9mIE1FUkNIQU5UQUJJTElUWSBvciBGSVRORVNTXG4gKiBGT1IgQSBQQVJUSUNVTEFSIFBVUlBPU0UuIFNlZSB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlIGZvciBtb3JlXG4gKiBkZXRhaWxzLlxuICpcbiAqIFlvdSBzaG91bGQgaGF2ZSByZWNlaXZlZCBhIGNvcHkgb2YgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZVxuICogYWxvbmcgd2l0aCB0aGlzIHByb2dyYW0uICBJZiBub3QsIHNlZSA8aHR0cDovL3d3dy5nbnUub3JnL2xpY2Vuc2VzLz4uXG4gKlxuICogSW4gYWNjb3JkYW5jZSB3aXRoIFNlY3Rpb24gNyhiKSBvZiB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlXG4gKiB2ZXJzaW9uIDMsIHRoZXNlIEFwcHJvcHJpYXRlIExlZ2FsIE5vdGljZXMgbXVzdCByZXRhaW4gdGhlIGRpc3BsYXkgb2YgdGhlXG4gKiBcIlN1cGVyY2hhcmdlZCBieSBTdWl0ZUNSTVwiIGxvZ28uIElmIHRoZSBkaXNwbGF5IG9mIHRoZSBsb2dvcyBpcyBub3QgcmVhc29uYWJseVxuICogZmVhc2libGUgZm9yIHRlY2huaWNhbCByZWFzb25zLCB0aGUgQXBwcm9wcmlhdGUgTGVnYWwgTm90aWNlcyBtdXN0IGRpc3BsYXlcbiAqIHRoZSB3b3JkcyBcIlN1cGVyY2hhcmdlZCBieSBTdWl0ZUNSTVwiLlxuICovXG5cbmltcG9ydCB7VmFsaWRhdG9ySW50ZXJmYWNlfSBmcm9tICcuLi92YWxpZGF0b3IuSW50ZXJmYWNlJztcbmltcG9ydCB7QWJzdHJhY3RDb250cm9sLCBWYWxpZGF0b3JzfSBmcm9tICdAYW5ndWxhci9mb3Jtcyc7XG5pbXBvcnQge1xuICAgIEZpZWxkRGVmaW5pdGlvbixcbiAgICBSZWNvcmQsXG4gICAgU3RhbmRhcmRWYWxpZGF0aW9uRXJyb3JzLFxuICAgIFN0YW5kYXJkVmFsaWRhdG9yRm4sXG4gICAgVmFsaWRhdGlvbkRlZmluaXRpb24sXG4gICAgVmlld0ZpZWxkRGVmaW5pdGlvblxufSBmcm9tICdjb21tb24nO1xuaW1wb3J0IHtJbmplY3RhYmxlfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7aXNOdW1iZXJ9IGZyb20gXCJsb2Rhc2gtZXNcIjtcblxuZXhwb3J0IGNvbnN0IG1pblZhbGlkYXRvciA9IChtaW46IG51bWJlcik6IFN0YW5kYXJkVmFsaWRhdG9yRm4gPT4gKFxuICAgIChjb250cm9sOiBBYnN0cmFjdENvbnRyb2wpOiBTdGFuZGFyZFZhbGlkYXRpb25FcnJvcnMgfCBudWxsID0+IHtcblxuICAgICAgICBjb25zdCByZXN1bHQgPSBWYWxpZGF0b3JzLm1pbihtaW4pKGNvbnRyb2wpO1xuXG4gICAgICAgIGlmIChyZXN1bHQgPT09IG51bGwpIHtcbiAgICAgICAgICAgIHJldHVybiBudWxsO1xuICAgICAgICB9XG5cbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGVtYWlsVmFsaWRhdG9yOiB7XG4gICAgICAgICAgICAgICAgLi4ucmVzdWx0LFxuICAgICAgICAgICAgICAgIG1lc3NhZ2U6IHtcbiAgICAgICAgICAgICAgICAgICAgbGFiZWxLZXk6ICdMQkxfVkFMSURBVElPTl9FUlJPUl9NSU4nLFxuICAgICAgICAgICAgICAgICAgICBjb250ZXh0OiB7XG4gICAgICAgICAgICAgICAgICAgICAgICB2YWx1ZTogY29udHJvbC52YWx1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgIG1pbjogJycgKyBtaW5cbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgfTtcbiAgICB9XG4pO1xuXG5leHBvcnQgY29uc3QgbWF4VmFsaWRhdG9yID0gKG1heDogbnVtYmVyKTogU3RhbmRhcmRWYWxpZGF0b3JGbiA9PiAoXG4gICAgKGNvbnRyb2w6IEFic3RyYWN0Q29udHJvbCk6IFN0YW5kYXJkVmFsaWRhdGlvbkVycm9ycyB8IG51bGwgPT4ge1xuXG4gICAgICAgIGNvbnN0IHJlc3VsdCA9IFZhbGlkYXRvcnMubWF4KG1heCkoY29udHJvbCk7XG5cbiAgICAgICAgaWYgKHJlc3VsdCA9PT0gbnVsbCkge1xuICAgICAgICAgICAgcmV0dXJuIG51bGw7XG4gICAgICAgIH1cblxuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgZW1haWxWYWxpZGF0b3I6IHtcbiAgICAgICAgICAgICAgICAuLi5yZXN1bHQsXG4gICAgICAgICAgICAgICAgbWVzc2FnZToge1xuICAgICAgICAgICAgICAgICAgICBsYWJlbEtleTogJ0xCTF9WQUxJREFUSU9OX0VSUk9SX01BWCcsXG4gICAgICAgICAgICAgICAgICAgIGNvbnRleHQ6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHZhbHVlOiBjb250cm9sLnZhbHVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgbWF4OiAnJyArIG1heFxuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICB9O1xuICAgIH1cbik7XG5cbkBJbmplY3RhYmxlKHtcbiAgICBwcm92aWRlZEluOiAncm9vdCdcbn0pXG5leHBvcnQgY2xhc3MgUmFuZ2VWYWxpZGF0b3IgaW1wbGVtZW50cyBWYWxpZGF0b3JJbnRlcmZhY2Uge1xuXG4gICAgYXBwbGllcyhyZWNvcmQ6IFJlY29yZCwgdmlld0ZpZWxkOiBWaWV3RmllbGREZWZpbml0aW9uKTogYm9vbGVhbiB7XG4gICAgICAgIGlmICghdmlld0ZpZWxkIHx8ICF2aWV3RmllbGQuZmllbGREZWZpbml0aW9uKSB7XG4gICAgICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICAgIH1cblxuICAgICAgICBjb25zdCBkZWZpbml0aW9uID0gdmlld0ZpZWxkLmZpZWxkRGVmaW5pdGlvbjtcblxuICAgICAgICByZXR1cm4gdGhpcy5nZXRSYW5nZVZhbGlkYXRpb24oZGVmaW5pdGlvbikgIT09IG51bGw7XG4gICAgfVxuXG4gICAgZ2V0VmFsaWRhdG9yKHZpZXdGaWVsZDogVmlld0ZpZWxkRGVmaW5pdGlvbik6IFN0YW5kYXJkVmFsaWRhdG9yRm5bXSB7XG5cbiAgICAgICAgaWYgKCF2aWV3RmllbGQgfHwgIXZpZXdGaWVsZC5maWVsZERlZmluaXRpb24pIHtcbiAgICAgICAgICAgIHJldHVybiBbXTtcbiAgICAgICAgfVxuXG4gICAgICAgIGNvbnN0IHZhbGlkYXRpb24gPSB0aGlzLmdldFJhbmdlVmFsaWRhdGlvbih2aWV3RmllbGQuZmllbGREZWZpbml0aW9uKTtcblxuICAgICAgICBpZiAoIXZhbGlkYXRpb24pIHtcbiAgICAgICAgICAgIHJldHVybiBbXTtcbiAgICAgICAgfVxuXG4gICAgICAgIGxldCBtYXggPSBudWxsO1xuICAgICAgICBpZiAoaXNOdW1iZXIodmFsaWRhdGlvbj8ubWF4KSkge1xuICAgICAgICAgICAgbWF4ID0gcGFyc2VJbnQoJycgKyB2YWxpZGF0aW9uLm1heCwgMTApO1xuICAgICAgICB9XG5cbiAgICAgICAgbGV0IG1pbiA9IG51bGw7XG4gICAgICAgIGlmIChpc051bWJlcih2YWxpZGF0aW9uPy5taW4pKSB7XG4gICAgICAgICAgICBtaW4gPSBwYXJzZUludCgnJyArIHZhbGlkYXRpb24ubWluLCAxMCk7XG4gICAgICAgIH1cblxuICAgICAgICBjb25zdCB2YWxpZGF0aW9ucyA9IFtdO1xuXG4gICAgICAgIGlmIChpc051bWJlcihtaW4pICYmIGlzRmluaXRlKG1pbikpIHtcbiAgICAgICAgICAgIHZhbGlkYXRpb25zLnB1c2gobWluVmFsaWRhdG9yKG1pbikpO1xuICAgICAgICB9XG5cbiAgICAgICAgaWYgKGlzTnVtYmVyKG1heCkgJiYgaXNGaW5pdGUobWF4KSkge1xuICAgICAgICAgICAgdmFsaWRhdGlvbnMucHVzaChtYXhWYWxpZGF0b3IobWF4KSk7XG4gICAgICAgIH1cblxuICAgICAgICByZXR1cm4gdmFsaWRhdGlvbnM7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGdldFJhbmdlVmFsaWRhdGlvbihkZWZpbml0aW9uOiBGaWVsZERlZmluaXRpb24pOiBWYWxpZGF0aW9uRGVmaW5pdGlvbiB7XG5cbiAgICAgICAgaWYgKHRoaXMuaXNSYW5nZVZhbGlkYXRpb24oZGVmaW5pdGlvbi52YWxpZGF0aW9uKSkge1xuICAgICAgICAgICAgcmV0dXJuIGRlZmluaXRpb24udmFsaWRhdGlvbjtcbiAgICAgICAgfVxuXG4gICAgICAgIGlmICghZGVmaW5pdGlvbi52YWxpZGF0aW9ucyB8fCAhZGVmaW5pdGlvbi52YWxpZGF0aW9ucy5sZW5ndGgpIHtcbiAgICAgICAgICAgIHJldHVybiBudWxsO1xuICAgICAgICB9XG5cbiAgICAgICAgbGV0IHZhbGlkYXRpb246IFZhbGlkYXRpb25EZWZpbml0aW9uID0gbnVsbDtcblxuICAgICAgICBkZWZpbml0aW9uLnZhbGlkYXRpb25zLnNvbWUoZW50cnkgPT4ge1xuICAgICAgICAgICAgdmFsaWRhdGlvbiA9IGVudHJ5O1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMuaXNSYW5nZVZhbGlkYXRpb24oZW50cnkpO1xuICAgICAgICB9KTtcblxuICAgICAgICByZXR1cm4gdmFsaWRhdGlvbjtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgaXNSYW5nZVZhbGlkYXRpb24odmFsaWRhdGlvbjogVmFsaWRhdGlvbkRlZmluaXRpb24pOiBib29sZWFuIHtcbiAgICAgICAgcmV0dXJuIHZhbGlkYXRpb24gJiYgdmFsaWRhdGlvbi50eXBlID09PSAncmFuZ2UnO1xuICAgIH1cbn1cbiJdfQ==