/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Injectable } from '@angular/core';
import { isTrue } from 'common';
import { FormControlUtils } from '../../field/form-control.utils';
import * as i0 from "@angular/core";
import * as i1 from "../../field/form-control.utils";
export const requiredValidator = (utils) => ((control) => {
    if (utils.isEmptyTrimmedInputValue(control.value)) {
        return {
            required: {
                required: true,
                message: {
                    labelKey: 'LBL_VALIDATION_ERROR_REQUIRED',
                    context: {
                        value: control.value
                    }
                }
            }
        };
    }
    return null;
});
export const booleanRequiredValidator = (utils) => ((control) => {
    if (utils.isEmptyBooleanInputValue(control.value)) {
        return {
            required: {
                required: true,
                message: {
                    labelKey: 'LBL_VALIDATION_ERROR_REQUIRED',
                    context: {
                        value: control.value
                    }
                }
            }
        };
    }
    return null;
});
export const multienumRequiredValidator = (viewField, record, utils) => ((control) => {
    const name = viewField.name || '';
    if (!name || !record || !record.fields) {
        return null;
    }
    const field = record?.fields[name] ?? {};
    if (!field) {
        return null;
    }
    const activeItems = field.valueList;
    if (activeItems && activeItems.length > 0) {
        return null;
    }
    return {
        required: {
            required: true,
            message: {
                labelKey: 'LBL_VALIDATION_ERROR_REQUIRED',
                context: {}
            }
        }
    };
});
class RequiredValidator {
    constructor(utils) {
        this.utils = utils;
    }
    applies(record, viewField) {
        if (!viewField || !viewField.fieldDefinition) {
            return false;
        }
        const viewFieldType = viewField?.type ?? null;
        const fieldDefinitionType = viewField?.fieldDefinition?.type ?? null;
        if (viewFieldType === 'line-items' || fieldDefinitionType === 'line-items') {
            return false;
        }
        return isTrue(viewField.fieldDefinition.required);
    }
    getValidator(viewField, record) {
        const type = viewField?.type ?? viewField?.fieldDefinition?.type ?? '';
        if (type === 'boolean') {
            return [booleanRequiredValidator(this.utils)];
        }
        if (type === 'multienum') {
            return [multienumRequiredValidator(viewField, record, this.utils)];
        }
        return [requiredValidator(this.utils)];
    }
    static { this.ɵfac = function RequiredValidator_Factory(t) { return new (t || RequiredValidator)(i0.ɵɵinject(i1.FormControlUtils)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: RequiredValidator, factory: RequiredValidator.ɵfac, providedIn: 'root' }); }
}
export { RequiredValidator };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RequiredValidator, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i1.FormControlUtils }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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