/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Injectable } from '@angular/core';
import { Apollo, gql } from 'apollo-angular';
import { map } from 'rxjs/operators';
import { toInteger } from "lodash-es";
import * as i0 from "@angular/core";
import * as i1 from "apollo-angular";
class ListGQL {
    constructor(apollo) {
        this.apollo = apollo;
        this.fieldsMetadata = {
            fields: [
                'id',
                '_id',
                'meta',
                'records'
            ]
        };
    }
    /**
     * Fetch data either from backend
     *
     * @param {string} module to get from
     * @param {number} limit  page limit
     * @param {number} offset  current offset
     * @param {object} criteria filter criteria
     * @param {object} sort selection
     * @param {object} metadata with the fields to ask for
     * @returns {object} Observable<ApolloQueryResult<any>>
     */
    fetch(module, limit, offset, criteria, sort, metadata) {
        const fields = metadata.fields;
        const queryOptions = {
            query: gql `
              query recordList($module: String!, $limit: Int, $offset: Int, $criteria: Iterable, $sort: Iterable) {
                recordList(module: $module, limit: $limit, offset: $offset, criteria: $criteria, sort: $sort) {
                  ${fields.join('\n')}
                }
              }
            `,
            variables: {
                module,
                limit,
                offset,
                criteria,
                sort
            },
        };
        return this.apollo.query(queryOptions);
    }
    /**
     * Fetch the List records from the backend
     *
     * @param {string} module to use
     * @param {object} criteria to use
     * @param {object} sort to use
     * @param {object} pagination to use
     * @returns {object} Observable<any>
     */
    get(module, criteria, sort, pagination) {
        const mappedSort = this.mapSort(sort);
        return this.fetch(module, toInteger(pagination.pageSize), toInteger(pagination.current), criteria, mappedSort, this.fieldsMetadata)
            .pipe(map(({ data }) => {
            const recordsList = {
                records: [],
                pagination: { ...pagination }
            };
            if (!data || !data.recordList) {
                return recordsList;
            }
            const listData = data.recordList;
            if (listData.records) {
                listData.records.forEach((record) => {
                    recordsList.records.push(this.mapRecord(record));
                });
            }
            if (!listData.meta) {
                return recordsList;
            }
            if (listData.meta.offsets) {
                const paginationFieldMap = {
                    current: 'current',
                    next: 'next',
                    prev: 'previous',
                    total: 'total',
                    end: 'last',
                };
                Object.keys(paginationFieldMap).forEach((key) => {
                    if (key in listData.meta.offsets) {
                        const paginationField = paginationFieldMap[key];
                        recordsList.pagination[paginationField] = listData.meta.offsets[key];
                    }
                });
            }
            recordsList.meta = listData.meta;
            return recordsList;
        }));
    }
    /**
     * Map sort.
     * @param {object} sort to map
     */
    mapSort(sort) {
        const sortOrderMap = {
            NONE: '',
            ASC: 'ASC',
            DESC: 'DESC'
        };
        return {
            sortOrder: sortOrderMap[sort.sortOrder],
            orderBy: sort.orderBy
        };
    }
    /**
     * Map record. Allow for extensions
     * @param record
     */
    mapRecord(record) {
        return record;
    }
    static { this.ɵfac = function ListGQL_Factory(t) { return new (t || ListGQL)(i0.ɵɵinject(i1.Apollo)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ListGQL, factory: ListGQL.ɵfac, providedIn: 'root' }); }
}
export { ListGQL };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ListGQL, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i1.Apollo }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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