/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Component, HostListener } from '@angular/core';
import { combineLatestWith } from 'rxjs';
import { ActivatedRoute } from '@angular/router';
import { CreateViewStore } from '../../store/create-view/create-view.store';
import { RecordViewStore } from '../../../record/store/record-view/record-view.store';
import { AppStateStore } from '../../../../store/app-state/app-state.store';
import { RecordActionsAdapter } from "../../../record/adapters/actions.adapter";
import { RecordViewSidebarWidgetService } from "../../../record/services/record-view-sidebar-widget.service";
import { filter, map } from "rxjs/operators";
import * as i0 from "@angular/core";
import * as i1 from "../../../../store/app-state/app-state.store";
import * as i2 from "../../store/create-view/create-view.store";
import * as i3 from "../../../record/adapters/actions.adapter";
import * as i4 from "@angular/router";
import * as i5 from "@angular/common";
import * as i6 from "../../../record/components/record-container/record-container.component";
import * as i7 from "../../../record/components/record-header/record-header.component";
import * as i8 from "../../../../components/status-bar/status-bar.component";
function CreateRecordComponent_div_0_scrm_status_bar_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-status-bar");
} }
function CreateRecordComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1)(1, "div", 2);
    i0.ɵɵelement(2, "scrm-record-header");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "div", 3);
    i0.ɵɵelement(4, "hr", 4);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(5, CreateRecordComponent_div_0_scrm_status_bar_5_Template, 1, 0, "scrm-status-bar", 5);
    i0.ɵɵelement(6, "scrm-record-container");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(5);
    i0.ɵɵproperty("ngIf", ctx_r0.showStatusBar);
} }
class CreateRecordComponent {
    onEnterKey() {
        if (!this.saveAction || !this.context) {
            return;
        }
        this.actionsAdapter.runAction(this.saveAction, this.context);
    }
    constructor(appState, recordStore, actionsAdapter, route) {
        this.appState = appState;
        this.recordStore = recordStore;
        this.actionsAdapter = actionsAdapter;
        this.route = route;
        this.subs = [];
        this.vm$ = null;
        this.showStatusBar = false;
        this.actionConfig$ = this.recordStore.mode$.pipe(combineLatestWith(this.actionsAdapter.getActions(), this.getViewContext$()), filter(([mode, actions, context]) => mode === 'create'), map(([mode, actions, context]) => ({
            mode,
            actions,
            context
        })));
    }
    ngOnInit() {
        let mode = 'detail';
        const data = (this.route.snapshot && this.route.snapshot.data) || {};
        if (data.mode) {
            mode = data.mode;
        }
        let params = (this.route.snapshot && this.route.snapshot.queryParams) || {};
        params = { ...params };
        let recordId = this.route.snapshot.params.record;
        if (data.duplicate === true) {
            params.originalId = recordId;
            params.isDuplicate = true;
            recordId = '';
        }
        if (data.convert === true) {
            params.originalId = recordId;
            params.isConvert = true;
            recordId = '';
        }
        this.subs.push(this.recordStore.init(this.appState.getModule(), recordId, mode, params).subscribe());
        this.vm$ = this.recordStore.vm$;
        this.appState.removeAllPrevRoutes();
        this.subs.push(this.actionConfig$.subscribe(config => {
            this.context = config.context;
            config.actions.forEach(actionItem => {
                if (actionItem.key === 'saveNew') {
                    this.saveAction = actionItem;
                }
            });
        }));
    }
    getViewContext$() {
        return this.recordStore.viewContext$;
    }
    ngOnDestroy() {
        this.subs.forEach(sub => sub.unsubscribe());
        this.recordStore.destroy();
    }
    static { this.ɵfac = function CreateRecordComponent_Factory(t) { return new (t || CreateRecordComponent)(i0.ɵɵdirectiveInject(i1.AppStateStore), i0.ɵɵdirectiveInject(i2.CreateViewStore), i0.ɵɵdirectiveInject(i3.RecordActionsAdapter), i0.ɵɵdirectiveInject(i4.ActivatedRoute)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: CreateRecordComponent, selectors: [["scrm-create-record"]], hostBindings: function CreateRecordComponent_HostBindings(rf, ctx) { if (rf & 1) {
            i0.ɵɵlistener("keyup.control.enter", function CreateRecordComponent_keyup_control_enter_HostBindingHandler() { return ctx.onEnterKey(); });
        } }, features: [i0.ɵɵProvidersFeature([
                CreateViewStore,
                RecordActionsAdapter,
                {
                    provide: RecordViewStore,
                    useExisting: CreateViewStore
                },
                RecordViewSidebarWidgetService
            ])], decls: 2, vars: 3, consts: [["class", "record-view", 4, "ngIf"], [1, "record-view"], [1, "record-view-position-sticky"], [1, "record-view-hr-container"], [1, "record-view-hr"], [4, "ngIf"]], template: function CreateRecordComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, CreateRecordComponent_div_0_Template, 7, 1, "div", 0);
            i0.ɵɵpipe(1, "async");
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", i0.ɵɵpipeBind1(1, 1, ctx.vm$));
        } }, dependencies: [i5.NgIf, i6.RecordContainerComponent, i7.RecordHeaderComponent, i8.StatusBarComponent, i5.AsyncPipe], encapsulation: 2 }); }
}
export { CreateRecordComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CreateRecordComponent, [{
        type: Component,
        args: [{ selector: 'scrm-create-record', providers: [
                    CreateViewStore,
                    RecordActionsAdapter,
                    {
                        provide: RecordViewStore,
                        useExisting: CreateViewStore
                    },
                    RecordViewSidebarWidgetService
                ], template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n\n<!-- Start Record View Section -->\n<div class=\"record-view\" *ngIf=\"(vm$ | async) as vm\">\n\n    <div class=\"record-view-position-sticky\">\n        <scrm-record-header></scrm-record-header>\n    </div>\n    <div class=\"record-view-hr-container\">\n        <hr class=\"record-view-hr\">\n    </div>\n\n    <scrm-status-bar *ngIf=\"showStatusBar\"></scrm-status-bar>\n    <scrm-record-container></scrm-record-container>\n</div>\n<!-- End Record View Section -->\n" }]
    }], function () { return [{ type: i1.AppStateStore }, { type: i2.CreateViewStore }, { type: i3.RecordActionsAdapter }, { type: i4.ActivatedRoute }]; }, { onEnterKey: [{
            type: HostListener,
            args: ['keyup.control.enter']
        }] }); })();
//# sourceMappingURL=data:application/json;base64,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