/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { OnDestroy, OnInit, AfterViewInit } from "@angular/core";
import { Observable, Subscription } from "rxjs";
import { ListViewModel, ListViewStore } from "../../store/list-view/list-view.store";
import { AppStateStore } from "../../../../store/app-state/app-state.store";
import { QuickFiltersService } from "../../services/quick-filters.service";
import { ListViewSidebarWidgetService } from "../../services/list-view-sidebar-widget.service";
import { RecordPaginationService } from "../../../record/store/record-pagination/record-pagination.service";
import * as i0 from "@angular/core";
export declare class ColorService {
    private colors;
    private loading;
    getColors(): Promise<any>;
    static ɵfac: i0.ɵɵFactoryDeclaration<ColorService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<ColorService>;
}
export declare class ListComponent implements OnInit, OnDestroy, AfterViewInit {
    protected appState: AppStateStore;
    protected listStore: ListViewStore;
    protected quickFilters: QuickFiltersService;
    protected sidebarWidgetHandler: ListViewSidebarWidgetService;
    protected recordPaginationService: RecordPaginationService;
    protected colorService: ColorService;
    listSub: Subscription;
    module: string;
    private destroy$;
    private domObserver;
    private TAG_COLORS_LIST;
    private CALL_STATUS_STYLES;
    vm$: Observable<ListViewModel>;
    constructor(appState: AppStateStore, listStore: ListViewStore, quickFilters: QuickFiltersService, sidebarWidgetHandler: ListViewSidebarWidgetService, recordPaginationService: RecordPaginationService, colorService: ColorService);
    ngOnInit(): void;
    ngAfterViewInit(): void;
    ngOnDestroy(): void;
    private setupDomObserver;
    updateListLocalStorage(): void;
    private injectCallStatusDotList;
    private injectListTagColors;
    private loadColors;
    private applyFlatTagStyleList;
    static ɵfac: i0.ɵɵFactoryDeclaration<ListComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<ListComponent, "scrm-list", never, {}, {}, never, never, false, never>;
}
//# sourceMappingURL=list.component.d.ts.map