/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Component, ElementRef, ViewChild, } from "@angular/core";
import { AppStateStore } from "../../../../store/app-state/app-state.store";
import { Subject } from "rxjs";
import { takeUntil } from "rxjs/operators";
import { RecordViewStore } from "../../store/record-view/record-view.store";
import { ActivatedRoute } from "@angular/router";
import { RecordActionsAdapter } from "../../adapters/actions.adapter";
import { RecordViewSidebarWidgetService } from "../../services/record-view-sidebar-widget.service";
import { ColorService } from "../../../list/components/list-view/list.component";
import * as i0 from "@angular/core";
import * as i1 from "../../../../store/app-state/app-state.store";
import * as i2 from "../../store/record-view/record-view.store";
import * as i3 from "@angular/router";
import * as i4 from "../../services/record-view-sidebar-widget.service";
import * as i5 from "../../../list/components/list-view/list.component";
import * as i6 from "@angular/common";
import * as i7 from "../record-container/record-container.component";
import * as i8 from "../record-header/record-header.component";
import * as i9 from "../../../../components/status-bar/status-bar.component";
const _c0 = ["recordContainer"];
function RecordComponent_div_0_scrm_status_bar_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-status-bar");
} }
function RecordComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1)(1, "div", 2);
    i0.ɵɵelement(2, "scrm-record-header");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "div", 3);
    i0.ɵɵelement(4, "hr", 4);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(5, RecordComponent_div_0_scrm_status_bar_5_Template, 1, 0, "scrm-status-bar", 5);
    i0.ɵɵelement(6, "scrm-record-container");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(5);
    i0.ɵɵproperty("ngIf", ctx_r0.showStatusBar);
} }
class RecordComponent {
    constructor(appState, recordStore, route, sidebarWidgetHandler, colorService) {
        this.appState = appState;
        this.recordStore = recordStore;
        this.route = route;
        this.sidebarWidgetHandler = sidebarWidgetHandler;
        this.colorService = colorService;
        this.vm$ = null;
        this.showStatusBar = false;
        this.destroy$ = new Subject();
        this.TAG_COLORS = {};
        this.CALL_STATUS_STYLES = {};
    }
    ngOnInit() {
        console.log("[record.component.ts] ngOnInit");
        let mode = "detail";
        this.appState.addToPrevRoute(this.appState.getRouteUrl());
        const data = (this.route.snapshot && this.route.snapshot.data) || {};
        console.log("[record.component.ts] route data:", data);
        if (data.mode) {
            mode = data.mode;
        }
        const params = (this.route.snapshot && this.route.snapshot.queryParams) ||
            {};
        this.recordSub = this.recordStore
            .init(this.appState.getModule(), this.route.snapshot.params.record, mode, params)
            .subscribe();
        this.vm$ = this.recordStore.vm$;
        this.vm$.pipe(takeUntil(this.destroy$)).subscribe((vm) => {
            console.log("[record.component.ts] ViewModel received");
        });
        // Load colors then setup DOM observer
        this.loadColors().then(() => {
            this.setupDomObserver();
        });
    }
    setupDomObserver() {
        // If already observing, disconnect
        if (this.domObserver) {
            this.domObserver.disconnect();
        }
        this.domObserver = new MutationObserver(() => {
            // Try each injector once per mutation batch
            this.injectCallStatusDot();
            this.injectCallStatusDotDetail();
            this.injectEditTagColors();
            this.injectDetailTagColors();
        });
        this.domObserver.observe(this.container.nativeElement, {
            childList: true,
            subtree: true,
        });
    }
    ngAfterViewInit() {
        console.log("[record.component.ts] ngAfterViewInit");
        // Initial application of styles
        this.injectCallStatusDot();
        this.injectCallStatusDotDetail();
        this.injectEditTagColors();
        this.injectDetailTagColors();
    }
    ngOnDestroy() {
        if (this.recordSub) {
            this.recordSub.unsubscribe();
        }
        if (this.modeSub) {
            this.modeSub.unsubscribe();
        }
        // Clean up observer
        if (this.domObserver) {
            this.domObserver.disconnect();
        }
        // Complete all subscriptions
        this.destroy$.next();
        this.destroy$.complete();
        this.sidebarWidgetHandler.destroy();
        this.recordStore.destroy();
    }
    async loadColors() {
        try {
            const data = await this.colorService.getColors();
            this.TAG_COLORS = data.tagColors;
            this.CALL_STATUS_STYLES = data.callStatus;
        }
        catch (error) {
            console.error("[record.component.ts] Failed to load color mappings:", error);
        }
    }
    injectCallStatusDot() {
        const container = this.container.nativeElement.querySelector(".field-name-call_status_c scrm-dropdownenum-edit select.custom-select");
        if (!container)
            return;
        for (let i = 0; i < container.options.length; i++) {
            const opt = container.options[i];
            const cleanVal = opt.value?.split(":")[1]?.trim().toLowerCase();
            const styleInfo = this.CALL_STATUS_STYLES[cleanVal];
            if (styleInfo &&
                !opt.textContent.trim().startsWith(styleInfo.emoji)) {
                opt.textContent = `${styleInfo.emoji} ${opt.textContent.trim()}`;
            }
        }
    }
    injectCallStatusDotDetail() {
        const container = this.container.nativeElement.querySelector(".field-name-call_status_c scrm-dropdownenum-detail");
        if (!container)
            return;
        const originalText = container.textContent?.trim() || "";
        const cleanVal = originalText.toLowerCase().replace(/\s+/g, "");
        const styleInfo = this.CALL_STATUS_STYLES[cleanVal];
        if (styleInfo && !originalText.startsWith(styleInfo.emoji)) {
            container.textContent = `${styleInfo.emoji} ${originalText}`;
        }
    }
    applyFlatTagStyle(el, label) {
        const color = this.TAG_COLORS[label.toLowerCase()];
        if (!color)
            return;
        el.style.backgroundColor = color;
        el.style.color = "white";
        el.style.fontSize = "12px";
        el.style.fontWeight = "bold";
        el.style.padding = "2px 8px";
        el.style.borderRadius = "12px";
        el.style.display = "inline-block";
        el.style.margin = "2px";
    }
    injectEditTagColors() {
        const wrapper = this.container.nativeElement.querySelector(".dynamic-field-name-tag_c p-multiselect");
        const tokens = this.container.nativeElement.querySelectorAll(".p-multiselect-token, .p-multiselect-item");
        if (!wrapper || tokens.length === 0)
            return;
        tokens.forEach((el) => {
            const label = el.textContent?.trim().toLowerCase();
            this.applyFlatTagStyle(el, label);
        });
        const trigger = wrapper?.querySelector(".p-multiselect-trigger");
        if (trigger) {
            // Use passive event listener for better performance
            trigger.addEventListener("click", () => {
                setTimeout(() => {
                    const items = document.querySelectorAll(".p-multiselect-item");
                    items.forEach((el) => {
                        const label = el.textContent?.trim().toLowerCase();
                        this.applyFlatTagStyle(el, label);
                    });
                }, 100);
            }, { passive: true });
        }
    }
    injectDetailTagColors() {
        const fieldWrapper = this.container.nativeElement.querySelector("scrm-field.field-name-tag_c");
        const detailItems = fieldWrapper?.querySelectorAll("scrm-multienum-detail li") || [];
        if (detailItems.length === 0)
            return;
        detailItems.forEach((el) => {
            const label = el.textContent?.trim().toLowerCase();
            this.applyFlatTagStyle(el, label);
        });
    }
    static { this.ɵfac = function RecordComponent_Factory(t) { return new (t || RecordComponent)(i0.ɵɵdirectiveInject(i1.AppStateStore), i0.ɵɵdirectiveInject(i2.RecordViewStore), i0.ɵɵdirectiveInject(i3.ActivatedRoute), i0.ɵɵdirectiveInject(i4.RecordViewSidebarWidgetService), i0.ɵɵdirectiveInject(i5.ColorService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: RecordComponent, selectors: [["scrm-record"]], viewQuery: function RecordComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 7);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.container = _t.first);
        } }, features: [i0.ɵɵProvidersFeature([
                RecordViewStore,
                RecordActionsAdapter,
                RecordViewSidebarWidgetService,
            ])], decls: 2, vars: 3, consts: [["class", "record-view", 4, "ngIf"], [1, "record-view"], [1, "record-view-position-sticky"], [1, "record-view-hr-container"], [1, "record-view-hr"], [4, "ngIf"]], template: function RecordComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, RecordComponent_div_0_Template, 7, 1, "div", 0);
            i0.ɵɵpipe(1, "async");
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", i0.ɵɵpipeBind1(1, 1, ctx.vm$));
        } }, dependencies: [i6.NgIf, i7.RecordContainerComponent, i8.RecordHeaderComponent, i9.StatusBarComponent, i6.AsyncPipe], encapsulation: 2 }); }
}
export { RecordComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RecordComponent, [{
        type: Component,
        args: [{ selector: "scrm-record", providers: [
                    RecordViewStore,
                    RecordActionsAdapter,
                    RecordViewSidebarWidgetService,
                ], template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<!-- Start Record View Section -->\n<div class=\"record-view\" *ngIf=\"(vm$ | async) as vm\">\n\n    <div class=\"record-view-position-sticky\">\n        <scrm-record-header></scrm-record-header>\n    </div>\n    <div class=\"record-view-hr-container\">\n        <hr class=\"record-view-hr\">\n    </div>\n\n    <scrm-status-bar *ngIf=\"showStatusBar\"></scrm-status-bar>\n    <scrm-record-container></scrm-record-container>\n</div>\n<!-- End Record View Section -->\n" }]
    }], function () { return [{ type: i1.AppStateStore }, { type: i2.RecordViewStore }, { type: i3.ActivatedRoute }, { type: i4.RecordViewSidebarWidgetService }, { type: i5.ColorService }]; }, { container: [{
            type: ViewChild,
            args: ["recordContainer", { static: true }]
        }] }); })();
//# sourceMappingURL=data:application/json;base64,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