/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { BehaviorSubject } from 'rxjs';
export class BaseField {
    constructor() {
        this.fieldDependencies = {};
        this.attributeDependencies = [];
        this.defaultValueInitialized = false;
        this.valueSubject = new BehaviorSubject({});
        this.valueChanges$ = this.valueSubject.asObservable();
        this.loading = false;
    }
    get value() {
        return this.valueState;
    }
    set value(value) {
        const changed = value !== this.valueState;
        this.valueState = value;
        if (changed) {
            this.emitValueChanges();
        }
    }
    get valueList() {
        return this.valueListState;
    }
    set valueList(value) {
        this.valueListState = value;
        this.emitValueChanges();
    }
    get valueObject() {
        return this.valueObjectState;
    }
    set valueObject(value) {
        this.valueObjectState = value;
        this.emitValueChanges();
    }
    get valueObjectArray() {
        return this.valueObjectArrayState;
    }
    set valueObjectArray(value) {
        this.valueObjectArrayState = value;
        this.emitValueChanges();
    }
    emitValueChanges() {
        this.valueSubject.next({
            value: this.valueState,
            valueList: this.valueListState,
            valueObject: this.valueObjectState
        });
    }
    initDefaultValue() {
        if (this.defaultValueInitialized) {
            return;
        }
        const defaultValue = this?.default ?? this?.definition?.default ?? null;
        if (!this.value && defaultValue) {
            this.value = defaultValue;
            this?.formControl?.setValue(defaultValue);
            this.defaultValueInitialized = true;
        }
        else if (this.value === null) {
            this.value = '';
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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