/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Component } from '@angular/core';
import { deepClone, isFalse, isTrue } from 'common';
import { of } from 'rxjs';
import { LanguageStore } from '../../../../store/language/language.store';
import { BaseWidgetComponent } from '../../../widgets/base-widget.model';
import { distinctUntilChanged, filter, map, shareReplay } from 'rxjs/operators';
import { SystemConfigStore } from '../../../../store/system-config/system-config.store';
import { isEmpty } from "lodash-es";
import * as i0 from "@angular/core";
import * as i1 from "../../../../store/language/language.store";
import * as i2 from "../../../../store/system-config/system-config.store";
import * as i3 from "@angular/common";
import * as i4 from "../../../../components/widget-panel/widget-panel.component";
import * as i5 from "../../../../components/label/label.component";
import * as i6 from "../../../record-thread/components/record-thread/record-thread.component";
function RecordThreadSidebarWidgetComponent_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "div", 3);
    i0.ɵɵelement(2, "scrm-label", 4);
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} }
function RecordThreadSidebarWidgetComponent_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "scrm-record-thread", 5);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("config", ctx_r1.recordThreadConfig);
} }
class RecordThreadSidebarWidgetComponent extends BaseWidgetComponent {
    constructor(language, sytemConfig) {
        super();
        this.language = language;
        this.sytemConfig = sytemConfig;
        this.panelMode = 'none';
        this.subs = [];
    }
    ngOnInit() {
        const options = this.config.options || {};
        this.options = options.recordThread || null;
        if (!this.options) {
            return;
        }
        this.initPanelMode();
        this.initFilters$();
        this.initPresetFields$();
        if (this.context$ && this.context$.subscribe()) {
            this.subs.push(this.context$.subscribe((context) => {
                this.context = context;
            }));
        }
        this.recordThreadConfig = this.getConfig();
    }
    ngOnDestroy() {
        this.subs.forEach(sub => sub.unsubscribe());
    }
    getHeaderLabel() {
        return this.getLabel(this.config.labelKey) || '';
    }
    getLabel(key) {
        const context = this.context || {};
        const module = context.module || '';
        return this.language.getFieldLabel(key, module);
    }
    getConfig() {
        const config = {
            filters$: this.filters$,
            presetFields$: this.presetFields$,
            module: this.options.module,
            klass: this.options.class || '',
            maxListHeight: this.options.maxListHeight ?? 350,
            direction: this.options.direction || 'asc',
            create: !!this?.options?.create,
            createConfig: {},
            itemConfig: {
                collapsible: this.options.item.collapsible || false,
                collapseLimit: this.options.item.collapseLimit || null,
                klass: this.options.item.itemClass || '',
                dynamicClass: this.options.item.dynamicClass || [],
                metadata: {}
            },
            listActions: this?.options?.listActions ?? null,
            collapseListActions: this?.options?.collapseListActions ?? false,
            listActionsClass: this?.options?.listActionsClass ?? '',
            listActionsButtonClass: this?.options?.listActionsButtonClass ?? '',
            listActionsButtonGroupClass: this?.options?.listActionsButtonGroupClass ?? '',
        };
        this.setupItemMetadata(config.itemConfig.metadata, this.options.item.layout);
        if (!isEmpty(this.options?.create ?? null)) {
            config.createConfig = {
                collapsible: false,
                metadata: {}
            };
            this.setupItemMetadata(config.createConfig.metadata, this.options?.create?.layout ?? {});
        }
        return config;
    }
    setupItemMetadata(metadata, config) {
        if (config && config.header) {
            metadata.headerLayout = deepClone(config.header);
        }
        if (config && config.body) {
            metadata.bodyLayout = deepClone(config.body);
        }
        if (config && config.actions) {
            metadata.actions = deepClone(config.actions);
        }
        if (config && config.fields) {
            metadata.fields = deepClone(config.fields);
        }
        if ((config?.collapseActions ?? null) !== null) {
            metadata.collapseActions = config?.collapseActions;
        }
    }
    initPanelMode() {
        const ui = this.sytemConfig.getConfigValue('ui');
        const systemDefault = ui?.widget?.allowCollapse ?? null;
        const allowCollapse = this?.config?.allowCollapse ?? null;
        let mode = 'none';
        if (systemDefault !== null) {
            if (isTrue(systemDefault)) {
                mode = 'collapsible';
            }
            else if (isFalse(systemDefault)) {
                mode = 'none';
            }
        }
        if (allowCollapse !== null) {
            if (isTrue(allowCollapse)) {
                mode = 'collapsible';
            }
            else if (isFalse(allowCollapse)) {
                mode = 'none';
            }
        }
        this.panelMode = mode;
    }
    initFilters$() {
        if (!this.options || !this.options.filters || !this.context$) {
            return;
        }
        const parentFilters = this.options.filters.parentFilters || {};
        let context$ = of({}).pipe(shareReplay());
        if (Object.keys(parentFilters).length > 0) {
            context$ = this.context$.pipe(filter(context => {
                const record = (context && context.record) || {};
                return !!(record.attributes && Object.keys(record.attributes).length);
            }));
        }
        this.filters$ = context$.pipe(map(context => {
            const filters = { filters: {} };
            this.initParentFilters(context, filters);
            const staticFilters = this.options.filters.static || {};
            filters.filters = {
                ...filters.filters,
                ...staticFilters
            };
            if (this.options.filters.orderBy) {
                filters.orderBy = this.options.filters.orderBy;
            }
            if (this.options.filters.sortOrder) {
                filters.sortOrder = this.options.filters.sortOrder;
            }
            return filters;
        }), distinctUntilChanged());
    }
    initPresetFields$() {
        if (!this.options || !this.options.create || !this.options.create.presetFields || !this.context$) {
            return;
        }
        this.presetFields$ = this.context$.pipe(map(context => {
            const parentValues = this.initParentValues(context);
            const staticValues = this.options.create.presetFields.static || {};
            return {
                ...parentValues,
                ...staticValues
            };
        }), distinctUntilChanged());
    }
    initParentFilters(context, filters) {
        const parentFilters = this.options.filters.parentFilters || {};
        if (!context || !context.record || !parentFilters) {
            return;
        }
        Object.keys(parentFilters).forEach(parentField => {
            const field = parentFilters[parentField];
            const value = context.record.attributes[parentField] || '';
            if (!value) {
                return;
            }
            filters.filters[field] = {
                field: parentFilters,
                operator: '=',
                values: [value],
            };
        });
    }
    initParentValues(context) {
        const parentValues = this.options.create.presetFields.parentValues || {};
        if (!context || !context.record || !parentValues) {
            return;
        }
        const attributes = {};
        Object.keys(parentValues).forEach(parentField => {
            const field = parentValues[parentField];
            const value = context.record.attributes[parentField] || '';
            if (!value) {
                return;
            }
            attributes[field] = value;
        });
        return attributes;
    }
    static { this.ɵfac = function RecordThreadSidebarWidgetComponent_Factory(t) { return new (t || RecordThreadSidebarWidgetComponent)(i0.ɵɵdirectiveInject(i1.LanguageStore), i0.ɵɵdirectiveInject(i2.SystemConfigStore)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: RecordThreadSidebarWidgetComponent, selectors: [["scrm-record-thread-sidebar-widget"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 4, vars: 4, consts: [[3, "mode", "title"], ["widget-body", "", 1, "record-thread-sidebar-widget"], [4, "ngIf"], [1, "p-3", "widget-message"], ["labelKey", "LBL_BAD_CONFIG"], [3, "config"]], template: function RecordThreadSidebarWidgetComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "scrm-widget-panel", 0)(1, "div", 1);
            i0.ɵɵtemplate(2, RecordThreadSidebarWidgetComponent_ng_container_2_Template, 3, 0, "ng-container", 2);
            i0.ɵɵtemplate(3, RecordThreadSidebarWidgetComponent_ng_container_3_Template, 2, 1, "ng-container", 2);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵproperty("mode", ctx.panelMode)("title", ctx.getHeaderLabel());
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngIf", !ctx.options);
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.options);
        } }, dependencies: [i3.NgIf, i4.WidgetPanelComponent, i5.LabelComponent, i6.RecordThreadComponent], encapsulation: 2 }); }
}
export { RecordThreadSidebarWidgetComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RecordThreadSidebarWidgetComponent, [{
        type: Component,
        args: [{ selector: 'scrm-record-thread-sidebar-widget', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<scrm-widget-panel [mode]=\"panelMode\" [title]=\"getHeaderLabel()\">\n    <div class=\"record-thread-sidebar-widget\" widget-body>\n\n        <ng-container *ngIf=\"!options\">\n            <div class=\"p-3 widget-message\">\n                <scrm-label labelKey=\"LBL_BAD_CONFIG\"></scrm-label>\n            </div>\n        </ng-container>\n\n        <ng-container *ngIf=\"options\">\n            <scrm-record-thread [config]=\"recordThreadConfig\"></scrm-record-thread>\n        </ng-container>\n\n    </div>\n</scrm-widget-panel>\n" }]
    }], function () { return [{ type: i1.LanguageStore }, { type: i2.SystemConfigStore }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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