export class DateTimeModel {
    constructor(init) {
        this.hourStep = 1;
        this.minuteStep = 15;
        this.secondStep = 30;
        this.displaySeconds = false;
        Object.assign(this, init);
    }
    static toDateTimeStruct(formatter, dateString) {
        if (!dateString) {
            return null;
        }
        const dateTimeStruct = formatter.userDateTimeFormatToStruct(dateString);
        if (!dateTimeStruct) {
            return null;
        }
        const { date, time } = dateTimeStruct;
        return new DateTimeModel({
            date: date,
            time: time
        });
    }
    static internalToDateTimeStruct(formatter, dateString) {
        if (!dateString) {
            return null;
        }
        const dateTimeStruct = formatter.internalDateTimeFormatToStruct(dateString);
        if (!dateTimeStruct) {
            return null;
        }
        const { date, time } = dateTimeStruct;
        return new DateTimeModel({
            date: date,
            time: time
        });
    }
    toUserFormat(formatter, options) {
        //prepare datetime string in yyyy-M-d H:m:s format (datetimepicker default)
        const dateString = [this.date.year, this.date.month, this.date.day].join('-');
        const timeString = [this.time.hour, this.time.minute, this.time.second].join(':');
        const datetimeString = [dateString, timeString].join(' ');
        const internalDateTimeString = formatter.toInternalFormat(datetimeString, { fromFormat: 'yyyy-M-d H:m:s' });
        //convert from yyyy-M-d H:m:s format to user format
        return formatter.toUserFormat(internalDateTimeString, { ...options, fromFormat: 'yyyy-M-d H:m:s' });
    }
}
//# sourceMappingURL=data:application/json;base64,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