/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Component, ElementRef, HostListener, Input, signal } from '@angular/core';
import { Button, isFalse } from 'common';
import { LanguageStore } from '../../store/language/language.store';
import { BehaviorSubject, combineLatestWith } from 'rxjs';
import { ScreenSize, ScreenSizeObserverService } from '../../services/ui/screen-size-observer/screen-size-observer.service';
import { SystemConfigStore } from '../../store/system-config/system-config.store';
import { map } from 'rxjs/operators';
import * as i0 from "@angular/core";
import * as i1 from "../../store/language/language.store";
import * as i2 from "../../services/ui/screen-size-observer/screen-size-observer.service";
import * as i3 from "../../store/system-config/system-config.store";
import * as i4 from "@angular/common";
import * as i5 from "../image/image.component";
import * as i6 from "../button-group/button-group.component";
function LineActionMenuComponent_ng_container_0_scrm_button_group_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-button-group", 7);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("config$", ctx_r1.config$)("klass", "icon-bar-block");
} }
function LineActionMenuComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "div", 1)(2, "div", 2)(3, "div", 3)(4, "div");
    i0.ɵɵtemplate(5, LineActionMenuComponent_ng_container_0_scrm_button_group_5_Template, 1, 2, "scrm-button-group", 4);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(6, "button", 5);
    i0.ɵɵlistener("click", function LineActionMenuComponent_ng_container_0_Template_button_click_6_listener() { i0.ɵɵrestoreView(_r3); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.toggleExpand(ctx_r2.record == null ? null : ctx_r2.record.id)); });
    i0.ɵɵelement(7, "scrm-image", 6);
    i0.ɵɵelementEnd()()()();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵclassMap(ctx_r0.wrapperClass);
    i0.ɵɵproperty("ngClass", ctx_r0.isActive ? "active" : "");
    i0.ɵɵadvance(1);
    i0.ɵɵclassMap(ctx_r0.klass);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r0.config$);
} }
class LineActionMenuComponent {
    onClickOutside(target) {
        if (!this.el.nativeElement.contains(target)) {
            this.isActive = false;
            this.isClickedOutside.set(true);
        }
    }
    constructor(languageStore, languages, screenSize, systemConfigStore, el) {
        this.languageStore = languageStore;
        this.languages = languages;
        this.screenSize = screenSize;
        this.systemConfigStore = systemConfigStore;
        this.el = el;
        this.klass = '';
        this.wrapperClass = '';
        this.limitConfigKey = 'listview_line_actions_limits';
        this.configState = new BehaviorSubject({ buttons: [] });
        this.config$ = this.configState.asObservable();
        this.isActive = false;
        this.isClickedOutside = signal(false);
        this.buttonClass = 'line-action-item line-action';
        this.buttonGroupClass = 'float-right';
        this.subs = [];
        this.screen = ScreenSize.Medium;
        this.defaultBreakpoint = 3;
    }
    ngOnInit() {
        this.subs.push(this.config.getActions({ record: this.record }).pipe(combineLatestWith(this.screenSize.screenSize$, this.languages.vm$), map(([actions, screenSize, languages]) => {
            if (screenSize) {
                this.screen = screenSize;
            }
            this.configState.next(this.getButtonGroupConfig(actions));
            this.actions = actions;
        })).subscribe());
        this.subs.push(this.activeLineAction.activeAction$.subscribe((activeAction) => {
            if (this.record?.id === activeAction) {
                this.isActive = true;
            }
            else {
                this.isActive = false;
            }
        }));
    }
    ngOnDestroy() {
        this.subs.forEach(sub => sub.unsubscribe());
        this.isActive = false;
        this.activeLineAction.resetActiveAction();
    }
    getButtonGroupConfig(actions) {
        const expanded = [];
        const collapsed = [];
        actions.forEach((action) => {
            const button = this.buildButton(action);
            if (action.params && action.params.expanded) {
                expanded.push(button);
                return;
            }
            collapsed.push(button);
        });
        let breakpoint = actions.length;
        const buttons = expanded.concat(collapsed);
        return {
            buttonKlass: [this.buttonClass],
            dropdownLabel: this.languages.getAppString('LBL_ACTIONS') || '',
            breakpoint,
            dropdownOptions: {
                placement: ['bottom-right'],
                wrapperKlass: [(this.buttonGroupClass)]
            },
            buttons
        };
    }
    getBreakpoint() {
        const breakpointMap = this.systemConfigStore.getConfigValue(this.limitConfigKey);
        if (this.screen && breakpointMap && breakpointMap[this.screen]) {
            this.breakpoint = breakpointMap[this.screen];
            return this.breakpoint;
        }
        if (this.breakpoint) {
            return this.breakpoint;
        }
        return this.defaultBreakpoint;
    }
    buildButton(action) {
        const button = {
            titleKey: action.labelKey || '',
            klass: this.buttonClass,
            icon: action.icon || '',
            onClick: () => {
                this.config.runAction(action, {
                    module: (this.record && this.record.module) || '',
                    record: this.record
                });
            }
        };
        if (action.icon) {
            button.icon = action.icon;
        }
        const debounceClick = action?.params?.debounceClick ?? null;
        button.debounceClick = true;
        if (isFalse(debounceClick)) {
            button.debounceClick = false;
        }
        if (action.status) {
            Button.appendClasses(button, [action.status]);
        }
        return button;
    }
    toggleExpand(recordId) {
        const activeId = this.activeLineAction.getActiveAction();
        if (activeId === recordId && !this.isClickedOutside()) {
            this.activeLineAction.resetActiveAction();
        }
        else {
            this.activeLineAction.setActiveAction(recordId);
            this.isActive = true;
            this.isClickedOutside.set(false);
        }
    }
    static { this.ɵfac = function LineActionMenuComponent_Factory(t) { return new (t || LineActionMenuComponent)(i0.ɵɵdirectiveInject(i1.LanguageStore), i0.ɵɵdirectiveInject(i1.LanguageStore), i0.ɵɵdirectiveInject(i2.ScreenSizeObserverService), i0.ɵɵdirectiveInject(i3.SystemConfigStore), i0.ɵɵdirectiveInject(i0.ElementRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: LineActionMenuComponent, selectors: [["scrm-line-action-menu"]], hostBindings: function LineActionMenuComponent_HostBindings(rf, ctx) { if (rf & 1) {
            i0.ɵɵlistener("click", function LineActionMenuComponent_click_HostBindingHandler($event) { return ctx.onClickOutside($event.target); }, false, i0.ɵɵresolveDocument);
        } }, inputs: { klass: "klass", wrapperClass: "wrapperClass", record: "record", config: "config", activeLineAction: "activeLineAction", limitConfigKey: "limitConfigKey" }, decls: 1, vars: 1, consts: [[4, "ngIf"], [1, "line-action-container"], ["id", "line-action-div", 1, "line-action", "line-action-position"], [3, "ngClass"], [3, "config$", "klass", 4, "ngIf"], ["aria-label", "Mobile Menu Button", 1, "more-button", 3, "click"], ["image", "apps-line", 1, "sicon"], [3, "config$", "klass"]], template: function LineActionMenuComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, LineActionMenuComponent_ng_container_0_Template, 8, 8, "ng-container", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.actions.length);
        } }, dependencies: [i4.NgClass, i4.NgIf, i5.ImageComponent, i6.ButtonGroupComponent], encapsulation: 2 }); }
}
export { LineActionMenuComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LineActionMenuComponent, [{
        type: Component,
        args: [{ selector: 'scrm-line-action-menu', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<ng-container *ngIf=\"actions.length\">\n    <div class=\"line-action-container\">\n        <div id=\"line-action-div\" class=\"line-action line-action-position\">\n            <div class=\"{{wrapperClass}}\" [ngClass]=\"isActive ? 'active': ''\">\n                <div class=\"{{klass}}\">\n                    <scrm-button-group *ngIf=\"config$\" [config$]=\"config$\" [klass]=\"'icon-bar-block'\"></scrm-button-group>\n                </div>\n                <button class=\"more-button\" aria-label=\"Mobile Menu Button\" (click)=\"toggleExpand(record?.id)\">\n                    <scrm-image class=\"sicon\" image=\"apps-line\"></scrm-image>\n                </button>\n            </div>\n        </div>\n    </div>\n</ng-container>\n" }]
    }], function () { return [{ type: i1.LanguageStore }, { type: i1.LanguageStore }, { type: i2.ScreenSizeObserverService }, { type: i3.SystemConfigStore }, { type: i0.ElementRef }]; }, { klass: [{
            type: Input
        }], wrapperClass: [{
            type: Input
        }], record: [{
            type: Input
        }], config: [{
            type: Input
        }], activeLineAction: [{
            type: Input
        }], limitConfigKey: [{
            type: Input
        }], onClickOutside: [{
            type: HostListener,
            args: ['document:click', ['$event.target']]
        }] }); })();
//# sourceMappingURL=data:application/json;base64,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