import { Injectable } from '@angular/core';
import { DatetimeFormatter } from '../../../formatters/datetime/datetime-formatter.service';
import * as i0 from "@angular/core";
import * as i1 from "../../../formatters/datetime/datetime-formatter.service";
export const dateTimeValidator = (formatter, userFormat) => ((control) => {
    const invalid = formatter.validateUserFormat(control.value, userFormat);
    return invalid ? {
        dateTimeValidator: {
            value: control.value,
            message: {
                labelKey: 'LBL_VALIDATION_ERROR_DATETIME_FORMAT',
                context: {
                    value: control.value,
                    expected: formatter.toUserFormat('2020-01-23 12:30:40')
                }
            }
        },
    } : null;
});
class DateTimeValidator {
    constructor(formatter) {
        this.formatter = formatter;
    }
    applies(record, viewField) {
        if (!viewField || !viewField.fieldDefinition) {
            return false;
        }
        return viewField.type === 'datetime';
    }
    getValidator(viewField) {
        if (!viewField || !viewField.fieldDefinition) {
            return [];
        }
        const userFormat = viewField?.metadata?.date_time_format || '';
        return [dateTimeValidator(this.formatter, userFormat)];
    }
    static { this.ɵfac = function DateTimeValidator_Factory(t) { return new (t || DateTimeValidator)(i0.ɵɵinject(i1.DatetimeFormatter)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: DateTimeValidator, factory: DateTimeValidator.ɵfac, providedIn: 'root' }); }
}
export { DateTimeValidator };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateTimeValidator, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i1.DatetimeFormatter }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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