/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Component } from "@angular/core";
import { AppStateStore } from "../../../../store/app-state/app-state.store";
import { RecordViewStore } from "../../store/record-view/record-view.store";
import { ActivatedRoute } from "@angular/router";
import { RecordActionsAdapter } from "../../adapters/actions.adapter";
import { RecordViewSidebarWidgetService } from "../../services/record-view-sidebar-widget.service";
import * as i0 from "@angular/core";
import * as i1 from "../../../../store/app-state/app-state.store";
import * as i2 from "../../store/record-view/record-view.store";
import * as i3 from "@angular/router";
import * as i4 from "../../services/record-view-sidebar-widget.service";
import * as i5 from "@angular/common";
import * as i6 from "../record-container/record-container.component";
import * as i7 from "../record-header/record-header.component";
import * as i8 from "../../../../components/status-bar/status-bar.component";
function RecordComponent_div_0_scrm_status_bar_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-status-bar");
} }
function RecordComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1)(1, "div", 2);
    i0.ɵɵelement(2, "scrm-record-header");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "div", 3);
    i0.ɵɵelement(4, "hr", 4);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(5, RecordComponent_div_0_scrm_status_bar_5_Template, 1, 0, "scrm-status-bar", 5);
    i0.ɵɵelement(6, "scrm-record-container");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(5);
    i0.ɵɵproperty("ngIf", ctx_r0.showStatusBar);
} }
class RecordComponent {
    constructor(appState, recordStore, route, sidebarWidgetHandler) {
        this.appState = appState;
        this.recordStore = recordStore;
        this.route = route;
        this.sidebarWidgetHandler = sidebarWidgetHandler;
        this.vm$ = null;
        this.showStatusBar = false;
        this.TAG_COLORS = {
            vip: "#2ecc71",
            "bonus hunter": "#e74c3c",
            "short listed": "#3498db",
            registered: "#27ae60",
            hot: "#c0392b",
            remove: "#e67e22",
            "30% retention bonus": "#f1c40f",
            "50% retention bonus": "#f39c12",
            "30% 50% retention bonus": "#f1948a",
            outsource: "#9b59b6",
            "50k batch 1": "#8e44ad",
        };
    }
    ngOnInit() {
        console.log("[record.component.ts] ngOnInit");
        let mode = "detail";
        this.appState.addToPrevRoute(this.appState.getRouteUrl());
        const data = (this.route.snapshot && this.route.snapshot.data) || {};
        console.log("[record.component.ts] route data:", data);
        if (data.mode) {
            mode = data.mode;
        }
        const params = (this.route.snapshot && this.route.snapshot.queryParams) ||
            {};
        this.recordSub = this.recordStore
            .init(this.appState.getModule(), this.route.snapshot.params.record, mode, params)
            .subscribe();
        this.vm$ = this.recordStore.vm$;
        this.vm$.subscribe((vm) => {
            console.log("[record.component.ts] ViewModel received");
        });
        // ✅ Track view mode changes dynamically
        this.modeSub = this.recordStore.viewMode$.subscribe((mode) => {
            console.log("[record.component.ts] Current view mode is:", mode);
            if (mode === "edit") {
                setTimeout(() => {
                    console.log("[record.component.ts] Triggering emoji injection for edit view...");
                    //   this.injectCallStatusDot();
                    //   this.injectEditTagColors();
                }, 300);
            }
            if (mode === "detail") {
                setTimeout(() => {
                    console.log("[record.component.ts] Triggering emoji injection for edit view...");
                    this.injectDetailTagColors();
                    this.injectCallStatusDotDetail();
                }, 300);
            }
        });
    }
    ngAfterViewInit() {
        console.log("[record.component.ts] ngAfterViewInit");
    }
    ngOnDestroy() {
        if (this.recordSub) {
            this.recordSub.unsubscribe();
        }
        if (this.modeSub) {
            this.modeSub.unsubscribe();
        }
        this.sidebarWidgetHandler.destroy();
        this.recordStore.destroy();
    }
    injectCallStatusDot() {
        let attempts = 0;
        const interval = setInterval(() => {
            const container = document.querySelector(".field-name-call_status_c scrm-dropdownenum-edit select.custom-select");
            console.log("[record.component.ts] [emoji] Attempt", attempts, "- dropdown:", container);
            if (container || attempts > 10) {
                clearInterval(interval);
                if (!container) {
                    console.warn("[record.component.ts] [emoji] Call status <select> not found after 10 attempts.");
                    return;
                }
                const statusDot = {
                    willdeposit: "🟢 ",
                    interested: "🟢 ",
                    callterminated: "🔴 ",
                    depositdone: "🟢 ",
                    calllater: "🟡 ",
                    switchoff: "🔴 ",
                    notpicked1: "🟡 ",
                    notpicked2: "🟡 ",
                    notpicked3: "🟡 ",
                    invalidnumber: "🔴 ",
                    haventcall: "🟡 ",
                    notinterestbonus: "🔴 ",
                    notinterestweb: "🔴 ",
                    registered: "🟢 ",
                };
                for (let i = 0; i < container.options.length; i++) {
                    const opt = container.options[i];
                    const cleanVal = opt.value?.split(":")[1]?.trim().toLowerCase();
                    const symbol = statusDot[cleanVal];
                    if (symbol && !opt.textContent.trim().startsWith(symbol)) {
                        console.log(`[record.component.ts] [emoji] Injecting ${symbol} into:`, opt.textContent.trim());
                        opt.textContent = symbol + opt.textContent.trim();
                    }
                }
            }
            attempts++;
        }, 200);
    }
    injectCallStatusDotDetail() {
        let attempts = 0;
        const interval = setInterval(() => {
            const container = document.querySelector(".field-name-call_status_c scrm-dropdownenum-detail");
            console.log("[record.component.ts] [emoji] Attempt", attempts, "- container:", container);
            if (container || attempts > 10) {
                clearInterval(interval);
                if (!container) {
                    console.warn("[record.component.ts] [emoji] Call status not found.");
                    return;
                }
                const statusDot = {
                    willdeposit: "🟢",
                    interested: "🟢",
                    callterminated: "🔴",
                    depositdone: "🟢",
                    calllater: "🟡",
                    switchoff: "🔴",
                    notpicked1: "🟡",
                    notpicked2: "🟡",
                    notpicked3: "🟡",
                    invalidnumber: "🔴",
                    haventcall: "🟡",
                    notinterestbonus: "🔴",
                    notinterestweb: "🔴",
                    registered: "🟢",
                };
                const originalText = container.textContent?.trim() || "";
                const cleanVal = originalText.toLowerCase().replace(/\s+/g, "");
                const symbol = statusDot[cleanVal];
                if (symbol && !originalText.startsWith(symbol)) {
                    container.textContent = `${symbol} ${originalText}`;
                    console.log(`[record.component.ts] [emoji] Injected ${symbol} into detail text.`);
                }
                else {
                    console.log("[record.component.ts] [emoji] No match or already injected.");
                }
            }
            attempts++;
        }, 200);
    }
    applyFlatTagStyle(el, label) {
        const color = this.TAG_COLORS[label.toLowerCase()];
        if (!color)
            return;
        el.style.backgroundColor = color;
        el.style.color = "white";
        el.style.fontSize = "12px";
        el.style.fontWeight = "bold";
        el.style.padding = "2px 8px";
        el.style.borderRadius = "12px";
        el.style.display = "inline-block";
        el.style.margin = "2px";
    }
    injectEditTagColors() {
        let attempts = 0;
        const interval = setInterval(() => {
            const wrapper = document.querySelector(".dynamic-field-name-tag_c p-multiselect");
            const tokens = document.querySelectorAll(".p-multiselect-token, .p-multiselect-item");
            if ((wrapper && tokens.length > 0) || attempts > 10) {
                clearInterval(interval);
                tokens.forEach((el) => {
                    const label = el.textContent?.trim().toLowerCase();
                    this.applyFlatTagStyle(el, label);
                });
                // ✅ Reapply styling every time dropdown opens
                const trigger = wrapper?.querySelector(".p-multiselect-trigger");
                if (trigger) {
                    trigger.addEventListener("click", () => {
                        console.log("[TagColor] Multiselect clicked - reapplying colors after open...");
                        setTimeout(() => {
                            const items = document.querySelectorAll(".p-multiselect-item");
                            items.forEach((el) => {
                                const label = el.textContent?.trim().toLowerCase();
                                this.applyFlatTagStyle(el, label);
                            });
                        }, 200); // slight delay to allow DOM to render
                    });
                }
            }
            attempts++;
        }, 300);
    }
    injectDetailTagColors() {
        let attempts = 0;
        const interval = setInterval(() => {
            //   console.log(`[TagColor] [DETAIL] Attempt ${attempts + 1}`);
            const fieldWrapper = document.querySelector("scrm-field.field-name-tag_c");
            const detailItems = fieldWrapper?.querySelectorAll("scrm-multienum-detail li") || [];
            if (detailItems.length > 0 || attempts > 10) {
                clearInterval(interval);
                if (detailItems.length === 0) {
                    //   console.warn("[TagColor] No tag items found in detail view.");
                    return;
                }
                detailItems.forEach((el) => {
                    const label = el.textContent?.trim().toLowerCase();
                    this.applyFlatTagStyle(el, label);
                });
                // console.log(
                //   `[TagColor] Detail view styled (${detailItems.length} items)`
                // );
            }
            attempts++;
        }, 300);
    }
    static { this.ɵfac = function RecordComponent_Factory(t) { return new (t || RecordComponent)(i0.ɵɵdirectiveInject(i1.AppStateStore), i0.ɵɵdirectiveInject(i2.RecordViewStore), i0.ɵɵdirectiveInject(i3.ActivatedRoute), i0.ɵɵdirectiveInject(i4.RecordViewSidebarWidgetService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: RecordComponent, selectors: [["scrm-record"]], features: [i0.ɵɵProvidersFeature([
                RecordViewStore,
                RecordActionsAdapter,
                RecordViewSidebarWidgetService,
            ])], decls: 2, vars: 3, consts: [["class", "record-view", 4, "ngIf"], [1, "record-view"], [1, "record-view-position-sticky"], [1, "record-view-hr-container"], [1, "record-view-hr"], [4, "ngIf"]], template: function RecordComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, RecordComponent_div_0_Template, 7, 1, "div", 0);
            i0.ɵɵpipe(1, "async");
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", i0.ɵɵpipeBind1(1, 1, ctx.vm$));
        } }, dependencies: [i5.NgIf, i6.RecordContainerComponent, i7.RecordHeaderComponent, i8.StatusBarComponent, i5.AsyncPipe], encapsulation: 2 }); }
}
export { RecordComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RecordComponent, [{
        type: Component,
        args: [{ selector: "scrm-record", providers: [
                    RecordViewStore,
                    RecordActionsAdapter,
                    RecordViewSidebarWidgetService,
                ], template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<!-- Start Record View Section -->\n<div class=\"record-view\" *ngIf=\"(vm$ | async) as vm\">\n\n    <div class=\"record-view-position-sticky\">\n        <scrm-record-header></scrm-record-header>\n    </div>\n    <div class=\"record-view-hr-container\">\n        <hr class=\"record-view-hr\">\n    </div>\n\n    <scrm-status-bar *ngIf=\"showStatusBar\"></scrm-status-bar>\n    <scrm-record-container></scrm-record-container>\n</div>\n<!-- End Record View Section -->\n" }]
    }], function () { return [{ type: i1.AppStateStore }, { type: i2.RecordViewStore }, { type: i3.ActivatedRoute }, { type: i4.RecordViewSidebarWidgetService }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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