import * as i0 from '@angular/core';
import { Injectable, signal, Component, Input, EventEmitter, Output, Pipe, ChangeDetectionStrategy, LOCALE_ID, Inject, NgModule, CUSTOM_ELEMENTS_SCHEMA, Directive, ViewChild, inject, computed, HostBinding, HostListener, SecurityContext, createNgModule } from '@angular/core';
import * as i4 from 'common';
import { deepClone, emptyObject, isVoid, Button, isFalse, SelectionStatus, BaseComponentRegistry, ActionHandler, isEmptyString, isTrue, MessageTypes, BaseServiceRegistry, SortDirection, PageSelection, OverridableMap, EDITABLE_VIEW_MODES, BaseField, BaseTypeRegistry, LineActionEvent, isEditable, ready, ALL_VIEW_MODES, PaginationType } from 'common';
import { BehaviorSubject, of, merge, combineLatestWith, forkJoin, Subject, fromEvent, throwError, timer, combineLatest, Subscription, isObservable, from } from 'rxjs';
import { map, distinctUntilChanged, tap, shareReplay, first, take, debounceTime, filter, catchError, skip, finalize, startWith, takeWhile, debounce, concatAll, toArray, concatMap } from 'rxjs/operators';
import * as i1 from 'apollo-angular';
import { gql } from 'apollo-angular';
import * as i1$1 from '@angular/cdk/layout';
import { Breakpoints } from '@angular/cdk/layout';
import { isString, isEmpty, isNil, trimStart, trimEnd, isEqual, isNull, isObject, isArray, uniqBy, toInteger, merge as merge$1, isNumber, union, floor, toNumber } from 'lodash-es';
import * as i2 from '@angular/common';
import { formatNumber, formatDate, formatCurrency, CommonModule, DecimalPipe, DOCUMENT } from '@angular/common';
import * as i3 from 'angular-svg-icon';
import { AngularSvgIconModule } from 'angular-svg-icon';
import * as i3$1 from '@ng-bootstrap/ng-bootstrap';
import { NgbModule, NgbDropdownModule, NgbTooltipModule, NgbModalModule, NgbPopover, NgbDatepickerModule, NgbTimepickerModule, NgbDateParserFormatter, NgbDateAdapter, ModalDismissReasons, NgbAlertModule, NgbPopoverModule } from '@ng-bootstrap/ng-bootstrap';
import { DateTime, IANAZone } from 'luxon';
import get from 'lodash-es/get';
import partial from 'lodash-es/partial';
import * as i3$2 from '@swimlane/ngx-charts';
import { NgxChartsModule } from '@swimlane/ngx-charts';
import * as i3$3 from 'ng-dynamic-component';
import { DynamicModule } from 'ng-dynamic-component';
import * as i5 from '@angular/cdk/drag-drop';
import { moveItemInArray, transferArrayItem, DragDropModule } from '@angular/cdk/drag-drop';
import { multiply, divide, round } from 'mathjs';
import * as i1$2 from '@angular/router';
import { RouterModule, DefaultUrlSerializer, PRIMARY_OUTLET, RouterLink, NavigationEnd, UrlTree } from '@angular/router';
import { MutationObserverFactory } from '@angular/cdk/observers';
import { trigger, transition, animate, style, useAnimation } from '@angular/animations';
import * as i7 from 'primeng/api';
import { SharedModule } from 'primeng/api';
import * as i10 from 'primeng/multiselect';
import { MultiSelectModule } from 'primeng/multiselect';
import * as i5$1 from '@angular/forms';
import { FormsModule, ReactiveFormsModule, UntypedFormGroup, Validators, UntypedFormArray, UntypedFormControl, FormGroup, FormControl } from '@angular/forms';
import * as i5$2 from 'ngx-chips';
import { TagInputModule } from 'ngx-chips';
import * as i1$3 from '@angular/common/http';
import { HttpParams, HttpHeaders } from '@angular/common/http';
import * as i13 from 'primeng/dropdown';
import { DropdownModule } from 'primeng/dropdown';
import * as i14 from 'primeng/inputtext';
import { InputTextModule } from 'primeng/inputtext';
import * as i5$3 from '@tinymce/tinymce-angular';
import { TINYMCE_SCRIPT_SRC, EditorModule } from '@tinymce/tinymce-angular';
import isObjectLike from 'lodash-es/isObjectLike';
import set from 'lodash-es/set';
import { fadeIn, fadeOut, backInDown } from 'ng-animate';
import defaults from 'lodash-es/defaults';
import * as i7$1 from 'primeng/sidebar';
import { SidebarModule } from 'primeng/sidebar';
import * as i1$4 from '@angular/cdk/clipboard';
import * as i4$1 from '@angular/cdk/table';
import { CdkTableModule } from '@angular/cdk/table';
import * as i5$4 from '@angular/cdk/scrolling';
import { CdkVirtualScrollViewport, ScrollingModule } from '@angular/cdk/scrolling';
import * as i1$5 from '@angular/platform-browser';
import { loadRemoteModule } from '@angular-architects/module-federation-runtime';

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class CollectionGQL {
    constructor(apollo) {
        this.apollo = apollo;
    }
    /**
     * Fetch data either from backend or cache
     *
     * @param {string} module to get from
     * @param {object} metadata with the fields to ask for
     *
     * @returns {object} Observable<ApolloQueryResult<any>>
     */
    fetchAll(module, metadata) {
        const fields = metadata.fields;
        const queryOptions = {
            query: gql `
                query ${module}{
                    ${module} {
                        edges {
                            node {
                                ${fields.join('\n')}
                            }
                        }
                    }
                }
            `
        };
        return this.apollo.query(queryOptions);
    }
    static { this.ɵfac = function CollectionGQL_Factory(t) { return new (t || CollectionGQL)(i0.ɵɵinject(i1.Apollo)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: CollectionGQL, factory: CollectionGQL.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CollectionGQL, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i1.Apollo }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
const initialState$n = {
    configs: {},
    loading: false
};
let internalState$a = deepClone(initialState$n);
let cache$$7 = null;
class SystemConfigStore {
    constructor(collectionGQL) {
        this.collectionGQL = collectionGQL;
        this.store = new BehaviorSubject(internalState$a);
        this.state$ = this.store.asObservable();
        this.resourceName = 'systemConfigs';
        this.fieldsMetadata = {
            fields: [
                'id',
                '_id',
                'value',
                'items'
            ]
        };
        this.configs$ = this.state$.pipe(map(state => state.configs), distinctUntilChanged());
        this.loading$ = this.state$.pipe(map(state => state.loading));
    }
    /**
     * Public Api
     */
    /**
     * Get system config value by key
     *
     * @param {string} configKey of the config
     * @returns {{}|string} config value
     */
    getConfigValue(configKey) {
        if (!internalState$a.configs || !internalState$a.configs[configKey]) {
            return null;
        }
        if (internalState$a.configs[configKey].value !== null) {
            return internalState$a.configs[configKey].value;
        }
        return internalState$a.configs[configKey].items;
    }
    /**
     * Get ui config value by key
     *
     * @param {string} configKey of the ui config
     * @returns {{}|string} config value
     */
    getUi(configKey) {
        const ui = this.getConfigValue('ui') ?? {};
        return ui[configKey] ?? null;
    }
    getHomePage() {
        let defaultModule = 'home';
        const defaultModuleConfig = this.getConfigValue('default_module');
        if (defaultModuleConfig) {
            defaultModule = defaultModuleConfig;
        }
        return defaultModule;
    }
    /**
     * Clear state
     */
    clear() {
        cache$$7 = null;
        this.updateState(deepClone(initialState$n));
    }
    clearAuthBased() {
        this.clear();
    }
    /**
     * Initial SystemConfigs load if not cached and update state.
     * Returns observable to be used in resolver if needed
     *
     * @returns {Observable<{}>} observable
     */
    load() {
        this.updateState({ ...internalState$a, loading: true });
        return this.getSystemConfigs().pipe(tap(configs => {
            this.updateState({ ...internalState$a, configs, loading: false });
        }));
    }
    /**
     * Check if loaded
     */
    isCached() {
        return cache$$7 !== null;
    }
    /**
     * Set pre-loaded configs and cache
     */
    set(configs) {
        cache$$7 = of(configs).pipe(shareReplay(1));
        this.updateState({ ...internalState$a, configs, loading: false });
    }
    /**
     * Internal API
     */
    /**
     * Update the state
     *
     * @param {{}} state new state
     */
    updateState(state) {
        this.store.next(internalState$a = state);
    }
    /**
     * Get SystemConfigs cached Observable or call the backend
     *
     * @returns {Observable<{}>} observable
     */
    getSystemConfigs() {
        if (cache$$7 == null) {
            cache$$7 = this.fetch().pipe(shareReplay(1));
        }
        return cache$$7;
    }
    /**
     * Fetch the App strings from the backend
     *
     * @returns {Observable<{}>} observable
     */
    fetch() {
        return this.collectionGQL
            .fetchAll(this.resourceName, this.fieldsMetadata).pipe(map(({ data }) => {
            const configs = {};
            if (data.systemConfigs && data.systemConfigs.edges) {
                data.systemConfigs.edges.forEach((edge) => {
                    // eslint-disable-next-line no-underscore-dangle
                    configs[edge.node._id] = edge.node;
                });
            }
            return configs;
        }));
    }
    static { this.ɵfac = function SystemConfigStore_Factory(t) { return new (t || SystemConfigStore)(i0.ɵɵinject(CollectionGQL)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: SystemConfigStore, factory: SystemConfigStore.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(SystemConfigStore, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], function () { return [{ type: CollectionGQL }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
var ScreenSize;
(function (ScreenSize) {
    ScreenSize["XSmall"] = "XSmall";
    ScreenSize["Small"] = "Small";
    ScreenSize["Medium"] = "Medium";
    ScreenSize["Large"] = "Large";
    ScreenSize["XLarge"] = "XLarge";
})(ScreenSize || (ScreenSize = {}));
class ScreenSizeObserverService {
    constructor(breakpointObserver) {
        this.breakpointObserver = breakpointObserver;
        this.screenSize = new BehaviorSubject(ScreenSize.Medium);
        this.screenSize$ = this.screenSize.asObservable();
        this.initScreenSizeObservable();
    }
    initScreenSizeObservable() {
        merge(this.breakpointObserver.observe([
            Breakpoints.XSmall,
        ]).pipe(map((result) => {
            if (result.matches) {
                return ScreenSize.XSmall;
            }
        })), this.breakpointObserver.observe([
            Breakpoints.Small,
        ]).pipe(map((result) => {
            if (result.matches) {
                return ScreenSize.Small;
            }
        })), this.breakpointObserver.observe([
            Breakpoints.Medium,
        ]).pipe(map((result) => {
            if (result.matches) {
                return ScreenSize.Medium;
            }
        })), this.breakpointObserver.observe([
            Breakpoints.Large,
        ]).pipe(map((result) => {
            if (result.matches) {
                return ScreenSize.Large;
            }
        })), this.breakpointObserver.observe([
            Breakpoints.XLarge,
        ]).pipe(map((result) => {
            if (result.matches) {
                return ScreenSize.XLarge;
            }
        }))).subscribe((value) => {
            if (value) {
                this.screenSize.next(value);
            }
        });
    }
    static { this.ɵfac = function ScreenSizeObserverService_Factory(t) { return new (t || ScreenSizeObserverService)(i0.ɵɵinject(i1$1.BreakpointObserver)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ScreenSizeObserverService, factory: ScreenSizeObserverService.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ScreenSizeObserverService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i1$1.BreakpointObserver }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class EntityGQL {
    constructor(apollo) {
        this.apollo = apollo;
    }
    /**
     * Fetch data either from backend or cache
     *
     * @param {string} entity to get from
     * @param {string} id of the record
     * @param {object} metadata with the fields to ask for
     *
     * @returns {object}  Observable<ApolloQueryResult<any>>
     */
    fetch(entity, id, metadata) {
        const fields = metadata.fields;
        const queryOptions = {
            query: gql `
              query ${entity}($id: ID!) {
                ${entity}(id: $id) {
                  ${fields.join('\n')}
                }
              }
            `,
            variables: {
                id,
            },
        };
        return this.apollo.query(queryOptions);
    }
    static { this.ɵfac = function EntityGQL_Factory(t) { return new (t || EntityGQL)(i0.ɵɵinject(i1.Apollo)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: EntityGQL, factory: EntityGQL.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EntityGQL, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i1.Apollo }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class LocalStorageService {
    constructor() {
        this.storageKey = 'scrm-session-storage';
        this.stickyStorageKey = 'scrm-sticky-session-storage';
    }
    clear() {
        this.getLocalStorage().removeItem(this.storageKey);
        const sticky = this.getLocalStorage().getItem(this.stickyStorageKey);
        if (sticky) {
            this.getLocalStorage().setItem(this.storageKey, sticky);
        }
    }
    set(key, data, sticky = false) {
        this.store(this.storageKey, key, data);
        if (sticky) {
            this.store(this.stickyStorageKey, key, data);
        }
    }
    store(storageKey, key, data) {
        const storeJson = this.getLocalStorage().getItem(storageKey);
        let store = {};
        if (storeJson) {
            store = JSON.parse(storeJson);
        }
        store[key] = data;
        this.getLocalStorage().setItem(storageKey, JSON.stringify(store));
    }
    get(key) {
        const storeJson = this.getLocalStorage().getItem(this.storageKey);
        let store = {};
        if (storeJson) {
            store = JSON.parse(storeJson);
        }
        return store[key];
    }
    getLocalStorage() {
        return localStorage;
    }
    static { this.ɵfac = function LocalStorageService_Factory(t) { return new (t || LocalStorageService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: LocalStorageService, factory: LocalStorageService.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LocalStorageService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return []; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class EntityMutationGQL {
    constructor(apollo) {
        this.apollo = apollo;
    }
    /**
     * Create record on the backend
     *
     * @param {string} graphqlEntityName to use
     * @param {string} entityName to use
     * @param {object} input values
     * @param {object} metadata with the fields to ask for
     *
     * @returns {object} Observable<any>
     */
    create(graphqlEntityName, entityName, input, metadata) {
        const fields = metadata.fields;
        const mutationOptions = {
            mutation: gql `
                mutation create${entityName}($input: create${entityName}Input!) {
                  create${entityName}(input: $input) {
                    ${graphqlEntityName} {
                      ${fields.join('\n')}
                    }
                    clientMutationId
                  }
                }
            `,
            variables: {
                input
            },
        };
        return this.apollo.mutate(mutationOptions);
    }
    static { this.ɵfac = function EntityMutationGQL_Factory(t) { return new (t || EntityMutationGQL)(i0.ɵɵinject(i1.Apollo)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: EntityMutationGQL, factory: EntityMutationGQL.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EntityMutationGQL, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i1.Apollo }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
const blankProcess = {
    id: null,
    _id: null,
    status: null,
    async: null,
    type: null,
    options: null,
    messages: []
};
class ProcessService {
    constructor(recordMutationGQL) {
        this.recordMutationGQL = recordMutationGQL;
        this.graphqlName = 'process';
        this.coreName = 'Process';
        this.createFieldsMetadata = {
            fields: [
                '_id',
                'status',
                'async',
                'type',
                'messages',
                'data'
            ]
        };
    }
    /**
     * Public Api
     */
    /**
     * Submit and action/process request
     * Returns observable
     *
     * @param {string} type to create
     * @param {object} options to send
     * @returns {object} Observable<any>
     */
    submit(type, options) {
        return this.create(type, options);
    }
    /**
     * Internal API
     */
    /**
     * Create a process on the backend
     *
     * @param {string} type to create
     * @param {object} options to send
     * @returns {object} Observable<any>
     */
    create(type, options) {
        const input = {
            type,
            options
        };
        return this.recordMutationGQL.create(this.graphqlName, this.coreName, input, this.createFieldsMetadata)
            .pipe(map(({ data }) => {
            const process = { ...blankProcess };
            if (data.createProcess && data.createProcess.process) {
                return data.createProcess.process;
            }
            return process;
        }));
    }
    static { this.ɵfac = function ProcessService_Factory(t) { return new (t || ProcessService)(i0.ɵɵinject(EntityMutationGQL)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ProcessService, factory: ProcessService.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ProcessService, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], function () { return [{ type: EntityMutationGQL }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
const initialState$m = {
    appStrings: {},
    appListStrings: {},
    modStrings: {},
    languageKey: 'en_us',
    loaded: {},
    hasChanged: false
};
let internalState$9 = deepClone(initialState$m);
const initialCache$1 = {
    appStrings: {},
    appListStrings: {},
    modStrings: {},
};
let loadedLanguages = {};
let cache$1 = deepClone(initialCache$1);
class LanguageStore {
    constructor(recordGQL, localStorage, processService, configs) {
        this.recordGQL = recordGQL;
        this.localStorage = localStorage;
        this.processService = processService;
        this.configs = configs;
        this.store = new BehaviorSubject(internalState$9);
        this.state$ = this.store.asObservable();
        this.config = {
            appStrings: {
                fetch: 'fetchAppStrings',
                resourceName: 'appStrings',
                metadata: {
                    fields: [
                        'id',
                        '_id',
                        'items'
                    ]
                }
            },
            appListStrings: {
                fetch: 'fetchAppListStrings',
                resourceName: 'appListStrings',
                metadata: {
                    fields: [
                        'id',
                        '_id',
                        'items'
                    ]
                }
            },
            modStrings: {
                fetch: 'fetchModStrings',
                resourceName: 'modStrings',
                metadata: {
                    fields: [
                        'id',
                        '_id',
                        'items'
                    ]
                }
            },
        };
        this.appStrings$ = this.state$.pipe(map(state => state.appStrings), distinctUntilChanged());
        this.appListStrings$ = this.state$.pipe(map(state => state.appListStrings), distinctUntilChanged());
        this.modStrings$ = this.state$.pipe(map(state => state.modStrings), distinctUntilChanged());
        this.languageKey$ = this.state$.pipe(map(state => state.languageKey), distinctUntilChanged());
        this.vm$ = this.appStrings$
            .pipe(combineLatestWith(this.appListStrings$, this.modStrings$, this.languageKey$), map(([appStrings, appListStrings, modStrings, languageKey]) => ({ appStrings, appListStrings, modStrings, languageKey })));
    }
    /**
     * Public Api
     */
    /**
     * Clear state
     */
    clear() {
        loadedLanguages = {};
        cache$1 = deepClone(initialCache$1);
        this.updateState(deepClone(initialState$m));
    }
    clearAuthBased() {
        const keysToClear = ['modStrings', 'appListStrings'];
        keysToClear.forEach(type => {
            if (loadedLanguages && loadedLanguages[type]) {
                delete loadedLanguages[type];
            }
        });
        cache$1.modStrings = {};
        cache$1.appListStrings = {};
    }
    /**
     * Update the language strings toe the given language
     *
     * @param {string} languageKey language key
     * @param {boolean} reload
     */
    changeLanguage(languageKey, reload = false) {
        const types = [];
        Object.keys(loadedLanguages).forEach(type => loadedLanguages[type] && types.push(type));
        internalState$9.hasChanged = true;
        return this.load(languageKey, types, reload).pipe(tap(() => {
            this.localStorage.set('selected_language', languageKey, true);
        }));
    }
    /**
     * Get All languageStrings label by key
     *
     * @returns {object} LanguageStrings
     */
    getLanguageStrings() {
        if (!internalState$9) {
            return null;
        }
        return {
            appStrings: internalState$9.appStrings,
            appListStrings: internalState$9.appListStrings,
            modStrings: internalState$9.modStrings,
            languageKey: internalState$9.languageKey
        };
    }
    /**
     * Get AppStrings label by key
     *
     * @param {string} labelKey to fetch
     * @returns {string} label
     */
    getAppString(labelKey) {
        if (!internalState$9.appStrings || !internalState$9.appStrings[labelKey]) {
            return null;
        }
        return internalState$9.appStrings[labelKey];
    }
    /**
     * Get AppListStrings label by key
     *
     * @param {string} labelKey to fetch
     * @returns {string|{}} app strings
     */
    getAppListString(labelKey) {
        if (!internalState$9.appListStrings || !internalState$9.appListStrings[labelKey]) {
            return null;
        }
        return internalState$9.appListStrings[labelKey];
    }
    /**
     * Get ModStrings label by key
     *
     * @param {string} labelKey to fetch
     * @returns {string|{}} mod strings
     */
    getModString(labelKey) {
        if (!internalState$9.modStrings || !internalState$9.modStrings[labelKey]) {
            return null;
        }
        return internalState$9.modStrings[labelKey];
    }
    /**
     * Get field label
     *
     * @param {string} labelKey to fetch
     * @param {string} module to use
     * @param {object} lang to use
     * @returns {string} label
     */
    getFieldLabel(labelKey, module = null, lang = null) {
        let languages = lang;
        if (!lang) {
            languages = this.getLanguageStrings();
        }
        if (!languages || !languages.modStrings || !labelKey) {
            return '';
        }
        let label = '';
        if (module) {
            label = languages.modStrings[module] && languages.modStrings[module][labelKey];
        }
        if (!label) {
            label = languages.appStrings && languages.appStrings[labelKey];
        }
        return label || '';
    }
    /**
     * Get list label
     *
     * @param {string} listKey to fetch
     * @param {string} labelKey to fetch
     * @returns {string} label
     */
    getListLabel(listKey, labelKey) {
        if (!listKey || !labelKey) {
            return '';
        }
        const listStrings = this.getAppListString(listKey);
        if (!listStrings) {
            return '';
        }
        return listStrings[labelKey] || '';
    }
    /**
     * Get all available string types
     *
     * @returns {string[]} string types
     */
    getAvailableStringsTypes() {
        return Object.keys(this.config);
    }
    /**
     * Returns whether the language has changed manually
     *
     * @returns {boolean} has changed
     */
    hasLanguageChanged() {
        return internalState$9.hasChanged;
    }
    /**
     * Returns the currently active language
     *
     * @returns {string} current language key
     */
    getCurrentLanguage() {
        const storedLanguage = this.localStorage.get('selected_language');
        if (storedLanguage) {
            return storedLanguage;
        }
        return internalState$9.languageKey ?? 'en_us';
    }
    /**
     * Returns the active language
     *
     * @returns {string} active language key
     */
    getActiveLanguage() {
        return internalState$9.languageKey ?? '';
    }
    /**
     * Returns the selected language
     *
     * @returns {string} selected language key
     */
    getSelectedLanguage() {
        return this.localStorage.get('selected_language') ?? '';
    }
    /**
     * Check if language is enabled
     * @param currentLanguage
     */
    isLanguageEnabled(currentLanguage) {
        if (!currentLanguage) {
            return false;
        }
        const languages = this.configs.getConfigValue('languages') ?? {};
        const disabled = this.getDisabledLanguages();
        const languageKeys = Object.keys(languages);
        if (!languageKeys.length) {
            return false;
        }
        return languageKeys.includes(currentLanguage) && !disabled.includes(currentLanguage);
    }
    /**
     * Get disabled languages
     */
    getDisabledLanguages() {
        const disabledConfig = this.configs.getConfigValue('disabled_languages') ?? '';
        if (!isString(disabledConfig) || disabledConfig === '') {
            return [];
        }
        return disabledConfig.replace(' ', '').split(',');
    }
    /**
     * Get enabled languages
     */
    getEnabledLanguages() {
        const languages = this.configs.getConfigValue('languages') ?? {};
        const disabled = this.getDisabledLanguages();
        const enabled = {};
        const enabledKeys = Object.keys(languages).filter(value => !disabled.includes(value));
        enabledKeys.forEach(key => {
            enabled[key] = languages[key];
        });
        return enabled;
    }
    /**
     * Get fist language in list
     * @private
     */
    getFirstLanguage() {
        const languages = this.configs.getConfigValue('languages') ?? {};
        const languageKeys = Object.keys(languages);
        return languageKeys.sort()[0] ?? '';
    }
    /**
     * Initial Language Strings Load for given language and types if not cached and update state.
     * Returns observable to be used in resolver if needed
     *
     * @param {string} languageKey to load
     * @param {string[]} types to load
     * @param {boolean} reload
     * @returns {object} Observable
     */
    load(languageKey, types, reload = false) {
        const streams$ = [];
        types.forEach(type => streams$.push(this.getStrings(languageKey, type, reload)));
        return forkJoin(streams$).pipe(first(), tap(result => {
            const stateUpdate = { ...internalState$9, languageKey };
            types.forEach((type, index) => {
                stateUpdate[type] = result[index];
                loadedLanguages[type] = true;
            });
            this.updateState(stateUpdate);
        }));
    }
    /**
     * Check if loaded
     */
    areAllCached() {
        let isCached = true;
        isCached = isCached && !emptyObject(cache$1?.appStrings ?? {});
        isCached = isCached && !emptyObject(cache$1?.appListStrings ?? {});
        isCached = isCached && !emptyObject(cache$1?.modStrings ?? {});
        return isCached;
    }
    /**
     * Set pre-loaded strings and cache
     */
    set(languageKey, languageStrings) {
        const stateUpdate = { ...internalState$9, languageKey };
        if (languageStrings.appStrings && !emptyObject(languageStrings.appStrings)) {
            cache$1['appStrings'][languageKey] = of(languageStrings.appStrings).pipe(shareReplay(1));
            stateUpdate['appStrings'] = languageStrings.appStrings;
            loadedLanguages['appStrings'] = true;
        }
        if (languageStrings.appListStrings && !emptyObject(languageStrings.appListStrings)) {
            cache$1['appListStrings'][languageKey] = of(languageStrings.appListStrings).pipe(shareReplay(1));
            stateUpdate['appListStrings'] = languageStrings.appListStrings;
            loadedLanguages['appListStrings'] = true;
        }
        if (languageStrings.modStrings && !emptyObject(languageStrings.modStrings)) {
            cache$1['modStrings'][languageKey] = of(languageStrings.modStrings).pipe(shareReplay(1));
            stateUpdate['modStrings'] = languageStrings.modStrings;
            loadedLanguages['modStrings'] = true;
        }
        this.updateState(stateUpdate);
    }
    /**
     * Set session language
     */
    setSessionLanguage() {
        const processType = 'set-session-language';
        const options = {
            language: internalState$9.languageKey
        };
        return this.processService.submit(processType, options).pipe(take(1));
    }
    /**
     * Set session language
     */
    setUserLanguage() {
        const processType = 'set-user-language';
        const options = {
            language: internalState$9.languageKey
        };
        return this.processService.submit(processType, options).pipe(take(1));
    }
    /**
     * Internal API
     */
    /**
     * Update internal state cache and emit from store...
     *
     * @param {{}} state to set
     */
    updateState(state) {
        this.store.next(internalState$9 = state);
    }
    /**
     * Get given $type of strings Observable from cache  or call the backend
     *
     * @param {string} language to load
     * @param {string} type load
     * @param {boolean} reload
     * @returns {object} Observable<any>
     */
    getStrings(language, type, reload = false) {
        const stringsCache = cache$1[type];
        const fetchMethod = this.config[type].fetch;
        if (stringsCache[language] && reload === false) {
            return stringsCache[language];
        }
        stringsCache[language] = this[fetchMethod](language).pipe(shareReplay(1));
        return stringsCache[language];
    }
    /**
     * Fetch the App strings from the backend
     *
     * @param {string} language to fetch
     * @returns {{}} Observable<{}>
     */
    fetchAppStrings(language) {
        const resourceName = this.config.appStrings.resourceName;
        const fields = this.config.appStrings.metadata;
        return this.recordGQL.fetch(resourceName, `/api/app-strings/${language}`, fields)
            .pipe(map(({ data }) => {
            let items = {};
            if (data.appStrings) {
                items = data.appStrings.items;
            }
            return items;
        }));
    }
    /**
     * Fetch the App list strings from the backend
     *
     * @param {string} language to fetch
     * @returns {{}} Observable<{}>
     */
    fetchAppListStrings(language) {
        const resourceName = this.config.appListStrings.resourceName;
        const fields = this.config.appListStrings.metadata;
        return this.recordGQL.fetch(resourceName, `/api/app-list-strings/${language}`, fields)
            .pipe(map(({ data }) => {
            let items = {};
            if (data.appListStrings) {
                items = data.appListStrings.items;
            }
            return items;
        }));
    }
    /**
     * Fetch the Mod strings from the backend
     *
     * @param {string} language to fetch
     * @returns {{}} Observable<{}>
     */
    fetchModStrings(language) {
        const resourceName = this.config.modStrings.resourceName;
        const fields = this.config.modStrings.metadata;
        return this.recordGQL.fetch(resourceName, `/api/mod-strings/${language}`, fields)
            .pipe(map(({ data }) => {
            let items = {};
            if (data.modStrings) {
                items = data.modStrings.items;
            }
            return items;
        }));
    }
    static { this.ɵfac = function LanguageStore_Factory(t) { return new (t || LanguageStore)(i0.ɵɵinject(EntityGQL), i0.ɵɵinject(LocalStorageService), i0.ɵɵinject(ProcessService), i0.ɵɵinject(SystemConfigStore)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: LanguageStore, factory: LanguageStore.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LanguageStore, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], function () { return [{ type: EntityGQL }, { type: LocalStorageService }, { type: ProcessService }, { type: SystemConfigStore }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class LoadingBuffer {
    constructor(config, delayConfigKey = 'loading_display_delay') {
        this.config = config;
        this.delayConfigKey = delayConfigKey;
        this.loadingStore = new BehaviorSubject(false);
        this.loadingBufferStore = new BehaviorSubject(false);
        this.subs = [];
        this.buffered = false;
        this.loading$ = this.loadingStore.asObservable();
        const uiSettings = config.getConfigValue('ui') ?? {};
        const delay = parseInt(uiSettings[delayConfigKey] ?? '') ?? 1500;
        this.loadingBufferStore$ = this.loadingBufferStore.asObservable().pipe(debounceTime(delay));
        this.subs.push(this.loadingBufferStore$.subscribe((loading) => {
            if (!this.buffered) {
                return;
            }
            this.loadingStore.next(loading);
        }));
    }
    /**
     * Update loading status
     *
     * @param {boolean} loading status to set
     */
    updateLoading(loading) {
        if (loading === true) {
            this.buffered = true;
            this.loadingBufferStore.next(loading);
            return;
        }
        this.buffered = false;
        this.loadingStore.next(loading);
        this.loadingBufferStore.next(loading);
    }
    static { this.ɵfac = function LoadingBuffer_Factory(t) { i0.ɵɵinvalidFactory(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: LoadingBuffer, factory: LoadingBuffer.ɵfac }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LoadingBuffer, [{
        type: Injectable
    }], function () { return [{ type: SystemConfigStore }, { type: undefined }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class LoadingBufferFactory {
    constructor(config) {
        this.config = config;
    }
    create(delayConfigKey = 'loading_display_delay') {
        return new LoadingBuffer(this.config, delayConfigKey);
    }
    static { this.ɵfac = function LoadingBufferFactory_Factory(t) { return new (t || LoadingBufferFactory)(i0.ɵɵinject(SystemConfigStore)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: LoadingBufferFactory, factory: LoadingBufferFactory.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LoadingBufferFactory, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], function () { return [{ type: SystemConfigStore }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
const initialState$l = {
    loading: false,
    initialAppLoading: true,
    module: null,
    view: null,
    loaded: false,
    routeUrl: null,
    preLoginUrl: null,
    currentUser: null,
    activeRequests: 0,
    prevRoutes: [],
    isSidebarVisible: false,
    activeNavbarDropdown: 0
};
let internalState$8 = deepClone(initialState$l);
class AppStateStore {
    constructor(loadingBufferFactory, configs) {
        this.loadingBufferFactory = loadingBufferFactory;
        this.configs = configs;
        this.store = new BehaviorSubject(internalState$8);
        this.state$ = this.store.asObservable();
        this.loadingQueue = {};
        this.subs = [];
        this.isTouchScreen = signal(false);
        this.loading$ = this.state$.pipe(map(state => state.loading), distinctUntilChanged());
        this.module$ = this.state$.pipe(map(state => state.module), distinctUntilChanged());
        this.view$ = this.state$.pipe(map(state => state.view), distinctUntilChanged());
        this.initialAppLoading$ = this.state$.pipe(map(state => state.initialAppLoading), distinctUntilChanged());
        this.activeRequests$ = this.state$.pipe(map(state => state.activeRequests), distinctUntilChanged());
        this.isSidebarVisible$ = this.state$.pipe(map(state => state.isSidebarVisible), distinctUntilChanged());
        this.activeNavbarDropdown$ = this.state$.pipe(map(state => state.activeNavbarDropdown), distinctUntilChanged());
        this.vm$ = this.loading$.pipe(combineLatestWith(this.module$, this.view$, this.initialAppLoading$), map(([loading, module, view, initialAppLoading]) => ({
            loading,
            module,
            view,
            loaded: internalState$8.loaded,
            initialAppLoading,
            isSidebarVisible: internalState$8.isSidebarVisible,
            activeNavbarDropdown: internalState$8.activeNavbarDropdown
        })));
        if ('ontouchstart' in window || navigator.maxTouchPoints > 0) {
            this.isTouchScreen.set(true);
        }
        else {
            this.isTouchScreen.set(false);
        }
    }
    /**
     * Public Api
     */
    /**
     * Clear state
     */
    clear() {
        this.loadingQueue = {};
        this.updateState(deepClone(initialState$l));
        this.subs.forEach(sub => sub.unsubscribe());
    }
    clearAuthBased() {
    }
    init() {
        this.initLoadingBuffer();
    }
    /**
     * Check if is logged in
     */
    isLoggedIn() {
        return !!(internalState$8.currentUser ?? false);
    }
    /**
     * Get current user
     */
    getCurrentUser() {
        return internalState$8.currentUser;
    }
    /**
     * Set current user
     * @param user
     */
    setCurrentUser(user) {
        if (!isVoid(user)) {
            this.onLogin();
        }
        else {
            this.onLogout();
        }
        this.updateState({ ...internalState$8, currentUser: user });
    }
    /**
     * On login handlers
     * @protected
     */
    onLogin() {
    }
    /**
     * On logout handlers
     * @protected
     */
    onLogout() {
        this.updateState({ ...internalState$8, preLoginUrl: null });
    }
    /**
     * Get number of active requests
     */
    getActiveRequests() {
        return internalState$8.activeRequests;
    }
    /**
     * Add active request to counter
     */
    addActiveRequest() {
        let activeRequests = internalState$8.activeRequests;
        if (isVoid(activeRequests)) {
            activeRequests = 0;
        }
        activeRequests++;
        this.updateState({ ...internalState$8, activeRequests });
    }
    /**
     * Remove active request to counter
     */
    removeActiveRequest() {
        let activeRequests = internalState$8.activeRequests;
        if (isVoid(activeRequests)) {
            activeRequests = 0;
        }
        else {
            activeRequests--;
        }
        if (activeRequests < 0) {
            activeRequests = 0;
        }
        this.updateState({ ...internalState$8, activeRequests });
    }
    /**
     * Update loading status for given key
     *
     * @param {string} key to update
     * @param {boolean} loading status to set
     * @param {boolean} delay
     */
    updateLoading(key, loading, delay = true) {
        this.initLoadingBuffer();
        if (loading === true) {
            this.addToLoadingQueue(key);
            this.loadingBuffer.updateLoading(loading);
            if (!delay) {
                this.updateState({ ...internalState$8, loading });
            }
            return;
        }
        this.removeFromLoadingQueue(key);
        if (this.hasActiveLoading()) {
            this.loadingBuffer.updateLoading(loading);
            this.updateState({ ...internalState$8, loading });
        }
    }
    /**
     * Update loading status for given key
     *
     * @param {boolean} initialAppLoading status to set
     */
    updateInitialAppLoading(initialAppLoading) {
        this.updateState({ ...internalState$8, initialAppLoading });
    }
    /**
     * Has app been initially loaded
     *
     * @returns {boolean} is loaded
     */
    isLoaded() {
        return internalState$8.loaded;
    }
    /**
     * Set initial app load status
     *
     * @param {string} loaded flag
     */
    setLoaded(loaded) {
        this.updateState({ ...internalState$8, loaded });
    }
    /**
     * Set current module
     *
     * @param {string} module to set as current module
     */
    setModule(module) {
        this.updateState({ ...internalState$8, module });
    }
    /**
     * Get the current module
     *
     * @returns {string} current view
     */
    getModule() {
        return internalState$8?.module ?? '';
    }
    /**
     * Set current View
     *
     * @param {string} view to set as current view
     */
    setView(view) {
        this.updateState({ ...internalState$8, view });
    }
    /**
     * Get the current view
     *
     * @returns {string} current view
     */
    getView() {
        return internalState$8.view;
    }
    /**
     * Set route url
     *
     * @param {string} routeUrl to set
     */
    setRouteUrl(routeUrl) {
        this.updateState({ ...internalState$8, routeUrl });
    }
    /**
     * Get the route ulr
     *
     * @returns {string} current route url
     */
    getRouteUrl() {
        return internalState$8.routeUrl;
    }
    /**
     * set pre login url
     *
     * @param preLoginUrl
     */
    setPreLoginUrl(preLoginUrl) {
        this.updateState({ ...internalState$8, preLoginUrl });
    }
    /**
     * get pre login url
     *
     * @returns string
     */
    getPreLoginUrl() {
        return internalState$8.preLoginUrl ?? '';
    }
    /**
     * Internal API
     */
    /**
     * Init loading buffer
     * @protected
     */
    initLoadingBuffer() {
        if (!this.loadingBuffer) {
            this.loadingBuffer = this.loadingBufferFactory.create();
            this.subs.push(this.loadingBuffer.loading$.subscribe((loading) => {
                this.updateState({ ...internalState$8, loading });
            }));
        }
    }
    /**
     *  Check if there are still active loadings
     *
     *  @returns {boolean} active loading
     */
    hasActiveLoading() {
        return Object.keys(this.loadingQueue).length < 1;
    }
    /**
     * Remove key from loading queue
     *
     * @param {string} key to remove
     */
    removeFromLoadingQueue(key) {
        if (this.loadingQueue[key]) {
            delete this.loadingQueue[key];
        }
    }
    /**
     * Add key to loading queue
     *
     * @param {string} key to add
     */
    addToLoadingQueue(key) {
        this.loadingQueue[key] = true;
    }
    /**
     * Update the state
     *
     * @param {{}} state app state
     */
    updateState(state) {
        this.store.next(internalState$8 = state);
    }
    toggleSidebar() {
        this.updateState({ ...internalState$8, isSidebarVisible: !internalState$8.isSidebarVisible });
    }
    closeSidebar() {
        this.updateState({ ...internalState$8, isSidebarVisible: false });
    }
    getLatestPrevRoute() {
        return internalState$8.prevRoutes[internalState$8.prevRoutes.length - 2];
    }
    getPrevRoutes() {
        return internalState$8.prevRoutes;
    }
    addToPrevRoute(route) {
        const prevRoutes = this.getPrevRoutes();
        if (prevRoutes.length > 0 && prevRoutes[prevRoutes.length - 1] === route) {
            return;
        }
        prevRoutes.push(route);
        this.updateState({ ...internalState$8 });
    }
    removeLatestPrevRoute() {
        const prevRoutes = this.getPrevRoutes();
        const newArr = prevRoutes.slice(0, prevRoutes.length - 1);
        this.updateState({ ...internalState$8, prevRoutes: newArr });
    }
    removeAllPrevRoutes() {
        this.updateState({ ...internalState$8, prevRoutes: [] });
    }
    setActiveDropdown(key) {
        this.updateState({ ...internalState$8, activeNavbarDropdown: key });
    }
    getActiveDropdown() {
        return internalState$8.activeNavbarDropdown;
    }
    resetActiveDropdown() {
        this.updateState({ ...internalState$8, activeNavbarDropdown: 0 });
    }
    static { this.ɵfac = function AppStateStore_Factory(t) { return new (t || AppStateStore)(i0.ɵɵinject(LoadingBufferFactory), i0.ɵɵinject(SystemConfigStore)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: AppStateStore, factory: AppStateStore.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AppStateStore, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], function () { return [{ type: LoadingBufferFactory }, { type: SystemConfigStore }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
const initialState$k = {
    theme: null,
    images: {}
};
let internalState$7 = deepClone(initialState$k);
let cachedTheme = null;
let cache$$6 = null;
class ThemeImagesStore {
    constructor(recordGQL, appStateStore, iconRegistry) {
        this.recordGQL = recordGQL;
        this.appStateStore = appStateStore;
        this.iconRegistry = iconRegistry;
        this.store = new BehaviorSubject(internalState$7);
        this.state$ = this.store.asObservable();
        this.resourceName = 'themeImages';
        this.frontendName = 'theme-images';
        this.fieldsMetadata = {
            fields: [
                'id',
                '_id',
                'items'
            ]
        };
        this.images$ = this.state$.pipe(map(state => state.images), distinctUntilChanged());
    }
    /**
     * Public Api
     */
    /**
     * Clear state
     */
    clear() {
        cachedTheme = null;
        cache$$6 = null;
        this.updateState(deepClone(initialState$k));
    }
    clearAuthBased() {
    }
    /**
     * Change the current theme
     *
     * @param {string} theme to set
     */
    changeTheme(theme) {
        this.appStateStore.updateLoading('change-theme', true);
        this.load(theme).pipe(tap(() => this.appStateStore.updateLoading('change-theme', false))).subscribe();
    }
    /**
     * Returns the currently active image theme
     *
     * @returns {string} the theme
     */
    getTheme() {
        return internalState$7.theme;
    }
    /**
     * Initial ThemeImages load if not cached and update state.
     * Returns observable to be used in resolver if needed
     *
     * @param {string} theme to load
     * @returns {object} Observable<any>
     */
    load(theme) {
        return this.getThemeImages(theme).pipe(tap(images => {
            this.updateState({ ...internalState$7, images, theme });
        }));
    }
    /**
     * Check if loaded
     */
    isCached() {
        return cache$$6 !== null;
    }
    /**
     * Set pre-loaded theme images and cache
     */
    set(theme, images) {
        cachedTheme = theme;
        this.registerSvgs(images);
        cache$$6 = of(images).pipe(shareReplay(1));
        this.updateState({ ...internalState$7, images });
    }
    /**
     * Internal API
     */
    /**
     * Update the state
     *
     * @param {object} state to set
     */
    updateState(state) {
        this.store.next(internalState$7 = state);
    }
    /**
     * Get theme images cached Observable or call the backend
     *
     * @param {string} theme to retrieve
     * @returns {object} Observable<any>
     */
    getThemeImages(theme) {
        if (cachedTheme !== theme || cache$$6 === null) {
            cachedTheme = theme;
            cache$$6 = this.fetch(theme).pipe(shareReplay(1));
        }
        return cache$$6;
    }
    registerSvgs(images) {
        Object.keys(images).forEach(key => {
            const image = images[key];
            const content = image['content'] ?? '';
            const name = image['name'] ?? '';
            if (content === '' || name === '') {
                return;
            }
            this.iconRegistry.addSvg(name, content);
        });
    }
    /**
     * Fetch the theme images from the backend
     *
     * @param {string} theme to load
     * @returns {object} Observable<any>
     */
    fetch(theme) {
        return this.recordGQL
            .fetch(this.resourceName, `/api/${this.frontendName}/${theme}`, this.fieldsMetadata)
            .pipe(map(({ data }) => {
            let images = {};
            if (data && data.themeImages) {
                images = data.themeImages.items;
            }
            if (!emptyObject(images)) {
                const parsedImages = {};
                this.registerSvgs(images);
                Object.keys(images).forEach(key => {
                    const { content, ...image } = images[key] ?? {};
                    parsedImages[key] = image;
                });
                return parsedImages;
            }
            return images;
        }));
    }
    static { this.ɵfac = function ThemeImagesStore_Factory(t) { return new (t || ThemeImagesStore)(i0.ɵɵinject(EntityGQL), i0.ɵɵinject(AppStateStore), i0.ɵɵinject(i3.SvgIconRegistryService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ThemeImagesStore, factory: ThemeImagesStore.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ThemeImagesStore, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], function () { return [{ type: EntityGQL }, { type: AppStateStore }, { type: i3.SvgIconRegistryService }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function ImageComponent_ng_container_0_svg_icon_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "svg-icon", 3);
} if (rf & 2) {
    const img_r1 = i0.ɵɵnextContext().ngIf;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵclassMap(ctx_r2.wrapperClass);
    i0.ɵɵpropertyInterpolate("name", img_r1.name);
    i0.ɵɵproperty("svgClass", ctx_r2.klass || "")("title", ctx_r2.title || "");
} }
function ImageComponent_ng_container_0_img_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "img", 4);
} if (rf & 2) {
    const img_r1 = i0.ɵɵnextContext().ngIf;
    const ctx_r3 = i0.ɵɵnextContext();
    i0.ɵɵclassMap(ctx_r3.klass);
    i0.ɵɵpropertyInterpolate("src", img_r1.path, i0.ɵɵsanitizeUrl);
    i0.ɵɵproperty("title", ctx_r3.title || "");
} }
function ImageComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, ImageComponent_ng_container_0_svg_icon_1_Template, 1, 6, "svg-icon", 1);
    i0.ɵɵtemplate(2, ImageComponent_ng_container_0_img_2_Template, 1, 5, "img", 2);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const img_r1 = ctx.ngIf;
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", img_r1.type === "svg");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", img_r1.type !== "svg");
} }
class ImageComponent {
    constructor(themeImagesStore) {
        this.themeImagesStore = themeImagesStore;
        this.klass = '';
        this.title = '';
        this.wrapperClass = 'sicon';
        this.images$ = this.themeImagesStore.images$;
        this.imageSig = signal({});
        this.subs = [];
    }
    ngOnInit() {
        this.subs = [];
        this.subs.push(this.images$.pipe(filter(img => img !== null), map((images) => ({ images })), tap(data => this.getImage(data, this.image))).subscribe());
    }
    ngOnDestroy() {
        this.subs.forEach(sub => sub.unsubscribe());
        this.subs = [];
    }
    /**
     * Get image from current view model and log if not existent
     *
     * @param vm
     * @param image name
     * @returns ThemeImage
     */
    getImage(vm, image) {
        if (!vm || !vm.images || Object.keys(vm.images).length < 1) {
            return null;
        }
        this.imageSig.update(() => vm.images[image]);
        if (!this.imageSig()) {
            console.warn(`Image with name '${image}' not found`);
        }
    }
    static { this.ɵfac = function ImageComponent_Factory(t) { return new (t || ImageComponent)(i0.ɵɵdirectiveInject(ThemeImagesStore)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ImageComponent, selectors: [["scrm-image"]], inputs: { image: "image", klass: "klass", title: "title", wrapperClass: "wrapperClass" }, decls: 1, vars: 1, consts: [[4, "ngIf"], [3, "svgClass", "title", "class", "name", 4, "ngIf"], ["alt", "", 3, "src", "class", "title", 4, "ngIf"], [3, "svgClass", "title", "name"], ["alt", "", 3, "src", "title"]], template: function ImageComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, ImageComponent_ng_container_0_Template, 3, 2, "ng-container", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.imageSig());
        } }, dependencies: [i2.NgIf, i3.SvgIconComponent], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ImageComponent, [{
        type: Component,
        args: [{ selector: 'scrm-image', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<ng-container *ngIf=\"imageSig() as img\">\n\n    <svg-icon *ngIf=\"img.type === 'svg'\" [svgClass]=\"klass || ''\" [title]=\"title || ''\" class=\"{{wrapperClass}}\"\n              name=\"{{img.name}}\"></svg-icon>\n\n    <img *ngIf=\"img.type !=='svg'\" alt=\"\" src=\"{{img.path}}\" class=\"{{klass}}\" [title]=\"title || ''\">\n\n</ng-container>\n" }]
    }], function () { return [{ type: ThemeImagesStore }]; }, { image: [{
            type: Input
        }], klass: [{
            type: Input
        }], title: [{
            type: Input
        }], wrapperClass: [{
            type: Input
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function LabelComponent_ng_container_0_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtext(1);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", ctx_r2.language.getFieldLabel(ctx_r2.labelKey, ctx_r2.module), " ");
} }
function LabelComponent_ng_container_0_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtext(1);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r3 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", ctx_r3.language.getListLabel(ctx_r3.listKey, ctx_r3.labelKey), " ");
} }
function LabelComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, LabelComponent_ng_container_0_ng_container_1_Template, 2, 1, "ng-container", 0);
    i0.ɵɵtemplate(2, LabelComponent_ng_container_0_ng_container_2_Template, 2, 1, "ng-container", 0);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", !ctx_r0.listKey && ctx_r0.labelKey);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r0.listKey && ctx_r0.labelKey);
} }
class LabelComponent {
    constructor(language) {
        this.language = language;
        this.labelKey = '';
        this.module = null;
        this.listKey = null;
        this.languages$ = this.language.vm$;
    }
    static { this.ɵfac = function LabelComponent_Factory(t) { return new (t || LabelComponent)(i0.ɵɵdirectiveInject(LanguageStore)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: LabelComponent, selectors: [["scrm-label"]], inputs: { labelKey: "labelKey", module: "module", listKey: "listKey" }, decls: 2, vars: 3, consts: [[4, "ngIf"]], template: function LabelComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, LabelComponent_ng_container_0_Template, 3, 2, "ng-container", 0);
            i0.ɵɵpipe(1, "async");
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", i0.ɵɵpipeBind1(1, 1, ctx.languages$));
        } }, dependencies: [i2.NgIf, i2.AsyncPipe], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LabelComponent, [{
        type: Component,
        args: [{ selector: 'scrm-label', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<ng-container *ngIf=\"(languages$ | async) as languages\">\n    <ng-container *ngIf=\"!listKey && labelKey\">\n        {{language.getFieldLabel(labelKey, module)}}\n    </ng-container>\n    <ng-container *ngIf=\"listKey && labelKey\">\n        {{language.getListLabel(listKey, labelKey)}}\n    </ng-container>\n</ng-container>\n" }]
    }], function () { return [{ type: LanguageStore }]; }, { labelKey: [{
            type: Input
        }], module: [{
            type: Input
        }], listKey: [{
            type: Input
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function ButtonComponent_scrm_image_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 4);
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("image", ctx_r0.config.icon)("klass", ctx_r0.config.iconKlass || "")("title", ctx_r0.language.getFieldLabel(ctx_r0.config.titleKey || ""));
} }
function ButtonComponent_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtext(1);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate(ctx_r1.config.label || "");
} }
function ButtonComponent_scrm_label_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-label", 5);
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    let tmp_1_0;
    i0.ɵɵproperty("labelKey", ctx_r2.config.labelKey)("module", (tmp_1_0 = ctx_r2.config.labelModule) !== null && tmp_1_0 !== undefined ? tmp_1_0 : "");
} }
const _c0$N = ["*"];
class ButtonComponent {
    constructor(language) {
        this.language = language;
        this.clickBuffer = new Subject();
        this.clickBuffer$ = this.clickBuffer.asObservable();
        this.subs = [];
    }
    ngOnInit() {
        const isToDebounce = this.config?.debounceClick ?? null;
        this.clickCallBack = this.config?.onClick ?? null;
        const clickDebounceTime = this.getDebounceTime();
        if (isToDebounce && this.clickCallBack) {
            this.subs.push(this.clickBuffer$.pipe(debounceTime(clickDebounceTime)).subscribe(value => {
                const input = value ?? null;
                this.clickCallBack(input);
            }));
        }
    }
    ngOnDestroy() {
        this.subs.forEach(sub => sub.unsubscribe());
    }
    runClick(input) {
        const isToDebounce = this.config?.debounceClick ?? null;
        if (!this.clickCallBack) {
            return;
        }
        if (isToDebounce && this.clickCallBack) {
            this.clickBuffer.next(input ?? null);
            return;
        }
        this.clickCallBack(input ?? null);
    }
    /**
     * Get debounce time
     * @return number
     * @protected
     */
    getDebounceTime() {
        let clickDebounceTime = this.config?.clickDebounceTime ?? 625;
        if (!isFinite(clickDebounceTime)) {
            clickDebounceTime = 625;
        }
        return clickDebounceTime;
    }
    static { this.ɵfac = function ButtonComponent_Factory(t) { return new (t || ButtonComponent)(i0.ɵɵdirectiveInject(LanguageStore)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ButtonComponent, selectors: [["scrm-button"]], inputs: { config: "config" }, ngContentSelectors: _c0$N, decls: 5, vars: 6, consts: [["type", "button", 3, "ngClass", "disabled", "title", "click"], [3, "image", "klass", "title", 4, "ngIf"], [4, "ngIf"], [3, "labelKey", "module", 4, "ngIf"], [3, "image", "klass", "title"], [3, "labelKey", "module"]], template: function ButtonComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵprojectionDef();
            i0.ɵɵelementStart(0, "button", 0);
            i0.ɵɵlistener("click", function ButtonComponent_Template_button_click_0_listener($event) { return ctx.runClick($event); });
            i0.ɵɵtemplate(1, ButtonComponent_scrm_image_1_Template, 1, 3, "scrm-image", 1);
            i0.ɵɵtemplate(2, ButtonComponent_ng_container_2_Template, 2, 1, "ng-container", 2);
            i0.ɵɵtemplate(3, ButtonComponent_scrm_label_3_Template, 1, 2, "scrm-label", 3);
            i0.ɵɵprojection(4);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵproperty("ngClass", ctx.config.klass)("disabled", (ctx.config == null ? null : ctx.config.disabled) || "")("title", ctx.language.getFieldLabel(ctx.config.titleKey) || (ctx.config == null ? null : ctx.config.title) || "");
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.config.icon);
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", !ctx.config.labelKey);
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.config.labelKey);
        } }, dependencies: [i2.NgClass, i2.NgIf, ImageComponent, LabelComponent], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ButtonComponent, [{
        type: Component,
        args: [{ selector: 'scrm-button', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<button type=\"button\"\n        [ngClass]=\"config.klass\"\n        (click)=\"runClick($event)\"\n        [disabled]=\"config?.disabled || ''\"\n        [title]=\"(language.getFieldLabel(config.titleKey) || config?.title) || ''\">\n    <scrm-image *ngIf=\"config.icon\"\n                [image]=\"config.icon\"\n                [klass]=\"config.iconKlass || ''\"\n                [title]=\"language.getFieldLabel(config.titleKey || '')\"></scrm-image>\n    <ng-container *ngIf=\"!config.labelKey\">{{ config.label || '' }}</ng-container>\n    <scrm-label *ngIf=\"config.labelKey\" [labelKey]=\"config.labelKey\" [module]=\"config.labelModule ?? ''\"></scrm-label>\n    <ng-content></ng-content>\n</button>\n" }]
    }], function () { return [{ type: LanguageStore }]; }, { config: [{
            type: Input
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function DropdownSubmenuComponent_scrm_image_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 5);
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("image", ctx_r0.item.icon);
} }
function DropdownSubmenuComponent_div_5_li_2_scrm_image_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 5);
} if (rf & 2) {
    const subItem_r3 = i0.ɵɵnextContext().$implicit;
    i0.ɵɵproperty("image", subItem_r3.icon);
} }
function DropdownSubmenuComponent_div_5_li_2_Template(rf, ctx) { if (rf & 1) {
    const _r7 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "li", 9)(1, "a", 10);
    i0.ɵɵlistener("click", function DropdownSubmenuComponent_div_5_li_2_Template_a_click_1_listener() { const restoredCtx = i0.ɵɵrestoreView(_r7); const subItem_r3 = restoredCtx.$implicit; const ctx_r6 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r6.click(subItem_r3)); });
    i0.ɵɵtemplate(2, DropdownSubmenuComponent_div_5_li_2_scrm_image_2_Template, 1, 1, "scrm-image", 2);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const subItem_r3 = ctx.$implicit;
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngClass", subItem_r3 && subItem_r3.klass);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", subItem_r3.icon);
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", subItem_r3 && subItem_r3.label, " ");
} }
function DropdownSubmenuComponent_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 6)(1, "ul", 7);
    i0.ɵɵtemplate(2, DropdownSubmenuComponent_div_5_li_2_Template, 4, 3, "li", 8);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngbCollapse", ctx_r1.isCollapsed);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", ctx_r1.item.items);
} }
const _c0$M = ["*"];
class DropdownSubmenuComponent {
    constructor() {
        this.itemClicked = new EventEmitter();
        this.isCollapsed = true;
    }
    ngOnInit() {
    }
    click(item) {
        if (item && item.onClick) {
            item.onClick();
        }
        this.itemClicked.emit(true);
    }
    static { this.ɵfac = function DropdownSubmenuComponent_Factory(t) { return new (t || DropdownSubmenuComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: DropdownSubmenuComponent, selectors: [["scrm-dropdown-submenu"]], inputs: { item: "item" }, outputs: { itemClicked: "item-clicked" }, ngContentSelectors: _c0$M, decls: 8, vars: 3, consts: [[1, "dropdown-submenu-items-container"], [1, "dropdown-submenu-parent-button", "dropdown-item", "dropdown-toggle", 3, "click"], [3, "image", 4, "ngIf"], [3, "ngbCollapse", 4, "ngIf"], [1, "dropdown-submenu-extra"], [3, "image"], [3, "ngbCollapse"], [1, "dropdown-submenu", "pl-2", "mb-1"], ["class", "dropdown-submenu-item dropdown-item", 4, "ngFor", "ngForOf"], [1, "dropdown-submenu-item", "dropdown-item"], [1, "action-link", "dropdown-submenu-item-link", 3, "ngClass", "click"]], template: function DropdownSubmenuComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵprojectionDef();
            i0.ɵɵelementStart(0, "div")(1, "div", 0)(2, "a", 1);
            i0.ɵɵlistener("click", function DropdownSubmenuComponent_Template_a_click_2_listener() { return ctx.isCollapsed = !ctx.isCollapsed; });
            i0.ɵɵtemplate(3, DropdownSubmenuComponent_scrm_image_3_Template, 1, 1, "scrm-image", 2);
            i0.ɵɵtext(4);
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(5, DropdownSubmenuComponent_div_5_Template, 3, 2, "div", 3);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(6, "div", 4);
            i0.ɵɵprojection(7);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngIf", ctx.item && ctx.item.icon);
            i0.ɵɵadvance(1);
            i0.ɵɵtextInterpolate1(" ", ctx.item && ctx.item.label, " ");
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.item && ctx.item.items.length);
        } }, dependencies: [i2.NgClass, i2.NgForOf, i2.NgIf, ImageComponent, i3$1.NgbCollapse], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DropdownSubmenuComponent, [{
        type: Component,
        args: [{ selector: 'scrm-dropdown-submenu', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<div>\n    <div class=\"dropdown-submenu-items-container\">\n        <a (click)=\"isCollapsed = !isCollapsed\"\n           class=\"dropdown-submenu-parent-button dropdown-item dropdown-toggle\"\n        >\n            <scrm-image *ngIf=\"item && item.icon\" [image]=\"item.icon\"></scrm-image>\n            {{item && item.label}}\n        </a>\n        <div *ngIf=\"item && item.items.length\" [ngbCollapse]=\"isCollapsed\">\n            <ul class=\"dropdown-submenu pl-2 mb-1\">\n\n                <li *ngFor=\"let subItem of item.items\" class=\"dropdown-submenu-item dropdown-item\">\n\n                    <a class=\"action-link dropdown-submenu-item-link\"\n                       [ngClass]=\"subItem && subItem.klass\"\n                       (click)=\"click(subItem)\">\n                        <scrm-image *ngIf=\"subItem.icon\" [image]=\"subItem.icon\"></scrm-image>\n                        {{subItem && subItem.label}}\n                    </a>\n                </li>\n            </ul>\n        </div>\n    </div>\n    <div class=\"dropdown-submenu-extra\">\n        <ng-content></ng-content>\n    </div>\n</div>\n" }]
    }], function () { return []; }, { item: [{
            type: Input
        }], itemClicked: [{
            type: Output,
            args: ['item-clicked']
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2024 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class TruncatePipe {
    transform(value, limit) {
        return value.length <= limit
            ? value
            : value.slice(0, limit) + '...';
    }
    static { this.ɵfac = function TruncatePipe_Factory(t) { return new (t || TruncatePipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "truncate", type: TruncatePipe, pure: true, standalone: true }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TruncatePipe, [{
        type: Pipe,
        args: [{
                name: 'truncate',
                standalone: true
            }]
    }], null, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function DropdownButtonComponent_scrm_image_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 7);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("image", ctx_r1.config.icon)("klass", ctx_r1.config.iconKlass || "");
} }
function DropdownButtonComponent_ng_container_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtext(1);
    i0.ɵɵpipe(2, "truncate");
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", i0.ɵɵpipeBind2(2, 1, ctx_r2.config.label, ctx_r2.charSize.maxLength), " ");
} }
function DropdownButtonComponent_ng_container_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "scrm-label", 8);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r3 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("labelKey", ctx_r3.config.labelKey);
} }
function DropdownButtonComponent_ng_container_7_div_1_ng_container_3_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainer(0);
} }
const _c0$L = function (a0) { return { item: a0 }; };
function DropdownButtonComponent_ng_container_7_div_1_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, DropdownButtonComponent_ng_container_7_div_1_ng_container_3_ng_container_1_Template, 1, 0, "ng-container", 13);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const item_r13 = ctx.$implicit;
    i0.ɵɵnextContext(3);
    const _r6 = i0.ɵɵreference(10);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngTemplateOutlet", _r6)("ngTemplateOutletContext", i0.ɵɵpureFunction1(2, _c0$L, item_r13));
} }
function DropdownButtonComponent_ng_container_7_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 10)(1, "div", 11);
    i0.ɵɵelement(2, "scrm-label", 8);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(3, DropdownButtonComponent_ng_container_7_div_1_ng_container_3_Template, 2, 4, "ng-container", 12);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const section_r9 = ctx.$implicit;
    const isLast_r10 = ctx.last;
    const isFirst_r11 = ctx.first;
    let tmp_3_0;
    let tmp_4_0;
    i0.ɵɵclassProp("section-split", !isFirst_r11)("last-section", isLast_r10)("first-section", isFirst_r11);
    i0.ɵɵproperty("ngClass", (tmp_3_0 = section_r9.klass) !== null && tmp_3_0 !== undefined ? tmp_3_0 : "");
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("labelKey", (tmp_4_0 = (tmp_4_0 = section_r9.labelKey) !== null && tmp_4_0 !== undefined ? tmp_4_0 : section_r9.label) !== null && tmp_4_0 !== undefined ? tmp_4_0 : "");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngForOf", section_r9.items);
} }
function DropdownButtonComponent_ng_container_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, DropdownButtonComponent_ng_container_7_div_1_Template, 4, 9, "div", 9);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r4 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngForOf", ctx_r4.sections);
} }
function DropdownButtonComponent_ng_container_8_ng_container_1_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainer(0);
} }
function DropdownButtonComponent_ng_container_8_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, DropdownButtonComponent_ng_container_8_ng_container_1_ng_container_1_Template, 1, 0, "ng-container", 13);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const item_r17 = ctx.$implicit;
    i0.ɵɵnextContext(2);
    const _r6 = i0.ɵɵreference(10);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngTemplateOutlet", _r6)("ngTemplateOutletContext", i0.ɵɵpureFunction1(2, _c0$L, item_r17));
} }
function DropdownButtonComponent_ng_container_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, DropdownButtonComponent_ng_container_8_ng_container_1_Template, 2, 4, "ng-container", 12);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r5 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngForOf", ctx_r5.config.items);
} }
function DropdownButtonComponent_ng_template_9_ng_container_0_div_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵelement(1, "scrm-image", 7);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const item_r19 = i0.ɵɵnextContext(2).item;
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("image", item_r19.icon)("klass", item_r19.iconKlass || "");
} }
function DropdownButtonComponent_ng_template_9_ng_container_0_ng_container_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtext(1);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const item_r19 = i0.ɵɵnextContext(2).item;
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", item_r19.label, " ");
} }
function DropdownButtonComponent_ng_template_9_ng_container_0_ng_container_6_scrm_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-label", 18);
} if (rf & 2) {
    const item_r19 = i0.ɵɵnextContext(3).item;
    let tmp_1_0;
    i0.ɵɵproperty("labelKey", item_r19.labelKey)("module", (tmp_1_0 = item_r19.labelModule) !== null && tmp_1_0 !== undefined ? tmp_1_0 : "");
} }
function DropdownButtonComponent_ng_template_9_ng_container_0_ng_container_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, DropdownButtonComponent_ng_template_9_ng_container_0_ng_container_6_scrm_label_1_Template, 1, 2, "scrm-label", 17);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const item_r19 = i0.ɵɵnextContext(2).item;
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", item_r19 && item_r19.labelKey);
} }
function DropdownButtonComponent_ng_template_9_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    const _r32 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "a", 14);
    i0.ɵɵlistener("click", function DropdownButtonComponent_ng_template_9_ng_container_0_Template_a_click_1_listener() { i0.ɵɵrestoreView(_r32); const item_r19 = i0.ɵɵnextContext().item; const ctx_r30 = i0.ɵɵnextContext(); const _r0 = i0.ɵɵreference(1); return i0.ɵɵresetView(item_r19 && ctx_r30.click(item_r19.onClick, _r0)); });
    i0.ɵɵelementStart(2, "div", 15);
    i0.ɵɵtemplate(3, DropdownButtonComponent_ng_template_9_ng_container_0_div_3_Template, 2, 2, "div", 4);
    i0.ɵɵelementStart(4, "div", 16);
    i0.ɵɵtemplate(5, DropdownButtonComponent_ng_template_9_ng_container_0_ng_container_5_Template, 2, 1, "ng-container", 4);
    i0.ɵɵtemplate(6, DropdownButtonComponent_ng_template_9_ng_container_0_ng_container_6_Template, 2, 1, "ng-container", 4);
    i0.ɵɵelementEnd()()();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const item_r19 = i0.ɵɵnextContext().item;
    const ctx_r20 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngClass", item_r19 && item_r19.klass)("title", ctx_r20.language.getFieldLabel(item_r19 == null ? null : item_r19.titleKey) || (item_r19 == null ? null : item_r19.title) || "");
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", item_r19.icon);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", item_r19 && item_r19.label);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", item_r19 && !item_r19.label && item_r19.labelKey);
} }
function DropdownButtonComponent_ng_template_9_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    const _r35 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "scrm-dropdown-submenu", 19);
    i0.ɵɵlistener("item-clicked", function DropdownButtonComponent_ng_template_9_ng_container_1_Template_scrm_dropdown_submenu_item_clicked_1_listener() { i0.ɵɵrestoreView(_r35); const ctx_r34 = i0.ɵɵnextContext(2); const _r0 = i0.ɵɵreference(1); return i0.ɵɵresetView(ctx_r34.close(_r0)); });
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const item_r19 = i0.ɵɵnextContext().item;
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("item", item_r19);
} }
function DropdownButtonComponent_ng_template_9_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵtemplate(0, DropdownButtonComponent_ng_template_9_ng_container_0_Template, 7, 5, "ng-container", 4);
    i0.ɵɵtemplate(1, DropdownButtonComponent_ng_template_9_ng_container_1_Template, 2, 1, "ng-container", 4);
} if (rf & 2) {
    const item_r19 = ctx.item;
    const ctx_r7 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngIf", item_r19 && !ctx_r7.isDropdown(item_r19));
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", item_r19 && ctx_r7.isDropdown(item_r19));
} }
class DropdownButtonComponent {
    constructor(language, systemConfigStore) {
        this.language = language;
        this.systemConfigStore = systemConfigStore;
        this.disabled = false;
        this.autoClose = true;
        this.sections = [];
        this.sectionsEnabled = false;
        this.charSize = {
            minLength: 20,
            mediumLength: 20,
            maxLength: 20
        };
    }
    isDropdown(item) {
        if (!item) {
            return false;
        }
        return 'items' in item;
    }
    click(onClick, dropdown) {
        onClick();
        dropdown.close();
    }
    close(dropdown) {
        dropdown.close();
    }
    ngOnInit() {
        if (this.config && !this.config.placement) {
            this.config.placement = ['bottom-left', 'bottom-right', 'top-left', 'top-right'];
        }
        this.sections = [];
        const sectionsConfig = this.config?.sections ?? {};
        if (emptyObject(sectionsConfig)) {
            this.sectionsEnabled = false;
            return;
        }
        this.sectionsEnabled = true;
        this.preprocessItems(this.config?.items ?? []);
        const characterSizes = this.systemConfigStore.getUi('navbar_truncate_character_sizes');
        this.charSize = { ...characterSizes };
    }
    preprocessItems(items) {
        const sectionsConfig = this.config?.sections ?? {};
        const sections = {};
        if (!items || !items.length) {
            return;
        }
        items.forEach(item => {
            const sectionKey = item?.section ?? 'default';
            let section = this.getSection(sectionsConfig, sectionKey, sections);
            section.items.push(item);
        });
        Object.keys(sectionsConfig).forEach(sectionKey => {
            const section = sections[sectionKey];
            if (section && section.items && section.items.length) {
                this.sections.push(section);
            }
        });
    }
    /**
     * Get section from map, initialize if not on map
     * @param sectionsConfig
     * @param sectionKey
     * @param sections
     * @protected
     */
    getSection(sectionsConfig, sectionKey, sections) {
        const sectionConfig = sectionsConfig[sectionKey] ?? {};
        let section = sections[sectionKey] ?? null;
        if (section === null) {
            section = deepClone(sectionConfig);
            section.items = [];
            sections[sectionKey] = section;
        }
        return section;
    }
    getPlacement() {
        if (this.config && !this.config.placement) {
            return ['bottom-left', 'bottom-right', 'top-left', 'top-right'];
        }
        return this.config.placement;
    }
    static { this.ɵfac = function DropdownButtonComponent_Factory(t) { return new (t || DropdownButtonComponent)(i0.ɵɵdirectiveInject(LanguageStore), i0.ɵɵdirectiveInject(SystemConfigStore)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: DropdownButtonComponent, selectors: [["scrm-dropdown-button"]], inputs: { config: "config", disabled: "disabled", autoClose: "autoClose" }, decls: 11, vars: 13, consts: [["ngbDropdown", "", 1, "d-inline-block", "dropdown-button", 3, "autoClose", "placement", "ngClass"], ["dropDown", "ngbDropdown"], ["ngbDropdownToggle", "", 3, "disabled", "ngClass", "title"], [3, "image", "klass", 4, "ngIf"], [4, "ngIf"], ["ngbDropdownMenu", ""], ["buttonTemplate", ""], [3, "image", "klass"], [3, "labelKey"], [3, "ngClass", "section-split", "last-section", "first-section", 4, "ngFor", "ngForOf"], [3, "ngClass"], [1, "dropdown-menu-item-header"], [4, "ngFor", "ngForOf"], [4, "ngTemplateOutlet", "ngTemplateOutletContext"], ["ngbDropdownItem", "", 3, "ngClass", "title", "click"], [1, "d-flex", "align-items-center"], [1, "dropdown-item-label", "flex-grow-1"], [3, "labelKey", "module", 4, "ngIf"], [3, "labelKey", "module"], [3, "item", "item-clicked"]], template: function DropdownButtonComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0, 1)(2, "button", 2);
            i0.ɵɵtemplate(3, DropdownButtonComponent_scrm_image_3_Template, 1, 2, "scrm-image", 3);
            i0.ɵɵtemplate(4, DropdownButtonComponent_ng_container_4_Template, 3, 4, "ng-container", 4);
            i0.ɵɵtemplate(5, DropdownButtonComponent_ng_container_5_Template, 2, 1, "ng-container", 4);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(6, "div", 5);
            i0.ɵɵtemplate(7, DropdownButtonComponent_ng_container_7_Template, 2, 1, "ng-container", 4);
            i0.ɵɵtemplate(8, DropdownButtonComponent_ng_container_8_Template, 2, 1, "ng-container", 4);
            i0.ɵɵelementEnd()();
            i0.ɵɵtemplate(9, DropdownButtonComponent_ng_template_9_Template, 2, 2, "ng-template", null, 6, i0.ɵɵtemplateRefExtractor);
        } if (rf & 2) {
            i0.ɵɵclassProp("sectioned-dropdown-menu", ctx.sectionsEnabled);
            i0.ɵɵproperty("autoClose", ctx.autoClose)("placement", ctx.getPlacement())("ngClass", ctx.config.wrapperKlass);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("disabled", ctx.disabled)("ngClass", ctx.config.klass)("title", ctx.language.getFieldLabel(ctx.config.titleKey) || "");
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.config.icon);
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.config.label);
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", !ctx.config.label && ctx.config.labelKey);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngIf", ctx.sectionsEnabled);
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", !ctx.sectionsEnabled);
        } }, dependencies: [i2.NgClass, i2.NgForOf, i2.NgIf, i2.NgTemplateOutlet, i3$1.NgbDropdown, i3$1.NgbDropdownToggle, i3$1.NgbDropdownMenu, i3$1.NgbDropdownItem, ImageComponent, DropdownSubmenuComponent, LabelComponent, TruncatePipe], encapsulation: 2, changeDetection: 0 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DropdownButtonComponent, [{
        type: Component,
        args: [{ selector: 'scrm-dropdown-button', changeDetection: ChangeDetectionStrategy.OnPush, template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<div ngbDropdown\n     [autoClose]=\"autoClose\"\n     [placement]=\"getPlacement()\"\n     #dropDown=\"ngbDropdown\"\n     class=\"d-inline-block dropdown-button\"\n     [class.sectioned-dropdown-menu]=\"sectionsEnabled\"\n     [ngClass]=\"config.wrapperKlass\">\n    <button [disabled]=\"disabled\"\n            [ngClass]=\"config.klass\"\n            [title]=\"language.getFieldLabel(config.titleKey) || ''\"\n            ngbDropdownToggle>\n\n        <scrm-image *ngIf=\"config.icon\"\n                    [image]=\"config.icon\"\n                    [klass]=\"config.iconKlass || ''\"></scrm-image>\n\n        <ng-container *ngIf=\"config.label\">\n            {{ config.label | truncate: charSize.maxLength}}\n        </ng-container>\n\n        <ng-container *ngIf=\"!config.label && config.labelKey\">\n            <scrm-label [labelKey]=\"config.labelKey\"></scrm-label>\n        </ng-container>\n\n    </button>\n    <div ngbDropdownMenu>\n\n        <ng-container *ngIf=\"sectionsEnabled\">\n\n            <div *ngFor=\"let section of sections; last as isLast; first as isFirst\"\n                 [ngClass]=\"section.klass ?? ''\"\n                 [class.section-split]=\"!isFirst\"\n                 [class.last-section]=\"isLast\"\n                 [class.first-section]=\"isFirst\">\n                <div class=\"dropdown-menu-item-header\">\n                    <scrm-label [labelKey]=\"section.labelKey ?? section.label ?? ''\" ></scrm-label>\n                </div>\n\n                <ng-container *ngFor=\"let item of section.items; let last = last\">\n                    <ng-container *ngTemplateOutlet=\"buttonTemplate; context: { item: item }\"></ng-container>\n                </ng-container>\n\n            </div>\n\n        </ng-container>\n\n        <ng-container *ngIf=\"!sectionsEnabled\">\n            <ng-container *ngFor=\"let item of config.items\">\n                <ng-container *ngTemplateOutlet=\"buttonTemplate; context: { item: item }\"></ng-container>\n            </ng-container>\n        </ng-container>\n\n    </div>\n</div>\n\n\n<ng-template #buttonTemplate let-item=\"item\">\n\n    <ng-container *ngIf=\"item && !isDropdown(item)\">\n        <a ngbDropdownItem\n           [ngClass]=\"item && item.klass\"\n           [title]=\"(language.getFieldLabel(item?.titleKey) || item?.title) || ''\"\n           (click)=\"item && click(item.onClick, dropDown)\">\n            <div class=\"d-flex align-items-center\">\n                <div *ngIf=\"item.icon\">\n                    <scrm-image [image]=\"item.icon\" [klass]=\"item.iconKlass || ''\"></scrm-image>\n                </div>\n                <div class=\"dropdown-item-label flex-grow-1\">\n                    <ng-container *ngIf=\"item && item.label\">\n                        {{ item.label }}\n                    </ng-container>\n                    <ng-container *ngIf=\"item && !item.label && item.labelKey\">\n                        <scrm-label *ngIf=\"item && item.labelKey\" [labelKey]=\"item.labelKey\"\n                                    [module]=\"item.labelModule ?? ''\"></scrm-label>\n                    </ng-container>\n                </div>\n            </div>\n        </a>\n    </ng-container>\n\n    <ng-container *ngIf=\"item && isDropdown(item)\">\n        <scrm-dropdown-submenu (item-clicked)=\"close(dropDown)\" [item]=\"item\"></scrm-dropdown-submenu>\n    </ng-container>\n\n</ng-template>\n" }]
    }], function () { return [{ type: LanguageStore }, { type: SystemConfigStore }]; }, { config: [{
            type: Input
        }], disabled: [{
            type: Input
        }], autoClose: [{
            type: Input
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2023 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function GroupedButtonComponent_ng_container_1_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "scrm-button", 3);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const item_r2 = ctx.$implicit;
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("config", item_r2);
} }
function GroupedButtonComponent_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, GroupedButtonComponent_ng_container_1_ng_container_1_Template, 2, 1, "ng-container", 2);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngForOf", ctx_r0.config.items);
} }
class GroupedButtonComponent {
    static { this.ɵfac = function GroupedButtonComponent_Factory(t) { return new (t || GroupedButtonComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: GroupedButtonComponent, selectors: [["scrm-grouped-button"]], inputs: { config: "config" }, decls: 2, vars: 2, consts: [["role", "group", 1, "btn-group", "grouped-button", 3, "ngClass"], [4, "ngIf"], [4, "ngFor", "ngForOf"], [3, "config"]], template: function GroupedButtonComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵtemplate(1, GroupedButtonComponent_ng_container_1_Template, 2, 1, "ng-container", 1);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            let tmp_0_0;
            i0.ɵɵproperty("ngClass", (tmp_0_0 = ctx.config == null ? null : ctx.config.wrapperKlass) !== null && tmp_0_0 !== undefined ? tmp_0_0 : "");
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.config == null ? null : ctx.config.items);
        } }, dependencies: [i2.NgClass, i2.NgForOf, i2.NgIf, ButtonComponent], encapsulation: 2, changeDetection: 0 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GroupedButtonComponent, [{
        type: Component,
        args: [{ selector: 'scrm-grouped-button', changeDetection: ChangeDetectionStrategy.OnPush, template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2023 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n\n<div class=\"btn-group grouped-button\" role=\"group\" [ngClass]=\"config?.wrapperKlass ?? ''\">\n    <ng-container *ngIf=\"config?.items\">\n        <ng-container *ngFor=\"let item of config.items\">\n            <scrm-button [config]=\"item\"></scrm-button>\n        </ng-container>\n    </ng-container>\n</div>\n" }]
    }], null, { config: [{
            type: Input
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function ButtonGroupComponent_div_0_ng_container_1_scrm_button_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-button", 4);
} if (rf & 2) {
    const item_r3 = i0.ɵɵnextContext().$implicit;
    i0.ɵɵproperty("config", item_r3);
} }
function ButtonGroupComponent_div_0_ng_container_1_scrm_dropdown_button_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-dropdown-button", 4);
} if (rf & 2) {
    const item_r3 = i0.ɵɵnextContext().$implicit;
    i0.ɵɵproperty("config", item_r3);
} }
function ButtonGroupComponent_div_0_ng_container_1_scrm_grouped_button_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-grouped-button", 4);
} if (rf & 2) {
    const item_r3 = i0.ɵɵnextContext().$implicit;
    i0.ɵɵproperty("config", item_r3);
} }
function ButtonGroupComponent_div_0_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, ButtonGroupComponent_div_0_ng_container_1_scrm_button_1_Template, 1, 1, "scrm-button", 3);
    i0.ɵɵtemplate(2, ButtonGroupComponent_div_0_ng_container_1_scrm_dropdown_button_2_Template, 1, 1, "scrm-dropdown-button", 3);
    i0.ɵɵtemplate(3, ButtonGroupComponent_div_0_ng_container_1_scrm_grouped_button_3_Template, 1, 1, "scrm-grouped-button", 3);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const item_r3 = ctx.$implicit;
    let tmp_0_0;
    let tmp_1_0;
    let tmp_2_0;
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", item_r3 && !((tmp_0_0 = item_r3 == null ? null : item_r3.items) !== null && tmp_0_0 !== undefined ? tmp_0_0 : ""));
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", item_r3 && ((tmp_1_0 = item_r3 == null ? null : item_r3.items) !== null && tmp_1_0 !== undefined ? tmp_1_0 : "") && ((tmp_1_0 = item_r3 == null ? null : item_r3.type) !== null && tmp_1_0 !== undefined ? tmp_1_0 : "dropdown") === "dropdown");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", item_r3 && ((tmp_2_0 = item_r3 == null ? null : item_r3.items) !== null && tmp_2_0 !== undefined ? tmp_2_0 : "") && ((tmp_2_0 = item_r3 == null ? null : item_r3.type) !== null && tmp_2_0 !== undefined ? tmp_2_0 : "dropdown") === "grouped");
} }
function ButtonGroupComponent_div_0_scrm_dropdown_button_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-dropdown-button", 5);
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("config", ctx_r2.dropdownConfig);
} }
function ButtonGroupComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵtemplate(1, ButtonGroupComponent_div_0_ng_container_1_Template, 4, 3, "ng-container", 1);
    i0.ɵɵtemplate(2, ButtonGroupComponent_div_0_scrm_dropdown_button_2_Template, 1, 1, "scrm-dropdown-button", 2);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵclassMap(ctx_r0.klass);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngForOf", ctx_r0.buttons.expanded);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r0.buttons.collapsed.length);
} }
class ButtonGroupComponent {
    constructor() {
        this.klass = '';
        this.buttons = {
            expanded: [],
            collapsed: [],
        };
    }
    ngOnInit() {
        this.sub = this.config$.subscribe(config => {
            this.internalConfig = { ...config };
            this.splitButtons();
        });
    }
    ngOnDestroy() {
        this.sub.unsubscribe();
    }
    buildDropdownConfig() {
        let buttonClasses = ['button-group-button'];
        if (this.internalConfig.buttonKlass && this.internalConfig.buttonKlass.length > 0) {
            buttonClasses = buttonClasses.concat(this.internalConfig.buttonKlass);
        }
        if (this?.internalConfig?.dropdownOptions?.klass) {
            buttonClasses = buttonClasses.concat(this.internalConfig.dropdownOptions.klass);
        }
        let wrapperClasses = ['button-group-dropdown'];
        const dropdownOptions = this.internalConfig.dropdownOptions;
        const optionsWrapperKlass = dropdownOptions && dropdownOptions.wrapperKlass;
        if (optionsWrapperKlass && optionsWrapperKlass.length > 0) {
            wrapperClasses = wrapperClasses.concat(optionsWrapperKlass);
        }
        this.dropdownConfig = {
            label: this.internalConfig.dropdownLabel,
            klass: [...buttonClasses],
            wrapperKlass: wrapperClasses,
            items: this.buttons.collapsed,
        };
        if (this.internalConfig.dropdownOptions && this.internalConfig.dropdownOptions.placement) {
            this.dropdownConfig.placement = this.internalConfig.dropdownOptions.placement;
        }
        if (this.internalConfig.dropdownOptions && this.internalConfig.dropdownOptions.icon) {
            this.dropdownConfig.icon = this.internalConfig.dropdownOptions.icon;
        }
    }
    getBreakpoint() {
        if (!this.internalConfig.breakpoint && this.internalConfig.breakpoint !== 0) {
            return 4;
        }
        return this.internalConfig.breakpoint;
    }
    splitButtons() {
        this.buttons.expanded = [];
        this.buttons.collapsed = [];
        if (!this.internalConfig.buttons || this.internalConfig.buttons.length < 1) {
            return;
        }
        let count = 0;
        const showAfterBreakpoint = this.internalConfig.showAfterBreakpoint ?? true;
        this.internalConfig.buttons.forEach(button => {
            if (!button) {
                return;
            }
            if (count < this.getBreakpoint()) {
                let classes = ['button-group-button'];
                if (this.internalConfig.buttonKlass && this.internalConfig.buttonKlass.length > 0) {
                    classes = classes.concat(this.internalConfig.buttonKlass);
                }
                const newButton = { ...button };
                Button.appendClasses(newButton, [...classes]);
                this.buttons.expanded.push(newButton);
            }
            else if (showAfterBreakpoint === true) {
                this.buttons.collapsed.push({ ...button });
            }
            count++;
        });
        this.buildDropdownConfig();
    }
    static { this.ɵfac = function ButtonGroupComponent_Factory(t) { return new (t || ButtonGroupComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ButtonGroupComponent, selectors: [["scrm-button-group"]], inputs: { config$: "config$", klass: "klass" }, decls: 1, vars: 1, consts: [[3, "class", 4, "ngIf"], [4, "ngFor", "ngForOf"], ["autoClose", "outside", 3, "config", 4, "ngIf"], [3, "config", 4, "ngIf"], [3, "config"], ["autoClose", "outside", 3, "config"]], template: function ButtonGroupComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, ButtonGroupComponent_div_0_Template, 3, 4, "div", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.config$);
        } }, dependencies: [i2.NgForOf, i2.NgIf, ButtonComponent, DropdownButtonComponent, GroupedButtonComponent], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ButtonGroupComponent, [{
        type: Component,
        args: [{ selector: 'scrm-button-group', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<div *ngIf=\"config$\" [class]=\"klass\">\n    <ng-container *ngFor=\"let item of buttons.expanded\">\n        <scrm-button *ngIf=\"item && !(item?.items ?? '')\"\n                     [config]=\"item\">\n        </scrm-button>\n        <scrm-dropdown-button *ngIf=\"item && (item?.items ?? '') && ((item?.type ?? 'dropdown') === 'dropdown')\"\n                              [config]=\"item\">\n        </scrm-dropdown-button>\n        <scrm-grouped-button *ngIf=\"item && (item?.items ?? '') && ((item?.type ?? 'dropdown') === 'grouped')\"\n                              [config]=\"item\">\n        </scrm-grouped-button>\n    </ng-container>\n\n    <scrm-dropdown-button autoClose=\"outside\"\n                          *ngIf=\"buttons.collapsed.length\"\n                          [config]=\"dropdownConfig\"></scrm-dropdown-button>\n</div>\n" }]
    }], function () { return []; }, { config$: [{
            type: Input
        }], klass: [{
            type: Input
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
const initialState$j = {
    userPreferences: {},
    loading: false
};
let internalState$6 = deepClone(initialState$j);
let cache$$5 = null;
class UserPreferenceStore {
    constructor(collectionGQL, config, processService, localStorage) {
        this.collectionGQL = collectionGQL;
        this.config = config;
        this.processService = processService;
        this.localStorage = localStorage;
        this.store = new BehaviorSubject(internalState$6);
        this.state$ = this.store.asObservable();
        this.saveBufferStore = new BehaviorSubject(false);
        this.subs = [];
        this.resourceName = 'userPreferences';
        this.fieldsMetadata = {
            fields: [
                'id',
                '_id',
                'value',
                'items'
            ]
        };
        /**
         * Public long-lived observable streams
         */
        this.userPreferences$ = this.state$.pipe(map(state => state.userPreferences), distinctUntilChanged());
        this.loading$ = this.state$.pipe(map(state => state.loading));
        const uiSettings = config.getConfigValue('ui') ?? {};
        const delay = uiSettings.user_preferences_save_delay ?? 5000;
        this.saveBuffer$ = this.saveBufferStore.asObservable().pipe(debounceTime(delay ?? 5000));
        this.subs.push(this.saveBuffer$.subscribe((value) => {
            if (!value) {
                return;
            }
            this.saveUiPreferences();
        }));
    }
    /**
     * Public Api
     */
    /**
     * Clear state
     */
    clear() {
        cache$$5 = null;
        this.updateState(deepClone(initialState$j));
        this.subs.forEach(sub => sub.unsubscribe());
    }
    clearAuthBased() {
        this.clear();
    }
    /**
     * Get user preferences value by key
     *
     * @param {string} key to retrieve
     * @returns any users preference
     */
    getUserPreference(key) {
        if (!internalState$6.userPreferences || !internalState$6.userPreferences[key]) {
            return null;
        }
        return internalState$6.userPreferences[key];
    }
    /**
     * Get ui user preferences value by key
     *
     * @param module
     * @param {string} key to retrieve
     * @returns any users preference
     */
    getUi(module, key) {
        const storageKey = module + '-' + key;
        const value = this.storageLoad(module, storageKey);
        if (value != null) {
            return value;
        }
        const ui = internalState$6?.userPreferences?.ui ?? {};
        return ui[storageKey] ?? null;
    }
    /**
     * Set user preferences value by key
     *
     * @param {string} module name
     * @param {string} key to retrieve
     * @param value
     * @returns any users preference
     */
    setUi(module, key, value) {
        const storageKey = module + '-' + key;
        this.storageSave(module, storageKey, value);
        const ui = internalState$6?.userPreferences?.ui ?? {};
        ui[storageKey] = value;
        internalState$6.userPreferences.ui = ui;
        this.saveBufferStore.next(true);
    }
    saveUiPreferences() {
        const processType = 'save-ui-user-preferences';
        const options = {
            preferences: internalState$6.userPreferences.ui
        };
        this.processService.submit(processType, options).pipe(take(1)).subscribe();
    }
    /**
     * Store the data in local storage
     *
     * @param {string} module to store in
     * @param {string} storageKey to store in
     * @param {} data to store
     */
    storageSave(module, storageKey, data) {
        let storage = this.localStorage.get(storageKey);
        if (!storage) {
            storage = {};
        }
        storage[module] = data;
        this.localStorage.set(storageKey, storage);
    }
    /**
     * Store the key in local storage
     *
     * @param {string} module to load from
     * @param {string} storageKey from load from
     */
    storageLoad(module, storageKey) {
        const storage = this.localStorage.get(storageKey);
        if (!storage || !storage[module]) {
            return null;
        }
        return storage[module];
    }
    /**
     * Initial UserPreferences load if not cached and update state.
     * Returns observable to be used in resolver if needed
     *
     * @returns {object} Observable<any>
     */
    load() {
        this.updateState({ ...internalState$6, loading: true });
        return this.getUserPreferences().pipe(tap(userPreferences => {
            this.updateState({ ...internalState$6, userPreferences, loading: false });
        }));
    }
    /**
     * Check if loaded
     */
    isCached() {
        return cache$$5 !== null;
    }
    /**
     * Set pre-loaded preferences and cache
     */
    set(userPreferences) {
        cache$$5 = of(userPreferences).pipe(shareReplay(1));
        this.updateState({ ...internalState$6, userPreferences, loading: false });
    }
    /**
     * Internal API
     */
    /**
     * Update the state
     *
     * @param {object} state to set
     */
    updateState(state) {
        this.store.next(internalState$6 = state);
    }
    /**
     * Get UserPreferences cached Observable or call the backend
     *
     * @returns {object} Observable<any>
     */
    getUserPreferences() {
        if (cache$$5 == null) {
            cache$$5 = this.fetch().pipe(shareReplay(1));
        }
        return cache$$5;
    }
    /**
     * Fetch the User Preferences from the backend
     *
     * @returns {object} Observable<any>
     */
    fetch() {
        return this.collectionGQL
            .fetchAll(this.resourceName, this.fieldsMetadata).pipe(map(({ data }) => {
            const userPreferences = {};
            if (data.userPreferences && data.userPreferences.edges) {
                data.userPreferences.edges.forEach((edge) => {
                    if (!edge.node.items) {
                        return;
                    }
                    Object.keys(edge.node.items).forEach(key => {
                        userPreferences[key] = edge.node.items[key];
                    });
                });
            }
            return userPreferences;
        }));
    }
    static { this.ɵfac = function UserPreferenceStore_Factory(t) { return new (t || UserPreferenceStore)(i0.ɵɵinject(CollectionGQL), i0.ɵɵinject(SystemConfigStore), i0.ɵɵinject(ProcessService), i0.ɵɵinject(LocalStorageService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: UserPreferenceStore, factory: UserPreferenceStore.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(UserPreferenceStore, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], function () { return [{ type: CollectionGQL }, { type: SystemConfigStore }, { type: ProcessService }, { type: LocalStorageService }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class FormControlUtils {
    getTrimmedInputValue(inputValue) {
        // Handle the cases, when input values are not string e.g. multienums: String[]
        // Process the input, only when it's a string else return as it is
        if (typeof inputValue !== 'string') {
            return inputValue;
        }
        return inputValue.trim();
    }
    isEmptyInputValue(inputValue) {
        // Handle the cases, when input value is an string, array, objects or any other type
        return inputValue == null
            || typeof inputValue === 'undefined'
            || inputValue === ''
            || inputValue.length === 0;
    }
    isEmptyTrimmedInputValue(inputValue) {
        return this.isEmptyInputValue(this.getTrimmedInputValue(inputValue));
    }
    isEmptyBooleanInputValue(inputValue) {
        return this.isEmptyInputValue(inputValue) || inputValue === 'false' || inputValue === false || inputValue === '';
    }
    static { this.ɵfac = function FormControlUtils_Factory(t) { return new (t || FormControlUtils)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: FormControlUtils, factory: FormControlUtils.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FormControlUtils, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class NumberFormatter {
    constructor(preferences, formUtils, locale) {
        this.preferences = preferences;
        this.formUtils = formUtils;
        this.locale = locale;
    }
    toUserFormat(value, options) {
        if (isVoid(value) || value === '') {
            return '';
        }
        if (isFalse(options?.metadata?.format ?? true)) {
            return value;
        }
        const formatted = formatNumber(Number(value), this.locale);
        return this.replaceSeparators(formatted);
    }
    toInternalFormat(value) {
        if (!value) {
            return value;
        }
        const decimalSymbol = this.getDecimalsSymbol() || '.';
        const groupSymbol = this.getGroupSymbol() || ',';
        let decimalSymbolRegex = new RegExp(decimalSymbol, 'g');
        if (decimalSymbol === '.') {
            decimalSymbolRegex = new RegExp('\\.', 'g');
        }
        let groupSymbolRegex = new RegExp(groupSymbol, 'g');
        if (groupSymbol === '.') {
            groupSymbolRegex = new RegExp('\\.', 'g');
        }
        value = value.replace(groupSymbolRegex, 'group_separator');
        value = value.replace(decimalSymbolRegex, 'decimal_separator');
        value = value.replace(/decimal_separator/g, '.');
        value = value.replace(/group_separator/g, '');
        return value;
    }
    getFloatUserFormatPattern() {
        const group = this.getGroupSymbol();
        const decimals = this.getDecimalsSymbol();
        let pattern = '^-?(';
        pattern += '(\\d{1,3}(\\' + group + '\\d{3})*(\\' + decimals + '\\d+)?)|';
        pattern += '\\d*|';
        pattern += '(\\d+(\\' + decimals + '\\d+)?)|';
        pattern += '(\\d+(\\.\\d+)?)';
        pattern += ')$';
        return pattern;
    }
    getIntUserFormatPattern() {
        const group = this.getGroupSymbol();
        let pattern = '^-?(';
        pattern += '(\\d{1,3}(\\' + group + '\\d{3})*)|';
        pattern += '\\d*';
        pattern += ')$';
        return pattern;
    }
    getGroupSymbol() {
        const separator = this.preferences.getUserPreference('num_grp_sep');
        if (separator) {
            return separator;
        }
        return ',';
    }
    getDecimalsSymbol() {
        const separator = this.preferences.getUserPreference('dec_sep');
        if (separator) {
            return separator;
        }
        return '.';
    }
    replaceSeparators(transformed) {
        if (!transformed) {
            return transformed;
        }
        transformed = transformed.replace(/,/g, 'group_separator');
        transformed = transformed.replace(/\./g, 'decimal_separator');
        const decimalSymbol = this.getDecimalsSymbol() || '.';
        const groupSymbol = this.getGroupSymbol() || ',';
        transformed = transformed.replace(/decimal_separator/g, decimalSymbol);
        transformed = transformed.replace(/group_separator/g, groupSymbol);
        return transformed;
    }
    validateIntUserFormat(inputValue) {
        const trimmedInputValue = this.formUtils.getTrimmedInputValue(inputValue);
        if (this.formUtils.isEmptyInputValue(trimmedInputValue)) {
            return false;
        }
        const regex = new RegExp(this.getIntUserFormatPattern());
        return !regex.test(trimmedInputValue);
    }
    validateFloatUserFormat(inputValue) {
        const trimmedInputValue = this.formUtils.getTrimmedInputValue(inputValue);
        if (this.formUtils.isEmptyInputValue(trimmedInputValue)) {
            return false;
        }
        const regex = new RegExp(this.getFloatUserFormatPattern());
        return !regex.test(trimmedInputValue);
    }
    static { this.ɵfac = function NumberFormatter_Factory(t) { return new (t || NumberFormatter)(i0.ɵɵinject(UserPreferenceStore), i0.ɵɵinject(FormControlUtils), i0.ɵɵinject(LOCALE_ID)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: NumberFormatter, factory: NumberFormatter.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(NumberFormatter, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: UserPreferenceStore }, { type: FormControlUtils }, { type: undefined, decorators: [{
                type: Inject,
                args: [LOCALE_ID]
            }] }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DatetimeFormatter {
    constructor(preferences, formUtils, locale) {
        this.preferences = preferences;
        this.formUtils = formUtils;
        this.locale = locale;
        this.format$ = this.preferences.userPreferences$.pipe(map(() => {
            const date = this.getDateFormat();
            const time = this.getTimeFormat();
            return { date, time };
        }));
    }
    getDateFormat() {
        const dateFormatPreference = this.preferences.getUserPreference('date_format');
        if (dateFormatPreference) {
            return dateFormatPreference;
        }
        return this.getInternalDateFormat();
    }
    getTimeFormat() {
        const timeFormatPreference = this.preferences.getUserPreference('time_format');
        if (timeFormatPreference) {
            let format = timeFormatPreference;
            if (format.includes('aaaaaa')) {
                format = format.replace('aaaaaa', 'aaaaa\'m\'');
            }
            return format;
        }
        return this.getInternalTimeFormat();
    }
    getDateTimeFormat() {
        const dateFormat = this.getDateFormat();
        const timeFormat = this.getTimeFormat();
        return dateFormat + ' ' + timeFormat;
    }
    getInternalDateFormat() {
        return 'yyyy-MM-dd';
    }
    getInternalTimeFormat() {
        return 'HH:mm:ss';
    }
    getInternalDateTimeFormat() {
        const dateFormat = this.getInternalDateFormat();
        const timeFormat = this.getInternalTimeFormat();
        return dateFormat + ' ' + timeFormat;
    }
    getInternalFormat() {
        return this.getInternalDateTimeFormat();
    }
    getUserFormat() {
        return this.getDateTimeFormat();
    }
    /**
     * Format Internal Date to User. It assumes internal date is in GMT/UTC
     *
     * @param dateString
     * @param options
     */
    toUserFormat(dateString, options) {
        const fromFormat = (options && options.fromFormat) || this.getInternalFormat();
        const toFormat = (options && options.toFormat) || this.getUserFormat();
        if (dateString) {
            const dateTime = this.toDateTime(dateString, fromFormat, {
                zone: 'GMT'
            });
            if (!dateTime.isValid) {
                return dateString;
            }
            return formatDate(dateTime.toJSDate(), toFormat, this.locale, this.userTimeZone());
        }
        return '';
    }
    /**
     * Format User Date to Internal format. It assumes the date is in the user timezone
     *
     * @param dateString
     * @param options
     */
    toInternalFormat(dateString, options) {
        const fromFormat = (options && options.fromFormat) || this.getUserFormat();
        if (dateString) {
            let date = this.toDateTime(dateString, fromFormat, {
                zone: this.preferences.getUserPreference('timezone')
            });
            return formatDate(date.toJSDate(), this.getInternalFormat(), this.locale, 'GMT');
        }
        return '';
    }
    formatDateTime(dateString, format, fromFormat = '', locale = this.locale, timezone = '') {
        const dateTime = this.toDateTime(dateString, fromFormat);
        if (!dateTime.isValid) {
            return dateString;
        }
        return formatDate(dateTime.toJSDate(), format, locale, timezone);
    }
    toDateTime(datetimeString, fromFormat = '', options) {
        if (!datetimeString) {
            return DateTime.invalid('empty');
        }
        if (fromFormat) {
            return DateTime.fromFormat(datetimeString, fromFormat, options);
        }
        let dateTime = this.fromUserFormat(datetimeString, options);
        if (!dateTime.isValid) {
            dateTime = this.fromInternalFormat(datetimeString, options);
        }
        return dateTime;
    }
    userDateTimeFormatToStruct(datetime) {
        if (!datetime) {
            return null;
        }
        const dateTime = this.toDateTime(datetime, '', {
            zone: this.preferences.getUserPreference('timezone')
        });
        if (!dateTime.isValid) {
            return null;
        }
        return {
            date: {
                day: dateTime.day,
                month: dateTime.month,
                year: dateTime.year
            },
            time: {
                hour: dateTime.hour,
                minute: dateTime.minute,
                second: dateTime.second,
            }
        };
    }
    internalDateTimeFormatToStruct(datetime) {
        if (!datetime) {
            return null;
        }
        const dateTime = this.toDateTime(datetime, this.getInternalDateTimeFormat(), {
            zone: 'GMT'
        });
        const rezoned = dateTime.setZone(this.preferences.getUserPreference('timezone'));
        if (!dateTime.isValid) {
            return null;
        }
        return {
            date: {
                day: rezoned.day,
                month: rezoned.month,
                year: rezoned.year
            },
            time: {
                hour: rezoned.hour,
                minute: rezoned.minute,
                second: rezoned.second,
            }
        };
    }
    userDateFormatToStruct(datetime) {
        if (!datetime) {
            return null;
        }
        const dateTime = this.toDateTime(datetime, '', {
            zone: this.preferences.getUserPreference('timezone')
        });
        if (!dateTime.isValid) {
            return null;
        }
        return {
            day: dateTime.day,
            month: dateTime.month,
            year: dateTime.year
        };
    }
    dateFormatToStruct(datetime, fromFormat = '') {
        if (!datetime) {
            return null;
        }
        const dateTime = this.toDateTime(datetime, fromFormat);
        if (!dateTime.isValid) {
            return null;
        }
        return {
            day: dateTime.day,
            month: dateTime.month,
            year: dateTime.year
        };
    }
    userTimeFormatToStruct(datetime) {
        if (!datetime) {
            return null;
        }
        const dateTime = this.toDateTime(datetime, '', {
            zone: this.preferences.getUserPreference('timezone')
        });
        if (!dateTime.isValid) {
            return null;
        }
        return {
            hour: dateTime.hour,
            minute: dateTime.minute,
            second: dateTime.second
        };
    }
    fromUserFormat(datetime, options, formatOptions) {
        // ensure datetime is in user format.
        datetime = this.toUserFormat(datetime, formatOptions);
        datetime = datetime.toString();
        datetime = datetime.replace('a', 'A');
        datetime = datetime.replace('p', 'P');
        datetime = datetime.replace('m', 'M');
        let format = this.getUserFormat();
        format = format.replace('aaaaa\'m\'', 'a');
        return DateTime.fromFormat(datetime, format, options);
    }
    fromInternalFormat(datetime, options) {
        const format = this.getInternalFormat();
        return DateTime.fromFormat(datetime.toString(), format, options);
    }
    validateUserFormat(inputValue, userFormat = '') {
        const trimmedInputValue = this.formUtils.getTrimmedInputValue(inputValue);
        if (this.formUtils.isEmptyInputValue(trimmedInputValue)) {
            return false;
        }
        const dateTime = this.fromUserFormat(trimmedInputValue, {}, { fromFormat: userFormat });
        return !dateTime.isValid;
    }
    userTimeZone() {
        let userTZ = this.preferences.getUserPreference('timezone') ?? 'GMT';
        if (!userTZ) {
            userTZ = 'GMT';
        }
        const milliseconds = DateTime.now().setZone(userTZ).toMillis();
        return IANAZone.create(userTZ).formatOffset(milliseconds, 'techie');
    }
    static { this.ɵfac = function DatetimeFormatter_Factory(t) { return new (t || DatetimeFormatter)(i0.ɵɵinject(UserPreferenceStore), i0.ɵɵinject(FormControlUtils), i0.ɵɵinject(LOCALE_ID)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: DatetimeFormatter, factory: DatetimeFormatter.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DatetimeFormatter, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: UserPreferenceStore }, { type: FormControlUtils }, { type: undefined, decorators: [{
                type: Inject,
                args: [LOCALE_ID]
            }] }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class CurrencyFormatter {
    constructor(preferences, numberFormatter, locale) {
        this.preferences = preferences;
        this.numberFormatter = numberFormatter;
        this.locale = locale;
    }
    toUserFormat(value, options = null) {
        if (isVoid(value) || value === '') {
            return '';
        }
        const symbol = (options && options.symbol) || this.getSymbol();
        const code = (options && options.code) || this.getCode();
        let digits = null;
        if (options && options.digits !== null && isFinite(options.digits)) {
            digits = options.digits;
        }
        const digitsInfo = this.getDigitsInfo(digits);
        let formatted;
        if (options && options.mode === 'edit') {
            formatted = formatNumber(Number(value), this.locale, digitsInfo);
            return this.replaceSeparators(formatted);
        }
        formatted = formatCurrency(Number(value), this.locale, symbol, code, digitsInfo);
        return this.replaceSeparators(formatted);
    }
    toInternalFormat(value) {
        if (!value) {
            return '';
        }
        const transformed = value.replace(this.getSymbol(), '');
        return this.numberFormatter.toInternalFormat(transformed);
    }
    getCurrencyFormat() {
        const currencyFormat = this.preferences.getUserPreference('currency');
        if (currencyFormat) {
            return currencyFormat;
        }
        return this.getDefaultFormat();
    }
    getDefaultFormat() {
        return {
            iso4217: 'USD',
            name: 'US Dollars',
            symbol: '$'
        };
    }
    getCode() {
        return this.getCurrencyFormat().iso4217;
    }
    getSymbol() {
        return this.getCurrencyFormat().symbol;
    }
    getDigits() {
        const digits = this.preferences.getUserPreference('default_currency_significant_digits');
        if (digits) {
            return digits;
        }
        return 2;
    }
    getDigitsInfo(definedDigits) {
        let digitInfo = '1.2-2';
        let digits = this.getDigits();
        if (definedDigits !== null && isFinite(definedDigits)) {
            digits = definedDigits;
        }
        if (digits !== null && isFinite(digits)) {
            if (digits < 1) {
                digitInfo = '1.0-0';
            }
            else {
                digitInfo = `1.${digits}-${digits}`;
            }
        }
        return digitInfo;
    }
    replaceSeparators(transformed) {
        return this.numberFormatter.replaceSeparators(transformed);
    }
    static { this.ɵfac = function CurrencyFormatter_Factory(t) { return new (t || CurrencyFormatter)(i0.ɵɵinject(UserPreferenceStore), i0.ɵɵinject(NumberFormatter), i0.ɵɵinject(LOCALE_ID)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: CurrencyFormatter, factory: CurrencyFormatter.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CurrencyFormatter, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: UserPreferenceStore }, { type: NumberFormatter }, { type: undefined, decorators: [{
                type: Inject,
                args: [LOCALE_ID]
            }] }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DateFormatter extends DatetimeFormatter {
    getInternalFormat() {
        return this.getInternalDateFormat();
    }
    getUserFormat() {
        return this.getDateFormat();
    }
    /**
     * Format User Date to Internal format. It assumes the date is always in GMT
     *
     * @param dateString
     * @param options
     */
    toInternalFormat(dateString, options) {
        const fromFormat = (options && options.fromFormat) || this.getUserFormat();
        if (dateString) {
            let date = this.toDateTime(dateString, fromFormat);
            if (!date || !date.isValid) {
                date = this.toDateTime(dateString);
            }
            return formatDate(date.toJSDate(), this.getInternalFormat(), this.locale);
        }
        return '';
    }
    /**
     * Format Internal Date to User. It assumes internal date is in GMT/UTC
     *
     * @param dateString
     * @param options
     */
    toUserFormat(dateString, options) {
        const fromFormat = (options && options.fromFormat) || this.getInternalFormat();
        const toFormat = (options && options.toFormat) || this.getUserFormat();
        if (dateString) {
            const dateTime = this.toDateTime(dateString, fromFormat);
            if (!dateTime.isValid) {
                return dateString;
            }
            return formatDate(dateTime.toJSDate(), toFormat, this.locale);
        }
        return '';
    }
    static { this.ɵfac = /*@__PURE__*/ function () { let ɵDateFormatter_BaseFactory; return function DateFormatter_Factory(t) { return (ɵDateFormatter_BaseFactory || (ɵDateFormatter_BaseFactory = i0.ɵɵgetInheritedFactory(DateFormatter)))(t || DateFormatter); }; }(); }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: DateFormatter, factory: DateFormatter.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateFormatter, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class PhoneFormatter {
    constructor(formUtils, systemConfigStore) {
        this.formUtils = formUtils;
        this.systemConfigStore = systemConfigStore;
    }
    toUserFormat(value) {
        return value;
    }
    toInternalFormat(value) {
        return value;
    }
    getDefaultFormatPattern() {
        const validations = this.systemConfigStore.getUi('validations');
        const defaultRegex = validations?.regex?.phone || '';
        return defaultRegex;
    }
    validateUserFormat(inputValue, regexPattern) {
        const trimmedInputValue = this.formUtils.getTrimmedInputValue(inputValue);
        if (this.formUtils.isEmptyInputValue(trimmedInputValue)) {
            return false;
        }
        const regex = new RegExp(regexPattern);
        return !regex.test(trimmedInputValue);
    }
    static { this.ɵfac = function PhoneFormatter_Factory(t) { return new (t || PhoneFormatter)(i0.ɵɵinject(FormControlUtils), i0.ɵɵinject(SystemConfigStore)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: PhoneFormatter, factory: PhoneFormatter.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PhoneFormatter, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: FormControlUtils }, { type: SystemConfigStore }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DataTypeFormatter {
    constructor(currencyFormatter, numberFormatter, dateFormatter, datetimeFormatter, phoneFormatter) {
        this.currencyFormatter = currencyFormatter;
        this.numberFormatter = numberFormatter;
        this.dateFormatter = dateFormatter;
        this.datetimeFormatter = datetimeFormatter;
        this.phoneFormatter = phoneFormatter;
        this.map = {};
        this.map.int = numberFormatter;
        this.map.float = numberFormatter;
        this.map.date = dateFormatter;
        this.map.datetime = datetimeFormatter;
        this.map.currency = currencyFormatter;
        this.map.phone = phoneFormatter;
    }
    toUserFormat(dataType, value, options) {
        if (!dataType) {
            return value;
        }
        const formatter = this.map[dataType];
        if (!formatter) {
            return value;
        }
        return formatter.toUserFormat(value, options);
    }
    toInternalFormat(dataType, value) {
        if (!dataType) {
            return value;
        }
        const formatter = this.map[dataType];
        if (!formatter) {
            return value;
        }
        return formatter.toInternalFormat(value);
    }
    static { this.ɵfac = function DataTypeFormatter_Factory(t) { return new (t || DataTypeFormatter)(i0.ɵɵinject(CurrencyFormatter), i0.ɵɵinject(NumberFormatter), i0.ɵɵinject(DateFormatter), i0.ɵɵinject(DatetimeFormatter), i0.ɵɵinject(PhoneFormatter)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: DataTypeFormatter, factory: DataTypeFormatter.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DataTypeFormatter, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: CurrencyFormatter }, { type: NumberFormatter }, { type: DateFormatter }, { type: DatetimeFormatter }, { type: PhoneFormatter }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DynamicLabelService {
    constructor(typeFormatter, language, configs, preferences) {
        this.typeFormatter = typeFormatter;
        this.language = language;
        this.configs = configs;
        this.preferences = preferences;
        this.valuePipes = {};
        this.fieldPipes = {};
        this.valuePipes.int = (value) => this.valueTypeFormat('int', value);
        this.valuePipes.float = (value) => this.valueTypeFormat('float', value);
        this.valuePipes.date = (value) => this.valueTypeFormat('date', value);
        this.valuePipes.datetime = (value) => this.valueTypeFormat('datetime', value);
        this.valuePipes.currency = (value) => this.valueTypeFormat('currency', value);
        this.valuePipes.enum = (value, filterArguments = []) => this.enumFormat(value, filterArguments);
        this.fieldPipes.int = (value) => this.fieldTypeFormat('int', value);
        this.fieldPipes.float = (value) => this.fieldTypeFormat('float', value);
        this.fieldPipes.date = (value) => this.fieldTypeFormat('date', value);
        this.fieldPipes.datetime = (value) => this.fieldTypeFormat('datetime', value);
        this.fieldPipes.currency = (value) => this.fieldTypeFormat('currency', value);
        this.fieldPipes.phone = (value) => this.fieldTypeFormat('phone', value);
        this.fieldPipes.enum = (value) => this.enumFieldFormat(value);
        this.fieldPipes.dynamicenum = (value) => this.enumFieldFormat(value);
        this.fieldPipes.multienum = (value) => this.multiEnumFormat(value);
    }
    addValuePipe(name, processor) {
        this.valuePipes[name] = processor;
    }
    addFieldPipe(name, processor) {
        this.fieldPipes[name] = processor;
    }
    parse(template, context, fields) {
        if (!template) {
            return template;
        }
        const regex = /({{[\s\S]+?}})/g;
        const matches = template.match(regex);
        if (!matches || matches.length < 1) {
            return template;
        }
        let parsedTemplate = template;
        const module = (context && context.module) || '';
        matches.forEach((regexMatch) => {
            if (!parsedTemplate.includes(regexMatch)) {
                return;
            }
            let filter = '';
            let filterArguments = [];
            let value = '';
            let source = 'context';
            let parts = [];
            let variableName = '' + regexMatch;
            variableName = variableName.replace('{{', '');
            variableName = variableName.replace('}}', '');
            variableName = variableName.trim();
            let path = variableName;
            if (variableName.includes('|')) {
                const [name, pipe, ...others] = variableName.split('|');
                filter = pipe.trim();
                if (pipe.trim().includes(':')) {
                    let [filterType, ...filterArgs] = pipe.trim().split(':');
                    filter = filterType.trim();
                    filterArguments = filterArgs;
                }
                variableName = name.trim();
                path = name.trim();
            }
            if (variableName.includes('.')) {
                parts = variableName.split('.');
                source = parts[0];
                variableName = parts[1];
            }
            let sourceValues = context;
            if (source === 'fields') {
                sourceValues = fields;
            }
            if (source === 'fields') {
                if (!sourceValues || !(variableName in sourceValues)) {
                    parsedTemplate = parsedTemplate.replace(regexMatch, value);
                    return;
                }
                const field = fields[variableName];
                if (!field) {
                    parsedTemplate = parsedTemplate.replace(regexMatch, '');
                    return;
                }
                if (parts[2] && parts[2] === 'value' && field.type in this.fieldPipes) {
                    value = this.fieldPipes[field.type](field);
                    parsedTemplate = parsedTemplate.replace(regexMatch, value);
                    return;
                }
                if (parts[2] && parts[2] === 'label') {
                    value = this.getFieldLabel(field.labelKey, module);
                    parsedTemplate = parsedTemplate.replace(regexMatch, value);
                    return;
                }
                value = get({ fields }, path, '');
                parsedTemplate = parsedTemplate.replace(regexMatch, value);
                return;
            }
            if (source === 'config') {
                parsedTemplate = this.parseObjectContext(variableName, parsedTemplate, regexMatch, filter, filterArguments, (key) => {
                    return this.configs.getConfigValue(key);
                });
                return;
            }
            if (source === 'preferences') {
                parsedTemplate = this.parseObjectContext(variableName, parsedTemplate, regexMatch, filter, filterArguments, (key) => {
                    return this.preferences.getUserPreference(key);
                });
                return;
            }
            if (!sourceValues || !(variableName in sourceValues)) {
                parsedTemplate = parsedTemplate.replace(regexMatch, value);
                return;
            }
            value = get({ context }, path, '');
            if (filter in this.valuePipes) {
                value = this.valuePipes[filter](value);
            }
            parsedTemplate = parsedTemplate.replace(regexMatch, value);
        });
        return parsedTemplate;
    }
    valueTypeFormat(type, value) {
        return this.typeFormatter.toUserFormat(type, value);
    }
    enumFormat(value, filterArguments) {
        const options = filterArguments[0] ?? '';
        if (!options || !value) {
            return '';
        }
        return this.language.getListLabel(options, value);
    }
    fieldTypeFormat(type, field) {
        return this.typeFormatter.toUserFormat(type, field.value);
    }
    enumFieldFormat(field) {
        if (isVoid(field.definition.options) || isVoid(field.value)) {
            return '';
        }
        return this.language.getListLabel(field.definition.options, field.value);
    }
    multiEnumFormat(field) {
        if (isVoid(field.definition.options) || isVoid(field.valueList) || field.valueList.length < 1) {
            return '';
        }
        const result = [];
        field.valueList.forEach(value => {
            if (isVoid(value)) {
                return;
            }
            result.push(this.language.getListLabel(field.definition.options, value));
        });
        return result.join(', ');
    }
    getFieldLabel(labelKey, module = '') {
        if (isVoid(labelKey)) {
            return '';
        }
        return this.language.getFieldLabel(labelKey, module);
    }
    parseObjectContext(variableName, parsedTemplate, regexMatch, filter, filterArguments, getter) {
        let entryKey = variableName;
        if (variableName.includes('.')) {
            let [key, ...others] = variableName.split('.');
            entryKey = key;
        }
        let value = getter(entryKey);
        if (variableName.includes('.') && typeof value === 'object') {
            value = get({ value }, variableName, '');
        }
        if (!value || typeof value === 'object') {
            return parsedTemplate.replace(regexMatch, '');
        }
        if (filter in this.valuePipes) {
            value = this.valuePipes[filter](value, filterArguments);
        }
        return parsedTemplate.replace(regexMatch, value);
    }
    static { this.ɵfac = function DynamicLabelService_Factory(t) { return new (t || DynamicLabelService)(i0.ɵɵinject(DataTypeFormatter), i0.ɵɵinject(LanguageStore), i0.ɵɵinject(SystemConfigStore), i0.ɵɵinject(UserPreferenceStore)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: DynamicLabelService, factory: DynamicLabelService.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DynamicLabelService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: DataTypeFormatter }, { type: LanguageStore }, { type: SystemConfigStore }, { type: UserPreferenceStore }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function DynamicLabelComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "span", 1);
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(ctx_r0.parsedLabel);
} }
class DynamicLabelComponent {
    constructor(dynamicLabels, language) {
        this.dynamicLabels = dynamicLabels;
        this.language = language;
        this.template = '';
        this.labelKey = '';
        this.context = {};
        this.fields = {};
        this.module = null;
        this.parsedLabel = '';
    }
    ngOnInit() {
        this.vm$ = this.language.vm$.pipe(tap(() => {
            if (this.labelKey) {
                this.template = this.language.getFieldLabel(this.labelKey, this.module);
            }
            this.parseLabel();
        }));
    }
    ngOnChanges(changes) {
        if (changes.template || changes.context || changes.labelKey || changes.fields) {
            this.parseLabel();
        }
    }
    parseLabel() {
        this.parsedLabel = this.dynamicLabels.parse(this.template, this.context, this.fields);
    }
    static { this.ɵfac = function DynamicLabelComponent_Factory(t) { return new (t || DynamicLabelComponent)(i0.ɵɵdirectiveInject(DynamicLabelService), i0.ɵɵdirectiveInject(LanguageStore)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: DynamicLabelComponent, selectors: [["scrm-dynamic-label"]], inputs: { template: "template", labelKey: "labelKey", context: "context", fields: "fields", module: "module" }, features: [i0.ɵɵNgOnChangesFeature], decls: 2, vars: 3, consts: [[4, "ngIf"], [1, "dynamic-label"]], template: function DynamicLabelComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, DynamicLabelComponent_ng_container_0_Template, 3, 1, "ng-container", 0);
            i0.ɵɵpipe(1, "async");
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", i0.ɵɵpipeBind1(1, 1, ctx.vm$));
        } }, dependencies: [i2.NgIf, i2.AsyncPipe], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DynamicLabelComponent, [{
        type: Component,
        args: [{ selector: 'scrm-dynamic-label', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<ng-container *ngIf=\"(vm$ | async) as vm\">\n    <span class=\"dynamic-label\">{{parsedLabel}}</span>\n</ng-container>\n" }]
    }], function () { return [{ type: DynamicLabelService }, { type: LanguageStore }]; }, { template: [{
            type: Input
        }], labelKey: [{
            type: Input
        }], context: [{
            type: Input
        }], fields: [{
            type: Input
        }], module: [{
            type: Input
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class InlineLoadingSpinnerComponent {
    constructor() {
        this.klass = '';
    }
    ngOnInit() {
    }
    static { this.ɵfac = function InlineLoadingSpinnerComponent_Factory(t) { return new (t || InlineLoadingSpinnerComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: InlineLoadingSpinnerComponent, selectors: [["scrm-inline-loading-spinner"]], inputs: { klass: "klass" }, decls: 4, vars: 3, consts: [[1, "bounce1"], [1, "bounce2"], [1, "bounce3"]], template: function InlineLoadingSpinnerComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div");
            i0.ɵɵelement(1, "div", 0)(2, "div", 1)(3, "div", 2);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵclassMapInterpolate1("inline-spinner ", ctx.klass, "");
        } }, styles: [".inline-spinner[_ngcontent-%COMP%]{text-align:center}.inline-spinner[_ngcontent-%COMP%] > div[_ngcontent-%COMP%]{border-radius:100%;display:inline-block;animation:_ngcontent-%COMP%_sk-bouncedelay 1.4s infinite ease-in-out both}.inline-spinner[_ngcontent-%COMP%]   .bounce1[_ngcontent-%COMP%]{animation-delay:-.32s}.inline-spinner[_ngcontent-%COMP%]   .bounce2[_ngcontent-%COMP%]{animation-delay:-.16s}@keyframes _ngcontent-%COMP%_sk-bouncedelay{0%,80%,to{transform:scale(0)}40%{transform:scale(1)}}"] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(InlineLoadingSpinnerComponent, [{
        type: Component,
        args: [{ selector: 'scrm-inline-loading-spinner', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<div class=\"inline-spinner {{klass}}\">\n    <div class=\"bounce1\"></div>\n    <div class=\"bounce2\"></div>\n    <div class=\"bounce3\"></div>\n</div>\n", styles: [".inline-spinner{text-align:center}.inline-spinner>div{border-radius:100%;display:inline-block;animation:sk-bouncedelay 1.4s infinite ease-in-out both}.inline-spinner .bounce1{animation-delay:-.32s}.inline-spinner .bounce2{animation-delay:-.16s}@keyframes sk-bouncedelay{0%,80%,to{transform:scale(0)}40%{transform:scale(1)}}\n"] }]
    }], function () { return []; }, { klass: [{
            type: Input
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function ActionGroupMenuComponent_ng_container_0_ng_container_2_scrm_button_group_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-button-group", 2);
} if (rf & 2) {
    const ctx_r5 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("config$", ctx_r5.config$)("klass", ctx_r5.buttonGroupClass);
} }
function ActionGroupMenuComponent_ng_container_0_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, ActionGroupMenuComponent_ng_container_0_ng_container_2_scrm_button_group_1_Template, 1, 2, "scrm-button-group", 1);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r2.config$);
} }
function ActionGroupMenuComponent_ng_container_0_ng_container_3_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 6);
    i0.ɵɵelement(1, "scrm-label", 7);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r6 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("labelKey", ctx_r6.confirmationLabel);
} }
const _c0$K = function () { return {}; };
function ActionGroupMenuComponent_ng_container_0_ng_container_3_div_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 6);
    i0.ɵɵelement(1, "scrm-dynamic-label", 8);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r7 = i0.ɵɵnextContext(3);
    let tmp_1_0;
    let tmp_2_0;
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("labelKey", ctx_r7.confirmationDynamicLabel)("module", (tmp_1_0 = ctx_r7.actionContext == null ? null : ctx_r7.actionContext.module) !== null && tmp_1_0 !== undefined ? tmp_1_0 : "")("fields", (tmp_2_0 = ctx_r7.actionContext == null ? null : ctx_r7.actionContext.record == null ? null : ctx_r7.actionContext.record.fields) !== null && tmp_2_0 !== undefined ? tmp_2_0 : i0.ɵɵpureFunction0(3, _c0$K));
} }
function ActionGroupMenuComponent_ng_container_0_ng_container_3_div_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 9);
    i0.ɵɵelement(1, "scrm-button", 10);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r8 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("config", ctx_r8.inlineCancelButton);
} }
function ActionGroupMenuComponent_ng_container_0_ng_container_3_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 9);
    i0.ɵɵelement(1, "scrm-button", 10);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r9 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("config", ctx_r9.inlineConfirmButton);
} }
function ActionGroupMenuComponent_ng_container_0_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "div", 3);
    i0.ɵɵtemplate(2, ActionGroupMenuComponent_ng_container_0_ng_container_3_div_2_Template, 2, 1, "div", 4);
    i0.ɵɵtemplate(3, ActionGroupMenuComponent_ng_container_0_ng_container_3_div_3_Template, 2, 4, "div", 4);
    i0.ɵɵtemplate(4, ActionGroupMenuComponent_ng_container_0_ng_container_3_div_4_Template, 2, 1, "div", 5);
    i0.ɵɵtemplate(5, ActionGroupMenuComponent_ng_container_0_ng_container_3_div_5_Template, 2, 1, "div", 5);
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r3 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r3.confirmationLabel);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r3.confirmationDynamicLabel && !ctx_r3.confirmationLabel);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r3.inlineCancelButton);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r3.inlineConfirmButton);
} }
function ActionGroupMenuComponent_ng_container_0_ng_container_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "scrm-inline-loading-spinner", 11);
    i0.ɵɵelementContainerEnd();
} }
function ActionGroupMenuComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "div");
    i0.ɵɵtemplate(2, ActionGroupMenuComponent_ng_container_0_ng_container_2_Template, 2, 1, "ng-container", 0);
    i0.ɵɵtemplate(3, ActionGroupMenuComponent_ng_container_0_ng_container_3_Template, 6, 4, "ng-container", 0);
    i0.ɵɵtemplate(4, ActionGroupMenuComponent_ng_container_0_ng_container_4_Template, 2, 0, "ng-container", 0);
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵclassMapInterpolate1("", ctx_r0.klass, " float-right action-group-menu");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", !ctx_r0.inlineConfirmationEnabled && !ctx_r0.loading);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r0.inlineConfirmationEnabled && !ctx_r0.loading);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r0.loading);
} }
class ActionGroupMenuComponent {
    constructor(languages, screenSize, systemConfigStore) {
        this.languages = languages;
        this.screenSize = screenSize;
        this.systemConfigStore = systemConfigStore;
        this.klass = '';
        this.buttonClass = 'btn btn-sm';
        this.buttonGroupClass = '';
        this.actionLimitConfig = 'recordview_actions_limits';
        this.configState = new BehaviorSubject({ buttons: [] });
        this.config$ = this.configState.asObservable();
        this.inlineConfirmationEnabled = false;
        this.confirmationLabel = '';
        this.confirmationDynamicLabel = '';
        this.inlineCancelButton = null;
        this.inlineConfirmButton = null;
        this.loading = false;
        this.buttonGroupDropdownClass = 'dropdown-button-secondary';
        this.screen = ScreenSize.Medium;
        this.defaultBreakpoint = 4;
    }
    ngOnInit() {
        this.vm$ = this.config?.getActions().pipe(combineLatestWith(this.screenSize.screenSize$, this.languages.vm$), map(([actions, screenSize, languages]) => {
            if (screenSize) {
                this.screen = screenSize;
            }
            this.configState.next(this.getButtonGroupConfig(actions));
            return { actions, screenSize, languages };
        }));
    }
    isXSmallScreen() {
        return this.screen === ScreenSize.XSmall;
    }
    getButtonGroupConfig(actions) {
        const expanded = [];
        const collapsed = [];
        actions.forEach((action) => {
            const button = this.buildButton(action);
            if (action.params && action.params.collapsedMobile && this.isXSmallScreen()) {
                collapsed.push(button);
                return;
            }
            if (action.params && action.params.expanded) {
                expanded.push(button);
                return;
            }
            collapsed.push(button);
        });
        const collapseButtons = this.config.collapseButtons ?? true;
        let breakpoint = actions.length;
        if (collapseButtons === true) {
            breakpoint = this.getBreakpoint();
            if (expanded.length < breakpoint) {
                breakpoint = expanded.length;
            }
        }
        const buttons = expanded.concat(collapsed);
        return {
            buttonKlass: [this.buttonClass],
            dropdownLabel: this.languages.getAppString('LBL_ACTIONS') || '',
            breakpoint,
            dropdownOptions: {
                placement: ['bottom-right'],
                wrapperKlass: [(this.buttonGroupDropdownClass)]
            },
            buttons
        };
    }
    getBreakpoint() {
        const breakpointMap = this.systemConfigStore.getConfigValue(this.actionLimitConfig);
        if (this.screen && breakpointMap && breakpointMap[this.screen]) {
            this.breakpoint = breakpointMap[this.screen];
            return this.breakpoint;
        }
        if (this.breakpoint) {
            return this.breakpoint;
        }
        return this.defaultBreakpoint;
    }
    buildButton(action) {
        const button = {
            label: action.label || '',
            labelModule: this?.actionContext?.module ?? '',
            labelKey: action.labelKey || '',
            klass: this.buttonClass,
            titleKey: action.titleKey || '',
            onClick: () => {
                const inlineConfirmation = action?.params?.inlineConfirmation ?? false;
                if (inlineConfirmation) {
                    this.triggerTemporaryLoading();
                    const callback = () => {
                        this.config.runAction(action, this.actionContext);
                    };
                    this.initInlineConfirmation(action, callback);
                    return;
                }
                this.config.runAction(action, this.actionContext);
            }
        };
        if (!button.label) {
            button.labelKey = action.labelKey ?? '';
        }
        const debounceClick = action?.params?.debounceClick ?? null;
        button.debounceClick = true;
        if (isFalse(debounceClick)) {
            button.debounceClick = false;
        }
        if (action.icon) {
            button.icon = action.icon;
        }
        if (action.status) {
            Button.appendClasses(button, [action.status]);
        }
        if (action.klass) {
            Button.appendClasses(button, action.klass);
        }
        return button;
    }
    triggerTemporaryLoading() {
        this.loading = true;
        const delay = parseInt(this.systemConfigStore.getUi('inline_confirmation_loading_delay')) ?? 200;
        setTimeout(() => {
            this.loading = false;
        }, delay);
    }
    initInlineConfirmation(action, callback) {
        const cancelConfig = action?.params?.inlineConfirmationButtons?.cancel ?? {};
        const confirmConfig = action?.params?.inlineConfirmationButtons?.confirm ?? {};
        this.confirmationLabel = action?.params?.confirmationLabel ?? '';
        this.confirmationDynamicLabel = action?.params?.confirmationDynamicLabel ?? '';
        this.inlineCancelButton = this.buildInlineCancelButton(cancelConfig);
        this.inlineConfirmButton = this.buildInlineConfirmButton(confirmConfig, callback);
        this.inlineConfirmationEnabled = true;
    }
    buildInlineCancelButton(config) {
        const defaults = {
            labelKey: 'LBL_NO',
            klass: 'btn btn-sm p-0 m-0 btn-link border-0 line-height-initial',
            debounceClick: true,
        };
        const button = { ...defaults, ...(config ?? {}) };
        button.onClick = () => {
            this.triggerTemporaryLoading();
            this.resetInlineConfirmation();
        };
        return button;
    }
    buildInlineConfirmButton(config, callback) {
        const defaults = {
            labelKey: 'LBL_YES',
            klass: 'btn btn-sm p-0 m-0 btn-link border-0 line-height-initial',
            debounceClick: true,
        };
        const button = { ...defaults, ...(config ?? {}) };
        button.onClick = () => {
            this.triggerTemporaryLoading();
            callback();
            this.resetInlineConfirmation();
        };
        return button;
    }
    resetInlineConfirmation() {
        this.inlineConfirmationEnabled = false;
        this.confirmationDynamicLabel = '';
        this.confirmationLabel = '';
        this.inlineConfirmButton = null;
        this.inlineCancelButton = null;
    }
    static { this.ɵfac = function ActionGroupMenuComponent_Factory(t) { return new (t || ActionGroupMenuComponent)(i0.ɵɵdirectiveInject(LanguageStore), i0.ɵɵdirectiveInject(ScreenSizeObserverService), i0.ɵɵdirectiveInject(SystemConfigStore)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ActionGroupMenuComponent, selectors: [["scrm-action-group-menu"]], inputs: { klass: "klass", buttonClass: "buttonClass", buttonGroupClass: "buttonGroupClass", actionContext: "actionContext", config: "config", actionLimitConfig: "actionLimitConfig" }, decls: 2, vars: 3, consts: [[4, "ngIf"], [3, "config$", "klass", 4, "ngIf"], [3, "config$", "klass"], [1, "d-flex", "align-items-start", "justify-content-end", "inline-confirmation"], ["class", "pl-1 inline-confirmation-label", 4, "ngIf"], ["class", "pl-1 inline-confirmation-button", 4, "ngIf"], [1, "pl-1", "inline-confirmation-label"], [3, "labelKey"], [3, "labelKey", "module", "fields"], [1, "pl-1", "inline-confirmation-button"], [3, "config"], ["klass", "inline-spinner-md"]], template: function ActionGroupMenuComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, ActionGroupMenuComponent_ng_container_0_Template, 5, 6, "ng-container", 0);
            i0.ɵɵpipe(1, "async");
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", i0.ɵɵpipeBind1(1, 1, ctx.vm$));
        } }, dependencies: [i2.NgIf, ButtonComponent, ButtonGroupComponent, LabelComponent, DynamicLabelComponent, InlineLoadingSpinnerComponent, i2.AsyncPipe], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ActionGroupMenuComponent, [{
        type: Component,
        args: [{ selector: 'scrm-action-group-menu', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<ng-container *ngIf=\"(vm$ | async) as vm\">\n    <div class=\"{{klass}} float-right action-group-menu\">\n        <ng-container *ngIf=\"!inlineConfirmationEnabled && !loading\">\n            <scrm-button-group *ngIf=\"config$\" [config$]=\"config$\" [klass]=\"buttonGroupClass\"></scrm-button-group>\n        </ng-container>\n        <ng-container *ngIf=\"inlineConfirmationEnabled && !loading\">\n            <div class=\"d-flex align-items-start justify-content-end inline-confirmation\">\n                <div *ngIf=\"confirmationLabel\" class=\"pl-1 inline-confirmation-label\">\n                    <scrm-label [labelKey]=\"confirmationLabel\"></scrm-label>\n                </div>\n                <div *ngIf=\"confirmationDynamicLabel && !confirmationLabel\" class=\"pl-1 inline-confirmation-label\">\n                    <scrm-dynamic-label [labelKey]=\"confirmationDynamicLabel\"\n                                        [module]=\"actionContext?.module ?? ''\"\n                                        [fields]=\"actionContext?.record?.fields ?? {}\"\n                    >\n                    </scrm-dynamic-label>\n                </div>\n                <div *ngIf=\"inlineCancelButton\" class=\"pl-1 inline-confirmation-button\">\n                    <scrm-button [config]=\"inlineCancelButton\"></scrm-button>\n                </div>\n                <div *ngIf=\"inlineConfirmButton\" class=\"pl-1 inline-confirmation-button\">\n                    <scrm-button [config]=\"inlineConfirmButton\"></scrm-button>\n                </div>\n            </div>\n        </ng-container>\n        <ng-container *ngIf=\"loading\">\n            <scrm-inline-loading-spinner klass=\"inline-spinner-md\"></scrm-inline-loading-spinner>\n        </ng-container>\n    </div>\n</ng-container>\n" }]
    }], function () { return [{ type: LanguageStore }, { type: ScreenSizeObserverService }, { type: SystemConfigStore }]; }, { klass: [{
            type: Input
        }], buttonClass: [{
            type: Input
        }], buttonGroupClass: [{
            type: Input
        }], actionContext: [{
            type: Input
        }], config: [{
            type: Input
        }], actionLimitConfig: [{
            type: Input
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class ImageModule {
    static { this.ɵfac = function ImageModule_Factory(t) { return new (t || ImageModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: ImageModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            AngularSvgIconModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ImageModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    ImageComponent
                ],
                exports: [
                    ImageComponent
                ],
                imports: [
                    CommonModule,
                    AngularSvgIconModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(ImageModule, { declarations: [ImageComponent], imports: [CommonModule,
        AngularSvgIconModule], exports: [ImageComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DropdownSubmenuModule {
    static { this.ɵfac = function DropdownSubmenuModule_Factory(t) { return new (t || DropdownSubmenuModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: DropdownSubmenuModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            ImageModule,
            NgbModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DropdownSubmenuModule, [{
        type: NgModule,
        args: [{
                declarations: [DropdownSubmenuComponent],
                exports: [
                    DropdownSubmenuComponent
                ],
                imports: [
                    CommonModule,
                    ImageModule,
                    NgbModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(DropdownSubmenuModule, { declarations: [DropdownSubmenuComponent], imports: [CommonModule,
        ImageModule,
        NgbModule], exports: [DropdownSubmenuComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class LabelModule {
    static { this.ɵfac = function LabelModule_Factory(t) { return new (t || LabelModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: LabelModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LabelModule, [{
        type: NgModule,
        args: [{
                declarations: [LabelComponent],
                exports: [
                    LabelComponent
                ],
                imports: [
                    CommonModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(LabelModule, { declarations: [LabelComponent], imports: [CommonModule], exports: [LabelComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DropdownButtonModule {
    static { this.ɵfac = function DropdownButtonModule_Factory(t) { return new (t || DropdownButtonModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: DropdownButtonModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            NgbDropdownModule,
            ImageModule,
            DropdownSubmenuModule,
            LabelModule,
            NgbTooltipModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DropdownButtonModule, [{
        type: NgModule,
        args: [{
                declarations: [DropdownButtonComponent],
                exports: [
                    DropdownButtonComponent
                ],
                imports: [
                    CommonModule,
                    NgbDropdownModule,
                    ImageModule,
                    DropdownSubmenuModule,
                    LabelModule,
                    NgbTooltipModule,
                    TruncatePipe
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(DropdownButtonModule, { declarations: [DropdownButtonComponent], imports: [CommonModule,
        NgbDropdownModule,
        ImageModule,
        DropdownSubmenuModule,
        LabelModule,
        NgbTooltipModule,
        TruncatePipe], exports: [DropdownButtonComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class ButtonModule {
    static { this.ɵfac = function ButtonModule_Factory(t) { return new (t || ButtonModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: ButtonModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            ImageModule,
            LabelModule,
            NgbTooltipModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ButtonModule, [{
        type: NgModule,
        args: [{
                declarations: [ButtonComponent],
                exports: [ButtonComponent],
                imports: [
                    CommonModule,
                    ImageModule,
                    LabelModule,
                    NgbTooltipModule,
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(ButtonModule, { declarations: [ButtonComponent], imports: [CommonModule,
        ImageModule,
        LabelModule,
        NgbTooltipModule], exports: [ButtonComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2023 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class GroupedButtonModule {
    static { this.ɵfac = function GroupedButtonModule_Factory(t) { return new (t || GroupedButtonModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: GroupedButtonModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            ButtonModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GroupedButtonModule, [{
        type: NgModule,
        args: [{
                declarations: [GroupedButtonComponent],
                exports: [
                    GroupedButtonComponent
                ],
                imports: [
                    CommonModule,
                    ButtonModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(GroupedButtonModule, { declarations: [GroupedButtonComponent], imports: [CommonModule,
        ButtonModule], exports: [GroupedButtonComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class ButtonGroupModule {
    static { this.ɵfac = function ButtonGroupModule_Factory(t) { return new (t || ButtonGroupModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: ButtonGroupModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            ButtonModule,
            DropdownButtonModule,
            GroupedButtonModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ButtonGroupModule, [{
        type: NgModule,
        args: [{
                declarations: [ButtonGroupComponent],
                exports: [
                    ButtonGroupComponent
                ],
                imports: [
                    CommonModule,
                    ButtonModule,
                    DropdownButtonModule,
                    GroupedButtonModule,
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(ButtonGroupModule, { declarations: [ButtonGroupComponent], imports: [CommonModule,
        ButtonModule,
        DropdownButtonModule,
        GroupedButtonModule], exports: [ButtonGroupComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DynamicLabelModule {
    static { this.ɵfac = function DynamicLabelModule_Factory(t) { return new (t || DynamicLabelModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: DynamicLabelModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DynamicLabelModule, [{
        type: NgModule,
        args: [{
                declarations: [DynamicLabelComponent],
                exports: [
                    DynamicLabelComponent
                ],
                imports: [
                    CommonModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(DynamicLabelModule, { declarations: [DynamicLabelComponent], imports: [CommonModule], exports: [DynamicLabelComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class InlineLoadingSpinnerModule {
    static { this.ɵfac = function InlineLoadingSpinnerModule_Factory(t) { return new (t || InlineLoadingSpinnerModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: InlineLoadingSpinnerModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(InlineLoadingSpinnerModule, [{
        type: NgModule,
        args: [{
                declarations: [InlineLoadingSpinnerComponent],
                exports: [InlineLoadingSpinnerComponent],
                imports: [
                    CommonModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(InlineLoadingSpinnerModule, { declarations: [InlineLoadingSpinnerComponent], imports: [CommonModule], exports: [InlineLoadingSpinnerComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class ActionGroupMenuModule {
    static { this.ɵfac = function ActionGroupMenuModule_Factory(t) { return new (t || ActionGroupMenuModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: ActionGroupMenuModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            ImageModule,
            ButtonModule,
            ButtonGroupModule,
            LabelModule,
            DynamicLabelModule,
            InlineLoadingSpinnerModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ActionGroupMenuModule, [{
        type: NgModule,
        args: [{
                declarations: [ActionGroupMenuComponent],
                exports: [ActionGroupMenuComponent],
                imports: [
                    CommonModule,
                    ImageModule,
                    ButtonModule,
                    ButtonGroupModule,
                    LabelModule,
                    DynamicLabelModule,
                    InlineLoadingSpinnerModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(ActionGroupMenuModule, { declarations: [ActionGroupMenuComponent], imports: [CommonModule,
        ImageModule,
        ButtonModule,
        ButtonGroupModule,
        LabelModule,
        DynamicLabelModule,
        InlineLoadingSpinnerModule], exports: [ActionGroupMenuComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function BulkActionMenuComponent_ng_container_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "scrm-label", 17);
    i0.ɵɵelementContainerEnd();
} }
class BulkActionMenuComponent {
    constructor(languageStore) {
        this.languageStore = languageStore;
        this.subs = [];
        this.status = SelectionStatus.NONE;
        this.count = 0;
        this.SelectionStatus = SelectionStatus;
    }
    ngOnDestroy() {
        this.subs.forEach(sub => sub.unsubscribe());
        this.subs = [];
        this.count = 0;
        this.status = SelectionStatus.NONE;
    }
    ngOnInit() {
        this.subs = [];
        this.subs.push(this.selectionSource.getSelectionStatus().subscribe(status => this.status = status));
        this.subs.push(this.selectionSource.getSelectedCount().subscribe(count => this.count = count));
        this.subs.push(this.actionSource.getBulkActions().subscribe(actions => {
            const dropdownConfig = {
                labelKey: 'LBL_BULK_ACTION_BUTTON_LABEL',
                klass: ['bulk-action-button', 'btn', 'btn-sm'],
                wrapperKlass: ['bulk-action-group', 'float-left'],
                items: []
            };
            const dropdownSmallConfig = {
                labelKey: 'LBL_ACTION',
                klass: ['bulk-action-button', 'btn', 'btn-sm'],
                wrapperKlass: ['bulk-action-group', 'float-left'],
                items: []
            };
            Object.keys(actions).forEach(actionKey => {
                const action = actions[actionKey];
                dropdownConfig.items.push({
                    labelKey: action.labelKey ?? '',
                    klass: [`${actionKey}-bulk-action`],
                    onClick: () => {
                        this.actionSource.executeBulkAction(action.key);
                    }
                });
                dropdownSmallConfig.items.push({
                    labelKey: action.labelKey ?? '',
                    klass: [`${actionKey}-bulk-action`],
                    onClick: () => {
                        this.actionSource.executeBulkAction(action.key);
                    }
                });
            });
            this.dropdownConfig = dropdownConfig;
            this.dropdownSmallConfig = dropdownSmallConfig;
        }));
    }
    selectPage() {
        this.selectionSource.updateSelection(SelectionStatus.PAGE);
    }
    selectAll() {
        this.selectionSource.updateSelection(SelectionStatus.ALL);
    }
    deselectAll() {
        this.selectionSource.updateSelection(SelectionStatus.NONE);
    }
    toggleSelection(status) {
        if (status === SelectionStatus.ALL) {
            this.selectionSource.updateSelection(SelectionStatus.NONE);
            return;
        }
        this.selectionSource.updateSelection(SelectionStatus.ALL);
    }
    static { this.ɵfac = function BulkActionMenuComponent_Factory(t) { return new (t || BulkActionMenuComponent)(i0.ɵɵdirectiveInject(LanguageStore)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: BulkActionMenuComponent, selectors: [["scrm-bulk-action-menu"]], inputs: { selectionSource: "selectionSource", actionSource: "actionSource" }, decls: 18, vars: 8, consts: [[1, "bulk-action", "d-flex"], ["ngbDropdown", "", 1, "dropdown", "select-action-group"], ["type", "button", "ngbDropdownToggle", "", "aria-haspopup", "true", "aria-expanded", "false", "aria-hidden", "true", "aria-label", "Select Action Menu", 1, "bulk-action-button", "dropdown-toggle", "btn", "btn-sm"], [1, "checkbox-container"], ["type", "checkbox", "aria-hidden", "true", 3, "checked", "indeterminate", "change"], [1, "checkmark"], [1, "bulk-action-selected-number"], [4, "ngIf"], ["ngbDropdownMenu", "", "aria-hidden", "true", 1, "dropdown-menu"], [1, "dropdown-item", "select-all", 3, "click"], ["labelKey", "LBL_LISTVIEW_OPTION_ENTIRE"], [1, "dropdown-item", "select-page", 3, "click"], ["labelKey", "LBL_LISTVIEW_OPTION_CURRENT"], [1, "dropdown-item", "deselect-all", 3, "click"], ["labelKey", "LBL_LISTVIEW_NONE"], [1, "d-block", "d-sm-none", 3, "disabled", "config"], [1, "d-none", "d-sm-block", 3, "disabled", "config"], ["labelKey", "LBL_LISTVIEW_SELECTED_OBJECTS", 1, "d-none", "d-sm-inline"]], template: function BulkActionMenuComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "div", 1)(2, "button", 2)(3, "label", 3)(4, "input", 4);
            i0.ɵɵlistener("change", function BulkActionMenuComponent_Template_input_change_4_listener() { return ctx.toggleSelection(ctx.status); });
            i0.ɵɵelementEnd();
            i0.ɵɵelement(5, "span", 5);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(6, "span", 6);
            i0.ɵɵtemplate(7, BulkActionMenuComponent_ng_container_7_Template, 2, 0, "ng-container", 7);
            i0.ɵɵtext(8);
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(9, "div", 8)(10, "a", 9);
            i0.ɵɵlistener("click", function BulkActionMenuComponent_Template_a_click_10_listener() { return ctx.selectAll(); });
            i0.ɵɵelement(11, "scrm-label", 10);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(12, "a", 11);
            i0.ɵɵlistener("click", function BulkActionMenuComponent_Template_a_click_12_listener() { return ctx.selectPage(); });
            i0.ɵɵelement(13, "scrm-label", 12);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(14, "a", 13);
            i0.ɵɵlistener("click", function BulkActionMenuComponent_Template_a_click_14_listener() { return ctx.deselectAll(); });
            i0.ɵɵelement(15, "scrm-label", 14);
            i0.ɵɵelementEnd()()();
            i0.ɵɵelement(16, "scrm-dropdown-button", 15)(17, "scrm-dropdown-button", 16);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance(4);
            i0.ɵɵproperty("checked", ctx.status === "ALL")("indeterminate", ctx.status === "SOME" || ctx.status === "PAGE");
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngIf", ctx.count > 0);
            i0.ɵɵadvance(1);
            i0.ɵɵtextInterpolate1(" ", ctx.count > 0 ? ctx.count : "", " ");
            i0.ɵɵadvance(8);
            i0.ɵɵproperty("disabled", ctx.count < 1)("config", ctx.dropdownSmallConfig);
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("disabled", ctx.count < 1)("config", ctx.dropdownConfig);
        } }, dependencies: [i2.NgIf, i3$1.NgbDropdown, i3$1.NgbDropdownToggle, i3$1.NgbDropdownMenu, DropdownButtonComponent, LabelComponent], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BulkActionMenuComponent, [{
        type: Component,
        args: [{ selector: 'scrm-bulk-action-menu', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<div class=\"bulk-action d-flex\">\n    <div ngbDropdown class=\"dropdown select-action-group\">\n        <button class=\"bulk-action-button dropdown-toggle btn btn-sm\"\n                type=\"button\"\n                ngbDropdownToggle\n                aria-haspopup=\"true\"\n                aria-expanded=\"false\"\n                aria-hidden=\"true\"\n                aria-label=\"Select Action Menu\">\n            <label class=\"checkbox-container\">\n                <input type=\"checkbox\"\n                       [checked]=\"status === 'ALL'\"\n                       [indeterminate]=\"status === 'SOME' || status === 'PAGE'\"\n                       (change)=\"toggleSelection(status)\"\n                       aria-hidden=\"true\">\n                <span class=\"checkmark\"></span>\n            </label>\n            <span class=\"bulk-action-selected-number\">\n                <ng-container *ngIf=\"count > 0\"> <scrm-label class=\"d-none d-sm-inline\" labelKey=\"LBL_LISTVIEW_SELECTED_OBJECTS\"></scrm-label></ng-container> {{count > 0 ? count : ''}}\n            </span>\n        </button>\n        <div class=\"dropdown-menu\"\n             ngbDropdownMenu\n             aria-hidden=\"true\">\n            <a class=\"dropdown-item select-all\" (click)=\"selectAll()\">\n                <scrm-label labelKey=\"LBL_LISTVIEW_OPTION_ENTIRE\"></scrm-label>\n            </a>\n            <a class=\"dropdown-item select-page\" (click)=\"selectPage()\">\n                <scrm-label labelKey=\"LBL_LISTVIEW_OPTION_CURRENT\"></scrm-label>\n            </a>\n            <a class=\"dropdown-item deselect-all\" (click)=\"deselectAll()\">\n                <scrm-label labelKey=\"LBL_LISTVIEW_NONE\"></scrm-label>\n            </a>\n        </div>\n    </div>\n    <scrm-dropdown-button class=\"d-block d-sm-none\"\n                          [disabled]=\"count < 1\"\n                          [config]=\"dropdownSmallConfig\">\n    </scrm-dropdown-button>\n    <scrm-dropdown-button class=\"d-none d-sm-block\"\n                          [disabled]=\"count < 1\"\n                          [config]=\"dropdownConfig\">\n    </scrm-dropdown-button>\n</div>\n" }]
    }], function () { return [{ type: LanguageStore }]; }, { selectionSource: [{
            type: Input
        }], actionSource: [{
            type: Input
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class BulkActionMenuModule {
    static { this.ɵfac = function BulkActionMenuModule_Factory(t) { return new (t || BulkActionMenuModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: BulkActionMenuModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            NgbModule,
            DropdownButtonModule,
            LabelModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BulkActionMenuModule, [{
        type: NgModule,
        args: [{
                declarations: [BulkActionMenuComponent],
                exports: [BulkActionMenuComponent],
                imports: [
                    CommonModule,
                    NgbModule,
                    DropdownButtonModule,
                    LabelModule,
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(BulkActionMenuModule, { declarations: [BulkActionMenuComponent], imports: [CommonModule,
        NgbModule,
        DropdownButtonModule,
        LabelModule], exports: [BulkActionMenuComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class ButtonUtils {
    constructor() {
    }
    addOnClickPartial(button, partialInput) {
        const copy = { ...button };
        if (button && 'items' in copy) {
            const items = copy.items;
            copy.items = [];
            items.forEach(item => {
                copy.items.push(this.addOnClickPartial(item, partialInput));
            });
            return copy;
        }
        copy.onClick = copy.onClick && partial(copy.onClick, partialInput);
        return copy;
    }
    static { this.ɵfac = function ButtonUtils_Factory(t) { return new (t || ButtonUtils)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ButtonUtils, factory: ButtonUtils.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ButtonUtils, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return []; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class BaseChartComponent {
    constructor(elementRef, screenSize) {
        this.elementRef = elementRef;
        this.screenSize = screenSize;
        this.height = 300;
        this.view = signal([300, this.height]);
        this.subs = [];
    }
    onResize() {
        this.calculateView();
    }
    initResizeListener() {
        const resize$ = fromEvent(window, 'resize').pipe(tap(() => this.view.set([])), debounceTime(300));
        this.view.set([]);
        this.subs.push(resize$.pipe(debounceTime(50)).subscribe(() => {
            this.calculateView();
        }));
    }
    calculateView() {
        let width;
        const el = (this.elementRef && this.elementRef.nativeElement) || {};
        const parentEl = (el.parentElement && el.parentElement.parentElement) || {};
        const parentWidth = (parentEl && parentEl.offsetWidth) || 0;
        if (parentWidth > 0) {
            width = parentWidth;
        }
        else {
            width = window.innerWidth * 0.7;
            if (window.innerWidth > 990) {
                width = window.innerWidth * 0.23;
            }
        }
        this.view.set([width, this.height]);
    }
    static { this.ɵfac = function BaseChartComponent_Factory(t) { return new (t || BaseChartComponent)(i0.ɵɵdirectiveInject(i0.ElementRef), i0.ɵɵdirectiveInject(ScreenSizeObserverService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: BaseChartComponent, selectors: [["ng-component"]], inputs: { dataSource: "dataSource" }, decls: 0, vars: 0, template: function BaseChartComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseChartComponent, [{
        type: Component,
        args: [{ template: '' }]
    }], function () { return [{ type: i0.ElementRef }, { type: ScreenSizeObserverService }]; }, { dataSource: [{
            type: Input
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class BaseChartModule {
    static { this.ɵfac = function BaseChartModule_Factory(t) { return new (t || BaseChartModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: BaseChartModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseChartModule, [{
        type: NgModule,
        args: [{
                exports: [
                    BaseChartComponent,
                ],
                declarations: [
                    BaseChartComponent,
                ],
                imports: [
                    CommonModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(BaseChartModule, { declarations: [BaseChartComponent], imports: [CommonModule], exports: [BaseChartComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function ChartMessageAreaComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵelement(1, "scrm-label", 3);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("labelKey", ctx_r0.labelKey);
} }
class ChartMessageAreaComponent {
    constructor(language) {
        this.language = language;
        this.labelKey = '';
    }
    static { this.ɵfac = function ChartMessageAreaComponent_Factory(t) { return new (t || ChartMessageAreaComponent)(i0.ɵɵdirectiveInject(LanguageStore)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ChartMessageAreaComponent, selectors: [["scrm-chart-message-area"]], inputs: { labelKey: "labelKey" }, decls: 2, vars: 1, consts: [[1, "d-flex", "mb-4", "mt-4", "justify-content-center"], ["class", "lead", 4, "ngIf"], [1, "lead"], [3, "labelKey"]], template: function ChartMessageAreaComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵtemplate(1, ChartMessageAreaComponent_div_1_Template, 2, 1, "div", 1);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.labelKey);
        } }, dependencies: [i2.NgIf, LabelComponent], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ChartMessageAreaComponent, [{
        type: Component,
        args: [{ selector: 'scrm-chart-message-area', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<div class=\"d-flex mb-4 mt-4 justify-content-center\">\n    <div *ngIf=\"labelKey\" class=\"lead\">\n        <scrm-label [labelKey]=\"labelKey\"></scrm-label>\n    </div>\n</div>\n\n" }]
    }], function () { return [{ type: LanguageStore }]; }, { labelKey: [{
            type: Input
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class LoadingSpinnerComponent {
    constructor() {
        this.overlay = false;
    }
    static { this.ɵfac = function LoadingSpinnerComponent_Factory(t) { return new (t || LoadingSpinnerComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: LoadingSpinnerComponent, selectors: [["scrm-loading-spinner"]], inputs: { overlay: "overlay" }, decls: 19, vars: 2, consts: [[1, "loading-spinner"], [1, "sk-cube-grid"], [1, "sk-cube", "sk-cube1", "sk-cube-primary"], [1, "sk-cube", "sk-cube2", "sk-cube-secondary"], [1, "sk-cube", "sk-cube3", "sk-cube-secondary"], [1, "sk-cube", "sk-cube4", "sk-cube-primary"], [1, "sk-cube", "sk-cube5", "sk-cube-secondary"], [1, "sk-cube", "sk-cube6", "sk-cube-secondary"], [1, "sk-cube", "sk-cube7", "sk-cube-primary"], [1, "sk-cube", "sk-cube8", "sk-cube-primary"], [1, "sk-cube", "sk-cube9", "sk-cube-primary"]], template: function LoadingSpinnerComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div")(1, "div", 0)(2, "div", 1);
            i0.ɵɵelement(3, "div", 2)(4, "div", 2)(5, "div", 3)(6, "div", 4)(7, "div", 5)(8, "div", 5)(9, "div", 6)(10, "div", 7)(11, "div", 8)(12, "div", 8)(13, "div", 9)(14, "div", 10)(15, "div", 8)(16, "div", 8)(17, "div", 9)(18, "div", 10);
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵclassProp("overlay", ctx.overlay);
        } }, styles: [".sk-cube-grid[_ngcontent-%COMP%]{width:6.25em;height:6.25em}.sk-cube-grid[_ngcontent-%COMP%]   .sk-cube[_ngcontent-%COMP%]{width:25%;height:25%;float:left;animation:_ngcontent-%COMP%_sk-cubeGridScaleDelay 1.3s infinite ease-in-out}.sk-cube-grid[_ngcontent-%COMP%]   .sk-cube1[_ngcontent-%COMP%]{animation-delay:.2s}.sk-cube-grid[_ngcontent-%COMP%]   .sk-cube2[_ngcontent-%COMP%]{animation-delay:.3s}.sk-cube-grid[_ngcontent-%COMP%]   .sk-cube3[_ngcontent-%COMP%]{animation-delay:.4s}.sk-cube-grid[_ngcontent-%COMP%]   .sk-cube4[_ngcontent-%COMP%]{animation-delay:.1s}.sk-cube-grid[_ngcontent-%COMP%]   .sk-cube5[_ngcontent-%COMP%]{animation-delay:.2s}.sk-cube-grid[_ngcontent-%COMP%]   .sk-cube6[_ngcontent-%COMP%]{animation-delay:.3s}.sk-cube-grid[_ngcontent-%COMP%]   .sk-cube7[_ngcontent-%COMP%]{animation-delay:0s}.sk-cube-grid[_ngcontent-%COMP%]   .sk-cube8[_ngcontent-%COMP%]{animation-delay:.1s}.sk-cube-grid[_ngcontent-%COMP%]   .sk-cube9[_ngcontent-%COMP%]{animation-delay:.2s}@keyframes _ngcontent-%COMP%_sk-cubeGridScaleDelay{0%,70%,to{transform:scaleZ(1)}35%{transform:scale3D(0,0,1)}}"] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LoadingSpinnerComponent, [{
        type: Component,
        args: [{ selector: 'scrm-loading-spinner', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<div [class.overlay]=\"overlay\">\n    <div class=\"loading-spinner\">\n        <div class=\"sk-cube-grid\">\n            <div class=\"sk-cube sk-cube1 sk-cube-primary\"></div>\n            <div class=\"sk-cube sk-cube1 sk-cube-primary\"></div>\n            <div class=\"sk-cube sk-cube2 sk-cube-secondary\"></div>\n            <div class=\"sk-cube sk-cube3 sk-cube-secondary\"></div>\n            <div class=\"sk-cube sk-cube4 sk-cube-primary\"></div>\n            <div class=\"sk-cube sk-cube4 sk-cube-primary\"></div>\n            <div class=\"sk-cube sk-cube5 sk-cube-secondary\"></div>\n            <div class=\"sk-cube sk-cube6 sk-cube-secondary\"></div>\n            <div class=\"sk-cube sk-cube7 sk-cube-primary\"></div>\n            <div class=\"sk-cube sk-cube7 sk-cube-primary\"></div>\n            <div class=\"sk-cube sk-cube8 sk-cube-primary\"></div>\n            <div class=\"sk-cube sk-cube9 sk-cube-primary\"></div>\n            <div class=\"sk-cube sk-cube7 sk-cube-primary\"></div>\n            <div class=\"sk-cube sk-cube7 sk-cube-primary\"></div>\n            <div class=\"sk-cube sk-cube8 sk-cube-primary\"></div>\n            <div class=\"sk-cube sk-cube9 sk-cube-primary\"></div>\n        </div>\n    </div>\n</div>\n\n", styles: [".sk-cube-grid{width:6.25em;height:6.25em}.sk-cube-grid .sk-cube{width:25%;height:25%;float:left;animation:sk-cubeGridScaleDelay 1.3s infinite ease-in-out}.sk-cube-grid .sk-cube1{animation-delay:.2s}.sk-cube-grid .sk-cube2{animation-delay:.3s}.sk-cube-grid .sk-cube3{animation-delay:.4s}.sk-cube-grid .sk-cube4{animation-delay:.1s}.sk-cube-grid .sk-cube5{animation-delay:.2s}.sk-cube-grid .sk-cube6{animation-delay:.3s}.sk-cube-grid .sk-cube7{animation-delay:0s}.sk-cube-grid .sk-cube8{animation-delay:.1s}.sk-cube-grid .sk-cube9{animation-delay:.2s}@keyframes sk-cubeGridScaleDelay{0%,70%,to{transform:scaleZ(1)}35%{transform:scale3D(0,0,1)}}\n"] }]
    }], function () { return []; }, { overlay: [{
            type: Input
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function PieGridChartComponent_scrm_chart_message_area_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-chart-message-area", 3);
} }
function PieGridChartComponent_ng_container_1_ngx_charts_pie_grid_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "ngx-charts-pie-grid", 5);
} if (rf & 2) {
    const ctx_r3 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("animations", false)("view", ctx_r3.view())("scheme", ctx_r3.scheme)("minWidth", ctx_r3.minWidth)("label", ctx_r3.language.getFieldLabel(ctx_r3.label))("results", ctx_r3.results);
} }
function PieGridChartComponent_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, PieGridChartComponent_ng_container_1_ngx_charts_pie_grid_1_Template, 1, 6, "ngx-charts-pie-grid", 4);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r1.results && ctx_r1.results.length > 0);
} }
function PieGridChartComponent_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 6);
    i0.ɵɵelement(1, "scrm-loading-spinner");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    i0.ɵɵclassProp("m-5", true);
} }
class PieGridChartComponent extends BaseChartComponent {
    constructor(language, elementRef, screenSize) {
        super(elementRef, screenSize);
        this.language = language;
        this.elementRef = elementRef;
        this.screenSize = screenSize;
        this.height = 700;
        this.minWidth = 100;
    }
    ngOnInit() {
        if (this.dataSource.options.height) {
            this.height = this.dataSource.options.height;
        }
        if (this?.dataSource?.options?.minWidth) {
            this.minWidth = this.dataSource.options.minWidth;
        }
        this.initResizeListener();
        this.subs.push(this.dataSource.getResults().pipe(debounceTime(500)).subscribe(value => {
            this.parseResults(value);
            this.calculateHeightBasedOnResults();
            this.calculateView();
        }));
    }
    ngOnDestroy() {
        this.subs.forEach(sub => sub.unsubscribe());
    }
    get scheme() {
        return this.dataSource.options.scheme || 'picnic';
    }
    get label() {
        return this.dataSource.options.label || '';
    }
    onResize() {
        this.calculateHeightBasedOnResults();
        this.calculateView();
    }
    calculateHeightBasedOnResults() {
        if (this.results && this.results.length) {
            const perRow = Math.floor(this.view()[0] / 170);
            this.height = (Math.floor(this.results.length / perRow) * 200);
        }
        else {
            this.height = 50;
        }
    }
    parseResults(value) {
        this.results = [];
        if (value.singleSeries && value.singleSeries.length) {
            value.singleSeries.forEach(entry => {
                const parsedValue = parseFloat('' + entry.value);
                if (!parsedValue) {
                    this.results.push(entry);
                    return;
                }
                this.results.push({
                    name: entry.name,
                    value: parsedValue
                });
            });
        }
    }
    calculateView() {
        let width;
        const el = (this.elementRef && this.elementRef.nativeElement) || {};
        const parentEl = (el.parentElement && el.parentElement.parentElement) || {};
        const parentWidth = (parentEl && parentEl.offsetWidth) || 0;
        if (parentWidth > 0) {
            width = parentWidth;
        }
        else {
            width = window.innerWidth * 0.7;
            if (window.innerWidth > 990) {
                width = window.innerWidth * 0.23;
            }
        }
        if (width > 239) {
            this.view.set([width, this.height]);
            return;
        }
        this.view.set([width, 800]);
    }
    static { this.ɵfac = function PieGridChartComponent_Factory(t) { return new (t || PieGridChartComponent)(i0.ɵɵdirectiveInject(LanguageStore), i0.ɵɵdirectiveInject(i0.ElementRef), i0.ɵɵdirectiveInject(ScreenSizeObserverService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: PieGridChartComponent, selectors: [["scrm-pie-grid-chart"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 3, vars: 3, consts: [["labelKey", "LBL_NO_DATA", 4, "ngIf"], [4, "ngIf"], ["class", "chart-loading", 3, "m-5", 4, "ngIf"], ["labelKey", "LBL_NO_DATA"], [3, "animations", "view", "scheme", "minWidth", "label", "results", 4, "ngIf"], [3, "animations", "view", "scheme", "minWidth", "label", "results"], [1, "chart-loading"]], template: function PieGridChartComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, PieGridChartComponent_scrm_chart_message_area_0_Template, 1, 0, "scrm-chart-message-area", 0);
            i0.ɵɵtemplate(1, PieGridChartComponent_ng_container_1_Template, 2, 1, "ng-container", 1);
            i0.ɵɵtemplate(2, PieGridChartComponent_div_2_Template, 2, 2, "div", 2);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", !ctx.results || !ctx.results.length || ctx.results.length < 1);
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.view().length);
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", !ctx.view().length && ctx.results && ctx.results.length > 0);
        } }, dependencies: [i2.NgIf, i3$2.PieGridComponent, ChartMessageAreaComponent, LoadingSpinnerComponent], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PieGridChartComponent, [{
        type: Component,
        args: [{ selector: 'scrm-pie-grid-chart', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<scrm-chart-message-area *ngIf=\"!results || !results.length || results.length < 1\"\n                         labelKey=\"LBL_NO_DATA\"></scrm-chart-message-area>\n<ng-container *ngIf=\"view().length\">\n    <ngx-charts-pie-grid *ngIf=\"results && results.length > 0\"\n                         [animations]=\"false\"\n                         [view]=\"view()\"\n                         [scheme]=\"scheme\"\n                         [minWidth]=\"minWidth\"\n                         [label]=\"language.getFieldLabel(label)\"\n                         [results]=\"results\">\n    </ngx-charts-pie-grid>\n</ng-container>\n<div *ngIf=\"!view().length && results && results.length > 0\" [class.m-5]=\"true\" class=\"chart-loading\">\n    <scrm-loading-spinner></scrm-loading-spinner>\n</div>\n" }]
    }], function () { return [{ type: LanguageStore }, { type: i0.ElementRef }, { type: ScreenSizeObserverService }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function VerticalBarChartComponent_scrm_chart_message_area_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-chart-message-area", 3);
} }
function VerticalBarChartComponent_ng_container_1_ngx_charts_bar_vertical_1_ng_template_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(2, "div");
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const model_r6 = ctx.model;
    const ctx_r5 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate(model_r6.name);
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(ctx_r5.formatTooltipValue(model_r6.value));
} }
function VerticalBarChartComponent_ng_container_1_ngx_charts_bar_vertical_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "ngx-charts-bar-vertical", 5);
    i0.ɵɵtemplate(1, VerticalBarChartComponent_ng_container_1_ngx_charts_bar_vertical_1_ng_template_1_Template, 4, 2, "ng-template", null, 6, i0.ɵɵtemplateRefExtractor);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r3 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("animations", false)("results", ctx_r3.results)("view", ctx_r3.view())("scheme", ctx_r3.scheme)("gradient", ctx_r3.gradient)("xAxis", ctx_r3.xAxis)("yAxis", ctx_r3.yAxis)("legend", ctx_r3.legend)("legendPosition", "below")("showXAxisLabel", ctx_r3.showXAxisLabel)("showYAxisLabel", ctx_r3.showYAxisLabel)("xAxisLabel", ctx_r3.xAxisLabel)("yAxisLabel", ctx_r3.yAxisLabel)("yAxisTickFormatting", ctx_r3.yAxisTickFormatting);
} }
function VerticalBarChartComponent_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, VerticalBarChartComponent_ng_container_1_ngx_charts_bar_vertical_1_Template, 3, 14, "ngx-charts-bar-vertical", 4);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r1.results && ctx_r1.results.length > 0);
} }
function VerticalBarChartComponent_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 7);
    i0.ɵɵelement(1, "scrm-loading-spinner");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    i0.ɵɵclassProp("m-5", true);
} }
class VerticalBarChartComponent extends BaseChartComponent {
    constructor(elementRef, screenSize) {
        super(elementRef, screenSize);
        this.elementRef = elementRef;
        this.screenSize = screenSize;
    }
    ngOnInit() {
        if (this.dataSource.options.height) {
            this.height = this.dataSource.options.height;
        }
        this.initResizeListener();
        this.subs.push(this.dataSource.getResults().pipe(debounceTime(500)).subscribe(value => {
            this.results = value.singleSeries;
            this.calculateView();
        }));
    }
    ngOnDestroy() {
        this.subs.forEach(sub => sub.unsubscribe());
    }
    get scheme() {
        return this.dataSource.options.scheme || 'picnic';
    }
    get gradient() {
        return this.dataSource.options.gradient || false;
    }
    get xAxis() {
        return this.dataSource.options.xAxis || false;
    }
    get yAxis() {
        return !isFalse(this.dataSource.options.yAxis);
    }
    get legend() {
        return !isFalse(this.dataSource.options.legend);
    }
    get showXAxisLabel() {
        return this.dataSource.options.showXAxisLabel || false;
    }
    get showYAxisLabel() {
        return this.dataSource.options.showYAxisLabel || false;
    }
    get xAxisLabel() {
        return this.dataSource.options.xAxisLabel || '';
    }
    get yAxisLabel() {
        return this.dataSource.options.yAxisLabel || '';
    }
    get yAxisTickFormatting() {
        if (this.dataSource.options.yAxisTickFormatting) {
            return this.dataSource.tickFormatting;
        }
        return null;
    }
    formatTooltipValue(value) {
        if (!this.dataSource || !this.dataSource.tooltipFormatting) {
            return value;
        }
        return this.dataSource.tooltipFormatting(value);
    }
    static { this.ɵfac = function VerticalBarChartComponent_Factory(t) { return new (t || VerticalBarChartComponent)(i0.ɵɵdirectiveInject(i0.ElementRef), i0.ɵɵdirectiveInject(ScreenSizeObserverService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: VerticalBarChartComponent, selectors: [["scrm-vertical-bar-chart"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 3, vars: 3, consts: [["labelKey", "LBL_NO_DATA", 4, "ngIf"], [4, "ngIf"], ["class", "chart-loading", 3, "m-5", 4, "ngIf"], ["labelKey", "LBL_NO_DATA"], ["class", "vertical-bar-chart", 3, "animations", "results", "view", "scheme", "gradient", "xAxis", "yAxis", "legend", "legendPosition", "showXAxisLabel", "showYAxisLabel", "xAxisLabel", "yAxisLabel", "yAxisTickFormatting", 4, "ngIf"], [1, "vertical-bar-chart", 3, "animations", "results", "view", "scheme", "gradient", "xAxis", "yAxis", "legend", "legendPosition", "showXAxisLabel", "showYAxisLabel", "xAxisLabel", "yAxisLabel", "yAxisTickFormatting"], ["tooltipTemplate", ""], [1, "chart-loading"]], template: function VerticalBarChartComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, VerticalBarChartComponent_scrm_chart_message_area_0_Template, 1, 0, "scrm-chart-message-area", 0);
            i0.ɵɵtemplate(1, VerticalBarChartComponent_ng_container_1_Template, 2, 1, "ng-container", 1);
            i0.ɵɵtemplate(2, VerticalBarChartComponent_div_2_Template, 2, 2, "div", 2);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", !ctx.results || !ctx.results.length || ctx.results.length < 1);
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.view().length);
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", !ctx.view().length && ctx.results && ctx.results.length > 0);
        } }, dependencies: [i2.NgIf, i3$2.BarVerticalComponent, ChartMessageAreaComponent, LoadingSpinnerComponent], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(VerticalBarChartComponent, [{
        type: Component,
        args: [{ selector: 'scrm-vertical-bar-chart', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<scrm-chart-message-area *ngIf=\"!results || !results.length || results.length < 1\"\n                         labelKey=\"LBL_NO_DATA\"></scrm-chart-message-area>\n<ng-container *ngIf=\"view().length\">\n    <ngx-charts-bar-vertical *ngIf=\"results && results.length > 0\"\n                             class=\"vertical-bar-chart\"\n                             [animations]=\"false\"\n                             [results]=\"results\"\n                             [view]=\"view()\"\n                             [scheme]=\"scheme\"\n                             [gradient]=\"gradient\"\n                             [xAxis]=\"xAxis\"\n                             [yAxis]=\"yAxis\"\n                             [legend]=\"legend\"\n                             [legendPosition]=\"'below'\"\n                             [showXAxisLabel]=\"showXAxisLabel\"\n                             [showYAxisLabel]=\"showYAxisLabel\"\n                             [xAxisLabel]=\"xAxisLabel\"\n                             [yAxisLabel]=\"yAxisLabel\"\n                             [yAxisTickFormatting]=\"yAxisTickFormatting\">\n        <ng-template #tooltipTemplate let-model=\"model\">\n            <div>{{model.name}}</div>\n            <div>{{ formatTooltipValue(model.value) }}</div>\n        </ng-template>\n    </ngx-charts-bar-vertical>\n</ng-container>\n<div *ngIf=\"!view().length && results && results.length > 0\" [class.m-5]=\"true\" class=\"chart-loading\">\n    <scrm-loading-spinner></scrm-loading-spinner>\n</div>\n\n\n" }]
    }], function () { return [{ type: i0.ElementRef }, { type: ScreenSizeObserverService }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class ChartMessageAreaModule {
    static { this.ɵfac = function ChartMessageAreaModule_Factory(t) { return new (t || ChartMessageAreaModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: ChartMessageAreaModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            LabelModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ChartMessageAreaModule, [{
        type: NgModule,
        args: [{
                declarations: [ChartMessageAreaComponent],
                exports: [ChartMessageAreaComponent],
                imports: [
                    CommonModule,
                    LabelModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(ChartMessageAreaModule, { declarations: [ChartMessageAreaComponent], imports: [CommonModule,
        LabelModule], exports: [ChartMessageAreaComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class LoadingSpinnerModule {
    static { this.ɵfac = function LoadingSpinnerModule_Factory(t) { return new (t || LoadingSpinnerModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: LoadingSpinnerModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LoadingSpinnerModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    LoadingSpinnerComponent
                ],
                exports: [
                    LoadingSpinnerComponent
                ],
                imports: [
                    CommonModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(LoadingSpinnerModule, { declarations: [LoadingSpinnerComponent], imports: [CommonModule], exports: [LoadingSpinnerComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class VerticalBarChartModule {
    static { this.ɵfac = function VerticalBarChartModule_Factory(t) { return new (t || VerticalBarChartModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: VerticalBarChartModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            NgxChartsModule,
            ChartMessageAreaModule,
            LoadingSpinnerModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(VerticalBarChartModule, [{
        type: NgModule,
        args: [{
                declarations: [VerticalBarChartComponent],
                exports: [VerticalBarChartComponent],
                imports: [
                    CommonModule,
                    NgxChartsModule,
                    ChartMessageAreaModule,
                    LoadingSpinnerModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(VerticalBarChartModule, { declarations: [VerticalBarChartComponent], imports: [CommonModule,
        NgxChartsModule,
        ChartMessageAreaModule,
        LoadingSpinnerModule], exports: [VerticalBarChartComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class PieGridChartModule {
    static { this.ɵfac = function PieGridChartModule_Factory(t) { return new (t || PieGridChartModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: PieGridChartModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            NgxChartsModule,
            ChartMessageAreaModule,
            LoadingSpinnerModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PieGridChartModule, [{
        type: NgModule,
        args: [{
                declarations: [PieGridChartComponent],
                exports: [PieGridChartComponent],
                imports: [
                    CommonModule,
                    NgxChartsModule,
                    ChartMessageAreaModule,
                    LoadingSpinnerModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(PieGridChartModule, { declarations: [PieGridChartComponent], imports: [CommonModule,
        NgxChartsModule,
        ChartMessageAreaModule,
        LoadingSpinnerModule], exports: [PieGridChartComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function LineChartComponent_scrm_chart_message_area_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-chart-message-area", 3);
} }
function LineChartComponent_ng_container_1_ngx_charts_line_chart_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "ngx-charts-line-chart", 5);
} if (rf & 2) {
    const ctx_r3 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("animations", false)("results", ctx_r3.results)("view", ctx_r3.view())("scheme", ctx_r3.scheme)("gradient", ctx_r3.gradient)("xAxis", ctx_r3.xAxis)("yAxis", ctx_r3.yAxis)("legend", ctx_r3.legend)("xScaleMin", ctx_r3.xScaleMin)("xScaleMax", ctx_r3.xScaleMax)("xAxisTicks", ctx_r3.xAxisTicks)("showXAxisLabel", ctx_r3.showXAxisLabel)("showYAxisLabel", ctx_r3.showYAxisLabel)("xAxisLabel", ctx_r3.xAxisLabel)("legendPosition", "below")("autoScale", true)("yAxisTickFormatting", ctx_r3.yAxisTickFormatting)("xAxisTickFormatting", ctx_r3.xAxisTickFormatting)("tooltipDisabled", ctx_r3.tooltipDisabled)("yAxisLabel", ctx_r3.yAxisLabel);
} }
function LineChartComponent_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, LineChartComponent_ng_container_1_ngx_charts_line_chart_1_Template, 1, 20, "ngx-charts-line-chart", 4);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r1.results && ctx_r1.results.length > 0);
} }
function LineChartComponent_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 6);
    i0.ɵɵelement(1, "scrm-loading-spinner");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    i0.ɵɵclassProp("m-5", true);
} }
class LineChartComponent extends BaseChartComponent {
    constructor(elementRef, screenSize) {
        super(elementRef, screenSize);
        this.elementRef = elementRef;
        this.screenSize = screenSize;
    }
    ngOnInit() {
        if (this.dataSource.options.height) {
            this.height = this.dataSource.options.height;
        }
        this.initResizeListener();
        this.subs.push(this.dataSource.getResults().subscribe(value => {
            this.results = value.multiSeries;
            this.calculateView();
        }));
        this.scheme = this.getScheme();
        this.gradient = this.getGradient();
        this.xAxis = this.getXAxis();
        this.yAxis = this.getYAxis();
        this.legend = this.getLegend();
        this.xScaleMin = this.getXScaleMin();
        this.xScaleMax = this.getXScaleMax();
        this.xAxisTicks = this.getXAxisTicks();
        this.showXAxisLabel = this.getShowXAxisLabel();
        this.showYAxisLabel = this.getShowYAxisLabel();
        this.xAxisLabel = this.getXAxisLabel();
        this.yAxisLabel = this.getYAxisLabel();
        this.yAxisTickFormatting = this.getYAxisTickFormatting();
        this.xAxisTickFormatting = this.getXAxisTickFormatting();
        this.tooltipDisabled = this.getTooltipDisabled();
    }
    ngOnDestroy() {
        this.subs.forEach(sub => sub.unsubscribe());
    }
    getScheme() {
        return this.dataSource.options.scheme || 'picnic';
    }
    getGradient() {
        return this.dataSource.options.gradient || false;
    }
    getXAxis() {
        return !isFalse(this.dataSource.options.xAxis);
    }
    getYAxis() {
        return !isFalse(this.dataSource.options.yAxis);
    }
    getLegend() {
        return !isFalse(this.dataSource.options.legend);
    }
    getXScaleMin() {
        return this.dataSource.options.xScaleMin || null;
    }
    getXScaleMax() {
        return this.dataSource.options.xScaleMax || null;
    }
    getXAxisTicks() {
        return this.dataSource.options.xAxisTicks || null;
    }
    getShowXAxisLabel() {
        return !isFalse(this.dataSource.options.showXAxisLabel);
    }
    getShowYAxisLabel() {
        return this.dataSource.options.showYAxisLabel || false;
    }
    getXAxisLabel() {
        return this.dataSource.options.xAxisLabel || '';
    }
    getYAxisLabel() {
        return this.dataSource.options.yAxisLabel || '';
    }
    getYAxisTickFormatting() {
        if (!this.dataSource.options.yAxisTickFormatting) {
            return null;
        }
        return this.dataSource.tickFormatting || null;
    }
    getXAxisTickFormatting() {
        if (!this.dataSource.options.xAxisTickFormatting) {
            return null;
        }
        return this.dataSource.tickFormatting || null;
    }
    getTooltipDisabled() {
        return this.dataSource.options.tooltipDisabled || false;
    }
    static { this.ɵfac = function LineChartComponent_Factory(t) { return new (t || LineChartComponent)(i0.ɵɵdirectiveInject(i0.ElementRef), i0.ɵɵdirectiveInject(ScreenSizeObserverService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: LineChartComponent, selectors: [["scrm-line-chart"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 3, vars: 3, consts: [["labelKey", "LBL_NO_DATA", 4, "ngIf"], [4, "ngIf"], ["class", "chart-loading", 3, "m-5", 4, "ngIf"], ["labelKey", "LBL_NO_DATA"], ["class", "line-chart", 3, "animations", "results", "view", "scheme", "gradient", "xAxis", "yAxis", "legend", "xScaleMin", "xScaleMax", "xAxisTicks", "showXAxisLabel", "showYAxisLabel", "xAxisLabel", "legendPosition", "autoScale", "yAxisTickFormatting", "xAxisTickFormatting", "tooltipDisabled", "yAxisLabel", 4, "ngIf"], [1, "line-chart", 3, "animations", "results", "view", "scheme", "gradient", "xAxis", "yAxis", "legend", "xScaleMin", "xScaleMax", "xAxisTicks", "showXAxisLabel", "showYAxisLabel", "xAxisLabel", "legendPosition", "autoScale", "yAxisTickFormatting", "xAxisTickFormatting", "tooltipDisabled", "yAxisLabel"], [1, "chart-loading"]], template: function LineChartComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, LineChartComponent_scrm_chart_message_area_0_Template, 1, 0, "scrm-chart-message-area", 0);
            i0.ɵɵtemplate(1, LineChartComponent_ng_container_1_Template, 2, 1, "ng-container", 1);
            i0.ɵɵtemplate(2, LineChartComponent_div_2_Template, 2, 2, "div", 2);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", !ctx.results || !ctx.results.length || ctx.results.length < 1);
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.view().length);
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", !ctx.view().length && ctx.results && ctx.results.length > 0);
        } }, dependencies: [i2.NgIf, i3$2.LineChartComponent, ChartMessageAreaComponent, LoadingSpinnerComponent], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LineChartComponent, [{
        type: Component,
        args: [{ selector: 'scrm-line-chart', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<scrm-chart-message-area *ngIf=\"!results || !results.length || results.length < 1\"\n                         labelKey=\"LBL_NO_DATA\"></scrm-chart-message-area>\n<ng-container *ngIf=\"view().length\">\n    <ngx-charts-line-chart *ngIf=\"results && results.length > 0\"\n                           class=\"line-chart\"\n                           [animations]=\"false\"\n                           [results]=\"results\"\n                           [view]=\"view()\"\n                           [scheme]=\"scheme\"\n                           [gradient]=\"gradient\"\n                           [xAxis]=\"xAxis\"\n                           [yAxis]=\"yAxis\"\n                           [legend]=\"legend\"\n                           [xScaleMin]=\"xScaleMin\"\n                           [xScaleMax]=\"xScaleMax\"\n                           [xAxisTicks]=\"xAxisTicks\"\n                           [showXAxisLabel]=\"showXAxisLabel\"\n                           [showYAxisLabel]=\"showYAxisLabel\"\n                           [xAxisLabel]=\"xAxisLabel\"\n                           [legendPosition]=\"'below'\"\n                           [autoScale]=\"true\"\n                           [yAxisTickFormatting]=\"yAxisTickFormatting\"\n                           [xAxisTickFormatting]=\"xAxisTickFormatting\"\n                           [tooltipDisabled]=\"tooltipDisabled\"\n                           [yAxisLabel]=\"yAxisLabel\">\n    </ngx-charts-line-chart>\n</ng-container>\n<div *ngIf=\"!view().length && results && results.length > 0\" [class.m-5]=\"true\" class=\"chart-loading\">\n    <scrm-loading-spinner></scrm-loading-spinner>\n</div>\n" }]
    }], function () { return [{ type: i0.ElementRef }, { type: ScreenSizeObserverService }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class LineChartModule {
    static { this.ɵfac = function LineChartModule_Factory(t) { return new (t || LineChartModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: LineChartModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            NgxChartsModule,
            ChartMessageAreaModule,
            LoadingSpinnerModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LineChartModule, [{
        type: NgModule,
        args: [{
                declarations: [LineChartComponent],
                exports: [LineChartComponent],
                imports: [
                    CommonModule,
                    NgxChartsModule,
                    ChartMessageAreaModule,
                    LoadingSpinnerModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(LineChartModule, { declarations: [LineChartComponent], imports: [CommonModule,
        NgxChartsModule,
        ChartMessageAreaModule,
        LoadingSpinnerModule], exports: [LineChartComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
const chartModules = [
    LineChartModule,
    PieGridChartModule,
    VerticalBarChartModule
];
const chartTypeMap = {
    'line-chart': LineChartComponent,
    'pie-grid': PieGridChartComponent,
    'vertical-bar': VerticalBarChartComponent
};

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class ChartRegistry extends BaseComponentRegistry {
    constructor() {
        super();
    }
    initDefault() {
        Object.keys(chartTypeMap).forEach(key => {
            this.register('default', key, chartTypeMap[key]);
        });
    }
    static { this.ɵfac = function ChartRegistry_Factory(t) { return new (t || ChartRegistry)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ChartRegistry, factory: ChartRegistry.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ChartRegistry, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return []; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function ChartComponent_scrm_chart_message_area_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-chart-message-area", 2);
} }
const _c0$J = function (a0) { return { "dataSource": a0 }; };
function ChartComponent_ndc_dynamic_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "ndc-dynamic", 3);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ndcDynamicComponent", ctx_r1.chartType)("ndcDynamicInputs", i0.ɵɵpureFunction1(2, _c0$J, ctx_r1.dataSource));
} }
class ChartComponent {
    constructor(registry) {
        this.registry = registry;
        this.dataSource = null;
    }
    get chartType() {
        return this.registry.get('default', this.type);
    }
    ngOnInit() {
    }
    isConfigured() {
        return !!(this.type && this.dataSource && this.chartType);
    }
    static { this.ɵfac = function ChartComponent_Factory(t) { return new (t || ChartComponent)(i0.ɵɵdirectiveInject(ChartRegistry)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ChartComponent, selectors: [["scrm-chart"]], inputs: { dataSource: "dataSource", type: "type" }, decls: 2, vars: 2, consts: [["labelKey", "LBL_BAD_CONFIG", 4, "ngIf"], [3, "ndcDynamicComponent", "ndcDynamicInputs", 4, "ngIf"], ["labelKey", "LBL_BAD_CONFIG"], [3, "ndcDynamicComponent", "ndcDynamicInputs"]], template: function ChartComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, ChartComponent_scrm_chart_message_area_0_Template, 1, 0, "scrm-chart-message-area", 0);
            i0.ɵɵtemplate(1, ChartComponent_ndc_dynamic_1_Template, 1, 4, "ndc-dynamic", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", !ctx.isConfigured());
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.isConfigured());
        } }, dependencies: [i2.NgIf, i3$3.DynamicIoDirective, i3$3.DynamicComponent, ChartMessageAreaComponent], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ChartComponent, [{
        type: Component,
        args: [{ selector: 'scrm-chart', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<scrm-chart-message-area *ngIf=\"!isConfigured()\" labelKey=\"LBL_BAD_CONFIG\"></scrm-chart-message-area>\n<ndc-dynamic *ngIf=\"isConfigured()\"\n             [ndcDynamicComponent]=\"chartType\"\n             [ndcDynamicInputs]=\"{'dataSource': dataSource}\">\n</ndc-dynamic>\n\n" }]
    }], function () { return [{ type: ChartRegistry }]; }, { dataSource: [{
            type: Input,
            args: ['dataSource']
        }], type: [{
            type: Input,
            args: ['type']
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class ChartModule {
    static { this.ɵfac = function ChartModule_Factory(t) { return new (t || ChartModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: ChartModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule, chartModules, DynamicModule,
            ChartMessageAreaModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ChartModule, [{
        type: NgModule,
        args: [{
                declarations: [ChartComponent],
                exports: [ChartComponent],
                imports: [
                    CommonModule,
                    ...chartModules,
                    DynamicModule,
                    ChartMessageAreaModule,
                ],
                schemas: [CUSTOM_ELEMENTS_SCHEMA]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(ChartModule, { declarations: [ChartComponent], imports: [CommonModule, LineChartModule, PieGridChartModule, VerticalBarChartModule, DynamicModule,
        ChartMessageAreaModule], exports: [ChartComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function CloseButtonComponent_scrm_button_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "scrm-button", 1)(1, "span", 2);
    i0.ɵɵtext(2, "\u00D7");
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("config", ctx_r0.getConfig());
} }
class CloseButtonComponent {
    constructor() {
        this.buttonClasses = ['close-button'];
    }
    getConfig() {
        const btn = Button.fromButton(this.config);
        btn.addClasses(this.buttonClasses);
        return btn;
    }
    static { this.ɵfac = function CloseButtonComponent_Factory(t) { return new (t || CloseButtonComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: CloseButtonComponent, selectors: [["scrm-close-button"]], inputs: { config: "config" }, decls: 1, vars: 1, consts: [[3, "config", 4, "ngIf"], [3, "config"], ["aria-hidden", "true"]], template: function CloseButtonComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, CloseButtonComponent_scrm_button_0_Template, 3, 1, "scrm-button", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.config);
        } }, dependencies: [i2.NgIf, ButtonComponent], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CloseButtonComponent, [{
        type: Component,
        args: [{ selector: 'scrm-close-button', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<scrm-button *ngIf=\"config\" [config]=\"getConfig()\">\n    <span aria-hidden=\"true\">&times;</span>\n</scrm-button>\n" }]
    }], function () { return []; }, { config: [{
            type: Input
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class CloseButtonModule {
    static { this.ɵfac = function CloseButtonModule_Factory(t) { return new (t || CloseButtonModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: CloseButtonModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            ButtonModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CloseButtonModule, [{
        type: NgModule,
        args: [{
                declarations: [CloseButtonComponent],
                exports: [
                    CloseButtonComponent
                ],
                imports: [
                    CommonModule,
                    ButtonModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(CloseButtonModule, { declarations: [CloseButtonComponent], imports: [CommonModule,
        ButtonModule], exports: [CloseButtonComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function ModalComponent_scrm_label_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-label", 3);
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("labelKey", ctx_r0.titleKey);
} }
function ModalComponent_scrm_close_button_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-close-button", 4);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("config", ctx_r1.close);
} }
const _c0$I = [[["", "modal-body", ""]], [["", "modal-footer", ""]]];
const _c1$e = ["[modal-body]", "[modal-footer]"];
class ModalComponent {
    constructor() {
        this.klass = '';
        this.headerKlass = '';
        this.bodyKlass = '';
        this.footerKlass = '';
        this.titleKey = '';
        this.closable = false;
        this.close = {
            klass: ['btn', 'btn-outline-light', 'btn-sm']
        };
    }
    static { this.ɵfac = function ModalComponent_Factory(t) { return new (t || ModalComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ModalComponent, selectors: [["scrm-modal"]], inputs: { klass: "klass", headerKlass: "headerKlass", bodyKlass: "bodyKlass", footerKlass: "footerKlass", titleKey: "titleKey", closable: "closable", close: "close" }, ngContentSelectors: _c1$e, decls: 9, vars: 13, consts: [[1, "modal-title"], [3, "labelKey", 4, "ngIf"], [3, "config", 4, "ngIf"], [3, "labelKey"], [3, "config"]], template: function ModalComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵprojectionDef(_c0$I);
            i0.ɵɵelementStart(0, "div")(1, "div")(2, "div", 0);
            i0.ɵɵtemplate(3, ModalComponent_scrm_label_3_Template, 1, 1, "scrm-label", 1);
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(4, ModalComponent_scrm_close_button_4_Template, 1, 1, "scrm-close-button", 2);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(5, "div");
            i0.ɵɵprojection(6);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(7, "div");
            i0.ɵɵprojection(8, 1);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵclassMap(ctx.klass);
            i0.ɵɵadvance(1);
            i0.ɵɵclassMapInterpolate1("modal-header ", ctx.headerKlass, " d-flex align-items-center");
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngIf", ctx.titleKey);
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.closable);
            i0.ɵɵadvance(1);
            i0.ɵɵclassMapInterpolate1("modal-body ", ctx.bodyKlass, "");
            i0.ɵɵadvance(2);
            i0.ɵɵclassMapInterpolate1("modal-footer ", ctx.footerKlass, "");
        } }, dependencies: [i2.NgIf, CloseButtonComponent, LabelComponent], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ModalComponent, [{
        type: Component,
        args: [{ selector: 'scrm-modal', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<div [class]=\"klass\">\n    <div class=\"modal-header {{headerKlass}} d-flex align-items-center\">\n        <div class=\"modal-title\">\n            <scrm-label *ngIf=\"titleKey\" [labelKey]=\"titleKey\"></scrm-label>\n        </div>\n        <scrm-close-button *ngIf=\"closable\" [config]=\"close\"></scrm-close-button>\n    </div>\n\n    <div class=\"modal-body {{bodyKlass}}\">\n        <ng-content select=\"[modal-body]\"></ng-content>\n    </div>\n\n    <div class=\"modal-footer {{footerKlass}}\">\n        <ng-content select=\"[modal-footer]\"></ng-content>\n    </div>\n</div>\n" }]
    }], null, { klass: [{
            type: Input
        }], headerKlass: [{
            type: Input
        }], bodyKlass: [{
            type: Input
        }], footerKlass: [{
            type: Input
        }], titleKey: [{
            type: Input
        }], closable: [{
            type: Input
        }], close: [{
            type: Input
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function ColumnChooserComponent_div_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 16);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const item_r4 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", ctx_r1.getColumnLabel(item_r4.label), " ");
} }
function ColumnChooserComponent_div_14_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 17);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const item_r5 = ctx.$implicit;
    const ctx_r3 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", ctx_r3.getColumnLabel(item_r5.label), " ");
} }
const _c0$H = function (a0) { return [a0]; };
class ColumnChooserComponent {
    constructor(appState, languageStore, modal) {
        this.appState = appState;
        this.languageStore = languageStore;
        this.modal = modal;
        this.titleKey = 'LBL_COLUMN_SELECTOR_MODAL_TITLE';
    }
    drop(event) {
        if (event.previousContainer === event.container) {
            moveItemInArray(event.container.data, event.previousIndex, event.currentIndex);
        }
        else {
            transferArrayItem(event.previousContainer.data, event.container.data, event.previousIndex, event.currentIndex);
        }
    }
    getHeaderLabel() {
        return this.languageStore.getFieldLabel('LBL_COLUMN_SELECTOR_MODAL_TITLE');
    }
    getColumnLabel(label) {
        return this.languageStore.getFieldLabel(label, this.appState.getModule());
    }
    ngOnInit() {
        this.closeButtonIcon = {
            klass: ['btn', 'btn-outline-light', 'btn-sm'],
            onClick: () => {
                this.modal.close({
                    type: 'close-button'
                });
            }
        };
        this.closeButton = {
            klass: ['btn', 'modal-button-cancel'],
            labelKey: 'LBL_COLUMN_SELECTOR_CLOSE_BUTTON',
            onClick: () => {
                this.modal.close({
                    type: 'close-button'
                });
            }
        };
        this.saveButton = {
            klass: ['btn', 'modal-button-save'],
            labelKey: 'LBL_COLUMN_SELECTOR_SAVE_BUTTON',
            onClick: () => {
                this.modal.close({
                    type: 'close-button',
                    displayed: this.displayed,
                    hidden: this.hidden
                });
            }
        };
    }
    static { this.ɵfac = function ColumnChooserComponent_Factory(t) { return new (t || ColumnChooserComponent)(i0.ɵɵdirectiveInject(AppStateStore), i0.ɵɵdirectiveInject(LanguageStore), i0.ɵɵdirectiveInject(i3$1.NgbActiveModal)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ColumnChooserComponent, selectors: [["scrm-columnchooser"]], inputs: { displayed: "displayed", hidden: "hidden" }, decls: 19, vars: 16, consts: [["klass", "column-chooser-modal", 3, "closable", "close", "title", "titleKey"], ["modal-body", ""], [1, "d-flex", "bd-highlight"], [1, "p-2", "flex-fill", "bd-highlight", "column-chooser-container"], [1, "column-chooser-title"], ["labelKey", "LBL_COLUMN_SELECTOR_DISPLAYED_COLS"], ["cdkDropList", "", 1, "column-chooser-list", 3, "cdkDropListData", "cdkDropListConnectedTo", "cdkDropListDropped"], ["displayedList", "cdkDropList"], ["class", "column-chooser-item column-displayed", "cdkDrag", "", 4, "ngFor", "ngForOf"], ["labelKey", "LBL_COLUMN_SELECTOR_HIDDEN_COLS"], ["hiddenList", "cdkDropList"], ["class", "column-chooser-item column-hidden", "cdkDrag", "", 4, "ngFor", "ngForOf"], ["modal-footer", ""], [1, "modal-buttons"], ["data-dismiss", "modal", 3, "config"], [3, "config"], ["cdkDrag", "", 1, "column-chooser-item", "column-displayed"], ["cdkDrag", "", 1, "column-chooser-item", "column-hidden"]], template: function ColumnChooserComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "scrm-modal", 0)(1, "div", 1)(2, "div", 2)(3, "div", 3)(4, "h2", 4);
            i0.ɵɵelement(5, "scrm-label", 5);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(6, "div", 6, 7);
            i0.ɵɵlistener("cdkDropListDropped", function ColumnChooserComponent_Template_div_cdkDropListDropped_6_listener($event) { return ctx.drop($event); });
            i0.ɵɵtemplate(8, ColumnChooserComponent_div_8_Template, 2, 1, "div", 8);
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(9, "div", 3)(10, "h2", 4);
            i0.ɵɵelement(11, "scrm-label", 9);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(12, "div", 6, 10);
            i0.ɵɵlistener("cdkDropListDropped", function ColumnChooserComponent_Template_div_cdkDropListDropped_12_listener($event) { return ctx.drop($event); });
            i0.ɵɵtemplate(14, ColumnChooserComponent_div_14_Template, 2, 1, "div", 11);
            i0.ɵɵelementEnd()()()();
            i0.ɵɵelementStart(15, "div", 12)(16, "div", 13);
            i0.ɵɵelement(17, "scrm-button", 14)(18, "scrm-button", 15);
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            const _r0 = i0.ɵɵreference(7);
            const _r2 = i0.ɵɵreference(13);
            i0.ɵɵproperty("closable", true)("close", ctx.closeButtonIcon)("title", ctx.getHeaderLabel())("titleKey", ctx.titleKey);
            i0.ɵɵadvance(6);
            i0.ɵɵproperty("cdkDropListData", ctx.displayed)("cdkDropListConnectedTo", i0.ɵɵpureFunction1(12, _c0$H, _r2));
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngForOf", ctx.displayed);
            i0.ɵɵadvance(4);
            i0.ɵɵproperty("cdkDropListData", ctx.hidden)("cdkDropListConnectedTo", i0.ɵɵpureFunction1(14, _c0$H, _r0));
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngForOf", ctx.hidden);
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("config", ctx.closeButton);
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("config", ctx.saveButton);
        } }, dependencies: [i2.NgForOf, i5.CdkDropList, i5.CdkDrag, ModalComponent, LabelComponent, ButtonComponent], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ColumnChooserComponent, [{
        type: Component,
        args: [{ selector: 'scrm-columnchooser', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n\n<scrm-modal\n    [closable]=\"true\"\n    [close]=\"closeButtonIcon\"\n    [title]=\"getHeaderLabel()\"\n    [titleKey]=\"titleKey\"\n    klass=\"column-chooser-modal\">\n\n    <div modal-body>\n\n        <div class=\"d-flex bd-highlight\">\n            <div class=\"p-2 flex-fill bd-highlight column-chooser-container\">\n                <h2 class=\"column-chooser-title\">\n                    <scrm-label labelKey=\"LBL_COLUMN_SELECTOR_DISPLAYED_COLS\"></scrm-label>\n                </h2>\n\n                <div\n                    cdkDropList\n                    #displayedList=\"cdkDropList\"\n                    [cdkDropListData]=\"displayed\"\n                    [cdkDropListConnectedTo]=\"[hiddenList]\"\n                    class=\"column-chooser-list\"\n                    (cdkDropListDropped)=\"drop($event)\">\n                    <div class=\"column-chooser-item column-displayed\" *ngFor=\"let item of displayed\"\n                         cdkDrag>\n                        {{getColumnLabel(item.label)}}\n                    </div>\n                </div>\n            </div>\n            <div class=\"p-2 flex-fill bd-highlight column-chooser-container\">\n                <h2 class=\"column-chooser-title\">\n                    <scrm-label labelKey=\"LBL_COLUMN_SELECTOR_HIDDEN_COLS\"></scrm-label>\n                </h2>\n\n                <div\n                    cdkDropList\n                    #hiddenList=\"cdkDropList\"\n                    [cdkDropListData]=\"hidden\"\n                    [cdkDropListConnectedTo]=\"[displayedList]\"\n                    class=\"column-chooser-list\"\n                    (cdkDropListDropped)=\"drop($event)\">\n                    <div class=\"column-chooser-item column-hidden\" *ngFor=\"let item of hidden\" cdkDrag>\n                        {{getColumnLabel(item.label)}}\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n\n    <div modal-footer>\n        <div class=\"modal-buttons\">\n            <scrm-button data-dismiss=\"modal\" [config]=\"closeButton\"></scrm-button>\n            <scrm-button [config]=\"saveButton\"></scrm-button>\n        </div>\n    </div>\n\n</scrm-modal>\n" }]
    }], function () { return [{ type: AppStateStore }, { type: LanguageStore }, { type: i3$1.NgbActiveModal }]; }, { displayed: [{
            type: Input
        }], hidden: [{
            type: Input
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class ModalModule {
    static { this.ɵfac = function ModalModule_Factory(t) { return new (t || ModalModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: ModalModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            AngularSvgIconModule,
            CloseButtonModule,
            LabelModule,
            NgbModalModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ModalModule, [{
        type: NgModule,
        args: [{
                declarations: [ModalComponent],
                exports: [ModalComponent],
                imports: [
                    CommonModule,
                    AngularSvgIconModule,
                    CloseButtonModule,
                    LabelModule,
                    NgbModalModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(ModalModule, { declarations: [ModalComponent], imports: [CommonModule,
        AngularSvgIconModule,
        CloseButtonModule,
        LabelModule,
        NgbModalModule], exports: [ModalComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class ColumnChooserModule {
    static { this.ɵfac = function ColumnChooserModule_Factory(t) { return new (t || ColumnChooserModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: ColumnChooserModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            DragDropModule,
            CloseButtonModule,
            ModalModule,
            LabelModule,
            ButtonModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ColumnChooserModule, [{
        type: NgModule,
        args: [{
                declarations: [ColumnChooserComponent],
                exports: [ColumnChooserComponent],
                imports: [
                    CommonModule,
                    DragDropModule,
                    CloseButtonModule,
                    ModalModule,
                    LabelModule,
                    ButtonModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(ColumnChooserModule, { declarations: [ColumnChooserComponent], imports: [CommonModule,
        DragDropModule,
        CloseButtonModule,
        ModalModule,
        LabelModule,
        ButtonModule], exports: [ColumnChooserComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class BaseFieldGridComponent {
    constructor(breakpointObserver) {
        this.breakpointObserver = breakpointObserver;
        this.special = false;
        this.actions = false;
        this.appendActions = false;
        this.labelDisplay = 'top';
        this.labelClass = {};
        this.inputClass = {};
        this.rowClass = {};
        this.colClass = {};
        this.colAlignItems = '';
        this.sizeMap = {
            handset: 1,
            tablet: 2,
            web: 3,
            wide: 4
        };
        this.baseColClass = {
            col: true,
            'form-group': true,
            'm-1': true
        };
        this.baseRowClass = {
            'form-row': true,
            'align-items-center': true
        };
        this.baseLabelClass = {
            'col-form-label-sm': true,
            'mb-0': true,
        };
        this.baseInputClass = {
            'form-control': true,
            'form-control-sm': true,
        };
        this.currentSize = 'web';
        this.subscriptions = [];
    }
    ngOnInit() {
        this.initScreenSizeObserver(this.breakpointObserver);
        this.buildGrid();
        this.colClass = {
            ...this.colClass,
            ...this.baseColClass
        };
        this.rowClass = {
            ...this.baseRowClass,
            ...this.rowClass
        };
        this.labelClass = {
            ...this.labelClass,
            ...this.baseLabelClass
        };
        this.inputClass = {
            ...this.inputClass,
            ...this.baseInputClass
        };
    }
    ngOnDestroy() {
        this.subscriptions.forEach(sub => sub.unsubscribe());
    }
    get colNumber() {
        const max = this.sizeMap[this.currentSize];
        if (this.maxColumns && max > this.maxColumns) {
            return this.maxColumns;
        }
        return max;
    }
    addSpecialSlots(grid) {
        if (!grid || grid.length === 0) {
            return;
        }
        const neededSlots = this.getNeededExtraSlots();
        if (neededSlots.length === 0) {
            return;
        }
        if (this.colNumber === 1) {
            neededSlots.reverse().forEach(type => {
                const newRow = {
                    cols: []
                };
                this.fillRow(newRow);
                grid.push(newRow);
                newRow.cols[0][type] = true;
            });
        }
        else if (this.appendActions === true) {
            const lastRow = grid[grid.length - 1];
            const place = this.colNumber - 1;
            neededSlots.forEach(type => {
                lastRow.cols[place][type] = true;
            });
        }
        else {
            const lastNeededCol = this.colNumber - neededSlots.length;
            let lastRow = grid[grid.length - 1];
            if (lastRow.cols[lastNeededCol].field) {
                lastRow = {
                    cols: []
                };
                this.fillRow(lastRow);
                grid.push(lastRow);
            }
            let place = this.colNumber - 1;
            neededSlots.forEach(type => {
                lastRow.cols[place][type] = true;
                place--;
            });
        }
    }
    getNeededExtraSlots() {
        const neededSlots = [];
        if (this.actions) {
            neededSlots.push('actionSlot');
        }
        if (this.special) {
            neededSlots.push('specialSlot');
        }
        return neededSlots;
    }
    fillRow(row) {
        const len = row.cols.length;
        for (let i = len; i < this.colNumber; i++) {
            row.cols.push({ field: { type: '', display: 'none' } });
        }
    }
    initScreenSizeObserver(breakpointObserver) {
        this.subscriptions.push(breakpointObserver.observe([
            Breakpoints.HandsetPortrait,
        ]).subscribe((result) => {
            if (result.matches) {
                this.currentSize = 'handset';
                this.buildGrid();
            }
        }));
        this.subscriptions.push(breakpointObserver.observe([
            Breakpoints.TabletPortrait,
            Breakpoints.Small
        ]).subscribe((result) => {
            if (result.matches) {
                this.currentSize = 'tablet';
                this.buildGrid();
            }
        }));
        this.subscriptions.push(breakpointObserver.observe([
            Breakpoints.TabletLandscape,
            Breakpoints.WebLandscape,
        ]).subscribe((result) => {
            if (result.matches) {
                this.currentSize = 'web';
                this.buildGrid();
            }
        }));
        this.subscriptions.push(breakpointObserver.observe([
            Breakpoints.XLarge,
        ]).subscribe((result) => {
            if (result.matches) {
                this.currentSize = 'wide';
                this.buildGrid();
            }
        }));
    }
    static { this.ɵfac = function BaseFieldGridComponent_Factory(t) { return new (t || BaseFieldGridComponent)(i0.ɵɵdirectiveInject(i1$1.BreakpointObserver)); }; }
    static { this.ɵdir = /*@__PURE__*/ i0.ɵɵdefineDirective({ type: BaseFieldGridComponent, inputs: { special: "special", actions: "actions", appendActions: "appendActions", labelDisplay: "labelDisplay", labelClass: "labelClass", inputClass: "inputClass", rowClass: "rowClass", colClass: "colClass", colAlignItems: "colAlignItems", maxColumns: "maxColumns", sizeMap: "sizeMap" } }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseFieldGridComponent, [{
        type: Directive
    }], function () { return [{ type: i1$1.BreakpointObserver }]; }, { special: [{
            type: Input
        }], actions: [{
            type: Input
        }], appendActions: [{
            type: Input
        }], labelDisplay: [{
            type: Input
        }], labelClass: [{
            type: Input
        }], inputClass: [{
            type: Input
        }], rowClass: [{
            type: Input
        }], colClass: [{
            type: Input
        }], colAlignItems: [{
            type: Input
        }], maxColumns: [{
            type: Input
        }], sizeMap: [{
            type: Input
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class BaseActionManager {
    constructor() {
        this.actions = {
            edit: {},
            create: {},
            list: {},
            detail: {},
            massupdate: {},
            filter: {}
        };
    }
    run(action, mode, data) {
        if (!this.actions || !this.actions[mode] || !this.actions[mode][action.key]) {
            return;
        }
        this.actions[mode][action.key].run(data, action);
    }
    getHandler(action, mode) {
        let handlerKey = action.key;
        if (action && action.asyncProcess) {
            handlerKey = 'async-process';
        }
        if (!this.actions || !this.actions[mode] || !this.actions[mode][handlerKey]) {
            return null;
        }
        return this.actions[mode][handlerKey];
    }
    addHandler(action, mode, handler) {
        if (!this.actions[mode]) {
            this.actions[mode] = {};
        }
        this.actions[mode][action.key] = handler;
    }
    static { this.ɵfac = function BaseActionManager_Factory(t) { return new (t || BaseActionManager)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: BaseActionManager, factory: BaseActionManager.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseActionManager, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], null, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class FieldLogicActionHandler extends ActionHandler {
    shouldDisplay(data) {
        return true;
    }
    ;
    getTriggeringStatus() {
        return ['onValueChange'];
    }
}

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2023 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class ConditionOperatorActionHandler {
}

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2023 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class GreaterThanAction extends ConditionOperatorActionHandler {
    constructor() {
        super();
        this.key = 'greater-than';
    }
    run(record, field, opsConfig) {
        const comparisonValue = opsConfig.field ? record.fields[opsConfig.field].value : opsConfig.value;
        return Number(field.value) > Number(comparisonValue);
    }
    static { this.ɵfac = function GreaterThanAction_Factory(t) { return new (t || GreaterThanAction)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: GreaterThanAction, factory: GreaterThanAction.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GreaterThanAction, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return []; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2023 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class LessThanAction extends ConditionOperatorActionHandler {
    constructor() {
        super();
        this.key = 'less-than';
    }
    run(record, field, opsConfig) {
        const comparisonValue = opsConfig.field ? record.fields[opsConfig.field].value : opsConfig.value;
        return Number(field.value) < Number(comparisonValue);
    }
    static { this.ɵfac = function LessThanAction_Factory(t) { return new (t || LessThanAction)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: LessThanAction, factory: LessThanAction.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LessThanAction, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return []; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2023 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class NotEmptyAction extends ConditionOperatorActionHandler {
    constructor() {
        super();
        this.key = 'not-empty';
    }
    run(record, field, opsConfig) {
        if (!isEmptyString(field.value)) {
            return true;
        }
        return false;
    }
    static { this.ɵfac = function NotEmptyAction_Factory(t) { return new (t || NotEmptyAction)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: NotEmptyAction, factory: NotEmptyAction.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(NotEmptyAction, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return []; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2023 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class IsEmptyAction extends ConditionOperatorActionHandler {
    constructor() {
        super();
        this.key = 'is-empty';
    }
    run(record, field, opsConfig) {
        if (isEmptyString(field.value)) {
            return true;
        }
        return false;
    }
    static { this.ɵfac = function IsEmptyAction_Factory(t) { return new (t || IsEmptyAction)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: IsEmptyAction, factory: IsEmptyAction.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(IsEmptyAction, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return []; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2023 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class IsEqualAction extends ConditionOperatorActionHandler {
    constructor() {
        super();
        this.key = 'is-equal';
    }
    run(record, field, opsConfig) {
        let comparisonValue = null;
        if (this.compareToField(opsConfig)) {
            comparisonValue = this.getFieldComparisonValue(record, opsConfig);
        }
        else {
            comparisonValue = this.getStaticComparisonValue(opsConfig);
        }
        if (comparisonValue) {
            return comparisonValue.includes(field.value.toString());
        }
        return false;
    }
    getFieldComparisonValue(record, opsConfig) {
        return [record.fields[opsConfig.field]?.value];
    }
    getStaticComparisonValue(opsConfig) {
        if (Array.isArray(opsConfig.values)) {
            return opsConfig.values.map(value => value?.toString());
        }
        return [opsConfig.value].map(value => value?.toString());
    }
    compareToField(opsConfig) {
        if (opsConfig?.field) {
            return true;
        }
        return false;
    }
    static { this.ɵfac = function IsEqualAction_Factory(t) { return new (t || IsEqualAction)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: IsEqualAction, factory: IsEqualAction.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(IsEqualAction, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return []; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2023 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class NotEqualAction extends ConditionOperatorActionHandler {
    constructor() {
        super();
        this.key = 'not-equal';
    }
    run(record, field, opsConfig) {
        const comparisonValue = opsConfig.field ? [record.fields[opsConfig.field].value] : (Array.isArray(opsConfig.values) ? opsConfig.values : [opsConfig.value]).map(value => value.toString());
        if (comparisonValue) {
            return !comparisonValue.includes(field.value.toString());
        }
        return false;
    }
    static { this.ɵfac = function NotEqualAction_Factory(t) { return new (t || NotEqualAction)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: NotEqualAction, factory: NotEqualAction.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(NotEqualAction, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return []; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2023 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class ConditionOperatorManager {
    constructor(greaterThanAction, lessThanAction, notEmptyAction, isEmptyAction, isEqualAction, notEqualAction) {
        this.greaterThanAction = greaterThanAction;
        this.lessThanAction = lessThanAction;
        this.notEmptyAction = notEmptyAction;
        this.isEmptyAction = isEmptyAction;
        this.isEqualAction = isEqualAction;
        this.notEqualAction = notEqualAction;
    }
    get(key) {
        const operatorMap = {
            'greater-than': this.greaterThanAction,
            'less-than': this.lessThanAction,
            'not-empty': this.notEmptyAction,
            'is-empty': this.isEmptyAction,
            'is-equal': this.isEqualAction,
            'not-equal': this.notEqualAction,
        };
        return operatorMap[key];
    }
    static { this.ɵfac = function ConditionOperatorManager_Factory(t) { return new (t || ConditionOperatorManager)(i0.ɵɵinject(GreaterThanAction), i0.ɵɵinject(LessThanAction), i0.ɵɵinject(NotEmptyAction), i0.ɵɵinject(IsEmptyAction), i0.ɵɵinject(IsEqualAction), i0.ɵɵinject(NotEqualAction)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ConditionOperatorManager, factory: ConditionOperatorManager.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ConditionOperatorManager, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: GreaterThanAction }, { type: LessThanAction }, { type: NotEmptyAction }, { type: IsEmptyAction }, { type: IsEqualAction }, { type: NotEqualAction }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
/**
 * @DEPRECATED
 */
class FieldLogicDisplayTypeAction extends FieldLogicActionHandler {
    constructor(operatorManager) {
        super();
        this.operatorManager = operatorManager;
        this.key = 'displayType';
        this.modes = ['edit', 'detail', 'list', 'create', 'massupdate', 'filter'];
    }
    run(data, action) {
        const record = data.record;
        const field = data.field;
        if (!record || !field) {
            return;
        }
        const activeOnFields = (action.params && action.params.activeOnFields) || {};
        const relatedFields = Object.keys(activeOnFields);
        const activeOnAttributes = (action.params && action.params.activeOnAttributes) || {};
        const relatedAttributesFields = Object.keys(activeOnAttributes);
        if (!relatedFields.length && !relatedAttributesFields.length) {
            return;
        }
        const targetDisplay = action.params && action.params.targetDisplayType;
        if (!targetDisplay) {
            return;
        }
        let isActive = this.isActive(relatedFields, record, activeOnFields, relatedAttributesFields, activeOnAttributes);
        let display = data.field.defaultDisplay;
        if (isActive) {
            display = targetDisplay;
        }
        data.field.display = display;
        const resetOn = (action.params && action.params.resetOn) || 'none';
        if (resetOn === display) {
            if (data.field.valueList && data.field.valueList.length) {
                data.field.valueList = [];
            }
            if (data.field.value) {
                data.field.value = '';
            }
        }
    }
    /**
     * Check if any of the configured values is currently set
     * @param {array} relatedFields
     * @param {object} record
     * @param {object} activeOnFields
     * @param {array} relatedAttributesFields
     * @param {object} activeOnAttributes
     */
    isActive(relatedFields, record, activeOnFields, relatedAttributesFields, activeOnAttributes) {
        let isActive = false;
        if (!isActive && !isEmpty(activeOnFields)) {
            isActive = this.areFieldsActive(relatedFields, record, activeOnFields);
        }
        if (!isActive && !isEmpty(activeOnAttributes)) {
            isActive = this.areAttributesActive(relatedAttributesFields, record, activeOnAttributes);
        }
        return isActive;
    }
    /**
     * Are attributes active
     * @param {array} relatedAttributesFields
     * @param {object} record
     * @param {object} activeOnAttributes
     */
    areAttributesActive(relatedAttributesFields, record, activeOnAttributes) {
        return relatedAttributesFields.some(fieldKey => {
            const fields = record.fields;
            const field = (fields && record.fields[fieldKey]) || null;
            const attributes = activeOnAttributes[fieldKey] && Object.keys(activeOnAttributes[fieldKey]);
            if (!field || !attributes || !attributes.length) {
                return;
            }
            return attributes.some(attributeKey => {
                const activeValues = activeOnAttributes[fieldKey][attributeKey];
                const attribute = field.attributes && field.attributes[attributeKey];
                if (!activeValues || !activeValues.length || !attribute) {
                    return;
                }
                return this.isValueActive(record, attribute, activeValues);
            });
        });
    }
    /**
     * Are fields active
     * @param {array} relatedFields
     * @param {object} record
     * @param {object} activeOnFields
     */
    areFieldsActive(relatedFields, record, activeOnFields) {
        return relatedFields.every(fieldKey => {
            const fields = record.fields;
            const field = (fields && record.fields[fieldKey]) || null;
            const activeValues = activeOnFields[fieldKey];
            if (!field || !activeValues || !activeValues.length) {
                return;
            }
            return this.isValueActive(record, field, activeValues);
        });
    }
    /**
     * Is value active
     * @param record
     * @param {object} field
     * @param {array} activeValues
     */
    isValueActive(record, field, activeValues) {
        let isActive = false;
        if (field.valueList && field.valueList.length) {
            field.valueList.some(value => {
                return activeValues.some(activeValue => {
                    if (activeValue === value) {
                        isActive = true;
                        return true;
                    }
                });
            });
            return isActive;
        }
        const fields = Object.keys(record.fields);
        let opsArr = [];
        if (field.value) {
            activeValues.some(activeValue => {
                if (activeValue.field && !fields.includes(activeValue.field)) {
                    return;
                }
                if (activeValue === field.value && !activeValue.operator) {
                    isActive = true;
                }
                if (activeValue.operator) {
                    const operatorKey = activeValue.operator;
                    const operator = this.operatorManager.get(operatorKey);
                    opsArr.push(operator.run(record, field, activeValue));
                    isActive = opsArr.every(data => data);
                }
            });
        }
        else {
            activeValues.some(activeValue => {
                if (activeValue.operator) {
                    if (activeValue.field && !fields.includes(activeValue.field)) {
                        return;
                    }
                    const operatorKey = activeValue.operator;
                    const operator = this.operatorManager.get(operatorKey);
                    opsArr.push(operator.run(record, field, activeValue));
                    isActive = opsArr.every(data => data);
                }
            });
        }
        return isActive;
    }
    getTriggeringStatus() {
        return ['onValueChange', 'onFieldInitialize'];
    }
    static { this.ɵfac = function FieldLogicDisplayTypeAction_Factory(t) { return new (t || FieldLogicDisplayTypeAction)(i0.ɵɵinject(ConditionOperatorManager)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: FieldLogicDisplayTypeAction, factory: FieldLogicDisplayTypeAction.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FieldLogicDisplayTypeAction, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: ConditionOperatorManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class EmailPrimarySelectAction extends FieldLogicActionHandler {
    constructor() {
        super();
        this.key = 'emailPrimarySelect';
        this.modes = ['edit', 'create', 'massupdate'];
    }
    run(data, action) {
        const record = data.record;
        const field = data.field;
        if (!record || !field) {
            return;
        }
        const items = field.items;
        if (!field || !items || !items.length) {
            return;
        }
        const activeItems = items.filter(item => !(item && item.attributes && item.attributes.deleted));
        // Auto-select the primary, only when the number of displayed rows equal to one;
        // This logic applies either via Add or Remove
        if (activeItems && activeItems.length !== 1) {
            return;
        }
        const item = activeItems[0];
        const emailField = (item.fields && item.fields['email-fields']) || {};
        const primary = (emailField.attributes && emailField.attributes['primary_address']) || null;
        if (primary && !isTrue(primary.value)) {
            primary.value = 'true';
            primary.formControl.setValue('true');
            // re-validate the parent form-control after value update
            emailField.formControl.updateValueAndValidity({ onlySelf: true, emitEvent: true });
        }
    }
    static { this.ɵfac = function EmailPrimarySelectAction_Factory(t) { return new (t || EmailPrimarySelectAction)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: EmailPrimarySelectAction, factory: EmailPrimarySelectAction.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EmailPrimarySelectAction, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return []; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
const requiredValidator = (utils) => ((control) => {
    if (utils.isEmptyTrimmedInputValue(control.value)) {
        return {
            required: {
                required: true,
                message: {
                    labelKey: 'LBL_VALIDATION_ERROR_REQUIRED',
                    context: {
                        value: control.value
                    }
                }
            }
        };
    }
    return null;
});
const booleanRequiredValidator = (utils) => ((control) => {
    if (utils.isEmptyBooleanInputValue(control.value)) {
        return {
            required: {
                required: true,
                message: {
                    labelKey: 'LBL_VALIDATION_ERROR_REQUIRED',
                    context: {
                        value: control.value
                    }
                }
            }
        };
    }
    return null;
});
const multienumRequiredValidator = (viewField, record, utils) => ((control) => {
    const name = viewField.name || '';
    if (!name || !record || !record.fields) {
        return null;
    }
    const field = record?.fields[name] ?? {};
    if (!field) {
        return null;
    }
    const activeItems = field.valueList;
    if (activeItems && activeItems.length > 0) {
        return null;
    }
    return {
        required: {
            required: true,
            message: {
                labelKey: 'LBL_VALIDATION_ERROR_REQUIRED',
                context: {}
            }
        }
    };
});
class RequiredValidator {
    constructor(utils) {
        this.utils = utils;
    }
    applies(record, viewField) {
        if (!viewField || !viewField.fieldDefinition) {
            return false;
        }
        const viewFieldType = viewField?.type ?? null;
        const fieldDefinitionType = viewField?.fieldDefinition?.type ?? null;
        if (viewFieldType === 'line-items' || fieldDefinitionType === 'line-items') {
            return false;
        }
        return isTrue(viewField.fieldDefinition.required);
    }
    getValidator(viewField, record) {
        const type = viewField?.type ?? viewField?.fieldDefinition?.type ?? '';
        if (type === 'boolean') {
            return [booleanRequiredValidator(this.utils)];
        }
        if (type === 'multienum') {
            return [multienumRequiredValidator(viewField, record, this.utils)];
        }
        return [requiredValidator(this.utils)];
    }
    static { this.ɵfac = function RequiredValidator_Factory(t) { return new (t || RequiredValidator)(i0.ɵɵinject(FormControlUtils)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: RequiredValidator, factory: RequiredValidator.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RequiredValidator, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: FormControlUtils }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2023 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class ActiveFieldsChecker {
    constructor(operatorManager) {
        this.operatorManager = operatorManager;
    }
    /**
     * Check if any of the configured values is currently set
     * @param {array} relatedFields
     * @param {object} record
     * @param {object} activeOnFields
     * @param {array} relatedAttributesFields
     * @param {object} activeOnAttributes
     */
    isActive(relatedFields, record, activeOnFields, relatedAttributesFields, activeOnAttributes) {
        let isActive = true;
        if (!isEmpty(activeOnFields)) {
            isActive = this.areFieldsActive(relatedFields, record, activeOnFields);
        }
        if (!isEmpty(activeOnAttributes)) {
            isActive = isActive && this.areAttributesActive(relatedAttributesFields, record, activeOnAttributes);
        }
        return isActive;
    }
    /**
     * Are attributes active
     * @param {array} relatedAttributesFields
     * @param {object} record
     * @param {object} activeOnAttributes
     */
    areAttributesActive(relatedAttributesFields, record, activeOnAttributes) {
        return relatedAttributesFields.every(fieldKey => {
            const fields = record.fields;
            const field = (fields && record.fields[fieldKey]) || null;
            const attributes = activeOnAttributes[fieldKey] && Object.keys(activeOnAttributes[fieldKey]);
            if (!field || !attributes || !attributes.length) {
                return;
            }
            return attributes.some(attributeKey => {
                const activeValues = activeOnAttributes[fieldKey][attributeKey];
                const attribute = field.attributes && field.attributes[attributeKey];
                if (!activeValues || !activeValues.length || !attribute) {
                    return;
                }
                return this.isValueActive(record, attribute, activeValues);
            });
        });
    }
    /**
     * Are fields active
     * @param {array} relatedFields
     * @param {object} record
     * @param {object} activeOnFields
     */
    areFieldsActive(relatedFields, record, activeOnFields) {
        return relatedFields.every(fieldKey => {
            const fields = record.fields;
            const field = (fields && record.fields[fieldKey]) || null;
            const activeValues = activeOnFields[fieldKey];
            if (!field || !activeValues || !activeValues.length) {
                return true;
            }
            return this.isValueActive(record, field, activeValues);
        });
    }
    /**
     * Is value active
     * @param {object} record
     * @param {object} field
     * @param {array} activeValues
     */
    isValueActive(record, field, activeValues) {
        let isActive = false;
        if (field.valueList && field.valueList.length) {
            field.valueList.some(value => {
                return activeValues.some(activeValue => {
                    if (activeValue === value) {
                        isActive = true;
                        return true;
                    }
                });
            });
            return isActive;
        }
        const fields = Object.keys(record.fields);
        let opsArr = [];
        activeValues.some(activeValue => {
            if (activeValue.field && !fields.includes(activeValue.field)) {
                return;
            }
            if (isTrue(activeValue) || isFalse(activeValue)) {
                isActive = activeValue.toString() === field.value.toString();
                return;
            }
            const operatorKey = activeValue?.operator ?? 'is-equal';
            if (typeof activeValue === 'string') {
                activeValue = {
                    operator: operatorKey,
                    values: [activeValue]
                };
            }
            const operator = this.operatorManager.get(operatorKey);
            opsArr.push(operator.run(record, field, activeValue));
            isActive = opsArr.every(data => data);
        });
        return isActive;
    }
    static { this.ɵfac = function ActiveFieldsChecker_Factory(t) { return new (t || ActiveFieldsChecker)(i0.ɵɵinject(ConditionOperatorManager)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ActiveFieldsChecker, factory: ActiveFieldsChecker.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ActiveFieldsChecker, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: ConditionOperatorManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class RequiredAction extends FieldLogicActionHandler {
    constructor(requiredValidator, activeFieldsChecker) {
        super();
        this.requiredValidator = requiredValidator;
        this.activeFieldsChecker = activeFieldsChecker;
        this.key = 'required';
        this.modes = ['edit', 'create', 'massupdate', 'filter'];
    }
    run(data, action) {
        const record = data.record;
        const field = data.field;
        if (!record || !field) {
            return;
        }
        const activeOnFields = (action.params && action.params.activeOnFields) || {};
        const relatedFields = Object.keys(activeOnFields);
        const activeOnAttributes = (action.params && action.params.activeOnAttributes) || {};
        const relatedAttributesFields = Object.keys(activeOnAttributes);
        if (!relatedFields.length && !relatedAttributesFields.length) {
            return;
        }
        const isActive = this.activeFieldsChecker.isActive(relatedFields, record, activeOnFields, relatedAttributesFields, activeOnAttributes);
        let required = false;
        let validators = [...data.field.validators || []];
        if (isActive) {
            required = true;
            validators = validators.concat(this.requiredValidator.getValidator(field, record));
        }
        data.field.formControl.updateValueAndValidity({ onlySelf: true, emitEvent: true });
        record.formGroup.updateValueAndValidity({ onlySelf: true, emitEvent: true });
        data.field.definition.required = required;
        data.field.formControl.setValidators(validators);
        data.field.formControl.updateValueAndValidity({ onlySelf: true, emitEvent: true });
        record.formGroup.updateValueAndValidity({ onlySelf: true, emitEvent: true });
    }
    getTriggeringStatus() {
        return ['onValueChange', 'onFieldInitialize'];
    }
    static { this.ɵfac = function RequiredAction_Factory(t) { return new (t || RequiredAction)(i0.ɵɵinject(RequiredValidator), i0.ɵɵinject(ActiveFieldsChecker)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: RequiredAction, factory: RequiredAction.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RequiredAction, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: RequiredValidator }, { type: ActiveFieldsChecker }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class CurrencyService {
    constructor(config, preferences) {
        this.config = config;
        this.preferences = preferences;
    }
    getFieldCurrencyValue(field, record) {
        const isBase = this.isBase(field);
        const currencyId = this.getCurrencyId(record);
        if (!isBase && currencyId !== null) {
            return field.value;
        }
        const value = parseFloat(field.value);
        if (!isFinite(value)) {
            return field.value;
        }
        const userCurrency = this.getUserCurrency();
        return this.baseToCurrency(userCurrency.id, value).toString();
    }
    baseToCurrency(currencyId, value) {
        const conversionRate = this.getConversionRate(currencyId);
        if (!isFinite(conversionRate)) {
            return value;
        }
        return this.round(multiply(value, conversionRate));
    }
    currencyToBase(currencyId, value) {
        const conversionRate = this.getConversionRate(currencyId);
        if (!isFinite(conversionRate)) {
            return value;
        }
        return this.round(divide(value, conversionRate));
    }
    round(value) {
        const precision = this.getPrecision();
        return round(value, precision);
    }
    getCurrencyId(record) {
        return record?.fields?.currency_id?.value ?? null;
    }
    isBase(field) {
        return field?.metadata?.isBaseCurrency ?? false;
    }
    getCurrency(id) {
        const currencies = this.config.getConfigValue('currencies');
        return currencies[id] ?? [];
    }
    getBaseCurrency() {
        return this.config.getConfigValue('currency');
    }
    getUserCurrency() {
        return this.preferences.getUserPreference('currency');
    }
    getPrecision() {
        const userPrecision = parseInt(this.preferences.getUserPreference('default_currency_significant_digits'));
        if (isFinite(userPrecision)) {
            return userPrecision;
        }
        const systemPrecision = parseInt(this.config.getConfigValue('default_currency_significant_digits'));
        if (isFinite(systemPrecision)) {
            return systemPrecision;
        }
        return 0;
    }
    getConversionRate(id) {
        const currency = this.getCurrency(id);
        return parseFloat(currency['conversion_rate']);
    }
    getCode(id) {
        return this.getCurrency(id).iso4217;
    }
    getSymbol(id) {
        return this.getCurrency(id).symbol;
    }
    static { this.ɵfac = function CurrencyService_Factory(t) { return new (t || CurrencyService)(i0.ɵɵinject(SystemConfigStore), i0.ɵɵinject(UserPreferenceStore)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: CurrencyService, factory: CurrencyService.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CurrencyService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: SystemConfigStore }, { type: UserPreferenceStore }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class UpdateBaseCurrencyAction extends FieldLogicActionHandler {
    constructor(currencyService) {
        super();
        this.currencyService = currencyService;
        this.key = 'update-base-currency';
        this.modes = ['edit', 'create', 'massupdate', 'filter'];
    }
    run(data, action) {
        const record = data.record;
        const field = data.field;
        if (!record || !field) {
            return;
        }
        const currencyIdFieldName = action.params.currencyIdField ?? 'currency_id';
        const currencyFieldName = action.params.currencyField ?? 'amount';
        const currencyId = record?.fields[currencyIdFieldName]?.value ?? null;
        let value = parseFloat(record?.fields[currencyFieldName]?.value ?? null);
        if (!isFinite(value)) {
            return;
        }
        if (currencyId === null) {
            this.updateValue(field, value, record);
        }
        const baseValue = this.currencyService.currencyToBase(currencyId, value);
        if (!isFinite(baseValue)) {
            return;
        }
        this.updateValue(field, baseValue, record);
    }
    updateValue(field, baseValue, record) {
        field.value = baseValue.toString();
        field.formControl.setValue(baseValue.toString());
        // re-validate the parent form-control after value update
        record.formGroup.updateValueAndValidity({ onlySelf: true, emitEvent: true });
    }
    static { this.ɵfac = function UpdateBaseCurrencyAction_Factory(t) { return new (t || UpdateBaseCurrencyAction)(i0.ɵɵinject(CurrencyService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: UpdateBaseCurrencyAction, factory: UpdateBaseCurrencyAction.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(UpdateBaseCurrencyAction, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: CurrencyService }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class UpdateCurrencyAction extends FieldLogicActionHandler {
    constructor(currencyService) {
        super();
        this.currencyService = currencyService;
        this.key = 'update-currency';
        this.modes = ['edit', 'create', 'massupdate', 'filter'];
    }
    run(data, action) {
        const record = data.record;
        const field = data.field;
        const isBaseCurrency = field?.definition?.metadata?.isBaseCurrency ?? false;
        if (!record || !field || isBaseCurrency) {
            return;
        }
        const currencyIdFieldName = action.params.currencyIdField ?? 'currency_id';
        const baseCurrencyFieldName = action.params.baseCurrencyField ?? 'amount_usdollar';
        const currencyId = record?.fields[currencyIdFieldName]?.value ?? null;
        let value = parseFloat(field?.value ?? null);
        let baseValue = parseFloat(record?.fields[baseCurrencyFieldName]?.value ?? null);
        if (!isFinite(value) || !isFinite(baseValue) || currencyId === null) {
            return;
        }
        const newValue = this.currencyService.baseToCurrency(currencyId, baseValue);
        if (!isFinite(newValue)) {
            return;
        }
        this.updateValue(field, newValue, record);
    }
    updateValue(field, value, record) {
        field.value = value.toString();
        field.formControl.setValue(value.toString());
        // re-validate the parent form-control after value update
        record.formGroup.updateValueAndValidity({ onlySelf: true, emitEvent: true });
    }
    static { this.ɵfac = function UpdateCurrencyAction_Factory(t) { return new (t || UpdateCurrencyAction)(i0.ɵɵinject(CurrencyService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: UpdateCurrencyAction, factory: UpdateCurrencyAction.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(UpdateCurrencyAction, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: CurrencyService }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class UpdateFlexRelateModuleAction extends FieldLogicActionHandler {
    constructor() {
        super();
        this.key = 'update-flex-relate-module';
        this.modes = ['edit', 'create', 'massupdate', 'filter'];
    }
    run(data, action) {
        const record = data.record;
        const field = data.field;
        if (!record || !field) {
            return;
        }
        const typeField = field.definition.type_name ?? '';
        if (typeField === '') {
            return;
        }
        const type = record?.fields[typeField]?.value ?? '';
        const fieldModule = field?.definition?.module ?? '';
        if (type !== fieldModule) {
            field.definition.module = record?.fields[typeField]?.value ?? '';
            this.updateValue(field, {}, '', record);
        }
    }
    updateValue(field, valueObject, value, record) {
        field.value = value;
        field.valueObject = valueObject;
        field.formControl.setValue(value);
        // re-validate the parent form-control after value update
        record.formGroup.updateValueAndValidity({ onlySelf: true, emitEvent: true });
    }
    static { this.ɵfac = function UpdateFlexRelateModuleAction_Factory(t) { return new (t || UpdateFlexRelateModuleAction)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: UpdateFlexRelateModuleAction, factory: UpdateFlexRelateModuleAction.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(UpdateFlexRelateModuleAction, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return []; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2023 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class UpdateValueAction extends FieldLogicActionHandler {
    constructor(activeFieldsChecker) {
        super();
        this.activeFieldsChecker = activeFieldsChecker;
        this.key = 'updateValue';
        this.modes = ['edit', 'detail', 'list', 'create', 'massupdate', 'filter'];
    }
    run(data, action) {
        const record = data.record;
        const field = data.field;
        if (!record || !field) {
            return;
        }
        const activeOnFields = (action.params && action.params.activeOnFields) || {};
        const relatedFields = Object.keys(activeOnFields);
        const activeOnAttributes = (action.params && action.params.activeOnAttributes) || {};
        const relatedAttributesFields = Object.keys(activeOnAttributes);
        if (!relatedFields.length && !relatedAttributesFields.length) {
            return;
        }
        const targetValue = action.params && action.params.targetValue;
        if (!targetValue) {
            return;
        }
        const isActive = this.activeFieldsChecker.isActive(relatedFields, record, activeOnFields, relatedAttributesFields, activeOnAttributes);
        let value = data.field?.value;
        if (isActive) {
            value = targetValue;
        }
        this.updateValue(field, value.toString(), record);
    }
    /**
     * Update the new value
     * @param {object} field
     * @param {object} record
     */
    updateValue(field, value, record) {
        field.value = value.toString();
        field.formControl.setValue(value);
        // re-validate the parent form-control after value update
        record.formGroup.updateValueAndValidity({ onlySelf: true, emitEvent: true });
    }
    static { this.ɵfac = function UpdateValueAction_Factory(t) { return new (t || UpdateValueAction)(i0.ɵɵinject(ActiveFieldsChecker)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: UpdateValueAction, factory: UpdateValueAction.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(UpdateValueAction, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: ActiveFieldsChecker }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021-2023 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class MessageService {
    constructor(config) {
        this.config = config;
        this.messages = [];
        this.timeout = 3;
        this.messagesStage = new BehaviorSubject([]);
        this.messages$ = this.messagesStage.asObservable();
        this.initTimeOut();
    }
    updateState(messages) {
        this.messagesStage.next(this.messages = messages);
    }
    removeMessages() {
        this.updateState([]);
    }
    contains(message, remove = false) {
        let found = false;
        for (let i = 0; i < this.messages.length; i++) {
            if (!this.isSame(message, this.messages[i])) {
                continue;
            }
            found = true;
            if (remove) {
                const messages = [...this.messages];
                messages.splice(i, 1);
                this.updateState(messages);
            }
            break;
        }
        return found;
    }
    addMessage(message) {
        // push message only if it does not contains already...
        let ret = -1;
        if (!this.contains(message)) {
            const newMessages = [...this.messages];
            ret = newMessages.push(message);
            if (message.type === MessageTypes.success || message.type === MessageTypes.warning) {
                setTimeout(() => {
                    this.contains(message, true);
                }, this.timeout * 1000);
            }
            this.updateState(newMessages);
        }
        return ret;
    }
    addPrimaryMessage(text) {
        return this.addMessage({
            type: MessageTypes.primary,
            text
        });
    }
    addSecondaryMessage(text) {
        return this.addMessage({
            type: MessageTypes.secondary,
            text
        });
    }
    addSuccessMessage(text) {
        return this.addMessage({
            type: MessageTypes.success,
            text
        });
    }
    addSuccessMessageByKey(labelKey) {
        return this.addMessage({
            type: MessageTypes.success,
            labelKey
        });
    }
    addDangerMessage(text) {
        return this.addMessage({
            type: MessageTypes.danger,
            text
        });
    }
    addDangerMessageByKey(labelKey) {
        return this.addMessage({
            type: MessageTypes.danger,
            labelKey
        });
    }
    addWarningMessage(text) {
        return this.addMessage({
            type: MessageTypes.warning,
            text
        });
    }
    addWarningMessageByKey(labelKey) {
        return this.addMessage({
            type: MessageTypes.warning,
            labelKey
        });
    }
    addInfoMessage(text) {
        return this.addMessage({
            type: MessageTypes.info,
            text
        });
    }
    addDarkMessage(text) {
        return this.addMessage({
            type: MessageTypes.dark,
            text
        });
    }
    // --- LOG ---
    log(...args) {
        console.log.apply(console, args);
    }
    error(...args) {
        console.error.apply(console, args);
    }
    initTimeOut() {
        const ui = this.config.getConfigValue('ui');
        if (ui && ui.alert_timeout) {
            const parsed = parseInt(ui.alert_timeout, 10);
            if (!isNaN(parsed)) {
                this.timeout = parsed;
            }
        }
    }
    /**
     * Compare the text/labelKey on two messages. LabelKey always takes priority
     *
     * @param {Message} newMessage New Message
     * @param {Message} existingMessage Existing Message
     * @protected
     * @returns {boolean} True if is the same
     */
    isSame(newMessage, existingMessage) {
        let sourceField = 'text';
        if (newMessage.labelKey) {
            sourceField = 'labelKey';
        }
        return newMessage[sourceField] === existingMessage[sourceField];
    }
    static { this.ɵfac = function MessageService_Factory(t) { return new (t || MessageService)(i0.ɵɵinject(SystemConfigStore)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: MessageService, factory: MessageService.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MessageService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: SystemConfigStore }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class AsyncActionHandler {
}

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class RedirectAsyncAction extends AsyncActionHandler {
    constructor(router, message) {
        super();
        this.router = router;
        this.message = message;
        this.key = 'redirect';
    }
    run(data) {
        if (!data || !data.route) {
            this.message.addDangerMessageByKey('LBL_MISSING_HANDLER_DATA_ROUTE');
            return;
        }
        const params = {
            queryParams: {}
        };
        if (data.queryParams) {
            params.queryParams = data.queryParams;
        }
        this.router.navigate([data.route], params).then();
    }
    static { this.ɵfac = function RedirectAsyncAction_Factory(t) { return new (t || RedirectAsyncAction)(i0.ɵɵinject(i1$2.Router), i0.ɵɵinject(MessageService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: RedirectAsyncAction, factory: RedirectAsyncAction.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RedirectAsyncAction, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i1$2.Router }, { type: MessageService }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class ExportAsyncAction extends AsyncActionHandler {
    constructor(message) {
        super();
        this.message = message;
        this.key = 'export';
    }
    run(data) {
        if (!data || !data.url || !data.formData) {
            this.message.addDangerMessageByKey('LBL_MISSING_HANDLER_DATA_ROUTE');
            return;
        }
        const options = {
            responseType: 'blob',
            observe: 'response',
        };
        if (data.queryParams) {
            options.params = data.queryParams;
        }
        this.download(data.url, data.formData);
    }
    /**
     * Download file
     *
     * NOTE: using a hidden form instead of js for better memory management see:
     * https://github.com/eligrey/FileSaver.js/wiki/Saving-a-remote-file#using-a-form-element-other-than-get-methods
     *
     * @param {string} url for download
     * @param {object} formData to submit
     */
    download(url, formData) {
        const form = document.createElement('form');
        form.setAttribute('id', 'export-download');
        form.setAttribute('method', 'post');
        form.setAttribute('action', url);
        form.setAttribute('target', '_self');
        form.setAttribute('style', 'display: none;');
        Object.keys(formData).forEach(key => {
            const hiddenField = document.createElement('input');
            hiddenField.setAttribute('name', key);
            hiddenField.setAttribute('value', formData[key]);
            form.appendChild(hiddenField);
        });
        document.body.appendChild(form);
        form.submit();
        document.body.removeChild(form);
    }
    static { this.ɵfac = function ExportAsyncAction_Factory(t) { return new (t || ExportAsyncAction)(i0.ɵɵinject(MessageService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ExportAsyncAction, factory: ExportAsyncAction.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ExportAsyncAction, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: MessageService }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class NoopAsyncAction extends AsyncActionHandler {
    constructor() {
        super();
        this.key = 'noop';
    }
    run(data) {
    }
    static { this.ɵfac = function NoopAsyncAction_Factory(t) { return new (t || NoopAsyncAction)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: NoopAsyncAction, factory: NoopAsyncAction.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(NoopAsyncAction, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return []; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class IframeResizeHandlerHandler {
    constructor() {
    }
    /**
     * Public Api
     */
    init(iframe) {
        this.iframe = iframe;
        this.initialSizeAdjustment();
        this.addBodyResizeListener();
    }
    destroy() {
        if (this.observer) {
            this.observer.disconnect();
        }
        this.iframe = null;
        this.observer = null;
    }
    /**
     * Protected Api
     */
    initialSizeAdjustment() {
        setTimeout(this.onResize.bind(this), 200);
    }
    addBodyResizeListener() {
        const watchedData = {
            document: this.iframe.contentWindow.document,
            element: this.iframe.contentWindow.document.body,
            height: this.iframe.contentWindow.document.body.scrollHeight,
            watched: [
                {
                    getHeight: () => {
                        const modals = watchedData.document.getElementsByClassName('modal in');
                        const modal = modals && modals[0];
                        const modalDialog = modal && modal.firstElementChild;
                        return (modalDialog && (modalDialog.scrollHeight + 200)) || -1;
                    }
                },
                {
                    getHeight: () => {
                        const container = watchedData.document.getElementById('bootstrap-container');
                        const containerHeight = (container && container.scrollHeight + 150) || -1;
                        if (containerHeight > 0) {
                            return containerHeight;
                        }
                        return watchedData.element.scrollHeight + 50;
                    }
                }
            ]
        };
        this.observer = (new MutationObserverFactory()).create(() => {
            const heights = [];
            watchedData.watched.forEach((watched) => {
                const elHeight = watched.getHeight();
                if (elHeight > 0) {
                    heights.push(elHeight);
                }
            });
            heights.sort((a, b) => a - b);
            // consider the Height of the biggest
            const elementHeight = heights.pop();
            const feedback = this.calculateResizing(watchedData.height, elementHeight);
            if (feedback.resized) {
                watchedData.height = feedback.height;
            }
        });
        this.observer.observe(this.iframe.contentWindow.document.body, {
            attributes: true,
            childList: true,
            characterData: true,
            subtree: true
        });
    }
    calculateResizing(currentHeight, elementHeight) {
        const availableWindowHeight = window.innerHeight - 50;
        // if window size is bigger, take that size
        if (elementHeight < availableWindowHeight) {
            elementHeight = availableWindowHeight;
        }
        if (currentHeight === elementHeight) {
            return {
                resized: false
            };
        }
        if (currentHeight < (elementHeight - 20)) {
            this.resizeIFrame(elementHeight);
            return {
                resized: true,
                height: elementHeight
            };
        }
        if (this.iframe.scrollHeight > elementHeight) {
            this.resizeIFrame(elementHeight);
            return {
                resized: true,
                height: elementHeight
            };
        }
        return {
            resized: false
        };
    }
    onResize() {
        const elementHeight = this.iframe.contentWindow.document.body.scrollHeight + 120;
        const currentHeight = this.iframe.offsetHeight;
        this.calculateResizing(currentHeight, elementHeight);
    }
    resizeIFrame(size) {
        const adjustedValue = size + 1;
        this.iframe.style.height = adjustedValue + 'px';
    }
}

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class IframePageChangeObserver {
    constructor(iframe, changeCallback = null, loadCallback = null, unLoadCallback = null) {
        this.changeCallback = null;
        this.loadCallback = null;
        this.unLoadCallback = null;
        this.unloadListener = null;
        this.loadListener = null;
        this.iframe = iframe;
        this.changeCallback = changeCallback;
        this.loadCallback = loadCallback;
        this.unLoadCallback = unLoadCallback;
    }
    /**
     * Public Api
     */
    init() {
        this.loadListener = this.loadHandler.bind(this);
        this.unloadListener = this.unloadHandler.bind(this);
        this.iframe.contentWindow.addEventListener('load', this.loadListener);
        this.iframe.contentWindow.removeEventListener('unload', this.unloadListener);
    }
    destroy() {
        const contentWindow = this.iframe && this.iframe.contentWindow;
        if (contentWindow) {
            contentWindow.removeEventListener('unload', this.unloadListener);
            contentWindow.removeEventListener('load', this.loadListener);
        }
        this.iframe = null;
        this.lastDispatched = null;
        this.changeCallback = null;
        this.loadCallback = null;
        this.unLoadCallback = null;
        this.loadListener = null;
        this.unloadListener = null;
    }
    /**
     * Internal API
     */
    loadHandler() {
        this.loadCallback();
        this.bindUnload();
    }
    bindUnload() {
        this.iframe.contentWindow.removeEventListener('unload', this.unloadListener);
        this.unloadListener = this.unloadHandler.bind(this);
        this.iframe.contentWindow.addEventListener('unload', this.unloadListener);
    }
    unloadHandler() {
        this.unLoadCallback();
        // Timeout needed because the URL changes immediately after
        // the `unload` event is dispatched.
        setTimeout(this.triggerPageChange.bind(this), 0);
    }
    triggerPageChange() {
        const newHref = this.iframe && this.iframe.contentWindow && this.iframe.contentWindow.location.href;
        if (newHref && newHref !== this.lastDispatched) {
            this.lastDispatched = newHref;
            this.changeCallback(newHref);
        }
    }
}

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
const _c0$G = ["dataContainer"];
class ClassicModalComponent {
    constructor(languageStore, activeModal) {
        this.languageStore = languageStore;
        this.activeModal = activeModal;
        this.url = '';
        this.titleKey = '';
        this.asyncActionCallback = null;
        this.iframe = null;
    }
    ngOnInit() {
        this.closeButton = {
            klass: ['btn', 'btn-outline-light', 'btn-sm'],
            onClick: () => {
                this.activeModal.close({
                    type: 'close-button'
                });
            }
        };
    }
    ngAfterViewInit() {
        this.initIframe();
    }
    ngOnDestroy() {
        this.cleanObservers();
        this.iframe = null;
        const placeholder = this.wrapper;
        if (this.wrapper.firstChild) {
            placeholder.removeChild(placeholder.firstChild);
        }
        placeholder.innerHTML = '<iframe></iframe>';
        this.wrapper = null;
    }
    cleanObservers() {
        if (this.iframeResizeHandler) {
            this.iframeResizeHandler.destroy();
            this.iframeResizeHandler = null;
        }
        if (this.iframePageChangeHandler) {
            this.iframePageChangeHandler.destroy();
            this.iframePageChangeHandler = null;
        }
    }
    initIframe() {
        this.wrapper = this.dataContainer.nativeElement;
        if (this.wrapper.firstChild) {
            this.wrapper.removeChild(this.wrapper.firstChild);
        }
        const iframe = document.createElement('iframe');
        iframe.src = this.url;
        this.wrapper.appendChild(iframe);
        this.iframe = iframe;
        this.iframe.style.display = 'block';
        this.initObservers();
    }
    initObservers() {
        this.iframePageChangeHandler = this.buildIframePageChangeObserver();
        this.iframeResizeHandler = this.buildIframeResizeHandlerHandler();
        if (this.iframePageChangeHandler) {
            this.iframePageChangeHandler.init();
        }
    }
    onIFrameLoad() {
        // Do not show scroll at any time, to avoid flickering
        this.iframe.contentWindow.document.body.style.overflow = 'hidden';
        // callback function to execute custom task
        // as required by the caller
        if (this.asyncActionCallback !== null) {
            this.asyncActionCallback(this.iframe);
        }
        // Init resize handler
        this.iframeResizeHandler.init(this.iframe);
    }
    onIFrameUnload() {
        // hide iframe, while being re-directed
        this.iframe.style.display = 'none';
        this.iframeResizeHandler.destroy();
    }
    buildIframePageChangeObserver() {
        return new IframePageChangeObserver(this.iframe, null, this.onIFrameLoad.bind(this), this.onIFrameUnload.bind(this));
    }
    buildIframeResizeHandlerHandler() {
        return new IframeResizeHandlerHandler();
    }
    static { this.ɵfac = function ClassicModalComponent_Factory(t) { return new (t || ClassicModalComponent)(i0.ɵɵdirectiveInject(LanguageStore), i0.ɵɵdirectiveInject(i3$1.NgbActiveModal)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ClassicModalComponent, selectors: [["scrm-classic-modal"]], viewQuery: function ClassicModalComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0$G, 7);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dataContainer = _t.first);
        } }, inputs: { url: "url", titleKey: "titleKey", asyncActionCallback: "asyncActionCallback" }, decls: 5, vars: 3, consts: [["bodyKlass", "m-0 small-font", "footerKlass", "border-0", "klass", "classic-view-modal", 3, "closable", "close", "titleKey"], ["modal-body", ""], [1, "classic-view-container"], ["dataContainer", ""]], template: function ClassicModalComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "scrm-modal", 0)(1, "div", 1)(2, "div", 2, 3);
            i0.ɵɵelement(4, "iframe");
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵproperty("closable", true)("close", ctx.closeButton)("titleKey", ctx.titleKey);
        } }, dependencies: [ModalComponent], encapsulation: 2, data: { animation: [
                trigger('modalFade', [
                    transition('void <=> *', [
                        animate('800ms')
                    ]),
                ]),
            ] } }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ClassicModalComponent, [{
        type: Component,
        args: [{ selector: 'scrm-classic-modal', animations: [
                    trigger('modalFade', [
                        transition('void <=> *', [
                            animate('800ms')
                        ]),
                    ]),
                ], template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n\n<scrm-modal [closable]=\"true\"\n            [close]=\"closeButton\"\n            [titleKey]=\"titleKey\"\n            bodyKlass=\"m-0 small-font\"\n            footerKlass=\"border-0\"\n            klass=\"classic-view-modal\">\n\n    <div modal-body>\n\n        <div class=\"classic-view-container\" #dataContainer>\n            <iframe></iframe>\n        </div>\n\n    </div>\n\n</scrm-modal>\n" }]
    }], function () { return [{ type: LanguageStore }, { type: i3$1.NgbActiveModal }]; }, { url: [{
            type: Input
        }], titleKey: [{
            type: Input
        }], asyncActionCallback: [{
            type: Input
        }], dataContainer: [{
            type: ViewChild,
            args: ['dataContainer', { static: true }]
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class ChangelogAsyncAction extends AsyncActionHandler {
    constructor(router, modalService, message) {
        super();
        this.router = router;
        this.modalService = modalService;
        this.message = message;
        this.key = 'audit';
    }
    run(data) {
        if (!data || !data.url) {
            this.message.addDangerMessageByKey('LBL_MISSING_HANDLER_DATA_ROUTE');
            return;
        }
        this.showClassicViewModal(data.url);
    }
    /**
     * Remove title text from iframe source document
     */
    changeLogLegacyContentFormatter(iframeElement) {
        if (!iframeElement) {
            return;
        }
        const node = iframeElement.contentDocument.getElementsByClassName('moduleTitle')[0];
        if (!node) {
            return;
        }
        node.innerText = '';
    }
    /**
     * Show record selection modal
     */
    showClassicViewModal(url) {
        const modal = this.modalService.open(ClassicModalComponent, {
            size: 'xl',
            centered: true,
            scrollable: true
        });
        modal.componentInstance.titleKey = 'LBL_CHANGE_LOG';
        modal.componentInstance.url = url;
        modal.componentInstance.asyncActionCallback = this.changeLogLegacyContentFormatter.bind(this);
    }
    static { this.ɵfac = function ChangelogAsyncAction_Factory(t) { return new (t || ChangelogAsyncAction)(i0.ɵɵinject(i1$2.Router), i0.ɵɵinject(i3$1.NgbModal), i0.ɵɵinject(MessageService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ChangelogAsyncAction, factory: ChangelogAsyncAction.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ChangelogAsyncAction, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i1$2.Router }, { type: i3$1.NgbModal }, { type: MessageService }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class AsyncActionService {
    constructor(processService, appStateStore, message, redirectAction, exportAction, noopAction, changelogAction) {
        this.processService = processService;
        this.appStateStore = appStateStore;
        this.message = message;
        this.redirectAction = redirectAction;
        this.exportAction = exportAction;
        this.noopAction = noopAction;
        this.changelogAction = changelogAction;
        this.actions = {};
        this.registerHandler(redirectAction);
        this.registerHandler(exportAction);
        this.registerHandler(noopAction);
        this.registerHandler(changelogAction);
    }
    registerHandler(handler) {
        this.actions[handler.key] = handler;
    }
    /**
     * Send action request
     *
     * @param {string} actionName to submit
     * @param {string} data to send
     * @param {string} presetHandlerKey to use
     * @returns {object} Observable<Process>
     */
    run(actionName, data, presetHandlerKey = null) {
        const options = {
            ...data
        };
        this.appStateStore.updateLoading(actionName, true);
        return this.processService
            .submit(actionName, options)
            .pipe(take(1), tap((process) => {
            this.appStateStore.updateLoading(actionName, false);
            let handler = 'addSuccessMessageByKey';
            if (process.status === 'error') {
                handler = 'addDangerMessageByKey';
            }
            if (process.messages) {
                process.messages.forEach(message => {
                    if (!!message) {
                        this.message[handler](message);
                    }
                });
            }
            if (process.status === 'error') {
                return;
            }
            const actionHandlerKey = presetHandlerKey || (process.data && process.data.handler) || null;
            if (!actionHandlerKey) {
                return;
            }
            const actionHandler = this.actions[actionHandlerKey];
            if (!actionHandler) {
                this.message.addDangerMessageByKey('LBL_MISSING_HANDLER');
                return;
            }
            actionHandler.run(process.data.params);
        }), catchError((err) => {
            const errorMessage = err?.message ?? '';
            if (errorMessage === 'Access Denied.') {
                this.appStateStore.updateLoading(actionName, false);
                return of(null);
            }
            this.message.addDangerMessageByKey('LBL_ACTION_ERROR');
            this.appStateStore.updateLoading(actionName, false);
            return of(null);
        }));
    }
    static { this.ɵfac = function AsyncActionService_Factory(t) { return new (t || AsyncActionService)(i0.ɵɵinject(ProcessService), i0.ɵɵinject(AppStateStore), i0.ɵɵinject(MessageService), i0.ɵɵinject(RedirectAsyncAction), i0.ɵɵinject(ExportAsyncAction), i0.ɵɵinject(NoopAsyncAction), i0.ɵɵinject(ChangelogAsyncAction)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: AsyncActionService, factory: AsyncActionService.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AsyncActionService, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], function () { return [{ type: ProcessService }, { type: AppStateStore }, { type: MessageService }, { type: RedirectAsyncAction }, { type: ExportAsyncAction }, { type: NoopAsyncAction }, { type: ChangelogAsyncAction }]; }, null); })();

class BaseSaveRecordMapper {
    getKey() {
        return 'base';
    }
    map(record) {
        if (!record.fields || !Object.keys(record.fields).length) {
            return;
        }
        Object.keys(record.fields).forEach(fieldName => {
            const field = record.fields[fieldName];
            const type = field.type || '';
            const source = field.definition.source || '';
            const rname = field.definition.rname || 'name';
            const idName = field.definition.id_name || '';
            if (type === 'relate' && source === 'non-db' && idName === fieldName) {
                record.attributes[fieldName] = field.value;
                return;
            }
            if (type === 'relate' && source === 'non-db' && rname !== '' && field.valueObject) {
                const attribute = record.attributes[fieldName] || {};
                attribute[rname] = field.valueObject[rname];
                attribute.id = field.valueObject.id;
                record.attributes[fieldName] = attribute;
                record.attributes[idName] = field.valueObject.id;
                return;
            }
            if (field.valueObject) {
                record.attributes[fieldName] = field.valueObject;
                return;
            }
            if (field.items) {
                record.attributes[fieldName] = [];
                field.items.forEach(item => {
                    if (!item?.id && item?.attributes?.deleted) {
                        return;
                    }
                    record.attributes[fieldName].push({
                        id: item.id,
                        module: item.module,
                        attributes: deepClone(item.attributes)
                    });
                });
                return;
            }
            if (field.valueObjectArray) {
                record.attributes[fieldName] = field.valueObjectArray;
                return;
            }
            if (field.valueList) {
                record.attributes[fieldName] = field.valueList;
                return;
            }
            if (field.vardefBased && (isNil(field.value) || field.value === '')) {
                if (!isNil(record.attributes[fieldName])) {
                    delete record.attributes[fieldName];
                }
                return;
            }
            record.attributes[fieldName] = field.value;
        });
    }
    static { this.ɵfac = function BaseSaveRecordMapper_Factory(t) { return new (t || BaseSaveRecordMapper)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: BaseSaveRecordMapper, factory: BaseSaveRecordMapper.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseSaveRecordMapper, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2023 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class UpdateValueBackendAction extends FieldLogicActionHandler {
    constructor(asyncActionService, processService, messages, recordMappers, baseMapper, activeFieldsChecker) {
        super();
        this.asyncActionService = asyncActionService;
        this.processService = processService;
        this.messages = messages;
        this.recordMappers = recordMappers;
        this.baseMapper = baseMapper;
        this.activeFieldsChecker = activeFieldsChecker;
        this.key = 'updateValueBackend';
        this.modes = ['edit', 'detail', 'list', 'create', 'massupdate', 'filter'];
        recordMappers.register('default', baseMapper.getKey(), baseMapper);
    }
    run(data, action) {
        const record = data.record;
        const field = data.field;
        if (!record || !field) {
            return;
        }
        const activeOnFields = (action.params && action.params.activeOnFields) || {};
        const relatedFields = Object.keys(activeOnFields);
        const activeOnAttributes = (action.params && action.params.activeOnAttributes) || {};
        const relatedAttributesFields = Object.keys(activeOnAttributes);
        if (!relatedFields.length && !relatedAttributesFields.length) {
            return;
        }
        const process = action.params && action.params.process;
        if (!process) {
            return;
        }
        const isActive = this.activeFieldsChecker.isActive(relatedFields, record, activeOnFields, relatedAttributesFields, activeOnAttributes);
        if (isActive) {
            const processType = process;
            const baseRecord = this.getBaseRecord(record);
            const options = {
                action: processType,
                module: record.module ?? '',
                record: baseRecord
            };
            field.loading = true;
            this.processService.submit(processType, options).pipe(take(1)).subscribe((result) => {
                const value = result?.data?.value ?? null;
                field.loading = false;
                if (value === null) {
                    this.messages.addDangerMessageByKey("ERR_FIELD_LOGIC_BACKEND_CALCULATION");
                    return;
                }
                this.updateValue(field, value.toString(), record);
            }, (error) => {
                field.loading = false;
                this.messages.addDangerMessageByKey("ERR_FIELD_LOGIC_BACKEND_CALCULATION");
            });
        }
    }
    getBaseRecord(record) {
        if (!record) {
            return null;
        }
        this.mapRecordFields(record);
        const baseRecord = {
            id: record.id,
            type: record.type,
            module: record.module,
            attributes: record.attributes,
            acls: record.acls
        };
        return deepClone(baseRecord);
    }
    /**
     * Map staging fields
     */
    mapRecordFields(record) {
        const mappers = this.recordMappers.get(record.module);
        Object.keys(mappers).forEach(key => {
            const mapper = mappers[key];
            mapper.map(record);
        });
    }
    /**
     * Update the new value
     * @param {object} field
     * @param {string} value
     * @param {object} record
     */
    updateValue(field, value, record) {
        field.value = value.toString();
        field.formControl.setValue(value);
        // re-validate the parent form-control after value update
        record.formGroup.updateValueAndValidity({ onlySelf: true, emitEvent: true });
    }
    static { this.ɵfac = function UpdateValueBackendAction_Factory(t) { return new (t || UpdateValueBackendAction)(i0.ɵɵinject(AsyncActionService), i0.ɵɵinject(ProcessService), i0.ɵɵinject(MessageService), i0.ɵɵinject(i4.RecordMapperRegistry), i0.ɵɵinject(BaseSaveRecordMapper), i0.ɵɵinject(ActiveFieldsChecker)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: UpdateValueBackendAction, factory: UpdateValueBackendAction.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(UpdateValueBackendAction, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: AsyncActionService }, { type: ProcessService }, { type: MessageService }, { type: i4.RecordMapperRegistry }, { type: BaseSaveRecordMapper }, { type: ActiveFieldsChecker }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2023 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DisplayTypeBackendAction extends FieldLogicActionHandler {
    constructor(asyncActionService, processService, messages, recordMappers, baseMapper, activeFieldsChecker) {
        super();
        this.asyncActionService = asyncActionService;
        this.processService = processService;
        this.messages = messages;
        this.recordMappers = recordMappers;
        this.baseMapper = baseMapper;
        this.activeFieldsChecker = activeFieldsChecker;
        this.key = 'displayTypeBackend';
        this.modes = ['edit', 'detail', 'list', 'create', 'massupdate', 'filter'];
        recordMappers.register('default', baseMapper.getKey(), baseMapper);
    }
    run(data, action) {
        const record = data.record;
        const field = data.field;
        if (!record || !field) {
            return;
        }
        const activeOnFields = (action.params && action.params.activeOnFields) || {};
        const relatedFields = Object.keys(activeOnFields);
        const activeOnAttributes = (action.params && action.params.activeOnAttributes) || {};
        const relatedAttributesFields = Object.keys(activeOnAttributes);
        if (!relatedFields.length && !relatedAttributesFields.length) {
            return;
        }
        const process = action.params && action.params.process;
        if (!process) {
            return;
        }
        const isActive = this.activeFieldsChecker.isActive(relatedFields, record, activeOnFields, relatedAttributesFields, activeOnAttributes);
        let display = data.field.defaultDisplay;
        if (isActive) {
            const processType = process;
            const baseRecord = this.getBaseRecord(record);
            const options = {
                action: processType,
                module: record.module ?? '',
                record: baseRecord
            };
            field.loading = true;
            this.processService.submit(processType, options).subscribe((result) => {
                const targetDisplay = result?.data?.value ?? null;
                field.loading = false;
                if (targetDisplay === null) {
                    this.messages.addDangerMessageByKey("ERR_FIELD_LOGIC_BACKEND_CALCULATION");
                    return;
                }
                display = targetDisplay;
                data.field.display = display;
            }, (error) => {
                field.loading = false;
                this.messages.addDangerMessageByKey("ERR_FIELD_LOGIC_BACKEND_CALCULATION");
            });
        }
        const resetOn = (action.params && action.params.resetOn) || 'none';
        if (resetOn === display) {
            if (data.field.valueList && data.field.valueList.length) {
                data.field.valueList = [];
            }
            if (data.field.value) {
                data.field.value = '';
            }
        }
    }
    getBaseRecord(record) {
        if (!record) {
            return null;
        }
        this.mapRecordFields(record);
        const baseRecord = {
            id: record.id,
            type: record.type,
            module: record.module,
            attributes: record.attributes,
            acls: record.acls
        };
        return deepClone(baseRecord);
    }
    /**
     * Map staging fields
     */
    mapRecordFields(record) {
        const mappers = this.recordMappers.get(record.module);
        Object.keys(mappers).forEach(key => {
            const mapper = mappers[key];
            mapper.map(record);
        });
    }
    getTriggeringStatus() {
        return ['onValueChange', 'onFieldInitialize'];
    }
    static { this.ɵfac = function DisplayTypeBackendAction_Factory(t) { return new (t || DisplayTypeBackendAction)(i0.ɵɵinject(AsyncActionService), i0.ɵɵinject(ProcessService), i0.ɵɵinject(MessageService), i0.ɵɵinject(i4.RecordMapperRegistry), i0.ɵɵinject(BaseSaveRecordMapper), i0.ɵɵinject(ActiveFieldsChecker)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: DisplayTypeBackendAction, factory: DisplayTypeBackendAction.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DisplayTypeBackendAction, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: AsyncActionService }, { type: ProcessService }, { type: MessageService }, { type: i4.RecordMapperRegistry }, { type: BaseSaveRecordMapper }, { type: ActiveFieldsChecker }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class FieldLogicManager extends BaseActionManager {
    constructor(displayType, emailPrimarySelectAction, required, updateBaseCurrency, updateCurrency, updateValue, updateFlexRelateModule, updateValueBackend, dislayTypeBackend) {
        super();
        this.actions = {
            edit: {},
            create: {},
            list: {},
            detail: {},
            massupdate: {},
            filter: {}
        };
        displayType.modes.forEach(mode => this.actions[mode][displayType.key] = displayType);
        emailPrimarySelectAction.modes.forEach(mode => this.actions[mode][emailPrimarySelectAction.key] = emailPrimarySelectAction);
        required.modes.forEach(mode => this.actions[mode][required.key] = required);
        updateBaseCurrency.modes.forEach(mode => this.actions[mode][updateBaseCurrency.key] = updateBaseCurrency);
        updateCurrency.modes.forEach(mode => this.actions[mode][updateCurrency.key] = updateCurrency);
        updateFlexRelateModule.modes.forEach(mode => this.actions[mode][updateFlexRelateModule.key] = updateFlexRelateModule);
        updateValue.modes.forEach(mode => this.actions[mode][updateValue.key] = updateValue);
        updateValueBackend.modes.forEach(mode => this.actions[mode][updateValueBackend.key] = updateValueBackend);
        dislayTypeBackend.modes.forEach(mode => this.actions[mode][dislayTypeBackend.key] = dislayTypeBackend);
    }
    /**
     * Run logic for the given field
     * @param {object} field
     * @param {object} mode
     * @param {object} record
     * @param triggeringStatus
     */
    runLogic(field, mode, record, triggeringStatus = '') {
        if (!field.logic) {
            return;
        }
        const actions = Object.keys(field.logic).map(key => field.logic[key]);
        const modeActions = this.parseModeActions(actions, mode, triggeringStatus);
        const context = {
            record,
            field,
            module: record.module
        };
        modeActions.forEach(action => {
            this.runAction(action, mode, context);
        });
    }
    /**
     * Run the action using given context
     * @param action
     * @param mode
     * @param context
     */
    runAction(action, mode, context = null) {
        this.runFrontEndAction(action, mode, context);
    }
    /**
     * Run front end action
     * @param {object} action
     * @param {object} mode
     * @param {object} context
     */
    runFrontEndAction(action, mode, context = null) {
        const data = this.buildActionData(action, context);
        this.run(action, mode, data);
    }
    /**
     * Get module name
     * @param {object} context
     */
    getModuleName(context) {
        return context.module;
    }
    buildActionData(action, context) {
        return {
            field: context.field,
            record: (context && context.record) || null,
        };
    }
    /**
     * Parse mode actions
     * @param declaredActions
     * @param mode
     * @param triggeringStatus
     */
    parseModeActions(declaredActions, mode, triggeringStatus) {
        if (!declaredActions) {
            return [];
        }
        const availableActions = {
            list: [],
            detail: [],
            edit: [],
            create: [],
            massupdate: [],
            filter: [],
        };
        if (declaredActions && declaredActions.length) {
            declaredActions.forEach(action => {
                if (!action.modes || !action.modes.length) {
                    return;
                }
                action.modes.forEach(actionMode => {
                    if (!availableActions[actionMode] && !action.asyncProcess) {
                        return;
                    }
                    availableActions[actionMode].push(action);
                });
            });
        }
        const actions = [];
        const defaultTriggeringStatus = ['onValueChange'];
        availableActions[mode].forEach(action => {
            const frontendActionTriggeringStatus = this?.actions[mode][action.key]?.getTriggeringStatus() ?? null;
            const actionTriggeringStatus = action?.triggeringStatus ?? frontendActionTriggeringStatus ?? defaultTriggeringStatus;
            if (triggeringStatus && !actionTriggeringStatus.includes(triggeringStatus)) {
                return;
            }
            actions.push(action);
        });
        return actions;
    }
    static { this.ɵfac = function FieldLogicManager_Factory(t) { return new (t || FieldLogicManager)(i0.ɵɵinject(FieldLogicDisplayTypeAction), i0.ɵɵinject(EmailPrimarySelectAction), i0.ɵɵinject(RequiredAction), i0.ɵɵinject(UpdateBaseCurrencyAction), i0.ɵɵinject(UpdateCurrencyAction), i0.ɵɵinject(UpdateValueAction), i0.ɵɵinject(UpdateFlexRelateModuleAction), i0.ɵɵinject(UpdateValueBackendAction), i0.ɵɵinject(DisplayTypeBackendAction)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: FieldLogicManager, factory: FieldLogicManager.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FieldLogicManager, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: FieldLogicDisplayTypeAction }, { type: EmailPrimarySelectAction }, { type: RequiredAction }, { type: UpdateBaseCurrencyAction }, { type: UpdateCurrencyAction }, { type: UpdateValueAction }, { type: UpdateFlexRelateModuleAction }, { type: UpdateValueBackendAction }, { type: DisplayTypeBackendAction }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2023 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class FieldLogicDisplayActionHandler extends ActionHandler {
    shouldDisplay(data) {
        return true;
    }
    ;
}

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2023 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DisplayTypeAction extends FieldLogicDisplayActionHandler {
    constructor(activeFieldsChecker) {
        super();
        this.activeFieldsChecker = activeFieldsChecker;
        this.key = 'displayType';
        this.modes = ['edit', 'detail', 'list', 'create', 'massupdate', 'filter'];
    }
    run(data, action) {
        const record = data.record;
        const field = data.field;
        if (!record || !field) {
            return true;
        }
        const activeOnFields = (action.params && action.params.activeOnFields) || {};
        const relatedFields = Object.keys(activeOnFields);
        const activeOnAttributes = (action.params && action.params.activeOnAttributes) || {};
        const relatedAttributesFields = Object.keys(activeOnAttributes);
        if (!relatedFields.length && !relatedAttributesFields.length) {
            return true;
        }
        return this.activeFieldsChecker.isActive(relatedFields, record, activeOnFields, relatedAttributesFields, activeOnAttributes);
    }
    static { this.ɵfac = function DisplayTypeAction_Factory(t) { return new (t || DisplayTypeAction)(i0.ɵɵinject(ActiveFieldsChecker)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: DisplayTypeAction, factory: DisplayTypeAction.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DisplayTypeAction, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: ActiveFieldsChecker }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2023 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class FieldLogicDisplayManager extends BaseActionManager {
    constructor(displayType) {
        super();
        displayType.modes.forEach(mode => this.actions[mode][displayType.key] = displayType);
    }
    runAll(field, record, mode) {
        let toDisplay = 'show';
        if (!field.displayLogic) {
            return;
        }
        const validModeLogic = Object.values(field.displayLogic).filter(logic => {
            const allowedModes = logic['modes'] ?? [];
            return !!(allowedModes.length && allowedModes.includes(mode));
        });
        if (!validModeLogic || !validModeLogic.length) {
            field.display = toDisplay;
            return;
        }
        let defaultDisplay = field.defaultDisplay ?? 'show';
        let targetDisplay = 'none';
        if (defaultDisplay === 'none') {
            targetDisplay = 'show';
        }
        const context = {
            record,
            field,
            module: record.module
        };
        const isActive = validModeLogic.some(logic => {
            const data = this.buildActionData(logic, context);
            return this.actions[mode][logic.key].run(data, logic);
        });
        if (isActive) {
            defaultDisplay = targetDisplay;
        }
        toDisplay = defaultDisplay;
        if (defaultDisplay === 'show') {
            toDisplay = 'show';
        }
        field.display = toDisplay;
    }
    buildActionData(action, context) {
        return {
            field: context.field,
            record: (context && context.record) || null,
        };
    }
    static { this.ɵfac = function FieldLogicDisplayManager_Factory(t) { return new (t || FieldLogicDisplayManager)(i0.ɵɵinject(DisplayTypeAction)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: FieldLogicDisplayManager, factory: FieldLogicDisplayManager.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FieldLogicDisplayManager, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: DisplayTypeAction }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2024 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class BaseFieldHandler {
    initDefaultValue(field, record) {
        if (field.defaultValueInitialized) {
            return;
        }
        const defaultValue = field?.default ?? field?.definition?.default ?? null;
        if (!field.value && defaultValue) {
            field.value = defaultValue;
            field?.formControl?.setValue(defaultValue);
            field.defaultValueInitialized = true;
        }
        else if (field.value === null) {
            field.value = '';
        }
    }
    static { this.ɵfac = function BaseFieldHandler_Factory(t) { return new (t || BaseFieldHandler)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: BaseFieldHandler, factory: BaseFieldHandler.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseFieldHandler, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2024 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DateFieldHandler extends BaseFieldHandler {
    constructor(processService, messages) {
        super();
        this.processService = processService;
        this.messages = messages;
    }
    initDefaultValue(field, record) {
        if (field.defaultValueInitialized) {
            return;
        }
        let defaultValue = field?.default ?? field?.definition?.default ?? null;
        let displayDefault = field?.definition?.display_default ?? null;
        if (!defaultValue && !displayDefault) {
            field.defaultValueInitialized = true;
            return;
        }
        if (typeof defaultValue !== "string" && typeof displayDefault !== "string") {
            return;
        }
        if (defaultValue && typeof defaultValue !== "string") {
            super.initDefaultValue(field, record);
            return;
        }
        const processType = 'calculate-date-default';
        const options = {
            action: processType,
            module: record.module ?? '',
            field: field.name,
            displayDefault: displayDefault
        };
        field.loading = true;
        this.processService.submit(processType, options).pipe(take(1)).subscribe((result) => {
            const value = result?.data?.value ?? null;
            field.loading = false;
            if (value === null) {
                this.messages.addDangerMessageByKey("ERR_FIELD_LOGIC_BACKEND_CALCULATION");
                return;
            }
            this.updateValue(field, value.toString(), record);
            field.defaultValueInitialized = true;
        });
    }
    updateValue(field, value, record) {
        field.value = value.toString();
        field.formControl.setValue(value);
        // re-validate the parent form-control after value update
        record.formGroup.updateValueAndValidity({ onlySelf: true, emitEvent: true });
    }
    static { this.ɵfac = function DateFieldHandler_Factory(t) { return new (t || DateFieldHandler)(i0.ɵɵinject(ProcessService), i0.ɵɵinject(MessageService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: DateFieldHandler, factory: DateFieldHandler.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateFieldHandler, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: ProcessService }, { type: MessageService }]; }, null); })();

class MultiEnumFieldHandler extends BaseFieldHandler {
    initDefaultValue(field, record) {
        if (field.defaultValueInitialized) {
            return;
        }
        let defaultValue = field?.default ?? field?.definition?.default ?? null;
        if (!defaultValue) {
            field.defaultValueInitialized = true;
            return;
        }
        if (typeof defaultValue !== "string") {
            return;
        }
        defaultValue = trimStart(defaultValue, '^');
        defaultValue = trimEnd(defaultValue, '^');
        const defaultValues = defaultValue.split("^,^");
        if (!defaultValue) {
            field.defaultValueInitialized = true;
            return;
        }
        if (defaultValues && defaultValues.length) {
            field.valueList = defaultValues;
        }
        field.defaultValueInitialized = true;
    }
    static { this.ɵfac = /*@__PURE__*/ function () { let ɵMultiEnumFieldHandler_BaseFactory; return function MultiEnumFieldHandler_Factory(t) { return (ɵMultiEnumFieldHandler_BaseFactory || (ɵMultiEnumFieldHandler_BaseFactory = i0.ɵɵgetInheritedFactory(MultiEnumFieldHandler)))(t || MultiEnumFieldHandler); }; }(); }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: MultiEnumFieldHandler, factory: MultiEnumFieldHandler.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MultiEnumFieldHandler, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2024 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DefaultFieldHandler extends BaseFieldHandler {
    static { this.ɵfac = /*@__PURE__*/ function () { let ɵDefaultFieldHandler_BaseFactory; return function DefaultFieldHandler_Factory(t) { return (ɵDefaultFieldHandler_BaseFactory || (ɵDefaultFieldHandler_BaseFactory = i0.ɵɵgetInheritedFactory(DefaultFieldHandler)))(t || DefaultFieldHandler); }; }(); }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: DefaultFieldHandler, factory: DefaultFieldHandler.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DefaultFieldHandler, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2024 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class FieldHandlerRegistry extends BaseServiceRegistry {
    constructor(defaultFieldHandler, dateFieldHandler, multienumFieldHandler) {
        super();
        this.defaultFieldHandler = defaultFieldHandler;
        this.dateFieldHandler = dateFieldHandler;
        this.multienumFieldHandler = multienumFieldHandler;
        this.defaultMap = {};
        this.defaultMap = {
            'default': defaultFieldHandler,
            'date': dateFieldHandler,
            'multienum': multienumFieldHandler
        };
        this.initDefault();
    }
    initDefault() {
        Object.keys(this.getDefaultMap()).forEach(type => {
            this.register('default', type, this.getDefaultMap()[type]);
        });
    }
    getDefaultMap() {
        return this.defaultMap ?? {};
    }
    static { this.ɵfac = function FieldHandlerRegistry_Factory(t) { return new (t || FieldHandlerRegistry)(i0.ɵɵinject(DefaultFieldHandler), i0.ɵɵinject(DateFieldHandler), i0.ɵɵinject(MultiEnumFieldHandler)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: FieldHandlerRegistry, factory: FieldHandlerRegistry.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FieldHandlerRegistry, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: DefaultFieldHandler }, { type: DateFieldHandler }, { type: MultiEnumFieldHandler }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class BaseFieldComponent {
    get mode() {
        return this._mode;
    }
    set mode(value) {
        this._mode = value;
        this.modeState.next(this._mode);
    }
    constructor(typeFormatter, logic, logicDisplay) {
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
        this.originalMode = '';
        this.klass = null;
        this._mode = '';
        this.dependentFields = {};
        this.dependentAttributes = [];
        this.subs = [];
        this.validateOnlyOnSubmit = false;
        this.isInvalid = signal(false);
        this.modeState = new BehaviorSubject('');
        this.mode$ = this.modeState.asObservable();
        this.fieldHandlerRegistry = inject(FieldHandlerRegistry);
    }
    ngOnInit() {
        this.baseInit();
        if (!this.originalMode) {
            this.originalMode = this.mode;
        }
        const defaultValueModes = this?.field?.defaultValueModes ?? [];
        if (defaultValueModes.includes(this.originalMode)) {
            const fieldHandler = this.fieldHandlerRegistry.get(this.record.module, this.field.type);
            fieldHandler.initDefaultValue(this.field, this.record);
        }
    }
    ngOnDestroy() {
        this.unsubscribeAll();
    }
    baseInit() {
        this.initDependencyHandlers();
        this.validateOnlyOnSubmit = this.record?.metadata?.validateOnlyOnSubmit;
        if (this.record?.validationTriggered) {
            this.isInvalid = computed(() => {
                if (this.record?.metadata?.validateOnlyOnSubmit && this.record?.validationTriggered() && this.field.formControl?.invalid) {
                    return true;
                }
                return false;
            });
        }
    }
    /**
     * Calculate and init dependency handlers
     */
    initDependencyHandlers() {
        if (!this.record) {
            return;
        }
        const fieldKeys = (this.record.fields && Object.keys(this.record.fields)) || [];
        if (fieldKeys.length > 1) {
            this.calculateDependentFields(fieldKeys);
            this.field.previousValue = this.field.value;
            if ((this.dependentFields && Object.keys(this.dependentFields).length) || this.dependentAttributes.length) {
                Object.keys(this.dependentFields).forEach(fieldKey => {
                    const field = this.record.fields[fieldKey] || null;
                    if (!field) {
                        return;
                    }
                    const types = this.dependentFields[fieldKey].type ?? [];
                    if (types.includes('logic')) {
                        this.logic.runLogic(field, this.originalMode, this.record, 'onFieldInitialize');
                    }
                    if (types.includes('displayLogic')) {
                        this.logicDisplay.runAll(field, this.record, this.originalMode);
                    }
                });
            }
            if (this.field.valueChanges$ && ((this.dependentFields && Object.keys(this.dependentFields).length) || this.dependentAttributes.length)) {
                this.subs.push(this.field.valueChanges$.pipe(debounceTime(500)).subscribe((data) => {
                    Object.keys(this.dependentFields).forEach(fieldKey => {
                        const dependentField = this.dependentFields[fieldKey];
                        const field = this.record.fields[fieldKey] || null;
                        if (!field) {
                            return;
                        }
                        if (this.field.previousValue != data.value) {
                            const types = dependentField.type ?? [];
                            if (types.includes('logic')) {
                                this.logic.runLogic(field, this.originalMode, this.record, 'onValueChange');
                            }
                            if (types.includes('displayLogic')) {
                                this.logicDisplay.runAll(field, this.record, this.originalMode);
                            }
                        }
                    });
                    this.field.previousValue = data.value;
                    this.dependentAttributes.forEach(dependency => {
                        const field = this.record.fields[dependency.field] || {};
                        const attribute = (field && field.attributes && field.attributes[dependency.attribute]) || null;
                        if (!attribute) {
                            return;
                        }
                        this.logic.runLogic(attribute, this.mode, this.record, 'onValueChange');
                    });
                }));
            }
        }
    }
    /**
     * Calculate dependent fields
     * @param {array} fieldKeys
     */
    calculateDependentFields(fieldKeys) {
        fieldKeys.forEach(key => {
            if (this.field.source === 'field' || this.field.source === 'groupField') {
                this.addFieldDependency(key, this.dependentFields, this.dependentAttributes);
                return;
            }
            if (this.field.source === 'attribute') {
                this.addAttributeDependency(key, this.dependentFields, this.dependentAttributes);
                return;
            }
        });
    }
    /**
     * Add field dependency
     * @param {string} fieldKey
     * @param {array} dependentFields
     * @param {object} dependentAttributes
     */
    addFieldDependency(fieldKey, dependentFields, dependentAttributes) {
        const field = this.record.fields[fieldKey];
        const name = this.field.name || this.field.definition.name || '';
        if (fieldKey === name || !field) {
            return;
        }
        if (field.fieldDependencies && this.isDependencyField(field.fieldDependencies)) {
            dependentFields[fieldKey] = field.fieldDependencies[name];
        }
        const attributeKeys = (field.attributes && Object.keys(field.attributes)) || [];
        attributeKeys.forEach(attributeKey => {
            const attribute = field.attributes[attributeKey];
            if (!attribute || !attribute.fieldDependencies || !attribute.fieldDependencies.length) {
                return;
            }
            if (this.isDependencyField(attribute.fieldDependencies)) {
                dependentAttributes.push({
                    field: fieldKey,
                    attribute: attributeKey,
                    types: dependentFields[name]['types'] ?? []
                });
            }
        });
    }
    /**
     * Check if field is dependency
     * @param dependencies
     * @returns {boolean}
     */
    isDependencyField(dependencies) {
        const name = this.field.name || this.field.definition.name || '';
        return !!(dependencies[name] ?? false);
    }
    /**
     * Add attribute dependency
     * @param {string} fieldKey
     * @param {array} dependentFields
     * @param {object} dependentAttributes
     */
    addAttributeDependency(fieldKey, dependentFields, dependentAttributes) {
        const field = this.record.fields[fieldKey];
        const name = this.field.name || this.field.definition.name || '';
        if (fieldKey === name || !field) {
            return;
        }
        if (field.attributeDependencies && field.attributeDependencies.length && this.isDependencyAttribute(field.attributeDependencies)) {
            dependentFields[name] = field.fieldDependencies[name];
        }
        const attributeKeys = (field.attributes && Object.keys(field.attributes)) || [];
        attributeKeys.forEach(attributeKey => {
            const attribute = field.attributes[attributeKey];
            if (attribute && attribute.attributeDependencies && attribute.attributeDependencies.length) {
                const hasDependency = this.isDependencyAttribute(attribute.attributeDependencies);
                if (hasDependency) {
                    dependentAttributes.push({
                        field: fieldKey,
                        attribute: attributeKey,
                        types: (dependentFields[name] ?? {})['types'] ?? []
                    });
                }
            }
        });
    }
    /**
     * Check if attribute is dependency
     * @param {object} attributeDependencies
     * @returns {boolean}
     */
    isDependencyAttribute(attributeDependencies) {
        const parentKey = this.field.parentKey || '';
        const name = this.field.name || this.field.definition.name || '';
        return attributeDependencies.some(dependency => parentKey === dependency.field && name === dependency.attribute);
    }
    subscribeValueChanges() {
        if (this.field && this.field.formControl) {
            this.subs.push(this.field.formControl.valueChanges.subscribe(value => {
                if (!isVoid(value)) {
                    value = value.trim();
                }
                else {
                    value = '';
                }
                if (this.typeFormatter && this.field.type) {
                    value = this.toInternalFormat(this.field.type, value);
                }
                this.setFieldValue(value);
            }));
        }
    }
    toInternalFormat(fieldType, value) {
        return this.typeFormatter.toInternalFormat(fieldType, value);
    }
    setFieldValue(newValue) {
        this.field.value = newValue;
    }
    setFormControlValue(newValue) {
        if (isEqual(this.field.formControl.value, newValue)) {
            this.field.formControl.markAsPristine();
            return;
        }
        this.field.formControl.setValue(newValue);
        this.field.formControl.markAsDirty();
    }
    unsubscribeAll() {
        this.subs.forEach(sub => sub.unsubscribe());
    }
    static { this.ɵfac = function BaseFieldComponent_Factory(t) { return new (t || BaseFieldComponent)(i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: BaseFieldComponent, selectors: [["ng-component"]], inputs: { originalMode: "originalMode", field: "field", record: "record", parent: "parent", klass: "klass", mode: "mode" }, decls: 0, vars: 0, template: function BaseFieldComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseFieldComponent, [{
        type: Component,
        args: [{ template: '' }]
    }], function () { return [{ type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, { originalMode: [{
            type: Input
        }], field: [{
            type: Input
        }], record: [{
            type: Input
        }], parent: [{
            type: Input
        }], klass: [{
            type: Input
        }], mode: [{
            type: Input
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class PhoneDetailFieldComponent extends BaseFieldComponent {
    constructor(typeFormatter, logic, logicDisplay) {
        super(typeFormatter, logic, logicDisplay);
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    getTelLink(phone) {
        if (!phone) {
            return null;
        }
        return 'tel:' + this.getUnFormatted(phone);
    }
    getUnFormatted(phone) {
        if (!phone) {
            return '';
        }
        return phone.replace(/\s+/g, '');
    }
    static { this.ɵfac = function PhoneDetailFieldComponent_Factory(t) { return new (t || PhoneDetailFieldComponent)(i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: PhoneDetailFieldComponent, selectors: [["scrm-phone-detail"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 2, consts: [[3, "href"]], template: function PhoneDetailFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "a", 0);
            i0.ɵɵtext(1);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵproperty("href", ctx.getTelLink(ctx.field.value), i0.ɵɵsanitizeUrl);
            i0.ɵɵadvance(1);
            i0.ɵɵtextInterpolate(ctx.field.value);
        } }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PhoneDetailFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-phone-detail', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<a [href]=\"getTelLink(field.value)\">{{ field.value }}</a>\n" }]
    }], function () { return [{ type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class BaseEnumComponent extends BaseFieldComponent {
    constructor(languages, typeFormatter, logic, logicDisplay) {
        super(typeFormatter, logic, logicDisplay);
        this.languages = languages;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
        this.selectedValues = [];
        this.valueLabel = '';
        this.options = [];
        this.subs = [];
        this.isDynamicEnum = false;
    }
    ngOnInit() {
        super.ngOnInit();
        const options$ = this?.field?.metadata?.options$ ?? null;
        if (options$) {
            this.subs.push(this.field.metadata.options$.subscribe((options) => {
                this.buildProvidedOptions(options);
                this.initValue();
            }));
            return;
        }
        const options = this?.field?.definition?.options ?? null;
        if (options) {
            this.subs.push(this.languages.vm$.subscribe((strings) => {
                this.buildAppStringListOptions(strings.appListStrings);
                this.initValue();
            }));
        }
        if (!options && !options$) {
            this.initValue();
        }
    }
    ngOnDestroy() {
        this.isDynamicEnum = false;
        this.subs.forEach(sub => sub.unsubscribe());
        this.options = [];
        this.optionsMap = {};
        this.selectedValues = [];
    }
    getInvalidClass() {
        if (this.validateOnlyOnSubmit ? this.isInvalid() : (this.field.formControl.invalid && this.field.formControl.touched)) {
            return 'is-invalid';
        }
        return '';
    }
    buildProvidedOptions(options) {
        this.options = options;
        this.optionsMap = {};
        options.forEach(option => {
            this.optionsMap[option.value] = option.label;
        });
    }
    buildAppStringListOptions(appStrings) {
        this.optionsMap = {};
        this.addExtraOptions();
        if (appStrings && this.field.definition.options && appStrings[this.field.definition.options]) {
            const options = appStrings[this.field.definition.options];
            if (this.options && Object.keys(this.options)) {
                this.optionsMap = { ...this.optionsMap, ...options };
            }
        }
        this.buildOptionsArray(appStrings);
    }
    addExtraOptions() {
        const extraOptions = (this.field.metadata && this.field.metadata.extraOptions) || [];
        extraOptions.forEach((item) => {
            if (isVoid(item.value)) {
                return;
            }
            let label = item.label || '';
            if (item.labelKey) {
                label = this.languages.getFieldLabel(item.labelKey);
            }
            this.optionsMap[item.value] = label;
        });
    }
    buildOptionsArray(appStrings) {
        this.options = [];
        Object.keys(this.optionsMap).forEach(key => {
            const isOptionEmpty = isEmptyString(this.optionsMap[key]);
            if (isOptionEmpty && this.isSkipEmptyMode()) {
                return;
            }
            if (isOptionEmpty && !this.addEmptyStringOption()) {
                return;
            }
            this.options.push({
                value: key,
                label: this.optionsMap[key]
            });
        });
        if (this.isDynamicEnum) {
            this.buildDynamicEnumOptions(appStrings);
        }
    }
    addEmptyStringOption() {
        return this.field.type !== 'multienum';
    }
    isSkipEmptyMode() {
        return this.mode === 'massupdate' || this.mode === 'filter';
    }
    initValue() {
        this.selectedValues = [];
        if (this.field.criteria) {
            this.initValueLabel();
            return;
        }
        if (typeof this.field.value !== 'string') {
            return;
        }
        if (!this.optionsMap) {
            return;
        }
        if (typeof this.optionsMap[this.field.value] !== 'string') {
            return;
        }
        this.initValueLabel();
    }
    initValueLabel() {
        const fieldValue = this.field.value || this.field.criteria?.target || undefined;
        if (fieldValue !== undefined) {
            this.valueLabel = this.optionsMap[fieldValue];
            this.selectedValues.push({
                value: fieldValue,
                label: this.valueLabel
            });
        }
    }
    /**
     *  Initialize the default value for the enum
     *
     *  @returns {void}
     *  @description set default enum value, if defined in vardefs
     * */
    initEnumDefault() {
        if (!isEmptyString(this.record?.id)) {
            this.field?.formControl.setValue('');
            return;
        }
        let defaultVal = this?.field?.default ?? this?.field?.definition?.default ?? null;
        if (typeof defaultVal === 'string') {
            defaultVal = defaultVal.trim();
        }
        if (!defaultVal) {
            this.field.formControl.setValue('');
            return;
        }
        this.selectedValues.push({
            value: defaultVal,
            label: this.optionsMap[defaultVal]
        });
        this.initEnumDefaultFieldValues(defaultVal);
    }
    initEnumDefaultFieldValues(defaultVal) {
        if (this.field.type === 'multienum') {
            const defaultValues = this.selectedValues.map(option => option.value);
            this.field.valueList = defaultValues;
            this.field.formControl.setValue(defaultValues);
        }
        else {
            this.field.value = defaultVal;
            this.field.formControl.setValue(defaultVal);
        }
        this.field.formControl.markAsDirty();
    }
    checkAndInitAsDynamicEnum() {
        const definition = (this.field && this.field.definition) || {};
        const dynamic = (definition && definition.dynamic) || false;
        const parentEnumKey = (definition && definition.parentenum) || '';
        const fields = (this.record && this.record.fields) || null;
        if (dynamic && parentEnumKey && fields) {
            this.isDynamicEnum = true;
            const parentEnum = fields[parentEnumKey];
            if (parentEnum) {
                this.subscribeToParentValueChanges(parentEnum);
            }
        }
    }
    buildDynamicEnumOptions(appStrings) {
        const parentEnum = this.record.fields[this.field.definition.parentenum];
        if (parentEnum) {
            const parentOptionMap = appStrings[parentEnum.definition.options];
            if (parentOptionMap && Object.keys(parentOptionMap).length !== 0) {
                this.mappedOptions = this.createParentChildOptionsMap(parentOptionMap, this.options);
                let parentValues = [];
                if (parentEnum.definition.type === 'multienum') {
                    parentValues = parentEnum.valueList;
                }
                else {
                    parentValues.push(parentEnum.value);
                }
                this.options = this.filterMatchingOptions(parentValues);
                if (parentValues && parentValues.length) {
                    this.setValueToAvailableOption();
                }
            }
        }
    }
    filterMatchingOptions(values) {
        let filteredOptions = [];
        if (!values || !values.length) {
            return [];
        }
        values.forEach(value => {
            if (!this.mappedOptions[value]) {
                return;
            }
            filteredOptions = filteredOptions.concat([...this.mappedOptions[value]]);
        });
        return filteredOptions;
    }
    createParentChildOptionsMap(parentOptions, childOptions) {
        const mappedOptions = {};
        Object.keys(parentOptions).forEach(key => {
            mappedOptions[key] = childOptions.filter(option => String(option.value).startsWith(key));
        });
        return mappedOptions;
    }
    subscribeToParentValueChanges(parentEnum) {
        if (parentEnum.formControl) {
            this.subs.push(parentEnum.formControl.valueChanges.subscribe(values => {
                if (typeof values === 'string') {
                    values = [values];
                }
                // Rebuild available enum options
                this.options = this.filterMatchingOptions(values);
                this.setValueToAvailableOption();
                this.initValue();
            }));
        }
    }
    setValueToAvailableOption() {
        if (!this?.options?.length) {
            this.field.value = '';
            this.field.formControl.setValue('');
            return;
        }
        if (!this.options.some(option => option.value === this.field.value)) {
            this.field.value = this.options[0].value;
            this.field.formControl.setValue(this.options[0].value);
        }
    }
    buildOptionFromValue(value) {
        const option = { value: '', label: '' };
        if (isNull(value)) {
            return option;
        }
        option.value = (typeof value !== 'string' ? JSON.stringify(value) : value).trim();
        option.label = option.value;
        const valueLabel = this.optionsMap[option.value] ?? option.label;
        if (isObject(valueLabel)) {
            return option;
        }
        option.label = (typeof valueLabel !== 'string' ? JSON.stringify(valueLabel) : valueLabel).trim();
        return option;
    }
    static { this.ɵfac = function BaseEnumComponent_Factory(t) { return new (t || BaseEnumComponent)(i0.ɵɵdirectiveInject(LanguageStore), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: BaseEnumComponent, selectors: [["ng-component"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 0, vars: 0, template: function BaseEnumComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseEnumComponent, [{
        type: Component,
        args: [{ template: '' }]
    }], function () { return [{ type: LanguageStore }, { type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class BaseMultiEnumComponent extends BaseEnumComponent {
    constructor(languages, typeFormatter, logic, logicDisplay) {
        super(languages, typeFormatter, logic, logicDisplay);
        this.languages = languages;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    subscribeValueChanges() {
    }
    initValue() {
        const fieldValueList = this.field.valueList;
        if (isVoid(fieldValueList) || isEmpty(fieldValueList)) {
            return;
        }
        this.updateInternalState(fieldValueList);
    }
    updateInternalState(value = []) {
        const valueArray = isArray(value) ? value : [value];
        this.selectedValues = valueArray.map(valueElement => this.buildOptionFromValue(valueElement));
        this.selectedValues = uniqBy(this.selectedValues, 'value');
        this.syncSelectedValuesWithForm();
    }
    syncSelectedValuesWithForm() {
        const selectedValuesValueMap = this.selectedValues.map(selectedValue => selectedValue.value);
        if (!isEqual(this.field.valueList, selectedValuesValueMap)) {
            this.setFormControlValue(selectedValuesValueMap);
        }
        return selectedValuesValueMap;
    }
    static { this.ɵfac = function BaseMultiEnumComponent_Factory(t) { return new (t || BaseMultiEnumComponent)(i0.ɵɵdirectiveInject(LanguageStore), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: BaseMultiEnumComponent, selectors: [["ng-component"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 0, vars: 0, template: function BaseMultiEnumComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseMultiEnumComponent, [{
        type: Component,
        args: [{ template: '' }]
    }], function () { return [{ type: LanguageStore }, { type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
const _c0$F = ["multiSelect"];
function MultiEnumFilterFieldComponent_ng_template_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 6);
} }
function MultiEnumFilterFieldComponent_ng_template_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 7);
} }
function MultiEnumFilterFieldComponent_ng_template_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 8);
} }
class MultiEnumFilterFieldComponent extends BaseMultiEnumComponent {
    constructor(languages, typeFormatter, logic, logicDisplay, screenSize, systemConfigStore, primengConfig) {
        super(languages, typeFormatter, logic, logicDisplay);
        this.languages = languages;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
        this.screenSize = screenSize;
        this.systemConfigStore = systemConfigStore;
        this.primengConfig = primengConfig;
        this.placeholderLabel = '';
        this.selectedItemsLabel = '';
        this.emptyFilterLabel = '';
        this.maxSelectedLabels = 20;
        this.selectAll = false;
    }
    ngOnInit() {
        this.field.valueList = [];
        if (this.field.criteria.values && this.field.criteria.values.length > 0) {
            this.field.valueList = this.field.criteria.values;
        }
        const maxSelectedLabelsForDisplay = this.systemConfigStore.getUi('multiselect_max_number');
        this.screenSize.screenSize$
            .pipe(take(1))
            .subscribe((screenSize) => {
            this.maxSelectedLabels = maxSelectedLabelsForDisplay[screenSize] || this.maxSelectedLabels;
        });
        this.getTranslatedLabels();
        super.ngOnInit();
        this.primengConfig.ripple = true;
    }
    onAdd() {
        const value = this.selectedValues.map(option => option.value);
        this.field.valueList = value;
        this.field.formControl.setValue(value);
        this.field.formControl.markAsDirty();
        this.field.criteria.operator = '=';
        this.field.criteria.values = value;
        this.calculateSelectAll();
    }
    onRemove() {
        let value = this.selectedValues.map(option => option.value);
        if (!value) {
            value = [];
        }
        this.field.valueList = value;
        this.field.formControl.setValue(value);
        this.field.formControl.markAsDirty();
        this.field.criteria.operator = '=';
        this.field.criteria.values = value;
        this.calculateSelectAll();
    }
    onClear() {
        this.selectedValues = [];
        this.multiSelect.filterValue = '';
        this.onRemove();
    }
    onPanelShow() {
        this.multiSelect.filterInputChild.nativeElement.focus();
        this.multiSelect.filterValue = '';
        this.calculateSelectAll();
    }
    onFilter() {
        this.calculateSelectAll();
    }
    getPlaceholderLabel() {
        return this.languages.getAppString('LBL_SELECT_ITEM') || '';
    }
    onSelectAll(event) {
        this.selectAll = event.checked;
        if (this.selectAll) {
            if (this.multiSelect.visibleOptions() && this.multiSelect.visibleOptions().length) {
                this.selectedValues = this.multiSelect.visibleOptions();
            }
            else {
                this.selectedValues = this.options;
            }
            this.onAdd();
        }
        else {
            this.selectedValues = [];
            this.onRemove();
        }
    }
    getTranslatedLabels() {
        this.placeholderLabel = this.languages.getAppString('LBL_SELECT_ITEM') || '';
        this.selectedItemsLabel = this.languages.getAppString('LBL_ITEMS_SELECTED') || '';
        this.emptyFilterLabel = this.languages.getAppString('ERR_SEARCH_NO_RESULTS') || '';
    }
    addEmptyStringOption() {
        return false;
    }
    calculateSelectAll() {
        const visibleOptions = this?.multiSelect?.visibleOptions() ?? [];
        const selectedValuesKeys = (this?.selectedValues ?? []).map(item => item.value);
        if (!visibleOptions.length || !selectedValuesKeys.length) {
            this.selectAll = false;
            return;
        }
        if (visibleOptions.length > selectedValuesKeys.length) {
            this.selectAll = false;
            return;
        }
        this.selectAll = visibleOptions.every(item => selectedValuesKeys.includes(item.value));
    }
    static { this.ɵfac = function MultiEnumFilterFieldComponent_Factory(t) { return new (t || MultiEnumFilterFieldComponent)(i0.ɵɵdirectiveInject(LanguageStore), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager), i0.ɵɵdirectiveInject(ScreenSizeObserverService), i0.ɵɵdirectiveInject(SystemConfigStore), i0.ɵɵdirectiveInject(i7.PrimeNGConfig)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: MultiEnumFilterFieldComponent, selectors: [["scrm-multienum-filter"]], viewQuery: function MultiEnumFilterFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0$F, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.multiSelect = _t.first);
        } }, features: [i0.ɵɵInheritDefinitionFeature], decls: 6, vars: 14, consts: [[1, "d-flex", "align-items-center"], [3, "options", "ngModel", "optionLabel", "placeholder", "selectedItemsLabel", "emptyFilterMessage", "maxSelectedLabels", "styleClass", "showToggleAll", "selectAll", "autoOptionFocus", "autofocusFilter", "showClear", "focusOnHover", "ngModelChange", "onChange", "onSelectAllChange", "onRemove", "onPanelShow", "onFilter", "onClear"], ["multiSelect", ""], ["pTemplate", "dropdownicon"], ["pTemplate", "filtericon"], ["pTemplate", "checkicon"], ["image", "down_carret"], ["image", "search"], ["image", "checkbox_cross"]], template: function MultiEnumFilterFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "p-multiSelect", 1, 2);
            i0.ɵɵlistener("ngModelChange", function MultiEnumFilterFieldComponent_Template_p_multiSelect_ngModelChange_1_listener($event) { return ctx.selectedValues = $event; })("onChange", function MultiEnumFilterFieldComponent_Template_p_multiSelect_onChange_1_listener() { return ctx.onAdd(); })("onSelectAllChange", function MultiEnumFilterFieldComponent_Template_p_multiSelect_onSelectAllChange_1_listener($event) { return ctx.onSelectAll($event); })("onRemove", function MultiEnumFilterFieldComponent_Template_p_multiSelect_onRemove_1_listener() { return ctx.onRemove(); })("onPanelShow", function MultiEnumFilterFieldComponent_Template_p_multiSelect_onPanelShow_1_listener() { return ctx.onPanelShow(); })("onFilter", function MultiEnumFilterFieldComponent_Template_p_multiSelect_onFilter_1_listener() { return ctx.onFilter(); })("onClear", function MultiEnumFilterFieldComponent_Template_p_multiSelect_onClear_1_listener() { return ctx.onClear(); });
            i0.ɵɵtemplate(3, MultiEnumFilterFieldComponent_ng_template_3_Template, 1, 0, "ng-template", 3);
            i0.ɵɵtemplate(4, MultiEnumFilterFieldComponent_ng_template_4_Template, 1, 0, "ng-template", 4);
            i0.ɵɵtemplate(5, MultiEnumFilterFieldComponent_ng_template_5_Template, 1, 0, "ng-template", 5);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("options", ctx.options)("ngModel", ctx.selectedValues)("optionLabel", "label")("placeholder", ctx.placeholderLabel)("selectedItemsLabel", "{0} " + ctx.selectedItemsLabel)("emptyFilterMessage", ctx.emptyFilterLabel)("maxSelectedLabels", ctx.maxSelectedLabels)("styleClass", "w-100 " + ctx.getInvalidClass())("showToggleAll", true)("selectAll", ctx.selectAll)("autoOptionFocus", false)("autofocusFilter", true)("showClear", true)("focusOnHover", true);
        } }, dependencies: [i5$1.NgControlStatus, i5$1.NgModel, ImageComponent, i10.MultiSelect, i7.PrimeTemplate], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MultiEnumFilterFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-multienum-filter', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<div class=\"d-flex align-items-center\">\n    <p-multiSelect\n        #multiSelect\n        [options]=\"options\"\n        [(ngModel)]=\"selectedValues\"\n        [optionLabel]=\"'label'\"\n        (onChange)=\"onAdd()\"\n        (onSelectAllChange)=\"onSelectAll($event)\"\n        (onRemove)=\"onRemove()\"\n        (onPanelShow)=\"onPanelShow()\"\n        (onFilter)=\"onFilter()\"\n        [placeholder]=\"placeholderLabel\"\n        [selectedItemsLabel]=\"'{0} ' + selectedItemsLabel\"\n        [emptyFilterMessage]=\"emptyFilterLabel\"\n        [maxSelectedLabels]=\"maxSelectedLabels\"\n        [styleClass]=\"'w-100 ' + getInvalidClass()\"\n        [showToggleAll]=\"true\"\n        [selectAll]=\"selectAll\"\n        [autoOptionFocus]=\"false\"\n        [autofocusFilter]=\"true\"\n        [showClear]=\"true\"\n        (onClear)=\"onClear()\"\n        [focusOnHover]=\"true\"\n    >\n        <ng-template pTemplate=\"dropdownicon\">\n            <scrm-image image=\"down_carret\"></scrm-image>\n        </ng-template>\n        <ng-template pTemplate=\"filtericon\">\n            <scrm-image image=\"search\"></scrm-image>\n        </ng-template>\n        <ng-template pTemplate=\"checkicon\">\n            <scrm-image image=\"checkbox_cross\"></scrm-image>\n        </ng-template>\n\n    </p-multiSelect>\n</div>\n" }]
    }], function () { return [{ type: LanguageStore }, { type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }, { type: ScreenSizeObserverService }, { type: SystemConfigStore }, { type: i7.PrimeNGConfig }]; }, { multiSelect: [{
            type: ViewChild,
            args: ['multiSelect']
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class EnumDetailFieldComponent extends BaseEnumComponent {
    constructor(languages, typeFormatter, logic, logicDisplay) {
        super(languages, typeFormatter, logic, logicDisplay);
        this.languages = languages;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    static { this.ɵfac = function EnumDetailFieldComponent_Factory(t) { return new (t || EnumDetailFieldComponent)(i0.ɵɵdirectiveInject(LanguageStore), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: EnumDetailFieldComponent, selectors: [["scrm-enum-detail"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, template: function EnumDetailFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtext(0);
        } if (rf & 2) {
            i0.ɵɵtextInterpolate1("\n", ctx.valueLabel, "\n");
        } }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EnumDetailFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-enum-detail', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n{{valueLabel}}\n" }]
    }], function () { return [{ type: LanguageStore }, { type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class EnumDetailFieldModule {
    static { this.ɵfac = function EnumDetailFieldModule_Factory(t) { return new (t || EnumDetailFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: EnumDetailFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormsModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EnumDetailFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [EnumDetailFieldComponent],
                exports: [EnumDetailFieldComponent],
                imports: [
                    CommonModule,
                    FormsModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(EnumDetailFieldModule, { declarations: [EnumDetailFieldComponent], imports: [CommonModule,
        FormsModule], exports: [EnumDetailFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class BaseNameComponent extends BaseFieldComponent {
    constructor(typeFormatter, logic, logicDisplay) {
        super(typeFormatter, logic, logicDisplay);
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    getNameField(field, record) {
        if (!field.value || !record.attributes) {
            return;
        }
        const format = field.value.split(' ');
        const groupField = [];
        format.forEach(item => {
            if (record.attributes[item]) {
                groupField.push(record.attributes[item]);
            }
        });
        return groupField.join(' ');
    }
    static { this.ɵfac = function BaseNameComponent_Factory(t) { return new (t || BaseNameComponent)(i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: BaseNameComponent, selectors: [["ng-component"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 0, vars: 0, template: function BaseNameComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseNameComponent, [{
        type: Component,
        args: [{ template: '' }]
    }], function () { return [{ type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class FullNameDetailFieldsComponent extends BaseNameComponent {
    constructor(typeFormatter, logic, logicDisplay) {
        super(typeFormatter, logic, logicDisplay);
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    ngOnInit() {
        super.ngOnInit();
        this.data = this.getNameField(this.field, this.record);
    }
    static { this.ɵfac = function FullNameDetailFieldsComponent_Factory(t) { return new (t || FullNameDetailFieldsComponent)(i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FullNameDetailFieldsComponent, selectors: [["scrm-fullname-detail"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, template: function FullNameDetailFieldsComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtext(0);
        } if (rf & 2) {
            i0.ɵɵtextInterpolate1("\n", ctx.data, "\n");
        } }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FullNameDetailFieldsComponent, [{
        type: Component,
        args: [{ selector: 'scrm-fullname-detail', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n{{this.data}}\n" }]
    }], function () { return [{ type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class FullNameDetailFieldsModule {
    static { this.ɵfac = function FullNameDetailFieldsModule_Factory(t) { return new (t || FullNameDetailFieldsModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: FullNameDetailFieldsModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FullNameDetailFieldsModule, [{
        type: NgModule,
        args: [{
                declarations: [FullNameDetailFieldsComponent],
                exports: [FullNameDetailFieldsComponent],
                imports: [
                    CommonModule,
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(FullNameDetailFieldsModule, { declarations: [FullNameDetailFieldsComponent], imports: [CommonModule], exports: [FullNameDetailFieldsComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class VarcharDetailFieldComponent extends BaseFieldComponent {
    constructor(typeFormatter, logic, logicDisplay) {
        super(typeFormatter, logic, logicDisplay);
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    static { this.ɵfac = function VarcharDetailFieldComponent_Factory(t) { return new (t || VarcharDetailFieldComponent)(i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: VarcharDetailFieldComponent, selectors: [["scrm-varchar-detail"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, template: function VarcharDetailFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtext(0);
        } if (rf & 2) {
            i0.ɵɵtextInterpolate1("\n", ctx.field.value, "\n");
        } }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(VarcharDetailFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-varchar-detail', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n{{field.value}}\n" }]
    }], function () { return [{ type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class UrlDetailFieldComponent extends BaseFieldComponent {
    constructor(typeFormatter, logic, logicDisplay) {
        super(typeFormatter, logic, logicDisplay);
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    get target() {
        if (this.field.metadata && this.field.metadata.target) {
            return this.field.metadata.target;
        }
        return '_blank';
    }
    static { this.ɵfac = function UrlDetailFieldComponent_Factory(t) { return new (t || UrlDetailFieldComponent)(i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: UrlDetailFieldComponent, selectors: [["scrm-url-detail"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 3, consts: [[3, "target", "href"]], template: function UrlDetailFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "a", 0);
            i0.ɵɵtext(1);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵpropertyInterpolate("href", ctx.field.value, i0.ɵɵsanitizeUrl);
            i0.ɵɵproperty("target", ctx.target);
            i0.ɵɵadvance(1);
            i0.ɵɵtextInterpolate(ctx.field.value);
        } }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(UrlDetailFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-url-detail', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<a [target]=\"target\" href=\"{{ this.field.value }}\">{{ this.field.value }}</a>\n" }]
    }], function () { return [{ type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class BaseDateTimeComponent extends BaseFieldComponent {
    constructor(formatter, typeFormatter, logic, logicDisplay) {
        super(typeFormatter, logic, logicDisplay);
        this.formatter = formatter;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
        this.vm$ = this.formatter.format$;
    }
    getDateTimeFormat() {
        if (this.field?.metadata?.date_time_format) {
            return this.field.metadata.date_time_format;
        }
        return this.formatter.getDateTimeFormat();
    }
    toInternalFormat(fieldType, value) {
        return this.formatter.toInternalFormat(value, { fromFormat: this.getDateTimeFormat() });
    }
    static { this.ɵfac = function BaseDateTimeComponent_Factory(t) { return new (t || BaseDateTimeComponent)(i0.ɵɵdirectiveInject(DatetimeFormatter), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: BaseDateTimeComponent, selectors: [["ng-component"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 0, vars: 0, template: function BaseDateTimeComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseDateTimeComponent, [{
        type: Component,
        args: [{ template: '' }]
    }], function () { return [{ type: DatetimeFormatter }, { type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class BaseDateComponent extends BaseDateTimeComponent {
    constructor(formatter, typeFormatter, logic, logicDisplay) {
        super(formatter, typeFormatter, logic, logicDisplay);
        this.formatter = formatter;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    getDateFormat() {
        if (this.field?.metadata?.date_time_format) {
            return this.field?.metadata?.date_time_format ?? '';
        }
        return this.formatter.getDateFormat();
    }
    toInternalFormat(fieldType, value) {
        return this.formatter.toInternalFormat(value, { fromFormat: this.getDateFormat() });
    }
    static { this.ɵfac = function BaseDateComponent_Factory(t) { return new (t || BaseDateComponent)(i0.ɵɵdirectiveInject(DatetimeFormatter), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: BaseDateComponent, selectors: [["ng-component"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 0, vars: 0, template: function BaseDateComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseDateComponent, [{
        type: Component,
        args: [{ template: '' }]
    }], function () { return [{ type: DatetimeFormatter }, { type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function DateDetailFieldComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtext(1);
    i0.ɵɵpipe(2, "date");
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", i0.ɵɵpipeBind2(2, 1, ctx_r0.field.value, ctx_r0.getDateFormat()), "\n");
} }
class DateDetailFieldComponent extends BaseDateComponent {
    constructor(formatter, typeFormatter, logic, logicDisplay) {
        super(formatter, typeFormatter, logic, logicDisplay);
        this.formatter = formatter;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    static { this.ɵfac = function DateDetailFieldComponent_Factory(t) { return new (t || DateDetailFieldComponent)(i0.ɵɵdirectiveInject(DateFormatter), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: DateDetailFieldComponent, selectors: [["scrm-date-detail"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 3, consts: [[4, "ngIf"]], template: function DateDetailFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, DateDetailFieldComponent_ng_container_0_Template, 3, 4, "ng-container", 0);
            i0.ɵɵpipe(1, "async");
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", i0.ɵɵpipeBind1(1, 1, ctx.vm$));
        } }, dependencies: [i2.NgIf, i2.AsyncPipe, i2.DatePipe], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateDetailFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-date-detail', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<ng-container *ngIf=\"(vm$ | async) as vm\">\n    {{field.value | date:getDateFormat()}}\n</ng-container>\n" }]
    }], function () { return [{ type: DateFormatter }, { type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DateDetailFieldModule {
    static { this.ɵfac = function DateDetailFieldModule_Factory(t) { return new (t || DateDetailFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: DateDetailFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateDetailFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [DateDetailFieldComponent],
                exports: [DateDetailFieldComponent],
                imports: [
                    CommonModule,
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(DateDetailFieldModule, { declarations: [DateDetailFieldComponent], imports: [CommonModule], exports: [DateDetailFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class FormatCurrencyPipe {
    constructor(formatter) {
        this.formatter = formatter;
    }
    transform(value, options = null) {
        return this.formatter.toUserFormat(value, options);
    }
    static { this.ɵfac = function FormatCurrencyPipe_Factory(t) { return new (t || FormatCurrencyPipe)(i0.ɵɵdirectiveInject(CurrencyFormatter, 16)); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "formatCurrency", type: FormatCurrencyPipe, pure: true }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FormatCurrencyPipe, [{
        type: Pipe,
        args: [{
                name: 'formatCurrency'
            }]
    }], function () { return [{ type: CurrencyFormatter }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class FormatCurrencyModule {
    static { this.ɵfac = function FormatCurrencyModule_Factory(t) { return new (t || FormatCurrencyModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: FormatCurrencyModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FormatCurrencyModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    FormatCurrencyPipe
                ],
                exports: [
                    FormatCurrencyPipe
                ],
                imports: [
                    CommonModule,
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(FormatCurrencyModule, { declarations: [FormatCurrencyPipe], imports: [CommonModule], exports: [FormatCurrencyPipe] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class BaseNumberComponent extends BaseFieldComponent {
    constructor(userPreferences, systemConfig, typeFormatter, logic, logicDisplay) {
        super(typeFormatter, logic, logicDisplay);
        this.userPreferences = userPreferences;
        this.systemConfig = systemConfig;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
        this.preferences$ = this.userPreferences.userPreferences$;
        this.configs$ = this.systemConfig.configs$;
        this.vm$ = this.configs$.pipe(combineLatestWith(this.preferences$), map(([configs, preferences]) => ({
            configs,
            preferences,
        })));
    }
    get format() {
        if (!this.field.metadata) {
            return true;
        }
        return this.field.metadata.format !== false;
    }
    static { this.ɵfac = function BaseNumberComponent_Factory(t) { return new (t || BaseNumberComponent)(i0.ɵɵdirectiveInject(UserPreferenceStore), i0.ɵɵdirectiveInject(SystemConfigStore), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: BaseNumberComponent, selectors: [["ng-component"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 0, vars: 0, template: function BaseNumberComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseNumberComponent, [{
        type: Component,
        args: [{ template: '' }]
    }], function () { return [{ type: UserPreferenceStore }, { type: SystemConfigStore }, { type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function CurrencyDetailFieldComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtext(1);
    i0.ɵɵpipe(2, "formatCurrency");
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", i0.ɵɵpipeBind2(2, 1, ctx_r0.getCurrencyValue(), ctx_r0.getOptions()), "\n");
} }
class CurrencyDetailFieldComponent extends BaseNumberComponent {
    constructor(userPreferences, systemConfig, typeFormatter, logic, currencyService, logicDisplay) {
        super(userPreferences, systemConfig, typeFormatter, logic, logicDisplay);
        this.userPreferences = userPreferences;
        this.systemConfig = systemConfig;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.currencyService = currencyService;
        this.logicDisplay = logicDisplay;
    }
    getOptions() {
        let options = {};
        if (this.field && this.field.metadata && this.field.metadata.digits !== null && isFinite(this.field.metadata.digits)) {
            options = {
                digits: this.field.metadata.digits
            };
        }
        const isBase = this.currencyService.isBase(this.field);
        let currencyId = this.currencyService.getCurrencyId(this.record);
        if (isBase || currencyId === null) {
            currencyId = this.currencyService.getUserCurrency().id;
        }
        options.symbol = this.currencyService.getSymbol(currencyId);
        options.code = this.currencyService.getCode(currencyId);
        return options;
    }
    getCurrencyValue() {
        return this.currencyService.getFieldCurrencyValue(this.field, this.record);
    }
    static { this.ɵfac = function CurrencyDetailFieldComponent_Factory(t) { return new (t || CurrencyDetailFieldComponent)(i0.ɵɵdirectiveInject(UserPreferenceStore), i0.ɵɵdirectiveInject(SystemConfigStore), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(CurrencyService), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: CurrencyDetailFieldComponent, selectors: [["scrm-currency-detail"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 3, consts: [[4, "ngIf"]], template: function CurrencyDetailFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, CurrencyDetailFieldComponent_ng_container_0_Template, 3, 4, "ng-container", 0);
            i0.ɵɵpipe(1, "async");
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", i0.ɵɵpipeBind1(1, 1, ctx.vm$));
        } }, dependencies: [i2.NgIf, i2.AsyncPipe, FormatCurrencyPipe], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CurrencyDetailFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-currency-detail', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<ng-container *ngIf=\"(vm$ | async) as vm\">\n    {{this.getCurrencyValue() | formatCurrency:getOptions()}}\n</ng-container>\n" }]
    }], function () { return [{ type: UserPreferenceStore }, { type: SystemConfigStore }, { type: DataTypeFormatter }, { type: FieldLogicManager }, { type: CurrencyService }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class CurrencyDetailFieldModule {
    static { this.ɵfac = function CurrencyDetailFieldModule_Factory(t) { return new (t || CurrencyDetailFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: CurrencyDetailFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormatCurrencyModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CurrencyDetailFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [CurrencyDetailFieldComponent],
                exports: [CurrencyDetailFieldComponent],
                imports: [
                    CommonModule,
                    FormatCurrencyModule,
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(CurrencyDetailFieldModule, { declarations: [CurrencyDetailFieldComponent], imports: [CommonModule,
        FormatCurrencyModule], exports: [CurrencyDetailFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class TextDetailFieldComponent extends BaseFieldComponent {
    constructor(typeFormatter, logic, logicDisplay) {
        super(typeFormatter, logic, logicDisplay);
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    get rows() {
        if (this.field.metadata && this.field.metadata.rows) {
            return this.field.metadata.rows;
        }
        return 6;
    }
    get cols() {
        if (this.field.metadata && this.field.metadata.cols) {
            return this.field.metadata.cols;
        }
        return 20;
    }
    static { this.ɵfac = function TextDetailFieldComponent_Factory(t) { return new (t || TextDetailFieldComponent)(i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: TextDetailFieldComponent, selectors: [["scrm-text-detail"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 1, consts: [["readonly", "", 1, "detail-pre-styling"]], template: function TextDetailFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "pre", 0);
            i0.ɵɵtext(1);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance(1);
            i0.ɵɵtextInterpolate(ctx.field.value);
        } }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TextDetailFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-text-detail', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<pre readonly class=\"detail-pre-styling\">{{field.value}}</pre>\n" }]
    }], function () { return [{ type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class VarcharEditFieldComponent extends BaseFieldComponent {
    constructor(typeFormatter, logic, logicDisplay) {
        super(typeFormatter, logic, logicDisplay);
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    ngOnInit() {
        super.ngOnInit();
        this.subscribeValueChanges();
    }
    ngOnDestroy() {
        this.unsubscribeAll();
    }
    static { this.ɵfac = function VarcharEditFieldComponent_Factory(t) { return new (t || VarcharEditFieldComponent)(i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: VarcharEditFieldComponent, selectors: [["scrm-varchar-edit"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 5, consts: [["type", "text", 3, "formControl", "value", "ngClass"]], template: function VarcharEditFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelement(0, "input", 0);
        } if (rf & 2) {
            i0.ɵɵclassProp("is-invalid", ctx.validateOnlyOnSubmit ? ctx.isInvalid() : ctx.field.formControl.invalid && ctx.field.formControl.touched);
            i0.ɵɵproperty("formControl", ctx.field.formControl)("value", ctx.field.value)("ngClass", ctx.klass);
        } }, dependencies: [i2.NgClass, i5$1.DefaultValueAccessor, i5$1.NgControlStatus, i5$1.FormControlDirective], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(VarcharEditFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-varchar-edit', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<input [class.is-invalid]=\"validateOnlyOnSubmit ? isInvalid() : (field.formControl.invalid && field.formControl.touched)\"\n       [formControl]=\"field.formControl\"\n       [value]=\"field.value\"\n       [ngClass]=\"klass\"\n       type=\"text\">\n" }]
    }], function () { return [{ type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

class DateTimeModel {
    constructor(init) {
        this.hourStep = 1;
        this.minuteStep = 15;
        this.secondStep = 30;
        this.displaySeconds = false;
        Object.assign(this, init);
    }
    static toDateTimeStruct(formatter, dateString) {
        if (!dateString) {
            return null;
        }
        const dateTimeStruct = formatter.userDateTimeFormatToStruct(dateString);
        if (!dateTimeStruct) {
            return null;
        }
        const { date, time } = dateTimeStruct;
        return new DateTimeModel({
            date: date,
            time: time
        });
    }
    static internalToDateTimeStruct(formatter, dateString) {
        if (!dateString) {
            return null;
        }
        const dateTimeStruct = formatter.internalDateTimeFormatToStruct(dateString);
        if (!dateTimeStruct) {
            return null;
        }
        const { date, time } = dateTimeStruct;
        return new DateTimeModel({
            date: date,
            time: time
        });
    }
    toUserFormat(formatter, options) {
        //prepare datetime string in yyyy-M-d H:m:s format (datetimepicker default)
        const dateString = [this.date.year, this.date.month, this.date.day].join('-');
        const timeString = [this.time.hour, this.time.minute, this.time.second].join(':');
        const datetimeString = [dateString, timeString].join(' ');
        const internalDateTimeString = formatter.toInternalFormat(datetimeString, { fromFormat: 'yyyy-M-d H:m:s' });
        //convert from yyyy-M-d H:m:s format to user format
        return formatter.toUserFormat(internalDateTimeString, { ...options, fromFormat: 'yyyy-M-d H:m:s' });
    }
}

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function DateTimeEditFieldComponent_ng_template_4_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div")(1, "div")(2, "ngb-datepicker", 5);
    i0.ɵɵlistener("dateSelect", function DateTimeEditFieldComponent_ng_template_4_Template_ngb_datepicker_dateSelect_2_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.onDateChange($event)); });
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(3, "div", 6)(4, "ngb-timepicker", 7);
    i0.ɵɵlistener("ngModelChange", function DateTimeEditFieldComponent_ng_template_4_Template_ngb_timepicker_ngModelChange_4_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r4 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r4.onTimeChange($event)); });
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngModel", ctx_r1.dateTimeModel.date)("startDate", ctx_r1.dateTimeModel.date);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngModel", ctx_r1.dateTimeModel.time)("seconds", ctx_r1.dateTimeModel.displaySeconds)("hourStep", ctx_r1.dateTimeModel.hourStep)("minuteStep", ctx_r1.dateTimeModel.minuteStep)("secondStep", ctx_r1.dateTimeModel.secondStep);
} }
class DateTimeEditFieldComponent extends BaseDateTimeComponent {
    constructor(formatter, typeFormatter, calendar, config, logic, logicDisplay) {
        super(formatter, typeFormatter, logic, logicDisplay);
        this.formatter = formatter;
        this.typeFormatter = typeFormatter;
        this.calendar = calendar;
        this.config = config;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
        this.dateTimeModel = new DateTimeModel();
        config.autoClose = "outside";
        config.placement = this.getPlacement();
    }
    ngOnInit() {
        // Note: handle NgbDatePicker default validation
        // Note: convert empty form value to null for the ngb date validator to pass it
        if (isVoid(this.field.value) || isEmptyString(this.field.value)) {
            this.dateTimeModel.date = this.calendar.getToday();
            this.dateTimeModel.time = { hour: 0, minute: 0, second: 0 };
            this.field.formControl.setValue(null);
        }
        else {
            this.dateTimeModel = DateTimeModel.internalToDateTimeStruct(this.formatter, this.field.value);
            if (this.dateTimeModel === null) {
                this.field.formControl.setValue(null);
                return;
            }
            this.setFormValues(this.dateTimeModel.toUserFormat(this.formatter, { toFormat: this.getDateTimeFormat() }));
        }
        // enable seconds in timepicker
        if (this.formatter.getTimeFormat().includes('ss')) {
            this.dateTimeModel.displaySeconds = true;
        }
        this.subscribeValueChanges();
    }
    ngOnDestroy() {
        this.unsubscribeAll();
    }
    setFormValues(dateTimeString) {
        this.field.formControl.setValue(dateTimeString);
    }
    onDateChange(date) {
        this.dateTimeModel.date = date;
        this.setFormValues(this.dateTimeModel.toUserFormat(this.formatter, { toFormat: this.getDateTimeFormat() }));
        this.field.formControl.markAsDirty();
    }
    onTimeChange(time) {
        this.dateTimeModel.time = time;
        this.setFormValues(this.dateTimeModel.toUserFormat(this.formatter, { toFormat: this.getDateTimeFormat() }));
        this.field.formControl.markAsDirty();
    }
    onInputChange($event) {
        const dateTimeModel = DateTimeModel.toDateTimeStruct(this.formatter, $event.target.value);
        if (!dateTimeModel) {
            return;
        }
        this.dateTimeModel = dateTimeModel;
    }
    getOpenButton() {
        return {
            klass: 'btn btn-sm btn-outline-secondary m-0 border-0',
            icon: 'calendar'
        };
    }
    getPlacement() {
        return ['bottom-right', 'top-right', 'bottom-left', 'top-left'];
    }
    static { this.ɵfac = function DateTimeEditFieldComponent_Factory(t) { return new (t || DateTimeEditFieldComponent)(i0.ɵɵdirectiveInject(DatetimeFormatter), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(i3$1.NgbCalendar), i0.ɵɵdirectiveInject(i3$1.NgbPopoverConfig), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: DateTimeEditFieldComponent, selectors: [["scrm-datetime-edit"]], viewQuery: function DateTimeEditFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(NgbPopover, 7);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.popover = _t.first);
        } }, features: [i0.ɵɵInheritDefinitionFeature], decls: 6, vars: 8, consts: [[1, "input-group", "mr-2"], [3, "ngClass", "placeholder", "formControl", "ngbPopover", "change"], [1, "input-group-append"], [3, "config", "ngbPopover"], ["calendarContent", ""], ["name", "datepicker", 3, "ngModel", "startDate", "dateSelect"], [1, "d-flex", "justify-content-center", "mt-auto"], ["name", "timepicker", 3, "ngModel", "seconds", "hourStep", "minuteStep", "secondStep", "ngModelChange"]], template: function DateTimeEditFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "input", 1);
            i0.ɵɵlistener("change", function DateTimeEditFieldComponent_Template_input_change_1_listener($event) { return ctx.onInputChange($event); });
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(2, "div", 2);
            i0.ɵɵelement(3, "scrm-button", 3);
            i0.ɵɵelementEnd()();
            i0.ɵɵtemplate(4, DateTimeEditFieldComponent_ng_template_4_Template, 5, 7, "ng-template", null, 4, i0.ɵɵtemplateRefExtractor);
        } if (rf & 2) {
            const _r0 = i0.ɵɵreference(5);
            i0.ɵɵadvance(1);
            i0.ɵɵclassProp("is-invalid", ctx.validateOnlyOnSubmit ? ctx.isInvalid() : ctx.field.formControl.invalid && ctx.field.formControl.touched);
            i0.ɵɵproperty("ngClass", ctx.klass)("placeholder", ctx.getDateTimeFormat().toLowerCase())("formControl", ctx.field.formControl)("ngbPopover", _r0);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("config", ctx.getOpenButton())("ngbPopover", _r0);
        } }, dependencies: [i2.NgClass, i5$1.DefaultValueAccessor, i5$1.NgControlStatus, i5$1.NgModel, i3$1.NgbDatepicker, i3$1.NgbTimepicker, ButtonComponent, i5$1.FormControlDirective, i3$1.NgbPopover], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateTimeEditFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-datetime-edit', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n\n<div class=\"input-group mr-2\">\n\n    <input\n        [ngClass]=\"klass\"\n        [placeholder]=\"getDateTimeFormat().toLowerCase()\"\n        [class.is-invalid]=\"validateOnlyOnSubmit ? isInvalid() : (field.formControl.invalid && field.formControl.touched)\"\n        [formControl]=\"field.formControl\"\n        (change)=\"onInputChange($event)\"\n        [ngbPopover]=\"calendarContent\"\n    >\n\n    <div class=\"input-group-append\">\n        <scrm-button [config]=\"getOpenButton()\" [ngbPopover]=\"calendarContent\">\n        </scrm-button>\n    </div>\n</div>\n\n<ng-template #calendarContent>\n    <div>\n        <div>\n            <ngb-datepicker name=\"datepicker\"\n                            [ngModel]=\"dateTimeModel.date\"\n                            (dateSelect)=\"onDateChange($event)\" [startDate]=\"dateTimeModel.date\"></ngb-datepicker>\n        </div>\n\n        <div class=\"d-flex justify-content-center mt-auto\">\n            <ngb-timepicker name=\"timepicker\"\n                            [ngModel]=\"dateTimeModel.time\" (ngModelChange)=\"onTimeChange($event)\"\n                            [seconds]=\"dateTimeModel.displaySeconds\" [hourStep]=\"dateTimeModel.hourStep\"\n                            [minuteStep]=\"dateTimeModel.minuteStep\"\n                            [secondStep]=\"dateTimeModel.secondStep\">\n            </ngb-timepicker>\n        </div>\n    </div>\n</ng-template>\n" }]
    }], function () { return [{ type: DatetimeFormatter }, { type: DataTypeFormatter }, { type: i3$1.NgbCalendar }, { type: i3$1.NgbPopoverConfig }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, { popover: [{
            type: ViewChild,
            args: [NgbPopover, { static: true }]
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DateTimeEditFieldModule {
    static { this.ɵfac = function DateTimeEditFieldModule_Factory(t) { return new (t || DateTimeEditFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: DateTimeEditFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormsModule,
            NgbDatepickerModule,
            NgbTimepickerModule,
            ImageModule,
            ButtonModule,
            ReactiveFormsModule,
            NgbModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateTimeEditFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [DateTimeEditFieldComponent],
                exports: [DateTimeEditFieldComponent],
                imports: [
                    CommonModule,
                    FormsModule,
                    NgbDatepickerModule,
                    NgbTimepickerModule,
                    ImageModule,
                    ButtonModule,
                    ReactiveFormsModule,
                    NgbModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(DateTimeEditFieldModule, { declarations: [DateTimeEditFieldComponent], imports: [CommonModule,
        FormsModule,
        NgbDatepickerModule,
        NgbTimepickerModule,
        ImageModule,
        ButtonModule,
        ReactiveFormsModule,
        NgbModule], exports: [DateTimeEditFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DateParserFormatter extends NgbDateParserFormatter {
    constructor(formatter) {
        super();
        this.formatter = formatter;
    }
    getUserFormat() {
        return this.userFormat;
    }
    setUserFormat(format) {
        this.userFormat = format;
    }
    parse(value) {
        if (!value) {
            return null;
        }
        const options = { fromFormat: 'yyyy-M-d' };
        if (this.userFormat) {
            options.toFormat = this.userFormat;
        }
        return this.formatter.dateFormatToStruct(value, options.toFormat || this.formatter.getUserFormat());
    }
    format(date) {
        if (!date) {
            return null;
        }
        const dateString = [date.year, date.month, date.day].join('-');
        const options = { fromFormat: 'yyyy-M-d' };
        if (this.userFormat) {
            options.toFormat = this.userFormat;
        }
        return this.formatter.toUserFormat(dateString, options);
    }
    static { this.ɵfac = function DateParserFormatter_Factory(t) { return new (t || DateParserFormatter)(i0.ɵɵinject(DateFormatter)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: DateParserFormatter, factory: DateParserFormatter.ɵfac }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateParserFormatter, [{
        type: Injectable
    }], function () { return [{ type: DateFormatter }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DateAdapter extends NgbDateAdapter {
    constructor(formatter) {
        super();
        this.formatter = formatter;
    }
    getUserFormat() {
        return this.userFormat;
    }
    setUserFormat(format) {
        this.userFormat = format;
    }
    fromModel(value) {
        if (!value) {
            return null;
        }
        return this.formatter.dateFormatToStruct(value, this.userFormat || '');
    }
    toModel(date) {
        if (!date) {
            return null;
        }
        const dateString = [date.year, date.month, date.day].join('-');
        const options = { fromFormat: 'yyyy-M-d' };
        if (this.userFormat) {
            options.toFormat = this.userFormat;
        }
        return this.formatter.toUserFormat(dateString, options);
    }
    static { this.ɵfac = function DateAdapter_Factory(t) { return new (t || DateAdapter)(i0.ɵɵinject(DateFormatter)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: DateAdapter, factory: DateAdapter.ɵfac }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateAdapter, [{
        type: Injectable
    }], function () { return [{ type: DateFormatter }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DateEditFieldComponent extends BaseDateComponent {
    constructor(formatter, dateAdapter, dateParserFormatter, typeFormatter, logic, logicDisplay) {
        super(formatter, typeFormatter, logic, logicDisplay);
        this.formatter = formatter;
        this.dateAdapter = dateAdapter;
        this.dateParserFormatter = dateParserFormatter;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    ngOnInit() {
        // Note: handle NgbDatePicker default validation
        // Note: convert empty form value to null for the ngb date validator to pass it
        if (isVoid(this.field.value) || isEmptyString(this.field.value)) {
            this.field.formControl.setValue(null);
        }
        else {
            this.field.formControl.setValue(this.formatter.toUserFormat(this.field.value, { toFormat: this.getDateFormat() }));
        }
        const adapter = this.dateAdapter;
        adapter.setUserFormat(this.getDateFormat());
        const parserFormatter = this.dateParserFormatter;
        parserFormatter.setUserFormat(this.getDateFormat());
        this.dateModel = this.formatter.dateFormatToStruct(this.field.value, this.formatter.getInternalFormat());
        this.subscribeValueChanges();
    }
    ngOnDestroy() {
        this.unsubscribeAll();
    }
    setModel(value) {
        this.field.value = this.formatter.toInternalFormat(value, { fromFormat: this.getDateFormat() });
        this.dateModel = this.formatter.dateFormatToStruct(value, this.getDateFormat());
    }
    getOpenButton(datepicker) {
        return {
            klass: 'btn btn-sm btn-outline-secondary m-0 border-0',
            // eslint-disable-next-line @typescript-eslint/explicit-function-return-type
            onClick: () => {
                datepicker.toggle();
                datepicker.navigateTo(this.dateModel);
            },
            icon: 'calendar'
        };
    }
    openDatePicker(datepicker) {
        datepicker.toggle(); // Open the datepicker popup
        datepicker.navigateTo(this.dateModel);
    }
    getPlacement() {
        return ['bottom-left', 'bottom-right', 'top-left', 'top-right'];
    }
    static { this.ɵfac = function DateEditFieldComponent_Factory(t) { return new (t || DateEditFieldComponent)(i0.ɵɵdirectiveInject(DateFormatter), i0.ɵɵdirectiveInject(i3$1.NgbDateAdapter), i0.ɵɵdirectiveInject(i3$1.NgbDateParserFormatter), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: DateEditFieldComponent, selectors: [["scrm-date-edit"]], features: [i0.ɵɵProvidersFeature([
                { provide: NgbDateAdapter, useClass: DateAdapter },
                { provide: NgbDateParserFormatter, useClass: DateParserFormatter }
            ]), i0.ɵɵInheritDefinitionFeature], decls: 5, vars: 8, consts: [[1, "field-datetime-edit", "input-group"], ["ngbDatepicker", "", 3, "ngClass", "placement", "placeholder", "formControl", "startDate", "ngModelChange", "click"], ["datepicker", "ngbDatepicker"], [1, "input-group-append", "align-items-end"], [3, "config"]], template: function DateEditFieldComponent_Template(rf, ctx) { if (rf & 1) {
            const _r1 = i0.ɵɵgetCurrentView();
            i0.ɵɵelementStart(0, "div", 0)(1, "input", 1, 2);
            i0.ɵɵlistener("ngModelChange", function DateEditFieldComponent_Template_input_ngModelChange_1_listener($event) { return ctx.setModel($event); })("click", function DateEditFieldComponent_Template_input_click_1_listener() { i0.ɵɵrestoreView(_r1); const _r0 = i0.ɵɵreference(2); return i0.ɵɵresetView(ctx.openDatePicker(_r0)); });
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(3, "span", 3);
            i0.ɵɵelement(4, "scrm-button", 4);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            const _r0 = i0.ɵɵreference(2);
            i0.ɵɵadvance(1);
            i0.ɵɵclassProp("is-invalid", ctx.validateOnlyOnSubmit ? ctx.isInvalid() : ctx.field.formControl.invalid && ctx.field.formControl.touched);
            i0.ɵɵproperty("ngClass", ctx.klass)("placement", ctx.getPlacement())("placeholder", ctx.getDateFormat().toLowerCase())("formControl", ctx.field.formControl)("startDate", ctx.dateModel);
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("config", ctx.getOpenButton(_r0));
        } }, dependencies: [i2.NgClass, i5$1.DefaultValueAccessor, i5$1.NgControlStatus, i3$1.NgbInputDatepicker, ButtonComponent, i5$1.FormControlDirective], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateEditFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-date-edit', providers: [
                    { provide: NgbDateAdapter, useClass: DateAdapter },
                    { provide: NgbDateParserFormatter, useClass: DateParserFormatter }
                ], template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<div class=\"field-datetime-edit input-group\">\n    <input ngbDatepicker\n           [ngClass]=\"klass\"\n           [placement]=\"getPlacement()\"\n           [placeholder]=\"getDateFormat().toLowerCase()\"\n           [class.is-invalid]=\"validateOnlyOnSubmit ? isInvalid() : (field.formControl.invalid && field.formControl.touched)\"\n           [formControl]=\"field.formControl\"\n           [startDate]=\"dateModel\"\n           (ngModelChange)=\"setModel($event)\"\n           (click)=\"openDatePicker(datepicker)\"\n           #datepicker=\"ngbDatepicker\">\n    <span class=\"input-group-append align-items-end\">\n        <scrm-button [config]=\"getOpenButton(datepicker)\">\n        </scrm-button>\n    </span>\n</div>\n" }]
    }], function () { return [{ type: DateFormatter }, { type: i3$1.NgbDateAdapter }, { type: i3$1.NgbDateParserFormatter }, { type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DateFilterFieldComponent extends DateEditFieldComponent {
    constructor(formatter, dateAdapter, dateParserFormatter, typeFormatter, logic, logicDisplay) {
        super(formatter, dateAdapter, dateParserFormatter, typeFormatter, logic, logicDisplay);
        this.formatter = formatter;
        this.dateAdapter = dateAdapter;
        this.dateParserFormatter = dateParserFormatter;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    ngOnInit() {
        let current = null;
        if (this.field.criteria.values && this.field.criteria.values.length > 0) {
            current = this.field.criteria.values[0];
        }
        if (!isVoid(current) && !isEmptyString(current)) {
            current = current.trim();
        }
        this.field.value = current ?? '';
        super.ngOnInit();
    }
    setFieldValue(newValue) {
        super.setFieldValue(newValue);
        this.field.criteria.operator = '=';
        this.field.criteria.values = [newValue];
    }
    static { this.ɵfac = function DateFilterFieldComponent_Factory(t) { return new (t || DateFilterFieldComponent)(i0.ɵɵdirectiveInject(DateFormatter), i0.ɵɵdirectiveInject(i3$1.NgbDateAdapter), i0.ɵɵdirectiveInject(i3$1.NgbDateParserFormatter), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: DateFilterFieldComponent, selectors: [["scrm-date-filter"]], features: [i0.ɵɵProvidersFeature([
                { provide: NgbDateAdapter, useClass: DateAdapter },
                { provide: NgbDateParserFormatter, useClass: DateParserFormatter }
            ]), i0.ɵɵInheritDefinitionFeature], decls: 5, vars: 8, consts: [[1, "input-group"], ["ngbDatepicker", "", 3, "ngClass", "placement", "placeholder", "formControl", "startDate", "ngModelChange"], ["datepicker", "ngbDatepicker"], [1, "input-group-append", "align-items-end"], [3, "config"]], template: function DateFilterFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "input", 1, 2);
            i0.ɵɵlistener("ngModelChange", function DateFilterFieldComponent_Template_input_ngModelChange_1_listener($event) { return ctx.setModel($event); });
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(3, "span", 3);
            i0.ɵɵelement(4, "scrm-button", 4);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            const _r0 = i0.ɵɵreference(2);
            i0.ɵɵadvance(1);
            i0.ɵɵclassProp("is-invalid", ctx.validateOnlyOnSubmit ? ctx.isInvalid() : ctx.field.formControl.invalid && ctx.field.formControl.touched);
            i0.ɵɵproperty("ngClass", ctx.klass)("placement", ctx.getPlacement())("placeholder", ctx.getDateFormat().toLowerCase())("formControl", ctx.field.formControl)("startDate", ctx.dateModel);
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("config", ctx.getOpenButton(_r0));
        } }, dependencies: [i2.NgClass, i5$1.DefaultValueAccessor, i5$1.NgControlStatus, i3$1.NgbInputDatepicker, ButtonComponent, i5$1.FormControlDirective], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateFilterFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-date-filter', providers: [
                    { provide: NgbDateAdapter, useClass: DateAdapter },
                    { provide: NgbDateParserFormatter, useClass: DateParserFormatter }
                ], template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<div class=\"input-group\">\n    <input ngbDatepicker\n           [ngClass]=\"klass\"\n           [placement]=\"getPlacement()\"\n           [placeholder]=\"getDateFormat().toLowerCase()\"\n           [class.is-invalid]=\"validateOnlyOnSubmit ? isInvalid() : (field.formControl.invalid && field.formControl.touched)\"\n           [formControl]=\"field.formControl\"\n           [startDate]=\"dateModel\"\n           (ngModelChange)=\"setModel($event)\"\n           #datepicker=\"ngbDatepicker\">\n    <span class=\"input-group-append align-items-end\">\n        <scrm-button [config]=\"getOpenButton(datepicker)\">\n        </scrm-button>\n    </span>\n</div>\n" }]
    }], function () { return [{ type: DateFormatter }, { type: i3$1.NgbDateAdapter }, { type: i3$1.NgbDateParserFormatter }, { type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function DateTimeDetailFieldComponent_ng_container_0_span_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span");
    i0.ɵɵtext(1);
    i0.ɵɵpipe(2, "date");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", i0.ɵɵpipeBind3(2, 1, ctx_r2.toDateTime(ctx_r2.field.value), ctx_r2.getDateTimeFormat(), ctx_r2.getUserTimeZone()), " ");
} }
function DateTimeDetailFieldComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, DateTimeDetailFieldComponent_ng_container_0_span_1_Template, 3, 5, "span", 0);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r0.field.value);
} }
class DateTimeDetailFieldComponent extends BaseDateTimeComponent {
    constructor(formatter, typeFormatter, logic, logicDisplay) {
        super(formatter, typeFormatter, logic, logicDisplay);
        this.formatter = formatter;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    getUserTimeZone() {
        return this.formatter.userTimeZone();
    }
    toDateTime(dateString) {
        return this.formatter.toDateTime(dateString, this.formatter.getInternalFormat(), {
            zone: 'GMT'
        }).toJSDate();
    }
    static { this.ɵfac = function DateTimeDetailFieldComponent_Factory(t) { return new (t || DateTimeDetailFieldComponent)(i0.ɵɵdirectiveInject(DatetimeFormatter), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: DateTimeDetailFieldComponent, selectors: [["scrm-datetime-detail"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 3, consts: [[4, "ngIf"]], template: function DateTimeDetailFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, DateTimeDetailFieldComponent_ng_container_0_Template, 2, 1, "ng-container", 0);
            i0.ɵɵpipe(1, "async");
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", i0.ɵɵpipeBind1(1, 1, ctx.vm$));
        } }, dependencies: [i2.NgIf, i2.AsyncPipe, i2.DatePipe], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateTimeDetailFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-datetime-detail', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<ng-container *ngIf=\"(vm$ | async) as vm\">\n    <span *ngIf=\"field.value\">\n    {{toDateTime(field.value) | date:getDateTimeFormat():getUserTimeZone()}}\n    </span>\n</ng-container>\n" }]
    }], function () { return [{ type: DatetimeFormatter }, { type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DateTimeDetailFieldModule {
    static { this.ɵfac = function DateTimeDetailFieldModule_Factory(t) { return new (t || DateTimeDetailFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: DateTimeDetailFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateTimeDetailFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [DateTimeDetailFieldComponent],
                exports: [DateTimeDetailFieldComponent],
                imports: [
                    CommonModule,
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(DateTimeDetailFieldModule, { declarations: [DateTimeDetailFieldComponent], imports: [CommonModule], exports: [DateTimeDetailFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function DateTimeFilterFieldComponent_ng_template_4_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div")(1, "div")(2, "ngb-datepicker", 5);
    i0.ɵɵlistener("dateSelect", function DateTimeFilterFieldComponent_ng_template_4_Template_ngb_datepicker_dateSelect_2_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.onDateChange($event)); });
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(3, "div", 6)(4, "ngb-timepicker", 7);
    i0.ɵɵlistener("ngModelChange", function DateTimeFilterFieldComponent_ng_template_4_Template_ngb_timepicker_ngModelChange_4_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r4 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r4.onTimeChange($event)); });
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngModel", ctx_r1.dateTimeModel.date)("startDate", ctx_r1.dateTimeModel.date);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngModel", ctx_r1.dateTimeModel.time)("seconds", ctx_r1.dateTimeModel.displaySeconds)("hourStep", ctx_r1.dateTimeModel.hourStep)("minuteStep", ctx_r1.dateTimeModel.minuteStep)("secondStep", ctx_r1.dateTimeModel.secondStep);
} }
class DateTimeFilterFieldComponent extends BaseDateTimeComponent {
    constructor(formatter, typeFormatter, calendar, config, logic, logicDisplay) {
        super(formatter, typeFormatter, logic, logicDisplay);
        this.formatter = formatter;
        this.typeFormatter = typeFormatter;
        this.calendar = calendar;
        this.config = config;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
        this.dateTimeModel = new DateTimeModel();
        config.autoClose = "outside";
        config.placement = this.getPlacement();
    }
    ngOnInit() {
        super.ngOnInit();
        const values = (this.field && this.field.criteria && this.field.criteria.values) || [];
        let criteria = '';
        if (values.length > 0) {
            criteria = this.field.criteria.values[0];
        }
        // Note: handle NgbDatePicker default validation
        // Note: convert empty form value to null for the ngb date validator to pass it
        if (isEmptyString(criteria)) {
            this.dateTimeModel.date = this.calendar.getToday();
            this.dateTimeModel.time = { hour: 0, minute: 0, second: 0 };
            this.field.formControl.setValue(null);
        }
        else {
            this.dateTimeModel = DateTimeModel.internalToDateTimeStruct(this.formatter, criteria);
            if (this.dateTimeModel === null) {
                this.field.formControl.setValue(null);
                return;
            }
            this.setFormValues(this.dateTimeModel.toUserFormat(this.formatter));
        }
        // enable seconds in timepicker
        if (this.formatter.getTimeFormat().includes('ss')) {
            this.dateTimeModel.displaySeconds = true;
        }
        this.subscribeValueChanges();
    }
    ngOnDestroy() {
        this.unsubscribeAll();
    }
    setFormValues(dateTimeString) {
        this.field.formControl.setValue(dateTimeString);
        this.field.formControl.markAsDirty();
    }
    setFieldValue(newValue) {
        this.field.value = newValue;
        this.field.criteria.operator = '=';
        this.field.criteria.values = [newValue];
    }
    onDateChange(date) {
        this.dateTimeModel.date = date;
        this.setFormValues(this.dateTimeModel.toUserFormat(this.formatter));
    }
    onTimeChange(time) {
        this.dateTimeModel.time = time;
        this.setFormValues(this.dateTimeModel.toUserFormat(this.formatter));
    }
    onInputChange($event) {
        const dateTimeModel = DateTimeModel.toDateTimeStruct(this.formatter, $event.target.value);
        if (!dateTimeModel) {
            return;
        }
        this.dateTimeModel = dateTimeModel;
    }
    getOpenButton() {
        return {
            klass: 'btn btn-sm btn-outline-secondary m-0 border-0',
            icon: 'calendar'
        };
    }
    getPlacement() {
        return ['bottom-right', 'top-right', 'bottom-left', 'top-left'];
    }
    static { this.ɵfac = function DateTimeFilterFieldComponent_Factory(t) { return new (t || DateTimeFilterFieldComponent)(i0.ɵɵdirectiveInject(DatetimeFormatter), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(i3$1.NgbCalendar), i0.ɵɵdirectiveInject(i3$1.NgbPopoverConfig), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: DateTimeFilterFieldComponent, selectors: [["scrm-datetime-filter"]], viewQuery: function DateTimeFilterFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(NgbPopover, 7);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.popover = _t.first);
        } }, features: [i0.ɵɵInheritDefinitionFeature], decls: 6, vars: 7, consts: [[1, "input-group", "mr-2"], [3, "ngClass", "placeholder", "formControl", "change"], [1, "input-group-append"], [3, "config", "ngbPopover"], ["calendarContent", ""], ["name", "datepicker", 3, "ngModel", "startDate", "dateSelect"], [1, "d-flex", "justify-content-center", "mt-auto"], ["name", "timepicker", 3, "ngModel", "seconds", "hourStep", "minuteStep", "secondStep", "ngModelChange"]], template: function DateTimeFilterFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "input", 1);
            i0.ɵɵlistener("change", function DateTimeFilterFieldComponent_Template_input_change_1_listener($event) { return ctx.onInputChange($event); });
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(2, "div", 2);
            i0.ɵɵelement(3, "scrm-button", 3);
            i0.ɵɵelementEnd()();
            i0.ɵɵtemplate(4, DateTimeFilterFieldComponent_ng_template_4_Template, 5, 7, "ng-template", null, 4, i0.ɵɵtemplateRefExtractor);
        } if (rf & 2) {
            const _r0 = i0.ɵɵreference(5);
            i0.ɵɵadvance(1);
            i0.ɵɵclassProp("is-invalid", ctx.validateOnlyOnSubmit ? ctx.isInvalid() : ctx.field.formControl.invalid && ctx.field.formControl.touched);
            i0.ɵɵproperty("ngClass", ctx.klass)("placeholder", ctx.getDateTimeFormat().toLowerCase())("formControl", ctx.field.formControl);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("config", ctx.getOpenButton())("ngbPopover", _r0);
        } }, dependencies: [i2.NgClass, i5$1.DefaultValueAccessor, i5$1.NgControlStatus, i5$1.NgModel, i3$1.NgbDatepicker, i3$1.NgbTimepicker, ButtonComponent, i5$1.FormControlDirective, i3$1.NgbPopover], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateTimeFilterFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-datetime-filter', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n\n<div class=\"input-group mr-2\">\n\n    <input\n        [ngClass]=\"klass\"\n        [placeholder]=\"getDateTimeFormat().toLowerCase()\"\n        [class.is-invalid]=\"validateOnlyOnSubmit ? isInvalid() : (field.formControl.invalid && field.formControl.touched)\"\n        [formControl]=\"field.formControl\"\n        (change)=\"onInputChange($event)\"\n    >\n\n    <div class=\"input-group-append\">\n        <scrm-button [config]=\"getOpenButton()\" [ngbPopover]=\"calendarContent\">\n        </scrm-button>\n    </div>\n</div>\n\n<ng-template #calendarContent>\n    <div>\n        <div>\n            <ngb-datepicker name=\"datepicker\"\n                            [ngModel]=\"dateTimeModel.date\"\n                            (dateSelect)=\"onDateChange($event)\" [startDate]=\"dateTimeModel.date\"></ngb-datepicker>\n        </div>\n\n        <div class=\"d-flex justify-content-center mt-auto\">\n            <ngb-timepicker name=\"timepicker\"\n                            [ngModel]=\"dateTimeModel.time\" (ngModelChange)=\"onTimeChange($event)\"\n                            [seconds]=\"dateTimeModel.displaySeconds\" [hourStep]=\"dateTimeModel.hourStep\"\n                            [minuteStep]=\"dateTimeModel.minuteStep\"\n                            [secondStep]=\"dateTimeModel.secondStep\">\n            </ngb-timepicker>\n        </div>\n    </div>\n</ng-template>\n" }]
    }], function () { return [{ type: DatetimeFormatter }, { type: DataTypeFormatter }, { type: i3$1.NgbCalendar }, { type: i3$1.NgbPopoverConfig }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, { popover: [{
            type: ViewChild,
            args: [NgbPopover, { static: true }]
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DateTimeFilterFieldModule {
    static { this.ɵfac = function DateTimeFilterFieldModule_Factory(t) { return new (t || DateTimeFilterFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: DateTimeFilterFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormsModule,
            NgbDatepickerModule,
            NgbTimepickerModule,
            ImageModule,
            ButtonModule,
            ReactiveFormsModule,
            NgbModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateTimeFilterFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [DateTimeFilterFieldComponent],
                exports: [DateTimeFilterFieldComponent],
                imports: [
                    CommonModule,
                    FormsModule,
                    NgbDatepickerModule,
                    NgbTimepickerModule,
                    ImageModule,
                    ButtonModule,
                    ReactiveFormsModule,
                    NgbModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(DateTimeFilterFieldModule, { declarations: [DateTimeFilterFieldComponent], imports: [CommonModule,
        FormsModule,
        NgbDatepickerModule,
        NgbTimepickerModule,
        ImageModule,
        ButtonModule,
        ReactiveFormsModule,
        NgbModule], exports: [DateTimeFilterFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function MultiEnumDetailFieldComponent_li_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "li");
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const selected_r1 = ctx.$implicit;
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate(selected_r1.label);
} }
class MultiEnumDetailFieldComponent extends BaseMultiEnumComponent {
    constructor(languages, typeFormatter, logic, logicDisplay) {
        super(languages, typeFormatter, logic, logicDisplay);
        this.languages = languages;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    static { this.ɵfac = function MultiEnumDetailFieldComponent_Factory(t) { return new (t || MultiEnumDetailFieldComponent)(i0.ɵɵdirectiveInject(LanguageStore), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: MultiEnumDetailFieldComponent, selectors: [["scrm-multienum-detail"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 1, consts: [[4, "ngFor", "ngForOf"]], template: function MultiEnumDetailFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "ul");
            i0.ɵɵtemplate(1, MultiEnumDetailFieldComponent_li_1_Template, 2, 1, "li", 0);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngForOf", ctx.selectedValues);
        } }, dependencies: [i2.NgForOf], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MultiEnumDetailFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-multienum-detail', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<ul>\n    <li *ngFor=\"let selected of selectedValues;\">{{selected.label}}</li>\n</ul>\n" }]
    }], function () { return [{ type: LanguageStore }, { type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
const _c0$E = ["tag"];
class EnumEditFieldComponent extends BaseEnumComponent {
    constructor(languages, typeFormatter, logic, logicDisplay) {
        super(languages, typeFormatter, logic, logicDisplay);
        this.languages = languages;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    ngOnInit() {
        this.checkAndInitAsDynamicEnum();
        super.ngOnInit();
    }
    onAdd(item) {
        if (item && item.value) {
            this.field.value = item.value;
            this.field.formControl.setValue(item.value);
            this.field.formControl.markAsDirty();
            return;
        }
        this.field.value = '';
        this.field.formControl.setValue('');
        this.field.formControl.markAsDirty();
        this.selectedValues = [];
        return;
    }
    onRemove() {
        this.field.value = '';
        this.field.formControl.setValue('');
        this.field.formControl.markAsDirty();
        setTimeout(() => {
            this.tag.focus(true, true);
            this.tag.dropdown.show();
        }, 200);
    }
    getPlaceholderLabel() {
        return this.languages.getAppString('LBL_SELECT_ITEM') || '';
    }
    selectFirstElement() {
        const filteredElements = this.tag.dropdown.items;
        if (filteredElements.length !== 0) {
            const firstElement = filteredElements[0];
            this.selectedValues.push(firstElement);
            this.onAdd(firstElement);
            this.tag.dropdown.hide();
        }
    }
    static { this.ɵfac = function EnumEditFieldComponent_Factory(t) { return new (t || EnumEditFieldComponent)(i0.ɵɵdirectiveInject(LanguageStore), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: EnumEditFieldComponent, selectors: [["scrm-enum-edit"]], viewQuery: function EnumEditFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0$E, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.tag = _t.first);
        } }, features: [i0.ɵɵInheritDefinitionFeature], decls: 3, vars: 15, consts: [["maxItems", "1", 3, "ngModel", "onlyFromAutocomplete", "clearOnBlur", "displayBy", "identifyBy", "placeholder", "secondaryPlaceholder", "inputClass", "ngModelChange", "onAdd", "onRemove", "keyup.enter"], ["tag", ""], [3, "displayBy", "identifyBy", "showDropdownIfEmpty", "keepOpen", "autocompleteItems"]], template: function EnumEditFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "tag-input", 0, 1);
            i0.ɵɵlistener("ngModelChange", function EnumEditFieldComponent_Template_tag_input_ngModelChange_0_listener($event) { return ctx.selectedValues = $event; })("onAdd", function EnumEditFieldComponent_Template_tag_input_onAdd_0_listener($event) { return ctx.onAdd($event); })("onRemove", function EnumEditFieldComponent_Template_tag_input_onRemove_0_listener() { return ctx.onRemove(); })("keyup.enter", function EnumEditFieldComponent_Template_tag_input_keyup_enter_0_listener() { return ctx.selectFirstElement(); });
            i0.ɵɵelement(2, "tag-input-dropdown", 2);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵclassMap(ctx.getInvalidClass());
            i0.ɵɵproperty("ngModel", ctx.selectedValues)("onlyFromAutocomplete", true)("clearOnBlur", true)("displayBy", "label")("identifyBy", "value")("placeholder", ctx.getPlaceholderLabel())("secondaryPlaceholder", ctx.getPlaceholderLabel())("inputClass", ctx.getInvalidClass());
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("displayBy", "label")("identifyBy", "value")("showDropdownIfEmpty", true)("keepOpen", false)("autocompleteItems", ctx.options);
        } }, dependencies: [i5$2.TagInputComponent, i5$2.TagInputDropdown, i5$1.NgControlStatus, i5$1.NgModel], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EnumEditFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-enum-edit', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<tag-input [(ngModel)]=\"selectedValues\"\n           [onlyFromAutocomplete]=\"true\"\n           [clearOnBlur]=\"true\"\n           [displayBy]=\"'label'\"\n           [identifyBy]=\"'value'\"\n           [placeholder]=\"getPlaceholderLabel()\"\n           [secondaryPlaceholder]=\"getPlaceholderLabel()\"\n           [class]=\"getInvalidClass()\"\n           [inputClass]=\"getInvalidClass()\"\n           maxItems=\"1\"\n           #tag\n           (onAdd)=\"onAdd($event)\"\n           (onRemove)=\"onRemove()\"\n           (keyup.enter)=\"selectFirstElement()\">\n    <tag-input-dropdown [displayBy]=\"'label'\"\n                        [identifyBy]=\"'value'\"\n                        [showDropdownIfEmpty]=\"true\"\n                        [keepOpen]=\"false\"\n                        [autocompleteItems]=\"this.options\">\n    </tag-input-dropdown>\n</tag-input>\n" }]
    }], function () { return [{ type: LanguageStore }, { type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, { tag: [{
            type: ViewChild,
            args: ['tag']
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class BaseBooleanComponent extends BaseFieldComponent {
    get checked() {
        return isTrue(this.field.value);
    }
    toggle() {
        let newValue = 'true';
        if (this.checked) {
            newValue = 'false';
        }
        this.field.value = newValue;
        this.field.formControl.setValue(newValue);
        this.field.formControl.markAsDirty();
    }
    static { this.ɵfac = /*@__PURE__*/ function () { let ɵBaseBooleanComponent_BaseFactory; return function BaseBooleanComponent_Factory(t) { return (ɵBaseBooleanComponent_BaseFactory || (ɵBaseBooleanComponent_BaseFactory = i0.ɵɵgetInheritedFactory(BaseBooleanComponent)))(t || BaseBooleanComponent); }; }(); }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: BaseBooleanComponent, selectors: [["ng-component"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 0, vars: 0, template: function BaseBooleanComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseBooleanComponent, [{
        type: Component,
        args: [{ template: '' }]
    }], null, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class BooleanDetailFieldComponent extends BaseBooleanComponent {
    constructor(typeFormatter, logic, logicDisplay) {
        super(typeFormatter, logic, logicDisplay);
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    static { this.ɵfac = function BooleanDetailFieldComponent_Factory(t) { return new (t || BooleanDetailFieldComponent)(i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: BooleanDetailFieldComponent, selectors: [["scrm-boolean-detail"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 3, vars: 1, consts: [[1, "checkbox-container"], ["type", "checkbox", "disabled", "", "readonly", "", "aria-hidden", "true", 3, "checked"], [1, "checkmark"]], template: function BooleanDetailFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "label", 0);
            i0.ɵɵelement(1, "input", 1)(2, "span", 2);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("checked", ctx.checked);
        } }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BooleanDetailFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-boolean-detail', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<label class=\"checkbox-container\">\n    <input type=\"checkbox\"\n           [checked]=\"checked\"\n           disabled\n           readonly\n           aria-hidden=\"true\">\n    <span class=\"checkmark\"></span>\n</label>\n" }]
    }], function () { return [{ type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class ModuleNameMapper {
    constructor(systemConfig) {
        this.systemConfig = systemConfig;
    }
    /**
     * Public Api
     */
    /**
     * Map the legacy name to frontend
     *
     * @param {string} module the module name
     * @returns {string} frontend name
     */
    toFrontend(module) {
        const map = this.getLegacyToFrontendMap();
        if (!map || !map[module]) {
            return module;
        }
        return map[module];
    }
    /**
     * Map the frontend name to legacy
     *
     * @param {string} module the module name
     * @returns {string} frontend name
     */
    toLegacy(module) {
        const map = this.getFrontendToLegacyMap();
        if (!map[module]) {
            return module;
        }
        return map[module];
    }
    /**
     * Check if module is valid
     *
     * @param {string} module the module name
     * @returns {boolean} is valid
     */
    isValid(module) {
        const map = this.getFrontendToLegacyMap();
        let valid = false;
        if (map[module]) {
            valid = true;
        }
        return valid;
    }
    /**
     * Internal API
     */
    /**
     * Get the legacy to frontend map
     *
     * @returns {{}} map
     */
    getLegacyToFrontendMap() {
        return this.systemConfig.getConfigValue('module_name_map');
    }
    /**
     * Get the frontend to legacy map
     *
     * @returns {{}} map
     */
    getFrontendToLegacyMap() {
        const map = this.systemConfig.getConfigValue('module_name_map');
        const invertedMap = {};
        Object.keys(map).forEach((legacyName) => {
            const frontendName = map[legacyName];
            invertedMap[frontendName] = legacyName;
        });
        return invertedMap;
    }
    static { this.ɵfac = function ModuleNameMapper_Factory(t) { return new (t || ModuleNameMapper)(i0.ɵɵinject(SystemConfigStore)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ModuleNameMapper, factory: ModuleNameMapper.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ModuleNameMapper, [{
        type: Injectable,
        args: [{ providedIn: 'root' }]
    }], function () { return [{ type: SystemConfigStore }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class ActionNameMapper {
    constructor(systemConfig) {
        this.systemConfig = systemConfig;
    }
    /**
     * Public Api
     */
    /**
     * Map the legacy name to frontend
     *
     * @param {string} action the action name
     * @returns {string} frontend name
     */
    toFrontend(action) {
        const map = this.getLegacyToFrontendMap();
        if (!map[action]) {
            return action;
        }
        return map[action];
    }
    /**
     * Map the frontend name to legacy
     *
     * @param {string} action the action name
     * @returns {string} frontend name
     */
    toLegacy(action) {
        const map = this.getFrontendToLegacyMap();
        if (!map[action]) {
            return action;
        }
        return map[action];
    }
    /**
     * Check if action is valid
     *
     * @param {string} action the action name
     * @returns {boolean} is valid
     */
    isValid(action) {
        const map = this.getFrontendToLegacyMap();
        let valid = false;
        if (map[action]) {
            valid = true;
        }
        return valid;
    }
    /**
     * Internal API
     */
    /**
     * Get the legacy to frontend map
     *
     * @returns {{}} legacy to frontend map
     */
    getLegacyToFrontendMap() {
        return this.systemConfig.getConfigValue('action_name_map');
    }
    /**
     * Get the frontend to legacy map
     *
     * @returns {{}} frontend to legacy map
     */
    getFrontendToLegacyMap() {
        const map = this.systemConfig.getConfigValue('action_name_map');
        const invertedMap = {};
        Object.keys(map).forEach((legacyName) => {
            const frontendName = map[legacyName];
            invertedMap[frontendName] = legacyName;
        });
        return invertedMap;
    }
    static { this.ɵfac = function ActionNameMapper_Factory(t) { return new (t || ActionNameMapper)(i0.ɵɵinject(SystemConfigStore)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ActionNameMapper, factory: ActionNameMapper.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ActionNameMapper, [{
        type: Injectable,
        args: [{ providedIn: 'root' }]
    }], function () { return [{ type: SystemConfigStore }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
const ROUTE_PREFIX$1 = './#';
class ModuleNavigation {
    constructor(router, moduleNameMapper, actionNameMapper) {
        this.router = router;
        this.moduleNameMapper = moduleNameMapper;
        this.actionNameMapper = actionNameMapper;
    }
    /**
     * Public Api
     */
    /**
     * Get module info
     *
     * @param {string} module name
     * @param {object} navigation info
     * @returns {object} module info
     */
    getModuleInfo(module, navigation) {
        if (!navigation || !navigation.modules) {
            return null;
        }
        return navigation.modules[module];
    }
    /**
     * Get module label
     *
     * @param {object} module info
     * @param {object} appListStrings map
     * @returns {string} the module label
     */
    getModuleLabel(module, appListStrings) {
        if (!appListStrings || !appListStrings.moduleList || !module) {
            return '';
        }
        const labelKey = (module && module.labelKey) || '';
        return appListStrings.moduleList[labelKey] || labelKey;
    }
    /**
     * Get module route
     *
     * @param {object} module NavbarModule
     * @returns {object} NavigationRoute
     */
    getModuleRoute(module) {
        let url = (module && module.defaultRoute) || '';
        let route = null;
        const params = null;
        if (url.startsWith(ROUTE_PREFIX$1)) {
            route = url.replace(ROUTE_PREFIX$1, '');
            url = null;
        }
        return { route, url, params };
    }
    /**
     * Navigate using action information
     *
     * @param {object} item ModuleAction
     * @returns {object} Promise<boolean>
     */
    navigate(item) {
        const route = this.getActionRoute(item);
        return this.router.navigate([route.route], {
            queryParams: route.params
        });
    }
    /**
     * Navigate using menu item information
     *
     * @param {object} item MenuItem
     */
    navigateUsingMenuItem(item) {
        if (item.link.route) {
            this.router.navigate([item.link.route ?? ''], {
                queryParams: item.link.params ?? {}
            }).then();
            return;
        }
        if (item.link.url) {
            this.router.navigateByUrl(item.link.url ?? '').then();
            return;
        }
    }
    /**
     * Get action route info
     *
     * @param {object} action ModuleAction
     * @returns {object} NavigationRoute
     */
    getActionRoute(action) {
        let url = action.url;
        let route = null;
        let params = {};
        let process = action?.process;
        if (url.startsWith(ROUTE_PREFIX$1)) {
            route = url.replace(ROUTE_PREFIX$1, '');
            url = null;
            if (action.params) {
                params = action.params;
            }
            else {
                const routeParts = route.split('?');
                route = routeParts[0];
                const queryParamsStr = routeParts[1];
                const queryParamsObj = {};
                if (queryParamsStr) {
                    queryParamsStr.split('&').forEach(param => {
                        const keyValue = param.split('=');
                        queryParamsObj[keyValue[0]] = keyValue[1];
                    });
                }
                params = queryParamsObj;
            }
        }
        return { route, url, params, process };
    }
    /**
     * Get label for module action item
     *
     * @param {string} module name
     * @param {object} item action
     * @param {object} languages map
     * @param {string} labelKey to use
     * @returns {string} label
     */
    getActionLabel(module, item, languages, labelKey = '') {
        if (!languages || !languages.modStrings || !item || !module) {
            return '';
        }
        let key = labelKey;
        if (!key) {
            key = item.labelKey;
        }
        let label = languages.modStrings[module] && languages.modStrings[module][key];
        if (!label) {
            label = languages.appStrings && languages.appStrings[key];
        }
        if (!label && item.module) {
            label = languages.modStrings[item.module] && languages.modStrings[item.module][key];
        }
        if (!label) {
            label = languages.modStrings.administration && languages.modStrings.administration[key];
        }
        return label || '';
    }
    /**
     * Get record router link route info
     *
     * @param {string} module name
     * @param {string} id fo the record
     * @returns {string} router link
     */
    getRecordRouterLink(module, id, isEdit) {
        if (isEdit) {
            return `/${module}/edit/${id}`;
        }
        return `/${module}/record/${id}`;
    }
    /**
     * Navigate back using return params
     * @param record
     * @param moduleName
     * @param params
     */
    navigateBack(record, moduleName, params) {
        let returnModule = this.getReturnModule(params);
        let returnAction = this.getReturnAction(params);
        const returnId = this.getReturnId(params);
        let route = '';
        if (returnModule) {
            route += '/' + returnModule;
        }
        if (returnAction) {
            route += '/' + returnAction;
        }
        if (returnId) {
            route += '/' + returnId;
        }
        if (returnModule === moduleName && returnAction === 'record') {
            const rid = !returnId ? record.id : returnId;
            route = '/' + moduleName + '/record/' + rid;
        }
        if (!route && record && record.id) {
            route = '/' + moduleName + '/record/' + record.id;
        }
        if (!route && record && record.id) {
            route = '/' + moduleName;
        }
        this.router.navigate([route]).then();
    }
    /**
     * Extract return id
     * @param params
     */
    getReturnId(params) {
        return params.return_id || '';
    }
    /**
     * Extract and map return action
     * @param params
     */
    getReturnAction(params) {
        let returnAction = '';
        if (params.return_action) {
            returnAction = this.actionNameMapper.toFrontend(params.return_action);
        }
        return returnAction;
    }
    /**
     * Extract and map return action
     * @param params
     */
    getReturnModule(params) {
        let returnModule = '';
        if (params.return_module) {
            returnModule = this.moduleNameMapper.toFrontend(params.return_module);
        }
        return returnModule;
    }
    static { this.ɵfac = function ModuleNavigation_Factory(t) { return new (t || ModuleNavigation)(i0.ɵɵinject(i1$2.Router), i0.ɵɵinject(ModuleNameMapper), i0.ɵɵinject(ActionNameMapper)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ModuleNavigation, factory: ModuleNavigation.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ModuleNavigation, [{
        type: Injectable,
        args: [{ providedIn: 'root' }]
    }], function () { return [{ type: i1$2.Router }, { type: ModuleNameMapper }, { type: ActionNameMapper }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function EmailListFieldsComponent_a_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "a", 3);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵpropertyInterpolate1("href", "mailto:", ctx_r0.field.value, "", i0.ɵɵsanitizeUrl);
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate(ctx_r0.field.value);
} }
function EmailListFieldsComponent_a_2_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "a", 4);
    i0.ɵɵlistener("click", function EmailListFieldsComponent_a_2_Template_a_click_0_listener() { i0.ɵɵrestoreView(_r3); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.openEmail()); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate(ctx_r1.field.value);
} }
class EmailListFieldsComponent extends BaseFieldComponent {
    constructor(typeFormatter, logic, logicDisplay, preferences, navigation, moduleNameMapper, actionNameMapper, appState, modalService, router) {
        super(typeFormatter, logic, logicDisplay);
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
        this.preferences = preferences;
        this.navigation = navigation;
        this.moduleNameMapper = moduleNameMapper;
        this.actionNameMapper = actionNameMapper;
        this.appState = appState;
        this.modalService = modalService;
        this.router = router;
    }
    ngOnInit() {
        this.linkType = this.preferences.getUserPreference('email_link_type') || 'mailto';
    }
    openEmail() {
        const view = this.actionNameMapper.toLegacy(this.appState.getView());
        const module = this.moduleNameMapper.toLegacy(this.parent.module);
        const parent_id = this.parent.id;
        const parent_name = this.parent.attributes.name;
        const email = this.field.value;
        let return_id;
        if (view !== 'ListView' && view !== 'index') {
            return_id = parent_id;
        }
        this.router.navigate(['emails', 'compose'], {
            queryParams: {
                return_module: module,
                return_action: view,
                return_id,
                to_addrs_names: email,
                parent_type: module,
                parent_name,
                parent_id,
            }
        });
    }
    static { this.ɵfac = function EmailListFieldsComponent_Factory(t) { return new (t || EmailListFieldsComponent)(i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager), i0.ɵɵdirectiveInject(UserPreferenceStore), i0.ɵɵdirectiveInject(ModuleNavigation), i0.ɵɵdirectiveInject(ModuleNameMapper), i0.ɵɵdirectiveInject(ActionNameMapper), i0.ɵɵdirectiveInject(AppStateStore), i0.ɵɵdirectiveInject(i3$1.NgbModal), i0.ɵɵdirectiveInject(i1$2.Router)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: EmailListFieldsComponent, selectors: [["scrm-email-list"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 3, vars: 2, consts: [[1, "mailto-field"], [3, "href", 4, "ngIf"], ["class", "clickable field-link", 3, "click", 4, "ngIf"], [3, "href"], [1, "clickable", "field-link", 3, "click"]], template: function EmailListFieldsComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵtemplate(1, EmailListFieldsComponent_a_1_Template, 2, 2, "a", 1);
            i0.ɵɵtemplate(2, EmailListFieldsComponent_a_2_Template, 2, 1, "a", 2);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.linkType === "mailto");
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.linkType === "sugar");
        } }, dependencies: [i2.NgIf], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EmailListFieldsComponent, [{
        type: Component,
        args: [{ selector: 'scrm-email-list', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<div class=\"mailto-field\">\n    <a *ngIf=\"linkType === 'mailto'\" href=\"mailto:{{ this.field.value }}\">{{ this.field.value }}</a>\n\n    <a *ngIf=\"linkType === 'sugar'\" class=\"clickable field-link\" (click)=\"openEmail()\">{{ this.field.value }}</a>\n</div>\n" }]
    }], function () { return [{ type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }, { type: UserPreferenceStore }, { type: ModuleNavigation }, { type: ModuleNameMapper }, { type: ActionNameMapper }, { type: AppStateStore }, { type: i3$1.NgbModal }, { type: i1$2.Router }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class EmailListFieldsModule {
    static { this.ɵfac = function EmailListFieldsModule_Factory(t) { return new (t || EmailListFieldsModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: EmailListFieldsModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EmailListFieldsModule, [{
        type: NgModule,
        args: [{
                declarations: [EmailListFieldsComponent],
                exports: [EmailListFieldsComponent],
                imports: [
                    CommonModule,
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(EmailListFieldsModule, { declarations: [EmailListFieldsComponent], imports: [CommonModule], exports: [EmailListFieldsComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class VarcharFilterFieldComponent extends BaseFieldComponent {
    constructor(typeFormatter, logic, logicDisplay) {
        super(typeFormatter, logic, logicDisplay);
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    ngOnInit() {
        super.ngOnInit();
        let current = '';
        if (this.field.criteria && this.field.criteria.values && this.field.criteria.values.length > 0) {
            current = this.field.criteria.values[0];
        }
        if (!isVoid(current)) {
            current = current.trim();
        }
        else {
            current = '';
        }
        this.field.value = current;
        const formattedValue = this.typeFormatter.toUserFormat(this.field.type, current, { mode: 'edit' });
        this.field.formControl.setValue(formattedValue);
        this.field.formControl.markAsDirty();
        this.subscribeValueChanges();
    }
    ngOnDestroy() {
        this.unsubscribeAll();
    }
    setFieldValue(newValue) {
        this.field.value = newValue;
        this.field.criteria.operator = '=';
        this.field.criteria.values = [newValue];
    }
    static { this.ɵfac = function VarcharFilterFieldComponent_Factory(t) { return new (t || VarcharFilterFieldComponent)(i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: VarcharFilterFieldComponent, selectors: [["scrm-varchar-filter"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 5, consts: [["type", "text", 3, "formControl", "value", "ngClass"]], template: function VarcharFilterFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelement(0, "input", 0);
        } if (rf & 2) {
            i0.ɵɵclassProp("is-invalid", ctx.validateOnlyOnSubmit ? ctx.isInvalid() : ctx.field.formControl.invalid && ctx.field.formControl.touched);
            i0.ɵɵproperty("formControl", ctx.field.formControl)("value", ctx.field.value)("ngClass", ctx.klass);
        } }, dependencies: [i2.NgClass, i5$1.DefaultValueAccessor, i5$1.NgControlStatus, i5$1.FormControlDirective], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(VarcharFilterFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-varchar-filter', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<input [class.is-invalid]=\"validateOnlyOnSubmit ? isInvalid() : (field.formControl.invalid && field.formControl.touched)\"\n       [formControl]=\"field.formControl\"\n       [value]=\"field.value\"\n       [ngClass]=\"klass\"\n       type=\"text\">\n" }]
    }], function () { return [{ type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class EnumEditFieldModule {
    static { this.ɵfac = function EnumEditFieldModule_Factory(t) { return new (t || EnumEditFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: EnumEditFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            TagInputModule,
            FormsModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EnumEditFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [EnumEditFieldComponent],
                exports: [EnumEditFieldComponent],
                imports: [
                    CommonModule,
                    TagInputModule,
                    FormsModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(EnumEditFieldModule, { declarations: [EnumEditFieldComponent], imports: [CommonModule,
        TagInputModule,
        FormsModule], exports: [EnumEditFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class MultiEnumDetailFieldModule {
    static { this.ɵfac = function MultiEnumDetailFieldModule_Factory(t) { return new (t || MultiEnumDetailFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: MultiEnumDetailFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormsModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MultiEnumDetailFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [MultiEnumDetailFieldComponent],
                exports: [MultiEnumDetailFieldComponent],
                imports: [
                    CommonModule,
                    FormsModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(MultiEnumDetailFieldModule, { declarations: [MultiEnumDetailFieldComponent], imports: [CommonModule,
        FormsModule], exports: [MultiEnumDetailFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class LegacyEntrypointLinkBuilder {
    getDownloadEntrypointLink(id, type) {
        const queryParams = { entryPoint: 'download', id, type };
        return './index.php' + this.buildQueryString(queryParams);
    }
    buildQueryString(queryParams, exclude = []) {
        let params = new HttpParams();
        Object.keys(queryParams).forEach((param) => {
            if (exclude.includes(param)) {
                return;
            }
            const value = queryParams[param];
            params = params.set(param, value);
        });
        if (params.keys().length > 0) {
            return '?' + params.toString();
        }
        return '';
    }
    static { this.ɵfac = function LegacyEntrypointLinkBuilder_Factory(t) { return new (t || LegacyEntrypointLinkBuilder)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: LegacyEntrypointLinkBuilder, factory: LegacyEntrypointLinkBuilder.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LegacyEntrypointLinkBuilder, [{
        type: Injectable,
        args: [{ providedIn: 'root' }]
    }], null, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class FileDetailFieldComponent extends BaseFieldComponent {
    constructor(typeFormatter, logic, logicDisplay, legacyEntrypointLinkBuilder) {
        super(typeFormatter, logic, logicDisplay);
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
        this.legacyEntrypointLinkBuilder = legacyEntrypointLinkBuilder;
        this.filenameLink = '';
    }
    ngOnInit() {
        const id = this.record.id;
        const type = this.record.module;
        this.filenameLink = this.legacyEntrypointLinkBuilder.getDownloadEntrypointLink(id, type);
    }
    static { this.ɵfac = function FileDetailFieldComponent_Factory(t) { return new (t || FileDetailFieldComponent)(i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager), i0.ɵɵdirectiveInject(LegacyEntrypointLinkBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FileDetailFieldComponent, selectors: [["scrm-file-detail"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 3, vars: 2, consts: [[1, "clickable", "field-link", 3, "href"]], template: function FileDetailFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementContainerStart(0);
            i0.ɵɵelementStart(1, "a", 0);
            i0.ɵɵtext(2);
            i0.ɵɵelementEnd();
            i0.ɵɵelementContainerEnd();
        } if (rf & 2) {
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("href", ctx.filenameLink, i0.ɵɵsanitizeUrl);
            i0.ɵɵadvance(1);
            i0.ɵɵtextInterpolate1(" ", ctx.field.value, " ");
        } }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FileDetailFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-file-detail', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<ng-container>\n    <a [href]=\"filenameLink\" class=\"clickable field-link\">\n        {{field.value}}\n    </a>\n</ng-container>\n" }]
    }], function () { return [{ type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }, { type: LegacyEntrypointLinkBuilder }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class FileDetailFieldModule {
    static { this.ɵfac = function FileDetailFieldModule_Factory(t) { return new (t || FileDetailFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: FileDetailFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            RouterModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FileDetailFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [FileDetailFieldComponent],
                exports: [FileDetailFieldComponent],
                imports: [
                    CommonModule,
                    RouterModule,
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(FileDetailFieldModule, { declarations: [FileDetailFieldComponent], imports: [CommonModule,
        RouterModule], exports: [FileDetailFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class FormatNumberPipe extends DecimalPipe {
    constructor(formatter, locale) {
        super(locale);
        this.formatter = formatter;
        this.locale = locale;
    }
    // eslint-disable-next-line no-dupe-class-members,@typescript-eslint/no-unused-vars
    transform(value, digitsInfo, locale) {
        if (!value) {
            return null;
        }
        return this.formatter.toUserFormat('' + value);
    }
    static { this.ɵfac = function FormatNumberPipe_Factory(t) { return new (t || FormatNumberPipe)(i0.ɵɵdirectiveInject(NumberFormatter, 16), i0.ɵɵdirectiveInject(LOCALE_ID, 16)); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "formatNumber", type: FormatNumberPipe, pure: true }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FormatNumberPipe, [{
        type: Pipe,
        args: [{
                name: 'formatNumber'
            }]
    }], function () { return [{ type: NumberFormatter }, { type: undefined, decorators: [{
                type: Inject,
                args: [LOCALE_ID]
            }] }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function FloatDetailFieldComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtext(1);
    i0.ɵɵpipe(2, "formatNumber");
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", i0.ɵɵpipeBind1(2, 1, ctx_r0.field.value), "\n");
} }
class FloatDetailFieldComponent extends BaseNumberComponent {
    constructor(userPreferences, systemConfig, typeFormatter, logic, logicDisplay) {
        super(userPreferences, systemConfig, typeFormatter, logic, logicDisplay);
        this.userPreferences = userPreferences;
        this.systemConfig = systemConfig;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    static { this.ɵfac = function FloatDetailFieldComponent_Factory(t) { return new (t || FloatDetailFieldComponent)(i0.ɵɵdirectiveInject(UserPreferenceStore), i0.ɵɵdirectiveInject(SystemConfigStore), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FloatDetailFieldComponent, selectors: [["scrm-float-detail"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 3, consts: [[4, "ngIf"]], template: function FloatDetailFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, FloatDetailFieldComponent_ng_container_0_Template, 3, 3, "ng-container", 0);
            i0.ɵɵpipe(1, "async");
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", i0.ɵɵpipeBind1(1, 1, ctx.vm$));
        } }, dependencies: [i2.NgIf, i2.AsyncPipe, FormatNumberPipe], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FloatDetailFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-float-detail', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<ng-container *ngIf=\"(vm$ | async) as vm\">\n    {{field.value | formatNumber}}\n</ng-container>\n" }]
    }], function () { return [{ type: UserPreferenceStore }, { type: SystemConfigStore }, { type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class FormatNumberModule {
    static { this.ɵfac = function FormatNumberModule_Factory(t) { return new (t || FormatNumberModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: FormatNumberModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FormatNumberModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    FormatNumberPipe
                ],
                exports: [
                    FormatNumberPipe
                ],
                imports: [
                    CommonModule,
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(FormatNumberModule, { declarations: [FormatNumberPipe], imports: [CommonModule], exports: [FormatNumberPipe] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class FloatDetailFieldModule {
    static { this.ɵfac = function FloatDetailFieldModule_Factory(t) { return new (t || FloatDetailFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: FloatDetailFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormatNumberModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FloatDetailFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [FloatDetailFieldComponent],
                exports: [FloatDetailFieldComponent],
                imports: [
                    CommonModule,
                    FormatNumberModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(FloatDetailFieldModule, { declarations: [FloatDetailFieldComponent], imports: [CommonModule,
        FormatNumberModule], exports: [FloatDetailFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class VarcharFilterFieldModule {
    static { this.ɵfac = function VarcharFilterFieldModule_Factory(t) { return new (t || VarcharFilterFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: VarcharFilterFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormsModule,
            ReactiveFormsModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(VarcharFilterFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [VarcharFilterFieldComponent],
                exports: [VarcharFilterFieldComponent],
                imports: [
                    CommonModule,
                    FormsModule,
                    ReactiveFormsModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(VarcharFilterFieldModule, { declarations: [VarcharFilterFieldComponent], imports: [CommonModule,
        FormsModule,
        ReactiveFormsModule], exports: [VarcharFilterFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class RelateDetailFieldComponent extends BaseFieldComponent {
    constructor(typeFormatter, logic, logicDisplay) {
        super(typeFormatter, logic, logicDisplay);
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    static { this.ɵfac = function RelateDetailFieldComponent_Factory(t) { return new (t || RelateDetailFieldComponent)(i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: RelateDetailFieldComponent, selectors: [["scrm-relate-detail"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, template: function RelateDetailFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtext(0);
        } if (rf & 2) {
            i0.ɵɵtextInterpolate1("\n", ctx.field.value, "\n");
        } }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RelateDetailFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-relate-detail', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n{{field.value}}\n" }]
    }], function () { return [{ type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class ModalRecordFilterAdapter {
    getConfig(store) {
        return {
            klass: 'light-filter',
            panelMode: 'collapsible',
            isCollapsed: true,
            collapseOnSearch: true,
            savedFilterEdit: false,
            displayHeader: true,
            module: store.recordList.getModule(),
            filter$: store.recordList.criteria$.pipe(map(criteria => {
                return {
                    key: 'default',
                    criteria
                };
            })),
            savedFilters$: of([]),
            searchFields$: store.searchMetadata$.pipe(map((searchMeta) => {
                if (!searchMeta) {
                    return {};
                }
                let type = 'advanced';
                if (!searchMeta.layout.advanced) {
                    type = 'basic';
                }
                return searchMeta.layout[type];
            })),
            listFields: [],
            onClose: () => {
            },
            onSearch: () => {
            },
            updateFilter: (filter, reload = true) => {
                store.recordList.updateSearchCriteria(filter.criteria, reload);
            },
            resetFilter: (reload) => {
                store.recordList.resetSearchCriteria(reload);
            },
            addSavedFilter: (filter) => {
            },
            removeSavedFilter: (filter) => {
            },
            setOpenFilter: (filter) => {
            },
        };
    }
    static { this.ɵfac = function ModalRecordFilterAdapter_Factory(t) { return new (t || ModalRecordFilterAdapter)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ModalRecordFilterAdapter, factory: ModalRecordFilterAdapter.ɵfac }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ModalRecordFilterAdapter, [{
        type: Injectable
    }], null, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class ModalRecordListTableAdapter {
    constructor(systemConfigs, preferences) {
        this.systemConfigs = systemConfigs;
        this.preferences = preferences;
    }
    /**
     * Get table config
     *
     * @param {object} store to use
     * @param {boolean} multiSelect
     * @returns {object} TableConfig
     */
    getTable(store, multiSelect = false) {
        const config = {
            showHeader: true,
            showFooter: true,
            klass: 'light-table',
            module: store.recordList.getModule(),
            columns: store.columns$.pipe(map(columns => this.mapColumns(store, columns))),
            sort$: store.recordList.sort$,
            maxColumns$: of(5),
            loading$: store.recordList.loading$,
            dataSource: store.recordList,
            pagination: store.recordList,
            toggleRecordSelection: (id) => {
                store.recordList.toggleSelection(id);
            },
            updateSorting: (orderBy, sortOrder) => {
                store.recordList.updateSorting(orderBy, sortOrder);
                store.saveCurrentSort();
            },
            maxListHeight: this.preferences.getUserPreference('record_modal_max_height') ?? this.systemConfigs.getConfigValue('record_modal_max_height'),
            paginationType: this.preferences.getUserPreference('record_modal_pagination_type') ?? this.systemConfigs.getConfigValue('record_modal_pagination_type'),
            loadMore: () => {
                const jump = this.preferences.getUserPreference('list_max_entries_per_modal') ?? this.systemConfigs.getConfigValue('list_max_entries_per_modal');
                const pagination = store.recordList.getPagination();
                const currentPageSize = pagination.pageSize || 0;
                const newPageSize = Number(currentPageSize) + Number(jump);
                store.recordList.setPageSize(newPageSize);
                store.recordList.updatePagination(pagination.current);
            },
            allLoaded: () => {
                const pagination = store.recordList.getPagination();
                if (!pagination) {
                    return false;
                }
                if (Number(pagination.pageLast) >= Number(pagination.total)) {
                    return true;
                }
                return Number(pagination.pageSize) >= Number(pagination.total);
            }
        };
        if (multiSelect) {
            config.selection$ = store.recordList.selection$;
            config.selectedCount$ = store.recordList.selectedCount$;
            config.selectedStatus$ = store.recordList.selectedStatus$;
        }
        return config;
    }
    /**
     * Parse and override column definitions
     *
     * @param {object} store to use
     * @param {[]} columns to map
     * @returns {[]} ColumnDefinition[]
     */
    mapColumns(store, columns) {
        const mappedColumns = [];
        columns.forEach(column => {
            const mapped = { ...column };
            const metadata = column.metadata || {};
            mapped.metadata = { ...metadata };
            this.disableRelateFieldsLink(mapped);
            this.addLinkSelectHandler(store, mapped);
            mappedColumns.push(mapped);
        });
        return mappedColumns;
    }
    /**
     * Disable link for relate fields
     *
     * @param {object} definition to update
     */
    disableRelateFieldsLink(definition) {
        if (definition.type !== 'relate') {
            return;
        }
        definition.link = false;
        definition.metadata.link = false;
    }
    /**
     * Add onClick handler for link fields
     *
     * @param {object} store to use
     * @param {object} definition to update
     */
    addLinkSelectHandler(store, definition) {
        if (!definition.link) {
            return;
        }
        definition.metadata.onClick = (field, record) => {
            store.recordList.clearSelection();
            store.recordList.toggleSelection(record.id);
            store.emitLinkClicked();
        };
    }
}

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class ListGQL {
    constructor(apollo) {
        this.apollo = apollo;
        this.fieldsMetadata = {
            fields: [
                'id',
                '_id',
                'meta',
                'records'
            ]
        };
    }
    /**
     * Fetch data either from backend
     *
     * @param {string} module to get from
     * @param {number} limit  page limit
     * @param {number} offset  current offset
     * @param {object} criteria filter criteria
     * @param {object} sort selection
     * @param {object} metadata with the fields to ask for
     * @returns {object} Observable<ApolloQueryResult<any>>
     */
    fetch(module, limit, offset, criteria, sort, metadata) {
        const fields = metadata.fields;
        const queryOptions = {
            query: gql `
              query recordList($module: String!, $limit: Int, $offset: Int, $criteria: Iterable, $sort: Iterable) {
                recordList(module: $module, limit: $limit, offset: $offset, criteria: $criteria, sort: $sort) {
                  ${fields.join('\n')}
                }
              }
            `,
            variables: {
                module,
                limit,
                offset,
                criteria,
                sort
            },
        };
        return this.apollo.query(queryOptions);
    }
    /**
     * Fetch the List records from the backend
     *
     * @param {string} module to use
     * @param {object} criteria to use
     * @param {object} sort to use
     * @param {object} pagination to use
     * @returns {object} Observable<any>
     */
    get(module, criteria, sort, pagination) {
        const mappedSort = this.mapSort(sort);
        return this.fetch(module, toInteger(pagination.pageSize), toInteger(pagination.current), criteria, mappedSort, this.fieldsMetadata)
            .pipe(map(({ data }) => {
            const recordsList = {
                records: [],
                pagination: { ...pagination }
            };
            if (!data || !data.recordList) {
                return recordsList;
            }
            const listData = data.recordList;
            if (listData.records) {
                listData.records.forEach((record) => {
                    recordsList.records.push(this.mapRecord(record));
                });
            }
            if (!listData.meta) {
                return recordsList;
            }
            if (listData.meta.offsets) {
                const paginationFieldMap = {
                    current: 'current',
                    next: 'next',
                    prev: 'previous',
                    total: 'total',
                    end: 'last',
                };
                Object.keys(paginationFieldMap).forEach((key) => {
                    if (key in listData.meta.offsets) {
                        const paginationField = paginationFieldMap[key];
                        recordsList.pagination[paginationField] = listData.meta.offsets[key];
                    }
                });
            }
            recordsList.meta = listData.meta;
            return recordsList;
        }));
    }
    /**
     * Map sort.
     * @param {object} sort to map
     */
    mapSort(sort) {
        const sortOrderMap = {
            NONE: '',
            ASC: 'ASC',
            DESC: 'DESC'
        };
        return {
            sortOrder: sortOrderMap[sort.sortOrder],
            orderBy: sort.orderBy
        };
    }
    /**
     * Map record. Allow for extensions
     * @param record
     */
    mapRecord(record) {
        return record;
    }
    static { this.ɵfac = function ListGQL_Factory(t) { return new (t || ListGQL)(i0.ɵɵinject(i1.Apollo)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ListGQL, factory: ListGQL.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ListGQL, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i1.Apollo }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
const initialFilter$1 = {
    key: 'default',
    module: 'saved-search',
    attributes: {
        contents: ''
    },
    criteria: {
        name: 'default',
        filters: {}
    }
};
const initialFilters$1 = {
    'default': deepClone(initialFilter$1)
};
const initialSearchCriteria = {
    filters: {}
};
const initialListSort = {
    orderBy: '',
    sortOrder: SortDirection.DESC
};
const initialListPagination = {
    pageSize: 5,
    current: 0,
    previous: 0,
    next: 5,
    last: 0,
    total: 0,
    pageFirst: 0,
    pageLast: 0
};
const initialSelection = {
    all: false,
    status: SelectionStatus.NONE,
    selected: {},
    count: 0
};
const initialState$i = {
    module: '',
    records: [],
    criteria: deepClone(initialSearchCriteria),
    activeFilters: deepClone(initialFilters$1),
    sort: deepClone(initialListSort),
    pagination: deepClone(initialListPagination),
    selection: deepClone(initialSelection),
    openFilter: deepClone(initialFilter$1),
    loading: false,
    meta: {}
};
class RecordListStore {
    constructor(listGQL, configStore, preferencesStore, languageStore, message, localStorageService) {
        this.listGQL = listGQL;
        this.configStore = configStore;
        this.preferencesStore = preferencesStore;
        this.languageStore = languageStore;
        this.message = message;
        this.localStorageService = localStorageService;
        /** Internal Properties */
        this.cache$ = null;
        this.internalState = deepClone(initialState$i);
        this.store = new BehaviorSubject(this.internalState);
        this.state$ = this.store.asObservable();
        this.subs = [];
        this.pageKey = null;
        this.records$ = this.state$.pipe(map(state => state.records), distinctUntilChanged());
        this.criteria$ = this.state$.pipe(map(state => state.criteria), distinctUntilChanged());
        this.sort$ = this.state$.pipe(map(state => state.sort), distinctUntilChanged());
        this.pagination$ = this.state$.pipe(map(state => state.pagination), distinctUntilChanged());
        this.selection$ = this.state$.pipe(map(state => state.selection), distinctUntilChanged());
        this.selectedCount$ = this.state$.pipe(map(state => state.selection.count), distinctUntilChanged());
        this.selectedStatus$ = this.state$.pipe(map(state => state.selection.status), distinctUntilChanged());
        this.activeFilters$ = this.state$.pipe(map(state => state.activeFilters), distinctUntilChanged());
        this.openFilter$ = this.state$.pipe(map(state => state.openFilter), distinctUntilChanged());
        this.loading$ = this.state$.pipe(map(state => state.loading));
    }
    connect() {
        return this.records$;
    }
    disconnect() {
    }
    get criteria() {
        if (!this.internalState.criteria) {
            return deepClone(initialSearchCriteria);
        }
        return deepClone(this.internalState.criteria);
    }
    set criteria(criteria) {
        this.updateState({
            ...this.internalState,
            criteria
        });
    }
    get activeFilters() {
        return deepClone(this.internalState.activeFilters);
    }
    get sort() {
        if (!this.internalState.sort) {
            return deepClone(initialListSort);
        }
        return deepClone(this.internalState.sort);
    }
    set sort(sort) {
        this.updateState({
            ...this.internalState,
            sort
        });
    }
    get pagination() {
        if (!this.internalState.pagination) {
            return deepClone(initialListPagination);
        }
        return deepClone(this.internalState.pagination);
    }
    set pagination(pagination) {
        this.updateState({
            ...this.internalState,
            pagination
        });
    }
    get selection() {
        if (!this.internalState.selection) {
            return deepClone(initialSelection);
        }
        return deepClone(this.internalState.selection);
    }
    get records() {
        if (!this.internalState.records) {
            return [];
        }
        return this.internalState.records;
    }
    getModule() {
        return this.internalState.module;
    }
    getRecord(id) {
        let record = null;
        this.records.some(item => {
            if (item.id === id) {
                record = item;
                return true;
            }
        });
        return record;
    }
    /**
     * Clean destroy
     */
    destroy() {
        this.clear();
    }
    /**
     * Initial list records load if not cached and update state.
     * Returns observable to be used in resolver if needed
     *
     * @param {string} module to use
     * @param {boolean} load if to load
     * @param {string} pageSizeConfigKey string
     * @param filter
     * @param preferenceKey
     * @returns {object} Observable<any>
     */
    init(module, load = true, pageSizeConfigKey = 'list_max_entries_per_page', filter = deepClone(initialFilter$1), preferenceKey = '') {
        this.internalState.module = module;
        this.preferenceKey = preferenceKey;
        if (pageSizeConfigKey) {
            this.watchPageSize(pageSizeConfigKey);
        }
        this.setBaseFilter(filter);
        this.loadCurrentFilter(module);
        if (load === false) {
            return null;
        }
        return this.load();
    }
    setBaseFilter(filter) {
        this.baseFilterMap = { 'default': deepClone(filter) };
        this.baseFilter = deepClone(filter);
        this.updateState({ ...this.internalState, activeFilters: deepClone(this.baseFilterMap), openFilter: deepClone(this.baseFilter) });
    }
    /**
     * Load current filter
     * @param module
     * @protected
     */
    loadCurrentFilter(module) {
        const activeFiltersPref = this.loadPreference(module, 'current-filters') ?? this.baseFilterMap;
        if (!activeFiltersPref || emptyObject(activeFiltersPref)) {
            return;
        }
        let currentSort = this.loadPreference(module, 'current-sort');
        if (!currentSort && emptyObject(currentSort)) {
            currentSort = null;
        }
        this.setFilters(activeFiltersPref, false, currentSort);
    }
    /**
     * Set active filters
     *
     * @param {object} filters to set
     * @param {boolean} reload flag
     * @param sort
     */
    setFilters(filters, reload = true, sort = null) {
        const filterKey = Object.keys(filters).shift();
        const filter = filters[filterKey];
        this.updateState({ ...this.internalState, activeFilters: deepClone(filters), openFilter: deepClone(filter) });
        if (filter.criteria) {
            let orderBy = filter.criteria.orderBy ?? '';
            const sortOrder = filter.criteria.sortOrder ?? 'desc';
            let direction = this.mapSortOrder(sortOrder);
            if (sort !== null) {
                orderBy = sort.orderBy;
                direction = sort.sortOrder;
            }
            this.updateSorting(orderBy, direction, false);
            this.updateSortLocalStorage();
            this.updateSearchCriteria(filter.criteria, reload);
        }
        this.updateFilterLocalStorage();
    }
    updateFilterLocalStorage() {
        const module = this.internalState.module;
        this.savePreference(module, 'current-filters', this.internalState.activeFilters);
    }
    updateSortLocalStorage() {
        const module = this.internalState.module;
        this.savePreference(module, 'current-sort', this.sort);
    }
    updatePaginationLocalStorage() {
        if (this.pageKey === null) {
            return;
        }
        const module = this.internalState.module;
        const key = module + '-' + this.pageKey + '-' + 'current-pagination';
        this.localStorageService.set(key, this.pagination);
    }
    /**
     * Load / reload records using current pagination and criteria
     *
     * @param {boolean} useCache if to use cache
     * @returns {object} Observable<ListViewState>
     */
    load(useCache = true) {
        this.updateState({
            ...this.internalState,
            loading: true
        });
        return this.getRecords(this.internalState.module, this.internalState.criteria, this.internalState.sort, this.internalState.pagination, useCache).pipe(catchError(() => {
            this.message.addDangerMessageByKey('LBL_GET_RECORD_LIST_ERROR');
            return of({
                records: [],
                criteria: deepClone(initialSearchCriteria),
                sort: deepClone(initialListSort),
                pagination: deepClone(initialListPagination),
                openFilter: deepClone(this.baseFilter),
                activeFilters: deepClone(this.baseFilterMap),
                selection: deepClone(initialSelection),
                meta: {}
            });
        }), tap((data) => {
            this.calculatePageCount(data.records, data.pagination);
            this.updateState({
                ...this.internalState,
                records: data.records,
                pagination: data.pagination,
                loading: false,
                meta: data.meta ?? {}
            });
        }));
    }
    /**
     * Update the search criteria
     *
     * @param {object} criteria to set
     * @param {boolean} reload flag
     */
    updateSearchCriteria(criteria, reload = true) {
        this.updateState({ ...this.internalState, criteria });
        if (reload) {
            this.updateSelection(SelectionStatus.NONE);
            // Reset pagination to default first page
            this.resetPagination();
        }
    }
    /**
     * Reset search criteria
     * @param {boolean} reload flag
     */
    resetSearchCriteria(reload = true) {
        this.updateSearchCriteria(deepClone(initialSearchCriteria), reload);
    }
    /**
     * Update current list view sorting
     *
     * @param {string} orderBy to set
     * @param {string} sortOrder to set
     * @param {boolean} reload flag
     */
    updateSorting(orderBy, sortOrder, reload = true) {
        if (sortOrder === SortDirection.NONE) {
            orderBy = '';
            sortOrder = SortDirection.DESC;
        }
        const sort = { orderBy, sortOrder };
        this.updateState({ ...this.internalState, sort });
        if (reload) {
            this.load(false).pipe(take(1)).subscribe();
        }
    }
    /**
     * Map sort order to SortDirection enum
     * @param {string} sortOrder to map
     * @returns {string} SortDirection
     */
    mapSortOrder(sortOrder) {
        let direction = SortDirection.NONE;
        const sort = sortOrder.toLowerCase();
        if (sort === 'asc') {
            direction = SortDirection.ASC;
        }
        else if (sort === 'desc') {
            direction = SortDirection.DESC;
        }
        return direction;
    }
    /**
     * Update the pagination
     *
     * @param {number} current to set
     */
    updatePagination(current) {
        const pagination = { ...this.internalState.pagination, current };
        this.updateState({ ...this.internalState, pagination });
        this.load(false).pipe(take(1), tap(() => this.updatePaginationLocalStorage())).subscribe();
    }
    setPagination(current) {
        const pagination = { ...this.internalState.pagination, current };
        this.updateState({ ...this.internalState, pagination });
        return this.load(false).pipe(take(1), tap(() => this.updatePaginationLocalStorage()));
    }
    /**
     * Set open filters
     *
     * @param {object} filter to set
     */
    setOpenFilter(filter) {
        this.updateState({ ...this.internalState, openFilter: deepClone(filter) });
    }
    /**
     * Reset active filters
     *
     * @param {boolean} reload flag
     */
    resetFilters(reload = true) {
        this.updateState({
            ...this.internalState,
            activeFilters: deepClone(this.baseFilterMap),
            openFilter: deepClone(this.baseFilter),
        });
        this.clearSort();
        this.updateSortLocalStorage();
        this.updateFilterLocalStorage();
        this.updateSearchCriteria(this.baseFilter.criteria, reload);
    }
    /**
     * Save ui user preference
     * @param module
     * @param storageKey
     * @param value
     * @protected
     */
    savePreference(module, storageKey, value) {
        const preferenceKey = this.preferenceKey ?? null;
        if (!preferenceKey) {
            return null;
        }
        const key = `${preferenceKey}${storageKey}`;
        this.preferencesStore.setUi(module, key, value);
    }
    /**
     * Load ui user preference
     * @param module
     * @param storageKey
     * @protected
     */
    loadPreference(module, storageKey) {
        const preferenceKey = this.preferenceKey ?? null;
        if (!preferenceKey) {
            return null;
        }
        const key = `${preferenceKey}${storageKey}`;
        return this.preferencesStore.getUi(module, key);
    }
    /**
     * Reset/Clear the pagination
     */
    resetPagination() {
        this.updatePagination(0);
    }
    /**
     * Clear observable cache
     */
    clear() {
        this.cache$ = null;
        this.store.unsubscribe();
        this.preferencesSub.unsubscribe();
    }
    clearAuthBased() {
        this.clear();
    }
    /**
     * Selection public api
     */
    getSelectionStatus() {
        return this.selectedStatus$;
    }
    getSelectedCount() {
        return this.selectedCount$;
    }
    updateSelection(state) {
        if (state === SelectionStatus.NONE) {
            this.clearSelection();
            return;
        }
        if (state === SelectionStatus.ALL) {
            this.selectAll();
            return;
        }
        if (state === SelectionStatus.PAGE) {
            this.selectPage();
            return;
        }
    }
    clearSelection() {
        this.updateState({
            ...this.internalState,
            selection: deepClone(initialSelection)
        });
    }
    clearSort() {
        this.updateState({
            ...this.internalState,
            sort: deepClone(initialListSort)
        });
    }
    selectAll() {
        const total = this.internalState.pagination.total;
        this.updateState({
            ...this.internalState,
            selection: {
                all: true,
                status: SelectionStatus.ALL,
                selected: {},
                count: total
            }
        });
    }
    selectPage() {
        const selected = { ...this.internalState.selection.selected };
        if (this.internalState.records && this.internalState.records.length) {
            this.internalState.records.forEach(value => {
                if (value && value.id) {
                    selected[value.id] = value.id;
                }
            });
        }
        this.updateState({
            ...this.internalState,
            selection: {
                all: false,
                status: SelectionStatus.SOME,
                selected,
                count: Object.keys(selected).length
            }
        });
    }
    toggleSelection(id) {
        const selection = deepClone(this.internalState.selection);
        if (selection.selected[id]) {
            delete selection.selected[id];
        }
        else {
            selection.selected[id] = id;
        }
        selection.count = Object.keys(selection.selected).length;
        if (selection.count === 0) {
            selection.status = SelectionStatus.NONE;
        }
        else {
            selection.status = SelectionStatus.SOME;
        }
        this.updateState({
            ...this.internalState,
            selection
        });
    }
    /**
     * Pagination Public API
     */
    getPaginationCount() {
        return this.pagination$.pipe(map(pagination => ({
            pageFirst: pagination.pageFirst,
            pageLast: pagination.pageLast,
            total: pagination.total
        })), distinctUntilChanged());
    }
    getPagination() {
        return this.store.value.pagination;
    }
    getMeta() {
        return this.store.value.meta;
    }
    changePage(page) {
        let pageToLoad = 0;
        const pageMap = {};
        pageMap[PageSelection.FIRST] = 0;
        pageMap[PageSelection.PREVIOUS] = this.internalState.pagination.previous;
        pageMap[PageSelection.NEXT] = this.internalState.pagination.next;
        pageMap[PageSelection.LAST] = this.internalState.pagination.last;
        if (page in pageMap && pageMap[page] >= 0) {
            pageToLoad = pageMap[page];
            if (Number(pageToLoad) > this.internalState.pagination.last) {
                return;
            }
            if (pageToLoad < 0) {
                return;
            }
            this.updatePagination(pageToLoad);
        }
    }
    setPage(page, isPaginationLoadMore) {
        let pageToLoad = 0;
        const pageMap = {};
        pageMap[PageSelection.FIRST] = 0;
        pageMap[PageSelection.PREVIOUS] = this.internalState.pagination.previous;
        pageMap[PageSelection.NEXT] = this.internalState.pagination.next;
        pageMap[PageSelection.LAST] = this.internalState.pagination.last;
        if (page in pageMap && pageMap[page] >= 0) {
            pageToLoad = pageMap[page];
            if (Number(pageToLoad) > this.internalState.pagination.last) {
                return of({});
            }
            if (pageToLoad < 0) {
                return of({});
            }
            if (isPaginationLoadMore) {
                pageToLoad = 0;
            }
            return this.setPagination(pageToLoad);
        }
        return of({});
    }
    /**
     * Set Pagination page size
     *
     * @param {number} pageSize to set
     */
    setPageSize(pageSize) {
        const pagination = { ...this.internalState.pagination, pageSize };
        this.updateState({ ...this.internalState, pagination });
    }
    /**
     * Get Pagination page size
     */
    getPageSize() {
        return this?.internalState?.pagination?.pageSize ?? 10;
    }
    /**
     * Internal API
     */
    /**
     * Subscribe to page size changes
     *
     * @param {string} pageSizeConfigKey key
     */
    watchPageSize(pageSizeConfigKey) {
        const pageSizePreference = this.preferencesStore.getUserPreference(pageSizeConfigKey);
        const pageSizeConfig = this.configStore.getConfigValue(pageSizeConfigKey);
        this.determinePageSize(pageSizePreference, pageSizeConfig);
        this.preferencesSub = this.configStore.configs$.pipe(combineLatestWith(this.preferencesStore.userPreferences$), tap(([configs, preferences]) => {
            const key = pageSizeConfigKey;
            const sizePreference = (preferences && preferences[key]) || null;
            const sizeConfig = (configs && configs[key] && configs[key].value) || null;
            this.determinePageSize(sizePreference, sizeConfig);
        })).subscribe();
    }
    /**
     * Determine page size to use
     *
     * @param {} pageSizePreference to use
     * @param {string} pageSizeConfig to use
     */
    determinePageSize(pageSizePreference, pageSizeConfig) {
        let size = 20;
        if (pageSizePreference) {
            size = pageSizePreference;
        }
        else if (pageSizeConfig) {
            size = parseInt(pageSizeConfig, 10);
        }
        this.setPageSize(size);
    }
    /**
     * Update the state
     *
     * @param {object} state to set
     */
    updateState(state) {
        this.store.next(this.internalState = state);
    }
    /**
     * Calculate page count
     *
     * @param {object} records list
     * @param {object} pagination info
     */
    calculatePageCount(records, pagination) {
        const recordCount = (records && records.length) || 0;
        let pageFirst = 0;
        let pageLast = 0;
        if (recordCount > 0) {
            pageFirst = pagination.current + 1;
            pageLast = pagination.current + recordCount;
        }
        pagination.pageFirst = pageFirst;
        pagination.pageLast = pageLast;
    }
    /**
     * Get records cached Observable or call the backend
     *
     * @param {string} module to use
     * @param {object} criteria to use
     * @param {object} sort to use
     * @param {object} pagination to use
     * @param {boolean} useCache if to use cache
     * @returns {object} Observable<any>
     */
    getRecords(module, criteria, sort, pagination, useCache = true) {
        if (this.cache$ == null || useCache === false) {
            this.cache$ = this.listGQL.get(module, criteria, sort, pagination).pipe(shareReplay(1));
        }
        return this.cache$;
    }
    static { this.ɵfac = function RecordListStore_Factory(t) { return new (t || RecordListStore)(i0.ɵɵinject(ListGQL), i0.ɵɵinject(SystemConfigStore), i0.ɵɵinject(UserPreferenceStore), i0.ɵɵinject(LanguageStore), i0.ɵɵinject(MessageService), i0.ɵɵinject(LocalStorageService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: RecordListStore, factory: RecordListStore.ɵfac }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RecordListStore, [{
        type: Injectable
    }], function () { return [{ type: ListGQL }, { type: SystemConfigStore }, { type: UserPreferenceStore }, { type: LanguageStore }, { type: MessageService }, { type: LocalStorageService }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class RecordListStoreFactory {
    constructor(listGQL, configStore, preferencesStore, languageStore, message, localStorageService) {
        this.listGQL = listGQL;
        this.configStore = configStore;
        this.preferencesStore = preferencesStore;
        this.languageStore = languageStore;
        this.message = message;
        this.localStorageService = localStorageService;
    }
    create() {
        return new RecordListStore(this.listGQL, this.configStore, this.preferencesStore, this.languageStore, this.message, this.localStorageService);
    }
    static { this.ɵfac = function RecordListStoreFactory_Factory(t) { return new (t || RecordListStoreFactory)(i0.ɵɵinject(ListGQL), i0.ɵɵinject(SystemConfigStore), i0.ɵɵinject(UserPreferenceStore), i0.ɵɵinject(LanguageStore), i0.ɵɵinject(MessageService), i0.ɵɵinject(LocalStorageService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: RecordListStoreFactory, factory: RecordListStoreFactory.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RecordListStoreFactory, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], function () { return [{ type: ListGQL }, { type: SystemConfigStore }, { type: UserPreferenceStore }, { type: LanguageStore }, { type: MessageService }, { type: LocalStorageService }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
const initialState$h = {
    module: '',
    detailView: {},
    editView: {},
    listView: {},
    search: {},
    recordView: {},
    subPanel: {},
    massUpdate: {},
    recentlyViewed: [],
    favorites: [],
    fieldActions: {}
};
const initialModuleMetadataState = {};
let internalState$5 = deepClone(initialState$h);
let allModulesState = deepClone(initialModuleMetadataState);
const initialCache = {};
let cache = deepClone(initialCache);
class MetadataStore {
    constructor(recordGQL, appState) {
        this.recordGQL = recordGQL;
        this.appState = appState;
        this.typeKeys = {
            listView: 'listView',
            search: 'search',
            recordView: 'recordView',
            subPanel: 'subPanel',
            massUpdate: 'massUpdate',
            recentlyViewed: 'recentlyViewed',
            favorites: 'favorites'
        };
        this.store = new BehaviorSubject(internalState$5);
        this.state$ = this.store.asObservable();
        this.allModuleStore = new BehaviorSubject(allModulesState);
        this.allModulesState$ = this.allModuleStore.asObservable();
        this.resourceName = 'moduleMetadata';
        this.fieldsMetadata = {
            fields: [
                'id',
                '_id',
            ]
        };
        this.types = [
            'listView',
            'search',
            'recordView',
            'subPanel',
            'massUpdate',
            'recentlyViewed',
            'favorites'
        ];
        this.baseTypes = [
            'listView',
            'search',
            'recordView',
            'favorites'
        ];
        this.listViewColumns$ = this.state$.pipe(map(state => state.listView.fields), distinctUntilChanged());
        this.listViewLineActions$ = this.state$.pipe(map(state => state.listView.lineActions), distinctUntilChanged());
        this.listViewTableActions$ = this.state$.pipe(map(state => state.listView.tableActions), distinctUntilChanged());
        this.listMetadata$ = this.state$.pipe(map(state => state.listView), distinctUntilChanged());
        this.searchMetadata$ = this.state$.pipe(map(state => state.search), distinctUntilChanged());
        this.recordViewMetadata$ = this.state$.pipe(map(state => state.recordView), distinctUntilChanged());
        this.fieldActions$ = this.state$.pipe(map(state => state.fieldActions), distinctUntilChanged());
        this.subPanelMetadata$ = this.state$.pipe(map(state => state.subPanel), distinctUntilChanged());
        this.metadata$ = this.state$;
        this.allModuleMetadata$ = this.allModulesState$;
    }
    /**
     * Clear state
     */
    clear() {
        cache = deepClone(initialCache);
        allModulesState = deepClone(initialModuleMetadataState);
        this.updateState('', deepClone(initialState$h));
    }
    clearAuthBased() {
        this.clear();
    }
    /**
     * Get all metadata types
     *
     * @returns {string[]} metadata types
     */
    getMetadataTypes() {
        return this.types;
    }
    getModule() {
        return internalState$5.module;
    }
    get() {
        return internalState$5;
    }
    getModuleMeta(module) {
        const meta = allModulesState[module] ?? {};
        return { ...meta };
    }
    setModuleMetadata(module, metadata) {
        cache[module] = of(metadata).pipe(shareReplay(1));
        this.updateAllModulesState(module, metadata);
    }
    /**
     * Initial ListViewMeta load if not cached and update state.
     *
     * @param {string} moduleID to fetch
     * @param {string[]} types to fetch
     * @param useCache
     * @returns any data
     */
    reloadModuleMetadata(moduleID, types, useCache = true) {
        if (!types) {
            types = this.getMetadataTypes();
        }
        return this.getMetadata(moduleID, types, useCache).pipe(tap((metadata) => {
            this.updateAllModulesState(moduleID, metadata);
        }));
    }
    /**
     * Initial ListViewMeta load if not cached and update state.
     *
     * @param {string} moduleID to fetch
     * @param {string[]} types to fetch
     * @param useCache
     * @returns any data
     */
    load(moduleID, types, useCache = true) {
        if (!types) {
            types = this.getMetadataTypes();
        }
        return this.getMetadata(moduleID, types, useCache).pipe(tap((metadata) => {
            this.updateState(moduleID, metadata);
        }));
    }
    /**
     * Check if loaded
     */
    isCached(module) {
        return (cache[module] ?? null) !== null;
    }
    /**
     * Get empty Metadata
     */
    getEmpty() {
        return deepClone(initialState$h);
    }
    /**
     * Set pre-loaded navigation and cache
     */
    set(module, metadata) {
        cache[module] = of(metadata).pipe(shareReplay(1));
        this.updateState(module, metadata);
    }
    /**
     * Get ListViewMeta cached Observable or call the backend
     *
     * @param {string} module to fetch
     * @param {string[]} types to retrieve
     * @param useCache
     * @returns {object} Observable<any>
     */
    getMetadata(module, types = null, useCache = true) {
        if (cache[module] == null || useCache === false) {
            cache[module] = this.fetchMetadata(module, types).pipe(shareReplay(1));
        }
        return cache[module];
    }
    /**
     * Internal API
     */
    mapMetadata(module, data) {
        const moduleMetadata = allModulesState[module] ?? {};
        const metadata = { ...moduleMetadata };
        this.parseListViewMetadata(data, metadata);
        this.parseSearchMetadata(data, metadata);
        this.parseRecordViewMetadata(data, metadata);
        this.parseSubPanelMetadata(data, metadata);
        this.parseMassUpdateMetadata(data, metadata);
        this.parseRecentlyViewedMetadata(data, metadata);
        this.parseFavoritesMetadata(data, metadata);
        this.parseFieldViewMetada(data, metadata);
        return metadata;
    }
    /**
     * Update the state
     *
     * @param {string} module
     * @param {object} state to set
     */
    updateState(module, state) {
        this.updateAllModulesState(module, state);
        this.store.next(internalState$5 = { ...state, module });
    }
    /**
     * Update the state
     *
     * @param {string} module
     * @param {object} state to set
     */
    updateAllModulesState(module, state) {
        if (module !== '') {
            const newState = {
                ...allModulesState
            };
            newState[module] = { ...state };
            this.allModuleStore.next(allModulesState = newState);
        }
    }
    /**
     * Fetch the Metadata from the backend
     *
     * @param {string} module to fetch
     * @param {string[]} types to retrieve
     * @returns {object} Observable<{}>
     */
    fetchMetadata(module, types) {
        const fieldsToRetrieve = {
            fields: [
                ...this.fieldsMetadata.fields,
                ...(types ?? this.baseTypes)
            ]
        };
        return this.recordGQL.fetch(this.resourceName, `/api/module-metadata/${module}`, fieldsToRetrieve)
            .pipe(map(({ data }) => {
            return this.mapMetadata(module, data.moduleMetadata);
        }));
    }
    parseListViewMetadata(data, metadata) {
        if (!data || !data.listView) {
            return;
        }
        const listViewMeta = {
            fields: [],
            bulkActions: {},
            lineActions: [],
            tableActions: [],
            chartTypes: {},
            filters: []
        };
        if (data.listView.columns) {
            data.listView.columns.forEach((field) => {
                listViewMeta.fields.push(field);
            });
        }
        const entries = {
            bulkActions: 'bulkActions',
            lineActions: 'lineActions',
            tableActions: 'tableActions',
            sidebarWidgets: 'sidebarWidgets',
            availableFilters: 'filters',
            paginationType: 'paginationType'
        };
        this.addDefinedMeta(listViewMeta, data.listView, entries);
        metadata.listView = listViewMeta;
    }
    parseFieldViewMetada(data, metadata) {
        if (!data || !data.recordView || !data.recordView.panels) {
            return;
        }
        const fieldActions = {
            recordView: {}
        };
        data.recordView.panels.forEach(panel => {
            if (panel.rows) {
                panel.rows.forEach(row => {
                    if (row.cols) {
                        row.cols.forEach(col => {
                            if (col.fieldActions && col.fieldActions.actions) {
                                Object.values(col.fieldActions.actions).forEach(action => {
                                    action['fieldName'] = col.name;
                                    const viewFieldActions = fieldActions['recordView'][col.name] ?? [];
                                    viewFieldActions.push(action);
                                    fieldActions['recordView'][col.name] = viewFieldActions;
                                });
                            }
                        });
                    }
                });
            }
        });
        metadata.fieldActions = fieldActions;
    }
    parseSearchMetadata(data, metadata) {
        if (data && data.search) {
            metadata.search = data.search;
        }
    }
    parseSubPanelMetadata(data, metadata) {
        if (data && data.subPanel) {
            metadata.subPanel = data.subPanel;
        }
    }
    parseMassUpdateMetadata(data, metadata) {
        if (data && data.massUpdate) {
            metadata.massUpdate = data.massUpdate;
        }
    }
    parseRecordViewMetadata(data, metadata) {
        if (!data || !data.recordView) {
            return;
        }
        const recordViewMeta = {
            actions: [],
            templateMeta: {},
            panels: []
        };
        const receivedMeta = data.recordView;
        const entries = {
            templateMeta: 'templateMeta',
            actions: 'actions',
            panels: 'panels',
            topWidget: 'topWidget',
            sidebarWidgets: 'sidebarWidgets',
            bottomWidgets: 'bottomWidgets',
            summaryTemplates: 'summaryTemplates',
            vardefs: 'vardefs',
            metadata: 'metadata'
        };
        this.addDefinedMeta(recordViewMeta, receivedMeta, entries);
        metadata.recordView = recordViewMeta;
    }
    parseRecentlyViewedMetadata(data, metadata) {
        if (data && data.recentlyViewed) {
            metadata.recentlyViewed = data.recentlyViewed;
        }
    }
    parseFavoritesMetadata(data, metadata) {
        if (data && data.favorites) {
            metadata.favorites = data.favorites;
        }
    }
    addDefinedMeta(metadata, received, keyMap) {
        Object.keys(keyMap).forEach(dataKey => {
            const metadataKey = keyMap[dataKey];
            if (received[dataKey]) {
                metadata[metadataKey] = received[dataKey];
            }
        });
    }
    static { this.ɵfac = function MetadataStore_Factory(t) { return new (t || MetadataStore)(i0.ɵɵinject(EntityGQL), i0.ɵɵinject(AppStateStore)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: MetadataStore, factory: MetadataStore.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MetadataStore, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], function () { return [{ type: EntityGQL }, { type: AppStateStore }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class RecordListModalStore {
    constructor(listStoreFactory, meta, preferences) {
        this.listStoreFactory = listStoreFactory;
        this.meta = meta;
        this.preferences = preferences;
        this.module = '';
        this.parentModule = '';
        this.recordList = listStoreFactory.create();
        this.loading$ = this.recordList.loading$;
        this.metadataLoadingState = new BehaviorSubject(false);
        this.linkClickedState = new BehaviorSubject(false);
        this.linkClicked$ = this.linkClickedState.asObservable();
        this.metadataLoading$ = this.metadataLoadingState.asObservable();
        this.selection$ = this.recordList.selection$;
        this.selectedCount$ = this.recordList.selectedCount$;
        this.selectedStatus$ = this.recordList.selectedStatus$;
    }
    clear() {
        this.recordList.clear();
        this.recordList = null;
    }
    clearAuthBased() {
        this.recordList.clearAuthBased();
    }
    /**
     * Initial list records load if not cached and update state.
     * Returns observable to be used in resolver if needed
     *
     * @param {string} module name
     * @param {string} parentModule
     */
    init(module, parentModule = '') {
        this.module = module;
        this.parentModule = parentModule;
        this.loadCurrentSort();
        this.metadataLoadingState.next(true);
        const meta$ = this.meta.getMetadata(module).pipe(tap(() => {
            this.metadataLoadingState.next(false);
            this.recordList.load().pipe(take(1)).subscribe();
        }));
        this.listMetadata$ = meta$.pipe(map(meta => meta.listView));
        this.searchMetadata$ = meta$.pipe(map(meta => meta.search));
        this.recordList.init(module, false, 'list_max_entries_per_modal');
        this.columns$ = this.listMetadata$.pipe(map(metadata => metadata.fields));
    }
    /**
     * Load / reload records using current pagination and criteria
     *
     * @param {boolean} useCache if to use cache
     * @returns {object} Observable<RecordList>
     */
    load(useCache = true) {
        return this.recordList.load(useCache);
    }
    /**
     * Load current sorting
     */
    loadCurrentSort() {
        if (!this.parentModule) {
            return;
        }
        const currentSort = this.loadPreference(this.parentModule, 'current-sort');
        if (!currentSort || emptyObject(currentSort)) {
            return;
        }
        this.recordList.sort = currentSort;
    }
    /**
     * Load current sorting
     */
    saveCurrentSort() {
        if (!this.parentModule) {
            return;
        }
        this.savePreference(this.parentModule, 'current-sort', this.recordList.sort);
    }
    /**
     * Emit Clicked Event
     */
    emitLinkClicked() {
        this.linkClickedState.next(true);
    }
    /**
     * Build ui user preference key
     * @param storageKey
     * @protected
     */
    getPreferenceKey(storageKey) {
        return this.module + '-record-list-modal-' + storageKey;
    }
    /**
     * Save ui user preference
     * @param module
     * @param storageKey
     * @param value
     * @protected
     */
    savePreference(module, storageKey, value) {
        this.preferences.setUi(module, this.getPreferenceKey(storageKey), value);
    }
    /**
     * Load ui user preference
     * @param parentModule
     * @param storageKey
     * @protected
     */
    loadPreference(parentModule, storageKey) {
        return this.preferences.getUi(parentModule, this.getPreferenceKey(storageKey));
    }
    static { this.ɵfac = function RecordListModalStore_Factory(t) { return new (t || RecordListModalStore)(i0.ɵɵinject(RecordListStoreFactory), i0.ɵɵinject(MetadataStore), i0.ɵɵinject(UserPreferenceStore)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: RecordListModalStore, factory: RecordListModalStore.ɵfac }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RecordListModalStore, [{
        type: Injectable
    }], function () { return [{ type: RecordListStoreFactory }, { type: MetadataStore }, { type: UserPreferenceStore }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class RecordListModalStoreFactory {
    constructor(listStoreFactory, metadataStore, preferences) {
        this.listStoreFactory = listStoreFactory;
        this.metadataStore = metadataStore;
        this.preferences = preferences;
    }
    create() {
        return new RecordListModalStore(this.listStoreFactory, this.metadataStore, this.preferences);
    }
    static { this.ɵfac = function RecordListModalStoreFactory_Factory(t) { return new (t || RecordListModalStoreFactory)(i0.ɵɵinject(RecordListStoreFactory), i0.ɵɵinject(MetadataStore), i0.ɵɵinject(UserPreferenceStore)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: RecordListModalStoreFactory, factory: RecordListModalStoreFactory.ɵfac, providedIn: 'root' }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RecordListModalStoreFactory, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], function () { return [{ type: RecordListStoreFactory }, { type: MetadataStore }, { type: UserPreferenceStore }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class MaxColumnsCalculator {
    constructor(screenSize, systemConfigStore) {
        this.screenSize = screenSize;
        this.systemConfigStore = systemConfigStore;
        this.screen = ScreenSize.Medium;
        this.maxColumns = 5;
    }
    getMaxColumns(sidebarActive$) {
        return sidebarActive$.pipe(combineLatestWith(this.screenSize.screenSize$), map(([sidebarActive, screenSize]) => {
            if (screenSize) {
                this.screen = screenSize;
            }
            return this.calculateMaxColumns(sidebarActive);
        }), distinctUntilChanged());
    }
    calculateMaxColumns(sideBar = true) {
        let sizeMap;
        sizeMap = this.systemConfigStore.getConfigValue('listview_column_limits');
        if (sideBar) {
            sizeMap = sizeMap.with_sidebar;
        }
        else {
            sizeMap = sizeMap.without_sidebar;
        }
        if (this.screen && sizeMap) {
            const maxCols = sizeMap[this.screen];
            if (maxCols) {
                this.maxColumns = maxCols;
            }
        }
        return this.maxColumns;
    }
    static { this.ɵfac = function MaxColumnsCalculator_Factory(t) { return new (t || MaxColumnsCalculator)(i0.ɵɵinject(ScreenSizeObserverService), i0.ɵɵinject(SystemConfigStore)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: MaxColumnsCalculator, factory: MaxColumnsCalculator.ɵfac }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MaxColumnsCalculator, [{
        type: Injectable
    }], function () { return [{ type: ScreenSizeObserverService }, { type: SystemConfigStore }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function RecordListModalComponent_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "scrm-label", 3);
    i0.ɵɵelementContainerEnd();
} }
function RecordListModalComponent_ng_container_3_scrm_list_filter_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-list-filter", 9);
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("config", ctx_r2.filterConfig);
} }
function RecordListModalComponent_ng_container_3_ng_container_9_scrm_loading_spinner_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-loading-spinner", 11);
} if (rf & 2) {
    i0.ɵɵproperty("overlay", true);
} }
function RecordListModalComponent_ng_container_3_ng_container_9_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, RecordListModalComponent_ng_container_3_ng_container_9_scrm_loading_spinner_1_Template, 1, 1, "scrm-loading-spinner", 10);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const loading_r5 = ctx.ngIf;
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", loading_r5);
} }
function RecordListModalComponent_ng_container_3_ng_container_11_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "scrm-button", 9);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r4 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("config", ctx_r4.buildSelectButton());
} }
function RecordListModalComponent_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "div")(2, "div", 4)(3, "div", 5)(4, "div", 6);
    i0.ɵɵtemplate(5, RecordListModalComponent_ng_container_3_scrm_list_filter_5_Template, 1, 1, "scrm-list-filter", 7);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(6, "div", 8)(7, "div", 6);
    i0.ɵɵelement(8, "scrm-table", 9);
    i0.ɵɵelementEnd()()();
    i0.ɵɵtemplate(9, RecordListModalComponent_ng_container_3_ng_container_9_Template, 2, 1, "ng-container", 2);
    i0.ɵɵpipe(10, "async");
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(11, RecordListModalComponent_ng_container_3_ng_container_11_Template, 2, 1, "ng-container", 2);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(5);
    i0.ɵɵproperty("ngIf", ctx_r1.filterConfig);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("config", ctx_r1.tableConfig);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", i0.ɵɵpipeBind1(10, 4, ctx_r1.loading$));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r1.multiSelect);
} }
class RecordListModalComponent {
    constructor(activeModal, storeFactory, languages, maxColumnCalculator, preferences, systemConfigs) {
        this.activeModal = activeModal;
        this.storeFactory = storeFactory;
        this.languages = languages;
        this.maxColumnCalculator = maxColumnCalculator;
        this.preferences = preferences;
        this.systemConfigs = systemConfigs;
        this.titleKey = '';
        this.multiSelect = false;
        this.multiSelectButtonLabel = 'LBL_SAVE';
        this.adapter = null;
        this.filterAdapter = null;
        this.subs = [];
        this.store = this.storeFactory.create();
    }
    ngOnInit() {
        this.closeButton = {
            klass: ['btn', 'btn-outline-light', 'btn-sm'],
            onClick: () => {
                this.activeModal.close({
                    type: 'close-button'
                });
            }
        };
        this.init();
    }
    ngOnDestroy() {
        this.subs.forEach(sub => sub.unsubscribe());
    }
    init() {
        if (!this.module) {
            return;
        }
        this.initStore();
        this.initTableAdapter();
        this.initFilterAdapters();
    }
    getMaxColumns() {
        return this.maxColumnCalculator.getMaxColumns(of(true));
    }
    linkSelectedRecords() {
        this.activeModal.close({
            selection: this.store.recordList.selection,
            records: this.store.recordList.records
        });
    }
    buildSelectButton() {
        return {
            klass: ['btn', 'btn-primary', 'btn-sm'],
            onClick: () => {
                this.linkSelectedRecords();
            },
            labelKey: this.multiSelectButtonLabel
        };
    }
    initTableAdapter() {
        if (this.adapter === null) {
            this.adapter = new ModalRecordListTableAdapter(this.systemConfigs, this.preferences);
        }
        this.tableConfig = this.adapter.getTable(this.store, this.multiSelect);
        if (this.store?.listMetadata?.maxHeight) {
            this.tableConfig.maxListHeight = this.store.listMetadata.maxHeight;
        }
        if (!this.tableConfig?.maxListHeight) {
            const ui = this.systemConfigs.getConfigValue('ui') ?? {};
            const configModalHeight = this.systemConfigs.getConfigValue('record_modal_max_height') ?? '';
            this.tableConfig.maxListHeight = ui.record_modal_max_height ?? configModalHeight;
        }
        this.tableConfig.maxColumns$ = this.getMaxColumns();
    }
    initFilterAdapters() {
        if (this.filterAdapter === null) {
            this.filterAdapter = new ModalRecordFilterAdapter();
        }
        this.filterConfig = this.filterAdapter.getConfig(this.store);
    }
    initStore() {
        this.store.init(this.module, this.parentModule ?? '');
        this.loading$ = this.store.metadataLoading$;
        this.subs.push(this.store.linkClicked$.pipe(distinctUntilChanged(), skip(1)).subscribe(clicked => {
            if (!clicked) {
                return;
            }
            this.linkSelectedRecords();
        }));
    }
    static { this.ɵfac = function RecordListModalComponent_Factory(t) { return new (t || RecordListModalComponent)(i0.ɵɵdirectiveInject(i3$1.NgbActiveModal), i0.ɵɵdirectiveInject(RecordListModalStoreFactory), i0.ɵɵdirectiveInject(LanguageStore), i0.ɵɵdirectiveInject(MaxColumnsCalculator), i0.ɵɵdirectiveInject(UserPreferenceStore), i0.ɵɵdirectiveInject(SystemConfigStore)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: RecordListModalComponent, selectors: [["scrm-record-list-modal"]], inputs: { titleKey: "titleKey", module: "module", parentModule: "parentModule", multiSelect: "multiSelect", multiSelectButtonLabel: "multiSelectButtonLabel", adapter: "adapter", filterAdapter: "filterAdapter" }, features: [i0.ɵɵProvidersFeature([MaxColumnsCalculator])], decls: 4, vars: 5, consts: [["bodyKlass", "m-0 small-font", "footerKlass", "border-0", "headerKlass", "border-0", "klass", "record-list-modal", 3, "closable", "close", "title"], ["modal-body", ""], [4, "ngIf"], ["labelKey", "LBL_CONFIG_NO_CONFIG"], [1, "container-fluid"], [1, "row", "pb-3"], [1, "col"], [3, "config", 4, "ngIf"], [1, "row"], [3, "config"], [3, "overlay", 4, "ngIf"], [3, "overlay"]], template: function RecordListModalComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "scrm-modal", 0)(1, "div", 1);
            i0.ɵɵtemplate(2, RecordListModalComponent_ng_container_2_Template, 2, 0, "ng-container", 2);
            i0.ɵɵtemplate(3, RecordListModalComponent_ng_container_3_Template, 12, 6, "ng-container", 2);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵproperty("closable", true)("close", ctx.closeButton)("title", ctx.titleKey);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngIf", !ctx.tableConfig);
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.tableConfig);
        } }, encapsulation: 2, data: { animation: [
                trigger('modalFade', [
                    transition('void <=> *', [
                        animate('800ms')
                    ]),
                ]),
            ] } }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RecordListModalComponent, [{
        type: Component,
        args: [{ selector: 'scrm-record-list-modal', providers: [MaxColumnsCalculator], animations: [
                    trigger('modalFade', [
                        transition('void <=> *', [
                            animate('800ms')
                        ]),
                    ]),
                ], template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<scrm-modal [closable]=\"true\"\n            [close]=\"closeButton\"\n            [title]=\"titleKey\"\n            bodyKlass=\"m-0 small-font\"\n            footerKlass=\"border-0\"\n            headerKlass=\"border-0\"\n            klass=\"record-list-modal\">\n\n    <div modal-body>\n\n        <ng-container *ngIf=\"!tableConfig\">\n            <scrm-label labelKey=\"LBL_CONFIG_NO_CONFIG\"></scrm-label>\n        </ng-container>\n\n        <ng-container *ngIf=\"tableConfig\">\n            <div>\n                <div class=\"container-fluid\">\n                    <div class=\"row pb-3\">\n                        <div class=\"col\">\n                            <scrm-list-filter *ngIf=\"filterConfig\" [config]=\"filterConfig\"></scrm-list-filter>\n                        </div>\n                    </div>\n                    <div class=\"row\">\n                        <div class=\"col\">\n                            <scrm-table [config]=\"tableConfig\">\n                            </scrm-table>\n                        </div>\n                    </div>\n                </div>\n\n                <ng-container *ngIf=\"(loading$ | async) as loading\">\n                    <scrm-loading-spinner *ngIf=\"loading\" [overlay]=\"true\"></scrm-loading-spinner>\n                </ng-container>\n            </div>\n            <ng-container *ngIf=\"multiSelect\">\n                    <scrm-button [config]=\"buildSelectButton()\"></scrm-button>\n            </ng-container>\n        </ng-container>\n    </div>\n</scrm-modal>\n" }]
    }], function () { return [{ type: i3$1.NgbActiveModal }, { type: RecordListModalStoreFactory }, { type: LanguageStore }, { type: MaxColumnsCalculator }, { type: UserPreferenceStore }, { type: SystemConfigStore }]; }, { titleKey: [{
            type: Input
        }], module: [{
            type: Input
        }], parentModule: [{
            type: Input
        }], multiSelect: [{
            type: Input
        }], multiSelectButtonLabel: [{
            type: Input
        }], adapter: [{
            type: Input
        }], filterAdapter: [{
            type: Input
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class RelateService {
    constructor(recordListStoreFactory) {
        this.recordList = recordListStoreFactory.create();
    }
    init(module) {
        this.recordList.init(module, false);
    }
    search(term, field) {
        const criteria = this.recordList.criteria;
        criteria.filters[field] = {
            field,
            operator: '=',
            values: [term]
        };
        this.recordList.updateSearchCriteria(criteria, false);
        return this.recordList.load(false).pipe(map(value => value.records), take(1), shareReplay(1));
    }
    static { this.ɵfac = function RelateService_Factory(t) { return new (t || RelateService)(i0.ɵɵinject(RecordListStoreFactory)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: RelateService, factory: RelateService.ɵfac }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RelateService, [{
        type: Injectable
    }], function () { return [{ type: RecordListStoreFactory }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class BaseRelateComponent extends BaseFieldComponent {
    constructor(languages, typeFormatter, relateService, moduleNameMapper, logic, logicDisplay) {
        super(typeFormatter, logic, logicDisplay);
        this.languages = languages;
        this.typeFormatter = typeFormatter;
        this.relateService = relateService;
        this.moduleNameMapper = moduleNameMapper;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
        this.selectedValues = [];
        this.options = [];
        this.status = '';
        this.initModule = '';
        this.search = (text) => {
            if (text === '') {
                return of([]);
            }
            this.status = 'searching';
            return this.relateService.search(text, this.getRelateFieldName()).pipe(tap(() => this.status = 'found'), catchError(() => {
                this.status = 'error';
                return of([]);
            }), map(records => {
                if (!records || records.length < 1) {
                    this.status = 'not-found';
                    return [];
                }
                const flatRecords = [];
                records.forEach((record) => {
                    if (record && record.attributes) {
                        flatRecords.push(record.attributes);
                    }
                });
                this.status = '';
                return flatRecords;
            }));
        };
    }
    get module() {
        if (!this.record || !this.record.module) {
            return null;
        }
        return this.record.module;
    }
    ngOnInit() {
        super.ngOnInit();
        this.init();
        this.subs.push(this.field.valueChanges$.subscribe(() => {
            this.onModuleChange();
        }));
    }
    ngOnDestroy() {
        this.subs.forEach(sub => sub.unsubscribe());
    }
    onModuleChange() {
        const currentModule = this.initModule;
        const newModule = this?.field?.definition?.module ?? '';
        if (currentModule === newModule) {
            return;
        }
        this.initModule = newModule;
        if (currentModule === '' && currentModule !== newModule) {
            this.init();
        }
        if (newModule === '') {
            this.status = 'no-module';
        }
        else {
            this.init();
            this.status = '';
            this.selectedValues = [];
            this.options = [];
        }
    }
    getRelateFieldName() {
        if (!this.field?.definition?.metadata?.relateSearchField) {
            return (this.field && this.field.definition && this.field.definition.rname) || 'name';
        }
        return this.field.definition.metadata.relateSearchField;
    }
    getRelateIdField() {
        return (this.field && this.field.definition && this.field.definition.id_name) || '';
    }
    getRelatedModule() {
        const legacyName = (this.field && this.field.definition && this.field.definition.module) || '';
        if (!legacyName) {
            return '';
        }
        return this.moduleNameMapper.toFrontend(legacyName);
    }
    getMessage() {
        const messages = {
            searching: 'LBL_SEARCHING',
            'not-found': 'LBL_NOT_FOUND',
            error: 'LBL_SEARCH_ERROR',
            found: 'LBL_FOUND',
            'no-module': 'LBL_NO_MODULE_SELECTED'
        };
        if (messages[this.status]) {
            return messages[this.status];
        }
        return '';
    }
    getInvalidClass() {
        if (this.validateOnlyOnSubmit ? this.isInvalid() : (this.field.formControl.invalid && this.field.formControl.touched)) {
            return 'is-invalid';
        }
        if (this.hasSearchError()) {
            return 'is-invalid';
        }
        return '';
    }
    hasSearchError() {
        return this.status === 'error' || this.status === 'not-found';
    }
    resetStatus() {
        this.status = '';
    }
    getPlaceholderLabel() {
        return this.languages.getAppString('LBL_TYPE_TO_SEARCH') || '';
    }
    init() {
        this.initModule = this?.field?.definition?.module ?? '';
        if (this.relateService) {
            this.relateService.init(this.getRelatedModule());
        }
    }
    buildRelate(id, relateValue) {
        const relate = { id };
        if (this.getRelateFieldName()) {
            relate[this.getRelateFieldName()] = relateValue;
        }
        return relate;
    }
    static { this.ɵfac = function BaseRelateComponent_Factory(t) { return new (t || BaseRelateComponent)(i0.ɵɵdirectiveInject(LanguageStore), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(RelateService), i0.ɵɵdirectiveInject(ModuleNameMapper), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: BaseRelateComponent, selectors: [["ng-component"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 0, vars: 0, template: function BaseRelateComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseRelateComponent, [{
        type: Component,
        args: [{ template: '' }]
    }], function () { return [{ type: LanguageStore }, { type: DataTypeFormatter }, { type: RelateService }, { type: ModuleNameMapper }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
const _c0$D = ["tag"];
const _c1$d = ["dropdownFilterInput"];
function RelateEditFieldComponent_ng_container_1_ng_template_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 8);
} }
function RelateEditFieldComponent_ng_container_1_ng_template_5_Template(rf, ctx) { if (rf & 1) {
    const _r8 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 9);
    i0.ɵɵlistener("click", function RelateEditFieldComponent_ng_container_1_ng_template_5_Template_div_click_0_listener($event) { return $event.stopPropagation(); });
    i0.ɵɵelementStart(1, "input", 10, 11);
    i0.ɵɵlistener("ngModelChange", function RelateEditFieldComponent_ng_container_1_ng_template_5_Template_input_ngModelChange_1_listener($event) { i0.ɵɵrestoreView(_r8); const ctx_r7 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r7.filterValue = $event); })("keyup", function RelateEditFieldComponent_ng_container_1_ng_template_5_Template_input_keyup_1_listener($event) { i0.ɵɵrestoreView(_r8); const ctx_r9 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r9.onFilterInput($event)); });
    i0.ɵɵelementEnd();
    i0.ɵɵelement(3, "scrm-image", 12);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r3 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngModel", ctx_r3.filterValue);
} }
function RelateEditFieldComponent_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    const _r11 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "div", 2)(2, "p-dropdown", 3, 4);
    i0.ɵɵlistener("ngModelChange", function RelateEditFieldComponent_ng_container_1_Template_p_dropdown_ngModelChange_2_listener($event) { i0.ɵɵrestoreView(_r11); const ctx_r10 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r10.selectedValue = $event); })("onChange", function RelateEditFieldComponent_ng_container_1_Template_p_dropdown_onChange_2_listener($event) { i0.ɵɵrestoreView(_r11); const ctx_r12 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r12.onAdd($event.value)); })("onLazyLoad", function RelateEditFieldComponent_ng_container_1_Template_p_dropdown_onLazyLoad_2_listener() { i0.ɵɵrestoreView(_r11); const ctx_r13 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r13.onFilter()); })("onShow", function RelateEditFieldComponent_ng_container_1_Template_p_dropdown_onShow_2_listener() { i0.ɵɵrestoreView(_r11); const ctx_r14 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r14.focusFilterInput()); })("onHide", function RelateEditFieldComponent_ng_container_1_Template_p_dropdown_onHide_2_listener() { i0.ɵɵrestoreView(_r11); const _r1 = i0.ɵɵreference(3); const ctx_r15 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r15.resetFunction(_r1.options)); })("onClear", function RelateEditFieldComponent_ng_container_1_Template_p_dropdown_onClear_2_listener($event) { i0.ɵɵrestoreView(_r11); const ctx_r16 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r16.onClear($event)); });
    i0.ɵɵtemplate(4, RelateEditFieldComponent_ng_container_1_ng_template_4_Template, 1, 0, "ng-template", 5);
    i0.ɵɵtemplate(5, RelateEditFieldComponent_ng_container_1_ng_template_5_Template, 4, 1, "ng-template", 6);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(6, "div");
    i0.ɵɵelement(7, "scrm-button", 7);
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("options", ctx_r0.options)("ngModel", ctx_r0.selectedValue)("optionLabel", ctx_r0.getRelateFieldName())("emptyMessage", ctx_r0.emptyFilterLabel)("emptyFilterMessage", ctx_r0.emptyFilterLabel)("placeholder", ctx_r0.placeholderLabel)("autoOptionFocus", false)("autofocusFilter", false)("focusOnHover", true)("filter", true)("lazy", true)("dataKey", "id")("filterBy", ctx_r0.getRelateFieldName())("showClear", true)("styleClass", "w-100 " + ctx_r0.getInvalidClass());
    i0.ɵɵadvance(5);
    i0.ɵɵproperty("config", ctx_r0.selectButton);
} }
class RelateEditFieldComponent extends BaseRelateComponent {
    /**
     * Constructor
     *
     * @param {object} languages service
     * @param {object} typeFormatter service
     * @param {object} relateService service
     * @param {object} moduleNameMapper service
     * @param {object} modalService service
     * @param {object} logic
     * @param {object} logicDisplay
     */
    constructor(languages, typeFormatter, relateService, moduleNameMapper, modalService, logic, logicDisplay) {
        super(languages, typeFormatter, relateService, moduleNameMapper, logic, logicDisplay);
        this.languages = languages;
        this.typeFormatter = typeFormatter;
        this.relateService = relateService;
        this.moduleNameMapper = moduleNameMapper;
        this.modalService = modalService;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
        this.selectedValue = {};
        this.placeholderLabel = '';
        this.emptyFilterLabel = '';
        this.filterValue = '';
    }
    /**
     * On init handler
     */
    ngOnInit() {
        super.ngOnInit();
        this.init();
        this.getTranslatedLabels();
        this.selectButton = {
            klass: ['btn', 'btn-sm', 'btn-outline-secondary', 'm-0', 'border-0'],
            onClick: () => {
                this.showSelectModal();
            },
            icon: 'cursor'
        };
    }
    init() {
        super.init();
        this.initValue();
        const idFieldName = this.getRelateIdField();
        if (idFieldName && this.record && this.record.fields && this.record.fields[idFieldName]) {
            this.idField = this.record.fields[idFieldName];
        }
    }
    initValue() {
        if (!this.field.valueObject) {
            this.selectedValue = {};
            this.field.formControl.setValue('');
            return;
        }
        if (!this.field.valueObject.id) {
            this.selectedValue = {};
            this.field.formControl.setValue('');
            return;
        }
        if (this.field?.metadata?.relateSearchField) {
            const rname = this.field?.definition?.rname ?? 'name';
            this.field.valueObject[this.field.metadata.relateSearchField] = this.field.valueObject[rname];
        }
        this.selectedValue = this.field.valueObject;
        this.options = [this.field.valueObject];
    }
    /**
     * Handle newly added item
     *
     * @param {object} item added
     */
    onAdd(item) {
        if (item) {
            const relateName = this.getRelateFieldName();
            this.setValue(item.id, item[relateName]);
            return;
        }
        this.setValue('', '');
        this.selectedValue = {};
        return;
    }
    /**
     * Handle item removal
     */
    onRemove() {
        this.setValue('', '');
        this.selectedValue = {};
        this.options = [];
    }
    onClear(event) {
        this.selectedValue = {};
        this.filterValue = '';
        this.options = [];
        this.onRemove();
    }
    onFilter() {
        const relateName = this.getRelateFieldName();
        this.filterValue = this.filterValue ?? '';
        const matches = this.filterValue.match(/^\s*$/g);
        if (matches && matches.length) {
            this.filterValue = '';
        }
        let term = this.filterValue;
        this.search(term).pipe(take(1), map(data => data.filter(item => item[relateName] !== '')), map(filteredData => filteredData.map(item => ({
            id: item.id,
            [relateName]: item[relateName]
        })))).subscribe(filteredOptions => {
            this.options = filteredOptions;
            if (!this?.selectedValue || !this?.selectedValue?.id) {
                return;
            }
            let found = false;
            filteredOptions.some(value => {
                if (value?.id === this.selectedValue.id) {
                    found = true;
                    return true;
                }
                return false;
            });
            if (found === false && this.selectedValue) {
                this.options.push(this.selectedValue);
            }
        });
    }
    resetFunction(options) {
        this.filterValue = '';
        this.options = [];
        if (!emptyObject(this.selectedValue)) {
            this.options = [this.selectedValue];
        }
    }
    onFilterInput(event) {
        event.stopPropagation();
        this.tag.onLazyLoad.emit();
    }
    /**
     * Set value on field
     *
     * @param {string} id to set
     * @param {string} relateValue to set
     */
    setValue(id, relateValue) {
        const relate = this.buildRelate(id, relateValue);
        this.field.value = relateValue;
        this.field.valueObject = relate;
        this.field.formControl.setValue(relateValue);
        this.field.formControl.markAsDirty();
        if (this.idField) {
            this.idField.value = id;
            this.idField.formControl.setValue(id);
            this.idField.formControl.markAsDirty();
        }
        if (relateValue) {
            const relateName = this.getRelateFieldName();
            this.selectedValue = { id: id, [relateName]: relateValue };
        }
        this.options = [this.selectedValue];
    }
    /**
     * Show record selection modal
     */
    showSelectModal() {
        const modal = this.modalService.open(RecordListModalComponent, { size: 'xl', scrollable: true });
        modal.componentInstance.module = this.getRelatedModule();
        modal.result.then((data) => {
            if (!data || !data.selection || !data.selection.selected) {
                return;
            }
            const record = this.getSelectedRecord(data);
            this.setItem(record);
        });
    }
    /**
     * Get Selected Record
     *
     * @param {object} data RecordListModalResult
     * @returns {object} Record
     */
    getSelectedRecord(data) {
        let id = '';
        Object.keys(data.selection.selected).some(selected => {
            id = selected;
            return true;
        });
        let record = null;
        data.records.some(rec => {
            if (rec && rec.id === id) {
                record = rec;
                return true;
            }
        });
        return record;
    }
    /**
     * Set the record as the selected item
     *
     * @param {object} record to set
     */
    setItem(record) {
        this.tag.writeValue(record.attributes);
        this.onAdd(record.attributes);
    }
    getTranslatedLabels() {
        this.placeholderLabel = this.languages.getAppString('LBL_SELECT_ITEM') || '';
        this.emptyFilterLabel = this.languages.getAppString('ERR_SEARCH_NO_RESULTS') || '';
    }
    focusFilterInput() {
        this.dropdownFilterInput.nativeElement.focus();
    }
    static { this.ɵfac = function RelateEditFieldComponent_Factory(t) { return new (t || RelateEditFieldComponent)(i0.ɵɵdirectiveInject(LanguageStore), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(RelateService), i0.ɵɵdirectiveInject(ModuleNameMapper), i0.ɵɵdirectiveInject(i3$1.NgbModal), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: RelateEditFieldComponent, selectors: [["scrm-relate-edit"]], viewQuery: function RelateEditFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0$D, 5);
            i0.ɵɵviewQuery(_c1$d, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.tag = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dropdownFilterInput = _t.first);
        } }, features: [i0.ɵɵProvidersFeature([RelateService]), i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 1, consts: [[1, "d-flex", "align-items-center"], [4, "ngIf"], [1, "flex-grow-1", "w-100", "mr-1"], [3, "options", "ngModel", "optionLabel", "emptyMessage", "emptyFilterMessage", "placeholder", "autoOptionFocus", "autofocusFilter", "focusOnHover", "filter", "lazy", "dataKey", "filterBy", "showClear", "styleClass", "ngModelChange", "onChange", "onLazyLoad", "onShow", "onHide", "onClear"], ["tag", ""], ["pTemplate", "dropdownicon"], ["pTemplate", "filter"], [3, "config"], ["image", "down_carret"], [1, "p-dropdown-filter-container", 3, "click"], ["type", "text", "pInputText", "", "autocomplete", "off", "tabindex", "0", 1, "p-dropdown-filter", "p-component", 3, "ngModel", "ngModelChange", "keyup"], ["dropdownFilterInput", ""], ["image", "search", 1, "p-element", "p-dropdown-filter-search-icon"]], template: function RelateEditFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵtemplate(1, RelateEditFieldComponent_ng_container_1_Template, 8, 16, "ng-container", 1);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.initModule);
        } }, dependencies: [i2.NgIf, i5$1.DefaultValueAccessor, i5$1.NgControlStatus, i5$1.NgModel, ButtonComponent, i7.PrimeTemplate, ImageComponent, i13.Dropdown, i14.InputText], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RelateEditFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-relate-edit', providers: [RelateService], template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<div class=\"d-flex align-items-center\">\n    <ng-container *ngIf=\"initModule\">\n        <div class=\"flex-grow-1 w-100 mr-1\">\n            <p-dropdown\n                #tag\n                [options]=\"options\"\n                [(ngModel)]=\"selectedValue\"\n                [optionLabel]=\"getRelateFieldName()\"\n                (onChange)=\"onAdd($event.value)\"\n                (onLazyLoad)=\"onFilter()\"\n                (onShow)=\"focusFilterInput()\"\n                (onHide)=\"resetFunction(tag.options)\"\n                [emptyMessage]=\"emptyFilterLabel\"\n                [emptyFilterMessage]=\"emptyFilterLabel\"\n                [placeholder]=\"placeholderLabel\"\n                [autoOptionFocus]=\"false\"\n                [autofocusFilter]=\"false\"\n                [focusOnHover] = \"true\"\n                [filter]=\"true\"\n                [lazy]=\"true\"\n                [dataKey]=\"'id'\"\n                [filterBy]=\"getRelateFieldName()\"\n                [showClear]=\"true\"\n                (onClear)=\"onClear($event)\"\n                [styleClass]=\"'w-100 ' + getInvalidClass()\"\n            >\n                <ng-template pTemplate=\"dropdownicon\">\n                    <scrm-image image=\"down_carret\"></scrm-image>\n                </ng-template>\n                <ng-template pTemplate=\"filter\" let-options=\"options\">\n\n                    <div class=\"p-dropdown-filter-container\" (click)=\"$event.stopPropagation()\">\n                        <input #dropdownFilterInput\n                               type=\"text\"\n                               pInputText\n                               autocomplete=\"off\"\n                               class=\"p-dropdown-filter p-component\"\n                               [(ngModel)]=\"filterValue\"\n                               (keyup)=\"onFilterInput($event)\"\n                               tabindex=\"0\">\n                        <scrm-image image=\"search\" class=\"p-element p-dropdown-filter-search-icon\"></scrm-image>\n                    </div>\n\n                </ng-template>\n            </p-dropdown>\n        </div>\n        <div>\n            <scrm-button [config]=\"selectButton\">\n            </scrm-button>\n        </div>\n    </ng-container>\n</div>\n\n" }]
    }], function () { return [{ type: LanguageStore }, { type: DataTypeFormatter }, { type: RelateService }, { type: ModuleNameMapper }, { type: i3$1.NgbModal }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, { tag: [{
            type: ViewChild,
            args: ['tag']
        }], dropdownFilterInput: [{
            type: ViewChild,
            args: ['dropdownFilterInput']
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class RelateEditFieldModule {
    static { this.ɵfac = function RelateEditFieldModule_Factory(t) { return new (t || RelateEditFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: RelateEditFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            LabelModule,
            FormsModule,
            ButtonModule,
            MultiSelectModule,
            ImageModule,
            DropdownModule,
            InputTextModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RelateEditFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [RelateEditFieldComponent],
                exports: [RelateEditFieldComponent],
                imports: [
                    CommonModule,
                    LabelModule,
                    FormsModule,
                    ButtonModule,
                    MultiSelectModule,
                    ImageModule,
                    DropdownModule,
                    InputTextModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(RelateEditFieldModule, { declarations: [RelateEditFieldComponent], imports: [CommonModule,
        LabelModule,
        FormsModule,
        ButtonModule,
        MultiSelectModule,
        ImageModule,
        DropdownModule,
        InputTextModule], exports: [RelateEditFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
const _c0$C = ["tag"];
const _c1$c = ["dropdownFilterInput"];
function RelateFilterFieldComponent_ng_container_1_ng_template_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 9);
} }
function RelateFilterFieldComponent_ng_container_1_ng_template_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 10);
} }
function RelateFilterFieldComponent_ng_container_1_ng_template_6_scrm_image_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 10);
} }
function RelateFilterFieldComponent_ng_container_1_ng_template_6_Template(rf, ctx) { if (rf & 1) {
    const _r10 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 11);
    i0.ɵɵlistener("click", function RelateFilterFieldComponent_ng_container_1_ng_template_6_Template_div_click_0_listener($event) { return $event.stopPropagation(); });
    i0.ɵɵelementStart(1, "div", 12);
    i0.ɵɵelement(2, "input", 13);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "div", 14);
    i0.ɵɵlistener("click", function RelateFilterFieldComponent_ng_container_1_ng_template_6_Template_div_click_3_listener() { i0.ɵɵrestoreView(_r10); const ctx_r9 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r9.onSelectAll()); });
    i0.ɵɵtemplate(4, RelateFilterFieldComponent_ng_container_1_ng_template_6_scrm_image_4_Template, 1, 0, "scrm-image", 15);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(5, "div", 16);
    i0.ɵɵlistener("click", function RelateFilterFieldComponent_ng_container_1_ng_template_6_Template_div_click_5_listener($event) { return $event.stopPropagation(); });
    i0.ɵɵelementStart(6, "input", 17, 18);
    i0.ɵɵlistener("ngModelChange", function RelateFilterFieldComponent_ng_container_1_ng_template_6_Template_input_ngModelChange_6_listener($event) { i0.ɵɵrestoreView(_r10); const ctx_r12 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r12.filterValue = $event); })("keyup", function RelateFilterFieldComponent_ng_container_1_ng_template_6_Template_input_keyup_6_listener($event) { i0.ɵɵrestoreView(_r10); const ctx_r13 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r13.onFilterInput($event)); });
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(8, "span", 19);
    i0.ɵɵelement(9, "scrm-image", 20);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r4 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngIf", ctx_r4.selectAll);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngModel", ctx_r4.filterValue);
} }
function RelateFilterFieldComponent_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    const _r15 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "div", 2)(2, "p-multiSelect", 3, 4);
    i0.ɵɵlistener("ngModelChange", function RelateFilterFieldComponent_ng_container_1_Template_p_multiSelect_ngModelChange_2_listener($event) { i0.ɵɵrestoreView(_r15); const ctx_r14 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r14.selectedValues = $event); })("onChange", function RelateFilterFieldComponent_ng_container_1_Template_p_multiSelect_onChange_2_listener() { i0.ɵɵrestoreView(_r15); const ctx_r16 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r16.onAdd()); })("onLazyLoad", function RelateFilterFieldComponent_ng_container_1_Template_p_multiSelect_onLazyLoad_2_listener() { i0.ɵɵrestoreView(_r15); const ctx_r17 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r17.onFilter()); })("onRemove", function RelateFilterFieldComponent_ng_container_1_Template_p_multiSelect_onRemove_2_listener() { i0.ɵɵrestoreView(_r15); const ctx_r18 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r18.onRemove()); })("onPanelShow", function RelateFilterFieldComponent_ng_container_1_Template_p_multiSelect_onPanelShow_2_listener() { i0.ɵɵrestoreView(_r15); const ctx_r19 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r19.onPanelShow()); })("onPanelHide", function RelateFilterFieldComponent_ng_container_1_Template_p_multiSelect_onPanelHide_2_listener() { i0.ɵɵrestoreView(_r15); const ctx_r20 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r20.resetFunction()); })("onClear", function RelateFilterFieldComponent_ng_container_1_Template_p_multiSelect_onClear_2_listener() { i0.ɵɵrestoreView(_r15); const ctx_r21 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r21.onClear()); });
    i0.ɵɵtemplate(4, RelateFilterFieldComponent_ng_container_1_ng_template_4_Template, 1, 0, "ng-template", 5);
    i0.ɵɵtemplate(5, RelateFilterFieldComponent_ng_container_1_ng_template_5_Template, 1, 0, "ng-template", 6);
    i0.ɵɵtemplate(6, RelateFilterFieldComponent_ng_container_1_ng_template_6_Template, 10, 2, "ng-template", 7);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(7, "div");
    i0.ɵɵelement(8, "scrm-button", 8);
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("options", ctx_r0.options)("ngModel", ctx_r0.selectedValues)("optionLabel", ctx_r0.getRelateFieldName())("placeholder", ctx_r0.placeholderLabel)("selectedItemsLabel", "{0} " + ctx_r0.selectedItemsLabel)("emptyFilterMessage", ctx_r0.emptyFilterLabel)("emptyMessage", ctx_r0.emptyFilterLabel)("maxSelectedLabels", ctx_r0.maxSelectedLabels)("styleClass", "w-100 " + ctx_r0.getInvalidClass())("showToggleAll", true)("selectAll", ctx_r0.selectAll)("autoOptionFocus", false)("autofocusFilter", false)("focusOnHover", true)("showClear", true)("filter", true)("lazy", true)("dataKey", "id")("filterBy", ctx_r0.getRelateFieldName());
    i0.ɵɵadvance(6);
    i0.ɵɵproperty("config", ctx_r0.selectButton);
} }
class RelateFilterFieldComponent extends BaseRelateComponent {
    /**
     * Constructor
     *
     * @param {object} languages service
     * @param {object} typeFormatter service
     * @param {object} relateService service
     * @param {object} moduleNameMapper service
     * @param {object} modalService service
     * @param {object} logic
     * @param {object} logicDisplay
     */
    constructor(languages, typeFormatter, relateService, moduleNameMapper, modalService, logic, logicDisplay) {
        super(languages, typeFormatter, relateService, moduleNameMapper, logic, logicDisplay);
        this.languages = languages;
        this.typeFormatter = typeFormatter;
        this.relateService = relateService;
        this.moduleNameMapper = moduleNameMapper;
        this.modalService = modalService;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
        this.placeholderLabel = '';
        this.selectedItemsLabel = '';
        this.emptyFilterLabel = '';
        this.maxSelectedLabels = 20;
        this.selectAll = false;
        this.filterValue = '';
        this.selectButton = {
            klass: ['btn', 'btn-sm', 'btn-outline-secondary', 'm-0', 'border-0'],
            onClick: () => {
                this.showSelectModal();
            },
            icon: 'cursor'
        };
    }
    /**
     * On init handler
     */
    ngOnInit() {
        this.selectAll = false;
        const filter = this.record;
        this.field.valueList = [];
        this.field.valueObjectArray = [];
        let values = (this.field && this.field.criteria && this.field.criteria.values) || [];
        values = values.filter(value => !value);
        if (values.length > 0) {
            this.field.valueList = values;
        }
        let valueObjectArray = (this.field && this.field.criteria && this.field.criteria.valueObjectArray) || [];
        valueObjectArray = valueObjectArray.map(value => {
            const mapped = { ...value };
            mapped[this.getRelateFieldName()] = value[this.getRelateFieldName()] ?? value?.name ?? '';
            return mapped;
        });
        if (valueObjectArray.length > 0) {
            this.field.valueObjectArray = deepClone(valueObjectArray);
            this.selectedValues = deepClone(valueObjectArray);
        }
        super.ngOnInit();
        this.options = this.options ?? [];
        this.getTranslatedLabels();
        this.addCurrentlySelectedToOptions(this.options ?? []);
        const idFieldName = this.getRelateIdField();
        if (idFieldName && filter && filter.criteriaFields && filter.criteriaFields[idFieldName]) {
            this.idField = filter.criteriaFields[idFieldName];
            this.idField.valueList = [];
            let idValues = (this.idField && this.idField.criteria && this.idField.criteria.values) || [];
            idValues = idValues.filter(value => !!value);
            if (idValues.length > 0) {
                this.idField.valueList = deepClone(idValues);
            }
        }
    }
    /**
     * Handle newly added item
     */
    onAdd() {
        this.updateFieldValues();
        this.calculateSelectAll();
    }
    /**
     * Handle item removal
     */
    onRemove() {
        this.updateFieldValues();
        this.calculateSelectAll();
    }
    onClear() {
        this.options = [];
        this.selectedValues = [];
        this.selectAll = false;
        this.filterValue = '';
        this.onRemove();
    }
    onSelectAll() {
        this.selectAll = !this.selectAll;
        if (this.selectAll) {
            if (this.tag.visibleOptions() && this.tag.visibleOptions().length) {
                this.selectedValues = this.tag.visibleOptions();
            }
            else {
                this.selectedValues = this.options;
            }
            this.onAdd();
        }
        else {
            this.selectedValues = [];
            this.onRemove();
        }
    }
    getTranslatedLabels() {
        this.placeholderLabel = this.languages.getAppString('LBL_SELECT_ITEM') || '';
        this.selectedItemsLabel = this.languages.getAppString('LBL_ITEMS_SELECTED') || '';
        this.emptyFilterLabel = this.languages.getAppString('ERR_SEARCH_NO_RESULTS') || '';
    }
    onPanelShow() {
        this.dropdownFilterInput.nativeElement.focus();
        this.calculateSelectAll();
    }
    resetFunction() {
        this.filterValue = '';
        this.options = this.selectedValues;
    }
    onFilterInput(event) {
        event?.stopPropagation();
        this.selectAll = false;
        this.tag.onLazyLoad.emit();
    }
    onFilter() {
        const relateName = this.getRelateFieldName();
        this.filterValue = this.filterValue ?? '';
        const matches = this.filterValue.match(/^\s*$/g);
        if (matches && matches.length) {
            this.filterValue = '';
        }
        let term = this.filterValue;
        this.search(term).pipe(take(1), map(data => data.filter((item) => item[relateName] !== '')), map(filteredData => filteredData.map((item) => ({
            id: item.id,
            [relateName]: item[relateName]
        })))).subscribe(filteredOptions => {
            this.options = filteredOptions;
            this.addCurrentlySelectedToOptions(filteredOptions);
            this.calculateSelectAll();
        });
    }
    updateFieldValues() {
        let value = this?.selectedValues?.map(option => option[this.getRelateFieldName()]) ?? null;
        if (!value) {
            value = [];
        }
        this.field.valueList = value;
        this.field.valueObjectArray = deepClone(this.selectedValues ?? []);
        this.updateSearchCriteria(this.field);
        this.field.criteria.valueObjectArray = deepClone(this.field.valueObjectArray);
        this.updateIdField();
    }
    updateIdField() {
        if (!this.idField) {
            return;
        }
        this.idField.valueList = this?.selectedValues?.map(option => option.id) ?? [];
        this.updateSearchCriteria(this.idField);
    }
    /**
     * Set value on field
     *
     * @param item
     */
    setValue(item) {
        const relateName = this.getRelateFieldName();
        const id = item?.id ?? '';
        const relateValue = item[relateName];
        if (this.idField && this.idField.valueList.includes(id)) {
            return;
        }
        if (!this.idField && this.field.valueList.includes(relateValue)) {
            return;
        }
        const valueObject = {};
        valueObject.id = id;
        valueObject[relateName] = relateValue;
        this.field.valueObjectArray.push(valueObject);
        this.field.valueList.push(relateValue);
        if (this.idField) {
            this.idField.valueList.push(id);
            this.updateSearchCriteria(this.idField);
        }
        this.updateSearchCriteria(this.field);
        if (!this.field.criteria.valueObjectArray) {
            this.field.criteria.valueObjectArray = [];
        }
        this.field.criteria.valueObjectArray.push(valueObject);
    }
    /**
     * Set value on field criteria and form
     */
    updateSearchCriteria(field) {
        field.criteria.operator = '=';
        field.criteria.values = field.valueList;
        field.formControl.setValue(field.valueList);
        field.formControl.markAsDirty();
    }
    /**
     * Show record selection modal
     */
    showSelectModal() {
        const modal = this.modalService.open(RecordListModalComponent, { size: 'xl', scrollable: true });
        modal.componentInstance.module = this.getRelatedModule();
        modal.result.then((data) => {
            if (!data || !data.selection || !data.selection.selected) {
                return;
            }
            const record = this.getSelectedRecord(data);
            const found = this.field.valueObjectArray.find(element => element.id === record.id);
            if (found) {
                return;
            }
            this.setItem(record);
            this.tag.updateModel(this.selectedValues);
        });
    }
    /**
     * Get Selected Record
     *
     * @param {object} data RecordListModalResult
     * @returns {object} Record
     */
    getSelectedRecord(data) {
        let id = '';
        Object.keys(data.selection.selected).some(selected => {
            id = selected;
            return true;
        });
        let record = null;
        data.records.some(rec => {
            if (rec && rec.id === id) {
                record = rec;
                return true;
            }
        });
        return record;
    }
    /**
     * Set the record as the selected item
     *
     * @param {object} record to set
     */
    setItem(record) {
        const relateName = this.getRelateFieldName();
        const newItem = {
            id: record?.attributes?.id,
            [relateName]: record?.attributes[relateName]
        };
        const inList = this.isInList(this.selectedValues, newItem);
        if (inList) {
            return;
        }
        this.selectedValues.push(newItem);
        this.addCurrentlySelectedToOptions(this.options);
        this.onAdd();
    }
    addCurrentlySelectedToOptions(filteredOptions) {
        if (!this?.selectedValues || !this?.selectedValues.length) {
            return;
        }
        this.selectedValues.forEach(selectedValue => {
            let found = this.isInList(filteredOptions, selectedValue);
            if (found === false && selectedValue) {
                this.options.push(selectedValue);
            }
        });
    }
    isInList(filteredOptions, selectedValue) {
        let found = false;
        filteredOptions.some((value) => {
            if (value?.id === selectedValue?.id) {
                found = true;
                return true;
            }
            return false;
        });
        return found;
    }
    calculateSelectAll() {
        const visibleOptions = this?.tag?.visibleOptions() ?? [];
        const selectedValuesKeys = (this?.selectedValues ?? []).map(item => item.value);
        if (!visibleOptions.length || !selectedValuesKeys.length) {
            this.selectAll = false;
            return;
        }
        if (visibleOptions.length > selectedValuesKeys.length) {
            this.selectAll = false;
            return;
        }
        this.selectAll = visibleOptions.every(item => selectedValuesKeys.includes(item.value));
    }
    static { this.ɵfac = function RelateFilterFieldComponent_Factory(t) { return new (t || RelateFilterFieldComponent)(i0.ɵɵdirectiveInject(LanguageStore), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(RelateService), i0.ɵɵdirectiveInject(ModuleNameMapper), i0.ɵɵdirectiveInject(i3$1.NgbModal), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: RelateFilterFieldComponent, selectors: [["scrm-relate-filter"]], viewQuery: function RelateFilterFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0$C, 5);
            i0.ɵɵviewQuery(_c1$c, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.tag = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dropdownFilterInput = _t.first);
        } }, features: [i0.ɵɵProvidersFeature([RelateService]), i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 1, consts: [[1, "d-flex", "align-items-center"], [4, "ngIf"], [1, "flex-grow-1", "w-100", "mr-1"], [3, "options", "ngModel", "optionLabel", "placeholder", "selectedItemsLabel", "emptyFilterMessage", "emptyMessage", "maxSelectedLabels", "styleClass", "showToggleAll", "selectAll", "autoOptionFocus", "autofocusFilter", "focusOnHover", "showClear", "filter", "lazy", "dataKey", "filterBy", "ngModelChange", "onChange", "onLazyLoad", "onRemove", "onPanelShow", "onPanelHide", "onClear"], ["tag", ""], ["pTemplate", "dropdownicon"], ["pTemplate", "checkicon"], ["pTemplate", "filter"], [3, "config"], ["image", "down_carret"], ["image", "checkbox_cross"], [1, "p-checkbox", "p-component", 3, "click"], ["data-p-hidden-accessible", "true", 1, "p-hidden-accessible"], ["type", "checkbox", "checked", "false", "aria-label", "All items unselected"], ["role", "checkbox", "aria-checked", "false", 1, "p-checkbox-box", 3, "click"], ["image", "checkbox_cross", 4, "ngIf"], [1, "p-multiselect-filter-container", 3, "click"], ["type", "text", "pInputText", "", "autocomplete", "off", "tabindex", "0", 1, "p-multiselect-filter", "p-inputtext", "p-component", 3, "ngModel", "ngModelChange", "keyup"], ["dropdownFilterInput", ""], [1, "p-multiselect-filter-icon"], ["image", "search", 1, "p-element", "p-dropdown-filter-search-icon"]], template: function RelateFilterFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵtemplate(1, RelateFilterFieldComponent_ng_container_1_Template, 9, 20, "ng-container", 1);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.initModule);
        } }, dependencies: [i2.NgIf, i5$1.DefaultValueAccessor, i5$1.NgControlStatus, i5$1.NgModel, ButtonComponent, ImageComponent, i10.MultiSelect, i7.PrimeTemplate, i14.InputText], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RelateFilterFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-relate-filter', providers: [RelateService], template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<div class=\"d-flex align-items-center\">\n    <ng-container *ngIf=\"initModule\">\n        <div class=\"flex-grow-1 w-100 mr-1\">\n            <p-multiSelect\n                #tag\n                [options]=\"this.options\"\n                [(ngModel)]=\"selectedValues\"\n                [optionLabel]=\"getRelateFieldName()\"\n                (onChange)=\"onAdd()\"\n                (onLazyLoad)=\"onFilter()\"\n                (onRemove)=\"onRemove()\"\n                (onPanelShow)=\"onPanelShow()\"\n                (onPanelHide)=\"resetFunction()\"\n                [placeholder]=\"placeholderLabel\"\n                [selectedItemsLabel]=\"'{0} ' + selectedItemsLabel\"\n                [emptyFilterMessage]=\"emptyFilterLabel\"\n                [emptyMessage]=\"emptyFilterLabel\"\n                [maxSelectedLabels]=\"maxSelectedLabels\"\n                [styleClass]=\"'w-100 ' + getInvalidClass()\"\n                [showToggleAll]=\"true\"\n                [selectAll]=\"selectAll\"\n                [autoOptionFocus]=\"false\"\n                [autofocusFilter]=\"false\"\n                [focusOnHover]=\"true\"\n                [showClear]=\"true\"\n                (onClear)=\"onClear()\"\n                [filter]=\"true\"\n                [lazy]=\"true\"\n                [dataKey]=\"'id'\"\n                [filterBy]=\"getRelateFieldName()\"\n            >\n                <ng-template pTemplate=\"dropdownicon\">\n                    <scrm-image image=\"down_carret\"></scrm-image>\n                </ng-template>\n                <ng-template pTemplate=\"checkicon\">\n                    <scrm-image image=\"checkbox_cross\"></scrm-image>\n                </ng-template>\n\n                <ng-template pTemplate=\"filter\" let-options=\"options\">\n\n                    <div class=\"p-checkbox p-component\" (click)=\"$event.stopPropagation()\">\n                        <div class=\"p-hidden-accessible\" data-p-hidden-accessible=\"true\">\n                            <input type=\"checkbox\" checked=\"false\" aria-label=\"All items unselected\">\n                        </div>\n                        <div role=\"checkbox\" class=\"p-checkbox-box\" aria-checked=\"false\" (click)=\"onSelectAll()\">\n                            <scrm-image image=\"checkbox_cross\" *ngIf=\"selectAll\"></scrm-image>\n                        </div>\n                    </div>\n                    <div class=\"p-multiselect-filter-container\" (click)=\"$event.stopPropagation()\">\n                        <input #dropdownFilterInput\n                               type=\"text\"\n                               pInputText\n                               autocomplete=\"off\"\n                               class=\"p-multiselect-filter p-inputtext p-component\"\n                               [(ngModel)]=\"filterValue\"\n                               (keyup)=\"onFilterInput($event);\"\n                               tabindex=\"0\">\n                        <span class=\"p-multiselect-filter-icon\">\n                            <scrm-image image=\"search\" class=\"p-element p-dropdown-filter-search-icon\"></scrm-image>\n                        </span>\n                    </div>\n\n                </ng-template>\n\n\n\n            </p-multiSelect>\n        </div>\n        <div>\n            <scrm-button [config]=\"selectButton\">\n            </scrm-button>\n        </div>\n    </ng-container>\n</div>\n\n\n\n" }]
    }], function () { return [{ type: LanguageStore }, { type: DataTypeFormatter }, { type: RelateService }, { type: ModuleNameMapper }, { type: i3$1.NgbModal }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, { tag: [{
            type: ViewChild,
            args: ['tag']
        }], dropdownFilterInput: [{
            type: ViewChild,
            args: ['dropdownFilterInput']
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class TextDetailFieldModule {
    static { this.ɵfac = function TextDetailFieldModule_Factory(t) { return new (t || TextDetailFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: TextDetailFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormsModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TextDetailFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [TextDetailFieldComponent],
                exports: [TextDetailFieldComponent],
                imports: [
                    CommonModule,
                    FormsModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(TextDetailFieldModule, { declarations: [TextDetailFieldComponent], imports: [CommonModule,
        FormsModule], exports: [TextDetailFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class PhoneDetailFieldModule {
    static { this.ɵfac = function PhoneDetailFieldModule_Factory(t) { return new (t || PhoneDetailFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: PhoneDetailFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PhoneDetailFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [PhoneDetailFieldComponent],
                exports: [PhoneDetailFieldComponent],
                imports: [
                    CommonModule,
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(PhoneDetailFieldModule, { declarations: [PhoneDetailFieldComponent], imports: [CommonModule], exports: [PhoneDetailFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DateEditFieldModule {
    static { this.ɵfac = function DateEditFieldModule_Factory(t) { return new (t || DateEditFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: DateEditFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormsModule,
            NgbDatepickerModule,
            ButtonModule,
            ReactiveFormsModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateEditFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [DateEditFieldComponent],
                exports: [DateEditFieldComponent],
                imports: [
                    CommonModule,
                    FormsModule,
                    NgbDatepickerModule,
                    ButtonModule,
                    ReactiveFormsModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(DateEditFieldModule, { declarations: [DateEditFieldComponent], imports: [CommonModule,
        FormsModule,
        NgbDatepickerModule,
        ButtonModule,
        ReactiveFormsModule], exports: [DateEditFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class MultiEnumFilterFieldModule {
    static { this.ɵfac = function MultiEnumFilterFieldModule_Factory(t) { return new (t || MultiEnumFilterFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: MultiEnumFilterFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormsModule,
            ReactiveFormsModule,
            TagInputModule,
            ImageModule,
            MultiSelectModule,
            SharedModule,
            ButtonModule,
            InputTextModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MultiEnumFilterFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [MultiEnumFilterFieldComponent],
                exports: [MultiEnumFilterFieldComponent],
                imports: [
                    CommonModule,
                    FormsModule,
                    ReactiveFormsModule,
                    TagInputModule,
                    ImageModule,
                    MultiSelectModule,
                    SharedModule,
                    ButtonModule,
                    InputTextModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(MultiEnumFilterFieldModule, { declarations: [MultiEnumFilterFieldComponent], imports: [CommonModule,
        FormsModule,
        ReactiveFormsModule,
        TagInputModule,
        ImageModule,
        MultiSelectModule,
        SharedModule,
        ButtonModule,
        InputTextModule], exports: [MultiEnumFilterFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class RelateDetailFieldsModule {
    static { this.ɵfac = function RelateDetailFieldsModule_Factory(t) { return new (t || RelateDetailFieldsModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: RelateDetailFieldsModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RelateDetailFieldsModule, [{
        type: NgModule,
        args: [{
                declarations: [RelateDetailFieldComponent],
                exports: [RelateDetailFieldComponent],
                imports: [
                    CommonModule,
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(RelateDetailFieldsModule, { declarations: [RelateDetailFieldComponent], imports: [CommonModule], exports: [RelateDetailFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class RelateFilterFieldModule {
    static { this.ɵfac = function RelateFilterFieldModule_Factory(t) { return new (t || RelateFilterFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: RelateFilterFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            TagInputModule,
            LabelModule,
            FormsModule,
            InlineLoadingSpinnerModule,
            ButtonModule,
            ImageModule,
            MultiSelectModule,
            SharedModule,
            DropdownModule,
            InputTextModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RelateFilterFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [RelateFilterFieldComponent],
                exports: [RelateFilterFieldComponent],
                imports: [
                    CommonModule,
                    TagInputModule,
                    LabelModule,
                    FormsModule,
                    InlineLoadingSpinnerModule,
                    ButtonModule,
                    ImageModule,
                    MultiSelectModule,
                    SharedModule,
                    DropdownModule,
                    InputTextModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(RelateFilterFieldModule, { declarations: [RelateFilterFieldComponent], imports: [CommonModule,
        TagInputModule,
        LabelModule,
        FormsModule,
        InlineLoadingSpinnerModule,
        ButtonModule,
        ImageModule,
        MultiSelectModule,
        SharedModule,
        DropdownModule,
        InputTextModule], exports: [RelateFilterFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class BooleanEditFieldComponent extends BaseBooleanComponent {
    constructor(typeFormatter, logic, logicDisplay) {
        super(typeFormatter, logic, logicDisplay);
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    static { this.ɵfac = function BooleanEditFieldComponent_Factory(t) { return new (t || BooleanEditFieldComponent)(i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: BooleanEditFieldComponent, selectors: [["scrm-boolean-edit"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 4, vars: 1, consts: [[1, "pb-4", "checkbox-field"], [1, "checkbox-container"], ["type", "checkbox", "aria-hidden", "true", 3, "checked", "change"], [1, "checkmark"]], template: function BooleanEditFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "label", 1)(2, "input", 2);
            i0.ɵɵlistener("change", function BooleanEditFieldComponent_Template_input_change_2_listener() { return ctx.toggle(); });
            i0.ɵɵelementEnd();
            i0.ɵɵelement(3, "span", 3);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("checked", ctx.checked);
        } }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BooleanEditFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-boolean-edit', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<div class=\"pb-4 checkbox-field\">\n<label class=\"checkbox-container\">\n    <input type=\"checkbox\"\n           [checked]=\"checked\"\n           (change)=\"toggle()\"\n           aria-hidden=\"true\">\n    <span class=\"checkmark\"></span>\n</label>\n</div>\n" }]
    }], function () { return [{ type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class BooleanEditFieldModule {
    static { this.ɵfac = function BooleanEditFieldModule_Factory(t) { return new (t || BooleanEditFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: BooleanEditFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BooleanEditFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [BooleanEditFieldComponent],
                exports: [BooleanEditFieldComponent],
                imports: [
                    CommonModule,
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(BooleanEditFieldModule, { declarations: [BooleanEditFieldComponent], imports: [CommonModule], exports: [BooleanEditFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class VarcharEditFieldModule {
    static { this.ɵfac = function VarcharEditFieldModule_Factory(t) { return new (t || VarcharEditFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: VarcharEditFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormsModule,
            ReactiveFormsModule,
            LabelModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(VarcharEditFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [VarcharEditFieldComponent],
                exports: [VarcharEditFieldComponent],
                imports: [
                    CommonModule,
                    FormsModule,
                    ReactiveFormsModule,
                    LabelModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(VarcharEditFieldModule, { declarations: [VarcharEditFieldComponent], imports: [CommonModule,
        FormsModule,
        ReactiveFormsModule,
        LabelModule], exports: [VarcharEditFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class BooleanDetailFieldModule {
    static { this.ɵfac = function BooleanDetailFieldModule_Factory(t) { return new (t || BooleanDetailFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: BooleanDetailFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BooleanDetailFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [BooleanDetailFieldComponent],
                exports: [BooleanDetailFieldComponent],
                imports: [
                    CommonModule,
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(BooleanDetailFieldModule, { declarations: [BooleanDetailFieldComponent], imports: [CommonModule], exports: [BooleanDetailFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class UrlDetailFieldModule {
    static { this.ɵfac = function UrlDetailFieldModule_Factory(t) { return new (t || UrlDetailFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: UrlDetailFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(UrlDetailFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [UrlDetailFieldComponent],
                exports: [UrlDetailFieldComponent],
                imports: [
                    CommonModule,
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(UrlDetailFieldModule, { declarations: [UrlDetailFieldComponent], imports: [CommonModule], exports: [UrlDetailFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
const _c0$B = ["multiSelect"];
function MultiEnumEditFieldComponent_ng_template_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 6);
} }
function MultiEnumEditFieldComponent_ng_template_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 7);
} }
function MultiEnumEditFieldComponent_ng_template_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 8);
} }
class MultiEnumEditFieldComponent extends BaseMultiEnumComponent {
    constructor(languages, typeFormatter, logic, logicDisplay, screenSize, systemConfigStore, primengConfig) {
        super(languages, typeFormatter, logic, logicDisplay);
        this.languages = languages;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
        this.screenSize = screenSize;
        this.systemConfigStore = systemConfigStore;
        this.primengConfig = primengConfig;
        this.placeholderLabel = '';
        this.selectedItemsLabel = '';
        this.emptyFilterLabel = '';
        this.maxSelectedLabels = 20;
        this.selectAll = false;
    }
    ngOnInit() {
        this.checkAndInitAsDynamicEnum();
        this.getTranslatedLabels();
        super.ngOnInit();
        const maxSelectedLabelsForDisplay = this.systemConfigStore.getUi('multiselect_max_number');
        this.screenSize.screenSize$
            .pipe(take(1))
            .subscribe((screenSize) => {
            this.maxSelectedLabels = maxSelectedLabelsForDisplay[screenSize] || this.maxSelectedLabels;
        });
        this.primengConfig.ripple = true;
        this.clearButton = {
            klass: ['btn', 'btn-sm', 'btn-outline-secondary', 'm-0', 'border-0'],
            onClick: (event) => {
                this.onRemove();
            },
            icon: 'cross'
        };
    }
    onAdd() {
        const value = this.selectedValues.map(option => option.value);
        this.field.valueList = value;
        this.field.formControl.setValue(value);
        this.field.formControl.markAsDirty();
        this.calculateSelectAll();
    }
    onSelectAll(event) {
        this.selectAll = event.checked;
        if (this.selectAll) {
            if (this.multiSelect.visibleOptions() && this.multiSelect.visibleOptions().length) {
                this.selectedValues = this.multiSelect.visibleOptions();
            }
            else {
                this.selectedValues = this.options;
            }
            this.onAdd();
        }
        else {
            this.selectedValues = [];
            this.onRemove();
        }
    }
    onRemove() {
        const value = this.selectedValues.map(option => option.value);
        this.field.valueList = value;
        this.field.formControl.setValue(value);
        this.field.formControl.markAsDirty();
        this.calculateSelectAll();
    }
    onClear() {
        this.selectedValues = [];
        this.multiSelect.filterValue = '';
        this.onRemove();
    }
    onPanelShow() {
        this.multiSelect.filterInputChild.nativeElement.focus();
        this.multiSelect.filterValue = '';
        this.calculateSelectAll();
    }
    onFilter() {
        this.calculateSelectAll();
    }
    getTranslatedLabels() {
        this.placeholderLabel = this.languages.getAppString('LBL_SELECT_ITEM') || '';
        this.selectedItemsLabel = this.languages.getAppString('LBL_ITEMS_SELECTED') || '';
        this.emptyFilterLabel = this.languages.getAppString('ERR_SEARCH_NO_RESULTS') || '';
    }
    calculateSelectAll() {
        const visibleOptions = this?.multiSelect?.visibleOptions() ?? [];
        const selectedValuesKeys = (this?.selectedValues ?? []).map(item => item.value);
        if (!visibleOptions.length || !selectedValuesKeys.length) {
            this.selectAll = false;
            return;
        }
        if (visibleOptions.length > selectedValuesKeys.length) {
            this.selectAll = false;
            return;
        }
        this.selectAll = visibleOptions.every(item => selectedValuesKeys.includes(item.value));
    }
    static { this.ɵfac = function MultiEnumEditFieldComponent_Factory(t) { return new (t || MultiEnumEditFieldComponent)(i0.ɵɵdirectiveInject(LanguageStore), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager), i0.ɵɵdirectiveInject(ScreenSizeObserverService), i0.ɵɵdirectiveInject(SystemConfigStore), i0.ɵɵdirectiveInject(i7.PrimeNGConfig)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: MultiEnumEditFieldComponent, selectors: [["scrm-multienum-edit"]], viewQuery: function MultiEnumEditFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0$B, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.multiSelect = _t.first);
        } }, features: [i0.ɵɵInheritDefinitionFeature], decls: 6, vars: 14, consts: [[1, "d-flex", "align-items-center"], [3, "options", "ngModel", "optionLabel", "placeholder", "selectedItemsLabel", "emptyFilterMessage", "maxSelectedLabels", "styleClass", "showToggleAll", "selectAll", "autoOptionFocus", "autofocusFilter", "showClear", "focusOnHover", "ngModelChange", "onChange", "onSelectAllChange", "onRemove", "onPanelShow", "onFilter", "onClear"], ["multiSelect", ""], ["pTemplate", "dropdownicon"], ["pTemplate", "filtericon"], ["pTemplate", "checkicon"], ["image", "down_carret"], ["image", "search"], ["image", "checkbox_cross"]], template: function MultiEnumEditFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "p-multiSelect", 1, 2);
            i0.ɵɵlistener("ngModelChange", function MultiEnumEditFieldComponent_Template_p_multiSelect_ngModelChange_1_listener($event) { return ctx.selectedValues = $event; })("onChange", function MultiEnumEditFieldComponent_Template_p_multiSelect_onChange_1_listener() { return ctx.onAdd(); })("onSelectAllChange", function MultiEnumEditFieldComponent_Template_p_multiSelect_onSelectAllChange_1_listener($event) { return ctx.onSelectAll($event); })("onRemove", function MultiEnumEditFieldComponent_Template_p_multiSelect_onRemove_1_listener() { return ctx.onRemove(); })("onPanelShow", function MultiEnumEditFieldComponent_Template_p_multiSelect_onPanelShow_1_listener() { return ctx.onPanelShow(); })("onFilter", function MultiEnumEditFieldComponent_Template_p_multiSelect_onFilter_1_listener() { return ctx.onFilter(); })("onClear", function MultiEnumEditFieldComponent_Template_p_multiSelect_onClear_1_listener() { return ctx.onClear(); });
            i0.ɵɵtemplate(3, MultiEnumEditFieldComponent_ng_template_3_Template, 1, 0, "ng-template", 3);
            i0.ɵɵtemplate(4, MultiEnumEditFieldComponent_ng_template_4_Template, 1, 0, "ng-template", 4);
            i0.ɵɵtemplate(5, MultiEnumEditFieldComponent_ng_template_5_Template, 1, 0, "ng-template", 5);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("options", ctx.options)("ngModel", ctx.selectedValues)("optionLabel", "label")("placeholder", ctx.placeholderLabel)("selectedItemsLabel", "{0} " + ctx.selectedItemsLabel)("emptyFilterMessage", ctx.emptyFilterLabel)("maxSelectedLabels", ctx.maxSelectedLabels)("styleClass", "w-100 " + ctx.getInvalidClass())("showToggleAll", true)("selectAll", ctx.selectAll)("autoOptionFocus", false)("autofocusFilter", true)("showClear", true)("focusOnHover", true);
        } }, dependencies: [i5$1.NgControlStatus, i5$1.NgModel, i10.MultiSelect, i7.PrimeTemplate, ImageComponent], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MultiEnumEditFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-multienum-edit', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<div class=\"d-flex align-items-center\">\n    <p-multiSelect\n        #multiSelect\n        [options]=\"options\"\n        [(ngModel)]=\"selectedValues\"\n        [optionLabel]=\"'label'\"\n        (onChange)=\"onAdd()\"\n        (onSelectAllChange)=\"onSelectAll($event)\"\n        (onRemove)=\"onRemove()\"\n        (onPanelShow)=\"onPanelShow()\"\n        (onFilter)=\"onFilter()\"\n        [placeholder]=\"placeholderLabel\"\n        [selectedItemsLabel]=\"'{0} ' + selectedItemsLabel\"\n        [emptyFilterMessage]=\"emptyFilterLabel\"\n        [maxSelectedLabels]=\"maxSelectedLabels\"\n        [styleClass]=\"'w-100 ' + getInvalidClass()\"\n        [showToggleAll]=\"true\"\n        [selectAll]=\"selectAll\"\n        [autoOptionFocus]=\"false\"\n        [autofocusFilter]=\"true\"\n        [showClear]=\"true\"\n        (onClear)=\"onClear()\"\n        [focusOnHover]=\"true\"\n    >\n        <ng-template pTemplate=\"dropdownicon\">\n            <scrm-image image=\"down_carret\"></scrm-image>\n        </ng-template>\n        <ng-template pTemplate=\"filtericon\">\n            <scrm-image image=\"search\"></scrm-image>\n        </ng-template>\n        <ng-template pTemplate=\"checkicon\">\n            <scrm-image image=\"checkbox_cross\"></scrm-image>\n        </ng-template>\n    </p-multiSelect>\n</div>\n\n" }]
    }], function () { return [{ type: LanguageStore }, { type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }, { type: ScreenSizeObserverService }, { type: SystemConfigStore }, { type: i7.PrimeNGConfig }]; }, { multiSelect: [{
            type: ViewChild,
            args: ['multiSelect']
        }] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function IntDetailFieldComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtext(1);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate(ctx_r0.field.value);
} }
function IntDetailFieldComponent_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtext(1);
    i0.ɵɵpipe(2, "formatNumber");
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", i0.ɵɵpipeBind1(2, 1, ctx_r1.field.value), "\n");
} }
class IntDetailFieldComponent extends BaseNumberComponent {
    constructor(userPreferences, systemConfig, typeFormatter, logic, logicDisplay) {
        super(userPreferences, systemConfig, typeFormatter, logic, logicDisplay);
        this.userPreferences = userPreferences;
        this.systemConfig = systemConfig;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    static { this.ɵfac = function IntDetailFieldComponent_Factory(t) { return new (t || IntDetailFieldComponent)(i0.ɵɵdirectiveInject(UserPreferenceStore), i0.ɵɵdirectiveInject(SystemConfigStore), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: IntDetailFieldComponent, selectors: [["scrm-int-detail"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 3, vars: 4, consts: [[4, "ngIf"]], template: function IntDetailFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, IntDetailFieldComponent_ng_container_0_Template, 2, 1, "ng-container", 0);
            i0.ɵɵtemplate(1, IntDetailFieldComponent_ng_container_1_Template, 3, 3, "ng-container", 0);
            i0.ɵɵpipe(2, "async");
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", !ctx.format);
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.format && i0.ɵɵpipeBind1(2, 2, ctx.vm$));
        } }, dependencies: [i2.NgIf, i2.AsyncPipe, FormatNumberPipe], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(IntDetailFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-int-detail', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<ng-container *ngIf=\"!format\">{{ field.value }}</ng-container>\n<ng-container *ngIf=\"format && (vm$ | async) as vm\">\n    {{field.value | formatNumber}}\n</ng-container>\n" }]
    }], function () { return [{ type: UserPreferenceStore }, { type: SystemConfigStore }, { type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class MultiEnumEditFieldModule {
    static { this.ɵfac = function MultiEnumEditFieldModule_Factory(t) { return new (t || MultiEnumEditFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: MultiEnumEditFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormsModule,
            MultiSelectModule,
            ButtonModule,
            DropdownModule,
            ImageModule,
            InputTextModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MultiEnumEditFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [MultiEnumEditFieldComponent],
                exports: [MultiEnumEditFieldComponent],
                imports: [
                    CommonModule,
                    FormsModule,
                    MultiSelectModule,
                    ButtonModule,
                    DropdownModule,
                    ImageModule,
                    InputTextModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(MultiEnumEditFieldModule, { declarations: [MultiEnumEditFieldComponent], imports: [CommonModule,
        FormsModule,
        MultiSelectModule,
        ButtonModule,
        DropdownModule,
        ImageModule,
        InputTextModule], exports: [MultiEnumEditFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class IntDetailFieldModule {
    static { this.ɵfac = function IntDetailFieldModule_Factory(t) { return new (t || IntDetailFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: IntDetailFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormatNumberModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(IntDetailFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [IntDetailFieldComponent],
                exports: [IntDetailFieldComponent],
                imports: [
                    CommonModule,
                    FormatNumberModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(IntDetailFieldModule, { declarations: [IntDetailFieldComponent], imports: [CommonModule,
        FormatNumberModule], exports: [IntDetailFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class VarcharDetailFieldModule {
    static { this.ɵfac = function VarcharDetailFieldModule_Factory(t) { return new (t || VarcharDetailFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: VarcharDetailFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(VarcharDetailFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [VarcharDetailFieldComponent],
                exports: [VarcharDetailFieldComponent],
                imports: [
                    CommonModule,
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(VarcharDetailFieldModule, { declarations: [VarcharDetailFieldComponent], imports: [CommonModule], exports: [VarcharDetailFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class TextEditFieldComponent extends BaseFieldComponent {
    constructor(typeFormatter, logic, logicDisplay) {
        super(typeFormatter, logic, logicDisplay);
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    ngOnInit() {
        super.ngOnInit();
        this.subscribeValueChanges();
    }
    ngOnDestroy() {
        this.unsubscribeAll();
    }
    get rows() {
        if (this.field.metadata && this.field.metadata.rows) {
            return this.field.metadata.rows;
        }
        return 6;
    }
    get cols() {
        if (this.field.metadata && this.field.metadata.cols) {
            return this.field.metadata.cols;
        }
        return 20;
    }
    static { this.ɵfac = function TextEditFieldComponent_Factory(t) { return new (t || TextEditFieldComponent)(i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: TextEditFieldComponent, selectors: [["scrm-text-edit"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 6, consts: [[3, "rows", "cols", "ngClass", "formControl"]], template: function TextEditFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelement(0, "textarea", 0);
        } if (rf & 2) {
            i0.ɵɵclassProp("is-invalid", ctx.validateOnlyOnSubmit ? ctx.isInvalid() : ctx.field.formControl.invalid && ctx.field.formControl.touched);
            i0.ɵɵproperty("rows", ctx.rows)("cols", ctx.cols)("ngClass", ctx.klass)("formControl", ctx.field.formControl);
        } }, dependencies: [i2.NgClass, i5$1.DefaultValueAccessor, i5$1.NgControlStatus, i5$1.FormControlDirective], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TextEditFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-text-edit', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<textarea [rows]=\"rows\"\n          [cols]=\"cols\"\n          [ngClass]=\"klass\"\n          [class.is-invalid]=\"validateOnlyOnSubmit ? isInvalid() : (field.formControl.invalid && field.formControl.touched)\"\n          [formControl]=\"field.formControl\">\n</textarea>\n" }]
    }], function () { return [{ type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DateFilterFieldModule {
    static { this.ɵfac = function DateFilterFieldModule_Factory(t) { return new (t || DateFilterFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: DateFilterFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormsModule,
            NgbDatepickerModule,
            ButtonModule,
            ReactiveFormsModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateFilterFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [DateFilterFieldComponent],
                exports: [DateFilterFieldComponent],
                imports: [
                    CommonModule,
                    FormsModule,
                    NgbDatepickerModule,
                    ButtonModule,
                    ReactiveFormsModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(DateFilterFieldModule, { declarations: [DateFilterFieldComponent], imports: [CommonModule,
        FormsModule,
        NgbDatepickerModule,
        ButtonModule,
        ReactiveFormsModule], exports: [DateFilterFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class TextEditFieldModule {
    static { this.ɵfac = function TextEditFieldModule_Factory(t) { return new (t || TextEditFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: TextEditFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormsModule,
            ReactiveFormsModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TextEditFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [TextEditFieldComponent],
                exports: [TextEditFieldComponent],
                imports: [
                    CommonModule,
                    FormsModule,
                    ReactiveFormsModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(TextEditFieldModule, { declarations: [TextEditFieldComponent], imports: [CommonModule,
        FormsModule,
        ReactiveFormsModule], exports: [TextEditFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function DropdownEnumEditFieldComponent_ng_container_2_option_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 4);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const item_r2 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵclassMap(ctx_r1.getId(item_r2));
    i0.ɵɵproperty("ngValue", item_r2.value);
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", item_r2.label, " ");
} }
function DropdownEnumEditFieldComponent_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, DropdownEnumEditFieldComponent_ng_container_2_option_1_Template, 2, 5, "option", 3);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngForOf", ctx_r0.options);
} }
class DropdownEnumEditFieldComponent extends BaseEnumComponent {
    constructor(languages, typeFormatter, logic, logicDisplay) {
        super(languages, typeFormatter, logic, logicDisplay);
        this.languages = languages;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    ngOnInit() {
        this.checkAndInitAsDynamicEnum();
        super.ngOnInit();
        this.subscribeValueChanges();
    }
    getId(item) {
        return this.field.name + '-' + item.value;
    }
    static { this.ɵfac = function DropdownEnumEditFieldComponent_Factory(t) { return new (t || DropdownEnumEditFieldComponent)(i0.ɵɵdirectiveInject(LanguageStore), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: DropdownEnumEditFieldComponent, selectors: [["scrm-dropdownenum-edit"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 3, vars: 2, consts: [[1, "dropdownenum"], [1, "custom-select", "custom-select-sm", 3, "formControl"], [4, "ngIf"], [3, "class", "ngValue", 4, "ngFor", "ngForOf"], [3, "ngValue"]], template: function DropdownEnumEditFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "select", 1);
            i0.ɵɵtemplate(2, DropdownEnumEditFieldComponent_ng_container_2_Template, 2, 1, "ng-container", 2);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("formControl", ctx.field.formControl);
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.options && ctx.options.length);
        } }, dependencies: [i2.NgForOf, i2.NgIf, i5$1.NgSelectOption, i5$1.ɵNgSelectMultipleOption, i5$1.SelectControlValueAccessor, i5$1.NgControlStatus, i5$1.FormControlDirective], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DropdownEnumEditFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-dropdownenum-edit', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<div class=\"dropdownenum\">\n    <select [formControl]=\"field.formControl\" class=\"custom-select custom-select-sm\">\n        <ng-container *ngIf=\"this.options && this.options.length\">\n            <option *ngFor=\"let item of this.options;\"\n                    class=\"{{getId(item)}}\"\n                    [ngValue]=\"item.value\">\n                {{item.label}}\n            </option>\n        </ng-container>\n    </select>\n</div>\n" }]
    }], function () { return [{ type: LanguageStore }, { type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DropdownEnumEditFieldModule {
    static { this.ɵfac = function DropdownEnumEditFieldModule_Factory(t) { return new (t || DropdownEnumEditFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: DropdownEnumEditFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormsModule,
            ReactiveFormsModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DropdownEnumEditFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [DropdownEnumEditFieldComponent],
                exports: [DropdownEnumEditFieldComponent],
                imports: [
                    CommonModule,
                    FormsModule,
                    ReactiveFormsModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(DropdownEnumEditFieldModule, { declarations: [DropdownEnumEditFieldComponent], imports: [CommonModule,
        FormsModule,
        ReactiveFormsModule], exports: [DropdownEnumEditFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DropdownEnumDetailFieldComponent extends BaseEnumComponent {
    constructor(languages, typeFormatter, logic, logicDisplay) {
        super(languages, typeFormatter, logic, logicDisplay);
        this.languages = languages;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    static { this.ɵfac = function DropdownEnumDetailFieldComponent_Factory(t) { return new (t || DropdownEnumDetailFieldComponent)(i0.ɵɵdirectiveInject(LanguageStore), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: DropdownEnumDetailFieldComponent, selectors: [["scrm-dropdownenum-detail"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, template: function DropdownEnumDetailFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtext(0);
        } if (rf & 2) {
            i0.ɵɵtextInterpolate1("\n", ctx.valueLabel, "\n");
        } }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DropdownEnumDetailFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-dropdownenum-detail', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n{{valueLabel}}\n" }]
    }], function () { return [{ type: LanguageStore }, { type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class DropdownEnumDetailFieldModule {
    static { this.ɵfac = function DropdownEnumDetailFieldModule_Factory(t) { return new (t || DropdownEnumDetailFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: DropdownEnumDetailFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormsModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DropdownEnumDetailFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [DropdownEnumDetailFieldComponent],
                exports: [DropdownEnumDetailFieldComponent],
                imports: [
                    CommonModule,
                    FormsModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(DropdownEnumDetailFieldModule, { declarations: [DropdownEnumDetailFieldComponent], imports: [CommonModule,
        FormsModule], exports: [DropdownEnumDetailFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class RadioEnumDetailFieldComponent extends BaseEnumComponent {
    constructor(languages, typeFormatter, logic, logicDisplay) {
        super(languages, typeFormatter, logic, logicDisplay);
        this.languages = languages;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    static { this.ɵfac = function RadioEnumDetailFieldComponent_Factory(t) { return new (t || RadioEnumDetailFieldComponent)(i0.ɵɵdirectiveInject(LanguageStore), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: RadioEnumDetailFieldComponent, selectors: [["scrm-radioenum-detail"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, template: function RadioEnumDetailFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtext(0);
        } if (rf & 2) {
            i0.ɵɵtextInterpolate1("\n", ctx.valueLabel, "\n");
        } }, encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RadioEnumDetailFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-radioenum-detail', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n{{valueLabel}}\n" }]
    }], function () { return [{ type: LanguageStore }, { type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class RadioEnumDetailFieldModule {
    static { this.ɵfac = function RadioEnumDetailFieldModule_Factory(t) { return new (t || RadioEnumDetailFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: RadioEnumDetailFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormsModule] }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RadioEnumDetailFieldModule, [{
        type: NgModule,
        args: [{
                declarations: [RadioEnumDetailFieldComponent],
                exports: [RadioEnumDetailFieldComponent],
                imports: [
                    CommonModule,
                    FormsModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(RadioEnumDetailFieldModule, { declarations: [RadioEnumDetailFieldComponent], imports: [CommonModule,
        FormsModule], exports: [RadioEnumDetailFieldComponent] }); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
function RadioEnumEditFieldComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵelement(1, "input", 2);
    i0.ɵɵelementStart(2, "label", 3);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const item_r1 = ctx.$implicit;
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵclassMapInterpolate1("form-check radioenum-input ", ctx_r0.getId(item_r1), "");
    i0.ɵɵclassProp("form-check-inline", ctx_r0.displayDirection === "row");
    i0.ɵɵadvance(1);
    i0.ɵɵpropertyInterpolate("id", ctx_r0.getId(item_r1));
    i0.ɵɵproperty("checked", ctx_r0.field.value === item_r1.value)("formControl", ctx_r0.field.formControl)("value", item_r1.value)("name", ctx_r0.field.name);
    i0.ɵɵadvance(1);
    i0.ɵɵpropertyInterpolate("for", ctx_r0.getId(item_r1));
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate1(" ", item_r1.label, " ");
} }
class RadioEnumEditFieldComponent extends BaseEnumComponent {
    constructor(languages, typeFormatter, logic, logicDisplay) {
        super(languages, typeFormatter, logic, logicDisplay);
        this.languages = languages;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    get displayDirection() {
        if (!this.field || !this.field.definition || !this.field.definition.displayDirection) {
            return '';
        }
        return this.field.definition.displayDirection;
    }
    ngOnInit() {
        this.checkAndInitAsDynamicEnum();
        super.ngOnInit();
        this.subscribeValueChanges();
        if (this.record && this.record.formGroup) {
            this.formGroup = this.record.formGroup;
        }
        else {
            this.formGroup = new UntypedFormGroup({});
            this.formGroup.addControl(this.field.name, this.field.formControl);
        }
    }
    getId(item) {
        return this.field.name + '-' + item.value;
    }
    buildOptionsArray(appStrings) {
        this.options = [];
        Object.keys(this.optionsMap).forEach(key => {
            this.options.push({
                value: key,
                label: this.optionsMap[key]
            });
        });
        if (this.isDynamicEnum) {
            this.buildDynamicEnumOptions(appStrings);
        }
    }
    static { this.ɵfac = function RadioEnumEditFieldComponent_Factory(t) { return new (t || RadioEnumEditFieldComponent)(i0.ɵɵdirectiveInject(LanguageStore), i0.ɵɵdirectiveInject(DataTypeFormatter), i0.ɵɵdirectiveInject(FieldLogicManager), i0.ɵɵdirectiveInject(FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: RadioEnumEditFieldComponent, selectors: [["scrm-radioenum-edit"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 1, consts: [[1, "radioenum"], [3, "form-check-inline", "class", 4, "ngFor", "ngForOf"], ["type", "radio", 1, "form-check-input", 3, "checked", "formControl", "value", "name", "id"], [1, "form-check-label", 3, "for"]], template: function RadioEnumEditFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵtemplate(1, RadioEnumEditFieldComponent_div_1_Template, 4, 12, "div", 1);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngForOf", ctx.options);
        } }, dependencies: [i2.NgForOf, i5$1.DefaultValueAccessor, i5$1.RadioControlValueAccessor, i5$1.NgControlStatus, i5$1.FormControlDirective], encapsulation: 2 }); }
}
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RadioEnumEditFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-radioenum-edit', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<div class=\"radioenum\">\n    <div *ngFor=\"let item of this.options;\"\n         [class.form-check-inline]=\"displayDirection === 'row'\"\n         class=\"form-check radioenum-input {{getId(item)}}\">\n        <input [checked]=\"field.value === item.value\"\n               [formControl]=\"field.formControl\"\n               [value]=\"item.value\"\n               [name]=\"field.name\"\n               class=\"form-check-input\"\n               id=\"{{getId(item)}}\"\n               type=\"radio\"\n        />\n        <label class=\"form-check-label\"\n               for=\"{{getId(item)}}\">\n            {{item.label}}\n        </label>\n    </div>\n</div>\n" }]
    }], function () { return [{ type: LanguageStore }, { type: DataTypeFormatter }, { type: FieldLogicManager }, { type: FieldLogicDisplayManager }]; }, null); })();

/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
class RadioEnumEditFieldModule {
    static { this.ɵfac = function RadioEnumEditFieldModule_Factory(t) { return new (t || RadioEnumEditFieldModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: RadioEnumEditFieldModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
  